/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mediacreation;

import com.luna.insight.server.mediacreation.IMediaBatchProfile;
import com.luna.insight.server.mediacreation.IMediaBatchProfileResolution;
import java.io.Serializable;
import java.util.List;

public abstract class MediaBatchProfile
implements IMediaBatchProfile,
Serializable {
    static final long serialVersionUID = 2481786272834630230L;
    protected String name;
    protected String urlPrefix;
    protected String sidUrlPrefix;
    protected boolean preserveFilenames;
    protected boolean preserveDirStructure;
    protected int profileID;
    public List resolutions;

    public MediaBatchProfile(String string, int n, String string2, String string3, boolean bl, boolean bl2, List list) {
        this.name = string;
        this.urlPrefix = string2 == null ? "" : string2;
        this.sidUrlPrefix = string3 == null ? "" : string3;
        this.preserveFilenames = bl;
        this.preserveDirStructure = bl2;
        this.resolutions = list;
        this.profileID = n;
    }

    public int getProfileId() {
        return this.profileID;
    }

    public String getName() {
        return this.name;
    }

    public String getSidUrlPrefix() {
        return this.sidUrlPrefix;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setPreserveDirStructure(boolean bl) {
        this.preserveDirStructure = bl;
    }

    public boolean getPreserveDirStructure() {
        return this.preserveDirStructure;
    }

    public void setPreserveFilenames(boolean bl) {
        this.preserveFilenames = bl;
    }

    public boolean getPreserveFilenames() {
        return this.preserveFilenames;
    }

    public void setProfileName(String string) {
        this.name = string;
    }

    public void setSidUrlPrefix(String string) {
        this.sidUrlPrefix = string;
    }

    public void setUrlPrefix(String string) {
        this.urlPrefix = string;
    }

    public List getResolutions() {
        return this.resolutions;
    }

    public IMediaBatchProfileResolution getResolutionForSize(int n) {
        if (this.resolutions == null || this.resolutions.size() == 0) {
            return null;
        }
        int n2 = this.resolutions.size() - 1;
        if (n > IMediaBatchProfileResolution.PIXEL_SIZES[n2]) {
            return (IMediaBatchProfileResolution)this.resolutions.get(n2);
        }
        for (int i = n2; i > 0; --i) {
            if (n > IMediaBatchProfileResolution.PIXEL_SIZES[i] || n <= IMediaBatchProfileResolution.PIXEL_SIZES[i - 1]) continue;
            return (IMediaBatchProfileResolution)this.resolutions.get(i);
        }
        return (IMediaBatchProfileResolution)this.resolutions.get(0);
    }
}

