/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mediacreation;

import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.mediacreation.IMediaBatch;
import com.luna.insight.server.mediacreation.IMediaBatchElement;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class MediaBatchElement
implements IMediaBatchElement,
Serializable {
    static final long serialVersionUID = 6882273619517662392L;
    public static final int STATUS_NOT_STARTED = 0;
    public static final int PROCESSING = 1;
    public static final int PUBLISHING = 2;
    public static final int COMPLETE = 3;
    public static final int ERROR = 4;
    protected IMediaBatch batch;
    protected long batchElementID = -1L;
    protected int status = 0;
    protected int processingSubStatus = 0;
    protected String srcFilepath = "";
    protected String srcFilename = "";
    protected long destMediaID = -1L;
    protected String objectKey = "";
    protected String storedObjectKey = "";
    protected int storedObjectKeyFieldID = -1;
    protected int objectKeyFieldID = -1;
    protected SimpleDate processedTimestamp = null;
    protected SimpleDate lastPublishedTimestamp = null;
    protected transient ImageIcon thumbnailImage = null;
    private boolean modifiedSinceLastCommit = false;
    private boolean publishedSinceLastCommit = false;
    private boolean deleteRequested = false;

    public MediaBatchElement(IMediaBatch iMediaBatch, String string, String string2) {
        this.batch = iMediaBatch;
        this.srcFilepath = string;
        this.srcFilename = string2;
        this.objectKeyFieldID = iMediaBatch.getMappingFieldID();
        this.modifiedSinceLastCommit = true;
    }

    public MediaBatchElement(long l, int n, String string, String string2, long l2, int n2, String string3, SimpleDate simpleDate, SimpleDate simpleDate2) {
        this.batchElementID = l;
        this.status = n;
        this.srcFilepath = string == null ? "" : string;
        this.srcFilename = string2 == null ? "" : string2;
        this.destMediaID = l2;
        this.objectKeyFieldID = n2;
        this.storedObjectKeyFieldID = n2;
        this.storedObjectKey = this.objectKey = string3 == null ? "" : string3;
        this.processedTimestamp = simpleDate;
        this.lastPublishedTimestamp = simpleDate2;
    }

    public void copy(IMediaBatchElement iMediaBatchElement) {
        MediaBatchElement mediaBatchElement = (MediaBatchElement)iMediaBatchElement;
        this.batch = mediaBatchElement.batch;
        this.batchElementID = mediaBatchElement.batchElementID;
        this.status = mediaBatchElement.status;
        this.processingSubStatus = mediaBatchElement.processingSubStatus;
        this.srcFilepath = mediaBatchElement.srcFilepath;
        this.srcFilename = mediaBatchElement.srcFilename;
        this.destMediaID = mediaBatchElement.destMediaID;
        this.objectKey = mediaBatchElement.objectKey;
        this.storedObjectKey = mediaBatchElement.storedObjectKey;
        this.storedObjectKeyFieldID = mediaBatchElement.storedObjectKeyFieldID;
        this.objectKeyFieldID = mediaBatchElement.objectKeyFieldID;
        this.processedTimestamp = mediaBatchElement.processedTimestamp;
        this.lastPublishedTimestamp = mediaBatchElement.lastPublishedTimestamp;
        this.modifiedSinceLastCommit = mediaBatchElement.modifiedSinceLastCommit;
        this.publishedSinceLastCommit = mediaBatchElement.publishedSinceLastCommit;
        this.deleteRequested = mediaBatchElement.deleteRequested;
    }

    public long getDestMediaID() {
        return this.destMediaID;
    }

    public void setDestMediaID(long l) {
        if (this.destMediaID != l) {
            this.modifiedSinceLastCommit = true;
        }
        this.destMediaID = l;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        if (n != this.status) {
            this.modifiedSinceLastCommit = true;
        }
        this.status = n;
    }

    public ImageIcon getThumbnailImage() {
        return this.thumbnailImage;
    }

    public void setThumbnailImage(ImageIcon imageIcon) {
        this.thumbnailImage = imageIcon;
    }

    public String getSourceFilename() {
        return this.srcFilename;
    }

    public String getLinkIdentifier() {
        return this.objectKey;
    }

    public void setLinkIdentifier(String string) {
        this.objectKey = string == null ? this.storedObjectKey : string;
    }

    public String getSourceDirectory() {
        return this.srcFilepath;
    }

    public boolean isModifiedSinceLastCommit() {
        return this.modifiedSinceLastCommit || this.isLinkModified() || this.deleteRequested || this.publishedSinceLastCommit;
    }

    public void setModifiedSinceLastCommit(boolean bl) {
        this.modifiedSinceLastCommit = bl;
        if (!bl) {
            this.storedObjectKey = this.objectKey;
            this.storedObjectKeyFieldID = this.objectKeyFieldID;
            this.publishedSinceLastCommit = false;
            this.deleteRequested = false;
        }
    }

    public IMediaBatch getMediaBatch() {
        return this.batch;
    }

    public void setMediaBatch(IMediaBatch iMediaBatch) {
        this.batch = iMediaBatch;
    }

    public long getBatchElementID() {
        return this.batchElementID;
    }

    public void setBatchElementID(long l) {
        this.batchElementID = l;
    }

    public int getObjectKeyFieldID() {
        return this.objectKeyFieldID;
    }

    public void setObjectKeyFieldID(int n) {
        this.objectKeyFieldID = n;
    }

    public void restoreObjectKeyFieldID() {
        this.objectKeyFieldID = this.storedObjectKeyFieldID;
    }

    public SimpleDate getLastPublishedTimestamp() {
        return this.lastPublishedTimestamp;
    }

    public void setLastPublishedTimestamp(SimpleDate simpleDate) {
        this.lastPublishedTimestamp = simpleDate;
    }

    public SimpleDate getProcessedTimestamp() {
        return this.processedTimestamp;
    }

    public void setProcessedTimestamp(SimpleDate simpleDate) {
        this.processedTimestamp = simpleDate;
    }

    public boolean isPublishedSinceLastCommit() {
        return this.publishedSinceLastCommit;
    }

    public void setPublishedSinceLastCommit(boolean bl) {
        this.publishedSinceLastCommit = bl;
    }

    public boolean isLinkModified() {
        return !this.objectKey.equals(this.storedObjectKey) || this.objectKeyFieldID != this.storedObjectKeyFieldID;
    }

    public boolean isDeleteRequested() {
        return this.deleteRequested;
    }

    public void setDeleteRequested(boolean bl) {
        this.deleteRequested = bl;
    }

    public boolean linkingInfoIsComplete() {
        return (this.status == 3 || this.status == 1) && this.destMediaID != -1L && this.objectKeyFieldID != -1 && this.objectKey != null && !this.objectKey.equals("");
    }

    public int getProcessingSubStatus() {
        return this.processingSubStatus;
    }

    public void setProcessingSubStatus(int n) {
        this.processingSubStatus = n;
    }
}

