/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.core.util.CSVLogger;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.MutableLong;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.InsightTableNames;
import com.luna.insight.server.backend.JdbcConnectorError;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlColumnSelection;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.SqlTable;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.indexer.DiacriticMappings;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.indexer.TrinityIndexerField;
import com.luna.insight.server.indexer.TrinityIndexerProgressListener;
import com.luna.insight.server.indexer.TrinityJoin;
import com.luna.insight.server.indexer.TrinityTable;
import com.luna.insight.server.indexer.TrinityTermObjectToMap;
import com.luna.insight.server.indexer.TrinityTermToFilter;
import com.luna.insight.server.indexer.TrinityTermToIndex;
import com.luna.insight.server.indexer.TrinityValueObjectToMap;
import com.luna.insight.server.indexer.TrinityValueToIndex;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityField;
import com.luna.insight.server.inscribe.EntityRelationship;
import com.luna.insight.server.inscribe.EntityType;
import com.luna.insight.server.inscribe.EntityValueDetails;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class EntityIndexer
implements InsightTableNames {
    public static final String COMPONENT_NAME = "Insight Multiple Entity (v" + InsightVersion.version() + ") Database Indexer";
    public static final String COMPONENT_CODE = "IDX";
    public static final String BUILD_DATE = "20Nov2009";
    public static final int DEFAULT_DEBUG_LEVEL = 3;
    public static final String PROPS_FILE = "InsightTrinityIndexer.dat";
    public static final String PADDER = "                          ";
    public static final long PROGRESS_DISPLAY_DELAY = 200L;
    public static String DEFAULT_DATE_FORMAT_STRING = "yyyy-MM-dd hh:mm:ss.S";
    public static int DEFAULT_QUERY_MODE = 0;
    public static int DEFAULT_OBJ_ENTITY_TYPE_ID = 1;
    public static Integer uniqueCollectionID = null;
    public static boolean doFileLoad = false;
    public static boolean doFullIndex = false;
    public static boolean doValueIndex = false;
    public static boolean doTermIndex = false;
    public static boolean force = false;
    public static boolean doHierarchyIndex = false;
    public static boolean doFlatObjectDataBrowser = false;
    public static int maxChars = 30;
    public static boolean updateLiveCaches = false;
    public static boolean convertFuzzyDates = false;
    public static boolean generateMultipageDocuments = false;
    public static boolean clearTempTablesOnExit = true;
    public static final String DEFAULT_LOADFILE_NAME = "Idx";
    public static final String DEFAULT_LOADFILE_EXTENSION = ".txt";
    public static final String DEFAULT_LOADFILE_ENDOFRECORD = "]|#";
    public static final boolean GATHER_SQL_COMMANDS = false;
    protected int debugLevel = 3;
    protected static long startTime;
    protected static long timeSpent;
    protected long lastTime;
    protected long maxValueID = 1L;
    protected long maxTermID = 1L;
    protected String connectString;
    protected Properties properties;
    protected TrinityTable[] tables;
    protected TrinityIndexerField[] fields;
    protected TrinityJoin[] joins;
    protected String[] stopList;
    protected EntityType[] entityTypes;
    protected EntityField[] entityFields;
    protected EntityRelationship[] entityRelations;
    protected int objEntityTypeID = DEFAULT_OBJ_ENTITY_TYPE_ID;
    protected String elapsedTime;
    protected String remainingTime;
    protected DiacriticMappings dcMappings;
    protected long incrementalLastTime = 400L;
    protected int queryMode = DEFAULT_QUERY_MODE;
    protected String globalEscapeDelimiter = null;
    protected String unicodeFieldPrefix = null;
    protected SqlQueryGenerator sqlQueryGeneratorUtil = this.getQueryGenerator();
    protected DatabaseConnectorGenerator dbConnectorGenerator;
    protected SqlBatchController sqlBatchController = null;
    protected TrinityIndexerProgressListener progressListener = null;
    protected boolean indexCancelled = false;
    protected String loadFilePathname = null;
    protected String loadFilename_VALUES = null;
    protected String loadFilename_VTE_MAP = null;
    protected String loadFilename_TERMS = null;
    protected String loadFilename_TTE_MAP = null;
    protected DataOutputStream dos_VALUES = null;
    protected DataOutputStream dos_VTE_MAP = null;
    protected DataOutputStream dos_TERMS = null;
    protected DataOutputStream dos_TTE_MAP = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        if (stringArray.length >= 1) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase("-uid") || stringArray[n2].equalsIgnoreCase("-uniquecollectionid")) {
                    if (++n2 >= stringArray.length) continue;
                    try {
                        n = Integer.parseInt(stringArray[n2]);
                        ++n2;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-h") || stringArray[n2].equalsIgnoreCase("-hierarchy")) {
                    ++n2;
                    doHierarchyIndex = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-a") || stringArray[n2].equalsIgnoreCase("-all")) {
                    ++n2;
                    doFullIndex = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-v") || stringArray[n2].equalsIgnoreCase("-values")) {
                    ++n2;
                    doValueIndex = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-t") || stringArray[n2].equalsIgnoreCase("-terms")) {
                    ++n2;
                    doTermIndex = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-f") || stringArray[n2].equalsIgnoreCase("-force")) {
                    ++n2;
                    force = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-stt") || stringArray[n2].equalsIgnoreCase("-savetemptables")) {
                    ++n2;
                    clearTempTablesOnExit = false;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-b") || stringArray[n2].equalsIgnoreCase("-bulk")) {
                    ++n2;
                    doFileLoad = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-u") || stringArray[n2].equalsIgnoreCase("-updatecaches")) {
                    ++n2;
                    updateLiveCaches = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-fd") || stringArray[n2].equalsIgnoreCase("-fuzzydates")) {
                    ++n2;
                    convertFuzzyDates = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-mpd") || stringArray[n2].equalsIgnoreCase("-mpdgen")) {
                    ++n2;
                    generateMultipageDocuments = true;
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-flatobjbrow")) {
                    doFlatObjectDataBrowser = true;
                    if (++n2 >= stringArray.length) continue;
                    try {
                        maxChars = Integer.parseInt(stringArray[n2]);
                        ++n2;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (stringArray[n2].equalsIgnoreCase("-?") || stringArray[n2].equalsIgnoreCase("-help") || stringArray[n2].equalsIgnoreCase("/?")) {
                    ++n2;
                    System.out.println("Switches: \n   -uid <id>  OR   -uniquecollectionid <id> : Unique Collection Identifier.\n                                              Example: -uid 1\n                                              Run without -uid to see a list of collections\n   -a    OR   -all                : Re-index entire database.\n   -b    OR   -bulk               : Create files to bulk load into the database.\n   -v    OR   -values             : Re-index the values.\n   -t    OR   -terms              : Re-index the terms.\n   -f    OR   -force              : Do not prompt about overwriting old tables.\n   -stt  OR   -savetemptables     : Save (do not clear) the temp tables on exit.\n   -h    OR   -hierarchy          : Index hierarchies.\n   -u    OR   -updatecaches       : Update the caches on live collection server.\n   -fd   OR   -fuzzydates         : Index fuzzy dates.\n   -mpd  OR   -mpdgen             : Generate multipage documents.\n   -flatobjbrow     [maxChars]    : Populate flat object data for Browser.\n   -?    OR   /?                  : Show this help message.");
                    System.exit(-1);
                    continue;
                }
                ++n2;
            }
        }
        System.out.println("\n" + COMPONENT_NAME + "\nBuild of " + BUILD_DATE + "\n");
        if (n <= 0) {
            System.out.println("\n\n Unique Collection ID is not specified.  Use -help for the usage options\n\n");
        }
        uniqueCollectionID = new Integer(n);
        EntityIndexer entityIndexer = new EntityIndexer();
        if (n <= 0) {
            System.out.println("\n\nERROR. Indexer Failed.");
            System.out.println("\n\n Unique Collection ID is not specified.  Use -help for the usage options\n\n");
            System.out.println(" Options for uniquecollectionid:\n");
            object = entityIndexer.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = entityIndexer.getQueryGenerator();
                sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
                sqlQueryGenerator.addOrderBy("IRCOLLECTIONCONFIGURATIONINFO", "UniqueCollectionID");
                object.setQuery(sqlQueryGenerator.getQuery());
                object.runQuery();
                while (object.more()) {
                    System.out.println("-uid " + object.getIntegerField("UniqueCollectionID") + ": " + object.getFieldByName("CollectionName") + " [" + object.getFieldByName("InstitutionID") + "-" + object.getFieldByName("CollectionID") + "-" + object.getFieldByName("VCID") + "]");
                    object.next();
                }
                System.out.println("\n\n");
            }
            catch (Exception exception) {
                EntityIndexer.debugOut("Exception in getting list of Unique Collection ID:\n" + InsightUtilities.getStackTrace(exception));
            }
            finally {
                object.close();
            }
            System.exit(0);
        }
        entityIndexer.go();
        if (doHierarchyIndex || doFlatObjectDataBrowser || updateLiveCaches || convertFuzzyDates || generateMultipageDocuments) {
            object = new TrinityIndexer(new Integer(n), doFileLoad, false, false, false, doHierarchyIndex, force, doFlatObjectDataBrowser, maxChars, updateLiveCaches, convertFuzzyDates, generateMultipageDocuments, clearTempTablesOnExit);
            ((TrinityIndexer)object).go();
        }
    }

    public static void debugOut(String string) {
        EntityIndexer.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IDX: " + string, n);
    }

    public static void debugOutStay(String string) {
        EntityIndexer.debugOutStay(string, 3);
    }

    public static void debugOutStay(String string, int n) {
        Debug.debugOutStay("IDX: " + string + "\r", n);
    }

    public static void clearDebugOutStay() {
        Debug.debugOutStay("                                                                               \r", 3);
    }

    public static String getPadderSubstring(int n) {
        if (n < PADDER.length()) {
            return PADDER.substring(n);
        }
        return "";
    }

    public static int getRecordCount(DatabaseConnector databaseConnector, String string) {
        int n = 0;
        if (databaseConnector != null) {
            try {
                databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(string, "ValueCount"));
                EntityIndexer.debugOut("Count field value query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                n = databaseConnector.getIntegerField("ValueCount");
            }
            catch (Exception exception) {
                n = 0;
                EntityIndexer.debugOut("Exception getting record count:\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return n;
    }

    public static void registerValue(Map map, String string, boolean bl, long l, boolean bl2, String string2) {
        if (map != null && string != null) {
            String string3 = string.toLowerCase() + "-" + bl;
            TrinityValueToIndex trinityValueToIndex = (TrinityValueToIndex)map.get(string3);
            if (trinityValueToIndex == null) {
                trinityValueToIndex = new TrinityValueToIndex(string, false, bl);
                map.put(string3, trinityValueToIndex);
            }
            trinityValueToIndex.addObjectID(l, bl2, string2);
        }
    }

    public static void registerTerms(Map map, Vector vector, int n, long l, int n2, String string) {
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            EntityIndexer.registerTerm(map, (String)vector.elementAt(i), n, l, n2, string);
        }
    }

    public static void registerTerm(Map map, String string, int n, long l, int n2, String string2) {
        if (map != null && string != null && string2 != null) {
            String string3 = string;
            TrinityTermToIndex trinityTermToIndex = (TrinityTermToIndex)map.get(string3);
            if (trinityTermToIndex == null) {
                trinityTermToIndex = new TrinityTermToIndex(string);
                map.put(string3, trinityTermToIndex);
            }
            trinityTermToIndex.addEntityID(n, l, n2, string2);
        }
    }

    public static Vector parseTerms(String string, String[] stringArray) {
        return TrinityIndexer.parseTerms(string, stringArray);
    }

    public static void registerEntityMapping(Map map, Entity entity, Entity entity2, EntityValueDetails entityValueDetails) {
        if (map != null && entity != null) {
            Vector<Entity> vector = (Vector<Entity>)map.get(entity);
            if (vector == null) {
                vector = new Vector<Entity>(1);
                map.put(entity, vector);
            }
            if (entity2 != null) {
                int n = vector.indexOf(entity2);
                if (n > -1) {
                    entity2 = (Entity)vector.get(n);
                } else {
                    vector.add(entity2);
                }
                entity2.addReferenceObject(entityValueDetails);
            }
        }
    }

    public static void setRelatedEntities(Map map, Entity entity) {
        if (entity != null && map != null) {
            entity.severRelatedEntities();
            List list = (List)map.get(entity);
            if (list != null) {
                int n;
                for (n = 0; n < list.size(); ++n) {
                    entity.addRelatedEntity((Entity)list.get(n));
                }
                for (n = 0; n < list.size(); ++n) {
                    EntityIndexer.setRelatedEntities(map, (Entity)list.get(n));
                }
            }
        }
    }

    public static void getRelatedEntitySqlCommands(Integer n, Entity entity, List list, boolean bl, SqlBatchController sqlBatchController, SqlQueryGenerator sqlQueryGenerator) {
        EntityIndexer.getRelatedEntitySqlCommands(n, entity, list, "ITVALUETOENTITYMAP", bl, sqlBatchController, sqlQueryGenerator);
    }

    public static void getRelatedEntitySqlCommands(Integer n, Entity entity, List list, String string, boolean bl, SqlBatchController sqlBatchController, SqlQueryGenerator sqlQueryGenerator) {
        if (!(entity == null || entity.getRelatedEntities() == null || bl && list == null)) {
            Entity entity2 = entity.getTopmostParent();
            for (int i = 0; i < entity.getRelatedEntities().size(); ++i) {
                Entity entity3 = (Entity)entity.getRelatedEntities().get(i);
                long l = entity3.getSecondClassParentEntityID();
                for (int j = 0; entity3.getReferenceObjects() != null && j < entity3.getReferenceObjects().size(); ++j) {
                    if (!(entity3.getReferenceObjects().get(j) instanceof EntityValueDetails)) continue;
                    EntityValueDetails entityValueDetails = (EntityValueDetails)entity3.getReferenceObjects().get(j);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueID", 2, stringBuffer2, entityValueDetails.getValueID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, entity2.getEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, entity2.getEntityID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityTypeID", 2, stringBuffer2, entity3.getEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityID", 2, stringBuffer2, entity3.getEntityID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ParentEntityTypeID", 2, stringBuffer2, entity.getEntityTypeID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ParentEntityID", 2, stringBuffer2, entity.getEntityID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Preferred", 2, stringBuffer2, entityValueDetails.isPreferred() ? "1" : "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, entityValueDetails.getDisplayOrder());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Grouping", 1, stringBuffer2, l);
                    String string2 = "INSERT INTO " + string + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")";
                    if (bl) {
                        list.add(string2);
                        continue;
                    }
                    if (sqlBatchController == null) continue;
                    sqlBatchController.postSqlCommand(string2);
                }
                EntityIndexer.getRelatedEntitySqlCommands(n, entity3, list, string, bl, sqlBatchController, sqlQueryGenerator);
            }
        }
    }

    public EntityIndexer() {
        this.properties = this.loadProperties();
        this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(this.properties);
        this.connectString = this.properties.getProperty("DatabaseConnect");
        this.queryMode = Integer.parseInt(this.properties.getProperty("DatabaseQueryMode", "" + DEFAULT_QUERY_MODE));
        this.globalEscapeDelimiter = this.properties.getProperty("GlobalEscapeDelimiter");
        this.unicodeFieldPrefix = this.properties.getProperty("UnicodeFieldPrefix");
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
        DEFAULT_DATE_FORMAT_STRING = this.properties.getProperty("DateFormatString", DEFAULT_DATE_FORMAT_STRING);
        try {
            this.debugLevel = Integer.parseInt(this.properties.getProperty("DebugLevel", "3"));
            Debug.setDebugLevel(this.debugLevel);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        EntityIndexer.debugOut("");
        this.dcMappings = new DiacriticMappings();
        EntityIndexer.debugOut("");
        if (!this.dcMappings.hasMappings()) {
            EntityIndexer.debugOut("No DiacriticMappings found.");
            this.dcMappings = null;
        } else {
            EntityIndexer.debugOut("DiacriticMappings found.");
        }
        if (this.connectString == null || this.connectString.length() == 0) {
            EntityIndexer.debugOut("Connect string is empty.  Stopping.");
            System.exit(0);
        }
        int n = 100;
        try {
            n = Integer.parseInt(this.properties.getProperty("BatchSize"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
        }
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("SQL command batch size: " + n);
        EntityIndexer.debugOut("");
        this.sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), n);
        this.objEntityTypeID = this.getPreferredEntityTypeID(uniqueCollectionID);
        if (doFileLoad) {
            String string = this.loadFilePathname != null ? InsightUtilities.concatFilepath(this.loadFilePathname, DEFAULT_LOADFILE_NAME) : DEFAULT_LOADFILE_NAME;
            this.loadFilename_VALUES = string + "_VALUES" + "_UID" + uniqueCollectionID + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_VTE_MAP = string + "_VALUETOENTITYMAP" + "_UID" + uniqueCollectionID + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TERMS = string + "_TERMS" + "_UID" + uniqueCollectionID + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TTE_MAP = string + "_TERMTOENTITYMAP" + "_UID" + uniqueCollectionID + DEFAULT_LOADFILE_EXTENSION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPreferredEntityTypeID(Integer n) {
        int n2 = DEFAULT_OBJ_ENTITY_TYPE_ID;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            n2 = TrinityConnector.getPreferredEntityTypeID(n, databaseConnector, sqlQueryGenerator);
        }
        catch (Exception exception) {
            EntityIndexer.debugOut("Exception while getting \"preferred\" entity type ID:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n2;
    }

    public EntityIndexer(Integer n, boolean bl, boolean bl2, boolean bl3, String string, int n2, int n3, String string2, String string3, String string4, File file, boolean bl4, boolean bl5, int n4, String string5, DatabaseConnectorGenerator databaseConnectorGenerator) {
        uniqueCollectionID = n;
        doFileLoad = bl3;
        doFullIndex = false;
        doValueIndex = bl;
        doTermIndex = bl2;
        force = bl4;
        clearTempTablesOnExit = !bl5;
        this.loadFilePathname = string;
        this.queryMode = n3;
        this.globalEscapeDelimiter = string2;
        this.unicodeFieldPrefix = string3;
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
        DEFAULT_DATE_FORMAT_STRING = string4;
        this.dbConnectorGenerator = databaseConnectorGenerator;
        this.connectString = string5;
        try {
            this.debugLevel = n4;
            Debug.setDebugLevel(n4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        EntityIndexer.debugOut("");
        this.dcMappings = file != null ? new DiacriticMappings(file) : new DiacriticMappings();
        EntityIndexer.debugOut("");
        if (!this.dcMappings.hasMappings()) {
            EntityIndexer.debugOut("No DiacriticMappings found.");
            this.dcMappings = null;
        } else {
            EntityIndexer.debugOut("DiacriticMappings found.");
        }
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("SQL command batch size: " + n2);
        EntityIndexer.debugOut("");
        this.sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), n2);
        this.objEntityTypeID = this.getPreferredEntityTypeID(n);
        if (bl3) {
            String string6 = string != null ? InsightUtilities.concatFilepath(string, DEFAULT_LOADFILE_NAME) : DEFAULT_LOADFILE_NAME;
            this.loadFilename_VALUES = string6 + "_VALUES" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_VTE_MAP = string6 + "_VALUETOENTITYMAP" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TERMS = string6 + "_TERMS" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
            this.loadFilename_TTE_MAP = string6 + "_TERMTOENTITYMAP" + "_UID" + n + DEFAULT_LOADFILE_EXTENSION;
        }
    }

    protected DatabaseConnector getDatabaseConnector() {
        return this.dbConnectorGenerator.getConnector(this.connectString);
    }

    protected SqlQueryGenerator getQueryGenerator() {
        return new SqlQueryGenerator(this.queryMode, this.globalEscapeDelimiter, this.unicodeFieldPrefix);
    }

    protected SqlQueryGenerator getQueryGeneratorUtil() {
        return this.sqlQueryGeneratorUtil;
    }

    protected String getStringField(DatabaseConnector databaseConnector, String string) {
        String string2 = null;
        try {
            string2 = databaseConnector.getFieldByName(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "\nException:\n" + InsightUtilities.getStackTrace(exception));
        }
        return string2;
    }

    protected int getIntegerField(DatabaseConnector databaseConnector, String string) {
        int n = 0;
        try {
            n = databaseConnector.getIntegerFieldByName(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "\nException:\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    protected boolean getBooleanField(DatabaseConnector databaseConnector, String string) {
        boolean bl = false;
        try {
            bl = databaseConnector.getBooleanField(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "\nException:\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    protected long getLongField(DatabaseConnector databaseConnector, String string) {
        long l = 0L;
        try {
            l = databaseConnector.getLongField(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "\nException:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        return l;
    }

    protected Date getDateField(DatabaseConnector databaseConnector, String string) {
        Date date = null;
        try {
            date = databaseConnector.getDateFieldByName(string);
        }
        catch (Exception exception) {
            this.exitError("Could not find field \"" + string + "\" in query:\n" + databaseConnector.getQuery() + "\nException:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
        return date;
    }

    protected long numeralizeDate(String string) {
        long l = 0L;
        try {
            return InsightUtilities.numeralizeDate(string, DEFAULT_DATE_FORMAT_STRING);
        }
        catch (Exception exception) {
            this.exitError("Couldn't convert date " + string + " into millisecond value. Exception:\n" + InsightUtilities.convertStackTraceToString(exception));
            return l;
        }
    }

    public void go() {
        startTime = System.currentTimeMillis();
        boolean bl = false;
        if ((doFullIndex || doValueIndex || doTermIndex) && !this.indexCancelled) {
            try {
                EntityIndexer.debugOut("");
                EntityIndexer.debugOut("Gathering Insight Source (IS) information from database.");
                this.gatherTableData(uniqueCollectionID);
                this.gatherJoinData(uniqueCollectionID);
                this.gatherFieldData();
                this.gatherStopList();
                bl = this.gatherEntityTypes(uniqueCollectionID);
                if (bl && (doFullIndex || doValueIndex)) {
                    EntityIndexer.debugOut("Could not find source tables. Cannot perform value or term indexing");
                    this.exitError("This collection does not support value indexing");
                    return;
                }
                this.gatherEntityFields(uniqueCollectionID);
                this.gatherEntityRelationships(uniqueCollectionID);
                EntityIndexer.debugOut("");
                EntityIndexer.debugOut("Clearing out temporary indices.");
                EntityIndexer.debugOut("");
                try {
                    if (!this.indexCancelled) {
                        this.clearTemporaryTables(uniqueCollectionID);
                    }
                }
                catch (Exception exception) {
                    this.exitError("Exception while clearing temporary tables:\n" + InsightUtilities.convertStackTraceToString(exception));
                }
                EntityIndexer.debugOut("");
                EntityIndexer.debugOut("  " + this.entityTypes.length + " indexable entity types.");
                EntityIndexer.debugOut("  " + this.entityFields.length + " entity fields:");
                for (int i = 0; i < this.entityFields.length; ++i) {
                    EntityIndexer.debugOut("  Entity field " + (i < 9 ? " " : "") + (i + 1) + ": " + this.entityFields[i].getEntityType().getName() + EntityIndexer.getPadderSubstring(this.entityFields[i].getEntityType().getName().length()) + " - " + this.entityFields[i].getTrinityField().sourceName);
                }
                EntityIndexer.debugOut("");
                EntityIndexer.debugOut("Indexing.");
                EntityIndexer.debugOut("");
                if (doFullIndex) {
                    doValueIndex = true;
                    doTermIndex = true;
                } else if (doValueIndex && doTermIndex) {
                    doFullIndex = true;
                }
                if (doFullIndex && !this.indexCancelled) {
                    this.doFullIndexing(uniqueCollectionID);
                } else if (doValueIndex && !this.indexCancelled) {
                    this.doValueIndexing(uniqueCollectionID);
                } else if (doTermIndex && !this.indexCancelled) {
                    this.doTermIndexing(uniqueCollectionID, false);
                }
                this.updateTableEntityToMediaMap();
                EntityIndexer.clearDebugOutStay();
                if (!this.indexCancelled) {
                    try {
                        this.commitIndexingChanges(uniqueCollectionID);
                    }
                    catch (Exception exception) {
                        this.exitError("Exception while clearing and copying to destination tables:\n" + InsightUtilities.convertStackTraceToString(exception));
                    }
                }
                EntityIndexer.debugOut("");
                timeSpent = System.currentTimeMillis() - startTime;
                EntityIndexer.debugOut("Time spent indexing including waits: " + EntityIndexer.formatTimeString((int)(timeSpent / 1000L)));
            }
            catch (Exception exception) {
                this.exitError("Exception while Indexing:\n" + InsightUtilities.convertStackTraceToString(exception));
            }
            catch (JdbcConnectorError jdbcConnectorError) {
                EntityIndexer.debugOut("  Caught JdbcConnectorError while Indexing: " + InsightUtilities.getStackTrace(jdbcConnectorError));
                this.exitError("Caught JdbcConnectorError while Indexing:\n" + InsightUtilities.getStackTrace(jdbcConnectorError));
            }
        }
        if (this.sqlBatchController != null) {
            this.sqlBatchController.setStillNeeded(false);
        }
    }

    protected void doFullIndexing(Integer n) {
        if (!this.indexCancelled) {
            this.doValueIndexing(n);
        }
        if (!this.indexCancelled) {
            this.doTermIndexing(n, true);
        }
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("SQL command execution time: " + EntityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
    }

    protected void doValueIndexing(Integer n) {
        long l;
        long l2 = System.currentTimeMillis();
        doValueIndex = true;
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Value indexing for UID: " + n.toString());
        EntityIndexer.debugOut("");
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        BufferedOutputStream bufferedOutputStream2 = null;
        boolean bl = true;
        if (doFileLoad) {
            try {
                fileOutputStream = new FileOutputStream(this.loadFilename_VALUES);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.dos_VALUES = new DataOutputStream(bufferedOutputStream);
                fileOutputStream2 = new FileOutputStream(this.loadFilename_VTE_MAP);
                bufferedOutputStream2 = new BufferedOutputStream(fileOutputStream2);
                this.dos_VTE_MAP = new DataOutputStream(bufferedOutputStream2);
            }
            catch (IOException iOException) {
                doFileLoad = false;
                this.exitError("Exception while indexing fields:\n" + InsightUtilities.convertStackTraceToString(iOException));
            }
        }
        this.maxValueID = TrinityIndexer.getMaxValueID(this.getDatabaseConnector(), "DTVALUES");
        if (this.progressListener != null) {
            this.progressListener.setBorderTitle("Value Indexing");
            this.progressListener.setValuePb3Maximum(this.entityFields.length);
        }
        for (int i = 0; i < this.entityFields.length; ++i) {
            if (!this.indexCancelled) {
                Object object;
                if (this.progressListener != null) {
                    this.progressListener.reportTime(System.currentTimeMillis(), this.entityFields.length);
                    this.progressListener.setValuePb1Value(0);
                    this.progressListener.setValuePb1Maximum(100);
                    this.progressListener.setValuePb2Value(0);
                }
                EntityField entityField = this.entityFields[i];
                MutableLong mutableLong = new MutableLong();
                long l3 = 0L;
                int n2 = i * 100 / (this.fields.length + 1 > 0 ? this.fields.length + 1 : 1);
                int n3 = 100 / (this.fields.length + 1 > 0 ? this.fields.length + 1 : 1);
                EntityIndexer.debugOut("  Entity field: " + entityField.getEntityType().getName() + " : " + entityField.getTrinityField().sourceName);
                if (this.progressListener != null) {
                    this.progressListener.setValueIndexingFieldText("" + entityField.getTrinityField().sourceName);
                }
                TreeMap treeMap = new TreeMap();
                Collection collection = treeMap.values();
                TrinityValueToIndex trinityValueToIndex = null;
                boolean bl2 = true;
                boolean bl3 = true;
                long l4 = 0L;
                String string = "";
                String string2 = "";
                if (!this.indexCancelled) {
                    try {
                        object = this.getDatabaseConnector();
                        String string3 = this.createEntityFieldQuery(entityField);
                        EntityIndexer.clearDebugOutStay();
                        Debug.debugOutStay("  Querying field values.\r", 3);
                        l = System.currentTimeMillis();
                        l3 = EntityIndexer.getRecordCount((DatabaseConnector)object, string3);
                        EntityIndexer.debugOut("Total record count: " + l3);
                        EntityIndexer.debugOut("Time spent getting record count: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                        l = System.currentTimeMillis();
                        object = this.getDatabaseConnector();
                        object.setQuery(string3);
                        EntityIndexer.debugOut("Field query:\n" + object.getQuery());
                        object.runQuery();
                        EntityIndexer.debugOut("Time spent getting records: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                        EntityIndexer.clearDebugOutStay();
                        l = System.currentTimeMillis();
                        long l5 = 0L;
                        long l6 = 0L;
                        boolean bl4 = false;
                        while (object.more() && !this.indexCancelled) {
                            String string4;
                            long l7 = this.getLongField((DatabaseConnector)object, entityField.getEntityType().getEntityIDColumnName());
                            try {
                                bl2 = entityField.getPrefValueColumnName() == null || entityField.getPrefValueColumnName().length() == 0 || object.getIntegerFieldByName(entityField.getPrefValueColumnName()) == 1;
                            }
                            catch (Exception exception) {
                                bl2 = true;
                            }
                            String string5 = "0";
                            if (entityField.getGroupingFieldName() != null && entityField.getGroupingFieldName().length() > 0 && entityField.getGroupingTable() != null) {
                                try {
                                    string5 = object.getFieldByName(entityField.getGroupingFieldName());
                                    if (string5 == null) {
                                        string5 = "0";
                                    }
                                }
                                catch (Exception exception) {
                                    string5 = "0";
                                }
                            }
                            try {
                                string4 = object.getFieldByName(entityField.getFieldValueColumnName());
                            }
                            catch (Exception exception) {
                                string4 = null;
                            }
                            if (!(string4 == null || string4.equals(string) && l7 == l4 && string5.equals(string2))) {
                                String string6;
                                long l8;
                                long l9;
                                if (l7 != l4) {
                                    bl4 = false;
                                }
                                l4 = l7;
                                string = string4;
                                string2 = string5;
                                string4 = string4.trim();
                                if (entityField.getTrinityField().fieldType == 3) {
                                    string4 = this.numeralizeDate(string4) + "";
                                }
                                bl3 = false;
                                if (bl2) {
                                    l9 = System.currentTimeMillis();
                                    if (bl4) {
                                        EntityIndexer.debugOut("Warning: Entity " + l7 + " has more than one preferred value for this field." + "\n     Marking value \"" + string4 + "\" as not preferred.");
                                        bl2 = false;
                                    } else {
                                        bl4 = true;
                                    }
                                    l8 = System.currentTimeMillis() - l9;
                                    l5 += l8;
                                }
                                l9 = System.currentTimeMillis();
                                EntityIndexer.registerValue(treeMap, string4, true, l7, bl2, string5);
                                if (this.dcMappings != null && !string4.equals(string6 = this.dcMappings.normalize(string4))) {
                                    EntityIndexer.registerValue(treeMap, string6, false, l7, false, string5);
                                }
                                l8 = System.currentTimeMillis() - l9;
                                l6 += l8;
                            }
                            if (!this.indexCancelled) {
                                this.updateValueReadProgress(mutableLong.addToValue(1L), l3, n2, n3, 1, this.maxValueID, this.maxTermID);
                            }
                            object.next();
                        }
                        EntityIndexer.debugOut("Total time spent processing records: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                        object.close();
                        if (bl3) {
                            EntityIndexer.clearDebugOutStay();
                            EntityIndexer.debugOut("No values found for this field.");
                        }
                    }
                    catch (Exception exception) {
                        this.exitError("Exception while indexing fields:\n" + InsightUtilities.getStackTrace(exception));
                    }
                }
                l3 = 0L;
                object = collection.iterator();
                int n4 = 0;
                while (object.hasNext() && !this.indexCancelled) {
                    trinityValueToIndex = (TrinityValueToIndex)object.next();
                    l3 += (long)trinityValueToIndex.getObjectIDCount();
                    ++n4;
                }
                EntityIndexer.debugOut("Total record count: " + l3);
                mutableLong.setValue(0L);
                EntityIndexer.clearDebugOutStay();
                if (!this.indexCancelled) {
                    try {
                        l = System.currentTimeMillis();
                        object = collection.iterator();
                        n4 = 0;
                        while (object.hasNext()) {
                            trinityValueToIndex = (TrinityValueToIndex)object.next();
                            if (this.indexCancelled) break;
                            if (doFileLoad) {
                                this.writeValueToFile(n, trinityValueToIndex, entityField, mutableLong, l3, n2, n3, bl);
                                bl = false;
                            } else {
                                this.writeValue(n, trinityValueToIndex, entityField, mutableLong, l3, n2, n3);
                            }
                            ++n4;
                        }
                        EntityIndexer.debugOut("");
                        EntityIndexer.debugOut("Time spent writing values: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                    }
                    catch (Exception exception) {
                        this.exitError("Exception while indexing values:\n" + InsightUtilities.getStackTrace(exception));
                    }
                }
                treeMap = null;
                collection = null;
            }
            EntityIndexer.clearDebugOutStay();
            if (this.progressListener == null) continue;
            this.progressListener.setValuePb3Value(i + 1);
        }
        try {
            if (this.dos_VALUES != null) {
                this.dos_VALUES.close();
                this.dos_VALUES = null;
            }
            if (this.dos_VTE_MAP != null) {
                this.dos_VTE_MAP.close();
                this.dos_VTE_MAP = null;
            }
        }
        catch (IOException iOException) {
            this.exitError("Exception while indexing values:\n" + InsightUtilities.getStackTrace(iOException));
        }
        this.sqlBatchController.executeRemainingCommands();
        if (doFileLoad) {
            EntityIndexer.debugOut("Time spent in value indexing phase before file load: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("*** NOTE: Entity Relationship Indexing will start once the files have been uploaded", 1);
            EntityIndexer.debugOut("");
            this.generateLoadControlFiles(n, this.loadFilename_VALUES, this.loadFilename_VTE_MAP, null, null);
            if (!this.loadedFiles(this.loadFilename_VALUES, this.loadFilename_VTE_MAP)) {
                this.exitError("Could not upload files.");
            }
        }
        l = System.currentTimeMillis();
        this.doEntityRelIndexing(n);
        EntityIndexer.debugOut("Time spent in Entity Relationship Indexing: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
        l = System.currentTimeMillis();
        this.doEntityFlattening(n, true);
        EntityIndexer.debugOut("Time spent in Entity Flattening: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
        l = System.currentTimeMillis();
        this.updateValueToObjectMappings(n);
        EntityIndexer.debugOut("Time spent in copying value-to-entity information: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
        if (!doTermIndex) {
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("SQL command execution time: " + EntityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
        } else {
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("SQL command execution time so far: " + EntityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
        }
        if (this.progressListener != null) {
            this.progressListener.setValueIndexingFieldText("Completed");
            this.progressListener.setValuePb1Value(100);
            this.progressListener.setValuePb2Value(100);
        }
        EntityIndexer.debugOut("Time spent in value indexing phase including waits: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
    }

    protected void generateLoadControlFiles(Integer n, String string, String string2, String string3, String string4) {
        String string5 = this.loadFilePathname != null ? InsightUtilities.concatFilepath(this.loadFilePathname, DEFAULT_LOADFILE_NAME) : DEFAULT_LOADFILE_NAME;
        String string6 = null;
        String string7 = "\r\n";
        String string8 = ".cmd";
        String string9 = ".ctl";
        String string10 = "usrid";
        String string11 = "pass";
        EntityIndexer.debugOut("");
        try {
            if (string6 == null || string6.equalsIgnoreCase("Oracle")) {
                FileWriter fileWriter;
                File file;
                String string12;
                if (string != null) {
                    string12 = string5 + "_VALUES" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITVALUES data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_VALUES" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_VALUES" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITVALUES" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(UniqueCollectionID integer external," + string7 + " ValueID integer external," + string7 + " FieldID integer external," + string7 + " Enabled integer external," + string7 + " ValueNumber float external," + string7 + " ValueText char(4000) OPTIONALLY ENCLOSED BY X'22')" + string7);
                        fileWriter.close();
                    }
                }
                if (string2 != null) {
                    string12 = string5 + "_VALUETOENTITYMAP" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITVALUETOENTITYMAP data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_VALUETOENTITYMAP" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_VALUETOENTITYMAP" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string2).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITVALUETOENTITYMAP" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(UniqueCollectionID integer external," + string7 + " ValueID integer external," + string7 + " EntityTypeID integer external," + string7 + " EntityID integer external," + string7 + " RelEntityTypeID integer external," + string7 + " RelEntityID integer external," + string7 + " ParentEntityTypeID integer external," + string7 + " ParentEntityID integer external," + string7 + " DisplayOrder integer external," + string7 + " Preferred integer external," + string7 + " Grouping char(50) OPTIONALLY ENCLOSED BY X'22')" + string7);
                        fileWriter.close();
                    }
                }
                if (string3 != null) {
                    string12 = string5 + "_TERMS" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITTERMS data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_TERMS" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_TERMS" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string3).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITTERMS" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(TermID integer external," + string7 + " Keyword char(255) OPTIONALLY ENCLOSED BY X'22')" + string7);
                        fileWriter.close();
                    }
                }
                if (string4 != null) {
                    string12 = string5 + "_TERMTOENTITYMAP" + "_UID" + n + string8;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle command file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle command file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("echo Importing ITTERMTOENTITYMAP data using the Oracle SQL*Loader utility" + string7 + "sqlldr SILENT=HEADER,FEEDBACK CONTROL=" + DEFAULT_LOADFILE_NAME + "_TERMTOENTITYMAP" + "_UID" + n + string9 + " USERID=" + string10 + "/" + string11 + string7);
                        fileWriter.close();
                    }
                    string12 = string5 + "_TERMTOENTITYMAP" + "_UID" + n + string9;
                    file = new File(string12);
                    if (file.exists()) {
                        EntityIndexer.debugOut("Oracle control file already exists: " + string12);
                    } else {
                        EntityIndexer.debugOut("Generating Oracle control file: " + string12);
                        fileWriter = new FileWriter(string12);
                        fileWriter.write("-- Control file for Oracle SQL Loader" + string7 + "-- Generated by (c) Luna Imaging, Inc." + string7 + string7 + "OPTIONS(direct=false,skip=1)" + string7 + "LOAD DATA" + string7 + "INFILE '" + new File(string4).getName() + "'" + " \"str '" + DEFAULT_LOADFILE_ENDOFRECORD + "'\"" + string7 + "INTO TABLE " + "ITTERMTOENTITYMAP" + string7 + "APPEND" + string7 + "FIELDS TERMINATED BY X'09' TRAILING NULLCOLS" + string7 + "(UniqueCollectionID integer external," + string7 + " TermID integer external," + string7 + " EntityTypeID integer external," + string7 + " EntityID integer external," + string7 + " FieldID integer external," + string7 + " Grouping integer external)" + string7);
                        fileWriter.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            EntityIndexer.debugOut("Got exception creating bulk load scripts");
        }
    }

    protected boolean loadedFiles(String string, String string2) {
        int n = 110;
        int n2 = -1;
        if (!this.indexCancelled) {
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("Files ready for bulk load.\n     Files   " + string + "\n     and     " + string2 + "\n     are ready for bulk upload." + "\n     Please upload the files to the database and check whether" + "\n     the data have been successfully uploaded." + "\n\n     Have the files been successfully uploaded? (y/n)", 1);
            n = 110;
            byte[] byArray = new byte[1];
            try {
                if (this.progressListener != null) {
                    EntityIndexer.debugOut("Get answer through progressListener.");
                    this.progressListener.pauseTimer();
                    this.progressListener.pauseRemainingTimeTimer();
                    n2 = this.progressListener.showJOptionPaneConfirmDialog("Files   " + string + "\nand     " + string2 + "\nare ready for bulk upload." + "\n\nHave the files been successfully uploaded?", "upload files");
                    if (n2 == 0) {
                        this.progressListener.restartTimer();
                        this.progressListener.restartRemainingTimeTimer();
                    }
                } else {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    while ((n = (int)bufferedReader.readLine().charAt(0)) != 121 && n != 89 && n != 110 && n != 78) {
                        EntityIndexer.debugOut("Please enter y for Yes or n for No", 1);
                    }
                }
            }
            catch (Exception exception) {
                EntityIndexer.debugOut("Got exception reading answer");
            }
        }
        return n == 121 || n2 == 0;
    }

    protected void doTermIndexing(Integer n, boolean bl) {
        long l;
        doTermIndex = true;
        long l2 = System.currentTimeMillis();
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Term indexing for UID: " + n.toString());
        EntityIndexer.debugOut("");
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        BufferedOutputStream bufferedOutputStream2 = null;
        boolean bl2 = true;
        if (doFileLoad) {
            try {
                fileOutputStream = new FileOutputStream(this.loadFilename_TERMS);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.dos_TERMS = new DataOutputStream(bufferedOutputStream);
                fileOutputStream2 = new FileOutputStream(this.loadFilename_TTE_MAP);
                bufferedOutputStream2 = new BufferedOutputStream(fileOutputStream2);
                this.dos_TTE_MAP = new DataOutputStream(bufferedOutputStream2);
            }
            catch (IOException iOException) {
                doFileLoad = false;
                this.exitError("Exception while indexing fields:\n" + InsightUtilities.convertStackTraceToString(iOException));
            }
        }
        try {
            EntityField entityField = null;
            boolean bl3 = true;
            MutableLong mutableLong = new MutableLong();
            long l3 = 0L;
            MutableLong mutableLong2 = new MutableLong();
            long l4 = 0L;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            String string = bl ? "ITVALUES" : "DTVALUES";
            String string2 = bl ? "ITVALUETOENTITYMAP" : "DTVALUETOENTITYMAP";
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            this.maxTermID = TrinityIndexer.getMaxTermID(databaseConnector, "DTTERMS");
            if (this.progressListener != null) {
                this.progressListener.setBorderTitle("Term Indexing");
                this.progressListener.setTermPb3Maximum(this.entityFields.length);
            }
            for (int i = 0; i < this.entityFields.length; ++i) {
                if (this.indexCancelled) continue;
                entityField = this.entityFields[i];
                if (entityField.getTrinityField().isKeywordSearchable()) {
                    TrinityTermToIndex trinityTermToIndex;
                    int n2;
                    EntityIndexer.clearDebugOutStay();
                    EntityIndexer.debugOut("  Entity field: " + entityField.getEntityType().getName() + " : " + entityField.getTrinityField().sourceName);
                    if (this.progressListener != null) {
                        if (!this.progressListener.isTimeRemainingEstimated()) {
                            this.progressListener.reportTime(System.currentTimeMillis(), this.entityFields.length);
                        }
                        this.progressListener.setTermIndexingFieldText("" + entityField.getTrinityField().sourceName);
                        this.progressListener.setTermPb1Value(0);
                        this.progressListener.setTermPb2Value(0);
                    }
                    bl3 = true;
                    TreeMap treeMap = new TreeMap();
                    Collection collection = treeMap.values();
                    Debug.debugOutStay("  Querying terms.\r", 3);
                    sqlQueryGenerator.clear();
                    sqlQueryGenerator.addTable(string, null, "*");
                    sqlQueryGenerator.addTable(string2, null, new String[]{"EntityTypeID", "EntityID", "Grouping"});
                    sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                    sqlQueryGenerator.addJoin(string2, string, "ValueID", 0);
                    sqlQueryGenerator.addJoin(string, "IRFIELDS", new String[]{"FieldID"}, 0);
                    sqlQueryGenerator.addJoin("IRFIELDS", new String[]{"FieldType"}, "IRTYPES", new String[]{"TypeID"}, 0);
                    sqlQueryGenerator.appendToWhere(string + ".FieldID = " + entityField.getTrinityField().fieldID);
                    sqlQueryGenerator.appendToWhere(string + ".UniqueCollectionID = " + n);
                    String string3 = sqlQueryGenerator.getQuery();
                    l = System.currentTimeMillis();
                    l3 = EntityIndexer.getRecordCount(databaseConnector, string3);
                    EntityIndexer.debugOut("Term indexing: recordsToRead =" + l3);
                    mutableLong.setValue(0L);
                    databaseConnector.setQuery(string3);
                    EntityIndexer.debugOut("Terms query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    EntityIndexer.clearDebugOutStay();
                    l = System.currentTimeMillis();
                    long l5 = 0L;
                    while (databaseConnector.more()) {
                        String string4;
                        try {
                            if (this.indexCancelled) break;
                            string4 = databaseConnector.getFieldByName(TrinityConnector.getFieldValueName(databaseConnector.getFieldByName("TypeCode")));
                        }
                        catch (Exception exception) {
                            string4 = null;
                        }
                        if (string4 != null) {
                            bl3 = false;
                            string4 = string4.trim();
                            int n3 = databaseConnector.getIntegerField("EntityTypeID");
                            long l6 = databaseConnector.getLongField("EntityID");
                            String string5 = databaseConnector.getField("Grouping");
                            long l7 = System.currentTimeMillis();
                            try {
                                EntityIndexer.registerTerms(treeMap, EntityIndexer.parseTerms(string4, this.stopList), n3, l6, entityField.getFieldID(), string5);
                            }
                            catch (Exception exception) {
                                EntityIndexer.debugOut("Term indexing: Caught exception in registerTerms(): " + InsightUtilities.getStackTrace(exception));
                            }
                            long l8 = System.currentTimeMillis() - l7;
                            l5 += l8;
                        }
                        if (!this.indexCancelled) {
                            this.updateTermReadProgress(mutableLong.addToValue(1L), l3, this.maxTermID);
                        }
                        if (this.indexCancelled) break;
                        databaseConnector.next();
                    }
                    EntityIndexer.debugOut("Total time spent processing records: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                    databaseConnector.close();
                    if (bl3) {
                        EntityIndexer.clearDebugOutStay();
                        EntityIndexer.debugOut("No terms found.");
                    }
                    l4 = 0L;
                    Iterator iterator = null;
                    if (!this.indexCancelled) {
                        iterator = collection.iterator();
                        n2 = 0;
                        while (iterator.hasNext() && !this.indexCancelled) {
                            trinityTermToIndex = (TrinityTermToIndex)iterator.next();
                            l4 += (long)trinityTermToIndex.getEntityIDCount();
                            ++n2;
                        }
                        mutableLong2.setValue(0L);
                    }
                    EntityIndexer.clearDebugOutStay();
                    EntityIndexer.debugOut("Term indexing: recordsToWrite=" + l4 + "   ");
                    if (!this.indexCancelled) {
                        try {
                            l = System.currentTimeMillis();
                            iterator = collection.iterator();
                            n2 = 0;
                            while (iterator.hasNext() && !this.indexCancelled) {
                                trinityTermToIndex = (TrinityTermToIndex)iterator.next();
                                if (doFileLoad) {
                                    this.writeTermToFile(n, trinityTermToIndex, mutableLong2, l4, bl2);
                                    bl2 = false;
                                } else {
                                    this.writeTerm(n, trinityTermToIndex, mutableLong2, l4);
                                }
                                ++n2;
                            }
                            EntityIndexer.debugOut("Time spent writing terms: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
                        }
                        catch (Exception exception) {
                            this.exitError("Term indexing: Exception while writing terms to database:\n" + InsightUtilities.getStackTrace(exception));
                        }
                        catch (JdbcConnectorError jdbcConnectorError) {
                            String string6 = "";
                            Exception exception = jdbcConnectorError.getRootCause();
                            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                                string6 = "Problem: " + exception.getMessage() + "\n";
                            }
                            string6 = string6 + "Term indexing: Exception while writing terms to database:\n";
                            this.exitError(string6 + InsightUtilities.getStackTrace(exception));
                        }
                    }
                    treeMap = null;
                    collection = null;
                }
                if (this.progressListener == null) continue;
                this.progressListener.setTermPb3Value(i + 1);
            }
        }
        catch (Exception exception) {
            EntityIndexer.debugOut("Exception while indexing terms:\n" + InsightUtilities.getStackTrace(exception));
        }
        try {
            if (this.dos_TERMS != null) {
                this.dos_TERMS.close();
                this.dos_TERMS = null;
            }
            if (this.dos_TTE_MAP != null) {
                this.dos_TTE_MAP.close();
                this.dos_TTE_MAP = null;
            }
        }
        catch (IOException iOException) {
            this.exitError("Exception while indexing terms:\n" + InsightUtilities.getStackTrace(iOException));
        }
        if (doFileLoad) {
            EntityIndexer.debugOut("Time spent in term indexing phase before file load: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("*** NOTE: Term filtering will start once the files have been uploaded", 1);
            EntityIndexer.debugOut("");
            this.generateLoadControlFiles(n, null, null, this.loadFilename_TERMS, this.loadFilename_TTE_MAP);
            if (!this.loadedFiles(this.loadFilename_TERMS, this.loadFilename_TTE_MAP)) {
                this.exitError("Could not upload files.");
            }
        } else {
            EntityIndexer.debugOut("Time spent in term indexing phase before filtering terms: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
        }
        if (!this.indexCancelled) {
            EntityIndexer.debugOut("Term indexing: telling SqlBatchController to execute any remaining commands.");
            try {
                this.sqlBatchController.executeRemainingCommands();
            }
            catch (Exception exception) {
                EntityIndexer.debugOut("Term indexing: Exception executing remaining SQL commands: " + InsightUtilities.getStackTrace(exception));
            }
            l = System.currentTimeMillis();
            this.filterTerms(n);
            EntityIndexer.debugOut("Time spent filtering terms: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
            this.updateTermToObjectMappings(n);
            EntityIndexer.clearDebugOutStay();
            if (!doValueIndex) {
                EntityIndexer.debugOut("");
                EntityIndexer.debugOut("SQL command execution time: " + EntityIndexer.formatTimeString((int)(this.sqlBatchController.getExecTime() / 1000L)));
            }
        }
        if (this.progressListener != null) {
            this.progressListener.setTermIndexingFieldText("Completed");
        }
        EntityIndexer.debugOut("Time spent in term indexing phase including waits: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l2) / 1000L)));
    }

    protected void filterTerms(Integer n) {
        long l = System.currentTimeMillis();
        EntityIndexer.clearDebugOutStay();
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Filter terms.");
        if (this.progressListener != null) {
            this.progressListener.setTermIndexingFieldText("Filtering Terms");
        }
        try {
            TrinityTermToFilter trinityTermToFilter;
            boolean bl = true;
            MutableLong mutableLong = new MutableLong();
            long l2 = 0L;
            MutableLong mutableLong2 = new MutableLong();
            long l3 = 0L;
            boolean bl2 = true;
            String string = bl2 ? "ITTERMS" : "DTTERMS";
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            Debug.debugOutStay("  Querying values.\r", 3);
            sqlQueryGenerator.addTable(string, null, "*");
            sqlQueryGenerator.addOrderBy(string, "TermID");
            String string2 = sqlQueryGenerator.getQuery();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            l2 = EntityIndexer.getRecordCount(databaseConnector, string2);
            TreeMap<String, TrinityTermToFilter> treeMap = new TreeMap<String, TrinityTermToFilter>();
            databaseConnector.setQuery(string2);
            databaseConnector.runQuery();
            EntityIndexer.clearDebugOutStay();
            while (databaseConnector.more() && !this.indexCancelled) {
                String string3;
                try {
                    string3 = databaseConnector.getFieldByName("Keyword");
                }
                catch (Exception exception) {
                    string3 = null;
                }
                if (string3 != null) {
                    bl = false;
                    string3 = string3.trim();
                    String string4 = string3.toLowerCase();
                    int n2 = databaseConnector.getIntegerField("TermID");
                    trinityTermToFilter = (TrinityTermToFilter)treeMap.get(string4);
                    if (trinityTermToFilter == null) {
                        trinityTermToFilter = new TrinityTermToFilter(n2, string3);
                        treeMap.put(string4, trinityTermToFilter);
                    } else {
                        trinityTermToFilter.addDupeTermID(n2);
                    }
                }
                this.updateTermReadProgress(mutableLong.addToValue(1L), l2, this.maxTermID);
                databaseConnector.next();
            }
            databaseConnector.close();
            if (bl) {
                EntityIndexer.clearDebugOutStay();
                EntityIndexer.debugOut("No terms found.");
            }
            l3 = 0L;
            Iterator iterator = treeMap.values().iterator();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (iterator.hasNext() && !this.indexCancelled) {
                trinityTermToFilter = (TrinityTermToFilter)iterator.next();
                n3 = trinityTermToFilter.getDupeTermIDCount();
                if (n3 > 0) {
                    n4 += n3;
                    l3 += (long)n3;
                    l3 += (long)n3;
                }
                ++n5;
            }
            EntityIndexer.debugOut("Time spent in term filtering phase before executing update commands: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l) / 1000L)));
            EntityIndexer.debugOut("Filter terms: dupeCount     =" + n4 + "          ");
            EntityIndexer.debugOut("Filter terms: recordsToWrite=" + l3 + "          ");
            mutableLong2.setValue(0L);
            EntityIndexer.clearDebugOutStay();
            try {
                long l4 = System.currentTimeMillis();
                String string5 = "";
                int n6 = 0;
                iterator = treeMap.values().iterator();
                while (iterator.hasNext() && !this.indexCancelled) {
                    trinityTermToFilter = (TrinityTermToFilter)iterator.next();
                    n3 = trinityTermToFilter.getDupeTermIDCount();
                    if (n3 <= 0) continue;
                    String string6 = "";
                    Iterator iterator2 = trinityTermToFilter.getDupeTermIDs();
                    while (iterator2.hasNext() && !this.indexCancelled) {
                        int n7 = (Integer)iterator2.next();
                        if (string6.length() > 0) {
                            string6 = string6 + ", ";
                        }
                        string6 = string6 + n7;
                        if (string5.length() > 0) {
                            string5 = string5 + ", ";
                        }
                        string5 = string5 + n7;
                        ++n6;
                    }
                    this.sqlBatchController.postSqlCommand("UPDATE ITTERMTOENTITYMAP SET TermID = " + trinityTermToFilter.getTermID() + " WHERE TermID IN (" + string6 + ")");
                    this.updateTermWriteProgress(mutableLong2.addToValue(n3), l3, this.maxTermID);
                    if (n6 > 10) {
                        this.sqlBatchController.postSqlCommand("DELETE FROM ITTERMS WHERE TermID IN (" + string5 + ")");
                        string5 = "";
                        n6 = 0;
                    }
                    this.updateTermWriteProgress(mutableLong2.addToValue(n3), l3, this.maxTermID);
                }
                if (n6 > 0) {
                    this.sqlBatchController.postSqlCommand("DELETE FROM ITTERMS WHERE TermID IN (" + string5 + ")");
                }
                EntityIndexer.debugOut("Time spent in term filtering phase of executing update commands: " + EntityIndexer.formatTimeString((int)((System.currentTimeMillis() - l4) / 1000L)));
            }
            catch (Exception exception) {
                this.exitError("Exception while filtering terms:\n" + InsightUtilities.getStackTrace(exception));
            }
            treeMap = null;
        }
        catch (Exception exception) {
            this.exitError("Exception while filtering terms:\n" + InsightUtilities.getStackTrace(exception));
        }
        try {
            this.sqlBatchController.executeRemainingCommands();
        }
        catch (Exception exception) {
            EntityIndexer.debugOut("Filter terms: Exception caught while executing remaining SQL commands: " + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doEntityRelIndexing(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Entity relationships.");
        EntityIndexer.debugOut("");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        for (int i = 0; i < this.entityRelations.length; ++i) {
            EntityRelationship entityRelationship = this.entityRelations[i];
            EntityIndexer.debugOut("  Entity relationship # " + (i + 1) + ": " + entityRelationship.getEntityType().getName() + " to " + entityRelationship.getRelEntityType().getName());
            if (this.indexCancelled) continue;
            String string = this.createEntityRelationshipQuery(n, entityRelationship);
            EntityIndexer.debugOut("Adding " + EntityIndexer.getRecordCount(databaseConnector, string) + " relationships to " + "ITENTITYTOENTITYMAP" + ".");
            databaseConnector.setQuery("INSERT INTO ITENTITYTOENTITYMAP (EntityTypeID, EntityID, RelEntityTypeID, RelEntityID, UniqueCollectionID) " + string);
            EntityIndexer.debugOut("Relationship query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
        }
        databaseConnector.close();
    }

    protected void doEntityFlattening(Integer n, boolean bl) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Entity flattening.");
        EntityIndexer.debugOut("");
        long l = System.currentTimeMillis();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            boolean bl2 = false;
            if (bl2) {
                int n2;
                Vector<Entity> vector = new Vector<Entity>();
                String string = bl ? "ITVALUETOENTITYMAP" : "DTVALUETOENTITYMAP";
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                sqlQueryGenerator.addTable(string, new String[]{"EntityTypeID", "EntityID"});
                sqlQueryGenerator.appendToWhere("(RelEntityTypeID = 0 OR RelEntityID = 0)");
                sqlQueryGenerator.appendToWhere(string + ".UniqueCollectionID = " + n);
                String string2 = sqlQueryGenerator.getQuery();
                int n3 = EntityIndexer.getRecordCount(databaseConnector, string2);
                databaseConnector.setQuery(string2);
                EntityIndexer.debugOut("Get entities query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                EntityIndexer.clearDebugOutStay();
                while (databaseConnector.more()) {
                    vector.add(new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID")));
                    this.updateProgress(System.currentTimeMillis() - l, vector.size(), n3, "Retrieving entities (" + vector.size() + " rec) ", "");
                    databaseConnector.next();
                }
                databaseConnector.close();
                EntityIndexer.clearDebugOutStay();
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    this.updateProgress(System.currentTimeMillis() - l, n2 + 1, vector.size(), "Finding related entities (" + (n2 + 1) + " entity) ", "");
                    this.setRelatedEntities((Entity)vector.get(n2), databaseConnector, bl);
                }
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    this.updateProgress(System.currentTimeMillis() - l, n2 + 1, vector.size(), "Writing related entities (" + (n2 + 1) + " entity) ", "");
                    this.writeRelatedEntities(n, (Entity)vector.get(n2));
                }
            } else {
                EntityIndexer.clearDebugOutStay();
                TreeMap treeMap = new TreeMap();
                String string = bl ? "ITENTITYTOENTITYMAP" : "DTENTITYTOENTITYMAP";
                String string3 = bl ? "ITVALUETOENTITYMAP" : "DTVALUETOENTITYMAP";
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable(string, "*");
                sqlQueryGenerator.addTable(string3, new String[]{"ValueID", "Preferred", "DisplayOrder"});
                sqlQueryGenerator.addJoin(string, new String[]{"RelEntityTypeID", "RelEntityID"}, string3, new String[]{"EntityTypeID", "EntityID"}, 0);
                sqlQueryGenerator.appendToWhere(string + ".UniqueCollectionID = " + n);
                String string4 = sqlQueryGenerator.getQuery();
                int n4 = EntityIndexer.getRecordCount(databaseConnector, string4);
                databaseConnector.setQuery(string4);
                EntityIndexer.debugOut("Get entity mappings query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                EntityIndexer.clearDebugOutStay();
                int n5 = 0;
                while (databaseConnector.more()) {
                    EntityIndexer.registerEntityMapping(treeMap, new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID")), new Entity(databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID")), new EntityValueDetails(databaseConnector.getLongField("ValueID"), databaseConnector.getIntegerField("DisplayOrder"), databaseConnector.getBooleanField("Preferred")));
                    this.updateProgress(System.currentTimeMillis() - l, n5 + 1, n4, "Retrieving entity mapping (" + (n5 + 1) + " rec) ", "");
                    databaseConnector.next();
                    ++n5;
                }
                databaseConnector.close();
                EntityIndexer.clearDebugOutStay();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable(string, "*");
                sqlQueryGenerator.appendToWhere(string + ".RelEntityTypeID NOT IN (" + "SELECT EntityTypeID" + " FROM " + string3 + " WHERE " + string3 + ".EntityTypeID = " + string + ".RelEntityTypeID" + " AND " + string3 + ".EntityID = " + string + ".RelEntityID)");
                sqlQueryGenerator.appendToWhere(string + ".UniqueCollectionID = " + n);
                string4 = sqlQueryGenerator.getQuery();
                n4 = EntityIndexer.getRecordCount(databaseConnector, string4);
                databaseConnector.setQuery(string4);
                EntityIndexer.debugOut("Get entity mappings w\\out values query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                EntityIndexer.clearDebugOutStay();
                n5 = 0;
                while (databaseConnector.more()) {
                    EntityIndexer.registerEntityMapping(treeMap, new Entity(databaseConnector.getIntegerField("EntityTypeID"), databaseConnector.getLongField("EntityID")), new Entity(databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID")), null);
                    this.updateProgress(System.currentTimeMillis() - l, n5 + 1, n4, "Retrieving entity mapping (" + (n5 + 1) + " rec) ", "");
                    databaseConnector.next();
                    ++n5;
                }
                databaseConnector.close();
                EntityIndexer.clearDebugOutStay();
                List list = null;
                SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                int n6 = 0;
                Iterator iterator = treeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Entity entity = (Entity)iterator.next();
                    this.updateProgress(System.currentTimeMillis() - l, n6, treeMap.size(), "Copying related entities (" + (n6 + 1) + " entity) ", "");
                    EntityIndexer.setRelatedEntities(treeMap, entity);
                    EntityIndexer.getRelatedEntitySqlCommands(n, entity, list, false, this.sqlBatchController, sqlQueryGenerator2);
                    ++n6;
                }
                treeMap = null;
                EntityIndexer.clearDebugOutStay();
            }
            this.sqlBatchController.executeRemainingCommands();
        }
        catch (Exception exception) {
            EntityIndexer.debugOut("Exception in doEntityFlattening():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        EntityIndexer.clearDebugOutStay();
    }

    protected void updateValueToObjectMappings(Integer n) {
        EntityIndexer.clearDebugOutStay();
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Updating ITVALUETOOBJECT with Object entity data.");
        EntityIndexer.debugOut("Using entity type ID " + this.objEntityTypeID + " for Object.");
        EntityIndexer.debugOut("");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery("INSERT INTO ITVALUETOOBJECT (UniqueCollectionID, ValueID, ObjectID, Grouping, DisplayOrder, Preferred) SELECT DISTINCT UniqueCollectionID, ValueID, EntityID AS ObjectID, CAST(GROUPING AS INTEGER), DisplayOrder, Preferred FROM ITVALUETOENTITYMAP WHERE EntityTypeID = " + this.objEntityTypeID);
        EntityIndexer.debugOut("Update ITVALUETOOBJECT command:\n" + databaseConnector.getQuery());
        try {
            databaseConnector.runUpdateQuerySafe();
        }
        catch (JdbcConnectorError jdbcConnectorError) {
            EntityIndexer.debugOut("CAST is not supported.  Trying the query without CAST");
            databaseConnector.setQuery("INSERT INTO ITVALUETOOBJECT (UniqueCollectionID, ValueID, ObjectID, Grouping, DisplayOrder, Preferred) SELECT DISTINCT UniqueCollectionID, ValueID, EntityID AS ObjectID, GROUPING, DisplayOrder, Preferred FROM ITVALUETOENTITYMAP WHERE EntityTypeID = " + this.objEntityTypeID);
            EntityIndexer.debugOut("Update ITVALUETOOBJECT command:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
        }
        databaseConnector.close();
    }

    protected void updateTermToObjectMappings(Integer n) {
        EntityIndexer.clearDebugOutStay();
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Updating ITTERMOBJECTMAP with Object entity data.");
        EntityIndexer.debugOut("Using entity type ID " + this.objEntityTypeID + " for Object.");
        EntityIndexer.debugOut("");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery("INSERT INTO ITTERMOBJECTMAP (UniqueCollectionID, TermID, ObjectID, FieldID, Grouping) SELECT DISTINCT UniqueCollectionID, TermID, EntityID AS ObjectID, FieldID, Grouping FROM ITTERMTOENTITYMAP WHERE EntityTypeID = " + this.objEntityTypeID);
        EntityIndexer.debugOut("Update ITTERMOBJECTMAP command:\n" + databaseConnector.getQuery());
        databaseConnector.runUpdateQuery();
        databaseConnector.close();
    }

    protected void updateTableEntityToMediaMap() {
        EntityIndexer.clearDebugOutStay();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("Auto-fill IRENTITYMEDIAMAP.");
            int n = 0;
            databaseConnector.setQuery("SELECT COUNT(*) AS EntityMediaMapCount FROM IRENTITYMEDIAMAP");
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("EntityMediaMapCount");
            }
            databaseConnector.close();
            if (n > 0) {
                EntityIndexer.debugOut("\tIRENTITYMEDIAMAP already populated.");
            } else {
                EntityIndexer.debugOut("\tCopy IROBJECTIMAGEMAP -> IRENTITYMEDIAMAP");
                databaseConnector.setQuery("INSERT INTO IRENTITYMEDIAMAP (EntityTypeID, EntityID, MediaID) SELECT DISTINCT " + this.objEntityTypeID + " AS EntityTypeID" + ", ObjectID AS EntityID" + ", ImageID AS MediaID" + " FROM " + "IROBJECTIMAGEMAP");
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            EntityIndexer.debugOut("Exception in updateTableEntityToMediaMap():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            EntityIndexer.debugOut("Error in updateTableEntityToMediaMap():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    protected void setRelatedEntities(Entity entity) {
        if (entity != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            this.setRelatedEntities(entity, databaseConnector, false);
            databaseConnector.close();
        }
    }

    protected void setRelatedEntities(Entity entity, DatabaseConnector databaseConnector, boolean bl) {
        if (entity != null && databaseConnector != null) {
            String string = bl ? "ITENTITYTOENTITYMAP" : "DTENTITYTOENTITYMAP";
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(string, "*");
            sqlQueryGenerator.appendToWhere("EntityTypeID = " + entity.getEntityTypeID() + " AND EntityID = " + entity.getEntityID());
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            try {
                while (databaseConnector.more()) {
                    entity.addRelatedEntity(new Entity(databaseConnector.getIntegerField("RelEntityTypeID"), databaseConnector.getLongField("RelEntityID")));
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                EntityIndexer.debugOut("Exception in setRelatedEntities():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
            List list = entity.getRelatedEntities();
            for (int i = 0; list != null && i < list.size(); ++i) {
                this.setRelatedEntities((Entity)list.get(i), databaseConnector, bl);
            }
        }
    }

    protected void writeRelatedEntities(Integer n, Entity entity) {
        if (!this.indexCancelled && entity != null && entity.getRelatedEntities() != null) {
            Vector vector = new Vector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            EntityIndexer.getRelatedEntitySqlCommands(n, entity, vector, false, this.sqlBatchController, sqlQueryGenerator);
        }
    }

    protected void writeValueToFile(Integer n, TrinityValueToIndex trinityValueToIndex, EntityField entityField, MutableLong mutableLong, long l, int n2, int n3, boolean bl) throws IOException {
        if (!this.indexCancelled) {
            StringWriter stringWriter;
            StringWriter stringWriter2;
            ++this.maxValueID;
            String string = this.maxValueID + "";
            if (bl) {
                stringWriter2 = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter2, "UniqueCollectionID");
                CSVLogger.write(stringWriter2, "ValueID");
                CSVLogger.write(stringWriter2, "FieldID");
                CSVLogger.write(stringWriter2, "Enabled");
                CSVLogger.write(stringWriter2, "ValueNumber");
                CSVLogger.write(stringWriter2, "ValueText");
                CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_VALUES.writeBytes(stringWriter2.toString());
            }
            stringWriter2 = new StringWriter();
            CSVLogger.writeFirstRecord(stringWriter2, n);
            CSVLogger.write(stringWriter2, string);
            CSVLogger.write(stringWriter2, entityField.getFieldID() + "");
            CSVLogger.write(stringWriter2, trinityValueToIndex.isEnabled() ? "1" : "0");
            if (entityField.getTrinityField().fieldType == 2) {
                CSVLogger.write(stringWriter2, trinityValueToIndex.getValue());
                CSVLogger.write(stringWriter2, null);
            } else {
                CSVLogger.write(stringWriter2, null);
                CSVLogger.write(stringWriter2, trinityValueToIndex.getValue());
            }
            CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
            this.dos_VALUES.writeBytes(stringWriter2.toString());
            stringWriter2 = null;
            this.updateValueWriteProgress(mutableLong.getValue(), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            if (bl) {
                stringWriter = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter, "UniqueCollectionID");
                CSVLogger.write(stringWriter, "ValueID");
                CSVLogger.write(stringWriter, "EntityTypeID");
                CSVLogger.write(stringWriter, "EntityID");
                CSVLogger.write(stringWriter, "RelEntityTypeID");
                CSVLogger.write(stringWriter, "RelEntityID");
                CSVLogger.write(stringWriter, "ParentEntityTypeID");
                CSVLogger.write(stringWriter, "ParentEntityID");
                CSVLogger.write(stringWriter, "DisplayOrder");
                CSVLogger.write(stringWriter, "Preferred");
                CSVLogger.write(stringWriter, "Grouping");
                CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_VTE_MAP.writeBytes(stringWriter.toString());
                stringWriter = null;
            }
            Iterator iterator = trinityValueToIndex.getObjectIDs();
            long l2 = -1L;
            while (iterator.hasNext() && !this.indexCancelled) {
                TrinityValueObjectToMap trinityValueObjectToMap = (TrinityValueObjectToMap)iterator.next();
                if (l2 != trinityValueObjectToMap.getObjectID()) {
                    l2 = trinityValueObjectToMap.getObjectID();
                    stringWriter = new StringWriter();
                    CSVLogger.writeFirstRecord(stringWriter, n);
                    CSVLogger.write(stringWriter, string);
                    CSVLogger.write(stringWriter, entityField.getEntityType().getEntityTypeID() + "");
                    CSVLogger.write(stringWriter, trinityValueObjectToMap.getObjectID() + "");
                    CSVLogger.write(stringWriter, "0");
                    CSVLogger.write(stringWriter, "0");
                    CSVLogger.write(stringWriter, "0");
                    CSVLogger.write(stringWriter, "0");
                    CSVLogger.write(stringWriter, "0");
                    CSVLogger.write(stringWriter, trinityValueObjectToMap.isPreferred() ? "1" : "0");
                    CSVLogger.write(stringWriter, trinityValueObjectToMap.getGrouping());
                    CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
                    this.dos_VTE_MAP.writeBytes(stringWriter.toString());
                    stringWriter = null;
                }
                this.updateValueWriteProgress(mutableLong.addToValue(1L), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            }
        }
    }

    protected void writeValue(Integer n, TrinityValueToIndex trinityValueToIndex, EntityField entityField, MutableLong mutableLong, long l, int n2, int n3) {
        if (!this.indexCancelled) {
            ++this.maxValueID;
            String string = this.maxValueID + "";
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueID", 2, stringBuffer2, string);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, entityField.getFieldID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Enabled", 2, stringBuffer2, trinityValueToIndex.isEnabled() ? "1" : "0");
            if (entityField.getTrinityField().fieldType == 2) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueNumber", 2, stringBuffer2, trinityValueToIndex.getValue());
            } else {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueText", 1, stringBuffer2, trinityValueToIndex.getValue());
            }
            this.sqlBatchController.postSqlCommand("INSERT INTO ITVALUES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.updateValueWriteProgress(mutableLong.getValue(), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            Iterator iterator = trinityValueToIndex.getObjectIDs();
            long l2 = -1L;
            while (iterator.hasNext() && !this.indexCancelled) {
                TrinityValueObjectToMap trinityValueObjectToMap = (TrinityValueObjectToMap)iterator.next();
                if (l2 != trinityValueObjectToMap.getObjectID()) {
                    l2 = trinityValueObjectToMap.getObjectID();
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ValueID", 2, stringBuffer2, string);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, entityField.getEntityType().getEntityTypeID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, trinityValueObjectToMap.getObjectID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityTypeID", 2, stringBuffer2, "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RelEntityID", 2, stringBuffer2, "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ParentEntityTypeID", 2, stringBuffer2, "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ParentEntityID", 2, stringBuffer2, "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Preferred", 2, stringBuffer2, trinityValueObjectToMap.isPreferred() ? "1" : "0");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Grouping", 1, stringBuffer2, trinityValueObjectToMap.getGrouping());
                    this.sqlBatchController.postSqlCommand("INSERT INTO ITVALUETOENTITYMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                }
                this.updateValueWriteProgress(mutableLong.addToValue(1L), l, n2, n3, 1, this.maxValueID, this.maxTermID);
            }
        }
    }

    protected void writeTermToFile(Integer n, TrinityTermToIndex trinityTermToIndex, MutableLong mutableLong, long l, boolean bl) throws IOException {
        StringWriter stringWriter;
        StringWriter stringWriter2;
        ++this.maxTermID;
        String string = this.maxTermID + "";
        if (bl) {
            stringWriter2 = new StringWriter();
            CSVLogger.writeFirstRecord(stringWriter2, "TermID");
            CSVLogger.write(stringWriter2, "Keyword");
            CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
            this.dos_TERMS.writeBytes(stringWriter2.toString());
        }
        stringWriter2 = new StringWriter();
        CSVLogger.writeFirstRecord(stringWriter2, string);
        CSVLogger.write(stringWriter2, trinityTermToIndex.getTerm());
        CSVLogger.writeEndOfRecord(stringWriter2, DEFAULT_LOADFILE_ENDOFRECORD);
        this.dos_TERMS.writeBytes(stringWriter2.toString());
        stringWriter2 = null;
        this.updateTermWriteProgress(mutableLong.getValue(), l, this.maxTermID);
        if (bl) {
            stringWriter = new StringWriter();
            CSVLogger.writeFirstRecord(stringWriter, "UniqueCollectionID");
            CSVLogger.write(stringWriter, "TermID");
            CSVLogger.write(stringWriter, "EntityTypeID");
            CSVLogger.write(stringWriter, "EntityID");
            CSVLogger.write(stringWriter, "FieldID");
            CSVLogger.write(stringWriter, "Grouping");
            CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
            this.dos_TTE_MAP.writeBytes(stringWriter.toString());
            stringWriter = null;
        }
        Iterator iterator = trinityTermToIndex.getEntityIDs();
        while (iterator.hasNext() && !this.indexCancelled) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                TrinityTermObjectToMap trinityTermObjectToMap = (TrinityTermObjectToMap)vector.get(i);
                stringWriter = new StringWriter();
                CSVLogger.writeFirstRecord(stringWriter, n);
                CSVLogger.write(stringWriter, string);
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getEntityTypeID() + "");
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getEntityID() + "");
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getFieldID() + "");
                CSVLogger.write(stringWriter, trinityTermObjectToMap.getGrouping());
                CSVLogger.writeEndOfRecord(stringWriter, DEFAULT_LOADFILE_ENDOFRECORD);
                this.dos_TTE_MAP.writeBytes(stringWriter.toString());
                stringWriter = null;
                this.updateTermWriteProgress(mutableLong.addToValue(1L), l, this.maxTermID);
            }
        }
    }

    protected void writeTerm(Integer n, TrinityTermToIndex trinityTermToIndex, MutableLong mutableLong, long l) {
        ++this.maxTermID;
        String string = this.maxTermID + "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TermID", 2, stringBuffer2, string);
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Keyword", 1, stringBuffer2, trinityTermToIndex.getTerm());
        this.sqlBatchController.postSqlCommand("INSERT INTO ITTERMS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
        this.updateTermWriteProgress(mutableLong.getValue(), l, this.maxTermID);
        Iterator iterator = trinityTermToIndex.getEntityIDs();
        while (iterator.hasNext() && !this.indexCancelled) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size() && !this.indexCancelled; ++i) {
                TrinityTermObjectToMap trinityTermObjectToMap = (TrinityTermObjectToMap)vector.get(i);
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TermID", 2, stringBuffer2, string);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, trinityTermObjectToMap.getEntityTypeID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, trinityTermObjectToMap.getEntityID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, trinityTermObjectToMap.getFieldID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Grouping", 2, stringBuffer2, trinityTermObjectToMap.getGrouping());
                this.sqlBatchController.postSqlCommand("INSERT INTO ITTERMTOENTITYMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.updateTermWriteProgress(mutableLong.addToValue(1L), l, this.maxTermID);
            }
        }
    }

    protected void updateValueReadProgress(long l, long l2, int n, int n2, int n3, long l3, long l4) {
        if (l % 20L == 0L) {
            long l5 = System.currentTimeMillis() - startTime;
            int n4 = (int)(l5 / 1000L);
            int n5 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            int n6 = n + n2 * n3 * n5 / 100;
            if (l5 > this.lastTime + 2000L) {
                double d = 0.0;
                int n7 = 0;
                if (n4 > 5) {
                    d = (double)n4 * 100.0 / ((double)n + (double)(n2 * n3 * n5) / 100.0);
                    n7 = (int)d - n4;
                }
                this.elapsedTime = this.elapsedTime(l5);
                this.remainingTime = EntityIndexer.formatTimeString(n7);
                this.lastTime = l5;
            }
            Debug.debugOutStay("  Reading/indexing values " + l + "val (" + n5 + "%, " + n6 + "%)/" + l3 + "fv/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setValuePb1Value(n5);
            }
        }
    }

    protected void updateValueWriteProgress(long l, long l2, int n, int n2, int n3, long l3, long l4) {
        if (l % 20L == 0L) {
            long l5 = System.currentTimeMillis() - startTime;
            int n4 = (int)(l5 / 1000L);
            int n5 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            int n6 = n + n2 * n3 * n5 / 100;
            if (l5 > this.lastTime + 2000L) {
                double d = 0.0;
                int n7 = 0;
                if (n4 > 5) {
                    d = (double)n4 * 100.0 / ((double)n + (double)(n2 * n3 * n5) / 100.0);
                    n7 = (int)d - n4;
                }
                this.elapsedTime = this.elapsedTime(l5);
                this.remainingTime = EntityIndexer.formatTimeString(n7);
                if (this.progressListener != null) {
                    // empty if block
                }
                this.lastTime = l5;
            }
            Debug.debugOutStay("  Writing values " + l + "rec/" + l2 + "recs(" + n5 + "%, " + n6 + "%)/" + l3 + "fv/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setValuePb2Value(n5);
            }
        }
    }

    protected void updateTermReadProgress(long l, long l2, long l3) {
        if (l % 20L == 0L) {
            long l4 = System.currentTimeMillis() - startTime;
            int n = (int)(l4 / 1000L);
            int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            if (l4 > this.lastTime + 2000L) {
                double d = 0.0;
                int n3 = 0;
                if (n > 5) {
                    d = n * 100 / (n2 > 0 ? n2 : 1);
                    n3 = (int)d - n;
                }
                this.elapsedTime = this.elapsedTime(l4);
                this.remainingTime = EntityIndexer.formatTimeString(n3);
                this.lastTime = l4;
            }
            Debug.debugOutStay("  Reading/indexing terms " + l + "val (" + n2 + "%)/" + l3 + "t/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setTermPb1Value(n2 + 1);
            }
        }
    }

    protected void updateTermWriteProgress(long l, long l2, long l3) {
        if (l % 20L == 0L) {
            long l4 = System.currentTimeMillis() - startTime;
            int n = (int)(l4 / 1000L);
            int n2 = (int)(l * 100L / (l2 > 0L ? l2 : 1L));
            if (l4 > this.lastTime + 2000L) {
                double d = 0.0;
                int n3 = 0;
                if (n > 5) {
                    d = n * 100 / (n2 > 0 ? n2 : 1);
                    n3 = (int)d - n;
                }
                this.elapsedTime = this.elapsedTime(l4);
                this.remainingTime = EntityIndexer.formatTimeString(n3);
                this.lastTime = l4;
            }
            Debug.debugOutStay("  Writing terms " + l + "rec/" + l2 + "recs(" + n2 + "%)/" + l3 + "t/" + this.elapsedTime + "e/" + this.remainingTime + "r\r", 3);
            if (this.progressListener != null) {
                this.progressListener.setTermPb2Value(n2 + 1);
            }
        }
    }

    protected void commitIndexingChanges(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Clearing old destination tables.");
        EntityIndexer.debugOut("");
        if (this.canClearDestinationTables()) {
            if (this.progressListener != null && (doTermIndex || doValueIndex)) {
                this.progressListener.setDestinationTablesStatusText("Deleting Tables");
            }
            if (doTermIndex) {
                this.clearTable(n, "DTTERMTOENTITYMAP");
                this.clearTable(n, "DTTERMOBJECTMAP");
                this.clearTable(null, "DTTERMS", "TermID NOT IN (SELECT TermID FROM DTTERMOBJECTMAP)");
            }
            if (doValueIndex) {
                this.clearTable(n, "DTVALUETOENTITYMAP");
                this.clearTable(n, "DTVALUETOOBJECT");
                this.clearTable(n, "DTVALUES");
                this.clearTable(n, "DTENTITYTOENTITYMAP");
                this.clearTable(n, "ISCOLLECTIONENTITYMAP");
            }
        } else {
            this.exitError("Aborting indexing.");
        }
        if (!this.indexCancelled) {
            int n2;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM IDTEMPOLD");
            databaseConnector.runUpdateQuery();
            databaseConnector.setQuery("DELETE FROM IDTEMPNEW");
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            EntityIndexer.debugOut("");
            EntityIndexer.debugOut("Copying from temporary tables to destination tables.");
            EntityIndexer.debugOut("");
            if (this.progressListener != null && (doTermIndex || doValueIndex)) {
                n2 = 0;
                if (doTermIndex) {
                    n2 += 3;
                }
                if (doValueIndex) {
                    n2 += 4;
                }
                this.progressListener.setDestinationPb1Maximum(n2);
                this.progressListener.setDestinationTablesStatusText("Copying Values into Tables");
            }
            n2 = 1;
            DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
            if (doTermIndex) {
                databaseConnector2.setQuery("INSERT INTO DTTERMTOENTITYMAP SELECT Distinct * FROM ITTERMTOENTITYMAP");
                EntityIndexer.debugOut("  ITTERMTOENTITYMAP -> DTTERMTOENTITYMAP.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
                databaseConnector2.setQuery("INSERT INTO DTTERMOBJECTMAP SELECT Distinct * FROM ITTERMOBJECTMAP");
                EntityIndexer.debugOut("  ITTERMOBJECTMAP -> DTTERMOBJECTMAP.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
                databaseConnector2.setQuery("INSERT INTO DTTERMS SELECT * FROM ITTERMS");
                EntityIndexer.debugOut("  ITTERMS -> DTTERMS.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
            }
            if (doValueIndex) {
                databaseConnector2.setQuery("INSERT INTO DTVALUETOENTITYMAP SELECT Distinct * FROM ITVALUETOENTITYMAP");
                EntityIndexer.debugOut("  ITVALUETOENTITYMAP -> DTVALUETOENTITYMAP.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
                databaseConnector2.setQuery("INSERT INTO DTVALUETOOBJECT SELECT Distinct * FROM ITVALUETOOBJECT");
                EntityIndexer.debugOut("  ITVALUETOOBJECT -> DTVALUETOOBJECT.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
                databaseConnector2.setQuery("INSERT INTO DTVALUES SELECT * FROM ITVALUES");
                EntityIndexer.debugOut("  ITVALUES -> DTVALUES.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
                databaseConnector2.setQuery("INSERT INTO DTENTITYTOENTITYMAP SELECT Distinct * FROM ITENTITYTOENTITYMAP");
                EntityIndexer.debugOut("  ITENTITYTOENTITYMAP -> DTENTITYTOENTITYMAP.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
                if (this.progressListener != null) {
                    this.progressListener.setDestinationPb1Value(n2++);
                }
                databaseConnector2.setQuery("INSERT INTO ISCOLLECTIONENTITYMAP (UniqueCollectionID, EntityTypeID, EntityID) SELECT Distinct UniqueCollectionID, EntityTypeID, EntityID FROM DTVALUETOENTITYMAP WHERE UniqueCollectionID = " + n);
                EntityIndexer.debugOut("  DTVALUETOENTITYMAP -> ISCOLLECTIONENTITYMAP.");
                databaseConnector2.runUpdateQuerySafe();
                databaseConnector2.close();
            }
            if (clearTempTablesOnExit) {
                EntityIndexer.debugOut("Cleaning up.  (Removing data from temporary tables.)");
                EntityIndexer.debugOut("");
                if (this.progressListener != null) {
                    this.progressListener.setDestinationTablesStatusText("Clearing Temporary Tables");
                }
                this.clearTemporaryTables(n);
            }
            if (this.progressListener != null) {
                this.progressListener.setDestinationTablesStatusText("Completed");
            }
        }
    }

    protected void updateProgress(long l, long l2, long l3, String string, String string2) {
        if (l2 % 20L == 0L) {
            Debug.debugOutStay("  " + string + " " + this.getProgressString(l, l2, l3) + " " + string2 + "\r", 3);
            this.lastTime = System.currentTimeMillis();
        }
    }

    protected String getProgressString(long l, long l2, long l3) {
        long l4 = l / 1000L;
        long l5 = l2 * 100L / (l3 > 0L ? l3 : 1L);
        long l6 = (long)((double)l4 * 100.0 / (double)l5) - l4;
        String string = EntityIndexer.formatTimeString((int)l4);
        String string2 = EntityIndexer.formatTimeString((int)l6);
        return "(" + l5 + "%, " + string + "e/" + string2 + "r)";
    }

    protected String elapsedTime(long l) {
        int n = (int)(l / 1000L);
        return EntityIndexer.formatTimeString(n);
    }

    protected static String formatTimeString(int n) {
        int n2 = n / 60;
        int n3 = n2 / 60;
        String string = "";
        string = n3 < 10 ? string + "0" + n3 + ":" : string + n3 + ":";
        string = n2 < 10 ? string + "0" + n2 + ":" : string + (n2 %= 60) + ":";
        string = n < 10 ? string + "0" + n : string + (n %= 60);
        return string;
    }

    protected String createEntityFieldQuery(EntityField entityField) {
        if (entityField != null) {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(entityField.getEntityType().getTable().name, null, entityField.getEntityType().getEntityIDColumnName());
            SqlTable sqlTable = entityField.getJoin() == null ? new SqlTable(entityField.getEntityType().getTable().name) : new SqlTable(entityField.getFieldTable().name);
            if (entityField.getPrefValueColumnName() != null && entityField.getPrefValueColumnName().length() > 0) {
                sqlTable.addColumnSelection(entityField.getPrefValueColumnName());
            }
            sqlTable.addColumnSelection(entityField.getFieldValueColumnName());
            sqlQueryGenerator.addTable(sqlTable);
            SqlTable sqlTable2 = null;
            if (entityField.getGroupingFieldName() != null && entityField.getGroupingFieldName().length() > 0 && entityField.getGroupingTable() != null && entityField.getJoin() != null) {
                sqlTable2 = new SqlTable(entityField.getGroupingTable().name);
                sqlTable2.addColumnSelection(entityField.getGroupingFieldName());
                sqlQueryGenerator.addTable(sqlTable2);
            }
            sqlQueryGenerator.addOrderBy(entityField.getEntityType().getTable().name, entityField.getEntityType().getEntityIDColumnName());
            if (!entityField.getEntityType().getTable().name.equalsIgnoreCase(sqlTable.getTableName()) || !entityField.getEntityType().getEntityIDColumnName().equalsIgnoreCase(entityField.getFieldValueColumnName())) {
                sqlQueryGenerator.addOrderBy(sqlTable.getTableName(), entityField.getFieldValueColumnName());
            }
            if (!(sqlTable2 == null || entityField.getEntityType().getTable().name.equalsIgnoreCase(sqlTable2.getTableName()) && entityField.getEntityType().getEntityIDColumnName().equalsIgnoreCase(entityField.getGroupingFieldName()) || sqlTable.getTableName().equalsIgnoreCase(sqlTable2.getTableName()) && entityField.getFieldValueColumnName().equalsIgnoreCase(entityField.getGroupingFieldName()))) {
                sqlQueryGenerator.addOrderBy(sqlTable2.getTableName(), entityField.getGroupingFieldName());
            }
            TrinityJoin trinityJoin = entityField.getJoin();
            while (trinityJoin != null) {
                sqlQueryGenerator.addJoin(trinityJoin.startTable.name, new String[]{trinityJoin.startTableField}, trinityJoin.endTable.name, new String[]{trinityJoin.endTableField}, 0);
                trinityJoin = trinityJoin.nextJoin;
            }
            EntityIndexer.debugOut("generated constructFieldQuery() query: \n" + sqlQueryGenerator.getQuery());
            return sqlQueryGenerator.getQuery();
        }
        return null;
    }

    protected String createEntityRelationshipQuery(Integer n, EntityRelationship entityRelationship) {
        if (entityRelationship != null) {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(entityRelationship.getEntityType().getTable().name, null, new Object[]{new SqlColumnSelection(entityRelationship.getEntityType().getEntityTypeID() + " AS EntityTypeID", false), new String(entityRelationship.getEntityType().getEntityIDColumnName() + " AS EntityID")});
            sqlQueryGenerator.addTable(entityRelationship.getRelEntityType().getTable().name, null, new Object[]{new SqlColumnSelection(entityRelationship.getRelEntityType().getEntityTypeID() + " AS RelEntityTypeID", false), new String(entityRelationship.getRelEntityType().getEntityIDColumnName() + " AS RelEntityID")});
            sqlQueryGenerator.addIsolatedSelection(n.toString() + " AS UniqueCollectionID");
            sqlQueryGenerator.addOrderBy(entityRelationship.getEntityType().getTable().name, entityRelationship.getEntityType().getEntityIDColumnName());
            TrinityJoin trinityJoin = entityRelationship.getJoin();
            while (trinityJoin != null) {
                sqlQueryGenerator.addJoin(trinityJoin.startTable.name, new String[]{trinityJoin.startTableField}, trinityJoin.endTable.name, new String[]{trinityJoin.endTableField}, 0);
                trinityJoin = trinityJoin.nextJoin;
            }
            return sqlQueryGenerator.getQuery();
        }
        return null;
    }

    protected void gatherTableData(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering table information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM ISTABLES WHERE UniqueCollectionID = " + n);
            databaseConnector.runQuery();
            Vector<TrinityTable> vector = new Vector<TrinityTable>();
            EntityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityTable trinityTable = new TrinityTable();
                    trinityTable.tableID = this.getIntegerField(databaseConnector, "TableID");
                    trinityTable.name = this.getStringField(databaseConnector, "TableName");
                    EntityIndexer.debugOut("  Table #" + trinityTable.tableID + ": " + trinityTable.name);
                    vector.addElement(trinityTable);
                    databaseConnector.next();
                }
            } else {
                EntityIndexer.debugOut("Cannot gather table data from ISTABLES table.");
            }
            databaseConnector.close();
            this.tables = vector.toArray(new TrinityTable[vector.size()]);
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering table data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void gatherJoinData(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering join information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM ISJOINS WHERE UniqueCollectionID = " + n);
            databaseConnector.runQuery();
            Vector<TrinityJoin> vector = new Vector<TrinityJoin>();
            EntityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityJoin trinityJoin = new TrinityJoin();
                    trinityJoin.joinID = this.getIntegerField(databaseConnector, "JoinID");
                    trinityJoin.startTableField = this.getStringField(databaseConnector, "StartFieldName");
                    trinityJoin.endTableField = this.getStringField(databaseConnector, "EndFieldName");
                    trinityJoin.nextJoinID = this.getIntegerField(databaseConnector, "NextJoin");
                    trinityJoin.startTable = this.getTable(this.getIntegerField(databaseConnector, "StartTableID"));
                    trinityJoin.endTable = this.getTable(this.getIntegerField(databaseConnector, "EndTableID"));
                    EntityIndexer.debugOut("  Join #" + trinityJoin.joinID + ": " + trinityJoin.startTable.name + " to " + trinityJoin.endTable.name);
                    vector.addElement(trinityJoin);
                    databaseConnector.next();
                }
            } else {
                EntityIndexer.debugOut("  No join data.");
            }
            databaseConnector.close();
            this.joins = vector.toArray(new TrinityJoin[vector.size()]);
            for (int i = 0; i < this.joins.length; ++i) {
                this.joins[i].nextJoin = this.getJoin(this.joins[i].nextJoinID);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering join data:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void gatherFieldData() {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering field information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRFIELDS", null, "*");
            sqlQueryGenerator.addTable("IRTYPES", null, "*");
            sqlQueryGenerator.addJoin("IRFIELDS", new String[]{"FieldType"}, "IRTYPES", new String[]{"TypeID"}, 0);
            sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            Vector<TrinityIndexerField> vector = new Vector<TrinityIndexerField>();
            EntityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    TrinityIndexerField trinityIndexerField = new TrinityIndexerField();
                    trinityIndexerField.fieldID = this.getIntegerField(databaseConnector, "FieldID");
                    trinityIndexerField.displayName = this.getStringField(databaseConnector, "DisplayName");
                    trinityIndexerField.setType(this.getStringField(databaseConnector, "TypeCode"));
                    trinityIndexerField.sourceName = this.getStringField(databaseConnector, "FieldName");
                    trinityIndexerField.searchable = this.getIntegerField(databaseConnector, "KeywordSearchable") == 1;
                    trinityIndexerField.setPreferredFieldName(this.getStringField(databaseConnector, "PreferredFieldName"));
                    String string = null;
                    try {
                        string = databaseConnector.getFieldByName("GroupingFieldName");
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                    trinityIndexerField.setGroupingFieldName(string);
                    try {
                        trinityIndexerField.setGroupingTable(this.getTable(databaseConnector.getIntegerField("GroupingTableID")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    trinityIndexerField.table = this.getTable(this.getIntegerField(databaseConnector, "TableID"));
                    trinityIndexerField.joinID = this.getIntegerField(databaseConnector, "JoinPath");
                    trinityIndexerField.join = this.getJoin(trinityIndexerField.joinID);
                    EntityIndexer.debugOut("  Field #" + trinityIndexerField.fieldID + ": " + trinityIndexerField.displayName);
                    EntityIndexer.debugOut("    first join: " + trinityIndexerField.join);
                    vector.addElement(trinityIndexerField);
                    databaseConnector.next();
                }
            } else {
                this.exitError("Cannot gather collection data from IRFIELDS table.");
            }
            databaseConnector.close();
            this.fields = new TrinityIndexerField[vector.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = (TrinityIndexerField)vector.elementAt(i);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering field data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void gatherStopList() {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering stop-list information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM ISSTOPLIST");
            databaseConnector.runQuery();
            Vector<String> vector = new Vector<String>();
            EntityIndexer.debugOut("");
            while (databaseConnector.more() && !this.indexCancelled) {
                String string = this.getStringField(databaseConnector, "Term");
                vector.addElement(string);
                EntityIndexer.debugOut("  Stop-list term #" + vector.size() + ": " + string);
                databaseConnector.next();
            }
            databaseConnector.close();
            this.stopList = new String[vector.size()];
            for (int i = 0; i < this.stopList.length; ++i) {
                this.stopList[i] = (String)vector.elementAt(i);
            }
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering field-group data:\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected boolean gatherEntityTypes(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering entity type information.");
        boolean bl = false;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYTYPES", null, "*");
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + sqlQueryGenerator.prepStringForQuery("NA") + ")");
            sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            Vector<EntityType> vector = new Vector<EntityType>();
            EntityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    EntityType entityType = new EntityType(this.getIntegerField(databaseConnector, "EntityTypeID"), this.getStringField(databaseConnector, "EntityTypeName"), this.getStringField(databaseConnector, "EntityTypeDisplayName"), this.getIntegerField(databaseConnector, "EntityTypeDisplayOrder"), this.getIntegerField(databaseConnector, "EntityTableID"), this.getStringField(databaseConnector, "EntityIDColumnName"), this.getIntegerField(databaseConnector, "RestrictionLevel"), this.getBooleanField(databaseConnector, "IsVocabulary"), this.getBooleanField(databaseConnector, "IsDependent"), this.getBooleanField(databaseConnector, "IsDupeCheckEnabled"), this.getBooleanField(databaseConnector, "IsRefCheckEnabled"));
                    entityType.setTable(this.getTable(entityType.getTableID()));
                    EntityIndexer.debugOut("  Entity type #" + entityType.getEntityTypeID() + ": " + entityType.getName());
                    vector.add(entityType);
                    if (InsightUtilities.isEmpty(entityType.getEntityIDColumnName()) || entityType.getTable() == null || !SqlQueryGenerator.doesColumnExist(databaseConnector2, entityType.getEntityIDColumnName(), entityType.getTable().name)) {
                        bl = true;
                        EntityIndexer.debugOut("Source table missing for entityType: " + entityType);
                    }
                    databaseConnector.next();
                }
            } else {
                EntityIndexer.debugOut("  No entity types defined.");
            }
            databaseConnector.close();
            databaseConnector2.close();
            this.entityTypes = vector.toArray(new EntityType[vector.size()]);
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering entity type data:\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    protected void gatherEntityFields(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering entity field information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYFIELDS", null, "*");
            sqlQueryGenerator.addTable("IRFIELDS", null, new String[]{"GroupingFieldname", "GroupingTableID"});
            sqlQueryGenerator.addJoin("ISENTITYFIELDS", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("ISENTITYFIELDS", "ISENTITYTYPES", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + sqlQueryGenerator.prepStringForQuery("NA") + ")");
            sqlQueryGenerator.addOrderBy("ISENTITYFIELDS", "EntityTypeID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            Vector<EntityField> vector = new Vector<EntityField>();
            EntityIndexer.debugOut("");
            if (databaseConnector.more()) {
                String string = null;
                String string2 = null;
                while (databaseConnector.more() && !this.indexCancelled) {
                    try {
                        string = databaseConnector.getStringField("HierarchyIDColumnName");
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                    try {
                        string2 = databaseConnector.getStringField("HierarchyNodeIDColumnName");
                    }
                    catch (Exception exception) {
                        string2 = null;
                    }
                    EntityField entityField = new EntityField(this.getIntegerField(databaseConnector, "EntityTypeID"), this.getIntegerField(databaseConnector, "FieldID"), this.getIntegerField(databaseConnector, "JoinID"), this.getIntegerField(databaseConnector, "FieldTableID"), this.getStringField(databaseConnector, "FieldValueColumnName"), this.getStringField(databaseConnector, "PreferredValueColumnName"), string, string2);
                    entityField.setEntityType(this.getEntityType(entityField.getEntityTypeID()));
                    entityField.setTrinityField(this.getField(entityField.getFieldID()));
                    entityField.setJoin(this.getJoin(entityField.getJoinID()));
                    entityField.setFieldTable(this.getTable(entityField.getFieldTableID()));
                    String string3 = null;
                    try {
                        string3 = databaseConnector.getFieldByName("GroupingFieldName");
                    }
                    catch (Exception exception) {
                        string3 = null;
                    }
                    entityField.setGroupingFieldName(string3);
                    int n2 = 0;
                    try {
                        n2 = databaseConnector.getIntegerField("GroupingTableID");
                    }
                    catch (Exception exception) {
                        n2 = 0;
                    }
                    for (int i = 0; i < this.tables.length; ++i) {
                        if (n2 != this.tables[i].tableID) continue;
                        entityField.setGroupingTable(this.tables[i]);
                        break;
                    }
                    vector.add(entityField);
                    EntityIndexer.debugOut("  Entity field # " + vector.size() + ": " + entityField.getEntityType().getName() + ": " + entityField.getTrinityField().displayName);
                    databaseConnector.next();
                }
            } else {
                EntityIndexer.debugOut("  No entity fields defined.");
            }
            databaseConnector.close();
            this.entityFields = vector.toArray(new EntityField[vector.size()]);
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering entity field data:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void gatherEntityRelationships(Integer n) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("Gathering entity relationship information.");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYRELATIONSHIPS", "*");
            sqlQueryGenerator.addJoin("ISENTITYRELATIONSHIPS", "ISENTITYTYPES", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + sqlQueryGenerator.prepStringForQuery("NA") + ")");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            Vector<EntityRelationship> vector = new Vector<EntityRelationship>();
            EntityIndexer.debugOut("");
            if (databaseConnector.more()) {
                while (databaseConnector.more() && !this.indexCancelled) {
                    EntityRelationship entityRelationship = new EntityRelationship(this.getIntegerField(databaseConnector, "EntityTypeID"), this.getIntegerField(databaseConnector, "RelEntityTypeID"), this.getIntegerField(databaseConnector, "JoinID"), databaseConnector.getIntegerField("SourceMapTableID"));
                    entityRelationship.setEntityType(this.getEntityType(entityRelationship.getEntityTypeID()));
                    entityRelationship.setRelEntityType(this.getEntityType(entityRelationship.getRelEntityTypeID()));
                    entityRelationship.setJoin(this.getJoin(entityRelationship.getJoinID()));
                    entityRelationship.setSourceMapTable(this.getTable(entityRelationship.getSourceMapTableID()));
                    vector.add(entityRelationship);
                    EntityIndexer.debugOut("  Entity relationship # " + vector.size() + ": " + entityRelationship.getEntityType().getName() + " to " + entityRelationship.getRelEntityType().getName());
                    databaseConnector.next();
                }
            } else {
                EntityIndexer.debugOut("  No entity relationships defined.");
            }
            databaseConnector.close();
            this.entityRelations = vector.toArray(new EntityRelationship[vector.size()]);
        }
        catch (Exception exception) {
            this.exitError("Exception while gathering entity relationship data:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected TrinityTable getTable(int n) {
        for (int i = 0; this.tables != null && i < this.tables.length; ++i) {
            if (this.tables[i].getTableID() != n) continue;
            return this.tables[i];
        }
        return null;
    }

    protected TrinityJoin getJoin(int n) {
        for (int i = 0; this.joins != null && i < this.joins.length; ++i) {
            if (this.joins[i].joinID != n) continue;
            return this.joins[i];
        }
        return null;
    }

    protected TrinityIndexerField getField(int n) {
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            if (this.fields[i].fieldID != n) continue;
            return this.fields[i];
        }
        return null;
    }

    protected boolean isStopWord(String string) {
        for (int i = 0; string != null && this.stopList != null && i < this.stopList.length; ++i) {
            if (this.stopList[i] == null || !this.stopList[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected EntityType getEntityType(int n) {
        for (int i = 0; this.entityTypes != null && i < this.entityTypes.length; ++i) {
            if (this.entityTypes[i].getEntityTypeID() != n) continue;
            return this.entityTypes[i];
        }
        return null;
    }

    protected void clearTemporaryTables(Integer n) {
        if (this.progressListener != null) {
            this.progressListener.setBorderTitle("Clearing Temporary Tables");
        }
        this.clearTable(null, "ITTERMS");
        this.clearTable(null, "ITTERMOBJECTMAP");
        this.clearTable(null, "ITTERMTOENTITYMAP");
        this.clearTable(null, "ITVALUES");
        this.clearTable(null, "ITVALUETOOBJECT");
        this.clearTable(null, "ITVALUETOENTITYMAP");
        this.clearTable(null, "ITENTITYTOENTITYMAP");
    }

    protected boolean canClearDestinationTables() {
        int n;
        int n2;
        block13: {
            n2 = 110;
            n = -1;
            if (!force) {
                String string = "";
                if (doValueIndex) {
                    string = string + " Values";
                }
                if (doTermIndex) {
                    if (string.length() > 0) {
                        string = string + " and";
                    }
                    string = string + " Terms";
                }
                EntityIndexer.debugOut("");
                EntityIndexer.debugOut("Indexing complete.\n     About to delete contents of old DT" + string + " tables and" + "\n     copy data from IT" + string + " tables into them." + "\n     Please look at your IT" + string + " tables" + "\n     and make sure that everything worked as you intended" + "\n     before changes are committed." + "\n\n     Really clear old destination tables? (y/n)", 1);
                n2 = 110;
                byte[] byArray = new byte[1];
                if (!force) {
                    try {
                        if (this.progressListener != null) {
                            EntityIndexer.debugOut("Get answer through progressListener.");
                            if (string.length() > 0) {
                                this.progressListener.pauseTimer();
                                this.progressListener.pauseRemainingTimeTimer();
                                n = this.progressListener.showJOptionPaneConfirmDialog(string + " Indexing has completed successfully. \n Would you like to update the destination tables?", "Commit Changes");
                                if (n == 0) {
                                    this.progressListener.restartTimer();
                                    this.progressListener.restartRemainingTimeTimer();
                                    this.progressListener.setBorderTitle("Updating Destination Tables");
                                    this.progressListener.setDestinationTablesStatusText("Started");
                                }
                            } else {
                                n = 0;
                                this.progressListener.setDestinationTablesStatusText("Started");
                            }
                            break block13;
                        }
                        while (true) {
                            System.in.read(byArray);
                            n2 = (char)byArray[0];
                            if (n2 != 121 && n2 != 89 && n2 != 110 && n2 != 78) {
                                EntityIndexer.debugOut("Please enter y for Yes or n for No", 1);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return n2 == 121 || force || n == 0;
    }

    protected void exitError(String string) {
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut("");
        EntityIndexer.debugOut(string);
        EntityIndexer.debugOut("");
        if (timeSpent == -1L) {
            timeSpent = System.currentTimeMillis() - startTime;
        }
        EntityIndexer.debugOut("Time spent indexing: " + EntityIndexer.formatTimeString((int)(timeSpent / 1000L)));
        try {
            if (this.dos_VALUES != null) {
                this.dos_VALUES.close();
                this.dos_VALUES = null;
            }
            if (this.dos_VTE_MAP != null) {
                this.dos_VTE_MAP.close();
                this.dos_VTE_MAP = null;
            }
            if (this.dos_TERMS != null) {
                this.dos_TERMS.close();
                this.dos_TERMS = null;
            }
            if (this.dos_TTE_MAP != null) {
                this.dos_TTE_MAP.close();
                this.dos_TTE_MAP = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.progressListener != null) {
            this.setIndexCancelled(true);
            this.progressListener.indexerFailure(string);
        } else {
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Properties loadProperties(File file) {
        Properties properties;
        block11: {
            properties = new Properties();
            FileInputStream fileInputStream = null;
            EntityIndexer.debugOut("Configuration file is " + file + ".");
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
            Object var6_4 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (Exception exception) {
                    EntityIndexer.debugOut("Cannot read configuration file!");
                    EntityIndexer.debugOut("Server terminating due to configuration file problems.");
                    EntityIndexer.debugOut("Exception in loadProperties():\n" + InsightUtilities.convertStackTraceToString(exception));
                    System.exit(0);
                    Object var6_5 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    protected Properties loadProperties() {
        Properties properties = new Properties();
        try {
            EntityIndexer.debugOut("Configuration file is InsightTrinityIndexer.dat.");
            FileInputStream fileInputStream = new FileInputStream(PROPS_FILE);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            EntityIndexer.debugOut("Cannot read configuration file!");
            EntityIndexer.debugOut("Server terminating due to configuration file problems.");
            EntityIndexer.debugOut("Exception in loadProperties():\n" + InsightUtilities.convertStackTraceToString(exception));
            System.exit(0);
        }
        return properties;
    }

    protected void clearTable(Integer n, String string) {
        this.clearTable(n, string, "");
    }

    protected void clearTable(Integer n, String string, String string2) {
        String string3 = "";
        if (string2 != null && string2.length() > 0) {
            string3 = " WHERE " + string2;
            if (n != null) {
                string3 = string3 + " AND UniqueCollectionID = " + n;
            }
        } else if (n != null) {
            string3 = " WHERE UniqueCollectionID = " + n;
        }
        EntityIndexer.debugOut("  Deleting contents of " + string + string3 + ".");
        this.quickUpdateQuery("DELETE FROM " + string + string3);
    }

    protected void quickQuery(String string) {
        EntityIndexer.debugOut("  Executing query: " + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(string);
        databaseConnector.runUpdateQuery();
        databaseConnector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quickUpdateQuery(String string) {
        EntityIndexer.debugOut("  Executing update query: " + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(string);
        try {
            databaseConnector.runUpdateQuerySafe();
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public void setIndexCancelled(boolean bl) {
        this.indexCancelled = bl;
        if (this.indexCancelled && this.sqlBatchController != null) {
            this.sqlBatchController.setStillNeeded(false);
        }
    }

    public void setProgressListener(TrinityIndexerProgressListener trinityIndexerProgressListener) {
        this.progressListener = trinityIndexerProgressListener;
    }

    static {
        timeSpent = -1L;
    }
}

