/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityAddChange;
import com.luna.insight.server.inscribe.EntityChange;
import com.luna.insight.server.inscribe.EntityFieldChange;
import com.luna.insight.server.inscribe.EntityFieldValue;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EntityMapChange;
import com.luna.insight.server.inscribe.EntityMediaMapChange;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class EntityChangeList
implements EntityKey,
Serializable {
    static final long serialVersionUID = 7153483201062061189L;
    protected Entity entityBefore = null;
    protected transient List fieldValuesAfter = new Vector(0);
    protected transient List relEntitiesAfter = new Vector(0);
    protected int userID;
    protected int entityTypeID;
    protected long entityID;
    protected String institutionID;
    protected String collectionID;
    protected String vcID;
    protected String entityKeyString = null;
    protected List entityChanges = new Vector(0);
    protected Map valueMetaDataMap = new Hashtable();
    protected EntityChangeList parentChangeList = null;
    protected List relChangeLists = new Vector(0);

    public static void debugOut(String string) {
        EntityChangeList.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("EntityChangeList: " + string, n);
    }

    public static List getFilteredChanges(List list) {
        int n;
        Vector vector = new Vector(list);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((EntityChange)object).getTimeStamp().compareTo(((EntityChange)object2).getTimeStamp());
            }
        };
        Collections.sort(vector, comparator);
        EntityChange[] entityChangeArray = vector.toArray(new EntityChange[0]);
        block0: for (int i = 0; i < entityChangeArray.length; ++i) {
            if (entityChangeArray[i] == null || entityChangeArray[i].getChangeStatus() != 1 || entityChangeArray[i].isInvertedDataCommit() || entityChangeArray[i].isSourceDataCommit()) continue;
            if (entityChangeArray[i].getChangeCategory() == 4) {
                for (n = 0; n < entityChangeArray.length; ++n) {
                    if (n == i) continue;
                    entityChangeArray[n] = null;
                }
                break;
            }
            for (n = i + 1; n < entityChangeArray.length; ++n) {
                if (entityChangeArray[n] == null || entityChangeArray[n].getChangeStatus() != 1 || entityChangeArray[n].isInvertedDataCommit() || entityChangeArray[n].isSourceDataCommit()) continue;
                if (EntityChange.areChangesNegating(entityChangeArray[i], entityChangeArray[n])) {
                    entityChangeArray[i] = null;
                    entityChangeArray[n] = null;
                    continue block0;
                }
                if (!EntityChange.areChangesEquivalent(entityChangeArray[i], entityChangeArray[n])) continue;
                entityChangeArray[n] = null;
            }
        }
        Vector<EntityChange> vector2 = new Vector<EntityChange>(0);
        for (n = 0; n < entityChangeArray.length; ++n) {
            if (entityChangeArray[n] == null) continue;
            vector2.add(entityChangeArray[n]);
        }
        return vector2;
    }

    public static void setEntityIDChange(Map map, EntityKey entityKey) {
        if (map != null && entityKey != null) {
            String string = entityKey.getEntityKeyString();
            EntityKey entityKey2 = (EntityKey)map.get(string);
            if (entityKey2 != null) {
                if (entityKey instanceof Entity) {
                    ((Entity)entityKey).setEntityID(entityKey2.getEntityID());
                    EntityChangeList.debugOut("Entity: Changed entity ID for: " + string + " to: " + entityKey.getEntityID() + ".");
                } else if (entityKey instanceof EntityChangeList) {
                    ((EntityChangeList)entityKey).setEntityID(entityKey2.getEntityID());
                    EntityChangeList.debugOut("EntityChangeList: Changed entity ID for: " + string + " to: " + entityKey.getEntityID() + ".");
                } else {
                    EntityChangeList.debugOut("Change found for entityID: " + string + " to: " + entityKey2.getEntityID() + " BUT change NOT made.");
                }
            } else {
                EntityChangeList.debugOut("No entity ID change for: " + string);
            }
        }
    }

    public EntityChangeList(EntityKey entityKey) {
        this(entityKey, null, true);
    }

    public EntityChangeList(EntityKey entityKey, boolean bl) {
        this(entityKey, null, bl);
    }

    public EntityChangeList(EntityKey entityKey, EntityChangeList entityChangeList, boolean bl) {
        this.entityTypeID = entityKey.getEntityTypeID();
        this.entityID = entityKey.getEntityID();
        this.institutionID = entityKey.getInstitutionID();
        this.collectionID = entityKey.getCollectionID();
        this.vcID = entityKey.getVCID();
        this.parentChangeList = entityChangeList;
        if (entityKey instanceof Entity) {
            this.setEntity((Entity)entityKey);
            if (bl) {
                this.relChangeLists.clear();
                if (this.entityBefore != null && this.entityBefore.getRelatedEntities() != null) {
                    List list = this.entityBefore.getRelatedEntities();
                    for (int i = 0; list != null && i < list.size(); ++i) {
                        Entity entity = (Entity)list.get(i);
                        this.addRelatedEntityChangeList(entity);
                    }
                }
            }
        }
    }

    public void registerFieldValue(int n, String string) {
        this.registerFieldValue(n, string, null);
    }

    public void registerFieldValue(int n, String string, Map map) {
        if (string != null && string.length() > 0) {
            EntityFieldValue entityFieldValue = this.getFieldValue(n, true);
            entityFieldValue.addValue(string);
            this.registerValueMetaData(n, string, map);
        }
    }

    public void registerRelatedEntity(Entity entity) {
        if (!(entity == null || Entity.isTempEntityID(entity.getEntityID()) && !entity.getEntityType().isDependent() || this.entityBefore.equals(entity))) {
            if (this.relEntitiesAfter == null) {
                this.relEntitiesAfter = new Vector(1);
            }
            if (!this.relEntitiesAfter.contains(entity)) {
                this.relEntitiesAfter.add(entity);
                this.addRelatedEntityChangeList(entity);
            }
        }
    }

    public void registerValueMetaData(int n, String string, Map map) {
        if (InsightUtilities.isNonEmpty(string) && map != null) {
            EntityChangeList.debugOut("Registering meta data for fieldID: " + n + ", value: " + string);
            this.valueMetaDataMap.put(this.getValueMetaDataKey(n, string), map);
        }
    }

    public Map getValueMetaData(int n, String string) {
        Map map = null;
        if (InsightUtilities.isNonEmpty(string)) {
            map = (Map)this.valueMetaDataMap.get(this.getValueMetaDataKey(n, string));
        }
        return map;
    }

    public String getValueMetaDataKey(int n, String string) {
        return ("FID:" + n + "-Value:" + string).intern();
    }

    public void detectChanges() {
        EntityFieldChange entityFieldChange;
        String string;
        int n;
        List list;
        EntityFieldValue entityFieldValue;
        EntityFieldValue entityFieldValue2;
        int n2;
        if (Entity.isTempEntityID(this.entityID)) {
            this.entityChanges.add(new EntityAddChange(EntityChange.getNextTempChangeID(), 1, 1, -1, false, false, this.entityTypeID, this.entityID, -1, new SimpleDate()));
        }
        for (n2 = 0; this.entityBefore.getFieldValues() != null && n2 < this.entityBefore.getFieldValues().size(); ++n2) {
            entityFieldValue2 = (EntityFieldValue)this.entityBefore.getFieldValues().get(n2);
            entityFieldValue = this.getFieldValue(entityFieldValue2.getFieldID(), false);
            list = entityFieldValue2.getValues();
            for (n = 0; list != null && n < list.size(); ++n) {
                string = (String)list.get(n);
                if (entityFieldValue != null && entityFieldValue.containsValue(string)) continue;
                entityFieldChange = new EntityFieldChange(EntityChange.getNextTempChangeID(), 2, 1, -1, false, false, this.entityTypeID, this.entityID, -1, new SimpleDate(), entityFieldValue2.getFieldID(), string);
                entityFieldChange.setMetaData(null);
                this.entityChanges.add(entityFieldChange);
            }
        }
        for (n2 = 0; this.fieldValuesAfter != null && n2 < this.fieldValuesAfter.size(); ++n2) {
            entityFieldValue = (EntityFieldValue)this.fieldValuesAfter.get(n2);
            entityFieldValue2 = this.entityBefore.getFieldValue(entityFieldValue.getFieldID(), false);
            list = entityFieldValue.getValues();
            for (n = 0; list != null && n < list.size(); ++n) {
                string = (String)list.get(n);
                if (entityFieldValue2 != null && entityFieldValue2.containsValue(string)) continue;
                entityFieldChange = new EntityFieldChange(EntityChange.getNextTempChangeID(), 1, 1, -1, false, false, this.entityTypeID, this.entityID, -1, new SimpleDate(), entityFieldValue.getFieldID(), string);
                entityFieldChange.setMetaData(this.getValueMetaData(entityFieldValue.getFieldID(), string));
                this.entityChanges.add(entityFieldChange);
            }
        }
        for (n = 0; this.entityBefore.getRelatedEntities() != null && n < this.entityBefore.getRelatedEntities().size(); ++n) {
            Entity entity = (Entity)this.entityBefore.getRelatedEntities().get(n);
            if (entity == null || this.relEntitiesAfter != null && this.relEntitiesAfter.contains(entity)) continue;
            this.entityChanges.add(new EntityMapChange(EntityChange.getNextTempChangeID(), 2, 1, -1, false, false, this.entityTypeID, this.entityID, -1, new SimpleDate(), entity.getEntityTypeID(), entity.getEntityID()));
        }
        for (n = 0; this.relEntitiesAfter != null && n < this.relEntitiesAfter.size(); ++n) {
            Entity entity = (Entity)this.relEntitiesAfter.get(n);
            if (entity == null || this.entityBefore.getRelatedEntities() != null && this.entityBefore.getRelatedEntities().contains(entity)) continue;
            this.entityChanges.add(new EntityMapChange(EntityChange.getNextTempChangeID(), 1, 1, -1, false, false, this.entityTypeID, this.entityID, -1, new SimpleDate(), entity.getEntityTypeID(), entity.getEntityID()));
        }
        EntityChangeList.debugOut("in detectChanges(): entityBefore: " + (this.entityBefore != null ? this.entityBefore.getEntityKeyString() : null) + ", entityChanges: " + this.entityChanges);
        for (n = 0; this.relChangeLists != null && n < this.relChangeLists.size(); ++n) {
            ((EntityChangeList)this.relChangeLists.get(n)).detectChanges();
        }
    }

    public void updateEntity() {
        this.updateEntity(this.entityBefore, false);
    }

    public void updateEntity(Entity entity, boolean bl) {
        Serializable serializable;
        List list;
        if (entity != null) {
            int n;
            list = entity.getFieldValues();
            for (int i = 0; list != null && i < list.size(); ++i) {
                ((EntityFieldValue)list.get(i)).removeAllValues();
            }
            for (int i = 0; this.fieldValuesAfter != null && i < this.fieldValuesAfter.size(); ++i) {
                EntityFieldValue entityFieldValue = (EntityFieldValue)this.fieldValuesAfter.get(i);
                serializable = entity.getFieldValue(entityFieldValue.getFieldID(), true);
                if (serializable == null) continue;
                List list2 = entityFieldValue.getValues();
                for (n = 0; list2 != null && n < list2.size(); ++n) {
                    ((EntityFieldValue)serializable).addValue((String)list2.get(n));
                }
            }
            entity.removeAllRelatedEntities();
            for (n = 0; this.relEntitiesAfter != null && n < this.relEntitiesAfter.size(); ++n) {
                Entity entity2 = (Entity)this.relEntitiesAfter.get(n);
                if (bl) {
                    entity2 = Entity.copyEntityShallow(entity2);
                }
                entity.addRelatedEntity(entity2);
            }
        }
        list = entity != null ? entity.getRelatedEntities() : null;
        for (int i = 0; this.relChangeLists != null && i < this.relChangeLists.size(); ++i) {
            EntityChangeList entityChangeList = (EntityChangeList)this.relChangeLists.get(i);
            serializable = Entity.getEntity(list, entityChangeList);
            entityChangeList.updateEntity((Entity)serializable, bl);
        }
    }

    public Entity getUpdatedEntityCopy() {
        Entity entity = null;
        if (this.entityBefore != null) {
            entity = Entity.copyEntityShallow(this.entityBefore);
            this.updateEntity(entity, true);
        }
        return entity;
    }

    public boolean isChanged() {
        if (this.entityChanges.size() > 0) {
            return true;
        }
        for (int i = 0; this.relChangeLists != null && i < this.relChangeLists.size(); ++i) {
            if (!((EntityChangeList)this.relChangeLists.get(i)).isChanged()) continue;
            return true;
        }
        return false;
    }

    public void addEntityChanges(List list) {
        if (list != null && list.size() > 0) {
            this.entityChanges.addAll(list);
        }
    }

    public void addEntityChange(EntityChange entityChange) {
        if (entityChange != null) {
            this.entityChanges.add(entityChange);
        }
    }

    protected void addRelatedEntityChangeList(Entity entity) {
        if (entity != null && this.entityBefore != null && !this.entityBefore.equals(entity) && entity.getEntityType() != null && entity.getEntityType().isDependent() && Entity.getEntityKey(this.relChangeLists, entity.getEntityTypeID(), entity.getEntityID()) == null) {
            this.relChangeLists.add(new EntityChangeList(entity, this, true));
        }
    }

    protected void addDependentEntityChangeList(Entity entity) {
        if (Entity.getEntityKey(this.relChangeLists, entity.getEntityTypeID(), entity.getEntityID()) == null) {
            this.relChangeLists.add(new EntityChangeList(entity, this, true));
        }
    }

    public void setEntityID(long l) {
        this.entityKeyString = null;
        long l2 = this.entityID;
        this.entityID = l;
        for (int i = 0; this.entityChanges != null && i < this.entityChanges.size(); ++i) {
            ((EntityChange)this.entityChanges.get(i)).setEntityID(l);
        }
        if (this.parentChangeList != null) {
            this.parentChangeList.replaceRelatedEntity(this.getEntityTypeID(), l2, l);
        }
    }

    public void setUserID(int n) {
        int n2;
        this.userID = n;
        for (n2 = 0; this.entityChanges != null && n2 < this.entityChanges.size(); ++n2) {
            ((EntityChange)this.entityChanges.get(n2)).setUserID(n);
        }
        for (n2 = 0; this.relChangeLists != null && n2 < this.relChangeLists.size(); ++n2) {
            ((EntityChangeList)this.relChangeLists.get(n2)).setUserID(n);
        }
    }

    public void setApprovalLevel(int n) {
        int n2;
        for (n2 = 0; this.entityChanges != null && n2 < this.entityChanges.size(); ++n2) {
            ((EntityChange)this.entityChanges.get(n2)).setApprovalLevel(n);
        }
        for (n2 = 0; this.relChangeLists != null && n2 < this.relChangeLists.size(); ++n2) {
            ((EntityChangeList)this.relChangeLists.get(n2)).setApprovalLevel(n);
        }
    }

    public void setEntity(Entity entity) {
        this.entityBefore = entity;
    }

    public void setEntities(List list) {
        int n;
        this.setEntity(Entity.getEntity(list, this));
        for (n = 0; this.entityChanges != null && n < this.entityChanges.size(); ++n) {
            if (!(this.entityChanges.get(n) instanceof EntityMapChange)) continue;
            ((EntityMapChange)this.entityChanges.get(n)).setRelatedEntity(Entity.getEntity(list, ((EntityMapChange)this.entityChanges.get(n)).getRelatedEntityTypeID(), ((EntityMapChange)this.entityChanges.get(n)).getRelatedEntityID()));
        }
        for (n = 0; this.relChangeLists != null && n < this.relChangeLists.size(); ++n) {
            ((EntityChangeList)this.relChangeLists.get(n)).setEntities(list);
        }
    }

    public void setEntityIDChanges(Map map) {
        if (map != null && map.size() > 0) {
            int n;
            EntityChangeList.setEntityIDChange(map, this);
            EntityChangeList.setEntityIDChange(map, this.entityBefore);
            for (n = 0; this.entityChanges != null && n < this.entityChanges.size(); ++n) {
                if (!(this.entityChanges.get(n) instanceof EntityMapChange)) continue;
                EntityChangeList.setEntityIDChange(map, ((EntityMapChange)this.entityChanges.get(n)).getRelatedEntity());
            }
            for (n = 0; this.relChangeLists != null && n < this.relChangeLists.size(); ++n) {
                ((EntityChangeList)this.relChangeLists.get(n)).setEntityIDChanges(map);
            }
        }
    }

    public void setMediaFiles(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n;
            for (n = 0; this.entityChanges != null && n < this.entityChanges.size(); ++n) {
                if (!(this.entityChanges.get(n) instanceof EntityMediaMapChange)) continue;
                ((EntityMediaMapChange)this.entityChanges.get(n)).setMediaFile(ImageFile.getImageFile(vector, ((EntityMediaMapChange)this.entityChanges.get(n)).getMediaID()));
            }
            for (n = 0; this.relChangeLists != null && n < this.relChangeLists.size(); ++n) {
                ((EntityChangeList)this.relChangeLists.get(n)).setMediaFiles(vector);
            }
        }
    }

    public void replaceRelatedEntity(int n, long l, long l2) {
        for (int i = 0; this.entityChanges != null && i < this.entityChanges.size(); ++i) {
            EntityMapChange entityMapChange;
            if (!(this.entityChanges.get(i) instanceof EntityMapChange) || (entityMapChange = (EntityMapChange)this.entityChanges.get(i)).getRelatedEntityTypeID() != n || entityMapChange.getRelatedEntityID() != l) continue;
            entityMapChange.setRelatedEntityID(l2);
        }
    }

    public List getEntityChanges() {
        return this.entityChanges;
    }

    public List getEntityChangesDeep() {
        if (this.entityChanges == null) {
            return null;
        }
        Vector vector = new Vector(0);
        vector.addAll(this.entityChanges);
        for (int i = 0; this.relChangeLists != null && i < this.relChangeLists.size(); ++i) {
            EntityChangeList entityChangeList = (EntityChangeList)this.relChangeLists.get(i);
            List list = entityChangeList.getEntityChangesDeep();
            if (list == null || list.size() <= 0) continue;
            vector.addAll(list);
        }
        return vector;
    }

    public List getEntityChanges(int n, int n2) {
        Vector<EntityChange> vector = new Vector<EntityChange>(0);
        for (int i = 0; this.entityChanges != null && i < this.entityChanges.size(); ++i) {
            EntityChange entityChange = (EntityChange)this.entityChanges.get(i);
            if (entityChange.getChangeCategory() != n || entityChange.getChangeType() != n2) continue;
            vector.add(entityChange);
        }
        return vector;
    }

    public List getEntityChangesDeep(int n, int n2) {
        int n3;
        Vector<EntityChange> vector = new Vector<EntityChange>(0);
        for (n3 = 0; this.entityChanges != null && n3 < this.entityChanges.size(); ++n3) {
            EntityChange entityChange = (EntityChange)this.entityChanges.get(n3);
            if (entityChange.getChangeCategory() != n || entityChange.getChangeType() != n2) continue;
            vector.add(entityChange);
        }
        for (n3 = 0; this.relChangeLists != null && n3 < this.relChangeLists.size(); ++n3) {
            EntityChangeList entityChangeList = (EntityChangeList)this.relChangeLists.get(n3);
            List list = entityChangeList.getEntityChangesDeep(n, n2);
            if (list == null || list.size() <= 0) continue;
            vector.addAll(list);
        }
        return vector;
    }

    public List getFilteredChanges() {
        return EntityChangeList.getFilteredChanges(this.entityChanges);
    }

    public List getEntities() {
        Vector vector = new Vector();
        this.getEntities(vector);
        return vector;
    }

    protected void getEntities(List list) {
        if (list != null) {
            int n;
            Entity entity = this.getEntity();
            if (entity != null && Entity.getEntity(list, entity) == null) {
                list.add(entity);
            }
            for (n = 0; this.entityChanges != null && n < this.entityChanges.size(); ++n) {
                if (!(this.entityChanges.get(n) instanceof EntityMapChange) || (entity = ((EntityMapChange)this.entityChanges.get(n)).getRelatedEntity()) == null || Entity.getEntity(list, entity) != null) continue;
                list.add(entity);
            }
            for (n = 0; this.relChangeLists != null && n < this.relChangeLists.size(); ++n) {
                ((EntityChangeList)this.relChangeLists.get(n)).getEntities(list);
            }
        }
    }

    public List getEntityKeys() {
        Vector<EntityKey> vector = new Vector<EntityKey>(0);
        vector.add(this);
        for (int i = 0; this.entityChanges != null && i < this.entityChanges.size(); ++i) {
            if (!(this.entityChanges.get(i) instanceof EntityMapChange)) continue;
            vector.add(((EntityMapChange)this.entityChanges.get(i)).getRelatedEntityKey());
        }
        return vector;
    }

    public List getEntityKeysDeep() {
        List list = this.getEntityKeys();
        if (this.relChangeLists != null) {
            for (int i = 0; i < this.relChangeLists.size(); ++i) {
                EntityChangeList entityChangeList = (EntityChangeList)this.relChangeLists.get(i);
                list.addAll(entityChangeList.getEntityKeysDeep());
            }
        }
        return list;
    }

    public List getMediaIDs(List vector) {
        if (vector == null) {
            vector = new Vector<Long>(0);
        }
        for (int i = 0; this.entityChanges != null && i < this.entityChanges.size(); ++i) {
            Long l;
            if (!(this.entityChanges.get(i) instanceof EntityMediaMapChange) || vector.contains(l = new Long(((EntityMediaMapChange)this.entityChanges.get(i)).getMediaID()))) continue;
            vector.add(l);
        }
        return vector;
    }

    public EntityChangeList getRelatedChangeList(EntityKey entityKey) {
        if (entityKey != null && this.relChangeLists != null) {
            return (EntityChangeList)Entity.getEntityKey(this.relChangeLists, entityKey.getEntityTypeID(), entityKey.getEntityID());
        }
        return null;
    }

    public EntityChangeList getRelatedChangeListDeep(EntityKey entityKey) {
        EntityChangeList entityChangeList = null;
        if (entityKey != null && this.relChangeLists != null) {
            for (int i = 0; i < this.relChangeLists.size(); ++i) {
                EntityChangeList entityChangeList2 = (EntityChangeList)this.relChangeLists.get(i);
                if (entityChangeList2.getEntityTypeID() == entityKey.getEntityTypeID() && entityChangeList2.getEntityID() == entityKey.getEntityID()) {
                    entityChangeList = entityChangeList2;
                    break;
                }
                entityChangeList = entityChangeList2.getRelatedChangeListDeep(entityKey);
                if (entityChangeList != null) break;
            }
        }
        return entityChangeList;
    }

    public List getRelatedChangeLists() {
        return this.relChangeLists;
    }

    public EntityChangeList getParentChangeList() {
        return this.parentChangeList;
    }

    public int getUserID() {
        return this.userID;
    }

    public Entity getEntity() {
        return this.entityBefore;
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public long getEntityID() {
        return this.entityID;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public String getEntityKeyString() {
        if (InsightUtilities.isEmpty(this.entityKeyString)) {
            this.entityKeyString = EntityKeyWrapper.getEntityKeyString(this);
        }
        return this.entityKeyString;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            int n;
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
            this.entityKeyString = null;
            if (this.entityBefore != null) {
                this.entityBefore.setCollectionKey(collectionKey);
            }
            for (n = 0; this.entityChanges != null && n < this.entityChanges.size(); ++n) {
                ((EntityChange)this.entityChanges.get(n)).setCollectionKey(collectionKey);
            }
            for (n = 0; this.relChangeLists != null && n < this.relChangeLists.size(); ++n) {
                ((EntityChangeList)this.relChangeLists.get(n)).setCollectionKey(collectionKey);
            }
        }
    }

    public SimpleDate getLastChangeDate() {
        SimpleDate simpleDate = null;
        if (this.entityChanges == null) {
            return null;
        }
        for (int i = 0; i < this.entityChanges.size(); ++i) {
            EntityChange entityChange = (EntityChange)this.entityChanges.get(i);
            if (simpleDate != null && simpleDate.compareTo(entityChange.getTimeStamp()) >= 0) continue;
            simpleDate = entityChange.getTimeStamp();
        }
        return simpleDate;
    }

    public int getChangeCategory() {
        int n = 0;
        if (this.entityChanges != null && this.entityChanges.size() > 0) {
            n = ((EntityChange)this.entityChanges.get(0)).getChangeCategory();
        }
        if (n == 0 && this.relChangeLists != null) {
            for (int i = 0; i < this.relChangeLists.size(); ++i) {
                int n2 = ((EntityChangeList)this.relChangeLists.get(i)).getChangeCategory();
                if (n2 == 0) continue;
                return n2;
            }
        }
        return n;
    }

    public int compareTo(Object object) {
        return this.getEntityKeyString().compareToIgnoreCase(((EntityKey)object).getEntityKeyString());
    }

    protected EntityFieldValue getFieldValue(int n, boolean bl) {
        EntityFieldValue entityFieldValue = null;
        for (int i = 0; this.fieldValuesAfter != null && i < this.fieldValuesAfter.size(); ++i) {
            EntityFieldValue entityFieldValue2 = (EntityFieldValue)this.fieldValuesAfter.get(i);
            if (entityFieldValue2.getFieldID() != n) continue;
            entityFieldValue = entityFieldValue2;
            break;
        }
        if (entityFieldValue == null && bl) {
            entityFieldValue = new EntityFieldValue(n);
            if (this.fieldValuesAfter == null) {
                this.fieldValuesAfter = new Vector(1);
            }
            this.fieldValuesAfter.add(entityFieldValue);
        }
        return entityFieldValue;
    }
}

