/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.indexer.TrinityFieldProfile;
import java.util.List;

public class TrinityFlatObjectRecord
implements Comparable {
    protected long objectID;
    protected List thumbFields;
    protected List sortFields;
    protected String[] thumbData;
    protected String[] sortData;
    protected int sortOrder = 0;
    protected String sortString = null;
    protected int maxChars = -1;

    public TrinityFlatObjectRecord(long l, List list, List list2) {
        this.objectID = l;
        this.thumbFields = list;
        this.sortFields = list2;
    }

    public void setSortOrder(int n) {
        this.sortOrder = n;
    }

    public void addFieldValue(int n, String string, int n2) {
        int n3;
        this.maxChars = n2;
        String string2 = string;
        if (n2 > 0 && string2 != null && string2.length() > n2) {
            string2 = string2.substring(0, n2);
        }
        for (n3 = 0; n3 < this.thumbFields.size(); ++n3) {
            if (((TrinityFieldProfile)this.thumbFields.get((int)n3)).fieldID != n) continue;
            if (this.thumbData == null) {
                this.thumbData = new String[this.thumbFields.size()];
            }
            this.thumbData[n3] = string2;
        }
        if (this.sortData == null && this.sortFields.size() > 0) {
            this.sortData = new String[this.sortFields.size()];
        }
        for (n3 = 0; n3 < this.sortFields.size(); ++n3) {
            if (((TrinityFieldProfile)this.sortFields.get((int)n3)).fieldID != n) continue;
            this.sortData[n3] = string2;
        }
    }

    public String getInsertStatement(Integer n, String string, SqlQueryGenerator sqlQueryGenerator) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n.toString());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, this.objectID + "");
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SortDataVal", 1, stringBuffer2, this.getSortString());
        for (n2 = 0; this.thumbData != null && n2 < this.thumbData.length; ++n2) {
            if (this.thumbData[n2] == null) continue;
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbData" + (n2 + 1), 1, stringBuffer2, this.thumbData[n2]);
        }
        for (n2 = 0; this.sortData != null && n2 < this.sortData.length; ++n2) {
            if (this.sortData[n2] == null) continue;
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SortData" + (n2 + 1), 1, stringBuffer2, this.sortData[n2]);
        }
        return "INSERT INTO " + string + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")";
    }

    public String getSortString() {
        if (this.sortString == null || this.sortString.length() == 0) {
            if (this.sortString == null) {
                this.sortString = "";
            }
            for (int i = 0; this.sortData != null && i < this.sortData.length; ++i) {
                this.sortString = this.sortData[i] == null ? this.sortString + TrinityConnector.convertSortValue("ZZZZZ", this.maxChars > -1 ? this.maxChars : 30) : this.sortString + TrinityConnector.convertSortValue(this.sortData[i], this.maxChars > -1 ? this.maxChars : 30);
            }
        }
        if (this.sortString == null || this.sortString.length() == 0) {
            this.sortString = "ZZZZZ";
        }
        return this.sortString;
    }

    public int compareTo(Object object) {
        String string = this.getSortString();
        String string2 = ((TrinityFlatObjectRecord)object).getSortString();
        if (string.equals("")) {
            if (string2.equals("")) {
                return 0;
            }
            return 1;
        }
        if (string2.equals("")) {
            return -1;
        }
        return string.compareToIgnoreCase(string2);
    }
}

