/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.indexer.TrinityFieldGroup;
import com.luna.insight.server.indexer.TrinityFieldGrouping;
import com.luna.insight.server.indexer.TrinityJoin;
import com.luna.insight.server.indexer.TrinityTable;
import com.luna.insight.server.indexer.TrinityValueGrouping;
import java.io.Serializable;
import java.util.Vector;

public class TrinityField
implements Serializable,
Comparable {
    static final long serialVersionUID = -8320492645064277400L;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_DATE = 3;
    public static final String TYPE_CODE_TEXT = "T";
    public static final String TYPE_CODE_NUMBER = "N";
    public static final String TYPE_CODE_DATE = "D";
    public static final int DELIMITER_TYPE_MULTI_FIELD_NAME = 1;
    public static final int DELIMITER_TYPE_SINGLE_FIELD_NAME = 2;
    public static final int DELIMITER_TYPE_COMMA = 3;
    public static final int DELIMITER_TYPE_SEMI_COLON = 4;
    public int fieldID = 0;
    public TrinityFieldGroup fieldGroup = null;
    public String displayName = null;
    public int displayOrder = 0;
    public int fieldType = 0;
    public String sourceName = null;
    public TrinityTable table = null;
    public int joinID = 0;
    public TrinityJoin join = null;
    public int hierarchyID = 0;
    public boolean searchable = false;
    public String preferredFieldName = null;
    public String groupingFieldName = null;
    public TrinityTable groupingTable = null;
    public TrinityFieldGrouping fieldGrouping = null;
    public int delimiterType = 1;
    public Vector values = null;
    public TrinityValueGrouping[] valuesArray = null;

    public static int getType(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase(TYPE_CODE_TEXT)) {
                return 1;
            }
            if (string.equalsIgnoreCase(TYPE_CODE_NUMBER)) {
                return 2;
            }
            if (string.equalsIgnoreCase(TYPE_CODE_DATE)) {
                return 3;
            }
            return 0;
        }
        return 0;
    }

    public static String getTypeCode(int n) {
        if (n == 1) {
            return TYPE_CODE_TEXT;
        }
        if (n == 2) {
            return TYPE_CODE_NUMBER;
        }
        if (n == 3) {
            return TYPE_CODE_DATE;
        }
        return "";
    }

    public TrinityField() {
    }

    public TrinityField(int n, TrinityFieldGroup trinityFieldGroup, String string, int n2, String string2, TrinityTable trinityTable, TrinityJoin trinityJoin, int n3, boolean bl) {
        this.fieldID = n;
        this.fieldGroup = trinityFieldGroup;
        this.displayName = string;
        this.fieldType = n2;
        this.sourceName = string2;
        this.table = trinityTable;
        this.join = trinityJoin;
        this.hierarchyID = n3;
        this.searchable = bl;
    }

    public TrinityField(int n, String string, int n2, int n3, int n4, TrinityFieldGrouping trinityFieldGrouping) {
        this.fieldID = n;
        this.displayName = string;
        this.displayOrder = n2;
        this.fieldType = n3;
        this.fieldGrouping = trinityFieldGrouping;
        this.setDelimiterType(n4);
    }

    public void addValue(String string, String string2) {
        this.valuesArray = null;
        if (this.values == null) {
            this.values = new Vector();
        }
        this.values.addElement(new TrinityValueGrouping(string, string2));
    }

    public void setHierarchyID(int n) {
        this.hierarchyID = n;
    }

    public void setPreferredFieldName(String string) {
        this.preferredFieldName = string;
    }

    public void setGroupingFieldName(String string) {
        this.groupingFieldName = string;
    }

    public void setGroupingTable(TrinityTable trinityTable) {
        this.groupingTable = trinityTable;
    }

    public void setDelimiterType(int n) {
        this.delimiterType = n;
        if (this.delimiterType < 1 || this.delimiterType > 4) {
            this.delimiterType = 1;
        }
    }

    public void setType(String string) {
        this.fieldType = TrinityField.getType(string);
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public String getPreferredFieldName() {
        return this.preferredFieldName;
    }

    public String getGroupingFieldName() {
        return this.groupingFieldName;
    }

    public TrinityTable getGroupingTable() {
        return this.groupingTable;
    }

    public int getDelimiterType() {
        return this.delimiterType;
    }

    public boolean isKeywordSearchable() {
        return this.searchable;
    }

    public int getHierarchyID() {
        return this.hierarchyID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TrinityValueGrouping[] getValues() {
        if (this.values == null) {
            this.values = new Vector(0);
        }
        if (this.valuesArray == null) {
            this.valuesArray = new TrinityValueGrouping[this.values.size()];
            this.values.copyInto(this.valuesArray);
        }
        return this.valuesArray;
    }

    public Vector getValuesByGrouping(String string) {
        Vector<String> vector = new Vector<String>(1);
        if (string != null) {
            this.getValues();
            for (int i = 0; i < this.valuesArray.length; ++i) {
                if (!this.valuesArray[i].getGrouping().equals(string)) continue;
                vector.addElement(this.valuesArray[i].getValue());
            }
        }
        return vector;
    }

    public boolean equals(Object object) {
        if (object instanceof TrinityField) {
            TrinityField trinityField = (TrinityField)object;
            return this.fieldID == trinityField.fieldID;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.displayOrder + "-" + this.fieldID;
    }

    public int compareTo(Object object) {
        if (object instanceof TrinityField) {
            TrinityField trinityField = (TrinityField)object;
            if (this.displayOrder == trinityField.displayOrder) {
                return this.fieldID - trinityField.fieldID;
            }
            return this.displayOrder - trinityField.displayOrder;
        }
        return InsightUtilities.compareStrings(this.toString(), object.toString());
    }
}

