/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DiacriticMappings {
    public static final int DEFAULT_DEBUG_LEVEL = 3;
    public static final String PROPS_FILE = InsightUtilities.getUserDirFilepath("DiacriticMappings.dat");
    protected Properties properties;
    protected Hashtable mappings;
    protected int debugLevel = 3;
    protected char lowestKey = (char)65535;

    public static Properties loadProperties() {
        return DiacriticMappings.loadProperties(PROPS_FILE);
    }

    public static Properties loadProperties(File file) {
        if (file != null) {
            return DiacriticMappings.loadProperties(file.getPath());
        }
        return null;
    }

    public static Properties loadProperties(String string) {
        return InsightUtilities.loadProperties(string);
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(3);
        DiacriticMappings diacriticMappings = new DiacriticMappings();
        if (diacriticMappings.hasMappings()) {
            if (stringArray.length > 0) {
                DiacriticMappings.debugOut("Normalized: " + diacriticMappings.normalize(stringArray[0]));
            } else {
                DiacriticMappings.debugOut("No arguments given.");
            }
        } else {
            DiacriticMappings.debugOut("No mappings were created.");
        }
    }

    public static void debugOut(String string) {
        Debug.debugOut("DiacriticMappings: " + string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("DiacriticMappings: " + string, n);
    }

    public DiacriticMappings() {
        this(DiacriticMappings.loadProperties());
    }

    public DiacriticMappings(File file) {
        this(DiacriticMappings.loadProperties(file));
    }

    public DiacriticMappings(Properties properties) {
        this.properties = properties;
        if (this.properties != null) {
            DiacriticMappings.debugOut("Building diacritic mappings.");
            this.mappings = new Hashtable(150);
            String string = null;
            Character c = null;
            Character c2 = null;
            int n = 1;
            while ((string = this.properties.getProperty("DiacriticMapping" + n)) != null) {
                c = this.extractKey(string);
                c2 = this.extractValue(string);
                if (c == null || c2 == null) break;
                if (c.charValue() < this.lowestKey) {
                    this.lowestKey = c.charValue();
                }
                this.mappings.put(c, c2);
                ++n;
            }
            if (this.mappings != null) {
                DiacriticMappings.debugOut("The loaded mappings (as hexadecimal Unicode values):");
                DiacriticMappings.debugOut("  NOTE: The command prompt will display most special");
                DiacriticMappings.debugOut("        characters wrong.  Rely on the hex values for");
                DiacriticMappings.debugOut("        verfication.");
                DiacriticMappings.debugOut("");
                Enumeration enumeration = this.mappings.keys();
                while (enumeration.hasMoreElements()) {
                    Character c3 = (Character)enumeration.nextElement();
                    Character c4 = (Character)this.mappings.get(c3);
                    DiacriticMappings.debugOut("    " + c3 + " (" + Integer.toHexString(c3.charValue()) + ") -> " + c4 + " (" + Integer.toHexString(c4.charValue()) + ")");
                }
            }
        }
    }

    protected Character extractKey(String string) {
        Character c = null;
        if (string != null) {
            c = new Character(string.charAt(0));
        }
        return c;
    }

    protected Character extractValue(String string) {
        Character c = null;
        if (string != null) {
            c = new Character(string.charAt(2));
        }
        return c;
    }

    public String normalize(String string) {
        if (InsightUtilities.isNonEmpty(string)) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
            for (int i = 0; i < string.length(); ++i) {
                Character c = new Character(string.charAt(i));
                if (c.charValue() >= this.lowestKey && this.mappings != null) {
                    Character c2 = (Character)this.mappings.get(c);
                    if (c2 != null) {
                        stringBuffer.append(c2.charValue());
                        continue;
                    }
                    stringBuffer.append(c.charValue());
                    continue;
                }
                stringBuffer.append(c.charValue());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean hasMappings() {
        boolean bl = false;
        if (this.mappings != null && this.mappings.size() > 0) {
            bl = true;
        }
        return bl;
    }
}

