/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.core.license.InsightLicenseNamedUsers;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.DefaultTheme;
import com.luna.insight.server.AudioFieldCriterion;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.DateCriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldMappingGroup;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldStandardsManager;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.FieldValueGroup;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.InsightDataAnchor;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightSmartServer;
import com.luna.insight.server.InsightSmartServicer;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.IscrMap;
import com.luna.insight.server.KeywordsFieldCriterion;
import com.luna.insight.server.MediaField;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.MiscFieldCriterion;
import com.luna.insight.server.MultiObjectIndicatorFieldCriterion;
import com.luna.insight.server.MutableInteger;
import com.luna.insight.server.MutableLong;
import com.luna.insight.server.ObjectDataRecord;
import com.luna.insight.server.ObjectDimension;
import com.luna.insight.server.ObjectIndicatorFieldCriterion;
import com.luna.insight.server.QtvrFieldCriterion;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.SpsRecord;
import com.luna.insight.server.StringCriterionValue;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.VideoFieldCriterion;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.InsightBackendConnector;
import com.luna.insight.server.backend.InsightTableNames;
import com.luna.insight.server.backend.SqlColumnSelection;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.UniqueListCache;
import com.luna.insight.server.hierarchy.HierarchyAncillaryData;
import com.luna.insight.server.hierarchy.HierarchyNodeData;
import com.luna.insight.server.hierarchy.HierarchyNodeFieldCriterion;
import com.luna.insight.server.hierarchy.HierarchyNodePath;
import com.luna.insight.server.hierarchy.ThesaurusRelationType;
import com.luna.insight.server.indexer.TrinityField;
import com.luna.insight.server.indexer.TrinityFieldGrouping;
import com.luna.insight.server.indexer.TrinityFieldProfile;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityIndexer;
import com.luna.insight.server.links.LinkFieldCriterion;
import com.luna.insight.server.links.LinkFieldMapping;
import com.luna.insight.server.links.LinkFieldStandard;
import com.luna.insight.server.mediacreation.IMediaBatch;
import com.luna.insight.server.mediacreation.IMediaBatchElement;
import com.luna.insight.server.mediacreation.IMediaBatchProfile;
import com.luna.insight.server.mediacreation.MediaBatch;
import com.luna.insight.server.mediacreation.MediaBatchElement;
import com.luna.insight.server.mpd.MpdFieldCriterion;
import com.luna.insight.server.mpd.MpdSearchResults;
import com.luna.insight.server.mvi.MviFieldCriterion;
import com.luna.insight.server.personalcollections.PersonalCollection;
import com.luna.insight.server.profile.CollectionProfileKey;
import com.luna.insight.server.ucb.FuzzyDateFieldCriterion;
import com.luna.insight.server.usergroup.CollectionUserGroupKey;
import com.luna.insight.server.usergroup.UserGroup;
import java.awt.Dimension;
import java.sql.Date;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TrinityConnector
extends InsightBackendConnector
implements InsightTableNames {
    public String TRINITY_VERSION_ID = InsightVersion.releaseName();
    public String TRINITY_COMPONENT_CODE = "TrinityConnector";
    public static float TRINITY_VERSION = 3.0f;
    public static String VALUE_NAME_TEXT = "ValueText";
    public static String VALUE_NAME_NUMBER = "ValueNumber";
    protected static final Object SEARCH_QUERY_ID_LOCK_OBJECT = new Object();
    protected static final Object HIERARCHY_ID_LOCK_OBJECT = new Object();
    protected static final Object BATCH_ELEMENT_ID_LOCK_OBJECT = new Object();
    protected static final Object USER_ID_LOCK_OBJECT = new Object();
    protected static final int HIERARCHY_LOCAL_FIELD_NODE_INDEX_INCREMENT = 100;
    protected static final UniqueListCache uniqueListCache = new UniqueListCache(3);
    protected String[] stopList = null;

    public static void clearuniqueListCache() {
        if (uniqueListCache != null) {
            uniqueListCache.clearCache();
        }
    }

    public static String convertSortValue(String string) {
        return TrinityConnector.convertSortValue(string, 30);
    }

    public static String convertSortValue(String string, int n) {
        if (string == null || string.length() == 0) {
            return "\uffff";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(Long.parseLong(string) + "");
            while (n - stringBuffer.length() > 0) {
                stringBuffer.insert(0, "0");
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string.toUpperCase();
    }

    public static String createFieldIDClause(String string, Vector vector) {
        Object[] objectArray = new Field[vector.size()];
        vector.copyInto(objectArray);
        return TrinityConnector.createFieldIDClause(string, (Field[])objectArray);
    }

    public static String createFieldIDClause(String string, Field[] fieldArray) {
        Vector<Integer> vector = new Vector<Integer>(0);
        for (int i = 0; fieldArray != null && i < fieldArray.length; ++i) {
            Integer n = new Integer(fieldArray[i].fieldID);
            if (vector.contains(n)) continue;
            vector.addElement(n);
        }
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.size() > 0) {
            stringBuffer.append(string2 + "FieldID IN (" + InsightUtilities.getListString(vector) + ")");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer = new StringBuffer("(" + stringBuffer.toString() + ")");
        }
        return stringBuffer.toString();
    }

    public static String createFieldIDClause(Vector vector, Vector vector2, String string) {
        return TrinityConnector.createFieldIDClause(vector.toArray(new TrinityFieldProfile[0]), vector2.toArray(new TrinityFieldProfile[0]), string);
    }

    public static String createFieldIDClause(TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, String string) {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < trinityFieldProfileArray.length; ++n) {
            if (trinityFieldProfileArray[n] == null || trinityFieldProfileArray[n].fieldName.equals("ImageID") || TrinityConnector.intExistsInVector(vector, trinityFieldProfileArray[n].fieldID)) continue;
            vector.addElement(new Integer(trinityFieldProfileArray[n].fieldID));
        }
        for (n = 0; n < trinityFieldProfileArray2.length; ++n) {
            if (trinityFieldProfileArray2[n] == null || trinityFieldProfileArray2[n].fieldName.equals("ImageID") || TrinityConnector.intExistsInVector(vector, trinityFieldProfileArray2[n].fieldID)) continue;
            vector.addElement(new Integer(trinityFieldProfileArray2[n].fieldID));
        }
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.size() > 0) {
            stringBuffer.append(string2 + "FieldID IN (" + InsightUtilities.getListString(vector) + ")");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer = new StringBuffer("(" + stringBuffer.toString() + ")");
        }
        return stringBuffer.toString();
    }

    public static boolean intExistsInVector(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            if ((Integer)vector.elementAt(i) != n) continue;
            return true;
        }
        return false;
    }

    public static String getFieldValue(DatabaseConnector databaseConnector) {
        String string = "";
        try {
            String string2 = databaseConnector.getFieldByName("TypeCode");
            string = TrinityConnector.getFieldValue(databaseConnector, TrinityConnector.getFieldValueName(string2));
            if (string2.equalsIgnoreCase("D")) {
                Date date = new Date(Long.parseLong(string));
                string = date.toString();
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public static String getFieldValue(DatabaseConnector databaseConnector, String string) {
        String string2 = "";
        try {
            string2 = databaseConnector.getFieldByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getFieldValueName(String string) {
        if (string.equalsIgnoreCase("T") || string.equalsIgnoreCase("D")) {
            return VALUE_NAME_TEXT;
        }
        return VALUE_NAME_NUMBER;
    }

    public static int getPreferredEntityTypeID(Integer n, DatabaseConnector databaseConnector, SqlQueryGenerator sqlQueryGenerator) {
        int n2 = EntityIndexer.DEFAULT_OBJ_ENTITY_TYPE_ID;
        try {
            sqlQueryGenerator.addTable("ISENTITYTYPES", null, "*");
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "TemplateID", "IRCOLLECTIONCONFIGURATIONINFO", "NativeStandardID", 0);
            sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeDisplayOrder");
            sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeDisplayName");
            sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeID");
            sqlQueryGenerator.appendToWhere("IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n);
            sqlQueryGenerator.appendToWhere("IsPreferredEntity = 1");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            Debug.debugOut("TrinityConnector: \"Preferred\" entity type ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("EntityTypeID");
                Debug.debugOut("TrinityConnector:   Entity type #" + n2, 3);
            } else {
                Debug.debugOut("TrinityConnector:   No \"preferred\" entity type defined.", 3);
            }
        }
        catch (Exception exception) {
            Debug.debugOut("TrinityConnector: Exception while getting \"preferred\" entity type ID:\n" + InsightUtilities.getStackTrace(exception), 3);
        }
        return n2;
    }

    public TrinityConnector(Hashtable hashtable) {
        super(hashtable);
        this.setVersionID(this.TRINITY_VERSION_ID);
        this.setComponentCode(this.TRINITY_COMPONENT_CODE);
        this.IG_TABLE_COLLECTION_INFO = "IRCOLLECTIONCONFIGURATIONINFO";
        this.IG_TABLE_FIELDS = "IRFIELDS";
        this.IG_TABLE_GROUP_IMAGE_MAP = "IRGROUPIMAGEMAP";
        this.IG_TABLE_GROUPS = "IRGROUPS";
        this.IG_TABLE_IMAGE_FILES = "IRIMAGEFILES";
        this.IG_TABLE_IMAGE_SERIES = "IRIMAGESERIES";
        this.IG_TABLE_IMAGE_SERIES_SLIDES = "IRIMAGESERIESSLIDES";
        this.IG_TABLE_INITIAL_SEARCH = "IRINITIALSEARCHCRITERIA";
        this.IG_TABLE_LPS = "IRLPS";
        this.IG_TABLE_MAX_IDS = "IRMAXIDS";
        this.IG_TABLE_OBJECT_IMAGE_MAP = "IROBJECTIMAGEMAP";
        this.IG_TABLE_PROFILE = "IRPROFILE";
        this.IG_TABLE_SPS = "IRSPS";
        this.IG_TABLE_VOCABULARY = "IRVOCABULARY";
    }

    public String getImplementationName() {
        return "Trinity " + this.dbConnectorGenerator.getConnectorTypeString() + " Insight Backend";
    }

    public boolean canEditObjects() {
        return false;
    }

    public Vector getInitialSearchCriteria(String string, String string2, String string3) {
        Vector<FieldCriterion> vector = new Vector<FieldCriterion>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable(this.IG_TABLE_INITIAL_SEARCH, null, "*");
            sqlQueryGenerator.addTable(this.IG_TABLE_FIELDS, null, "*");
            sqlQueryGenerator.addJoin(this.IG_TABLE_INITIAL_SEARCH, this.IG_TABLE_FIELDS, "FieldID", 0);
            sqlQueryGenerator.appendToWhere("((" + this.IG_TABLE_INITIAL_SEARCH + ".InstitutionID = " + this.prepStringForQuery(string) + ") AND (" + this.IG_TABLE_INITIAL_SEARCH + ".CollectionID = " + this.prepStringForQuery(string2) + ") AND (" + this.IG_TABLE_INITIAL_SEARCH + ".VCID = " + this.prepStringForQuery(string3) + ") AND (" + this.IG_TABLE_INITIAL_SEARCH + ".SearchType = 1))");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Initial search criteria query:\n" + databaseConnector.getQuery());
            TrinityConnector.debugFile("In initialSearchCriteria, about to run the query");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    FieldCriterion fieldCriterion = new FieldCriterion(databaseConnector.getIntegerFieldByName("BooleanOp"), databaseConnector.getIntegerFieldByName("EquivalenceOp"), new StringCriterionValue(databaseConnector.getFieldByName("Criterion")));
                    Field field = new Field(databaseConnector.getIntegerFieldByName("FieldId"), databaseConnector.getFieldByName("FieldName"), databaseConnector.getIntegerFieldByName("SearchType"));
                    field.fieldDisplayName = databaseConnector.getFieldByName("DisplayName");
                    field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                    fieldCriterion.field = field;
                    vector.addElement(fieldCriterion);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getInitialSearchCriteria():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public Field[] getFieldList(Integer n) {
        return this.getFieldList(n, false);
    }

    public Field[] getFieldList(Integer n, boolean bl) {
        Object[] objectArray;
        DatabaseConnector databaseConnector;
        block25: {
            databaseConnector = this.getDatabaseConnector();
            objectArray = new Field[]{};
            try {
                this.debugOut("in getFieldList().");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRFIELDS", null, "*");
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                if (n != null) {
                    sqlQueryGenerator.addJoin("ISENTITYFIELDS", "IRFIELDS", "FieldID", 0);
                    sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "ISENTITYFIELDS", "EntityTypeID", 0);
                    sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + this.getCollectionTemplateID(n));
                }
                sqlQueryGenerator.appendToWhere("(NOT IRFIELDS.FieldType = 0)");
                sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Field list query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block25;
                Vector<Field> vector = new Vector<Field>();
                int n2 = 0;
                this.debugOut("Suppress custom standard fields? " + bl);
                int n3 = 0;
                while (databaseConnector.more()) {
                    try {
                        n3 = databaseConnector.getIntegerField("CustomStandardID");
                    }
                    catch (Exception exception) {
                        n3 = 0;
                    }
                    if (!bl || n3 <= 0) {
                        Field field = new Field();
                        field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                        field.fieldName = databaseConnector.getFieldByName("FieldName");
                        field.fieldDisplayName = databaseConnector.getFieldByName("DisplayName");
                        field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                        field.fieldGroupID = databaseConnector.getIntegerField("FieldGroupID");
                        field.typeCode = databaseConnector.getFieldByName("TypeCode");
                        field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                        field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                        field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                        field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                        try {
                            field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            field.fieldType = 0;
                        }
                        try {
                            field.keywordSearchable = databaseConnector.getIntegerFieldByName("KeywordSearchable") == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.listMode = databaseConnector.getIntegerFieldByName("SelectListBehavior");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                        }
                        catch (Exception exception) {
                            field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                        }
                        if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                            try {
                                field.hierarchyName = this.getHierarchyName(databaseConnector.getIntegerFieldByName("HierarchyID"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (field.hierarchyName == null) {
                            field.hierarchyName = "";
                        }
                        vector.addElement(field);
                        if (n2 < 10) {
                            this.debugOut("0" + n2 + " " + field);
                        } else {
                            this.debugOut(n2 + " " + field);
                        }
                        ++n2;
                    }
                    databaseConnector.next();
                }
                objectArray = new Field[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFieldList():\n" + InsightUtilities.getStackTrace(exception));
                objectArray = new Field[]{};
            }
        }
        databaseConnector.close();
        return objectArray;
    }

    public Field[] getSearchableFieldList(Integer n) {
        return this.getSearchableFieldList(n, false);
    }

    public Field[] getSearchableFieldList(Integer n, boolean bl) {
        Object[] objectArray;
        DatabaseConnector databaseConnector;
        block24: {
            databaseConnector = this.getDatabaseConnector();
            objectArray = new Field[]{};
            try {
                this.debugOut("in getSearchableFieldList().");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRFIELDS", null, "*");
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.addJoin("ISENTITYFIELDS", "IRFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "ISENTITYFIELDS", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + this.getCollectionTemplateID(n));
                sqlQueryGenerator.appendToWhere("(DataFieldSearchable = 1) AND (NOT IRFIELDS.FieldType = 0)");
                sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Searchable field list query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block24;
                Vector<Field> vector = new Vector<Field>();
                int n2 = 0;
                this.debugOut("Suppress custom standard fields? " + bl);
                int n3 = 0;
                while (databaseConnector.more()) {
                    try {
                        n3 = databaseConnector.getIntegerField("CustomStandardID");
                    }
                    catch (Exception exception) {
                        n3 = 0;
                    }
                    if (!bl || n3 <= 0) {
                        Field field = new Field();
                        field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                        field.fieldName = databaseConnector.getFieldByName("FieldName");
                        field.fieldDisplayName = databaseConnector.getFieldByName("DisplayName");
                        field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                        field.fieldGroupID = databaseConnector.getIntegerField("FieldGroupID");
                        field.typeCode = databaseConnector.getFieldByName("TypeCode");
                        field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                        field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                        field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                        field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                        try {
                            field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            field.fieldType = 0;
                        }
                        try {
                            field.keywordSearchable = databaseConnector.getIntegerFieldByName("KeywordSearchable") == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.listMode = databaseConnector.getIntegerFieldByName("SelectListBehavior");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                        }
                        catch (Exception exception) {
                            field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                        }
                        if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                            try {
                                field.hierarchyName = this.getHierarchyName(databaseConnector.getIntegerFieldByName("HierarchyID"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (field.hierarchyName == null) {
                            field.hierarchyName = "";
                        }
                        vector.addElement(field);
                        if (n2 < 10) {
                            this.debugOut("0" + n2 + " " + field);
                        } else {
                            this.debugOut(n2 + " " + field);
                        }
                        ++n2;
                    }
                    databaseConnector.next();
                }
                objectArray = new Field[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getSearchableFieldList():\n" + InsightUtilities.getStackTrace(exception));
                objectArray = new Field[]{};
            }
        }
        databaseConnector.close();
        return objectArray;
    }

    public Field[] getPickableFieldList(Integer n) {
        return this.getPickableFieldList(n, false);
    }

    public Field[] getPickableFieldList(Integer n, boolean bl) {
        Object[] objectArray;
        DatabaseConnector databaseConnector;
        block24: {
            databaseConnector = this.getDatabaseConnector();
            objectArray = new Field[]{};
            try {
                this.debugOut("in getPickableFieldList().");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRFIELDS", null, "*");
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.addJoin("ISENTITYFIELDS", "IRFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "ISENTITYFIELDS", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + this.getCollectionTemplateID(n));
                sqlQueryGenerator.appendToWhere("SearchPick = 1");
                sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Pickable field list query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block24;
                Vector<Field> vector = new Vector<Field>();
                int n2 = 0;
                this.debugOut("Suppress custom standard fields? " + bl);
                int n3 = 0;
                while (databaseConnector.more()) {
                    try {
                        n3 = databaseConnector.getIntegerField("CustomStandardID");
                    }
                    catch (Exception exception) {
                        n3 = 0;
                    }
                    if (!bl || n3 <= 0) {
                        Field field = new Field();
                        field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                        field.fieldName = databaseConnector.getFieldByName("FieldName");
                        field.fieldDisplayName = databaseConnector.getFieldByName("DisplayName");
                        field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                        field.fieldGroupID = databaseConnector.getIntegerField("FieldGroupID");
                        field.typeCode = databaseConnector.getFieldByName("TypeCode");
                        field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                        field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                        field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                        field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                        try {
                            field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            field.fieldType = 0;
                        }
                        try {
                            field.keywordSearchable = databaseConnector.getIntegerFieldByName("KeywordSearchable") == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.listMode = databaseConnector.getIntegerFieldByName("SelectListBehavior");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                        }
                        catch (Exception exception) {
                            field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                        }
                        if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                            try {
                                field.hierarchyName = this.getHierarchyName(databaseConnector.getIntegerFieldByName("HierarchyID"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (field.hierarchyName == null) {
                            field.hierarchyName = "";
                        }
                        vector.addElement(field);
                        if (n2 < 10) {
                            this.debugOut("0" + n2 + " " + field);
                        } else {
                            this.debugOut(n2 + " " + field);
                        }
                        ++n2;
                    }
                    databaseConnector.next();
                }
                objectArray = new Field[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getPickableFieldList():\n" + InsightUtilities.getStackTrace(exception));
                objectArray = new Field[]{};
            }
        }
        databaseConnector.close();
        return objectArray;
    }

    public Field getField(String string, Integer n) {
        DatabaseConnector databaseConnector;
        Field field;
        block22: {
            field = new Field();
            databaseConnector = this.getDatabaseConnector();
            try {
                this.debugOut("in getField(" + string + ").");
                boolean bl = false;
                try {
                    Integer.parseInt(string);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRFIELDS", null, "*");
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin("IRFIELDS", "ISENTITYFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("ISENTITYFIELDS", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + n);
                if (bl) {
                    sqlQueryGenerator.appendToWhere("(IRFIELDS.FieldID = " + string + ")");
                } else {
                    sqlQueryGenerator.appendToWhere("(IRFIELDS.FieldName = " + this.prepStringForQuery(string) + ")");
                }
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Field query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block22;
                field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                field.fieldName = databaseConnector.getFieldByName("FieldName");
                field.fieldDisplayName = databaseConnector.getFieldByName("DisplayName");
                field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                field.typeCode = databaseConnector.getFieldByName("TypeCode");
                field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                try {
                    field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                }
                catch (NumberFormatException numberFormatException) {
                    field.fieldType = 0;
                }
                try {
                    field.keywordSearchable = databaseConnector.getIntegerFieldByName("KeywordSearchable") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.listMode = databaseConnector.getIntegerFieldByName("SelectListBehavior");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                }
                catch (Exception exception) {
                    field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                }
                if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                    try {
                        field.hierarchyName = this.getHierarchyName(databaseConnector.getIntegerFieldByName("HierarchyID"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (field.hierarchyName == null) {
                    field.hierarchyName = "";
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getField(): " + exception);
                field = new Field();
            }
        }
        databaseConnector.close();
        return field;
    }

    public ObjectDimension getObjectDimension(Integer n, long l) {
        DatabaseConnector databaseConnector;
        ObjectDimension objectDimension;
        block34: {
            this.debugOut("getObjectDimension(), image ID: " + l);
            objectDimension = new ObjectDimension(l);
            databaseConnector = this.getDatabaseConnector();
            try {
                int n2;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IROBJECTDIMENSION", null, "*");
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Dimension query(1): \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block34;
                int n3 = databaseConnector.getIntegerFieldByName("WidthFieldID");
                int n4 = databaseConnector.getIntegerFieldByName("HeightFieldID");
                objectDimension.metric = n2 = databaseConnector.getIntegerFieldByName("Metric");
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                String string = null;
                String string2 = null;
                String string3 = null;
                boolean bl = true;
                try {
                    if (databaseConnector.getIntegerFieldByName("WidthQualifierFieldID") > 0) {
                        n5 = databaseConnector.getIntegerFieldByName("WidthQualifierFieldID");
                    } else {
                        bl = false;
                    }
                    if (databaseConnector.getFieldByName("WidthQualifierValue") != null && !databaseConnector.getFieldByName("WidthQualifierValue").equals("")) {
                        string = databaseConnector.getFieldByName("WidthQualifierValue");
                    } else {
                        bl = false;
                    }
                    if (databaseConnector.getIntegerFieldByName("WidthMetricFieldID") > 0) {
                        n8 = databaseConnector.getIntegerFieldByName("WidthMetricFieldID");
                    } else {
                        bl = false;
                    }
                    if (databaseConnector.getIntegerFieldByName("HeightQualifierFieldID") > 0) {
                        n6 = databaseConnector.getIntegerFieldByName("HeightQualifierFieldID");
                    } else {
                        bl = false;
                    }
                    if (databaseConnector.getFieldByName("HeightQualifierValue") != null && !databaseConnector.getFieldByName("HeightQualifierValue").equals("")) {
                        string2 = databaseConnector.getFieldByName("HeightQualifierValue");
                    } else {
                        bl = false;
                    }
                    if (databaseConnector.getIntegerFieldByName("HeightMetricFieldID") > 0) {
                        n7 = databaseConnector.getIntegerFieldByName("HeightMetricFieldID");
                    } else {
                        bl = false;
                    }
                    if (databaseConnector.getFieldByName("MetricNameMap") != null && !databaseConnector.getFieldByName("MetricNameMap").equals("")) {
                        string3 = databaseConnector.getFieldByName("MetricNameMap");
                    } else {
                        bl = false;
                    }
                    this.debugOut("end getting new fields");
                }
                catch (Exception exception) {
                    bl = false;
                }
                sqlQueryGenerator.clear();
                sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, "ObjectID");
                sqlQueryGenerator.addTable("DTVALUES", null, "*");
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, "Grouping");
                sqlQueryGenerator.addTable("IRFIELDS", null, new String[0]);
                sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", "ValueID", 0);
                sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "IROBJECTIMAGEMAP", "ObjectID", 0);
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + n);
                if (bl) {
                    ObjectDimension.initDimensionQualifiers(string, string2);
                    ObjectDimension.initMetricNameMap(string3);
                    String string4 = "";
                    Vector<String> vector = new Vector<String>();
                    vector.add(Integer.toString(n5));
                    vector.add(Integer.toString(n6));
                    vector.add(Integer.toString(n7));
                    vector.add(Integer.toString(n8));
                    vector.add(Integer.toString(n3));
                    vector.add(Integer.toString(n4));
                    String string5 = InsightUtilities.getUniqueListString(vector);
                    sqlQueryGenerator.appendToWhere("((IROBJECTIMAGEMAP.ImageID = " + l + ") AND (" + "DTVALUES" + ".FieldID IN (" + string5 + ")))");
                    sqlQueryGenerator.addOrderBy("DTVALUETOOBJECT", "Grouping");
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Dimension query(2): \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        objectDimension.objectID = databaseConnector.getLongField("ObjectID");
                        String string6 = null;
                        String string7 = null;
                        String string8 = null;
                        String string9 = null;
                        String string10 = null;
                        String string11 = null;
                        String string12 = null;
                        long l2 = databaseConnector.getLongField("Grouping");
                        boolean bl2 = false;
                        while (databaseConnector.more()) {
                            int n9 = databaseConnector.getIntegerFieldByName("FieldID");
                            if (databaseConnector.getLongField("Grouping") == l2) {
                                String string13 = TrinityConnector.getFieldValue(databaseConnector);
                                if (n9 == n3) {
                                    string8 = string13;
                                }
                                if (n9 == n5) {
                                    string11 = string13;
                                }
                                if (n9 == n8) {
                                    string12 = string13;
                                }
                                databaseConnector.next();
                            } else {
                                bl2 = true;
                                l2 = databaseConnector.getLongField("Grouping");
                            }
                            if (!bl2 && databaseConnector.more()) continue;
                            if (ObjectDimension.isWidthDimension(string11)) {
                                string6 = string8;
                                string10 = string12;
                            } else if (ObjectDimension.isHeightDimension(string11)) {
                                string7 = string8;
                                string9 = string12;
                            }
                            string8 = "";
                            string12 = "";
                            string11 = "";
                            bl2 = false;
                        }
                        objectDimension.convertDimension(string6, string10, string7, string9, n2);
                    }
                } else {
                    sqlQueryGenerator.appendToWhere("((IROBJECTIMAGEMAP.ImageID = " + l + ") AND ((" + "DTVALUES" + ".FieldID = " + n3 + ") OR (" + "DTVALUES" + ".FieldID = " + n4 + ")))");
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Dimension query(2): \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        objectDimension.objectID = databaseConnector.getLongField("ObjectID");
                        String string14 = null;
                        String string15 = null;
                        while (databaseConnector.more()) {
                            int n10 = databaseConnector.getIntegerFieldByName("FieldID");
                            if (n10 == n3) {
                                string14 = TrinityConnector.getFieldValue(databaseConnector);
                            }
                            if (n10 == n4) {
                                string15 = TrinityConnector.getFieldValue(databaseConnector);
                            }
                            databaseConnector.next();
                        }
                        objectDimension.convertDimension(string14, string15);
                    }
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getObjectDimension: " + exception);
            }
        }
        databaseConnector.close();
        return objectDimension;
    }

    public FieldValue[] getFullInformation(long l) {
        this.debugOut("getFullInformation, objectID: " + l);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRFIELDGROUPS", null, new String[]{"DisplayOrder AS GroupDisplayOrder", "FieldGroupType", "DisplayName AS FieldGroupDisplayName"});
        sqlQueryGenerator.addTable("IRFIELDS", null, new String[]{"DisplayOrder AS FieldDisplayOrder", "FieldGroupID", "FieldID", "DisplayName AS FieldDisplayName", "FieldType", "DelimiterType"});
        sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
        sqlQueryGenerator.addTable("DTVALUES", null, "*");
        sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, new String[]{"Grouping", "ObjectID"});
        sqlQueryGenerator.addJoin("IRFIELDGROUPS", "IRFIELDS", "FieldGroupID", 0);
        sqlQueryGenerator.addJoin("IRFIELDS", "DTVALUES", "FieldID", 0);
        sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", "ValueID", 0);
        sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
        sqlQueryGenerator.appendToWhere("((DTVALUETOOBJECT.ObjectID = " + l + ") AND (" + "DTVALUES" + ".Enabled = 1) AND (" + "IRFIELDS" + ".DisplayedInData = 1) AND (NOT (" + "IRFIELDS" + ".FieldType = 0)))");
        sqlQueryGenerator.addOrderBy("IRFIELDGROUPS", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("IRFIELDGROUPS", "FieldGroupID");
        sqlQueryGenerator.addOrderBy("DTVALUETOOBJECT", "Grouping");
        sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("IRFIELDS", "FieldID");
        sqlQueryGenerator.addOrderBy("DTVALUETOOBJECT", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("DTVALUES", "ValueID");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Full info query: \n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            this.debugOut("At least one element found.");
            Vector<TrinityFieldGrouping> vector = new Vector<TrinityFieldGrouping>();
            TrinityFieldGrouping trinityFieldGrouping = null;
            TrinityField trinityField = null;
            String string = null;
            while (databaseConnector.more()) {
                try {
                    if (trinityFieldGrouping == null) {
                        trinityFieldGrouping = new TrinityFieldGrouping(databaseConnector.getIntegerFieldByName("FieldGroupID"), databaseConnector.getFieldByName("FieldGroupDisplayName"), databaseConnector.getIntegerFieldByName("FieldGroupType"));
                    } else if (trinityFieldGrouping.getFieldGroupID() != databaseConnector.getIntegerFieldByName("FieldGroupID")) {
                        if (vector.size() == 0 || trinityFieldGrouping != vector.lastElement()) {
                            vector.addElement(trinityFieldGrouping);
                        }
                        trinityFieldGrouping = new TrinityFieldGrouping(databaseConnector.getIntegerFieldByName("FieldGroupID"), databaseConnector.getFieldByName("FieldGroupDisplayName"), databaseConnector.getIntegerFieldByName("FieldGroupType"));
                    }
                    trinityField = new TrinityField(databaseConnector.getIntegerFieldByName("FieldID"), databaseConnector.getFieldByName("FieldDisplayName"), databaseConnector.getIntegerFieldByName("FieldDisplayOrder"), databaseConnector.getIntegerFieldByName("FieldType"), databaseConnector.getIntegerFieldByName("DelimiterType"), trinityFieldGrouping);
                    string = TrinityConnector.getFieldValue(databaseConnector);
                    trinityFieldGrouping.addFieldData(trinityField, string, databaseConnector.getFieldByName("Grouping"));
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getFullInformation(): " + exception);
                }
                databaseConnector.next();
                if (databaseConnector.more() || trinityFieldGrouping == null || vector.size() != 0 && trinityFieldGrouping == vector.lastElement()) continue;
                vector.addElement(trinityFieldGrouping);
            }
            databaseConnector.close();
            Vector vector2 = new Vector();
            TrinityFieldGrouping trinityFieldGrouping2 = null;
            Vector vector3 = null;
            for (int i = 0; i < vector.size(); ++i) {
                trinityFieldGrouping2 = (TrinityFieldGrouping)vector.elementAt(i);
                vector3 = trinityFieldGrouping2.getFormattedFieldData();
                for (int j = 0; j < vector3.size(); ++j) {
                    vector2.addElement(vector3.elementAt(j));
                }
            }
            Object[] objectArray = new FieldValue[vector2.size()];
            vector2.copyInto(objectArray);
            return objectArray;
        }
        this.debugOut("No matching elements.");
        databaseConnector.close();
        return new FieldValue[0];
    }

    public ObjectDataRecord getFullObjectData(long l, FieldStandardsManager fieldStandardsManager, String string) {
        this.debugOut("getFullObjectData, objectID: " + l);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRFIELDGROUPS", null, new String[]{"DisplayOrder AS GroupDisplayOrder", "FieldGroupType", "DisplayName AS FieldGroupDisplayName"});
        sqlQueryGenerator.addTable("IRFIELDS", null, new String[]{"DisplayOrder AS FieldDisplayOrder", "FieldGroupID", "FieldID", "DisplayName AS FieldDisplayName", "FieldType", "DelimiterType"});
        sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
        sqlQueryGenerator.addTable("DTVALUES", null, "*");
        sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, new String[]{"Grouping", "ObjectID"});
        sqlQueryGenerator.addJoin("IRFIELDGROUPS", "IRFIELDS", "FieldGroupID", 0);
        sqlQueryGenerator.addJoin("IRFIELDS", "DTVALUES", "FieldID", 0);
        sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", "ValueID", 0);
        sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
        sqlQueryGenerator.appendToWhere("((DTVALUETOOBJECT.ObjectID = " + l + ")" + " AND (" + "DTVALUES" + ".Enabled = 1)" + " AND (" + "IRFIELDS" + ".DisplayedInData = 1)" + " AND (NOT (" + "IRFIELDS" + ".FieldType = 0)))");
        sqlQueryGenerator.addOrderBy("IRFIELDGROUPS", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("IRFIELDGROUPS", "FieldGroupID");
        sqlQueryGenerator.addOrderBy("DTVALUETOOBJECT", "Grouping");
        sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("IRFIELDS", "FieldID");
        sqlQueryGenerator.addOrderBy("DTVALUETOOBJECT", "DisplayOrder");
        sqlQueryGenerator.addOrderBy("DTVALUES", "ValueID");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Full info query: \n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            Object object;
            this.debugOut("At least one element found.");
            String string2 = null;
            Vector<Object> vector = new Vector<Object>();
            Vector<FieldValueGroup> vector2 = new Vector<FieldValueGroup>();
            FieldValueGroup fieldValueGroup = null;
            Object object2 = null;
            boolean bl = true;
            while (databaseConnector.more()) {
                try {
                    string2 = TrinityConnector.getFieldValue(databaseConnector);
                    object = new FieldValue(databaseConnector.getIntegerFieldByName("FieldID"), databaseConnector.getFieldByName("FieldDisplayName"), string2, false);
                    Field field = null;
                    FieldMapping fieldMapping = null;
                    if (string != null && string.length() > 0) {
                        field = fieldStandardsManager.getFieldInStandardByID(string, ((FieldValue)object).getFieldID());
                        fieldMapping = fieldStandardsManager.getFieldMappingInStandardByID(string, ((FieldValue)object).getFieldID());
                    } else {
                        field = fieldStandardsManager.getFieldByID(((FieldValue)object).getFieldID());
                    }
                    if (field != null) {
                        ((FieldValue)object).field = field;
                    }
                    if (fieldMapping != null) {
                        ((FieldValue)object).fieldMapping = fieldMapping;
                    }
                    int n = (int)databaseConnector.getLongField("Grouping");
                    int n2 = databaseConnector.getIntegerFieldByName("FieldGroupID");
                    if (n > 0) {
                        if (fieldValueGroup == null) {
                            fieldValueGroup = new FieldValueGroup(databaseConnector.getIntegerField("FieldGroupID"), databaseConnector.getFieldByName("FieldGroupDisplayName"), databaseConnector.getIntegerField("FieldGroupType"), databaseConnector.getIntegerField("GroupDisplayOrder"), n);
                            vector2.add(fieldValueGroup);
                            fieldValueGroup.addFieldValue((FieldValue)object);
                            object2 = object;
                        } else if (n2 != fieldValueGroup.getFieldGroupID() || n != fieldValueGroup.getGrouping()) {
                            fieldValueGroup = new FieldValueGroup(databaseConnector.getIntegerField("FieldGroupID"), databaseConnector.getFieldByName("FieldGroupDisplayName"), databaseConnector.getIntegerField("FieldGroupType"), databaseConnector.getIntegerField("GroupDisplayOrder"), n);
                            vector2.add(fieldValueGroup);
                            fieldValueGroup.addFieldValue((FieldValue)object);
                            object2 = object;
                        } else if (((FieldValue)object2).getFieldID() == ((FieldValue)object).getFieldID()) {
                            ((FieldValue)object2).addValue(string2);
                        } else {
                            fieldValueGroup.addFieldValue((FieldValue)object);
                            object2 = object;
                        }
                        bl = false;
                    } else if (object2 != null && ((FieldValue)object2).getFieldID() == ((FieldValue)object).getFieldID() && bl) {
                        ((FieldValue)object2).addValue(string2);
                    } else {
                        boolean bl2 = true;
                        for (int i = 0; vector != null && i < vector.size(); ++i) {
                            FieldMapping fieldMapping2 = ((FieldValue)vector.get(i)).getFieldMapping();
                            if (fieldMapping2 == null || ((FieldValue)object).getFieldMapping() != fieldMapping2) continue;
                            bl2 = false;
                            break;
                        }
                        if (bl2) {
                            vector.add(object);
                        }
                        object2 = object;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getFullObjectData():\n" + InsightUtilities.getStackTrace(exception));
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            object = new ObjectDataRecord();
            object.setFieldValues(vector);
            if (vector2.size() > 0) {
                object.setGroupedFieldValues(vector2);
            }
            object.setObjectID(l);
            return object;
        }
        this.debugOut("No matching elements.");
        databaseConnector.close();
        return null;
    }

    public Vector getImagesInGroup(int n, int n2, int n3, CollectionKey collectionKey, Vector vector) {
        this.debugOut("in getImagesInGroup.");
        Vector<ImageInGroup> vector2 = new Vector<ImageInGroup>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            boolean bl;
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, new String[]{"GroupID", "ImageID", "MpdSeries", "AbsoluteOrder"});
            sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[]{"ObjectID"});
            sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"ResolutionSize", "MediaType", "Format", "Width", "Height", "Filename"});
            sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_OBJECT_IMAGE_MAP, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.appendToWhere(this.constructVirtualGroupQuery(this.IG_TABLE_GROUP_IMAGE_MAP, n));
            boolean bl2 = bl = n2 >= 0 || n3 >= 0;
            if (bl) {
                sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
                sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
                sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_IMAGE_FILES, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_LPS, this.IG_TABLE_IMAGE_FILES, new String[]{"LPSid"}, 0);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".Format != 'SOURCE' AND " + this.IG_TABLE_SPS + ".SPSNum = (" + "SELECT SPSNum FROM " + this.IG_TABLE_PROFILE + " WHERE " + this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3 + ")");
            }
            HashMap hashMap = null;
            int[] nArray = new int[]{};
            boolean bl3 = this.groupIsAbsoluteOrdered(n, n2, n3);
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_OBJECT_IMAGE_MAP, "ObjectID");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_GROUP_IMAGE_MAP, "ImageID");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_GROUP_IMAGE_MAP, "MpdSeries");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ResolutionSize");
            if (!bl3 && vector != null && vector.size() != 0) {
                hashMap = this.getIIGSortData(n, vector);
                nArray = new int[vector.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = ((FieldMapping)vector.elementAt(i)).getFinalField().getFieldID();
                }
            }
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Query i:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            int n4 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            int n5 = -1;
            ImageInGroup imageInGroup = null;
            long l5 = 0L;
            long l6 = 0L;
            boolean bl6 = false;
            int n6 = -1;
            Dimension dimension = null;
            Object var37_29 = null;
            int n7 = 1;
            String string = null;
            while (databaseConnector.more()) {
                try {
                    l2 = databaseConnector.getLongField("ObjectID");
                }
                catch (Exception exception) {
                    l2 = l5;
                }
                l4 = Long.parseLong(databaseConnector.getFieldByName("ImageID"));
                n5 = databaseConnector.getIntegerFieldByName("ResolutionSize");
                try {
                    bl5 = databaseConnector.getBooleanField("MpdSeries");
                }
                catch (Exception exception) {
                    bl5 = false;
                }
                try {
                    n4 = databaseConnector.getIntegerField("AbsoluteOrder");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l6 != l4 || l5 != l2 || bl6 != bl5 || n6 != n5) {
                    l5 = l2;
                    l6 = l4;
                    bl6 = bl5;
                    n6 = n5;
                    int n8 = 0;
                    int n9 = databaseConnector.getIntegerFieldByName("Width");
                    int n10 = databaseConnector.getIntegerFieldByName("Height");
                    dimension = new Dimension(n9, n10);
                    n8 = ImageFile.getFormatTypeToInt(databaseConnector.getFieldByName("Format"));
                    n7 = 1;
                    try {
                        n7 = databaseConnector.getIntegerFieldByName("MediaType");
                    }
                    catch (Exception exception) {
                        n7 = 1;
                    }
                    if (n7 < 1) {
                        n7 = 1;
                    }
                    string = this.getMediaUrl(databaseConnector);
                    ImageFile imageFile = new ImageFile(dimension, n5, string, n8, n7);
                    if (l3 == 0L || l2 != l || l4 != l3 || bl5 != bl4) {
                        if (imageInGroup != null) {
                            vector2.addElement(imageInGroup);
                        }
                        imageInGroup = new ImageInGroup(l2, l4, bl5, collectionKey, new Vector());
                        imageInGroup.setAbsoluteOrder(n4);
                        l = l2;
                        l3 = l4;
                        bl4 = bl5;
                        this.debugOut("Created IIG: " + imageInGroup);
                        if (hashMap != null) {
                            String[] stringArray = new String[nArray.length];
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string2 = this.generateIIGSortFieldKey(l2, nArray[i]);
                                stringArray[i] = TrinityConnector.convertSortValue((String)hashMap.get(string2));
                            }
                            imageInGroup.setSortKeys(stringArray);
                        }
                    }
                    imageInGroup.imageFiles.addElement(imageFile);
                }
                databaseConnector.next();
            }
            this.debugOut("Outside of while loop.");
            if (imageInGroup != null) {
                vector2.addElement(imageInGroup);
            }
            if (hashMap != null) {
                hashMap.clear();
            }
            if (vector2.size() > 0 && bl3) {
                Collections.sort(vector2, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n;
                        int n2 = ((ImageInGroup)object).getAbsoluteOrder();
                        if (n2 == (n = ((ImageInGroup)object2).getAbsoluteOrder())) {
                            return 0;
                        }
                        if (n2 < n) {
                            return -1;
                        }
                        return 1;
                    }
                });
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImagesInGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getIIGSortData(int n, Vector vector) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        String string = null;
        TrinityFieldProfile[] trinityFieldProfileArray = this.getFieldProfiles(vector.toArray(new FieldMapping[0]));
        String string2 = TrinityConnector.createFieldIDClause(new TrinityFieldProfile[0], trinityFieldProfileArray, "IRFIELDS");
        if (string2.length() > 0) {
            String string3 = "(" + string2;
            if (string != null && string.length() > 0) {
                string3 = string3 + " AND (" + string + ")";
            }
            string3 = string3 + " AND (DTVALUETOOBJECT.Preferred = 1) AND (DTVALUES.Enabled = 1) AND (IRGROUPIMAGEMAP.GroupID = " + n + "))";
            sqlQueryGenerator.addTable("IRFIELDS", null, "FieldID");
            sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, new String[]{"ObjectID"});
            sqlQueryGenerator.addTable("IRTYPES", null, new String[0]);
            sqlQueryGenerator.addTable("DTVALUES", null, "ValueText");
            sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IROBJECTIMAGEMAP", "ImageID", 0);
            sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "DTVALUETOOBJECT", "ObjectID", 0);
            sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", "ValueID", 0);
            sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere(string3);
        }
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("getIIGSortData - query: " + databaseConnector.getQuery());
        databaseConnector.runQuery();
        try {
            while (databaseConnector.more()) {
                long l = databaseConnector.getLongField("ObjectID");
                int n2 = databaseConnector.getIntegerField("FieldID");
                String string4 = databaseConnector.getStringField("ValueText");
                hashMap.put(this.generateIIGSortFieldKey(l, n2), string4);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getIIGSortData():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return hashMap;
    }

    protected String generateIIGSortFieldKey(long l, int n) {
        return "" + l + "_" + n;
    }

    public MediaMetaData getFullMediaData(long l, int n) {
        String string;
        String[] stringArray;
        this.debugOut("In getFullMediaData()");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRIMAGEFILES", null, "*");
        if (n == -1) {
            sqlQueryGenerator.appendToWhere("ImageID = " + l);
            sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ResolutionSize DESC");
        } else {
            sqlQueryGenerator.appendToWhere("ImageID = " + l + " AND ResolutionSize = " + n);
        }
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Full info query: \n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        MediaMetaData mediaMetaData = new MediaMetaData();
        if (databaseConnector.more()) {
            try {
                stringArray = databaseConnector.getFieldNames();
                MediaField mediaField = new MediaField("Image ID", databaseConnector.getFieldByName("ImageID"));
                mediaMetaData.addMediaField(mediaField);
                mediaField = new MediaField("Resolution Size", databaseConnector.getFieldByName("ResolutionSize"));
                mediaMetaData.addMediaField(mediaField);
                mediaField = new MediaField("Format", databaseConnector.getFieldByName("Format"));
                mediaMetaData.addMediaField(mediaField);
                string = ImageFile.getMediaTypeToString(databaseConnector.getIntegerFieldByName("MediaType"));
                mediaField = new MediaField("Media Type", string);
                mediaMetaData.addMediaField(mediaField);
                mediaField = new MediaField("File Name", databaseConnector.getFieldByName("FileName"));
                mediaMetaData.addMediaField(mediaField);
                mediaField = new MediaField("Width", databaseConnector.getFieldByName("Width"));
                mediaMetaData.addMediaField(mediaField);
                mediaField = new MediaField("Height", databaseConnector.getFieldByName("Height"));
                mediaMetaData.addMediaField(mediaField);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFullMediaData(): " + exception);
            }
        }
        databaseConnector.close();
        sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_MEDIA_INFO, null, "*");
        sqlQueryGenerator.appendToWhere("MediaID = " + l);
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Full info query: \n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            try {
                stringArray = databaseConnector.getFieldNames();
                if (stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("MediaID")) continue;
                        string = new MediaField(stringArray[i], databaseConnector.getFieldByName(stringArray[i]));
                        mediaMetaData.addMediaField((MediaField)string);
                        this.debugOut(stringArray[i] + " " + databaseConnector.getFieldByName(stringArray[i]));
                    }
                }
                databaseConnector.next();
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFullMediaData(): " + exception);
            }
        }
        databaseConnector.close();
        return mediaMetaData;
    }

    public int getMaxResolutionSize(long l) {
        this.debugOut("In getMaxResolutionSize()");
        int n = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRIMAGEFILES", null, "*");
        sqlQueryGenerator.appendToWhere("ImageID = " + l + " AND Format != 'SOURCE'");
        sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ResolutionSize DESC");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Full info query: \n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            try {
                String string = databaseConnector.getFieldByName("ResolutionSize");
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFullMediaData(): " + exception);
            }
        }
        databaseConnector.close();
        return n;
    }

    protected int getUniqueListCount(int n, String string, int n2, int n3, int n4, String string2) {
        return this.getUniqueListCount(new Integer(n), string, n2, n3, n4, string2, null);
    }

    protected int getUniqueListCount(FieldMapping fieldMapping, int n, int n2, String string, Vector vector) {
        return this.getUniqueListCount(fieldMapping, null, 0, n, n2, string, null);
    }

    protected int getUniqueListCount(Object object, String string, int n, int n2, int n3, String string2, Vector vector) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n4 = 0;
        try {
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(this.getUniqueListQuery(object, string, n, n2, n3, string2, vector), "ResultCount", true, this.useDistinctInCount));
            this.debugOut("Unique list count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n4 = databaseConnector.getIntegerField("ResultCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueListCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n4;
    }

    protected int getUniqueListFieldCount(int n, String string) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n2 = 0;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTVALUES", null, string);
            sqlQueryGenerator.appendToWhere("((DTVALUES.FieldID = " + n + ")" + " AND (" + "DTVALUES" + ".Enabled = 1))");
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(sqlQueryGenerator.getQuery(), "ResultCount", true, this.useDistinctInCount));
            this.debugOut("Unique list Field count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("ResultCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueListFieldCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n2;
    }

    protected String getUniqueListQuery(int n, String string, int n2, int n3, int n4, String string2) {
        return this.getUniqueListQuery(new Integer(n), string, n2, n3, n4, string2, null);
    }

    protected String getUniqueListQuery(FieldMapping fieldMapping, int n, int n2, String string, Vector vector) {
        return this.getUniqueListQuery(fieldMapping, null, 0, n, n2, string, null);
    }

    protected String getUniqueListQuery(Object object, String string, int n, int n2, int n3, String string2, Vector vector) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (object instanceof LinkFieldMapping) {
            String string3;
            LinkFieldMapping linkFieldMapping = (LinkFieldMapping)object;
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = this.createLinkCodeClause(vector);
            if (string4.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string4);
            }
            if ((string3 = this.createEquivalenceRelationshipClause(linkFieldMapping.fieldName, 1, n3, this.escapeSpecialCharacters(string2), false)).length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string3);
            }
            if (n2 > -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("GroupID = " + n2);
            }
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("IRLINKREPOSITORY", new String[]{linkFieldMapping.fieldName});
            if (n2 > -1) {
                sqlQueryGenerator.addJoin("IRLINKREPOSITORY", "IRGROUPIMAGEMAP", "ImageID", 0);
            }
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
        } else {
            int n4 = (Integer)object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("((DTVALUES." + string + " IS NOT NULL)" + " AND (" + "DTVALUES" + ".FieldID = " + n4 + ")" + " AND (" + "DTVALUES" + ".Enabled = 1)");
            if (n2 > -1) {
                stringBuffer.append(" AND (IRGROUPIMAGEMAP.GroupID = " + n2 + ")");
            }
            if (n3 != 0 && string2 != null) {
                String string5 = "DTVALUES." + string;
                if (this.useLowerCaseCommand && n != 2) {
                    string5 = "LOWER(" + string5 + ")";
                }
                boolean bl = false;
                String string6 = this.escapeSpecialCharacters(string2);
                if (this.useLowerCaseCommand) {
                    if (string6 == null) {
                        string6 = "LOWER('" + string6 + "')";
                    } else if (this.useLowerCaseCommandOnSearchValue && n != 2) {
                        bl = true;
                    } else {
                        string6 = string6.toLowerCase();
                    }
                }
                if (string6 != null && !string6.equals("")) {
                    stringBuffer.append(" AND " + this.createEquivalenceRelationshipClause(string5, n, n3, string6, bl));
                }
            }
            stringBuffer.append(")");
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("DTVALUES", null, string);
            if (n2 > -1) {
                sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", "ValueID", 0);
                sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "IROBJECTIMAGEMAP", "ObjectID", 0);
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "IRGROUPIMAGEMAP", "ImageID", 0);
            }
            sqlQueryGenerator.appendToWhere(stringBuffer.toString());
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.addOrderBy("DTVALUES", string);
            }
        }
        return sqlQueryGenerator.getQuery();
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, int n, int n2, String string, int n3, Vector vector) {
        return this.getUniqueList(fieldMapping, n, n2, string, n3, false, vector);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, int n, int n2, String string, int n3, boolean bl, Vector vector) {
        Object[] objectArray;
        Vector<CriterionValue> vector2 = new Vector<CriterionValue>();
        Vector vector3 = fieldMapping.getFinalFields();
        Field field = null;
        boolean bl2 = false;
        CriterionValue[] criterionValueArray = null;
        boolean bl3 = false;
        this.debugOut("In getUniqueList().");
        this.debugOut("linkCodes.size() is: " + vector.size());
        if (fieldMapping instanceof LinkFieldMapping) {
            boolean bl4 = bl3 = n3 > -1 && this.useSqlCountForThreshold && this.getUniqueListCount(fieldMapping, n, n2, string, vector) > n3;
            if (!bl3) {
                objectArray = this.getDatabaseConnector();
                objectArray.setQuery(this.getUniqueListQuery(fieldMapping, n, n2, string, vector));
                this.debugOut("Unique Link List Query:\n" + objectArray.getQuery());
                objectArray.runQuery();
                vector2 = new Vector();
                while (objectArray.more()) {
                    try {
                        StringCriterionValue stringCriterionValue = new StringCriterionValue(objectArray.getFieldByName(fieldMapping.fieldName));
                        if (stringCriterionValue != null && !stringCriterionValue.isEmpty() && !vector2.contains(stringCriterionValue)) {
                            vector2.addElement(stringCriterionValue);
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("Caught exception while retrieving results in getUniqueList():\n" + InsightUtilities.convertStackTraceToString(exception));
                    }
                    objectArray.next();
                }
                this.debugOut(vector2.size() + " elements found.");
                objectArray.close();
            }
        } else if (vector3 != null) {
            for (int i = 0; i < vector3.size(); ++i) {
                field = (Field)vector3.elementAt(i);
                boolean bl5 = bl2 = field.fieldType == 3;
                if (field == null) continue;
                criterionValueArray = this.getUniqueList(-1, field.fieldID, TrinityConnector.getFieldValueName(field.typeCode), field.fieldType, n, n2, string, n3, bl, bl2);
                if (criterionValueArray == null) {
                    bl3 = true;
                    break;
                }
                for (int j = 0; j < criterionValueArray.length; ++j) {
                    vector2.addElement(criterionValueArray[j]);
                }
            }
        }
        if (!bl3 && n3 > -1 && vector2.size() > n3) {
            bl3 = true;
        }
        objectArray = null;
        if (!bl3) {
            objectArray = new CriterionValue[vector2.size()];
            vector2.copyInto(objectArray);
        }
        return objectArray;
    }

    public CriterionValue[] getUniqueList(int n, int n2, int n3, int n4, String string, int n5, boolean bl, Vector vector) {
        this.debugOut("In getUniqueList() with cacheUniqueCollectionID = " + n + " fieldID = " + n2);
        CriterionValue[] criterionValueArray = new CriterionValue[]{};
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
            sqlQueryGenerator.addTable("IRFIELDS", null, "FieldType");
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("IRFIELDS.FieldID = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Field info query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                String string2 = databaseConnector.getFieldByName("TypeCode");
                int n6 = databaseConnector.getIntegerFieldByName("FieldType");
                boolean bl2 = "D".equals(string2);
                String string3 = TrinityConnector.getFieldValueName(string2);
                criterionValueArray = this.getUniqueList(n, n2, string3, n6, n3, n4, string, n5, bl, bl2);
            } else {
                this.debugOut("getUniqueList() fieldID: '" + n2 + "' not found.");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueList():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return criterionValueArray;
    }

    public CriterionValue[] getUniqueList(int n, String string, int n2, int n3, int n4, String string2, int n5, boolean bl) {
        return this.getUniqueList(-1, n, string, n2, n3, n4, string2, n5, false, bl);
    }

    public CriterionValue[] getUniqueList(int n, int n2, String string, int n3, int n4, int n5, String string2, int n6, boolean bl, boolean bl2) {
        this.debugOut("In getUniqueList() with cacheUniqueCollectionID = " + n + " and fieldID = " + n2 + " and valueField = " + string);
        TrinityConnector.debugFile("In getUniqueList() with cacheUniqueCollectionID = " + n + " and fieldID = " + n2 + " and valueField = " + string);
        Vector<CriterionValue> vector = new Vector<CriterionValue>();
        boolean bl3 = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (n6 > -1 && this.useSqlCountForThreshold) {
                if (this.useUniqueListCache) {
                    if (uniqueListCache.getFieldCount(this, n, n2, string) > n6) {
                        int n7;
                        bl3 = bl ? (!InsightUtilities.isNonEmpty(string2) ? uniqueListCache.getCount(this, n, n2, string, n3, n4, n5, string2) > n6 : ((n7 = uniqueListCache.getCount(n, n2, n4, n5, string2, this.caseInsensitiveComparison, this.STRING_WILDCARD_SYMBOL)) >= 0 ? n7 > n6 : this.getUniqueListCount(n2, string, n3, n4, n5, string2) > n6)) : this.getUniqueListCount(n2, string, n3, n4, n5, string2) > n6;
                    }
                } else {
                    boolean bl4 = bl3 = this.getUniqueListCount(n2, string, n3, n4, n5, string2) > n6;
                }
            }
            if (!bl3) {
                Vector vector2 = null;
                if (bl && this.useUniqueListCache) {
                    vector2 = uniqueListCache.getRecords(n, n2, n4, n5, string2, this.caseInsensitiveComparison, this.STRING_WILDCARD_SYMBOL);
                }
                if (vector2 != null) {
                    vector = vector2;
                } else {
                    databaseConnector.setQuery(this.getUniqueListQuery(n2, string, n3, n4, n5, string2));
                    this.debugOut("getUniqueList query:\n" + databaseConnector.getQuery());
                    TrinityConnector.debugFile("getUniqueList query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        String string3 = null;
                        CriterionValue criterionValue = null;
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        while (databaseConnector.more()) {
                            string3 = databaseConnector.getFieldByName(string);
                            if (string3 != null && !hashtable.containsKey(string3)) {
                                hashtable.put(string3, string3);
                                criterionValue = null;
                                if (bl2) {
                                    criterionValue = new DateCriterionValue();
                                    criterionValue.setWithSearchValue(string3);
                                } else {
                                    criterionValue = new StringCriterionValue(string3, InsightDataAnchor.getPlainText(string3));
                                }
                                if (criterionValue != null && !criterionValue.isEmpty()) {
                                    vector.addElement(criterionValue);
                                }
                            }
                            databaseConnector.next();
                        }
                        this.debugOut(vector.size() + " elements found.");
                        TrinityConnector.debugFile(vector.size() + " elements found.");
                    }
                    if (bl && this.useUniqueListCache) {
                        uniqueListCache.addRecords(n, n2, n4, n5, string2, vector);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueList():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        if (!bl3 && n6 > -1 && vector.size() > n6) {
            bl3 = true;
        }
        Object[] objectArray = null;
        if (!bl3) {
            objectArray = new CriterionValue[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Vector performThumbnailQuery(int n, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2, int n5, int n6, IscrMap iscrMap, boolean bl3) {
        TrinityConnector.debugFile("TrinityConnector.performThumbnailQuery(): isBrowserQuery=" + bl3);
        if (!bl3) {
            return this.doThumbnailQuery(n, fieldMappingArray, fieldMappingArray2, objectArray, bl, n2, n3, n4, bl2, n5, n6, iscrMap);
        }
        return this.doBrowserThumbnailQuery(n, fieldMappingArray, fieldMappingArray2, objectArray, bl, n2, n3, n4, bl2, n5, n6);
    }

    public Vector doThumbnailQuery(int n, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2, int n5, int n6, IscrMap iscrMap) {
        int n7;
        Vector vector = new Vector(0);
        TrinityFieldProfile[] trinityFieldProfileArray = this.getFieldProfiles(fieldMappingArray);
        TrinityFieldProfile[] trinityFieldProfileArray2 = this.getFieldProfiles(fieldMappingArray2);
        vector = this.gatherThumbnailSearchResults(n, objectArray, bl, trinityFieldProfileArray, trinityFieldProfileArray2, n2, n3, n4, n5, n6, iscrMap);
        this.totalRecords = vector.size();
        if (bl2) {
            Vector vector2 = new Vector(n6);
            for (n7 = n5; vector2.size() < n6 && n7 < vector.size(); ++n7) {
                vector2.addElement(vector.elementAt(n7));
            }
            vector = vector2;
        }
        if (!bl) {
            boolean bl3 = false;
            n7 = 0;
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (objectArray[i] instanceof MviFieldCriterion) {
                    bl3 = true;
                    break;
                }
                if (!(objectArray[i] instanceof MpdFieldCriterion)) continue;
                n7 = 1;
                break;
            }
            if (bl3 || n7 != 0) {
                int n8 = 0;
                while (vector != null && n8 < vector.size()) {
                    InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)vector.get(n8);
                    if (!(!bl3 || n7 == 0 || insightSmartClientResults.isMultiview() && insightSmartClientResults.isMultipage())) {
                        vector.remove(n8);
                        continue;
                    }
                    if (bl3 && !insightSmartClientResults.isMultiview()) {
                        vector.remove(n8);
                        continue;
                    }
                    if (n7 != 0 && !insightSmartClientResults.isMultipage()) {
                        vector.remove(n8);
                        continue;
                    }
                    ++n8;
                }
            }
        }
        return vector;
    }

    public Vector doBrowserThumbnailQuery(int n, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2, int n5, int n6) {
        TrinityConnector.debugFile("in TrinityConnector.doBrowserThumbnailQuery(): start=" + n5 + ", length=" + n6, 2);
        Vector vector = new Vector(0);
        TrinityFieldProfile[] trinityFieldProfileArray = this.getFieldProfiles(fieldMappingArray);
        TrinityFieldProfile[] trinityFieldProfileArray2 = this.getFieldProfiles(fieldMappingArray2);
        String string = "";
        if (bl) {
            string = this.createKeywordClause((String[])objectArray, "IROBJECTIMAGEMAP");
        } else if (objectArray != null && objectArray.length > 0) {
            string = this.createCriteriaClause(objectArray);
        }
        String string2 = "(";
        boolean bl3 = false;
        if (string.length() > 0) {
            string2 = string2 + " (" + string + ") AND ";
            bl3 = true;
        }
        string2 = string2 + "(IRGROUPIMAGEMAP.GroupID = " + n + "))";
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword(this.distinctKeyword);
        }
        sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, new String[]{"ObjectID", "ImageID"});
        sqlQueryGenerator.addTable("IRGROUPIMAGEMAP", null, "GroupID, MviSeries, MpdSeries, AbsoluteOrder");
        sqlQueryGenerator.addTable("DTFLATOBJECTDATA", null, new String[]{"SortDataVal", "ThumbData1", "ThumbData2", "ThumbData3", "ThumbData4"});
        sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IROBJECTIMAGEMAP", "ImageID", 0);
        sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "DTFLATOBJECTDATA", "ObjectID", 0);
        sqlQueryGenerator.appendToWhere(string2);
        sqlQueryGenerator.addOrderBy("DTFLATOBJECTDATA", "SortDataVal");
        if (bl3 || objectArray == null || objectArray.length == 0) {
            long l = System.currentTimeMillis();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            TrinityConnector.debugFile("TrinityConnector.doBrowserThumbnailQuery(): Thumbnail query: \n" + databaseConnector.getQuery(), 2);
            databaseConnector.runQuery();
            TrinityConnector.debugFile("TrinityConnector.doBrowserThumbnailQuery(): Thumbnail query time: " + (System.currentTimeMillis() - l), 2);
            vector = this.processBrowserThumbnailResults(databaseConnector, trinityFieldProfileArray, trinityFieldProfileArray2, n2, n3, n4, n, n5, n6);
            databaseConnector.close();
        }
        return vector;
    }

    protected String createOrderByClause(TrinityFieldProfile[] trinityFieldProfileArray) {
        StringBuffer stringBuffer = new StringBuffer("ORDER BY IRFIELDS.FieldID");
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < trinityFieldProfileArray.length; ++i) {
            if (trinityFieldProfileArray[i] == null) continue;
            if (!bl && trinityFieldProfileArray[i].fieldName.equalsIgnoreCase("ImageID")) {
                stringBuffer.append(", IROBJECTIMAGEMAP.ImageID");
                bl = true;
                continue;
            }
            if (bl2) break;
            stringBuffer.append(", DTVALUES." + VALUE_NAME_TEXT + ", " + "DTVALUES" + "." + VALUE_NAME_NUMBER);
            bl2 = true;
        }
        if (!bl && !bl2) {
            stringBuffer.append(", IROBJECTIMAGEMAP.ImageID");
        }
        return stringBuffer.toString();
    }

    protected String createHierarchyNodeSubClause(HierarchyNodeFieldCriterion hierarchyNodeFieldCriterion, boolean bl) {
        HierarchyNodeData hierarchyNodeData;
        StringBuffer stringBuffer = new StringBuffer();
        if (hierarchyNodeFieldCriterion != null && hierarchyNodeFieldCriterion.nodeData != null && this.setHierarchyNodeData(hierarchyNodeData = hierarchyNodeFieldCriterion.nodeData)) {
            if (bl) {
                stringBuffer.append("(IROBJECTIMAGEMAP.ObjectID = ANY (SELECT DTHIERARCHYTOOBJECT.ObjectID FROM DTHIERARCHYTOOBJECT WHERE (HierarchyID = " + hierarchyNodeData.hierarchyID);
            } else {
                stringBuffer.append("(((DTHIERARCHYTOOBJECT.HierarchyID = " + hierarchyNodeData.hierarchyID);
            }
            if (hierarchyNodeFieldCriterion.searchAllChildren) {
                stringBuffer.append(" AND HierarchyIndex >= " + hierarchyNodeData.startID + " AND HierarchyIndex <= " + hierarchyNodeData.endID);
            } else {
                stringBuffer.append(" AND HierarchyIndex = " + hierarchyNodeData.nodeID);
            }
            stringBuffer.append(")))");
        }
        return stringBuffer.toString();
    }

    protected String createCriteriaClause(Object[] objectArray) {
        return this.createCriteriaClause(objectArray, true, null);
    }

    protected String createCriteriaClause(Object[] objectArray, boolean bl, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.groupFieldCriterions(objectArray);
        Object var6_6 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            var6_6 = vector.elementAt(i);
            if (var6_6 instanceof String) {
                object2 = new String[]{var6_6};
                String string = this.createKeywordClause((String[])object2, "IROBJECTIMAGEMAP", bl);
                if (string == null || string.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("(" + string + ")");
                if (hashtable == null || bl) continue;
                hashtable.put("DTTERMOBJECTMAP", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof KeywordsFieldCriterion) {
                object2 = var6_6;
                String[] stringArray = new String[]{((KeywordsFieldCriterion)object2).equivalence.getSearchValue()};
                String string = this.createKeywordClause(stringArray, "IROBJECTIMAGEMAP", bl);
                if (string == null || string.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    if (((KeywordsFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("(" + string + ")");
                if (hashtable == null || bl) continue;
                hashtable.put("DTTERMOBJECTMAP", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof MultiObjectIndicatorFieldCriterion) {
                object2 = var6_6;
                if (((MultiObjectIndicatorFieldCriterion)object2).isEmpty()) continue;
                if (stringBuffer.length() > 0) {
                    if (((MultiObjectIndicatorFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("(IROBJECTIMAGEMAP.ObjectID IN (" + InsightUtilities.getListString(((MultiObjectIndicatorFieldCriterion)object2).getObjectIDs()) + "))");
                continue;
            }
            if (var6_6 instanceof ObjectIndicatorFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((ObjectIndicatorFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("(IROBJECTIMAGEMAP.ObjectID = " + ((ObjectIndicatorFieldCriterion)object2).getObjectID() + " AND " + "IROBJECTIMAGEMAP" + ".ImageID = " + ((ObjectIndicatorFieldCriterion)object2).getImageID() + ")");
                continue;
            }
            if (var6_6 instanceof MviFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((MviFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("(IRGROUPIMAGEMAP.MviSeries = 1)");
                continue;
            }
            if (var6_6 instanceof MpdFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((MpdFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("(IRGROUPIMAGEMAP.MpdSeries = 1)");
                continue;
            }
            if (var6_6 instanceof AudioFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((AudioFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                if (bl) {
                    stringBuffer.append("(IROBJECTIMAGEMAP.ImageID = ANY (SELECT ImageID FROM IRIMAGEFILES WHERE MediaType = 2))");
                } else {
                    stringBuffer.append("(IRIMAGEFILES.MediaType = 2)");
                }
                if (hashtable == null) continue;
                hashtable.put("IRIMAGEFILES", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof VideoFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((VideoFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                if (bl) {
                    stringBuffer.append("(IROBJECTIMAGEMAP.ImageID = ANY (SELECT ImageID FROM IRIMAGEFILES WHERE MediaType = 3))");
                } else {
                    stringBuffer.append("(IRIMAGEFILES.MediaType = 3)");
                }
                if (hashtable == null) continue;
                hashtable.put("IRIMAGEFILES", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof QtvrFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((QtvrFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                if (bl) {
                    stringBuffer.append("(IROBJECTIMAGEMAP.ImageID = ANY (SELECT ImageID FROM IRIMAGEFILES WHERE MediaType = 4))");
                } else {
                    stringBuffer.append("(IRIMAGEFILES.MediaType = 4)");
                }
                if (hashtable == null) continue;
                hashtable.put("IRIMAGEFILES", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof MiscFieldCriterion) {
                object2 = var6_6;
                if (stringBuffer.length() > 0) {
                    if (((MiscFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                if (bl) {
                    stringBuffer.append("(IROBJECTIMAGEMAP.ImageID = ANY (SELECT ImageID FROM IRIMAGEFILES WHERE MediaType = 5))");
                } else {
                    stringBuffer.append("(IRIMAGEFILES.MediaType = 5)");
                }
                if (hashtable == null) continue;
                hashtable.put("IRIMAGEFILES", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof HierarchyNodeFieldCriterion) {
                String string;
                int n;
                object2 = var6_6;
                boolean bl2 = true;
                for (n = 0; n < vector.size(); n += 1) {
                    if (vector.elementAt(n) instanceof HierarchyNodeFieldCriterion) continue;
                    bl2 = false;
                    break;
                }
                if ((string = this.createHierarchyNodeSubClause((HierarchyNodeFieldCriterion)object2, (n = bl ? 1 : (!bl2 ? 1 : 0)) != 0)).length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    if (((HierarchyNodeFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append(string);
                if (hashtable == null || n) continue;
                hashtable.put("DTHIERARCHYTOOBJECT", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof FuzzyDateFieldCriterion) {
                Vector vector2;
                object2 = var6_6;
                if (!this.supportsFuzzyDates || ((FuzzyDateFieldCriterion)object2).fieldMapping == null || (vector2 = ((FuzzyDateFieldCriterion)object2).fieldMapping.getFinalFields()) == null || vector2.size() <= 0) continue;
                String string = "";
                Vector<Object> vector3 = new Vector<Object>(vector2.size());
                object = null;
                for (int j = 0; j < vector2.size(); ++j) {
                    object = (Field)vector2.elementAt(j);
                    if (object == null || !((Field)object).date) continue;
                    vector3.addElement(object);
                }
                if (vector3.size() > 0) {
                    string = bl ? "IROBJECTIMAGEMAP.ObjectID = ANY (SELECT DTVALUETOOBJECT.ObjectID FROM DTVALUES, DTVALUETOOBJECT WHERE (DTVALUES.ValueID = DTVALUETOOBJECT.ValueID) AND (" + TrinityConnector.createFieldIDClause("DTVALUES", vector3) + " AND (" + "DTVALUES" + ".ValueDate" + "_Start" + " >= " + ((FuzzyDateFieldCriterion)object2).getStartJulian() + " AND " + "DTVALUES" + ".ValueDate" + "_End" + " <= " + ((FuzzyDateFieldCriterion)object2).getEndJulian() + ")))" : TrinityConnector.createFieldIDClause("DTVALUES", vector3) + " AND (" + "DTVALUES" + ".ValueDate" + "_Start" + " >= " + ((FuzzyDateFieldCriterion)object2).getStartJulian() + " AND " + "DTVALUES" + ".ValueDate" + "_End" + " <= " + ((FuzzyDateFieldCriterion)object2).getEndJulian() + ")";
                }
                if (string.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    if (((FuzzyDateFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                stringBuffer.append("(" + string + ")");
                if (hashtable == null) continue;
                hashtable.put("DTVALUES", new Boolean(true));
                continue;
            }
            if (var6_6 instanceof LinkFieldCriterion) {
                int n;
                object2 = var6_6;
                FieldMapping fieldMapping = ((LinkFieldCriterion)object2).fieldMapping;
                boolean bl3 = true;
                for (n = 0; n < vector.size(); ++n) {
                    if (vector.elementAt(n) instanceof LinkFieldCriterion) continue;
                    bl3 = false;
                    break;
                }
                int n2 = bl ? 1 : (n = !bl3 ? 1 : 0);
                if (((LinkFieldCriterion)object2).getFuzzyDateJulianRange() != null && ((LinkFieldCriterion)object2).fieldMapping.isFuzzyDateSearchable()) {
                    long l = ((LinkFieldCriterion)object2).getFuzzyDateJulianRange().getStartJulian();
                    long l2 = ((LinkFieldCriterion)object2).getFuzzyDateJulianRange().getEndJulian();
                    if (stringBuffer.length() > 0) {
                        if (((LinkFieldCriterion)object2).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    if (n != 0) {
                        stringBuffer.append("(IROBJECTIMAGEMAP.ImageID = ANY (SELECT ImageID FROM IRLINKREPOSITORY WHERE " + this.createLinkCodeClause(((LinkFieldCriterion)object2).getCollectionKey(), ((LinkFieldCriterion)object2).getClientIP(), ((LinkFieldCriterion)object2).getLocalClientIP(), ((LinkFieldCriterion)object2).getUserGroupShells()) + " AND (" + "IRLINKREPOSITORY" + "." + ((LinkFieldCriterion)object2).fieldMapping.fieldName + "_Start" + " >= " + l + " AND " + "IRLINKREPOSITORY" + "." + ((LinkFieldCriterion)object2).fieldMapping.fieldName + "_End" + " <= " + l2 + ")))");
                    } else {
                        stringBuffer.append("(" + this.createLinkCodeClause(((LinkFieldCriterion)object2).getCollectionKey(), ((LinkFieldCriterion)object2).getClientIP(), ((LinkFieldCriterion)object2).getLocalClientIP(), ((LinkFieldCriterion)object2).getUserGroupShells()) + " AND (" + "IRLINKREPOSITORY" + "." + ((LinkFieldCriterion)object2).fieldMapping.fieldName + "_Start" + " >= " + l + " AND " + "IRLINKREPOSITORY" + "." + ((LinkFieldCriterion)object2).fieldMapping.fieldName + "_End" + " <= " + l2 + "))");
                    }
                    if (hashtable == null || n != 0) continue;
                    hashtable.put("IRLINKREPOSITORY", new Boolean(true));
                    continue;
                }
                object = this.useLowerCaseCommand ? (((LinkFieldCriterion)object2).fieldMapping.fieldType == 2 ? "(" + ((LinkFieldCriterion)object2).fieldMapping.fieldName + ")" : "(LOWER(" + ((LinkFieldCriterion)object2).fieldMapping.fieldName + "))") : "(" + ((LinkFieldCriterion)object2).fieldMapping.fieldName + ")";
                boolean bl4 = false;
                String string = this.escapeSpecialCharacters(((LinkFieldCriterion)object2).equivalence.getSearchValue());
                if (this.useLowerCaseCommand) {
                    if (string == null) {
                        string = "LOWER('" + string + "')";
                    } else if (this.useLowerCaseCommandOnSearchValue && ((LinkFieldCriterion)object2).fieldMapping.fieldType != 2) {
                        bl4 = true;
                    } else {
                        string = string.toLowerCase();
                    }
                }
                if (stringBuffer.length() > 0) {
                    if (((LinkFieldCriterion)object2).booleanOperator == 1) {
                        stringBuffer.append(" AND ");
                    } else {
                        stringBuffer.append(" OR ");
                    }
                }
                if (n != 0) {
                    stringBuffer.append("(IROBJECTIMAGEMAP.ImageID = ANY (SELECT ImageID FROM IRLINKREPOSITORY WHERE " + this.createLinkCodeClause(((LinkFieldCriterion)object2).getCollectionKey(), ((LinkFieldCriterion)object2).getClientIP(), ((LinkFieldCriterion)object2).getLocalClientIP(), ((LinkFieldCriterion)object2).getUserGroupShells()) + " AND " + this.createEquivalenceRelationshipClause((String)object, 1, ((LinkFieldCriterion)object2).relationship, string, bl4) + "))");
                } else {
                    stringBuffer.append("(" + this.createLinkCodeClause(((LinkFieldCriterion)object2).getCollectionKey(), ((LinkFieldCriterion)object2).getClientIP(), ((LinkFieldCriterion)object2).getLocalClientIP(), ((LinkFieldCriterion)object2).getUserGroupShells()) + " AND " + this.createEquivalenceRelationshipClause((String)object, 1, ((LinkFieldCriterion)object2).relationship, string, bl4) + ")");
                }
                if (hashtable == null || n != 0) continue;
                hashtable.put("IRLINKREPOSITORY", new Boolean(true));
                continue;
            }
            if (!(var6_6 instanceof Vector)) continue;
            object2 = var6_6;
            FieldCriterion fieldCriterion = (FieldCriterion)((Vector)object2).firstElement();
            Field[] fieldArray = this.stripOutBogusFields(fieldCriterion.fieldMapping.getFinalFields());
            if (fieldArray == null || fieldArray.length <= 0) continue;
            if (stringBuffer.length() > 0) {
                if (fieldCriterion.booleanOperator == 1) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" OR ");
                }
            }
            if (fieldCriterion.paren == 1) {
                stringBuffer.append("(");
            }
            stringBuffer.append("(");
            Vector vector4 = this.groupFieldsByTypeCode(fieldArray);
            object = null;
            FieldCriterion fieldCriterion2 = null;
            for (int j = 0; j < vector4.size(); ++j) {
                object = (Vector)vector4.elementAt(j);
                if (hashtable != null) {
                    hashtable.put("DTVALUES", new Boolean(true));
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                if (bl) {
                    stringBuffer2.append("SELECT DTVALUETOOBJECT.ObjectID FROM DTVALUES, DTVALUETOOBJECT WHERE (DTVALUES.ValueID = DTVALUETOOBJECT.ValueID) AND (" + TrinityConnector.createFieldIDClause("DTVALUES", (Vector)object) + " AND (");
                } else {
                    stringBuffer2.append("(((" + TrinityConnector.createFieldIDClause("DTVALUES", (Vector)object) + " AND (");
                }
                for (int k = 0; k < ((Vector)object2).size(); ++k) {
                    String string;
                    fieldCriterion2 = (FieldCriterion)((Vector)object2).elementAt(k);
                    if (k > 0) {
                        if (fieldCriterion2.booleanOperator == 1) {
                            stringBuffer2.append(" AND ");
                        } else {
                            stringBuffer2.append(" OR ");
                        }
                    }
                    Field field = (Field)((Vector)object).firstElement();
                    String string2 = fieldCriterion2.equivalence.getSearchValue();
                    string2 = field.fieldType == 1 ? this.escapeSpecialCharacters(string2) : this.escapeQuotes(string2);
                    boolean bl5 = false;
                    if (this.useLowerCaseCommand) {
                        string = field.fieldType == 2 ? "DTVALUES." + TrinityConnector.getFieldValueName(field.typeCode) : "LOWER(DTVALUES." + TrinityConnector.getFieldValueName(field.typeCode) + ")";
                        if (this.useLowerCaseCommandOnSearchValue && field.fieldType != 2) {
                            bl5 = true;
                        } else {
                            string2 = string2.toLowerCase();
                        }
                    } else {
                        string = "DTVALUES." + TrinityConnector.getFieldValueName(field.typeCode);
                    }
                    stringBuffer2.append(this.createEquivalenceRelationshipClause(string, field.fieldType, fieldCriterion2.relationship, string2, bl5));
                }
                stringBuffer2.append("))");
                if (bl) {
                    if (this.useValueFromSubQuery) {
                        stringBuffer.append("(IROBJECTIMAGEMAP.ObjectID IN (" + this.buildSubQueryValues(stringBuffer2.toString()));
                    } else {
                        stringBuffer.append("(IROBJECTIMAGEMAP.ObjectID = ANY (" + stringBuffer2.toString());
                    }
                } else {
                    stringBuffer.append(stringBuffer2.toString());
                }
                stringBuffer.append("))");
            }
            stringBuffer.append(")");
            if (fieldCriterion.paren != 2) continue;
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected Field[] stripOutBogusFields(Vector vector) {
        Vector<Field> vector2 = new Vector<Field>();
        Field field = null;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                field = (Field)vector.elementAt(i);
                if (field == null || field.fieldType == 0) continue;
                vector2.addElement(field);
            }
        }
        Object[] objectArray = new Field[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    protected Vector groupFieldsByTypeCode(Field[] fieldArray) {
        Vector vector = new Vector();
        boolean bl = false;
        Vector vector2 = null;
        Field field = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                vector2 = (Vector)vector.elementAt(j);
                if (vector2 == null || vector2.size() <= 0) continue;
                field = (Field)vector2.firstElement();
                if (!field.typeCode.equals(fieldArray[i].typeCode)) continue;
                vector2.addElement(fieldArray[i]);
                bl = true;
                break;
            }
            if (bl) continue;
            Vector<Field> vector3 = new Vector<Field>(1);
            vector3.addElement(fieldArray[i]);
            vector.addElement(vector3);
        }
        return vector;
    }

    protected Vector groupFieldCriterions(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = false;
            Object var4_4 = null;
            Vector vector2 = null;
            FieldCriterion fieldCriterion = null;
            FieldCriterion fieldCriterion2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                if (objectArray[i] instanceof String) {
                    vector.addElement(objectArray[i]);
                    continue;
                }
                fieldCriterion2 = (FieldCriterion)objectArray[i];
                if (fieldCriterion2.fcType == 0) {
                    if (fieldCriterion2.fieldMapping == null || fieldCriterion2.relationship == 0) continue;
                    bl = false;
                    for (int j = 0; j < vector.size(); ++j) {
                        var4_4 = vector.elementAt(j);
                        if (!(var4_4 instanceof Vector)) continue;
                        vector2 = var4_4;
                        fieldCriterion = (FieldCriterion)vector2.firstElement();
                        if ((fieldCriterion.relationship != 2 || fieldCriterion2.relationship != 2) && (fieldCriterion.relationship == 2 || fieldCriterion2.relationship == 2) || fieldCriterion2.fcType != fieldCriterion.fcType || fieldCriterion2.booleanOperator != fieldCriterion.booleanOperator || fieldCriterion2.fieldMapping == null || fieldCriterion.fieldMapping == null || !fieldCriterion2.fieldMapping.equals(fieldCriterion.fieldMapping)) continue;
                        vector2.addElement(fieldCriterion2);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    vector2 = new Vector(1);
                    vector2.addElement(fieldCriterion2);
                    vector.addElement(vector2);
                    continue;
                }
                if (objectArray[i] instanceof LinkFieldCriterion) {
                    if (fieldCriterion2.relationship == 0 && (fieldCriterion2.relationship != 0 || ((LinkFieldCriterion)fieldCriterion2).getFuzzyDateJulianRange() == null) || fieldCriterion2.fieldMapping == null || !(fieldCriterion2.fieldMapping instanceof LinkFieldMapping)) continue;
                    vector.addElement(fieldCriterion2);
                    continue;
                }
                vector.addElement(fieldCriterion2);
            }
        }
        return vector;
    }

    protected String firstWordOf(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            n = i;
            if (cArray[i] == ' ') break;
        }
        return new String(cArray, 0, n + 1);
    }

    protected String generateTokenizedContainsSubClause(String string, String string2, String string3) {
        return this.generateTokenizedContainsSubClause(string, string2, string3, 1);
    }

    protected String generateTokenizedContainsSubClause(String string, String string2, String string3, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = " AND ";
        if (n == 0) {
            string4 = " OR ";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        String string5 = null;
        String string6 = "";
        if (this.useLowerCaseCommand) {
            string6 = "LOWER";
        }
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
            if (string5 == null || string5.length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string4);
            }
            if (this.useLowerCaseCommand) {
                stringBuffer.append(string6 + "(" + string + "." + string2 + ") LIKE " + string6 + "(" + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + this.escapeSpecialCharacters(string5) + this.STRING_WILDCARD_SYMBOL, false) + ")");
                continue;
            }
            stringBuffer.append(string6 + "(" + string + "." + string2 + " LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string6 + this.escapeSpecialCharacters(string5) + this.STRING_WILDCARD_SYMBOL, false) + ")");
        }
        return "(" + stringBuffer.toString() + ")";
    }

    protected String generateContainsClause(Vector vector, Field[] fieldArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        FieldCriterion fieldCriterion = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            fieldCriterion = (FieldCriterion)vector.elementAt(i);
            if (fieldCriterion.relationship != 2 || (string = this.generateTokenizedContainsSubClause("DTTERMS", "Keyword", fieldCriterion.equivalence.getSearchValue())).length() <= 0) continue;
            if (stringBuffer2.length() > 0) {
                if (fieldCriterion.booleanOperator == 1) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" OR ");
                }
            }
            stringBuffer2.append(string);
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("(IROBJECTIMAGEMAP.ObjectID = ANY (SELECT DTTERMOBJECTMAP.ObjectID FROM DTTERMS, DTTERMOBJECTMAP WHERE (DTTERMS.TermID = DTTERMOBJECTMAP.TermID) AND (" + TrinityConnector.createFieldIDClause("DTTERMOBJECTMAP", fieldArray) + " AND (" + stringBuffer2 + "))))");
        }
        return stringBuffer.toString();
    }

    protected String createKeywordClause(String[] stringArray, String string) {
        return this.createKeywordClause(stringArray, string, true);
    }

    protected String createKeywordClause(String[] stringArray, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        StringTokenizer stringTokenizer = null;
        boolean bl2 = true;
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        if (stringArray != null && stringArray.length > 0) {
            bl2 = true;
            for (int i = 0; i < stringArray.length; ++i) {
                stringTokenizer = new StringTokenizer(stringArray[i]);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!bl2) {
                        stringBuffer.append(" AND ");
                    }
                    String string3 = new String();
                    string3 = this.useLowerCaseCommand ? this.convertKeyword(stringTokenizer.nextToken()).toLowerCase() : this.convertKeyword(stringTokenizer.nextToken());
                    if (this.useValueFromSubQuery) {
                        if (bl) {
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append("SELECT DTTERMOBJECTMAP.ObjectID FROM DTTERMOBJECTMAP, DTTERMS WHERE (DTTERMOBJECTMAP.TermID = DTTERMS.TermID) AND ");
                            if (this.collectionLocale.equals(Locale.TRADITIONAL_CHINESE) || this.collectionLocale.equals(new Locale("zh", "CN")) || this.collectionLocale.equals(Locale.JAPAN) || this.collectionLocale.equals(Locale.KOREA)) {
                                stringBuffer2.append("(DTTERMS.Keyword LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string3 + this.STRING_WILDCARD_SYMBOL, false) + ")");
                            } else {
                                stringBuffer2.append("(DTTERMS.Keyword LIKE " + this.prepStringForQuery(string3, false) + ")");
                            }
                            stringBuffer.append("(" + string2 + "ObjectID IN (" + this.buildSubQueryValues(stringBuffer2.toString()) + "))");
                        } else {
                            stringBuffer.append("((");
                            if (this.collectionLocale.equals(Locale.TRADITIONAL_CHINESE) || this.collectionLocale.equals(new Locale("zh", "CN")) || this.collectionLocale.equals(Locale.JAPAN) || this.collectionLocale.equals(Locale.KOREA)) {
                                stringBuffer.append("(DTTERMS.Keyword LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string3 + this.STRING_WILDCARD_SYMBOL, false) + ")))");
                            } else {
                                stringBuffer.append("(DTTERMS.Keyword LIKE " + this.prepStringForQuery(string3, false) + ")))");
                            }
                        }
                    } else {
                        if (bl) {
                            stringBuffer.append("(" + string2 + "ObjectID = ANY (SELECT " + "DTTERMOBJECTMAP" + ".ObjectID FROM " + "DTTERMOBJECTMAP" + ", " + "DTTERMS" + " WHERE (" + "DTTERMOBJECTMAP" + ".TermID = " + "DTTERMS" + ".TermID) AND ");
                        } else {
                            stringBuffer.append("((");
                        }
                        if (this.collectionLocale.equals(Locale.TRADITIONAL_CHINESE) || this.collectionLocale.equals(new Locale("zh", "CN")) || this.collectionLocale.equals(Locale.JAPAN) || this.collectionLocale.equals(Locale.KOREA)) {
                            stringBuffer.append("(DTTERMS.Keyword LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string3 + this.STRING_WILDCARD_SYMBOL, false) + ")))");
                        } else {
                            stringBuffer.append("(DTTERMS.Keyword LIKE " + this.prepStringForQuery(string3, false) + ")))");
                        }
                    }
                    bl2 = false;
                }
            }
        }
        return stringBuffer.toString();
    }

    protected Vector processThumbnailResultsSingleSort(TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.debugOut("in processThumbnailResultsSingleSort().");
        TrinityConnector.debugFile("in processThumbnailResultsSingleSort().", 2);
        Vector<InsightSmartClientResults> vector = new Vector<InsightSmartClientResults>(0);
        if (trinityFieldProfileArray2 != null && trinityFieldProfileArray2.length > 0) {
            boolean bl;
            TrinityFieldProfile[] trinityFieldProfileArray3;
            if (trinityFieldProfileArray2.length > 1) {
                trinityFieldProfileArray3 = new TrinityFieldProfile[]{trinityFieldProfileArray2[0]};
                trinityFieldProfileArray2 = trinityFieldProfileArray3;
            }
            trinityFieldProfileArray3 = new TrinityFieldProfile[]{};
            String string2 = "(";
            String string3 = TrinityConnector.createFieldIDClause(trinityFieldProfileArray3, trinityFieldProfileArray2, "IRFIELDS");
            if (string3.length() > 0) {
                string2 = string2 + string3 + " AND ";
            }
            if (string != null && string.length() > 0) {
                string2 = string2 + "(" + string + ") AND ";
            }
            string2 = string2 + "(DTVALUETOOBJECT.Preferred = 1) AND (DTVALUES.Enabled = 1) AND (IRIMAGEFILES.ResolutionSize = " + n + ")" + " AND (" + "IRGROUPIMAGEMAP" + ".GroupID = " + n4 + "))";
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword(this.distinctKeyword);
            }
            sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, new String[]{"ObjectID", "ImageID"});
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"Width AS ThumbWidth", "Height AS ThumbHeight"});
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"Filename", "MediaType"});
            sqlQueryGenerator.addTable("IRGROUPIMAGEMAP", null, new String[]{"*"});
            sqlQueryGenerator.addTable("IRFIELDS", null, new String[]{"FieldID"});
            sqlQueryGenerator.addTable("IRTYPES", null, new String[]{"TypeCode"});
            sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"*"});
            sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IROBJECTIMAGEMAP", new String[]{"ImageID"}, 0);
            sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IRIMAGEFILES", new String[]{"ImageID"}, 0);
            sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "DTVALUETOOBJECT", new String[]{"ObjectID"}, 0);
            sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", new String[]{"ValueID"}, 0);
            sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", new String[]{"FieldID"}, 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere(string2);
            boolean bl2 = bl = n2 >= 0 || n3 >= 0;
            if (bl) {
                sqlQueryGenerator.addTable("IRSPS", null, new String[]{"URL"});
                sqlQueryGenerator.addTable("IRLPS", null, new String[]{"LPS"});
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", new String[]{"LPSid"}, 0);
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"MediaType", "Format", "ResolutionSize"}, 0);
                sqlQueryGenerator.addJoin("IRSPS", "IRPROFILE", new String[]{"SPSNum"}, 0);
                sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileId = " + n2 + " AND " + "IRPROFILE" + ".CollectionId = " + n3);
            }
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            this.totalRecords = 0;
            try {
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Thumbnail query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n7 = 0;
                while (databaseConnector.more() && n7 < n5) {
                    ++n7;
                    ++this.totalRecords;
                    databaseConnector.next();
                }
                Hashtable<String, Vector<InsightSmartClientResults>> hashtable = new Hashtable<String, Vector<InsightSmartClientResults>>(n6);
                vector = new Vector(n6 + 1);
                int n8 = 0;
                InsightSmartClientResults insightSmartClientResults = null;
                Object var21_22 = null;
                Vector<InsightSmartClientResults> vector2 = null;
                while (databaseConnector.more() && n8 < n6) {
                    insightSmartClientResults = new InsightSmartClientResults();
                    insightSmartClientResults.objectID = databaseConnector.getLongField("ObjectID");
                    insightSmartClientResults.imageID = databaseConnector.getLongField("ImageID");
                    insightSmartClientResults.mediaType = databaseConnector.getIntegerFieldByName("MediaType");
                    insightSmartClientResults.thumbDimension = new Dimension(databaseConnector.getIntegerFieldByName("ThumbWidth"), databaseConnector.getIntegerFieldByName("ThumbHeight"));
                    insightSmartClientResults.hasMviSeries = databaseConnector.getIntegerFieldByName("MviSeries") == 1;
                    try {
                        insightSmartClientResults.hasMpdSeries = databaseConnector.getIntegerFieldByName("MpdSeries") == 1;
                    }
                    catch (Exception exception) {
                        insightSmartClientResults.hasMpdSeries = false;
                    }
                    try {
                        insightSmartClientResults.absoluteOrder = databaseConnector.getIntegerField("AbsoluteOrder");
                    }
                    catch (Exception exception) {
                        insightSmartClientResults.absoluteOrder = 0;
                    }
                    insightSmartClientResults.thumbnailURL = this.getMediaUrl(databaseConnector);
                    insightSmartClientResults.fieldData = new String[trinityFieldProfileArray.length];
                    insightSmartClientResults.sortData = new String[trinityFieldProfileArray2.length];
                    insightSmartClientResults.sortData[0] = TrinityConnector.getFieldValue(databaseConnector);
                    insightSmartClientResults.iscrLocale = this.collectionLocale;
                    if (!vector.contains(insightSmartClientResults)) {
                        vector.addElement(insightSmartClientResults);
                        var21_22 = hashtable.get("" + insightSmartClientResults.objectID);
                        if (var21_22 == null) {
                            vector2 = new Vector<InsightSmartClientResults>(1);
                            vector2.addElement(insightSmartClientResults);
                            hashtable.put("" + insightSmartClientResults.objectID, vector2);
                        } else {
                            vector2 = var21_22;
                            vector2.addElement(insightSmartClientResults);
                        }
                        ++n8;
                        ++this.totalRecords;
                    }
                    databaseConnector.next();
                }
                while (databaseConnector.more()) {
                    ++this.totalRecords;
                    databaseConnector.next();
                }
                databaseConnector.close();
                if (vector.size() > 0 && (string3 = TrinityConnector.createFieldIDClause(trinityFieldProfileArray, trinityFieldProfileArray3, "IRFIELDS")).length() > 0) {
                    string2 = "(" + string3;
                    if (string != null && string.length() > 0) {
                        string2 = string2 + " AND (" + string + ")";
                    }
                    string2 = string2 + " AND (DTVALUETOOBJECT.Preferred = 1)";
                    string2 = string2 + " AND (DTVALUES.Enabled = 1)";
                    string2 = string2 + " AND (IRGROUPIMAGEMAP.GroupID = " + n4 + "))";
                    sqlQueryGenerator.clear();
                    sqlQueryGenerator.addTable("IRFIELDS", null, "FieldID");
                    sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, new String[]{"ObjectID", "ImageID"});
                    sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                    sqlQueryGenerator.addTable("DTVALUES", null, "*");
                    sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IROBJECTIMAGEMAP", "ImageID", 0);
                    sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "DTVALUETOOBJECT", "ObjectID", 0);
                    sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", "ValueID", 0);
                    sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
                    sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                    sqlQueryGenerator.appendToWhere(string2);
                    long l = System.currentTimeMillis();
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Values query: \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    this.debugOut("Value setting thumbnail query execution time: " + (System.currentTimeMillis() - l));
                    long l2 = System.currentTimeMillis();
                    this.setFieldData(databaseConnector, hashtable, trinityFieldProfileArray, trinityFieldProfileArray3);
                    this.debugOut("Set field data time: " + (System.currentTimeMillis() - l2));
                    l2 = System.currentTimeMillis();
                    this.setSortStrings(vector);
                    this.debugOut("Set sort strings time: " + (System.currentTimeMillis() - l2));
                    databaseConnector.close();
                }
                hashtable.clear();
            }
            catch (Exception exception) {
                this.debugOut("Exception in processThumbnailResultsSingleSort(): " + exception);
            }
            databaseConnector.close();
            if (vector.size() > 0) {
                Collections.sort(vector);
            }
        }
        return vector;
    }

    protected Vector processThumbnailResults(DatabaseConnector databaseConnector, TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        Vector<InsightSmartClientResults> vector;
        block14: {
            long l = System.currentTimeMillis();
            this.totalRecords = 0;
            vector = new Vector<InsightSmartClientResults>(0);
            try {
                if (databaseConnector == null || !databaseConnector.more() || !databaseConnector.more()) break block14;
                this.totalRecords = 0;
                boolean bl = false;
                if (!bl) {
                    Hashtable<String, Vector<InsightSmartClientResults>> hashtable = new Hashtable<String, Vector<InsightSmartClientResults>>(n6);
                    vector = new Vector(n6);
                    int n7 = 0;
                    Vector vector2 = new Vector(0);
                    Object var18_18 = null;
                    Vector<InsightSmartClientResults> vector3 = null;
                    InsightSmartClientResults insightSmartClientResults = null;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    while (databaseConnector.more()) {
                        long l5 = System.currentTimeMillis();
                        insightSmartClientResults = new InsightSmartClientResults();
                        insightSmartClientResults.objectID = databaseConnector.getLongField("ObjectID");
                        insightSmartClientResults.imageID = databaseConnector.getLongField("ImageID");
                        insightSmartClientResults.mediaType = databaseConnector.getIntegerFieldByName("MediaType");
                        insightSmartClientResults.thumbDimension = new Dimension(databaseConnector.getIntegerFieldByName("ThumbWidth"), databaseConnector.getIntegerFieldByName("ThumbHeight"));
                        insightSmartClientResults.hasMviSeries = databaseConnector.getIntegerFieldByName("MviSeries") == 1;
                        try {
                            insightSmartClientResults.hasMpdSeries = databaseConnector.getIntegerFieldByName("MpdSeries") == 1;
                        }
                        catch (Exception exception) {
                            insightSmartClientResults.hasMpdSeries = false;
                        }
                        try {
                            insightSmartClientResults.absoluteOrder = databaseConnector.getIntegerField("AbsoluteOrder");
                        }
                        catch (Exception exception) {
                            insightSmartClientResults.absoluteOrder = 0;
                        }
                        insightSmartClientResults.thumbnailURL = this.getMediaUrl(databaseConnector);
                        insightSmartClientResults.fieldData = new String[trinityFieldProfileArray.length];
                        insightSmartClientResults.sortData = new String[trinityFieldProfileArray2.length];
                        insightSmartClientResults.iscrLocale = this.collectionLocale;
                        l2 += System.currentTimeMillis() - l5;
                        l5 = System.currentTimeMillis();
                        if (!IscrMap.doesIscrExist(hashtable, insightSmartClientResults)) {
                            vector.addElement(insightSmartClientResults);
                            var18_18 = hashtable.get("" + insightSmartClientResults.objectID);
                            if (var18_18 == null) {
                                vector3 = new Vector<InsightSmartClientResults>(1);
                                vector3.addElement(insightSmartClientResults);
                                hashtable.put("" + insightSmartClientResults.objectID, vector3);
                            } else {
                                vector3 = var18_18;
                                vector3.addElement(insightSmartClientResults);
                            }
                            ++n7;
                            ++this.totalRecords;
                        }
                        l3 += System.currentTimeMillis() - l5;
                        l5 = System.currentTimeMillis();
                        databaseConnector.next();
                        l4 += System.currentTimeMillis() - l5;
                    }
                    databaseConnector.close();
                    this.debugOut("Sub - ISCR create time: " + l2);
                    this.debugOut("Sub - ISCR lookup time: " + l3);
                    this.debugOut("Sub - Call to next() time: " + l4);
                    this.debugOut("ISCR creation time: " + (System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                    String string2 = TrinityConnector.createFieldIDClause(trinityFieldProfileArray, trinityFieldProfileArray2, "IRFIELDS");
                    if (vector.size() > 0 && string2.length() > 0) {
                        String string3 = "(" + string2;
                        if (string != null && string.length() > 0) {
                            string3 = string3 + " AND (" + string + ")";
                        }
                        string3 = string3 + " AND (DTVALUETOOBJECT.Preferred = 1) AND (DTVALUES.Enabled = 1) AND (IRGROUPIMAGEMAP.GroupID = " + n4 + "))";
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                        sqlQueryGenerator.addTable("IRFIELDS", null, "FieldID");
                        sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, new String[]{"ObjectID"});
                        sqlQueryGenerator.addTable("IRTYPES", null, new String[0]);
                        sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"ValueText", "ValueNumber"});
                        sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IROBJECTIMAGEMAP", "ImageID", 0);
                        sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "DTVALUETOOBJECT", "ObjectID", 0);
                        sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", "ValueID", 0);
                        sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
                        sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                        sqlQueryGenerator.appendToWhere(string3);
                        long l6 = System.currentTimeMillis();
                        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                        this.debugOut("Value query: \n" + databaseConnector.getQuery());
                        databaseConnector.runQuery();
                        this.debugOut("Value query execution time: " + (System.currentTimeMillis() - l6));
                        if (vector.size() > 0) {
                            long l7 = System.currentTimeMillis();
                            this.setFieldData(databaseConnector, hashtable, trinityFieldProfileArray, trinityFieldProfileArray2);
                            this.debugOut("Set field data time: " + (System.currentTimeMillis() - l7));
                            l7 = System.currentTimeMillis();
                            this.setSortStrings(vector);
                            this.debugOut("Set sort strings time: " + (System.currentTimeMillis() - l7));
                        }
                        databaseConnector.close();
                    }
                    databaseConnector.close();
                    hashtable.clear();
                    l = System.currentTimeMillis();
                    Collections.sort(vector);
                    this.debugOut("Sort time: " + (System.currentTimeMillis() - l));
                    break block14;
                }
                this.debugOut("The start param has exceeded the number of objects returned.");
            }
            catch (Exception exception) {
                this.debugOut("Exception in processThumbnailResults(): " + exception);
            }
        }
        return vector;
    }

    protected Vector processBrowserThumbnailResults(DatabaseConnector databaseConnector, TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        Vector<InsightSmartClientResults> vector;
        block16: {
            TrinityConnector.debugFile("in TrinityConnector.processBrowserThumbnailResults(): start=" + n5 + ", length=" + n6, 2);
            long l = System.currentTimeMillis();
            this.totalRecords = 0;
            vector = new Vector<InsightSmartClientResults>(0);
            try {
                if (databaseConnector == null || !databaseConnector.more()) break block16;
                int n7 = 0;
                while (databaseConnector.more() && n7 < n5) {
                    ++n7;
                    ++this.totalRecords;
                    databaseConnector.next();
                }
                if (!databaseConnector.more()) break block16;
                boolean bl = false;
                if (!bl) {
                    Hashtable<String, Vector<InsightSmartClientResults>> hashtable = new Hashtable<String, Vector<InsightSmartClientResults>>(n6);
                    vector = new Vector(n6);
                    int n8 = 0;
                    Vector vector2 = new Vector(0);
                    Object var18_18 = null;
                    Vector<InsightSmartClientResults> vector3 = null;
                    InsightSmartClientResults insightSmartClientResults = null;
                    while (databaseConnector.more() && n8 < n6) {
                        insightSmartClientResults = new InsightSmartClientResults();
                        insightSmartClientResults.objectID = databaseConnector.getLongField("ObjectID");
                        insightSmartClientResults.imageID = databaseConnector.getLongField("ImageID");
                        insightSmartClientResults.hasMviSeries = databaseConnector.getIntegerFieldByName("MviSeries") == 1;
                        try {
                            insightSmartClientResults.hasMpdSeries = databaseConnector.getIntegerFieldByName("MpdSeries") == 1;
                        }
                        catch (Exception exception) {
                            insightSmartClientResults.hasMpdSeries = false;
                        }
                        try {
                            insightSmartClientResults.absoluteOrder = databaseConnector.getIntegerField("AbsoluteOrder");
                        }
                        catch (Exception exception) {
                            insightSmartClientResults.absoluteOrder = 0;
                        }
                        insightSmartClientResults.fieldData = new String[trinityFieldProfileArray.length];
                        for (int i = 0; i < insightSmartClientResults.fieldData.length && i < 4; ++i) {
                            insightSmartClientResults.fieldData[i] = databaseConnector.getFieldByName("ThumbData" + (i + 1));
                        }
                        insightSmartClientResults.iscrLocale = this.collectionLocale;
                        if (!IscrMap.doesIscrExist(hashtable, insightSmartClientResults)) {
                            vector.addElement(insightSmartClientResults);
                            var18_18 = hashtable.get("" + insightSmartClientResults.objectID);
                            if (var18_18 == null) {
                                vector3 = new Vector<InsightSmartClientResults>(1);
                                vector3.addElement(insightSmartClientResults);
                                hashtable.put("" + insightSmartClientResults.objectID, vector3);
                            } else {
                                vector3 = var18_18;
                                vector3.addElement(insightSmartClientResults);
                            }
                            ++n8;
                            ++this.totalRecords;
                        }
                        databaseConnector.next();
                    }
                    while (databaseConnector.more()) {
                        ++this.totalRecords;
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    TrinityConnector.debugFile("TrinityConnector.processBrowserThumbnailResults(): ISCR creation time: " + (System.currentTimeMillis() - l), 2);
                    l = System.currentTimeMillis();
                    hashtable.clear();
                    Collections.sort(vector);
                    break block16;
                }
                TrinityConnector.debugFile("TrinityConnector.processBrowserThumbnailResults(): The start param has exceeded the number of objects returned.", 2);
            }
            catch (Exception exception) {
                TrinityConnector.debugFile("TrinityConnector.processBrowserThumbnailResults(): Exception in processBrowserThumbnailResults(): " + exception, 2);
            }
        }
        if (vector != null) {
            TrinityConnector.debugFile("TrinityConnector.processBrowserThumbnailResults(): returning " + vector.size() + " results, totalRecords=" + this.totalRecords, 2);
        } else {
            TrinityConnector.debugFile("TrinityConnector.processBrowserThumbnailResults(): returning null results", 2);
        }
        return vector;
    }

    protected void setFieldData(DatabaseConnector databaseConnector, Hashtable hashtable, TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2) {
        try {
            String string = null;
            Object var6_7 = null;
            Vector vector = null;
            int n = 0;
            Vector vector2 = null;
            Vector vector3 = null;
            String string2 = null;
            String string3 = null;
            int n2 = 0;
            InsightSmartClientResults insightSmartClientResults = null;
            while (databaseConnector.more()) {
                string = databaseConnector.getFieldByName("ObjectID");
                var6_7 = hashtable.get(string);
                if (var6_7 != null && var6_7 instanceof Vector) {
                    vector = var6_7;
                    n = databaseConnector.getIntegerFieldByName("FieldID");
                    vector2 = this.getFieldIndices(trinityFieldProfileArray, n);
                    vector3 = this.getFieldIndices(trinityFieldProfileArray2, n);
                    if (vector2 != null && vector3 != null && (vector2.size() > 0 || vector3.size() > 0)) {
                        string2 = null;
                        string2 = vector2.size() > 0 ? trinityFieldProfileArray[((Integer)vector2.firstElement()).intValue()].fieldValueName : trinityFieldProfileArray2[((Integer)vector3.firstElement()).intValue()].fieldValueName;
                        string3 = InsightDataAnchor.getPlainText(TrinityConnector.getFieldValue(databaseConnector, string2)).intern();
                        for (int i = 0; i < vector.size(); ++i) {
                            int n3;
                            insightSmartClientResults = (InsightSmartClientResults)vector.elementAt(i);
                            for (n3 = 0; n3 < vector2.size(); ++n3) {
                                n2 = (Integer)vector2.elementAt(n3);
                                insightSmartClientResults.fieldData[n2] = string3;
                                if (insightSmartClientResults.fieldData[n2].length() <= InsightSmartServicer.MAXIMUM_THUMBNAIL_FIELD_LENGTH) continue;
                                insightSmartClientResults.fieldData[n2] = insightSmartClientResults.fieldData[n2].substring(0, InsightSmartServicer.MAXIMUM_THUMBNAIL_FIELD_LENGTH).intern();
                            }
                            if (insightSmartClientResults.sortData == null) continue;
                            for (n3 = 0; n3 < vector3.size(); ++n3) {
                                insightSmartClientResults.sortData[((Integer)vector3.elementAt((int)n3)).intValue()] = string3;
                            }
                        }
                    }
                }
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception setFieldData(): " + exception);
        }
    }

    protected final void setSortStrings(Vector vector) {
        try {
            InsightSmartClientResults insightSmartClientResults = null;
            for (int i = 0; i < vector.size(); ++i) {
                insightSmartClientResults = (InsightSmartClientResults)vector.elementAt(i);
                if (insightSmartClientResults.sortData == null) continue;
                for (int j = 0; j < insightSmartClientResults.sortData.length; ++j) {
                    if (insightSmartClientResults.sortString == null) {
                        insightSmartClientResults.sortString = "";
                    }
                    insightSmartClientResults.sortString = insightSmartClientResults.sortString + TrinityConnector.convertSortValue(insightSmartClientResults.sortData[j]);
                }
                if (insightSmartClientResults.sortString != null) {
                    insightSmartClientResults.sortString = insightSmartClientResults.sortString.intern();
                }
                insightSmartClientResults.sortData = null;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in setSortStrings(): " + exception);
        }
    }

    protected TrinityFieldProfile[] getFieldProfiles(FieldMapping[] fieldMappingArray) {
        this.debugOut("In getFieldProfiles().");
        TrinityFieldProfile[] trinityFieldProfileArray = new TrinityFieldProfile[]{};
        TrinityFieldProfile trinityFieldProfile = null;
        if (fieldMappingArray != null) {
            trinityFieldProfileArray = new TrinityFieldProfile[fieldMappingArray.length];
            for (int i = 0; i < fieldMappingArray.length; ++i) {
                if (fieldMappingArray[i] == null || fieldMappingArray[i].getFinalField() == null) continue;
                trinityFieldProfile = new TrinityFieldProfile();
                trinityFieldProfile.fieldName = fieldMappingArray[i].getFinalField().fieldName;
                trinityFieldProfile.fieldID = fieldMappingArray[i].getFinalField().fieldID;
                trinityFieldProfile.fieldValueName = TrinityConnector.getFieldValueName(fieldMappingArray[i].getFinalField().typeCode);
                trinityFieldProfileArray[i] = trinityFieldProfile;
            }
        }
        return trinityFieldProfileArray;
    }

    protected Vector getFieldIndices(TrinityFieldProfile[] trinityFieldProfileArray, int n) {
        Vector<Integer> vector = new Vector<Integer>(4);
        if (trinityFieldProfileArray != null) {
            for (int i = 0; i < trinityFieldProfileArray.length; ++i) {
                if (trinityFieldProfileArray[i] == null || n != trinityFieldProfileArray[i].fieldID) continue;
                vector.addElement(new Integer(i));
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Vector gatherThumbnailSearchResults(int n, Object[] objectArray, boolean bl, TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2, int n2, int n3, int n4, int n5, int n6, IscrMap iscrMap) {
        Vector<InsightSmartClientResults> vector;
        block27: {
            long l = System.currentTimeMillis();
            this.totalRecords = 0;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            vector = new Vector<InsightSmartClientResults>(0);
            try {
                Object object;
                int n7;
                block26: {
                    n7 = this.getNextSearchQueryID(databaseConnector);
                    this.clearSearchResults(n7, databaseConnector);
                    try {
                        int n8;
                        l = System.currentTimeMillis();
                        object = this.getSearchResultPopulationQueries(n7, n, objectArray, bl);
                        boolean bl2 = false;
                        for (n8 = 0; object != null && n8 < ((Vector)object).size(); ++n8) {
                            databaseConnector.setQuery((String)((Vector)object).elementAt(n8));
                            this.debugOut("Find search results cmd[" + n8 + "]:\n" + databaseConnector.getQuery());
                            if (databaseConnector.runUpdateQuerySafe() > 0) {
                                bl2 = true;
                            }
                            databaseConnector.close();
                        }
                        this.debugOut("Search result population time: " + (System.currentTimeMillis() - l));
                        if (!bl2) break block26;
                        l = System.currentTimeMillis();
                        vector = new Vector(n6);
                        n8 = 0;
                        if (iscrMap == null) {
                            iscrMap = new IscrMap(n6);
                            n8 = 1;
                        }
                        if (iscrMap.size() > 0) {
                            this.newLine();
                            this.debugOut("Using CACHED thumbnail results.");
                            this.newLine();
                            databaseConnector.setQuery(this.getThumbnailResultsQuery(n7, n));
                            this.debugOut("Get thumbnail results query:\n" + databaseConnector.getQuery());
                            databaseConnector.runQuerySafe();
                            this.debugOut("Get thumbnail results query time: " + (System.currentTimeMillis() - l));
                            l = System.currentTimeMillis();
                            while (databaseConnector.more()) {
                                int n9;
                                boolean bl3;
                                boolean bl4;
                                long l2;
                                long l3 = databaseConnector.getLongField("ObjectID");
                                InsightSmartClientResults insightSmartClientResults = iscrMap.getIscr(l3, l2 = databaseConnector.getLongField("ImageID"), bl4 = databaseConnector.getBooleanField("MviSeries"), bl3 = databaseConnector.getBooleanField("MpdSeries"), n9 = databaseConnector.getIntegerField("AbsoluteOrder", 0));
                                if (insightSmartClientResults == null) {
                                    ObjectIndicatorFieldCriterion objectIndicatorFieldCriterion = new ObjectIndicatorFieldCriterion(l3, l2);
                                    Vector vector2 = this.gatherThumbnailSearchResults(n, new FieldCriterion[]{objectIndicatorFieldCriterion}, false, trinityFieldProfileArray, trinityFieldProfileArray2, n2, n3, n4, 0, 1, null);
                                    if (InsightUtilities.isNonEmpty(vector2)) {
                                        this.debugOut("Generated ISCR for [objectID: " + l3 + ", mediaID: " + l2 + ", hasMvi: " + bl4 + ", hasMpd: " + bl3 + "].");
                                        insightSmartClientResults = (InsightSmartClientResults)vector2.get(0);
                                        insightSmartClientResults.setMultiview(false);
                                        insightSmartClientResults.setMultipage(false);
                                        insightSmartClientResults.setAbsoluteOrder(0);
                                        iscrMap.addIscr(insightSmartClientResults);
                                    } else {
                                        this.debugOut("Did not find ISCR for [objectID: " + l3 + ", mediaID: " + l2 + ", hasMvi: " + bl4 + ", hasMpd: " + bl3 + "].");
                                    }
                                }
                                if (insightSmartClientResults != null) {
                                    vector.addElement(insightSmartClientResults);
                                    ++this.totalRecords;
                                }
                                databaseConnector.next();
                            }
                            this.debugOut("ISCR addition time: " + (System.currentTimeMillis() - l));
                            l = System.currentTimeMillis();
                            databaseConnector.close();
                        } else {
                            databaseConnector.setQuery(this.getThumbnailResultsQuery(n7, n, n2, n3, n4));
                            this.debugOut("Get thumbnail results query:\n" + databaseConnector.getQuery());
                            databaseConnector.runQuerySafe();
                            this.debugOut("Get thumbnail results query time: " + (System.currentTimeMillis() - l));
                            l = System.currentTimeMillis();
                            InsightSmartClientResults insightSmartClientResults = null;
                            long l4 = 0L;
                            long l5 = 0L;
                            long l6 = 0L;
                            while (databaseConnector.more()) {
                                long l7 = System.currentTimeMillis();
                                insightSmartClientResults = new InsightSmartClientResults();
                                insightSmartClientResults.objectID = databaseConnector.getLongField("ObjectID");
                                insightSmartClientResults.imageID = databaseConnector.getLongField("ImageID");
                                insightSmartClientResults.mediaType = databaseConnector.getIntegerField("MediaType");
                                insightSmartClientResults.thumbDimension = new Dimension(databaseConnector.getIntegerField("ThumbWidth"), databaseConnector.getIntegerField("ThumbHeight"));
                                insightSmartClientResults.hasMviSeries = databaseConnector.getBooleanField("MviSeries");
                                try {
                                    insightSmartClientResults.hasMpdSeries = databaseConnector.getBooleanField("MpdSeries");
                                }
                                catch (Exception exception) {
                                    insightSmartClientResults.hasMpdSeries = false;
                                }
                                try {
                                    insightSmartClientResults.absoluteOrder = databaseConnector.getIntegerField("AbsoluteOrder");
                                }
                                catch (Exception exception) {
                                    insightSmartClientResults.absoluteOrder = 0;
                                }
                                insightSmartClientResults.thumbnailURL = this.getMediaUrl(databaseConnector);
                                insightSmartClientResults.fieldData = new String[trinityFieldProfileArray.length];
                                insightSmartClientResults.sortData = new String[trinityFieldProfileArray2.length];
                                insightSmartClientResults.iscrLocale = this.collectionLocale;
                                l4 += System.currentTimeMillis() - l7;
                                l7 = System.currentTimeMillis();
                                if (iscrMap.addIscr(insightSmartClientResults)) {
                                    vector.addElement(insightSmartClientResults);
                                    ++this.totalRecords;
                                }
                                l5 += System.currentTimeMillis() - l7;
                                l7 = System.currentTimeMillis();
                                databaseConnector.next();
                                l6 += System.currentTimeMillis() - l7;
                            }
                            databaseConnector.close();
                            this.debugOut("Sub - ISCR create time: " + l4);
                            this.debugOut("Sub - ISCR lookup time: " + l5);
                            this.debugOut("Sub - Call to next() time: " + l6);
                            this.debugOut("ISCR creation time: " + (System.currentTimeMillis() - l));
                            l = System.currentTimeMillis();
                            l = System.currentTimeMillis();
                            databaseConnector.setQuery(this.getThumbnailLabelsQuery(n7, trinityFieldProfileArray, trinityFieldProfileArray2));
                            this.debugOut("Get thumbnail labels query:\n" + databaseConnector.getQuery());
                            databaseConnector.runQuerySafe();
                            this.debugOut("Get thumbnail labels query time: " + (System.currentTimeMillis() - l));
                            l = System.currentTimeMillis();
                            long l8 = System.currentTimeMillis();
                            this.setFieldData(databaseConnector, iscrMap, trinityFieldProfileArray, trinityFieldProfileArray2);
                            this.debugOut("Set thumbnail labels time: " + (System.currentTimeMillis() - l8));
                            l8 = System.currentTimeMillis();
                            this.setSortStrings(vector);
                            this.debugOut("Set sort strings time: " + (System.currentTimeMillis() - l8));
                            databaseConnector.close();
                        }
                        if (n8 != 0) {
                            iscrMap.clear();
                        }
                        l = System.currentTimeMillis();
                        Collections.sort(vector);
                        this.debugOut("Sort time: " + (System.currentTimeMillis() - l));
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception in gatherThumbnailSearchResults(): " + InsightUtilities.getStackTrace(exception));
                        Runnable runnable = new Runnable(n7){
                            private final /* synthetic */ int val$searchQueryID;
                            {
                                this.val$searchQueryID = n;
                            }

                            public void run() {
                                TrinityConnector.this.debugOut("Clearing results of search query ID " + this.val$searchQueryID + " on separate thread.");
                                TrinityConnector.this.clearSearchResults(this.val$searchQueryID);
                            }
                        };
                        new Thread(runnable).start();
                        break block27;
                    }
                    catch (Error error) {
                        this.debugOut("Error in gatherThumbnailSearchResults(): " + InsightUtilities.getStackTrace(error));
                        {
                            catch (Throwable throwable) {
                                Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                                new Thread(runnable).start();
                                throw throwable;
                            }
                        }
                        Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                        new Thread(runnable).start();
                        break block27;
                    }
                }
                object = new /* invalid duplicate definition of identical inner class */;
                new Thread((Runnable)object).start();
            }
            catch (Exception exception) {
                this.debugOut("Exception in gatherThumbnailSearchResults(): " + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in gatherThumbnailSearchResults(): " + InsightUtilities.getStackTrace(error));
            }
        }
        return vector;
    }

    private boolean canOptimizeAndBlocks(FieldCriterion fieldCriterion, FieldCriterion fieldCriterion2) {
        this.debugOut("*** in canOptimizeAndBlocks\npreviousFc = " + fieldCriterion + "\nfc = " + fieldCriterion2);
        if (fieldCriterion == null || fieldCriterion2 == null) {
            return false;
        }
        if (fieldCriterion.getType() != 0) {
            return false;
        }
        if (fieldCriterion2.getType() != 0) {
            return false;
        }
        if (fieldCriterion.fieldMapping == null) {
            if (fieldCriterion2.fieldMapping != null) {
                return false;
            }
            if (fieldCriterion.getField() == null || fieldCriterion2.getField() == null || fieldCriterion.getField().getFieldID() != fieldCriterion2.getField().getFieldID()) {
                return false;
            }
        } else {
            if (fieldCriterion2.fieldMapping == null) {
                return false;
            }
            if (!fieldCriterion.fieldMapping.equals(fieldCriterion2.fieldMapping)) {
                return false;
            }
        }
        return fieldCriterion.getRelationship() != 1 && fieldCriterion2.getRelationship() != 1;
    }

    protected Vector getSearchResultPopulationQueries(int n, int n2, Object[] objectArray, boolean bl) {
        Vector<String> vector = new Vector<String>(0);
        int n3 = 0;
        if (objectArray == null || objectArray.length == 0) {
            String string = this.getSingleSearchResultPopulationQuery(n, n3, n2, null);
            if (string != null && string.length() > 0) {
                vector.add(string);
            }
        } else if (bl) {
            Vector<Object> vector2 = new Vector<Object>(objectArray != null ? objectArray.length : 0);
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof String)) continue;
                vector2.addElement(objectArray[i]);
            }
            String[] stringArray = vector2.toArray(new String[0]);
            n3 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i]);
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    if ((string = this.getSingleSearchResultPopulationQuery(n, ++n3, n2, stringTokenizer.nextToken())) != null && string.length() > 0) {
                        vector.add(string);
                        continue;
                    }
                    --n3;
                }
            }
        } else {
            Vector vector3 = new Vector(0);
            FieldCriterion fieldCriterion = null;
            Vector<Object> vector4 = null;
            int n4 = 0;
            int n5 = 0;
            while (objectArray != null && n5 < objectArray.length) {
                int n6;
                String[] stringArray;
                Vector<String> vector5;
                StringTokenizer stringTokenizer;
                FieldCriterion fieldCriterion2;
                FieldCriterion fieldCriterion3 = (FieldCriterion)objectArray[n5];
                if (vector4 == null) {
                    vector4 = new Vector<Object>(0);
                    vector3.add(vector4);
                    n4 = 0;
                }
                if (vector4.size() == 0) {
                    if (objectArray[n5] instanceof KeywordsFieldCriterion) {
                        fieldCriterion2 = (KeywordsFieldCriterion)objectArray[n5];
                        stringTokenizer = new StringTokenizer(fieldCriterion2.equivalence.getSearchValue());
                        vector5 = new Vector<String>(1);
                        while (stringTokenizer.hasMoreTokens()) {
                            vector5.addElement(stringTokenizer.nextToken());
                        }
                        if (vector5.size() > 1) {
                            stringArray = vector5.toArray(new String[0]);
                            for (n6 = 0; n6 < stringArray.length; ++n6) {
                                if (n6 > 0) {
                                    vector4 = new Vector(0);
                                    vector3.add(vector4);
                                }
                                vector4.add(stringArray[n6]);
                            }
                            n4 = 0;
                            fieldCriterion = null;
                            ++n5;
                            continue;
                        }
                        vector4.add(fieldCriterion3);
                        fieldCriterion = fieldCriterion3;
                        ++n5;
                        continue;
                    }
                    vector4.add(fieldCriterion3);
                    fieldCriterion = fieldCriterion3;
                    ++n5;
                    continue;
                }
                if (n4 > 0) {
                    vector4 = null;
                    continue;
                }
                if (fieldCriterion3.booleanOperator == 0) {
                    vector4.add(fieldCriterion3);
                    ++n5;
                    fieldCriterion = null;
                    continue;
                }
                if (fieldCriterion3.booleanOperator == 1 && this.canOptimizeAndBlocks(fieldCriterion, fieldCriterion3)) {
                    if (n5 + 1 < objectArray.length) {
                        fieldCriterion2 = (FieldCriterion)objectArray[n5 + 1];
                        if (fieldCriterion2.booleanOperator == 0) {
                            vector4 = null;
                        }
                    }
                    if (vector4 == null) continue;
                    vector4.add(fieldCriterion3);
                    ++n5;
                    ++n4;
                    fieldCriterion = fieldCriterion3;
                    continue;
                }
                if (objectArray[n5] instanceof KeywordsFieldCriterion) {
                    fieldCriterion2 = (KeywordsFieldCriterion)objectArray[n5];
                    stringTokenizer = new StringTokenizer(fieldCriterion2.equivalence.getSearchValue());
                    vector5 = new Vector(1);
                    while (stringTokenizer.hasMoreTokens()) {
                        vector5.addElement(stringTokenizer.nextToken());
                    }
                    if (vector5.size() > 1) {
                        stringArray = vector5.toArray(new String[0]);
                        for (n6 = 0; n6 < stringArray.length; ++n6) {
                            vector4 = new Vector(0);
                            vector3.add(vector4);
                            vector4.add(stringArray[n6]);
                        }
                        n4 = 0;
                        fieldCriterion = null;
                        ++n5;
                        continue;
                    }
                    vector4 = null;
                    continue;
                }
                vector4 = null;
            }
            n3 = -1;
            for (n5 = 0; n5 < vector3.size(); ++n5) {
                String string;
                if ((string = this.getSingleSearchResultPopulationQuery(n, ++n3, n2, vector3.get(n5))) != null && string.length() > 0) {
                    vector.add(string);
                    continue;
                }
                --n3;
            }
        }
        if (n3 > 0) {
            vector.add("DELETE FROM ITSEARCHRESULTS WHERE SearchQueryID = " + n + " AND CriteriaID <> " + n3);
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getSingleSearchResultPopulationQuery(int n, int n2, int n3, Object object) {
        Object[] objectArray;
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword(this.distinctKeyword);
        }
        sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, new Object[]{new SqlColumnSelection(n + " AS SearchQueryID", false), new SqlColumnSelection(n2 + " AS CriteriaID", false), new SqlColumnSelection("ObjectID AS ObjectID", true), new SqlColumnSelection("ImageID AS MediaID", true)});
        sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IROBJECTIMAGEMAP", "ImageID", 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(IRGROUPIMAGEMAP.GroupID = " + n3 + ")");
        if (object instanceof String) {
            String[] stringArray = new String[]{(String)object};
            String string = this.createKeywordClause(stringArray, "IROBJECTIMAGEMAP", false);
            if (string == null || string.length() <= 0) return null;
            sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ObjectID", "DTTERMOBJECTMAP", "ObjectID", 0);
            sqlQueryGenerator.addJoin("DTTERMOBJECTMAP", "TermID", "DTTERMS", "TermID", 0);
            stringBuffer.append(" AND (" + string + ")");
        } else if (object instanceof Vector && (objectArray = ((Vector)object).toArray(new Object[0])) != null && objectArray.length > 0) {
            Hashtable hashtable = new Hashtable();
            String string = this.createCriteriaClause(objectArray, false, hashtable);
            if (string == null || string.length() <= 0) return null;
            if (hashtable.get("DTTERMOBJECTMAP") != null) {
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ObjectID", "DTTERMOBJECTMAP", "ObjectID", 0);
                sqlQueryGenerator.addJoin("DTTERMOBJECTMAP", "TermID", "DTTERMS", "TermID", 0);
            }
            if (hashtable.get("DTVALUES") != null) {
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ObjectID", "DTVALUETOOBJECT", "ObjectID", 0);
                sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "ValueID", "DTVALUES", "ValueID", 0);
            }
            if (hashtable.get("IRIMAGEFILES") != null) {
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ImageID", "IRIMAGEFILES", "ImageID", 0);
            }
            if (hashtable.get("IRLINKREPOSITORY") != null) {
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ImageID", "IRLINKREPOSITORY", "ImageID", 0);
            }
            if (hashtable.get("DTHIERARCHYTOOBJECT") != null) {
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ObjectID", "DTHIERARCHYTOOBJECT", "ObjectID", 0);
            }
            stringBuffer.append(" AND (" + string + ")");
        }
        if (n2 > 0) {
            sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ObjectID", "ITSEARCHRESULTS", "ObjectID", 0);
            stringBuffer.append(" AND (ITSEARCHRESULTS.CriteriaID = " + (n2 - 1) + " AND " + "ITSEARCHRESULTS" + ".SearchQueryID = " + n + ")");
        }
        sqlQueryGenerator.appendToWhere(stringBuffer.toString());
        return "INSERT INTO ITSEARCHRESULTS " + sqlQueryGenerator.getQuery();
    }

    protected String getThumbnailResultsQuery(int n, int n2) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("ITSEARCHRESULTS", null, new String[]{"ObjectID", "MediaID AS ImageID"});
        sqlQueryGenerator.addTable("IRGROUPIMAGEMAP", null, new String[]{"MviSeries", "MpdSeries", "AbsoluteOrder"});
        sqlQueryGenerator.addJoin("ITSEARCHRESULTS", "MediaID", "IRGROUPIMAGEMAP", "ImageID", 0);
        sqlQueryGenerator.appendToWhere("ITSEARCHRESULTS.SearchQueryID = " + n);
        sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.GroupID = " + n2);
        return sqlQueryGenerator.getQuery();
    }

    protected String getThumbnailResultsQuery(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("ITSEARCHRESULTS", null, new String[]{"ObjectID", "MediaID AS ImageID"});
        sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"Width AS ThumbWidth", "Height AS ThumbHeight", "Filename", "MediaType"});
        sqlQueryGenerator.addTable("IRGROUPIMAGEMAP", null, new String[]{"MviSeries", "MpdSeries", "AbsoluteOrder"});
        sqlQueryGenerator.addJoin("ITSEARCHRESULTS", "MediaID", "IRIMAGEFILES", "ImageID", 0);
        sqlQueryGenerator.addJoin("IRGROUPIMAGEMAP", "IRIMAGEFILES", "ImageID", 0);
        sqlQueryGenerator.appendToWhere("ITSEARCHRESULTS.SearchQueryID = " + n);
        sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.GroupID = " + n2);
        sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ResolutionSize = " + n3);
        boolean bl2 = bl = n4 >= 0 || n5 >= 0;
        if (bl) {
            sqlQueryGenerator.addTable("IRSPS", null, new String[]{"URL"});
            sqlQueryGenerator.addTable("IRLPS", null, new String[]{"LPS"});
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.addJoin("IRSPS", "IRPROFILE", new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileId = " + n4);
            sqlQueryGenerator.appendToWhere("IRPROFILE.CollectionId = " + n5);
        }
        return sqlQueryGenerator.getQuery();
    }

    protected String getThumbnailLabelsQuery(int n, TrinityFieldProfile[] trinityFieldProfileArray, TrinityFieldProfile[] trinityFieldProfileArray2) {
        String string = TrinityConnector.createFieldIDClause(trinityFieldProfileArray, trinityFieldProfileArray2, "IRFIELDS");
        if (string.length() > 0) {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ITSEARCHRESULTS", null, "ObjectID");
            sqlQueryGenerator.addTable("IRFIELDS", null, "FieldID");
            sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"ValueText", "ValueNumber"});
            sqlQueryGenerator.addJoin("ITSEARCHRESULTS", "DTVALUETOOBJECT", "ObjectID", 0);
            sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", "ValueID", 0);
            sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("ITSEARCHRESULTS.SearchQueryID = " + n);
            sqlQueryGenerator.appendToWhere(string);
            sqlQueryGenerator.appendToWhere("DTVALUETOOBJECT.Preferred = 1");
            sqlQueryGenerator.appendToWhere("DTVALUES.Enabled = 1");
            return sqlQueryGenerator.getQuery();
        }
        return "";
    }

    public void resetSearchQueryID() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxSearchQueryID = 0");
            this.debugOut("Reset max search query ID:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
        }
        catch (Exception exception) {
            this.debugOut("Exception in resetSearchQueryID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in resetSearchQueryID():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    public void clearAllSearchResults() {
        this.clearAllSearchResults(null);
    }

    public void clearAllSearchResults(DatabaseConnector databaseConnector) {
        this.clearSearchResults(-1, true, databaseConnector);
    }

    public void clearSearchResults(int n) {
        this.clearSearchResults(n, false, null);
    }

    public void clearSearchResults(int n, DatabaseConnector databaseConnector) {
        this.clearSearchResults(n, false, databaseConnector);
    }

    public void clearSearchResults(int n, boolean bl, DatabaseConnector databaseConnector) {
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            databaseConnector.setQuery("DELETE FROM ITSEARCHRESULTS" + (bl ? "" : " WHERE SearchQueryID = " + n));
            this.debugOut("Clear ITSEARCHRESULTS cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
        }
        catch (Exception exception) {
            this.debugOut("Exception in clearSearchResults():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in clearSearchResults():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextUserGroupID() {
        int n = 0;
        DatabaseConnector databaseConnector = null;
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("SELECT MAX(GroupID) AS MaxGroupID FROM IRUSERGROUPS");
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n = databaseConnector.getIntegerField("MaxGroupID") + 1;
                }
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            TrinityConnector.debugFile("Exception in getNextUserGroupID():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextProfileID() {
        int n = 0;
        DatabaseConnector databaseConnector = null;
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("SELECT MAX(ProfileID) AS MaxProfileID FROM IRPROFILE");
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n = databaseConnector.getIntegerField("MaxProfileID") + 1;
                }
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            TrinityConnector.debugFile("Exception in getNextProfileID():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    protected int getNextSearchQueryID() {
        return this.getNextSearchQueryID(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextSearchQueryID(DatabaseConnector databaseConnector) {
        int n = 1;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = SEARCH_QUERY_ID_LOCK_OBJECT;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxSearchQueryID FROM IRMAXIDS");
                this.debugOut("Get next search query ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n2 = 0;
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("MaxSearchQueryID");
                }
                databaseConnector.close();
                if (n2 == Integer.MAX_VALUE) {
                    n2 = 0;
                }
                n = n2 + 1;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxSearchQueryID = " + n);
                this.debugOut("Set max search query ID:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextSearchQueryID():\n" + InsightUtilities.getStackTrace(exception));
            n = -1;
        }
        databaseConnector.close();
        return n;
    }

    protected int[] getNextCollectionID() {
        return this.getNextCollectionID(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getNextCollectionID(DatabaseConnector databaseConnector) {
        int n = 1;
        int n2 = 1;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxCollectionID, MaxUniqueCollectionID FROM IRMAXIDS");
                this.debugOut("Get next collection ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n3 = 0;
                int n4 = 0;
                if (databaseConnector.more()) {
                    n3 = databaseConnector.getIntegerField("MaxCollectionID");
                    n4 = databaseConnector.getIntegerField("MaxUniqueCollectionID");
                }
                databaseConnector.close();
                if (n3 <= 0 || n4 <= 0) {
                    n3 = 0;
                    n4 = 0;
                    databaseConnector.setQuery("SELECT CollectionID, UniqueCollectionID FROM IRCOLLECTIONCONFIGURATIONINFO");
                    this.debugOut("Get current collection IDs query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        int n5 = databaseConnector.getIntegerField("CollectionID");
                        int n6 = databaseConnector.getIntegerField("UniqueCollectionID");
                        if (n5 > n3) {
                            n3 = n5;
                        }
                        if (n6 > n4) {
                            n4 = n6;
                        }
                        databaseConnector.next();
                    }
                }
                n = n3 + 1;
                n2 = n4 + 1;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxCollectionID = " + n + ", MaxUniqueCollectionID = " + n2);
                this.debugOut("Set max collection IDs:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextCollectionID():\n" + InsightUtilities.getStackTrace(exception));
            n = -1;
        }
        databaseConnector.close();
        return new int[]{n, n2};
    }

    protected long getNextObjectID() {
        return this.getNextObjectID(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextObjectID(DatabaseConnector databaseConnector) {
        long l = 1L;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxObjectID FROM IRMAXIDS");
                this.debugOut("Get next object ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                long l2 = 0L;
                if (databaseConnector.more()) {
                    l2 = databaseConnector.getLongField("MaxObjectID");
                }
                databaseConnector.close();
                if (l2 <= 0L) {
                    databaseConnector.setQuery("SELECT MAX(ObjectID) AS MaxObjectID FROM DTVALUETOOBJECT");
                    this.debugOut("Get max object ID from DTVALUETOOBJECT query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    l2 = databaseConnector.getLongField("MaxObjectID");
                    databaseConnector.close();
                }
                l = l2 + 1L;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxObjectID = " + l);
                this.debugOut("Set max object ID:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextObjectID():\n" + InsightUtilities.getStackTrace(exception));
            l = -1L;
        }
        databaseConnector.close();
        return l;
    }

    protected long getNextMediaID() {
        return this.getNextMediaID(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextMediaID(DatabaseConnector databaseConnector) {
        long l = 1L;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxMediaID FROM IRMAXIDS");
                this.debugOut("Get next media ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                long l2 = 0L;
                if (databaseConnector.more()) {
                    l2 = databaseConnector.getLongField("MaxMediaID");
                }
                databaseConnector.close();
                if (l2 <= 0L) {
                    databaseConnector.setQuery("SELECT MAX(ImageID) AS MaxMediaID FROM IRIMAGEFILES");
                    this.debugOut("Get max media ID from IRIMAGEFILES query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    l2 = databaseConnector.getLongField("MaxMediaID");
                    databaseConnector.close();
                }
                l = l2 + 1L;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxMediaID = " + l);
                this.debugOut("Set max media ID:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextMediaID():\n" + InsightUtilities.getStackTrace(exception));
            l = -1L;
        }
        databaseConnector.close();
        return l;
    }

    protected int getNextLpsID() {
        return this.getNextLpsID(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextLpsID(DatabaseConnector databaseConnector) {
        int n = 1;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxLpsID FROM IRMAXIDS");
                this.debugOut("Get next LPS ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n2 = 0;
                int n3 = 0;
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("MaxLpsID");
                }
                databaseConnector.close();
                databaseConnector.setQuery("SELECT MAX(LPSid) AS MaxLpsID FROM IRLPS");
                this.debugOut("Get max LPS ID from IRLPS query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                n3 = databaseConnector.getIntegerField("MaxLpsID");
                databaseConnector.close();
                if (n3 > n2) {
                    n2 = n3;
                }
                n = n2 + 1;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxLpsID = " + n);
                this.debugOut("Set max LPS ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextLpsID():\n" + InsightUtilities.getStackTrace(exception));
            n = -1;
        }
        databaseConnector.close();
        return n;
    }

    protected int getNextSpsNumber() {
        return this.getNextSpsNumber(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextSpsNumber(DatabaseConnector databaseConnector) {
        int n = 1;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            Object object = MAX_IDS_LOCK_OBJ;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxSpsNumber FROM IRMAXIDS");
                this.debugOut("Get next SPS number query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n2 = 0;
                int n3 = 0;
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("MaxSpsNumber");
                }
                databaseConnector.close();
                databaseConnector.setQuery("SELECT MAX(SPSNum) AS MaxSPSNum FROM IRSPS");
                this.debugOut("Get max SPS number from IRSPS query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                n3 = databaseConnector.getIntegerField("MaxSPSNum");
                databaseConnector.close();
                if (n3 > n2) {
                    n2 = n3;
                }
                n = n2 + 1;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxSpsNumber = " + n);
                this.debugOut("Set max SPS number query:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextSpsNumber():\n" + InsightUtilities.getStackTrace(exception));
            n = -1;
        }
        databaseConnector.close();
        return n;
    }

    protected int getNextFieldID() {
        return this.getNextFieldID(null);
    }

    protected int getNextFieldID(DatabaseConnector databaseConnector) {
        return this.getNextAbstractIntegerID(databaseConnector, "MaxFieldID", "SELECT MAX(FieldID) AS MaxFieldID FROM (SELECT FieldID FROM IRFIELDS UNION SELECT FieldID FROM ISENTITYFIELDS UNION SELECT EntityTypeID AS FieldID FROM ISENTITYTYPES) MaxUnion");
    }

    protected int getNextBatchID() {
        return this.getNextBatchID(null);
    }

    protected int getNextBatchID(DatabaseConnector databaseConnector) {
        return this.getNextAbstractIntegerID(databaseConnector, "MaxBatchID", "SELECT MAX(BatchID) AS MaxBatchID FROM CCMEDIABATCHES");
    }

    protected long getNextBatchElementID(int n) {
        return this.getNextBatchElementID(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextBatchElementID(DatabaseConnector databaseConnector, int n) {
        long l = -1L;
        try {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            databaseConnector.setQuery("SELECT MAX(BatchElementID) AS MaxID FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + n);
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("MaxID", l);
            }
            l = l == -1L ? 1L : ++l;
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextBatchElementID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getNextBatchElementID():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return l;
    }

    protected int getNextTableID() {
        return this.getNextTableID(null);
    }

    protected int getNextTableID(DatabaseConnector databaseConnector) {
        return this.getNextAbstractIntegerID(databaseConnector, "MaxTableID", "SELECT MAX(TableID) AS MaxTableID FROM (SELECT TableID FROM ISTABLES UNION SELECT TableID FROM IRFIELDS UNION SELECT FieldTableID AS TableID FROM ISENTITYFIELDS UNION SELECT EntityTableID AS TableID FROM ISENTITYTYPES) MaxUnion");
    }

    protected int getNextFieldStandardID() {
        return this.getNextFieldStandardID(null);
    }

    protected int getNextFieldStandardID(DatabaseConnector databaseConnector) {
        return this.getNextAbstractIntegerID(databaseConnector, "MaxStandardID", "SELECT MAX(StandardID) AS MaxStandardID FROM SLSTANDARDSLOOKUP");
    }

    protected long getNextEntityID() {
        return this.getNextEntityID(null);
    }

    protected long getNextEntityID(int n) {
        return this.getNextEntityID(null, n);
    }

    protected long getNextEntityID(DatabaseConnector databaseConnector) {
        return this.getNextEntityID(databaseConnector, 1);
    }

    protected long getNextEntityID(DatabaseConnector databaseConnector, int n) {
        return this.getNextAbstractLongID(databaseConnector, "MaxEntityID", "SELECT MAX(EntityID) AS MaxEntityID FROM ISCOLLECTIONENTITYMAP", n);
    }

    public long getNextEntityChangeID(DatabaseConnector databaseConnector) {
        return this.getNextEntityChangeID(databaseConnector, 1);
    }

    protected long getNextEntityChangeID(DatabaseConnector databaseConnector, int n) {
        return this.getNextAbstractLongID(databaseConnector, "MaxChangeID", "SELECT MAX(ChangeID) AS MaxChangeID FROM IRENTITYCHANGES", n);
    }

    protected long getMaxEntityChangeID() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery("SELECT MaxChangeID FROM IRMAXIDS");
        this.debugOut("Get max change ID query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        long l = 0L;
        try {
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("MaxChangeID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxEntityChangeID():\n" + InsightUtilities.getStackTrace(exception));
            l = 0L;
        }
        databaseConnector.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextAbstractIntegerID(DatabaseConnector databaseConnector, String string, String string2) {
        int n = 1;
        if (InsightUtilities.isNonEmpty(string)) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                Object object = MAX_IDS_LOCK_OBJ;
                synchronized (object) {
                    databaseConnector.setQuery("SELECT " + string + " FROM " + "IRMAXIDS");
                    this.debugOut("Get next ID query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    int n2 = 0;
                    if (databaseConnector.more()) {
                        n2 = databaseConnector.getIntegerField(string);
                    }
                    databaseConnector.close();
                    if (n2 <= 0 && InsightUtilities.isNonEmpty(string2)) {
                        databaseConnector.setQuery(string2);
                        this.debugOut("Get max ID query:\n" + databaseConnector.getQuery());
                        databaseConnector.runQuerySafe();
                        if (databaseConnector.more()) {
                            n2 = databaseConnector.getIntegerField(string);
                        }
                        databaseConnector.close();
                    }
                    n = n2 + 1;
                    databaseConnector.setQuery("UPDATE IRMAXIDS SET " + string + " = " + n);
                    this.debugOut("Set max ID:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                }
            }
            catch (Error error) {
                this.debugOut("Error in getNextAbstractIntegerID():\n" + InsightUtilities.getStackTrace(error));
                n = -1;
            }
            catch (Exception exception) {
                this.debugOut("Exception in getNextAbstractIntegerID():\n" + InsightUtilities.getStackTrace(exception));
                n = -1;
            }
            databaseConnector.close();
        }
        return n;
    }

    protected long getNextAbstractLongID(DatabaseConnector databaseConnector, String string, String string2) {
        return this.getNextAbstractLongID(databaseConnector, string, string2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextAbstractLongID(DatabaseConnector databaseConnector, String string, String string2, int n) {
        long l = 1L;
        if (InsightUtilities.isNonEmpty(string)) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                Object object = MAX_IDS_LOCK_OBJ;
                synchronized (object) {
                    databaseConnector.setQuery("SELECT " + string + " FROM " + "IRMAXIDS");
                    this.debugOut("Get next ID query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    long l2 = 0L;
                    if (databaseConnector.more()) {
                        l2 = databaseConnector.getLongField(string);
                    }
                    databaseConnector.close();
                    if (l2 <= 0L && InsightUtilities.isNonEmpty(string2)) {
                        databaseConnector.setQuery(string2);
                        this.debugOut("Get max ID query:\n" + databaseConnector.getQuery());
                        databaseConnector.runQuery();
                        l2 = databaseConnector.getLongField(string);
                        databaseConnector.close();
                    }
                    l = l2 + 1L;
                    databaseConnector.setQuery("UPDATE IRMAXIDS SET " + string + " = " + (l2 + (long)n));
                    this.debugOut("Set max ID:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getNextAbstractLongID():\n" + InsightUtilities.getStackTrace(exception));
                l = -1L;
            }
            databaseConnector.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCollectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", "CollectionName");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get collection names query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                arrayList.add(databaseConnector.getField("CollectionName"));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionNames():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getCollectionNames():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    public boolean isCollectionNameInUse(String string) {
        List list;
        this.debugOut("in isCollectionNameInUse().");
        return !InsightUtilities.isNonEmpty(string) || (list = this.getCollectionNames()) == null || new HashSet(list).contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPersonalCollections(InsightLicenseNamedUsers insightLicenseNamedUsers, InsightUser insightUser, int n) {
        this.debugOut("in getPersonalCollections().");
        Vector<TrinityCollectionInfo> vector = new Vector<TrinityCollectionInfo>();
        if (insightUser != null || n > -1) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                int n2 = this.getInsightUserID(insightUser, false, databaseConnector);
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, new String[]{"InstitutionID", "CollectionID", "VCID", "CollectionName", "CopyrightStatement", "ForceCollectionNameDisplay", "InitialGroupOpen", "PcUserGroupMemberPrivs", "PcNonUserGroupMemberPrivs", "UniqueCollectionID"});
                sqlQueryGenerator.addTable("IRUSERS", null, "*");
                sqlQueryGenerator.addTable("IRUSERGROUPS", null, "*");
                sqlQueryGenerator.addJoin("IRCOLLECTIONCONFIGURATIONINFO", "PcOwnerID", "IRUSERS", "UserID", 0);
                sqlQueryGenerator.addJoin("IRCOLLECTIONCONFIGURATIONINFO", "PcOwnerUserGroupID", "IRUSERGROUPS", "GroupID", 0);
                sqlQueryGenerator.appendToWhere("IsPersonalCollection = 1");
                sqlQueryGenerator.addOrderBy("IRCOLLECTIONCONFIGURATIONINFO", "CollectionName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get personal collection info query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                boolean bl = false;
                while (databaseConnector.more()) {
                    String string = databaseConnector.getStringField("GroupName");
                    String string2 = databaseConnector.getStringField("GroupCodeKey");
                    int n3 = databaseConnector.getIntegerField("PcUserGroupMemberPrivs");
                    int n4 = databaseConnector.getIntegerField("PcNonUserGroupMemberPrivs");
                    boolean bl2 = bl = databaseConnector.getIntegerField("UserID") == n2;
                    if (!bl) {
                        bl = databaseConnector.getIntegerField("GroupID") == n ? PersonalCollection.hasPermissionSetting((int)n3, (int)1) : PersonalCollection.hasPermissionSetting((int)n4, (int)1);
                    }
                    if (bl) {
                        TrinityCollectionInfo trinityCollectionInfo = new TrinityCollectionInfo();
                        if (insightLicenseNamedUsers != null && !insightLicenseNamedUsers.isLicensedPCNamedUser(insightUser.getLoginName())) {
                            n3 &= 1;
                            n4 &= 1;
                            trinityCollectionInfo.setPcOwner(null);
                        }
                        trinityCollectionInfo.setPcOwner(this.getInsightUser(databaseConnector));
                        trinityCollectionInfo.setUniqueCollectionID(new Integer(databaseConnector.getIntegerField("UniqueCollectionID")));
                        trinityCollectionInfo.setInstitutionID(databaseConnector.getStringField("InstitutionID"));
                        trinityCollectionInfo.setCollectionID(databaseConnector.getStringField("CollectionID"));
                        trinityCollectionInfo.setVCID(databaseConnector.getStringField("VCID"));
                        trinityCollectionInfo.setCollectionName(databaseConnector.getStringField("CollectionName"));
                        trinityCollectionInfo.setCopyrightStatement(databaseConnector.getStringField("CopyrightStatement"));
                        trinityCollectionInfo.setForceCollectionName(databaseConnector.getBooleanField("ForceCollectionNameDisplay"));
                        trinityCollectionInfo.setInitialGroupOpen(databaseConnector.getStringField("InitialGroupOpen"));
                        trinityCollectionInfo.setPersonalCollection(true);
                        trinityCollectionInfo.setPcUsrGrpMemberPrivs(n3);
                        trinityCollectionInfo.setPcNonUsrGrpMemberPrivs(n4);
                        trinityCollectionInfo.setPcOwnerSessionGroupName(string);
                        trinityCollectionInfo.setPcOwnerSessionCodeKey(string2);
                        vector.add(trinityCollectionInfo);
                    }
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getPersonalCollections():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in getPersonalCollections():\n" + InsightUtilities.getStackTrace(error));
            }
            finally {
                databaseConnector.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPersonalCollectionServer() {
        DatabaseConnector databaseConnector = null;
        boolean bl = false;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRVERSION", null, "IsPersonalCollectionServer");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                bl = databaseConnector.getBooleanField("IsPersonalCollectionServer", false);
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isPersonalCollectionServer():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCreatePersonalCollections(UserGroup userGroup) {
        DatabaseConnector databaseConnector = null;
        boolean bl = false;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRPROFILE", null, "EditPersonalCollections");
            sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileID = " + userGroup.getProfileID());
            sqlQueryGenerator.appendToWhere("IRPROFILE.CollectionID = 0");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                bl = databaseConnector.getBooleanField("EditPersonalCollections", false);
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in canEditPersonalCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List publishMediaFiles(Integer n, int n2, List list, boolean bl) {
        this.debugOut("in publishMediaFiles()");
        boolean bl2 = false;
        HashSet<Long> hashSet = new HashSet<Long>();
        DatabaseConnector databaseConnector = null;
        try {
            if (list != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object = list.iterator();
                while (object.hasNext()) {
                    Long l = (Long)object.next();
                    String string = "DELETE FROM IRGROUPIMAGEMAP WHERE GroupID = " + n2 + " AND ImageID = " + l;
                    arrayList.add(string);
                    if (!bl) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, n2);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, l);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MVISeries", 2, stringBuffer2, 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MPDSeries", 2, stringBuffer2, 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "AbsoluteOrder", 2, stringBuffer2, 0);
                    String string2 = "INSERT INTO IRGROUPIMAGEMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                    arrayList.add(string2);
                }
                if (arrayList.size() > 0) {
                    databaseConnector = this.getDatabaseConnector();
                    databaseConnector.executeBatch(arrayList, true);
                    databaseConnector.close();
                    object = "SELECT EntityID FROM IRENTITYMEDIAMAP WHERE MediaID IN (" + InsightUtilities.getUniqueListString(list) + ")";
                    databaseConnector.setQuery((String)object);
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        hashSet.add(new Long(databaseConnector.getLongField("EntityID")));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    bl2 = true;
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in publishMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in publishMediaFiles():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl2 ? new ArrayList(hashSet) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long importMediaFiles(Integer n, List list, int n2) {
        this.debugOut("in importMediaFiles()");
        long l = -1L;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            long l2 = this.getNextMediaID();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, stringBuffer2, l2);
            databaseConnector.setQuery("INSERT INTO IRCOLLECTIONMEDIAMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert collection media mapping cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            for (int i = 0; i < list.size(); ++i) {
                ImageFile imageFile = (ImageFile)list.get(i);
                int n3 = imageFile.resolution;
                String string = ImageFile.getFormatTypeToString(imageFile.format);
                int n4 = imageFile.mediaType;
                String string2 = imageFile.filename;
                int n5 = imageFile.imageSize.width;
                int n6 = imageFile.imageSize.height;
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, l2);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Format", 1, stringBuffer2, string);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionSize", 2, stringBuffer2, n3);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaType", 2, stringBuffer2, n4);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LPSid", 2, stringBuffer2, n2);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FileName", 1, stringBuffer2, string2);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Width", 2, stringBuffer2, n5);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Height", 2, stringBuffer2, n6);
                databaseConnector.setQuery("INSERT INTO IRIMAGEFILES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Insert image files cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
            l = l2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in importMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in importMediaFiles():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long savePersonalCollectionMediaFiles(Integer n, List list, String string, String string2, Entity entity, int n2) {
        this.debugOut("in savePersonalCollectionMediaFiles()");
        long l = -1L;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            long l2 = this.getNextMediaID();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, stringBuffer2, l2);
            databaseConnector.setQuery("INSERT INTO IRCOLLECTIONMEDIAMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert collection media mapping cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, entity.getEntityID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, l2);
            databaseConnector.setQuery("INSERT INTO IROBJECTIMAGEMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert object image mapping cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, entity.getEntityTypeID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, entity.getEntityID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, stringBuffer2, l2);
            databaseConnector.setQuery("INSERT INTO IRENTITYMEDIAMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert entity media mapping cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            long l3 = this.getGroupID(n, string2, string);
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, l3);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, l2);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, 0);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "AbsoluteOrder", 2, stringBuffer2, 0);
            databaseConnector.setQuery("INSERT INTO IRGROUPIMAGEMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert group image mapping cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            for (int i = 0; i < list.size(); ++i) {
                ImageFile imageFile = (ImageFile)list.get(i);
                int n3 = imageFile.resolution;
                String string3 = ImageFile.getFormatTypeToString(imageFile.format);
                int n4 = imageFile.mediaType;
                String string4 = imageFile.filename;
                int n5 = imageFile.imageSize.width;
                int n6 = imageFile.imageSize.height;
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, l2);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Format", 1, stringBuffer2, string3);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionSize", 2, stringBuffer2, n3);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaType", 2, stringBuffer2, n4);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LPSid", 2, stringBuffer2, n2);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FileName", 1, stringBuffer2, string4);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Width", 2, stringBuffer2, n5);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Height", 2, stringBuffer2, n6);
                databaseConnector.setQuery("INSERT INTO IRIMAGEFILES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Insert image files cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
            }
            l = l2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in savePersonalCollectionMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in savePersonalCollectionMediaFiles():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return l;
    }

    public boolean saveInscribeImportedMediaFiles(Integer n, List list, String string, String string2, int n2, long l, MutableLong mutableLong) {
        this.debugOut("in saveInscribeImportedMediaFiles()");
        if (!PersonalCollection.isTempID((long)l)) {
            this.debugOut("saveInscribeImportedMediaFiles() returning:  media ID is not temporary (i.e. not new media).");
            return false;
        }
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (mutableLong == null) {
                mutableLong = new MutableLong();
            }
            mutableLong.setValue(this.getNextMediaID());
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, n);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, stringBuffer2, mutableLong.getValue());
            databaseConnector.setQuery("INSERT INTO IRCOLLECTIONMEDIAMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert collection media mapping cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                ImageFile imageFile = (ImageFile)list.get(i);
                int n3 = imageFile.resolution;
                String string3 = ImageFile.getFormatTypeToString(imageFile.format);
                int n4 = imageFile.mediaType;
                String string4 = imageFile.URL;
                int n5 = imageFile.imageSize.width;
                int n6 = imageFile.imageSize.height;
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, mutableLong.getValue());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Format", 1, stringBuffer2, string3);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionSize", 2, stringBuffer2, n3);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaType", 2, stringBuffer2, n4);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LPSid", 2, stringBuffer2, n2);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FileName", 1, stringBuffer2, string4);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Width", 2, stringBuffer2, n5);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Height", 2, stringBuffer2, n6);
                databaseConnector.setQuery("INSERT INTO IRIMAGEFILES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Insert image files cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
            }
            bl = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveInscribeImportedMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in saveInscribeImportedMediaFiles():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return bl;
    }

    public int getLpsID(String string, boolean bl) {
        this.debugOut("in getLpsID()");
        int n = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT LPSid FROM IRLPS WHERE LPS = " + this.prepStringForQuery(string));
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("LPSid");
            } else if (bl) {
                int n2 = this.getNextLpsID();
                databaseConnector.close();
                databaseConnector.setQuery("INSERT INTO IRLPS (LPSid, LPS) VALUES (" + n2 + ", " + this.prepStringForQuery(string) + ")");
                this.debugOut("Insert LPS record cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                n = n2;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getLpsID():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getLpsID():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return n;
    }

    public List getSpsRecords() {
        this.debugOut("in getSpsRecords()");
        Vector<SpsRecord> vector = new Vector<SpsRecord>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRSPS", null, "*");
            sqlQueryGenerator.addOrderBy("IRSPS", "SPSNum");
            sqlQueryGenerator.addOrderBy("IRSPS", "ResolutionSize");
            sqlQueryGenerator.addOrderBy("IRSPS", "MediaType");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                SpsRecord spsRecord = new SpsRecord(databaseConnector.getIntegerField("SPSNum"), databaseConnector.getIntegerField("ResolutionSize"), databaseConnector.getIntegerField("CollectionId"), databaseConnector.getIntegerField("MediaType"), databaseConnector.getStringField("Format"), databaseConnector.getStringField("URL"));
                vector.add(spsRecord);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getSpsRecords():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return vector;
    }

    public int addNewSpsRecords(List list) {
        this.debugOut("in addNewSpsRecords()");
        int n = -1;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            n = this.getNextSpsNumber();
            for (int i = 0; list != null && i < list.size(); ++i) {
                SpsRecord spsRecord = (SpsRecord)list.get(i);
                databaseConnector.setQuery("INSERT INTO IRSPS (SPSNum, ResolutionSize, CollectionId, MediaType, Format, URL) VALUES (" + n + ", " + spsRecord.resolutionSize + ", " + spsRecord.collectionID + ", " + spsRecord.mediaType + ", " + this.prepStringForQuery(spsRecord.format) + ", " + this.prepStringForQuery(spsRecord.url) + ")");
                this.debugOut("Insert SPS record cmd:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in addNewSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in addNewSpsRecords():\n" + InsightUtilities.getStackTrace(error));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteVirtualCollection(Integer n, CollectionKey collectionKey) {
        boolean bl = true;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
            sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            sqlQueryGenerator.appendToWhere("InstitutionID = '" + collectionKey.getInstitutionID() + "'");
            sqlQueryGenerator.appendToWhere("CollectionID = '" + collectionKey.getCollectionID() + "'");
            sqlQueryGenerator.appendToWhere("VCID = '" + collectionKey.getVCID() + "'");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n2 = 0;
            while (databaseConnector.more() && ++n2 <= 1) {
                databaseConnector.next();
            }
            databaseConnector.close();
            if (n2 != 1) {
                this.debugOut("deleteVirtualCollection:  found " + n2 + " rows matching criteria.  Need to find exactly 1 to proceed.");
                bl = false;
            } else {
                databaseConnector.setQuery("DELETE FROM IRCOLLECTIONCONFIGURATIONINFO WHERE UniqueCollectionID = " + n + " AND " + "InstitutionID = '" + collectionKey.getInstitutionID() + "' AND " + "CollectionID = '" + collectionKey.getCollectionID() + "' AND " + "VCID = '" + collectionKey.getVCID() + "'");
                int n3 = databaseConnector.runUpdateQuery();
                if (n3 != 1) {
                    this.debugOut("deleteVirtualCollection: deleted " + n3 + " rows from " + "IRCOLLECTIONCONFIGURATIONINFO" + "  Expected to delete 1.");
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteVirtualCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in deleteVirtualCollections():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    public boolean deleteCollection(Integer n) {
        boolean bl = false;
        Set set = null;
        Set set2 = null;
        HashSet<Integer> hashSet = null;
        Set set3 = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            List<String> list;
            set = this.getIntegerIDSet(databaseConnector, "IRGROUPS", "GroupID", "UniqueCollectionID", Collections.singleton(n));
            if (set == null) {
                return false;
            }
            set2 = this.getIntegerIDSet(databaseConnector, "ISCOLLECTIONENTITYMAP", "EntityID", "UniqueCollectionID", Collections.singleton(n));
            set3 = this.getLongIDSet(databaseConnector, "IRCOLLECTIONMEDIAMAP", "MediaID", "UniqueCollectionID", Collections.singleton(n));
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", "StandardID");
            sqlQueryGenerator.addJoin("SLSTANDARDSLOOKUP", "SLCOLLECTIONSTANDARDMAP", "StandardID", 0);
            sqlQueryGenerator.appendToWhere("SLCOLLECTIONSTANDARDMAP.UniqueCollectionID = " + n);
            sqlQueryGenerator.appendToWhere("SLSTANDARDSLOOKUP.Standard_Type = 4");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get standard ids query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            hashSet = new HashSet<Integer>();
            while (databaseConnector.more()) {
                hashSet.add(new Integer(databaseConnector.getIntegerFieldByName("StandardID")));
                databaseConnector.next();
            }
            databaseConnector.close();
            if (set2 != null) {
                list = Arrays.asList("DTHIERARCHYTOOBJECT", "IROBJECTIMAGEMAP");
                this.deleteData(databaseConnector, list, "ObjectID", set2);
                list = Arrays.asList("IRENTITYLOCKS", "IRENTITYMEDIAMAP");
                this.deleteData(databaseConnector, list, "EntityID", set2);
            }
            if (set3 != null) {
                this.deleteMediaRecords(set3);
            }
            list = Arrays.asList("IRGROUPIMAGEMAP", "IRIMAGESERIES");
            this.deleteData(databaseConnector, list, "GroupID", set);
            list = Arrays.asList("DTVALUETOENTITYMAP", "IRCOLLECTIONCONFIGURATIONINFO", "IRENTITYCHANGES", "IRUSERGROUPS", "SLCOLLECTIONSTANDARDMAP", "IRGROUPS", "DTFLATOBJECTDATA", "DTTERMOBJECTMAP", "DTVALUETOOBJECT", "DTENTITYTOENTITYMAP", "DTTERMTOENTITYMAP", "ISCOLLECTIONENTITYMAP", "DTVALUES");
            this.deleteData(databaseConnector, list, "UniqueCollectionID", Collections.singleton(n));
            if (hashSet != null) {
                list = Arrays.asList("SLSTANDARDSLOOKUP", "SLSTANDARDSSTARTUP");
                this.deleteData(databaseConnector, list, "StandardID", hashSet);
            }
            bl = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in deleteCollection():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return bl;
    }

    public Set getIntegerIDSet(DatabaseConnector databaseConnector, String string, String string2, String string3, Set set) throws Exception {
        return this.getIDSet(databaseConnector, string, string2, string3, set, false);
    }

    public Set getLongIDSet(DatabaseConnector databaseConnector, String string, String string2, String string3, Set set) throws Exception {
        return this.getIDSet(databaseConnector, string, string2, string3, set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getIDSet(DatabaseConnector databaseConnector, String string, String string2, String string3, Set set, boolean bl) throws Exception {
        HashSet<Number> hashSet = new HashSet<Number>();
        try {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            String string4 = "";
            if (set != null && set.size() == 1) {
                string4 = string3 + " = " + set.toArray()[0];
            } else if (set != null && set.size() > 1) {
                string4 = string3 + " IN " + this.buildInClause(set);
            }
            String string5 = "SELECT DISTINCT " + string2 + " FROM " + string + " WHERE " + string4;
            databaseConnector.setQuery(string5);
            this.debugOut("Get IDSet query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                if (bl) {
                    hashSet.add(new Long(databaseConnector.getLongField(string2)));
                } else {
                    hashSet.add(new Integer(databaseConnector.getIntegerField(string2)));
                }
                databaseConnector.next();
            }
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return hashSet.size() == 0 ? null : hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteData(DatabaseConnector databaseConnector, List list, String string, Set set) {
        block8: {
            try {
                if (set != null && set.size() == 1) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        databaseConnector.setQuery("DELETE FROM " + (String)iterator.next() + " WHERE " + string + " = " + set.toArray()[0]);
                        this.debugOut("DELETE DATA query:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                    }
                    break block8;
                }
                if (set == null || set.size() <= 1) break block8;
                int n = 0;
                int n2 = set.size();
                HashSet hashSet = new HashSet();
                Iterator iterator = set.iterator();
                while (true) {
                    Object e = iterator.next();
                    hashSet.add(e);
                    if (--n2 != 0 && ++n != 500) continue;
                    String string2 = string + " IN " + this.buildInClause(hashSet);
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        databaseConnector.setQuery("DELETE FROM " + (String)iterator2.next() + " WHERE " + string2);
                        this.debugOut("DELETE DATA query:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                    }
                    if (n2 == 0) {
                        break;
                    }
                    hashSet.clear();
                    n = 0;
                }
            }
            finally {
                databaseConnector.close();
            }
        }
    }

    private String buildInClause(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (true) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) break;
            stringBuffer.append(", ");
        }
        return "(" + stringBuffer + ")";
    }

    private String buildSubQueryValues(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(string);
        this.debugOut("Entity sub search query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        try {
            while (databaseConnector.more()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(databaseConnector.getIntegerField("ObjectID"));
                databaseConnector.next();
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append("NULL");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in buildSubQueryValues():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMediaRecords(Set set) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            List<String> list = Arrays.asList("CCMEDIABATCHELEMENTS");
            List<String> list2 = Arrays.asList("IRCOLLECTIONMEDIAMAP", "IRENTITYMEDIAMAP", "IRMEDIAINFO", "ITSEARCHRESULTS");
            List<String> list3 = Arrays.asList("IRIMAGEFILES", "IROBJECTIMAGEMAP", "IRGROUPIMAGEMAP", "IRIMAGESERIESSLIDES", "IRIMAGETODOCUMENTMAP", "IRLINKREPOSITORY", "ISDOCUMENTPAGES");
            this.deleteData(databaseConnector, list, "DestMediaID", set);
            this.deleteData(databaseConnector, list2, "MediaID", set);
            this.deleteData(databaseConnector, list3, "ImageID", set);
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeImageRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePcMediaRecordUrls(long l, String string, String string2) {
        this.debugOut("in updatePcMediaRecordUrls()");
        boolean bl = false;
        if (string != null && string2 != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                sqlQueryGenerator.addTable("IRIMAGEFILES", new String[]{"ResolutionSize", "FileName"});
                sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ImageID = " + l);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get media records to update query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                Vector<String[]> vector = new Vector<String[]>();
                while (databaseConnector.more()) {
                    int n = databaseConnector.getIntegerField("ResolutionSize");
                    String string3 = databaseConnector.getField("FileName");
                    vector.add(new String[]{n + "", string3});
                    databaseConnector.next();
                }
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray = (String[])vector.get(i);
                    if (!stringArray[1].startsWith(string)) continue;
                    String string4 = InsightUtilities.concatFilepath(string2, stringArray[1].substring(string.length()));
                    try {
                        databaseConnector.setQuery("UPDATE IRIMAGEFILES SET FileName = " + this.prepStringForQuery(string4) + " WHERE ImageID = " + l + " AND ResolutionSize = " + stringArray[0]);
                        this.debugOut("Update media URL cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        continue;
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception in updatePcMediaRecordUrls():\n" + InsightUtilities.getStackTrace(exception));
                        continue;
                    }
                    catch (Error error) {
                        this.debugOut("Error in updatePcMediaRecordUrls():\n" + InsightUtilities.getStackTrace(error));
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                this.debugOut("Exception in updatePcMediaRecordUrls():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in updatePcMediaRecordUrls():\n" + InsightUtilities.getStackTrace(error));
            }
            finally {
                databaseConnector.close();
            }
        }
        return bl;
    }

    public boolean isFieldStandardNameUnique(String string) {
        this.debugOut("in isFieldStandardNameUnique().");
        boolean bl = false;
        if (InsightUtilities.isNonEmpty(string)) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardName");
                sqlQueryGenerator.appendToWhere("SLSTANDARDSLOOKUP.StandardName = " + this.prepStringForQuery(string));
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Is standard name unique query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                bl = !databaseConnector.more();
            }
            catch (Exception exception) {
                this.debugOut("Exception in isFieldStandardNameUnique():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in isFieldStandardNameUnique():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return bl;
    }

    public boolean saveFieldStandard(FieldStandard fieldStandard) {
        boolean bl = false;
        if (fieldStandard != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                if (FieldStandard.isTempStandardID(fieldStandard.getStandardID())) {
                    fieldStandard.setStandardID(this.getNextFieldStandardID(databaseConnector));
                }
                this.removeFieldStandard(fieldStandard, databaseConnector);
                StringBuffer stringBuffer = null;
                StringBuffer stringBuffer2 = null;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                Vector<String> vector = new Vector<String>(0);
                Vector vector2 = fieldStandard.getFieldMappings();
                for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                    FieldMapping fieldMapping = (FieldMapping)vector2.get(i);
                    if (fieldStandard.getType() == 4) {
                        fieldMapping.setFieldID(this.getNextFieldID(databaseConnector));
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, fieldStandard.getStandardID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, fieldStandard.getStandardName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldID", 2, stringBuffer2, fieldMapping.getFieldID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldName", 1, stringBuffer2, fieldMapping.getFieldName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldDisplayName", 1, stringBuffer2, fieldMapping.getDisplayName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldType", 2, stringBuffer2, fieldMapping.getFieldType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardPickedField", 2, stringBuffer2, fieldMapping.isPicked() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldDisplayOrder", 2, stringBuffer2, fieldMapping.getDisplayOrder());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDate", 2, stringBuffer2, fieldMapping.isDate() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongString", 2, stringBuffer2, fieldMapping.getStringType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldDescriptionURL", 1, stringBuffer2, fieldMapping.getFieldDescriptionURL());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DataFieldSearchable", 2, stringBuffer2, fieldMapping.isDataFieldSearchable() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayedInThumbnail", 2, stringBuffer2, fieldMapping.isDisplayedInThumbnail() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Sortable", 2, stringBuffer2, fieldMapping.isSortable() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SelectListBehavior", 2, stringBuffer2, fieldMapping.getListMode());
                    vector.add("INSERT INTO SLSTANDARDFIELDS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    this.debugOut("Add field mapping to SLSTANDARDFIELDS cmd:\n" + vector.get(vector.size() - 1));
                    if (fieldStandard.getType() != 4) continue;
                    Field field = new Field();
                    field.setFieldID(fieldMapping.getFieldID());
                    field.setFieldName(fieldMapping.getFieldName());
                    field.setFieldDisplayName(fieldMapping.getDisplayName());
                    field.setFieldDisplayOrder(fieldMapping.getDisplayOrder());
                    field.setFieldGroupID(fieldMapping.getFieldGroupID());
                    field.setDescriptionUrl(fieldMapping.getFieldDescriptionURL());
                    field.setFieldType(fieldMapping.getFieldType() == 3 ? 1 : fieldMapping.getFieldType());
                    field.setPickable(fieldMapping.isPicked());
                    field.setStringType(fieldMapping.getStringType());
                    field.setDate(fieldMapping.isDate());
                    field.setTypeCode(TrinityField.getTypeCode(fieldMapping.getFieldType()));
                    field.setVocabulary(false);
                    field.setMultiValue(false);
                    field.setKeywordSearchable(false);
                    field.setHierarchyMode(Field.HIERARCHY_MODE_NONE);
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldID", 2, stringBuffer2, field.getFieldID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldGroupID", 2, stringBuffer2, field.getFieldGroupID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, field.getFieldDisplayName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldType", 2, stringBuffer2, field.getFieldType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FieldName", 1, stringBuffer2, field.getFieldName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DelimiterType", 2, stringBuffer2, 4);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, field.getFieldDisplayOrder());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "KeywordSearchable", 2, stringBuffer2, field.isKeywordSearchable() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayedInData", 2, stringBuffer2, 1);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SearchPick", 2, stringBuffer2, field.isPickable() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VocabField", 2, stringBuffer2, field.isVocabulary() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongString", 2, stringBuffer2, fieldMapping.getStringType());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MultiValue", 2, stringBuffer2, field.isMultiValue() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsDate", 2, stringBuffer2, field.isDate() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HierarchyMode", 2, stringBuffer2, field.getHierarchyMode());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CustomStandardID", 2, stringBuffer2, fieldStandard.getStandardID());
                    vector.add("INSERT INTO IRFIELDS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    this.debugOut("Add field to IRFIELDS cmd:\n" + vector.get(vector.size() - 1));
                    fieldMapping.setFieldStandard(fieldStandard);
                    fieldMapping.setFieldStandardName(fieldStandard.getStandardName());
                    fieldMapping.addFinalField(field);
                }
                if (InsightUtilities.isNonEmpty(vector)) {
                    databaseConnector.executeBatch(vector, true);
                    databaseConnector.close();
                }
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, fieldStandard.getStandardID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, fieldStandard.getStandardName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standard_Type", 2, stringBuffer2, fieldStandard.getType());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Version", 1, stringBuffer2, fieldStandard.getVersion());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Version_Info", 1, stringBuffer2, fieldStandard.getVersionInfo());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Standards_Order", 2, stringBuffer2, fieldStandard.getStandardsOrder());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardDescriptionURL", 1, stringBuffer2, fieldStandard.getDescriptionUrl());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Enabled", 2, stringBuffer2, fieldStandard.isEnabled() ? 1 : 0);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsTemplate", 2, stringBuffer2, fieldStandard.isTemplate() ? 1 : 0);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, new SimpleDate().get());
                if (fieldStandard.getStandardCreator() != null) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardCreatorID", 2, stringBuffer2, this.getInsightUserID(fieldStandard.getStandardCreator(), true, databaseConnector));
                }
                databaseConnector.setQuery("INSERT INTO SLSTANDARDSLOOKUP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Add field standard to SLSTANDARDSLOOKUP:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, fieldStandard.getStandardID());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, fieldStandard.getStandardName());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreateThumbCache", 2, stringBuffer2, fieldStandard.createThumbCache() ? 1 : 0);
                FieldMapping[] fieldMappingArray = fieldStandard.getStartThumbFields();
                for (int i = 0; i < 4 && fieldMappingArray != null && i < fieldMappingArray.length; ++i) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Thumbnail" + (i + 1) + "FieldID", 2, stringBuffer2, fieldMappingArray[i].getFieldID());
                }
                FieldMapping[] fieldMappingArray2 = fieldStandard.getStartSortFields();
                for (int i = 0; i < 4 && fieldMappingArray2 != null && i < fieldMappingArray2.length; ++i) {
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Sort" + (i + 1) + "FieldID", 2, stringBuffer2, fieldMappingArray2[i].getFieldID());
                }
                databaseConnector.setQuery("INSERT INTO SLSTANDARDSSTARTUP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Add field standard to SLSTANDARDSSTARTUP:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
                bl = true;
            }
            catch (Exception exception) {
                this.debugOut("Exception in saveFieldStandard():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in saveFieldStandard():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return bl;
    }

    public boolean removeFieldStandard(FieldStandard fieldStandard) {
        return this.removeFieldStandard(fieldStandard, null);
    }

    public boolean removeFieldStandard(FieldStandard fieldStandard, DatabaseConnector databaseConnector) {
        if (fieldStandard != null) {
            return this.removeFieldStandard(fieldStandard.getStandardID(), fieldStandard.getStandardName(), databaseConnector);
        }
        return false;
    }

    public boolean removeFieldStandard(int n, String string, DatabaseConnector databaseConnector) {
        this.debugOut("in removeFieldStandard('" + string + "').");
        boolean bl = false;
        if (InsightUtilities.isNonEmpty(string)) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                String string2 = this.prepStringForQuery(string);
                databaseConnector.setQuery("DELETE FROM SLSTANDARDSLOOKUP WHERE StandardName = " + string2);
                this.debugOut("Clear from SLSTANDARDSLOOKUP command:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM SLSTANDARDSSTARTUP WHERE StandardName = " + string2);
                this.debugOut("Clear from SLSTANDARDSSTARTUP command:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM SLSTANDARDFIELDS WHERE StandardName = " + string2);
                this.debugOut("Clear from SLSTANDARDFIELDS command:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM SLFIELDSTANDARDRELATION WHERE StandardName = " + string2 + " OR MappingStandardName = " + string2);
                this.debugOut("Clear from SLSTANDARDSSTARTUP command:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuerySafe();
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM IRFIELDS WHERE CustomStandardID = " + n);
                this.debugOut("Clear from IRFIELDS command:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                bl = true;
            }
            catch (Exception exception) {
                this.debugOut("Exception in removeFieldStandard():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in removeFieldStandard():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
        return bl;
    }

    public boolean saveObjectDataRecord(Integer n, ObjectDataRecord objectDataRecord, FieldStandardsManager fieldStandardsManager) {
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (objectDataRecord != null) {
                FieldValue fieldValue;
                if (PersonalCollection.isTempID((long)objectDataRecord.getObjectID())) {
                    objectDataRecord.setObjectID(this.getNextObjectID(databaseConnector));
                }
                this.removeObjectValues(objectDataRecord.getObjectID(), databaseConnector);
                Vector vector = objectDataRecord.getFieldValues();
                for (int i = 0; vector != null && i < vector.size(); ++i) {
                    fieldValue = (FieldValue)vector.get(i);
                    if (fieldValue.getFieldMapping() == null || fieldValue.getValues() == null || fieldValue.getValues().size() <= 0) continue;
                    fieldValue.setFieldMapping(fieldStandardsManager.getFieldMapping(fieldValue.getFieldMapping()));
                    this.saveFieldValue(n, fieldValue, objectDataRecord.getObjectID(), 0, databaseConnector);
                }
                Vector vector2 = objectDataRecord.getGroupedFieldValues();
                for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                    FieldValueGroup fieldValueGroup = (FieldValueGroup)vector2.get(i);
                    vector = fieldValueGroup.getFieldValues();
                    for (int j = 0; vector != null && j < vector.size(); ++j) {
                        fieldValue = (FieldValue)vector.get(j);
                        if (fieldValue.getFieldMapping() == null || fieldValue.getValues() == null || fieldValue.getValues().size() <= 0) continue;
                        fieldValue.setFieldMapping(fieldStandardsManager.getFieldMapping(fieldValue.getFieldMapping()));
                        this.saveFieldValue(n, fieldValue, objectDataRecord.getObjectID(), fieldValueGroup.getGrouping(), databaseConnector);
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveObjectDataRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in saveObjectDataRecord():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return bl;
    }

    public boolean removeObjectValues(long l, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            databaseConnector.setQuery("DELETE FROM DTVALUETOOBJECT WHERE ObjectID = " + l);
            this.debugOut("Remove object values cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            databaseConnector.setQuery("DELETE FROM DTTERMOBJECTMAP WHERE ObjectID = " + l);
            this.debugOut("Remove object terms cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.setQuery("DELETE FROM DTFLATOBJECTDATA WHERE ObjectID = " + l);
            this.debugOut("Remove object flat-data cmd:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            bl = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeObjectValues():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in removeObjectValues():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return bl;
    }

    public boolean saveFieldValue(Integer n, FieldValue fieldValue, long l, int n2, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            if (fieldValue != null && fieldValue.getFieldMapping() != null && fieldValue.getFieldMapping().getFinalFields() != null && fieldValue.getFieldMapping().getFinalFields().size() > 0 && fieldValue.getValues() != null && fieldValue.getValues().size() > 0) {
                Vector vector = fieldValue.getFieldMapping().getFinalFields();
                List list = fieldValue.getValues();
                int n3 = SqlQueryGenerator.getDataColumnLength("DTVALUES", "ValueText", databaseConnector);
                int n4 = SqlQueryGenerator.getDataColumnLength("DTTERMS", "Keyword", databaseConnector);
                for (int i = 0; i < list.size(); ++i) {
                    int n5;
                    String string = (String)list.get(i);
                    if (!InsightUtilities.isNonEmpty(string)) continue;
                    Vector vector2 = new Vector(0);
                    String string2 = null;
                    if (this.DIACRITIC_MAPPINGS != null && (InsightUtilities.isEmpty(string2 = this.DIACRITIC_MAPPINGS.normalize(string)) || string2.equals(string))) {
                        string2 = null;
                    }
                    Vector vector3 = new Vector(TrinityIndexer.parseTerms(string, this.getStopList()));
                    if (InsightUtilities.isNonEmpty(string2)) {
                        vector3.addAll(TrinityIndexer.parseTerms(string2, this.getStopList()));
                    }
                    for (n5 = 0; vector3 != null && n5 < vector3.size(); ++n5) {
                        if (vector2.contains(vector3.get(n5))) continue;
                        vector2.add(vector3.get(n5));
                    }
                    for (n5 = 0; n5 < vector.size(); ++n5) {
                        Field field = (Field)vector.get(n5);
                        TrinityIndexer.addValueMapping(n, InsightUtilities.truncate(string, n3), l, field.getFieldID(), field.getFieldType(), n2 + "", true, true, false, null, databaseConnector);
                        if (InsightUtilities.isNonEmpty(string2)) {
                            TrinityIndexer.addValueMapping(n, InsightUtilities.truncate(string2, n3), l, field.getFieldID(), field.getFieldType(), n2 + "", false, false, false, null, databaseConnector);
                        }
                        if (!field.isKeywordSearchable()) continue;
                        for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                            TrinityIndexer.addTermMapping(n, InsightUtilities.truncate((String)vector2.get(j), n4), l, field.getFieldID(), n2 + "", false, false, null, databaseConnector);
                        }
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveFieldValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in saveFieldValue():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return bl;
    }

    public String[] getStopList() {
        if (this.stopList == null) {
            this.stopList = TrinityIndexer.getStopList(this.getDatabaseConnector());
        }
        return this.stopList;
    }

    public String getHierarchyName(int n) {
        String string = "";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT * FROM ISHIERARCHIES WHERE HierarchyID = " + n);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                string = databaseConnector.getFieldByName("HierarchyName");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getHierarchyName(): " + exception);
            string = "";
        }
        databaseConnector.close();
        return string;
    }

    public int getHierarchyID(String string) {
        return this.getHierarchyID(string, null);
    }

    public int getHierarchyID(String string, DatabaseConnector databaseConnector) {
        int n = 0;
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            databaseConnector.setQuery("SELECT * FROM ISHIERARCHIES WHERE HierarchyName = " + this.prepStringForQuery(string));
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("HierarchyID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getHierarchyID():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHierarchyNames() {
        DatabaseConnector databaseConnector = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT * FROM ISHIERARCHIES ORDER BY HIERARCHYNAME");
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                arrayList.add(databaseConnector.getField("HIERARCHYNAME"));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getHierarchyNames():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    public Vector getTopLevelNodes(String string) {
        Vector<HierarchyNodeData> vector = new Vector<HierarchyNodeData>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT ISHIERARCHIES.HierarchyName, DTHIERARCHYNODES.* FROM DTHIERARCHYNODES, ISHIERARCHIES WHERE DTHIERARCHYNODES.HierarchyID = ISHIERARCHIES.HierarchyID AND ISHIERARCHIES.HierarchyName = " + this.prepStringForQuery(string) + " AND " + "DTHIERARCHYNODES" + ".Parent = 0" + " AND " + "DTHIERARCHYNODES" + ".StartOfChildren <> " + "DTHIERARCHYNODES" + ".EndOfChildren" + " ORDER BY " + "DTHIERARCHYNODES" + ".IsLocalVocabularyNode, " + "DTHIERARCHYNODES" + ".ValueText");
            this.debugOut("Get top-level nodes query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            Object var4_4 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            HierarchyNodeData hierarchyNodeData = null;
            while (databaseConnector.more()) {
                hierarchyNodeData = this.getHierarchyNodeData(databaseConnector);
                vector.add(hierarchyNodeData);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTopLevelNodes(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public Vector doTreeChildSearch(HierarchyNodeData hierarchyNodeData) {
        Vector<HierarchyNodeData> vector = new Vector<HierarchyNodeData>();
        if (this.setHierarchyNodeData(hierarchyNodeData)) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                databaseConnector.setQuery("SELECT * FROM DTHIERARCHYNODES WHERE (HierarchyID = " + hierarchyNodeData.hierarchyID + " AND Parent = " + hierarchyNodeData.nodeID + ")");
                this.debugOut("Child search query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                Object var4_4 = null;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                HierarchyNodeData hierarchyNodeData2 = null;
                while (databaseConnector.more()) {
                    hierarchyNodeData2 = this.getHierarchyNodeData(databaseConnector);
                    hierarchyNodeData2.hierarchyName = hierarchyNodeData.getHierarchyName();
                    vector.addElement(hierarchyNodeData2);
                    this.debugOut("Added child node " + hierarchyNodeData2);
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
            catch (Exception exception) {
                this.debugOut("Exception in doTreeChildSearch():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return vector;
    }

    public Vector doTreePathSearch(HierarchyNodeData hierarchyNodeData) {
        Object object;
        if (hierarchyNodeData == null) {
            return null;
        }
        Vector<HierarchyNodeData> vector = new Vector<HierarchyNodeData>();
        Hashtable<String, HierarchyNodeData> hashtable = new Hashtable<String, HierarchyNodeData>();
        String string = "DTHIERARCHYNODES";
        String string2 = "ISHIERARCHIES";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            object = hierarchyNodeData.getHierarchyName();
            int n = hierarchyNodeData.nodeID;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(string, "*");
            sqlQueryGenerator.addTable(string2, new String[]{"HierarchyID", "HierarchyName"});
            sqlQueryGenerator.appendToWhere(string2 + ".HierarchyID = " + string + ".HierarchyID");
            sqlQueryGenerator.appendToWhere(string2 + ".HierarchyName = " + this.prepStringForQuery((String)object));
            sqlQueryGenerator.appendToWhere(string + ".StartOfChildren <= " + n + " AND " + string + ".EndOfChildren >= " + n);
            sqlQueryGenerator.addOrderBy(string, "Parent");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Tree path query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                HierarchyNodeData hierarchyNodeData2 = this.getHierarchyNodeData(databaseConnector);
                vector.add(hierarchyNodeData2);
                hashtable.put(hierarchyNodeData2.parentNodeID + "", hierarchyNodeData2);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doTreePathSearch():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        object = this.sortPathNodes(hashtable);
        if (object == null) {
            return vector;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLocalNodePath(String string, String string2, Field field, String string3) {
        if (field == null || string3 == null) {
            return false;
        }
        HierarchyNodeData hierarchyNodeData = null;
        Object object = HIERARCHY_ID_LOCK_OBJECT;
        synchronized (object) {
            hierarchyNodeData = this.getLocalVocabularyRootNode(string);
            if (hierarchyNodeData == null) {
                hierarchyNodeData = this.addLocalVocabularyRootNode(string, string2);
            }
        }
        if (hierarchyNodeData == null) {
            return false;
        }
        int n = hierarchyNodeData.hierarchyID;
        HierarchyNodeData hierarchyNodeData2 = null;
        Object object2 = HIERARCHY_ID_LOCK_OBJECT;
        synchronized (object2) {
            hierarchyNodeData2 = this.getLocalVocabularyNodeChild(n, hierarchyNodeData, field.fieldDisplayName);
            if (hierarchyNodeData2 == null) {
                hierarchyNodeData2 = this.addLocalVocabularyNodeChild(n, hierarchyNodeData, field.fieldDisplayName);
            }
        }
        if (hierarchyNodeData2 == null) {
            return false;
        }
        object2 = null;
        Object object3 = HIERARCHY_ID_LOCK_OBJECT;
        synchronized (object3) {
            object2 = this.getLocalVocabularyNodeChild(n, hierarchyNodeData2, string3);
            if (object2 == null) {
                int n2 = this.getLocalVocabularyNodeHierarchyIndex(n, hierarchyNodeData2);
                if (n2 > hierarchyNodeData2.endID) {
                    hierarchyNodeData2 = this.addLocalVocabularyNodeChild(n, hierarchyNodeData, field.fieldDisplayName);
                }
                object2 = this.addLocalVocabularyNodeChild(n, hierarchyNodeData2, string3);
            }
        }
        return object2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HierarchyNodeData getLocalVocabularyRootNode(String string) {
        HierarchyNodeData hierarchyNodeData = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT DTHIERARCHYNODES.* FROM DTHIERARCHYNODES, ISHIERARCHIES WHERE DTHIERARCHYNODES.HierarchyID = ISHIERARCHIES.HierarchyID AND ISHIERARCHIES.HierarchyName = " + this.prepStringForQuery(string) + " AND " + "DTHIERARCHYNODES" + ".Parent = 0" + " AND " + "DTHIERARCHYNODES" + ".StartOfChildren <> " + "DTHIERARCHYNODES" + ".EndOfChildren" + " AND " + "DTHIERARCHYNODES" + ".IsLocalVocabularyNode = 1");
            this.debugOut("Get local vocabulary root node query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                hierarchyNodeData = this.getHierarchyNodeData(databaseConnector);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getLocalVocabularyRootNode(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return hierarchyNodeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HierarchyNodeData addLocalVocabularyRootNode(String string, String string2) {
        HierarchyNodeData hierarchyNodeData = null;
        int n = this.getHierarchyID(string);
        int n2 = this.getMaxHierarchyIndex(n);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            int n3 = n2 + 1;
            int n4 = 0;
            int n5 = n2 + 1;
            int n6 = n2 + 10100 + 1;
            int n7 = 1;
            databaseConnector.setQuery("INSERT INTO DTHIERARCHYNODES (HierarchyID, HierarchyIndex, ValueID, ValueText, Parent, StartOfChildren, EndOfChildren, IsLocalVocabularyNode) VALUES (" + n + ", " + (n2 + 1) + ", " + n3 + ", " + this.prepStringForQuery(string2) + ", " + n4 + ", " + n5 + ", " + n6 + ", " + n7 + ")");
            this.debugOut("Insert local vocabulary root node query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            databaseConnector.setQuery("SELECT * FROM DTHIERARCHYNODES WHERE (HierarchyID = " + n + " AND HierarchyIndex = " + (n2 + 1) + ")");
            this.debugOut("Select local vocabulary root node query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                hierarchyNodeData = this.getHierarchyNodeData(databaseConnector);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addLocalVocabularyRootNode(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return hierarchyNodeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HierarchyNodeData getLocalVocabularyNodeChild(int n, HierarchyNodeData hierarchyNodeData, String string) {
        HierarchyNodeData hierarchyNodeData2 = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT DTHIERARCHYNODES.* FROM DTHIERARCHYNODES WHERE (HierarchyID = " + n + " AND Parent = " + hierarchyNodeData.getNodeID() + " AND ValueText = " + this.prepStringForQuery(string) + " AND IsLocalVocabularyNode = 1)" + " ORDER BY HierarchyIndex DESC");
            this.debugOut("Get local vocabulary node child query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                hierarchyNodeData2 = this.getHierarchyNodeData(databaseConnector);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getLocalVocabularyNodeChild(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return hierarchyNodeData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HierarchyNodeData addLocalVocabularyNodeChild(int n, HierarchyNodeData hierarchyNodeData, String string) {
        int n2;
        HierarchyNodeData hierarchyNodeData2 = null;
        int n3 = n2 = this.getLocalVocabularyNodeHierarchyIndex(n, hierarchyNodeData);
        int n4 = n2;
        if (hierarchyNodeData.getParentNodeID() == 0) {
            n4 = n2 + 100;
        }
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            int n5 = n2;
            int n6 = hierarchyNodeData.getNodeID();
            int n7 = 1;
            databaseConnector.setQuery("INSERT INTO DTHIERARCHYNODES (HierarchyID, HierarchyIndex, ValueID, ValueText, Parent, StartOfChildren, EndOfChildren, IsLocalVocabularyNode) VALUES (" + n + ", " + n2 + ", " + n5 + ", " + this.prepStringForQuery(string) + ", " + n6 + ", " + n3 + ", " + n4 + ", " + n7 + ")");
            this.debugOut("Insert local vocabulary node child query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            databaseConnector.setQuery("SELECT * FROM DTHIERARCHYNODES WHERE (HierarchyID = " + n + " AND HierarchyIndex = " + n2 + ")");
            this.debugOut("Select local vocabulary node child query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                hierarchyNodeData2 = this.getHierarchyNodeData(databaseConnector);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addLocalVocabularyNodeChild(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return hierarchyNodeData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxHierarchyIndex(int n) {
        int n2 = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT MAX(HierarchyIndex) AS MaxIndex FROM DTHIERARCHYNODES WHERE (HierarchyID = " + n + ")");
            this.debugOut("Get max hierarchy index query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerFieldByName("MaxIndex");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxHierarchyIndex(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxHierarchyLocalChildNodeIndex(int n, int n2) {
        int n3 = -1;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT MAX(HierarchyIndex) AS MaxIndex FROM DTHIERARCHYNODES WHERE (HierarchyID = " + n + " AND Parent = " + n2 + " AND IsLocalVocabularyNode = 1)");
            this.debugOut("Get max hierarchy field node index query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n3 = databaseConnector.getIntegerFieldByName("MaxIndex");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxHierarchyIndex(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return n3;
    }

    protected int getLocalVocabularyNodeHierarchyIndex(int n, HierarchyNodeData hierarchyNodeData) {
        int n2 = -1;
        if (hierarchyNodeData.getParentNodeID() == 0) {
            int n3 = this.getMaxHierarchyLocalChildNodeIndex(n, hierarchyNodeData.getNodeID());
            n2 = n3 <= 0 ? hierarchyNodeData.getNodeID() + 1 : n3 + 100 + 1;
            if (n2 > hierarchyNodeData.endID) {
                int n4 = n2 + 100;
                this.updateLocalHierarchyNodeEndChildIndex(hierarchyNodeData, n4);
            }
        } else {
            int n5 = this.getMaxHierarchyLocalChildNodeIndex(n, hierarchyNodeData.getNodeID());
            n2 = n5 <= 0 ? hierarchyNodeData.getNodeID() + 1 : n5 + 1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTermsInHierarchy(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        String string2 = "DTHIERARCHYNODES";
        String string3 = "ISHIERARCHIES";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(string2, "ValueText");
            sqlQueryGenerator.addTable(string3, new String[]{"HierarchyID", "HierarchyName"});
            sqlQueryGenerator.appendToWhere(string3 + ".HierarchyID = " + string2 + ".HierarchyID");
            sqlQueryGenerator.appendToWhere(string3 + ".HierarchyName = " + this.prepStringForQuery(string));
            sqlQueryGenerator.addOrderBy(string2, "ValueText");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Hierarchy terms query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                String string4 = databaseConnector.getFieldByName("ValueText");
                vector.add(string4);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTermsInHierarchy():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTermInHierarchy(String string, String string2) {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            return false;
        }
        boolean bl = false;
        String string3 = "DTHIERARCHYNODES";
        String string4 = "ISHIERARCHIES";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(string3, "ValueText");
            sqlQueryGenerator.addTable(string4, new String[]{"HierarchyID", "HierarchyName"});
            sqlQueryGenerator.appendToWhere(string4 + ".HierarchyID = " + string3 + ".HierarchyID");
            sqlQueryGenerator.appendToWhere(string4 + ".HierarchyName = " + this.prepStringForQuery(string));
            sqlQueryGenerator.appendToWhere(string3 + ".ValueText = " + this.prepStringForQuery(string2));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Term in hierarchy query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                bl = true;
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isTermInHierarchy():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateLocalHierarchyNodeEndChildIndex(HierarchyNodeData hierarchyNodeData, int n) {
        if (hierarchyNodeData == null) {
            return false;
        }
        boolean bl = true;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = "UPDATE DTHIERARCHYNODES SET EndOfChildren = " + n + " WHERE (HierarchyID = " + hierarchyNodeData.hierarchyID + " AND HierarchyIndex = " + hierarchyNodeData.getNodeID() + " AND IsLocalVocabularyNode = 1)";
            databaseConnector.setQuery(string);
            this.debugOut("Update hierarchy node end child index query ID:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuerySafe();
        }
        catch (Exception exception) {
            bl = false;
            this.debugOut("Exception in updateHierarchyNodeEndChildIndex():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return bl;
    }

    public HierarchyAncillaryData doAncillarySearch(HierarchyNodeData hierarchyNodeData) {
        if (hierarchyNodeData == null) {
            return null;
        }
        Hashtable hashtable = this.getHierarchyRelationTypes();
        HierarchyAncillaryData hierarchyAncillaryData = new HierarchyAncillaryData();
        String string = "DTHIERARCHYNODERELATIONS";
        String string2 = "DTHIERARCHYNODES";
        String string3 = "ISHIERARCHIES";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string4 = hierarchyNodeData.getHierarchyName();
            int n = hierarchyNodeData.nodeID;
            String string5 = hierarchyNodeData.getNodeName();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(string, new String[]{"RelationTypeID", "RelHierarchyIndex"});
            sqlQueryGenerator.addTable(string2, new String[]{"*"});
            sqlQueryGenerator.addTable(string3, new String[]{"HierarchyName"});
            sqlQueryGenerator.appendToWhere("(" + string3 + ".HierarchyID = " + string2 + ".HierarchyID)");
            sqlQueryGenerator.appendToWhere("(" + string3 + ".HierarchyID = " + string + ".HierarchyID)");
            sqlQueryGenerator.appendToWhere("(" + string + ".HierarchyIndex = " + string2 + ".HierarchyIndex" + " OR " + string + ".RelHierarchyIndex = " + string2 + ".HierarchyIndex)");
            sqlQueryGenerator.appendToWhere(string3 + ".HierarchyName = " + this.prepStringForQuery(string4));
            sqlQueryGenerator.appendToWhere("(" + string + ".RelationTypeID = " + 1 + " OR " + string + ".RelationTypeID = " + 2 + " OR " + string + ".RelationTypeID = " + 3 + ")");
            sqlQueryGenerator.appendToWhere("(" + string + ".HierarchyIndex = " + n + ")");
            sqlQueryGenerator.appendToWhere("NOT (" + string2 + ".ValueText = " + this.prepStringForQuery(string5) + ")");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Ancillary search query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                HierarchyNodeData hierarchyNodeData2 = this.getHierarchyNodeData(databaseConnector);
                hierarchyNodeData2.nodeID = databaseConnector.getIntegerField("RelHierarchyIndex");
                hierarchyNodeData2.hierarchyName = string4;
                ThesaurusRelationType thesaurusRelationType = (ThesaurusRelationType)hashtable.get(databaseConnector.getIntegerField("RelationTypeID") + "");
                if (thesaurusRelationType != null) {
                    hierarchyAncillaryData.addAncillaryNode(hierarchyNodeData2, thesaurusRelationType);
                }
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doAncillarySearch():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return hierarchyAncillaryData;
    }

    public Vector doTermSearch(String string, String string2, int n, int n2, MutableInteger mutableInteger) {
        Vector<HierarchyNodePath> vector = new Vector<HierarchyNodePath>(0);
        DatabaseConnector databaseConnector = this.getDatabaseConnector(false);
        try {
            long l = System.currentTimeMillis();
            String string3 = "SELECT DISTINCT ISHIERARCHIES.HierarchyName, t1.* FROM ISHIERARCHIES, DTHIERARCHYNODES t1, DTHIERARCHYNODES t2, DTHIERARCHYNODERELATIONS WHERE ISHIERARCHIES.HierarchyID = DTHIERARCHYNODERELATIONS.HierarchyID AND DTHIERARCHYNODERELATIONS.HierarchyID = t1.HierarchyID AND t1.HierarchyID = t2.HierarchyID AND t1.HierarchyIndex = DTHIERARCHYNODERELATIONS.HierarchyIndex AND t2.HierarchyIndex = DTHIERARCHYNODERELATIONS.RelHierarchyIndex AND ISHIERARCHIES.HierarchyName = " + this.prepStringForQuery(string) + " AND " + this.createEquivalenceRelationshipClause("t2.ValueText", 1, 2, this.escapeSpecialCharacters(string2), false) + " AND " + "DTHIERARCHYNODERELATIONS" + ".RelationTypeID = " + 2 + " ORDER BY t1.ValueText";
            databaseConnector.setQuery(string3);
            this.debugOut("Preferred terms query:\n" + string3);
            databaseConnector.runQuerySafe();
            this.debugOut("Preferred terms query time: " + (System.currentTimeMillis() - l));
            if (!databaseConnector.more()) {
                databaseConnector.close();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("ISHIERARCHIES", null, "HierarchyName");
                sqlQueryGenerator.addTable("DTHIERARCHYNODES", null, "*");
                sqlQueryGenerator.addJoin("ISHIERARCHIES", "DTHIERARCHYNODES", "HierarchyID", 0);
                sqlQueryGenerator.appendToWhere("ISHIERARCHIES.HierarchyName = " + this.prepStringForQuery(string));
                sqlQueryGenerator.appendToWhere(this.createEquivalenceRelationshipClause("DTHIERARCHYNODES.ValueText", 1, 2, this.escapeSpecialCharacters(string2), false));
                sqlQueryGenerator.addOrderBy("DTHIERARCHYNODES", "ValueText");
                l = System.currentTimeMillis();
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get matching terms query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                this.debugOut("Get matching terms query time: " + (System.currentTimeMillis() - l));
            }
            l = System.currentTimeMillis();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (databaseConnector.more() && n4 < n) {
                if (string2 != null && string2.equalsIgnoreCase(databaseConnector.getStringField("ValueText"))) {
                    ++n4;
                }
                ++n3;
                databaseConnector.next();
            }
            while (databaseConnector.more() && n4 >= n && n5 < n2) {
                if (string2 != null && string2.equalsIgnoreCase(databaseConnector.getStringField("ValueText"))) {
                    vector.add(new HierarchyNodePath(this.getHierarchyNodeData(databaseConnector)));
                    ++n5;
                    ++n4;
                }
                ++n3;
                databaseConnector.next();
            }
            while (databaseConnector.more()) {
                ++n3;
                databaseConnector.next();
            }
            if (n5 < n2) {
                databaseConnector.first();
                while (databaseConnector.more() && n4 < n) {
                    if (string2 != null && !string2.equalsIgnoreCase(databaseConnector.getStringField("ValueText"))) {
                        ++n4;
                    }
                    databaseConnector.next();
                }
                while (databaseConnector.more() && n4 >= n && n5 < n2) {
                    if (string2 != null && !string2.equalsIgnoreCase(databaseConnector.getStringField("ValueText"))) {
                        vector.add(new HierarchyNodePath(this.getHierarchyNodeData(databaseConnector)));
                        ++n5;
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            this.debugOut("Gather page time: " + (System.currentTimeMillis() - l));
            if (mutableInteger != null) {
                mutableInteger.setValue(n3);
            }
            l = System.currentTimeMillis();
            this.setHierarchyNodePaths(vector);
            this.debugOut("Set hierarchy node paths: " + (System.currentTimeMillis() - l));
        }
        catch (Exception exception) {
            this.debugOut("Exception in doTermSearch():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in doTermSearch():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
        return vector;
    }

    protected void setHierarchyNodePaths(List list) {
        int n = 30;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            long l;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            for (n2 = 0; list != null && n2 < list.size(); ++n2) {
                HierarchyNodePath hierarchyNodePath = (HierarchyNodePath)list.get(n2);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" OR ");
                } else if (!bl) {
                    bl = true;
                    stringBuffer.append(" (");
                }
                stringBuffer.append("(DTHIERARCHYNODES.StartOfChildren <= " + hierarchyNodePath.getNodeData().getNodeID() + " AND " + "DTHIERARCHYNODES" + ".EndOfChildren >= " + hierarchyNodePath.getNodeData().getNodeID() + ")");
                if (++n4 != n && n2 != list.size() - 1) continue;
                this.debugOut("Batch size: " + n4);
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("DTHIERARCHYNODES", "*");
                sqlQueryGenerator.addTable("ISHIERARCHIES", new String[]{"HierarchyID", "HierarchyName"});
                sqlQueryGenerator.addJoin("ISHIERARCHIES", "DTHIERARCHYNODES", "HierarchyID", 0);
                sqlQueryGenerator.appendToWhere("ISHIERARCHIES.HierarchyName = " + this.prepStringForQuery(hierarchyNodePath.getNodeData().getHierarchyName()));
                stringBuffer.append(") ");
                sqlQueryGenerator.appendToWhere(stringBuffer.toString());
                l = System.currentTimeMillis();
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Batch node path query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                this.debugOut("Batch node path query time: " + (System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                while (databaseConnector.more()) {
                    HierarchyNodeData hierarchyNodeData = this.getHierarchyNodeData(databaseConnector);
                    for (int i = n3; i <= n2 && i < list.size(); ++i) {
                        hierarchyNodePath = (HierarchyNodePath)list.get(i);
                        if (hierarchyNodeData.startID > hierarchyNodePath.getNodeData().getNodeID() || hierarchyNodeData.endID < hierarchyNodePath.getNodeData().getNodeID()) continue;
                        hierarchyNodePath.addToPath(hierarchyNodeData);
                    }
                    databaseConnector.next();
                }
                databaseConnector.close();
                this.debugOut("Add paths time: " + (System.currentTimeMillis() - l));
                n3 = n2 + 1;
                n4 = 0;
                stringBuffer = new StringBuffer();
            }
            l = System.currentTimeMillis();
            for (n2 = 0; n2 < list.size(); ++n2) {
                ((HierarchyNodePath)list.get(n2)).sortPath();
            }
            this.debugOut("Sort paths time: " + (System.currentTimeMillis() - l));
        }
        catch (Exception exception) {
            this.debugOut("Exception in setNodePaths():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in setNodePaths():\n" + InsightUtilities.getStackTrace(error));
        }
        databaseConnector.close();
    }

    protected Hashtable getHierarchyRelationTypes() {
        if (hierarchyRelationTypes == null || hierarchyRelationTypes.size() == 0) {
            hierarchyRelationTypes = new Hashtable();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRTHESAURUSRELATIONTYPES", "*");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Hierarchy relation types query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    ThesaurusRelationType thesaurusRelationType = new ThesaurusRelationType(databaseConnector.getIntegerField("RelationTypeID"), databaseConnector.getFieldByName("RelationTypeName"), databaseConnector.getFieldByName("RelationTypeAbbr"), databaseConnector.getFieldByName("RelationTypeDesc"));
                    hierarchyRelationTypes.put(thesaurusRelationType.getRelationTypeID() + "", thesaurusRelationType);
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
            catch (Exception exception) {
                this.debugOut("Exception in getHierarchyRelationTypes():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return hierarchyRelationTypes;
    }

    protected Vector sortPathNodes(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            Object object;
            Enumeration enumeration = hashtable.keys();
            Object object2 = "999999";
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object2).compareToIgnoreCase((String)object) <= 0) continue;
                object2 = object;
            }
            object = (HierarchyNodeData)hashtable.get(object2);
            while (object != null) {
                vector.add(object);
                object = (HierarchyNodeData)hashtable.get(((HierarchyNodeData)object).getNodeID() + "");
            }
            if (vector.size() == 0) {
                vector = null;
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean setHierarchyNodeData(HierarchyNodeData hierarchyNodeData) {
        boolean bl = false;
        if (hierarchyNodeData != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("DTHIERARCHYNODES", null, "*");
                sqlQueryGenerator.addTable("ISHIERARCHIES", null, "HierarchyName");
                sqlQueryGenerator.addJoin("DTHIERARCHYNODES", "ISHIERARCHIES", "HierarchyID", 0);
                sqlQueryGenerator.appendToWhere("ISHIERARCHIES.HierarchyName = " + this.prepStringForQuery(hierarchyNodeData.hierarchyName) + " AND " + "DTHIERARCHYNODES" + ".HierarchyIndex = " + hierarchyNodeData.nodeID);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Set node data query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    hierarchyNodeData.hierarchyID = databaseConnector.getIntegerFieldByName("HierarchyID");
                    hierarchyNodeData.nodeID = databaseConnector.getIntegerFieldByName("HierarchyIndex");
                    hierarchyNodeData.parentNodeID = databaseConnector.getIntegerFieldByName("Parent");
                    hierarchyNodeData.startID = databaseConnector.getIntegerFieldByName("StartOfChildren");
                    hierarchyNodeData.endID = databaseConnector.getIntegerFieldByName("EndOfChildren");
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getHierarchyName(): " + exception);
            }
            databaseConnector.close();
        }
        return bl;
    }

    public HierarchyNodeData getHierarchyNodeData(DatabaseConnector databaseConnector) {
        HierarchyNodeData hierarchyNodeData = null;
        try {
            if (databaseConnector != null && databaseConnector.more()) {
                hierarchyNodeData = new HierarchyNodeData();
                hierarchyNodeData.hierarchyID = databaseConnector.getIntegerField("HierarchyID");
                hierarchyNodeData.nodeID = databaseConnector.getIntegerField("HierarchyIndex");
                hierarchyNodeData.uniqueIdentifier = databaseConnector.getStringField("ValueID");
                hierarchyNodeData.nodeName = databaseConnector.getFieldByName("ValueText");
                hierarchyNodeData.parentNodeID = databaseConnector.getIntegerField("Parent");
                hierarchyNodeData.startID = databaseConnector.getIntegerField("StartOfChildren");
                hierarchyNodeData.endID = databaseConnector.getIntegerField("EndOfChildren");
                hierarchyNodeData.isLocalNode = databaseConnector.getIntegerField("IsLocalVocabularyNode") == 1;
                hierarchyNodeData.totalChildCount = hierarchyNodeData.endID - hierarchyNodeData.startID;
                try {
                    hierarchyNodeData.hierarchyName = databaseConnector.getStringField("HierarchyName");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getHierarchyNodeData():\n" + InsightUtilities.getStackTrace(exception));
        }
        return hierarchyNodeData;
    }

    public boolean getFuzzyDateSupport() {
        boolean bl = false;
        String string = "ValueDate";
        String string2 = string.replace(' ', '_') + "_Start";
        String string3 = string.replace(' ', '_') + "_End";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        String[] stringArray = new String[]{string2, string3};
        bl = SqlQueryGenerator.doesColumnExist(databaseConnector, stringArray, "DTVALUES");
        databaseConnector.close();
        this.debugOut("getFuzzyDateSupport returns " + bl);
        return bl;
    }

    public MpdSearchResults searchMultipageDocument(String string, String string2) {
        this.debugOut("In searchMultipageDocument(" + string + ", " + string2 + ").");
        MpdSearchResults mpdSearchResults = new MpdSearchResults();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
        }
        sqlQueryGenerator.addTable("ISDOCUMENTPAGES", new String[]{"ObjectID", "ImageID"});
        sqlQueryGenerator.addJoin("DTTERMOBJECTMAP", "ISDOCUMENTPAGES", "ObjectID", 0);
        sqlQueryGenerator.addJoin("DTTERMOBJECTMAP", "DTTERMS", "TermID", 0);
        sqlQueryGenerator.appendToWhere("ISDOCUMENTPAGES.DocumentID = " + string);
        sqlQueryGenerator.appendToWhere(this.createEquivalenceRelationshipClause("Keyword", 1, 2, this.escapeSpecialCharacters(string2), false));
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Mpd search query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        try {
            while (databaseConnector.more()) {
                mpdSearchResults.addResult(databaseConnector.getFieldByName("ObjectID"), databaseConnector.getFieldByName("ImageID"));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in searchMultipageDocument():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return mpdSearchResults;
    }

    public int getInsightUserID(InsightUser insightUser) {
        return this.getInsightUserID(insightUser, false, null);
    }

    public int getInsightUserID(InsightUser insightUser, boolean bl, DatabaseConnector databaseConnector) {
        this.debugOut("in getInsightUserID().");
        int n = -1;
        if (insightUser != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRUSERS", null, new String[]{"UserID", "LastVisitTimeStamp"});
                sqlQueryGenerator.appendToWhere("LoginName = " + this.prepStringForQuery(insightUser.getLoginName()));
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuerySafe();
                if (databaseConnector.more()) {
                    n = databaseConnector.getIntegerField("UserID");
                    this.debugOut("Last visit time stamp: " + new SimpleDate(databaseConnector.getFieldByName("LastVisitTimeStamp")).getFull());
                    databaseConnector.close();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl) {
                        stringBuffer.append(", FirstName = " + this.prepStringForQuery(insightUser.getFirstName()));
                        stringBuffer.append(", LastName = " + this.prepStringForQuery(insightUser.getLastName()));
                        stringBuffer.append(", Organization = " + this.prepStringForQuery(insightUser.getOrganization()));
                        stringBuffer.append(", Email = " + this.prepStringForQuery(insightUser.getEmail()));
                        stringBuffer.append(", Phone = " + this.prepStringForQuery(insightUser.getPhone()));
                        stringBuffer.append(", Address = " + this.prepStringForQuery(insightUser.getAddress()));
                        stringBuffer.append(", City = " + this.prepStringForQuery(insightUser.getCity()));
                        stringBuffer.append(", State = " + this.prepStringForQuery(insightUser.getState()));
                        stringBuffer.append(", PostalCode = " + this.prepStringForQuery(insightUser.getPostalCode()));
                        stringBuffer.append(", Country = " + this.prepStringForQuery(insightUser.getCountry()));
                    }
                    databaseConnector.setQuery("UPDATE IRUSERS SET LastVisitTimeStamp = '" + new SimpleDate().get() + "'" + stringBuffer.toString() + " WHERE UserID = " + n);
                    this.debugOut("Update last visit time stamp for user " + n + " cmd:\n" + databaseConnector.getQuery());
                    databaseConnector.runUpdateQuerySafe();
                    databaseConnector.close();
                } else {
                    n = this.getNextUserID();
                    if (n > 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, n);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "LoginName", 1, stringBuffer2, insightUser.getLoginName(), true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "FirstName", 1, stringBuffer2, insightUser.getFirstName(), true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "LastName", 1, stringBuffer2, insightUser.getLastName(), true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Organization", 1, stringBuffer2, insightUser.getOrganization(), true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Email", 1, stringBuffer2, insightUser.getEmail(), true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Phone", 1, stringBuffer2, insightUser.getPhone(), true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Address", 1, stringBuffer2, insightUser.getAddress(), true);
                        String string = new SimpleDate().get();
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "LastVisitTimeStamp", 1, stringBuffer2, string, true);
                        sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, string, true);
                        databaseConnector.setQuery("INSERT INTO IRUSERS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                        this.debugOut("Add user cmd:\n" + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                    } else {
                        n = -1;
                    }
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getInsightUserID():\n" + InsightUtilities.getStackTrace(exception));
                n = -1;
            }
            catch (Error error) {
                this.debugOut("Error in getInsightUserID():\n" + InsightUtilities.getStackTrace(error));
                n = -1;
            }
            databaseConnector.close();
        }
        return n;
    }

    public InsightUser getInsightUser(DatabaseConnector databaseConnector) {
        InsightUser insightUser = null;
        try {
            if (databaseConnector != null && databaseConnector.more()) {
                insightUser = new InsightUser(databaseConnector.getIntegerField("UserID"), databaseConnector.getFieldByName("LoginName"), databaseConnector.getFieldByName("FirstName"), databaseConnector.getFieldByName("LastName"), databaseConnector.getFieldByName("Organization"), databaseConnector.getFieldByName("Email"), databaseConnector.getFieldByName("Address"), databaseConnector.getFieldByName("City"), databaseConnector.getFieldByName("State"), databaseConnector.getFieldByName("PostalCode"), databaseConnector.getFieldByName("Country"), databaseConnector.getFieldByName("Phone"), databaseConnector.getFieldByName("CreatedTimestamp"));
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getInsightUser():\n" + InsightUtilities.getStackTrace(exception));
        }
        return insightUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextUserID() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n = 1;
        try {
            Object object = USER_ID_LOCK_OBJECT;
            synchronized (object) {
                databaseConnector.setQuery("SELECT MaxUserID FROM IRMAXIDS");
                this.debugOut("Get next user ID query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                int n2 = 0;
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerField("MaxUserID");
                }
                databaseConnector.close();
                if (n2 <= 0) {
                    databaseConnector.setQuery("SELECT MAX(UserID) AS MaxUserID FROM IRUSERS");
                    this.debugOut("Get max user ID from IRUSERS query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    n2 = databaseConnector.getIntegerField("MaxUserID");
                    databaseConnector.close();
                }
                n = n2 + 1;
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxUserID = " + n);
                this.debugOut("Set max user ID:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextUserID():\n" + InsightUtilities.getStackTrace(exception));
            n = -1;
        }
        databaseConnector.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateStudioUser(String string) {
        DatabaseConnector databaseConnector = null;
        boolean bl = false;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IAADMINISTRATIONACCOUNTS", null, "*");
            sqlQueryGenerator.appendToWhere("UserName = " + this.prepStringForQuery(string));
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            int n2 = 32;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("ServerAdminPermissions", 0);
            }
            databaseConnector.close();
            bl = (n & n2) == n2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in authenticateStudioUser():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCollectionServerPrivs(String string) {
        DatabaseConnector databaseConnector = null;
        int n = 0;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IAADMINISTRATIONACCOUNTS", null, "*");
            sqlQueryGenerator.appendToWhere("UserName = " + this.prepStringForQuery(string));
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("ServerAdminPermissions", n);
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionServerPrivs():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    private String createBatchElementInsertStatement(IMediaBatchElement iMediaBatchElement) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchElementID", 2, stringBuffer2, iMediaBatchElement.getBatchElementID());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchID", 2, stringBuffer2, iMediaBatchElement.getMediaBatch().getBatchID());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ElementStatus", 2, stringBuffer2, iMediaBatchElement.getStatus());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SrcFilepath", 1, stringBuffer2, iMediaBatchElement.getSourceDirectory());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SrcFilename", 1, stringBuffer2, iMediaBatchElement.getSourceFilename());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DestMediaID", 2, stringBuffer2, iMediaBatchElement.getDestMediaID());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectKeyFieldID", 2, stringBuffer2, iMediaBatchElement.getObjectKeyFieldID());
        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectKey", 1, stringBuffer2, iMediaBatchElement.getLinkIdentifier());
        if (iMediaBatchElement.getProcessedTimestamp() != null) {
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ProcessedTimestamp", 1, stringBuffer2, iMediaBatchElement.getProcessedTimestamp().get());
        }
        if (iMediaBatchElement.getLastPublishedTimestamp() != null) {
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LastPublishedTimestamp", 1, stringBuffer2, iMediaBatchElement.getLastPublishedTimestamp().get());
        }
        return "INSERT INTO CCMEDIABATCHELEMENTS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List saveMediaBatch(IMediaBatch iMediaBatch) {
        boolean bl = false;
        DatabaseConnector databaseConnector = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            if (iMediaBatch.getBatchID() == 0) {
                iMediaBatch.setBatchID(this.getNextBatchID());
            }
            if (iMediaBatch.getBatchID() == 0) {
                this.debugOut("failed to get new batch id");
                List list = null;
                return list;
            }
            Object object = BATCH_ELEMENT_ID_LOCK_OBJECT;
            synchronized (object) {
                CharSequence charSequence;
                Object object2;
                Comparable comparable;
                Object object3;
                Object object4;
                FieldStandardsManager fieldStandardsManager = InsightSmartServer.getPrimaryServerInstance().getFSM(iMediaBatch.getUniqueCollectionID());
                int n = -1;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (iMediaBatch.getBatchElements() != null) {
                    long l = this.getNextBatchElementID(iMediaBatch.getBatchID());
                    object4 = iMediaBatch.getBatchElements().iterator();
                    while (object4.hasNext()) {
                        object3 = (IMediaBatchElement)object4.next();
                        if (object3.getBatchElementID() == -1L && !object3.isDeleteRequested()) {
                            object3.setBatchElementID(l++);
                            comparable = new SimpleDate();
                            if (object3.getStatus() == 1 && object3.getProcessedTimestamp() == null) {
                                object3.setProcessedTimestamp((SimpleDate)comparable);
                            }
                            if (object3.isPublishedSinceLastCommit()) {
                                object3.setLastPublishedTimestamp((SimpleDate)comparable);
                            }
                            arrayList2.add(this.createBatchElementInsertStatement((IMediaBatchElement)object3));
                            continue;
                        }
                        if (!object3.isModifiedSinceLastCommit()) continue;
                        arrayList2.add("DELETE FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + object3.getMediaBatch().getBatchID() + " AND BatchElementID = " + object3.getBatchElementID());
                        if (!object3.isDeleteRequested()) {
                            comparable = new SimpleDate();
                            if (object3.getStatus() == 1 && object3.getProcessedTimestamp() == null) {
                                object3.setProcessedTimestamp((SimpleDate)comparable);
                            }
                            if (object3.isPublishedSinceLastCommit()) {
                                object3.setLastPublishedTimestamp((SimpleDate)comparable);
                            }
                            arrayList2.add(this.createBatchElementInsertStatement((IMediaBatchElement)object3));
                        }
                        comparable = null;
                        if (!object3.isLinkModified() || object3.getObjectKeyFieldID() == -1 || (comparable = fieldStandardsManager.getFieldByID(object3.getObjectKeyFieldID())) == null || object3.getDestMediaID() == -1L || object3.getLinkIdentifier().equals("")) continue;
                        if (n == -1) {
                            if (databaseConnector == null) {
                                databaseConnector = this.getDatabaseConnector();
                            }
                            n = TrinityConnector.getPreferredEntityTypeID(object3.getMediaBatch().getUniqueCollectionID(), databaseConnector, this.getQueryGenerator());
                            if (databaseConnector != null) {
                                databaseConnector.close();
                            }
                        }
                        arrayList2.add("DELETE FROM IROBJECTIMAGEMAP WHERE ImageID = " + object3.getDestMediaID());
                        arrayList2.add("DELETE FROM IRENTITYMEDIAMAP WHERE MediaID = " + object3.getDestMediaID());
                        object2 = this.getQueryGenerator();
                        ((SqlQueryGenerator)object2).addTable("DTVALUETOENTITYMAP", null, new String[]{"EntityID", "EntityTypeID"});
                        ((SqlQueryGenerator)object2).addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
                        ((SqlQueryGenerator)object2).appendToWhere("DTVALUES.FieldID = " + object3.getObjectKeyFieldID());
                        ((SqlQueryGenerator)object2).appendToWhere("DTVALUES.UniqueCollectionID = " + object3.getMediaBatch().getUniqueCollectionID());
                        ((SqlQueryGenerator)object2).appendToWhere("DTVALUETOENTITYMAP.EntityTypeID = " + n);
                        if (((Field)comparable).getFieldType() == 2) {
                            ((SqlQueryGenerator)object2).appendToWhere("DTVALUES.ValueNumber = " + object3.getLinkIdentifier());
                        } else {
                            ((SqlQueryGenerator)object2).appendToWhere("DTVALUES.ValueText = " + this.prepStringForQuery(object3.getLinkIdentifier()));
                        }
                        if (databaseConnector == null) {
                            databaseConnector = this.getDatabaseConnector();
                        }
                        databaseConnector.setQuery(((SqlQueryGenerator)object2).getQuery());
                        databaseConnector.runQuerySafe();
                        while (databaseConnector.more()) {
                            long l2 = databaseConnector.getLongField("EntityID", -1L);
                            int n2 = databaseConnector.getIntegerField("EntityTypeID", -1);
                            if (l2 != -1L && n2 != -1) {
                                arrayList2.add("INSERT INTO IROBJECTIMAGEMAP (ObjectID, ImageID) VALUES (" + l2 + ", " + object3.getDestMediaID() + ")");
                                arrayList2.add("INSERT INTO IRENTITYMEDIAMAP (EntityTypeID, EntityID, MediaID) VALUES (" + n2 + ", " + l2 + ", " + object3.getDestMediaID() + ")");
                                arrayList.add(new Long(l2));
                            }
                            databaseConnector.next();
                        }
                        databaseConnector.close();
                    }
                }
                if (iMediaBatch.getLpsDir() == null) {
                    int n3 = ("" + iMediaBatch.getBatchID()).length();
                    charSequence = CoreUtilities.constructTripletText(iMediaBatch.getCollectionKeyWrapper().getInstitutionID(), iMediaBatch.getCollectionKeyWrapper().getCollectionID(), iMediaBatch.getCollectionKeyWrapper().getVCID());
                    if (((String)charSequence).length() > 255 - (n3 + 1)) {
                        object4 = ((String)charSequence).substring(0, 255 - (n3 + 1));
                        iMediaBatch.setLpsDir((String)object4 + '/' + iMediaBatch.getBatchID());
                    } else {
                        iMediaBatch.setLpsDir((String)charSequence + '/' + iMediaBatch.getBatchID());
                    }
                    int n4 = -1;
                    object3 = this.getQueryGenerator();
                    ((SqlQueryGenerator)object3).addTable("IRLPS", null, "LPSID");
                    ((SqlQueryGenerator)object3).appendToWhere("LPS = " + this.prepStringForQuery(iMediaBatch.getLpsDir()));
                    if (databaseConnector == null) {
                        databaseConnector = this.getDatabaseConnector();
                    }
                    databaseConnector.setQuery(((SqlQueryGenerator)object3).getQuery());
                    databaseConnector.runQuerySafe();
                    if (databaseConnector.more()) {
                        n4 = databaseConnector.getIntegerField("LPSID", n4);
                    }
                    databaseConnector.close();
                    if (n4 == -1) {
                        n4 = this.getNextLpsID();
                        if (n4 == -1) {
                            comparable = null;
                            return comparable;
                        }
                        comparable = new StringBuffer();
                        object2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                        sqlQueryGenerator.appendFieldAndValue((StringBuffer)comparable, "LPSID", 2, (StringBuffer)object2, n4);
                        sqlQueryGenerator.appendFieldAndValue((StringBuffer)comparable, "LPS", 1, (StringBuffer)object2, iMediaBatch.getLpsDir());
                        if (databaseConnector == null) {
                            databaseConnector = this.getDatabaseConnector();
                        }
                        databaseConnector.setQuery("INSERT INTO IRLPS (" + comparable + ") VALUES (" + object2 + ")");
                        databaseConnector.runUpdateQuerySafe();
                        databaseConnector.close();
                    }
                    iMediaBatch.setLpsId(n4);
                }
                if (!iMediaBatch.hasBeenSaved()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    charSequence = new StringBuffer();
                    object4 = this.getQueryGeneratorUtil();
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, (StringBuffer)charSequence, iMediaBatch.getUniqueCollectionID());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "BatchID", 2, (StringBuffer)charSequence, iMediaBatch.getBatchID());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "BatchName", 1, (StringBuffer)charSequence, iMediaBatch.getBatchName());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "BatchStatus", 2, (StringBuffer)charSequence, iMediaBatch.getBatchStatus());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "ResolutionProfileID", 2, (StringBuffer)charSequence, iMediaBatch.getBatchProfileID());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "DestDir", 1, (StringBuffer)charSequence, iMediaBatch.getDestDir());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "LPSDir", 1, (StringBuffer)charSequence, iMediaBatch.getLpsDir());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "LogFilepath", 1, (StringBuffer)charSequence, iMediaBatch.getLogFilepath());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "MappingFilepath", 1, (StringBuffer)charSequence, iMediaBatch.getMappingFilepath());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "MappingFieldID", 2, (StringBuffer)charSequence, iMediaBatch.getMappingFieldID());
                    ((SqlQueryGenerator)object4).appendFieldAndValue(stringBuffer, "StartingMediaID", 2, (StringBuffer)charSequence, iMediaBatch.getStartingMediaID());
                    if (databaseConnector == null) {
                        databaseConnector = this.getDatabaseConnector();
                    }
                    databaseConnector.setQuery("INSERT INTO CCMEDIABATCHES (" + stringBuffer + ") VALUES (" + charSequence + ")");
                    int n5 = databaseConnector.runUpdateQuery();
                    if (n5 == 1) {
                        iMediaBatch.setHasBeenSaved(true);
                    }
                    databaseConnector.close();
                } else if (iMediaBatch.isModifiedSinceLastCommit()) {
                    if (databaseConnector == null) {
                        databaseConnector = this.getDatabaseConnector();
                    }
                    databaseConnector.setQuery("UPDATE CCMEDIABATCHES SET MappingFieldID = " + iMediaBatch.getMappingFieldID() + " WHERE BatchID = " + iMediaBatch.getBatchID());
                    int n6 = databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    if (n6 == 1) {
                        iMediaBatch.setModifiedSinceLastCommit(false);
                    }
                }
                if (arrayList2.size() > 0) {
                    if (databaseConnector == null) {
                        databaseConnector = this.getDatabaseConnector();
                    }
                    databaseConnector.executeBatch(arrayList2, true);
                    databaseConnector.close();
                    HashSet<Long> hashSet = new HashSet<Long>();
                    for (int i = 0; i < iMediaBatch.getBatchElements().size(); ++i) {
                        object4 = (IMediaBatchElement)iMediaBatch.getBatchElements().get(i);
                        if (object4.isDeleteRequested()) {
                            if (object4.getDestMediaID() != -1L) {
                                hashSet.add(new Long(object4.getDestMediaID()));
                            }
                            iMediaBatch.getBatchElements().set(i, null);
                            continue;
                        }
                        object4.setModifiedSinceLastCommit(false);
                    }
                    if (hashSet.size() > 0) {
                        Set set = this.getLongIDSet(databaseConnector, "IRENTITYMEDIAMAP", "EntityID", "MediaID", hashSet);
                        if (set != null) {
                            arrayList.addAll(set);
                        }
                        this.deleteMediaRecords(hashSet);
                    }
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in saveMediaBatch():\n" + InsightUtilities.getStackTrace(error));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        if (!bl) {
            return null;
        }
        ArrayList<Long> arrayList3 = arrayList;
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMediaBatchElements(int n) {
        ArrayList<MediaBatchElement> arrayList = new ArrayList<MediaBatchElement>();
        DatabaseConnector databaseConnector = null;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHELEMENTS", null, "*");
            sqlQueryGenerator.appendToWhere("BatchID = " + n);
            sqlQueryGenerator.addOrderBy("CCMEDIABATCHELEMENTS", "BatchElementID");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                String string = databaseConnector.getStringField("ProcessedTimestamp");
                String string2 = databaseConnector.getStringField("LastPublishedTimestamp");
                MediaBatchElement mediaBatchElement = new MediaBatchElement(databaseConnector.getLongField("BatchElementID"), databaseConnector.getIntegerField("ElementStatus", 0), databaseConnector.getStringField("SrcFilepath"), databaseConnector.getStringField("SrcFilename"), databaseConnector.getLongField("DestMediaID", -1L), databaseConnector.getIntegerField("ObjectKeyFieldID", -1), databaseConnector.getStringField("ObjectKey"), string == null ? null : new SimpleDate(string), string2 == null ? null : new SimpleDate(string2));
                arrayList.add(mediaBatchElement);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaBatchElements():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMediaBatch(int n, Set set) {
        boolean bl = false;
        DatabaseConnector databaseConnector = null;
        try {
            Set set2;
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM CCMEDIABATCHES WHERE BatchID = " + n);
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            HashSet<Long> hashSet = new HashSet<Long>();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHELEMENTS", null, "DestMediaID");
            sqlQueryGenerator.appendToWhere("BatchID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                long l = databaseConnector.getLongField("DestMediaID", -1L);
                if (l != -1L) {
                    hashSet.add(new Long(l));
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            if (set != null && hashSet.size() > 0 && (set2 = this.getLongIDSet(null, "IRENTITYMEDIAMAP", "EntityID", "MediaID", hashSet)) != null) {
                set.addAll(set2);
            }
            databaseConnector.setQuery("DELETE FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + n);
            databaseConnector.runUpdateQuerySafe();
            databaseConnector.close();
            if (hashSet.size() > 0) {
                this.deleteMediaRecords(hashSet);
            }
            bl = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMediaBatches(Integer n) {
        ArrayList<MediaBatch> arrayList = new ArrayList<MediaBatch>();
        DatabaseConnector databaseConnector = null;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHES", null, "*");
            sqlQueryGenerator.addTable("IRLPS", null, "LPSID");
            sqlQueryGenerator.addJoin("CCMEDIABATCHES", "LPSDir", "IRLPS", "LPS", 0);
            sqlQueryGenerator.appendToWhere("CCMEDIABATCHES.UniqueCollectionID = " + n);
            sqlQueryGenerator.addOrderBy("CCMEDIABATCHES", "BatchID");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerField("ResolutionProfileID", -1);
                IMediaBatchProfile iMediaBatchProfile = null;
                if (n2 == -2) {
                    iMediaBatchProfile = IMediaBatchProfile.INSIGHT_JP2_BATCH_PROFILE;
                } else if (n2 == -3) {
                    iMediaBatchProfile = IMediaBatchProfile.INSIGHT_PERSONAL_COLLECTIONS_BATCH_PROFILE;
                }
                if (iMediaBatchProfile != null) {
                    MediaBatch mediaBatch = new MediaBatch(n, databaseConnector.getIntegerField("BatchID"), databaseConnector.getField("BatchName"), databaseConnector.getIntegerField("BatchStatus"), iMediaBatchProfile, databaseConnector.getField("DestDir"), databaseConnector.getField("LPSDir"), databaseConnector.getIntegerField("LPSID"), databaseConnector.getField("LogFilepath"), databaseConnector.getField("MappingFilepath"), databaseConnector.getIntegerField("MappingFieldID"), databaseConnector.getLongField("StartingMediaID"));
                    arrayList.add(mediaBatch);
                }
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaBatches():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildFieldPool(TrinityConnector trinityConnector) {
        Object object = FieldStandardsManager.FIELD_POOL_LOCK;
        synchronized (object) {
            if (!FieldStandardsManager.isFieldPoolUpToDate()) {
                if (trinityConnector == null) {
                    trinityConnector = (TrinityConnector)InsightSmartServer.getPrimaryServerInstance().getBackendConnector();
                }
                trinityConnector.setCollectionTemplateMap();
                Field[] fieldArray = trinityConnector.getFieldList(null);
                HashSet<Field> hashSet = new HashSet<Field>();
                for (int i = 0; i < fieldArray.length; ++i) {
                    hashSet.add(fieldArray[i]);
                }
                FieldStandardsManager.setFieldPool(hashSet);
            }
        }
    }

    public FieldStandardsManager assembleFSM(Integer n, boolean bl) {
        DatabaseConnector databaseConnector;
        FieldStandardsManager fieldStandardsManager;
        block41: {
            Debug.debugOut("In assembleFSM()", 3);
            Debug.debugOut("Building FSM (" + n + ")", 2);
            TrinityConnector.rebuildFieldPool(null);
            fieldStandardsManager = new FieldStandardsManager(n);
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            try {
                AbstractCollection abstractCollection;
                if (bl) {
                    sqlQueryGenerator.addTable("ISENTITYFIELDS", null, "FieldID");
                    sqlQueryGenerator.addTable("ISENTITYTYPES", null, "EntityTypeID");
                    sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISENTITYFIELDS", "EntityTypeID", 0);
                    sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                    sqlQueryGenerator.addJoin("ISTEMPLATEENTITYTYPEMAP", "TemplateID", "IRCOLLECTIONCONFIGURATIONINFO", "NativeStandardID", 0);
                    sqlQueryGenerator.appendToWhere("IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Get fields query:\n" + databaseConnector.getQuery());
                    abstractCollection = new HashSet();
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        abstractCollection.add((Integer)new Integer(databaseConnector.getIntegerField("FieldID")));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    sqlQueryGenerator = this.getQueryGenerator();
                    fieldStandardsManager.setFieldList((Set)(abstractCollection.size() > 0 ? abstractCollection : FieldStandardsManager.getFieldPool().keySet()));
                }
                if (bl) {
                    abstractCollection = new Vector();
                    sqlQueryGenerator.addTable("IRFIELDGROUPS", null, "*");
                    sqlQueryGenerator.addOrderBy("IRFIELDGROUPS", "DisplayOrder");
                    sqlQueryGenerator.addOrderBy("IRFIELDGROUPS", "DisplayName");
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Get field groups query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        ((Vector)abstractCollection).add(new FieldMappingGroup(databaseConnector.getIntegerField("FieldGroupID"), databaseConnector.getStringField("DisplayName"), databaseConnector.getIntegerField("FieldGroupType"), databaseConnector.getIntegerField("DisplayOrder")));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    FieldStandardsManager.setFieldMappingGroups(abstractCollection);
                }
                abstractCollection = new ArrayList();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardName");
                sqlQueryGenerator.addTable("SLCOLLECTIONSTANDARDMAP", null, "*");
                sqlQueryGenerator.addJoin("SLSTANDARDSLOOKUP", "SLCOLLECTIONSTANDARDMAP", "StandardID", 0);
                sqlQueryGenerator.addOrderBy("SLCOLLECTIONSTANDARDMAP", "Standards_Order");
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    abstractCollection.add(databaseConnector.getFieldByName("StandardName"));
                    databaseConnector.next();
                }
                databaseConnector.close();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, new String[]{"*", "StandardName AS FieldStandardName", "StandardID AS FieldStandardID"});
                sqlQueryGenerator.addTable("SLSTANDARDFIELDS", null, new String[]{"*"});
                sqlQueryGenerator.addJoin("SLSTANDARDFIELDS", "StandardID", "SLSTANDARDSLOOKUP", "ParentStandardID", 0);
                sqlQueryGenerator.addOrderBy("SLSTANDARDSLOOKUP", "StandardID");
                sqlQueryGenerator.addOrderBy("SLSTANDARDFIELDS", "StandardFieldID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Standard fields query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    Object object;
                    int n2;
                    int n3;
                    String string = null;
                    int n4 = 0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    HashSet hashSet = new HashSet(abstractCollection);
                    while (databaseConnector.more()) {
                        String string2 = databaseConnector.getFieldByName("FieldStandardName");
                        n3 = databaseConnector.getIntegerFieldByName("Standard_Type");
                        if (n3 == 4 && !hashSet.contains(string2)) {
                            databaseConnector.next();
                            continue;
                        }
                        try {
                            string = databaseConnector.getFieldByName("FieldDescriptionURL");
                        }
                        catch (Exception exception) {
                            string = "";
                        }
                        n4 = 0;
                        try {
                            n4 = databaseConnector.getIntegerFieldByName("LongString");
                        }
                        catch (Exception exception) {
                            n4 = 0;
                        }
                        bl5 = false;
                        try {
                            bl5 = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                        }
                        catch (Exception exception) {
                            bl5 = false;
                        }
                        bl2 = false;
                        try {
                            bl2 = databaseConnector.getIntegerFieldByName("DataFieldSearchable") == 1;
                        }
                        catch (Exception exception) {
                            bl2 = true;
                        }
                        bl3 = false;
                        try {
                            bl3 = databaseConnector.getIntegerFieldByName("DisplayedInThumbnail") == 1;
                        }
                        catch (Exception exception) {
                            bl3 = true;
                        }
                        bl4 = false;
                        try {
                            bl4 = databaseConnector.getIntegerFieldByName("Sortable") == 1;
                        }
                        catch (Exception exception) {
                            bl4 = true;
                        }
                        int n5 = 0;
                        try {
                            n5 = databaseConnector.getIntegerFieldByName("SelectListBehavior");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean bl6 = false;
                        try {
                            bl6 = databaseConnector.getBooleanField("IsMappingStandard");
                        }
                        catch (Exception exception) {
                            bl6 = false;
                        }
                        boolean bl7 = false;
                        boolean bl8 = false;
                        try {
                            bl8 = databaseConnector.getBooleanField("IsTemplate");
                        }
                        catch (Exception exception) {
                            bl8 = false;
                        }
                        n2 = 0;
                        try {
                            n2 = databaseConnector.getBooleanField("IsPCTemplate");
                        }
                        catch (Exception exception) {
                            n2 = 0;
                        }
                        boolean bl9 = false;
                        try {
                            bl9 = databaseConnector.getBooleanField("IsPublishedTemplate");
                        }
                        catch (Exception exception) {
                            bl9 = false;
                        }
                        fieldStandardsManager.addFieldStandard(string2, databaseConnector.getIntegerFieldByName("FieldStandardID"), databaseConnector.getIntegerFieldByName("ParentStandardID"), n3, databaseConnector.getFieldByName("Version"), databaseConnector.getFieldByName("Version_Info"), 0, databaseConnector.getStringField("StandardDescriptionURL"), bl6, bl7, bl8, n2 != 0, bl9, databaseConnector.getFieldByName("StandardFieldName"), databaseConnector.getFieldByName("StandardFieldDisplayName"), databaseConnector.getIntegerFieldByName("StandardFieldID"), databaseConnector.getIntegerFieldByName("StandardFieldType"), databaseConnector.getIntegerFieldByName("StandardPickedField") == 1, databaseConnector.getIntegerFieldByName("StandardFieldDisplayOrder"), string, n4, bl5, bl2, bl3, bl4, n5);
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    fieldStandardsManager.setParentRelations();
                    fieldStandardsManager.setEnabledStandardsOrder((List)((Object)abstractCollection));
                    fieldStandardsManager.setMappingStandard();
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("SLFIELDSTANDARDRELATION", null, "*");
                    sqlQueryGenerator.addOrderBy("SLFIELDSTANDARDRELATION", "StandardID");
                    sqlQueryGenerator.addOrderBy("SLFIELDSTANDARDRELATION", "StandardFieldID");
                    sqlQueryGenerator.addOrderBy("SLFIELDSTANDARDRELATION", "MappingStandardFieldID");
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Field relations query: \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    int n6 = 0;
                    n3 = 0;
                    while (databaseConnector.more()) {
                        n6 = databaseConnector.getIntegerFieldByName("StandardFieldID");
                        n3 = databaseConnector.getIntegerFieldByName("MappingStandardFieldID");
                        fieldStandardsManager.setFieldMapping(databaseConnector.getFieldByName("StandardName"), n6, databaseConnector.getFieldByName("MappingStandardName"), n3);
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardName AS FieldStandardName");
                    sqlQueryGenerator.addTable("SLSTANDARDSSTARTUP", null, "*");
                    sqlQueryGenerator.addJoin("SLSTANDARDSLOOKUP", "SLSTANDARDSSTARTUP", new String[]{"StandardID"}, 0);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Startup fields query: \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        fieldStandardsManager.setStartupFields(databaseConnector.getFieldByName("FieldStandardName"), databaseConnector.getIntegerFieldByName("CreateThumbCache") == 1, databaseConnector.getIntegerFieldByName("Thumbnail1FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail2FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail3FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail4FieldID"), databaseConnector.getIntegerFieldByName("Sort1FieldID"), databaseConnector.getIntegerFieldByName("Sort2FieldID"), databaseConnector.getIntegerFieldByName("Sort3FieldID"), databaseConnector.getIntegerFieldByName("Sort4FieldID"));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    LinkFieldStandard linkFieldStandard = new LinkFieldStandard();
                    DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
                    try {
                        sqlQueryGenerator = this.getQueryGenerator();
                        sqlQueryGenerator.addTable("IRLINKFIELDS", null, "*");
                        sqlQueryGenerator.addOrderBy("IRLINKFIELDS", "DisplayOrder");
                        sqlQueryGenerator.addOrderBy("IRLINKFIELDS", "FieldDisplayName");
                        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                        this.debugOut("Link fields query: \n" + databaseConnector.getQuery());
                        databaseConnector.runQuery();
                        object = null;
                        while (databaseConnector.more()) {
                            object = databaseConnector.getFieldByName("FieldName");
                            if (SqlQueryGenerator.doesColumnExist(databaseConnector2, (String)object, "IRLINKREPOSITORY")) {
                                linkFieldStandard.addFieldMapping(new LinkFieldMapping(databaseConnector.getIntegerFieldByName("FieldID"), (String)object, databaseConnector.getFieldByName("FieldDisplayName"), databaseConnector.getIntegerFieldByName("DisplayOrder"), databaseConnector.getIntegerFieldByName("IsDate") == 1));
                            }
                            databaseConnector.next();
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception when creating LinkFieldStandard:\n" + InsightUtilities.getStackTrace(exception));
                    }
                    catch (Error error) {
                        this.debugOut("Error when creating LinkFieldStandard:\n" + InsightUtilities.getStackTrace(error));
                    }
                    object = linkFieldStandard.getFieldMappings();
                    for (n2 = 0; object != null && n2 < ((Vector)object).size(); ++n2) {
                        LinkFieldMapping linkFieldMapping = (LinkFieldMapping)((Vector)object).elementAt(n2);
                        if (!linkFieldMapping.isDate()) continue;
                        linkFieldMapping.setFuzzyDateSearchable(SqlQueryGenerator.doesColumnExist(databaseConnector2, new String[]{linkFieldMapping.fieldName + "_Start", linkFieldMapping.fieldName + "_End"}, "IRLINKREPOSITORY"));
                    }
                    databaseConnector.close();
                    databaseConnector2.close();
                    this.debugOut(linkFieldStandard.getFieldMappingsCount() + " field(s) loaded for standard '" + linkFieldStandard.getStandardName() + "'.");
                    fieldStandardsManager.setLinkStandard(linkFieldStandard);
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "NativeStandardID");
                    sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    databaseConnector.runQuery();
                    n2 = -1;
                    while (databaseConnector.more()) {
                        n2 = databaseConnector.getIntegerFieldByName("NativeStandardID");
                        databaseConnector.next();
                    }
                    fieldStandardsManager.setCollectionStandard(n2);
                    fieldStandardsManager.matchToFinalFields();
                    fieldStandardsManager.matchToHierarchies();
                    fieldStandardsManager.matchToDates();
                    break block41;
                }
                this.debugOut("FSM query has returned no results.");
            }
            catch (Exception exception) {
                this.debugOut("Exception in assembleFSM():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return fieldStandardsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateThemeInfo(Integer n, CollectionKey collectionKey, String string, DefaultTheme defaultTheme) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        boolean bl = false;
        try {
            String string2 = "UPDATE IRCOLLECTIONCONFIGURATIONINFO SET BackgroundColorR = " + defaultTheme.getFillColor().getRed() + ", " + "BackgroundColorG = " + defaultTheme.getFillColor().getGreen() + ", " + "BackgroundColorB = " + defaultTheme.getFillColor().getBlue() + ", " + "BrowserBGMenu = " + this.prepStringForQuery(string + "menu_bg.jpg") + ", " + "BrowserBGGroupLeft = " + this.prepStringForQuery(string + "groupleft_bg.jpg") + ", " + "BrowserBGGroupLeftNS = " + this.prepStringForQuery(string + "groupleft_bg_ns.jpg") + ", " + "BrowserBGGroupRight = " + this.prepStringForQuery(string + "groupright_bg.jpg") + ", " + "BrowserBGGWBottom = " + this.prepStringForQuery(string + "gwbottom_bg.jpg") + ", " + "BrowserBGGWTop = " + this.prepStringForQuery(string + "gwtop_bg.jpg") + " " + "WHERE UniqueCollectionID = " + n + " AND VCID = '" + collectionKey.getVCID() + "'";
            databaseConnector.setQuery(string2);
            bl = databaseConnector.runUpdateQuery() > 0;
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateThemeInfo():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    public int saveCollectionUserGroupKey(CollectionUserGroupKey var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCollectionUserGroupKeyList(Integer n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRUSERGROUPS", null, new String[]{"ProfileID", "UniqueCollectionID", "GroupName", "GroupCodeKey", "GroupID"});
            sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            List list = this.getCollectionProfileKeyList(n2);
            HashMap<Integer, CollectionProfileKey> hashMap = new HashMap<Integer, CollectionProfileKey>();
            Object object = list.iterator();
            while (object.hasNext()) {
                CollectionProfileKey collectionProfileKey = (CollectionProfileKey)object.next();
                hashMap.put(new Integer(collectionProfileKey.getProfileID()), collectionProfileKey);
            }
            while (databaseConnector.more()) {
                object = new CollectionUserGroupKey(new Integer(databaseConnector.getIntegerField("UniqueCollectionID")), databaseConnector.getFieldByName("GroupName"), databaseConnector.getFieldByName("GroupCodeKey"), databaseConnector.getIntegerField("GroupID"));
                int n3 = databaseConnector.getIntegerField("ProfileID", -1);
                CollectionProfileKey collectionProfileKey = (CollectionProfileKey)hashMap.get(new Integer(n3));
                ((CollectionUserGroupKey)object).setProfile(collectionProfileKey);
                arrayList.add(object);
                databaseConnector.next();
            }
            Collections.sort(arrayList);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionProfileKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCollectionProfileKeyList(int n) {
        ArrayList<CollectionProfileKey> arrayList = new ArrayList<CollectionProfileKey>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRPROFILE", null, new String[]{"ProfileID", "CollectionID", "DisplayName"});
            sqlQueryGenerator.appendToWhere("CollectionID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                CollectionProfileKey collectionProfileKey = new CollectionProfileKey(databaseConnector.getIntegerField("ProfileID"), databaseConnector.getIntegerField("CollectionID"), databaseConnector.getFieldByName("DisplayName"));
                arrayList.add(collectionProfileKey);
                databaseConnector.next();
            }
            Collections.sort(arrayList);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionProfileKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    protected List getTrinityList() {
        Vector<String> vector = new Vector<String>(0);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, new String[]{"CollectionID", "InstitutionID", "VCID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    String string = databaseConnector.getStringField("VCID");
                    if (string == null) {
                        string = "NA";
                    }
                    vector.add(CoreUtilities.constructTripletText(databaseConnector.getStringField("institutionID"), databaseConnector.getStringField("CollectionID"), string));
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTrinityList():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCollectionMediaCount() {
        DatabaseConnector databaseConnector = null;
        try {
            int n = Integer.MAX_VALUE;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, "ImageID");
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(sqlQueryGenerator.getQuery(), "MediaCount", true, true));
            this.debugOut("getCollectionMediaCount query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                try {
                    n = databaseConnector.getIntegerField("MediaCount", Integer.MAX_VALUE);
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getCollectionMediaCount():\n" + InsightUtilities.getStackTrace(exception));
                }
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntityCount(Integer n, int n2) {
        DatabaseConnector databaseConnector = null;
        long l = -1L;
        try {
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT COUNT(*) AS COUNT FROM ISCOLLECTIONENTITYMAP WHERE UniqueCollectionID = " + n + " AND EntityTypeID = " + n2);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("COUNT", 0L);
            }
        }
        catch (Throwable throwable) {
            this.debugOut("Exception in getEntityCount():\n" + InsightUtilities.getStackTrace(throwable));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return l;
    }
}

