/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlJoin;
import com.luna.insight.server.backend.SqlReservedWords;
import com.luna.insight.server.backend.SqlTable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class SqlQueryGenerator
implements SqlReservedWords {
    public static final int ENTRY_LEVEL_SQL_92 = 0;
    public static final int INTERMEDIATE_LEVEL_SQL_92 = 1;
    public static final int INNER_JOIN = 0;
    public static final int LEFT_JOIN = 1;
    public static final int RIGHT_JOIN = 2;
    protected int queryMode = 0;
    protected String globalEscapeDelimiter = null;
    protected String unicodeFieldPrefix = null;
    protected List isolatedSelections = null;
    protected Vector tables = new Vector();
    protected Vector joins = new Vector();
    protected Vector orderBys = new Vector();
    protected Map whereAppendages = new Hashtable();
    protected int nextAppendageID = 0;
    protected boolean orderBySet = false;
    protected String orderBySetting = "";
    protected String generatedClause = "";
    protected String distinctKeyword = "";

    public static String getCountQuery(String string, String string2) {
        return SqlQueryGenerator.getCountQuery(string, string2, false, false);
    }

    public static String getCountQuery(String string, String string2, boolean bl, boolean bl2) {
        int n;
        String string3 = "";
        if (string != null) {
            string = string.trim();
        }
        if (string != null && string.length() > 0 && string2 != null && (n = InsightUtilities.indexOf(string, "FROM")) > -1) {
            StringTokenizer stringTokenizer;
            String string4;
            int n2;
            String string5 = "*";
            if (bl && (n2 = string.indexOf(string4 = (stringTokenizer = new StringTokenizer(string)).nextToken())) > -1 && (n2 += string4.length()) < n) {
                String string6;
                int n3 = n;
                int n4 = string.indexOf(",", n2);
                if (n4 > -1 && n4 < n3) {
                    n3 = n4;
                }
                string5 = string.substring(n2, n3);
                int n5 = InsightUtilities.indexOf(string5 = string5.trim(), string6 = "DISTINCT");
                if (n5 == 0) {
                    if (!bl2) {
                        string5 = string5.substring(string6.length());
                    }
                } else if (bl2) {
                    string5 = string6 + " " + string5;
                }
            }
            string3 = "SELECT COUNT(" + string5 + ") AS " + string2;
            int n6 = InsightUtilities.indexOf(string, "ORDER BY");
            string3 = n6 > -1 && n < n6 ? string3 + " " + string.substring(n, n6) : string3 + " " + string.substring(n);
        }
        return string3;
    }

    public static boolean doesColumnExist(DatabaseConnector databaseConnector, String string, String string2) {
        return SqlQueryGenerator.doesColumnExist(databaseConnector, string, string2, true);
    }

    public static boolean doesColumnExist(DatabaseConnector databaseConnector, String string, String string2, boolean bl) {
        String[] stringArray = new String[]{string};
        return SqlQueryGenerator.doesColumnExist(databaseConnector, stringArray, string2, bl);
    }

    public static boolean doesColumnExist(DatabaseConnector databaseConnector, Vector vector, String string) {
        Object[] objectArray = null;
        if (vector != null) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return SqlQueryGenerator.doesColumnExist(databaseConnector, (String[])objectArray, string);
    }

    public static boolean doesColumnExist(DatabaseConnector databaseConnector, String[] stringArray, String string) {
        return SqlQueryGenerator.doesColumnExist(databaseConnector, stringArray, string, true);
    }

    public static boolean doesColumnExist(DatabaseConnector databaseConnector, String[] stringArray, String string, boolean bl) {
        boolean bl2 = false;
        try {
            if (databaseConnector != null && stringArray != null && string != null) {
                int n;
                String string2 = "SELECT ";
                for (n = 0; n < stringArray.length; ++n) {
                    if (n > 0) {
                        string2 = string2 + ", ";
                    }
                    string2 = string2 + "COUNT(" + stringArray[n] + ") AS " + stringArray[n] + "_C";
                }
                string2 = string2 + " FROM " + string;
                SqlQueryGenerator.debugOut("Existence query:\n" + string2, 3);
                databaseConnector.setQuery(string2);
                databaseConnector.runQuery();
                for (n = 0; n < stringArray.length; ++n) {
                    databaseConnector.getFieldByName(stringArray[n] + "_C");
                }
                databaseConnector.close();
                bl2 = true;
            }
        }
        catch (Exception exception) {
            if (bl) {
                SqlQueryGenerator.debugOut("Existence query failed.");
            } else {
                SqlQueryGenerator.debugOut("Exception in doesColumnExist(), exc:\n" + InsightUtilities.getStackTrace(exception));
            }
            bl2 = false;
        }
        catch (Error error) {
            if (bl) {
                SqlQueryGenerator.debugOut("Existence query failed.");
            } else {
                SqlQueryGenerator.debugOut("Error in doesColumnExist(), err:\n" + InsightUtilities.getStackTrace(error));
            }
            bl2 = false;
        }
        return bl2;
    }

    public static int getDataColumnLength(String string, String string2, DatabaseConnector databaseConnector) {
        if (InsightUtilities.isNonEmpty(string) && InsightUtilities.isNonEmpty(string2) && databaseConnector != null) {
            try {
                databaseConnector.setQuery("SELECT " + string2 + " FROM " + string + " WHERE 1 = 2");
                SqlQueryGenerator.debugOut("Get data column length query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuerySafe();
                int[] nArray = databaseConnector.getColumnSizes();
                int[] nArray2 = databaseConnector.getFieldTypes();
                databaseConnector.close();
                if (nArray != null && nArray.length > 0 && nArray2 != null && nArray2.length > 0) {
                    if (SqlQueryGenerator.isNumericType(nArray2[0])) {
                        return "-9223372036854775808".length();
                    }
                    return nArray[0];
                }
            }
            catch (Exception exception) {
                SqlQueryGenerator.debugOut("Exception in getDataColumnLength():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                SqlQueryGenerator.debugOut("Error in getDataColumnLength():\n" + InsightUtilities.getStackTrace(error));
            }
        }
        databaseConnector.close();
        return -1;
    }

    public static boolean isNumericType(int n) {
        return n == -5 || n == -2 || n == -7 || n == 3 || n == 8 || n == 6 || n == 4 || n == 2 || n == 5 || n == -6;
    }

    public SqlQueryGenerator(int n, String string, String string2) {
        this.queryMode = n;
        this.globalEscapeDelimiter = string;
        this.unicodeFieldPrefix = string2;
        if (n < 0 || n > 1) {
            this.queryMode = 0;
        }
    }

    public void appendFieldAndValue(StringBuffer stringBuffer, String string, int n, StringBuffer stringBuffer2, long l) {
        this.appendFieldAndValue(stringBuffer, string, n, stringBuffer2, l + "");
    }

    public void appendFieldAndValue(StringBuffer stringBuffer, String string, int n, StringBuffer stringBuffer2, int n2) {
        this.appendFieldAndValue(stringBuffer, string, n, stringBuffer2, n2 + "");
    }

    public void appendFieldAndValue(StringBuffer stringBuffer, String string, int n, StringBuffer stringBuffer2, boolean bl) {
        this.appendFieldAndValue(stringBuffer, string, n, stringBuffer2, bl ? "1" : "0");
    }

    public void appendFieldAndValue(StringBuffer stringBuffer, String string, int n, StringBuffer stringBuffer2, String string2) {
        this.appendFieldAndValue(stringBuffer, string, n, stringBuffer2, string2, false);
    }

    public void appendFieldAndValue(StringBuffer stringBuffer, String string, int n, StringBuffer stringBuffer2, String string2, boolean bl) {
        if (stringBuffer != null && string != null && string.length() > 0 && stringBuffer2 != null && string2 != null && (string2.length() > 0 || bl)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            if (n == 2) {
                stringBuffer2.append(string2);
            } else {
                stringBuffer2.append(this.prepStringForQuery(string2));
            }
        }
    }

    public String escapeQuotes(String string) {
        String string2 = string == null ? "" : string;
        string2 = InsightUtilities.replaceSubstrings(string2, "'", "''", false);
        if (InsightUtilities.isNonEmpty(this.globalEscapeDelimiter)) {
            string2 = InsightUtilities.replaceSubstrings(string2, this.globalEscapeDelimiter, this.globalEscapeDelimiter + this.globalEscapeDelimiter, false);
        }
        return string2;
    }

    public String prepStringForQuery(String string, boolean bl) {
        if (bl) {
            string = this.escapeQuotes(string);
        } else if (string == null) {
            string = "";
        }
        if (InsightUtilities.isNonEmpty(this.unicodeFieldPrefix)) {
            return this.unicodeFieldPrefix + "'" + string + "'";
        }
        return "'" + string + "'";
    }

    public String prepStringForQuery(String string) {
        return this.prepStringForQuery(string, true);
    }

    public void clear() {
        this.tables.removeAllElements();
        this.joins.removeAllElements();
        this.orderBys.removeAllElements();
        this.isolatedSelections = null;
        this.whereAppendages.clear();
        this.nextAppendageID = 0;
        this.orderBySet = false;
        this.orderBySetting = "";
        this.generatedClause = "";
        this.distinctKeyword = "";
    }

    public void setDistinctKeyword(String string) {
        this.distinctKeyword = string;
    }

    public String addIsolatedSelection(String string) {
        if (string != null && (string = string.trim()).length() > 0) {
            if (this.isolatedSelections == null) {
                this.isolatedSelections = new Vector(1);
            }
            this.isolatedSelections.add(string);
        }
        return string;
    }

    public SqlTable addTable(String string, String string2) {
        return this.addTable(string, null, new String[]{string2});
    }

    public SqlTable addTable(String string, String[] stringArray) {
        return this.addTable(new SqlTable(string, null, InsightUtilities.toVector(stringArray)));
    }

    public SqlTable addTable(String string, String string2, String string3) {
        return this.addTable(string, string2, new String[]{string3});
    }

    public SqlTable addTable(String string, String string2, Object[] objectArray) {
        return this.addTable(new SqlTable(string, string2, InsightUtilities.toVector(objectArray)));
    }

    public SqlTable addTable(SqlTable sqlTable) {
        int n = this.tables.indexOf(sqlTable);
        if (n > -1) {
            SqlTable sqlTable2 = (SqlTable)this.tables.elementAt(n);
            sqlTable2.addColumnSelections(sqlTable.getColumnSelections());
            sqlTable = sqlTable2;
        } else {
            this.tables.addElement(sqlTable);
        }
        return sqlTable;
    }

    public void addColumnSelection(String string, String string2) {
        SqlTable sqlTable = this.getTableByTableName(string);
        if (sqlTable != null) {
            sqlTable.addColumnSelection(string2);
        }
    }

    public void clearColumnSelections(String string) {
        SqlTable sqlTable = this.getTableByTableName(string);
        if (sqlTable != null) {
            sqlTable.clearColumnSelections();
        }
    }

    public SqlTable getTableByTableName(String string) {
        SqlTable sqlTable = null;
        for (int i = 0; string != null && this.tables != null && i < this.tables.size(); ++i) {
            SqlTable sqlTable2 = (SqlTable)this.tables.elementAt(i);
            if (!sqlTable2.getTableName().equalsIgnoreCase(string)) continue;
            sqlTable = sqlTable2;
            break;
        }
        return sqlTable;
    }

    public SqlJoin addJoin(String string, String string2, String string3, int n) {
        return this.addJoin(string, string2, new String[]{string3}, n);
    }

    public SqlJoin addJoin(String string, String string2, String string3, String string4, int n) {
        return this.addJoin(string, new String[]{string2}, string3, new String[]{string4}, n);
    }

    public SqlJoin addJoin(String string, String string2, String[] stringArray, int n) {
        return this.addJoin(string, stringArray, string2, stringArray, n);
    }

    public SqlJoin addJoin(String string, String[] stringArray, String string2, String[] stringArray2, int n) {
        SqlTable sqlTable = this.getTableByTableName(string);
        SqlTable sqlTable2 = this.getTableByTableName(string2);
        if (sqlTable == null) {
            sqlTable = this.addTable(string, new String[0]);
        }
        if (sqlTable2 == null) {
            sqlTable2 = this.addTable(string2, new String[0]);
        }
        if (sqlTable != null && sqlTable2 != null) {
            SqlJoin sqlJoin = new SqlJoin(sqlTable, stringArray, sqlTable2, stringArray2, n, this.queryMode);
            this.joins.addElement(sqlJoin);
            return sqlJoin;
        }
        return null;
    }

    public int appendToWhere(String string) {
        if (string != null && string.length() > 0) {
            if (string.startsWith("AND")) {
                string = string.substring("AND".length());
            }
            if (string.length() > 0) {
                ++this.nextAppendageID;
                this.whereAppendages.put(new Integer(this.nextAppendageID), string);
                return this.nextAppendageID;
            }
        }
        return 0;
    }

    public String removeWhereAppendage(int n) {
        return (String)this.whereAppendages.remove(new Integer(n));
    }

    public Iterator getWhereAppendages() {
        return this.whereAppendages.values().iterator();
    }

    public void addOrderBy(String string, String string2) {
        SqlTable sqlTable;
        if (string2 != null && (sqlTable = this.getTableByTableName(string)) != null) {
            SqlTable sqlTable2 = new SqlTable(sqlTable.getTableName(), sqlTable.getUsername());
            sqlTable2.addOrderByColumn(string2);
            this.orderBys.addElement(sqlTable2);
        }
    }

    public void setOrderBy(String string) {
        if (string != null && string.length() > 0) {
            this.orderBySetting = string;
            this.orderBySet = true;
        }
    }

    public void clearOrderBys() {
        this.orderBySetting = "";
        this.orderBySet = false;
        this.orderBys.removeAllElements();
    }

    public String getQuery() {
        return this.getQuery(false);
    }

    public String getQuery(boolean bl) {
        if (this.generatedClause == null || this.generatedClause.length() == 0) {
            this.generatedClause = this.getSelectClause() + this.getFromClause() + this.getWhereClause() + this.getOrderByClause();
        } else if (bl) {
            this.generatedClause = this.getSelectClause() + this.getFromClause() + this.getWhereClause() + this.getOrderByClause();
        }
        return this.generatedClause;
    }

    protected String getSelectClause() {
        int n;
        String string = "";
        for (n = 0; n < this.tables.size(); ++n) {
            SqlTable sqlTable = (SqlTable)this.tables.elementAt(n);
            String string2 = sqlTable.getSelectionClause();
            if (string2.length() <= 0) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + string2;
        }
        for (n = 0; this.isolatedSelections != null && n < this.isolatedSelections.size(); ++n) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + this.isolatedSelections.get(n);
        }
        if (string.length() > 0) {
            if (this.distinctKeyword.length() > 0) {
                string = this.distinctKeyword + " " + string;
            }
            string = "SELECT " + string;
        }
        return string;
    }

    protected String getFromClause() {
        String string = "";
        if (this.queryMode == 0) {
            for (int i = 0; i < this.tables.size(); ++i) {
                SqlTable sqlTable = (SqlTable)this.tables.elementAt(i);
                String string2 = sqlTable.getFullName();
                if (string2.length() <= 0) continue;
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + string2;
            }
        } else if (this.queryMode == 1) {
            String string3 = "";
            if (this.joins.isEmpty()) {
                for (int i = 0; i < this.tables.size(); ++i) {
                    SqlTable sqlTable = (SqlTable)this.tables.elementAt(i);
                    String string4 = sqlTable.getFullName();
                    if (string4.length() <= 0) continue;
                    if (string3.length() > 0) {
                        string3 = string3 + ", ";
                    }
                    string3 = string3 + string4;
                }
            } else {
                Vector<SqlTable> vector = new Vector<SqlTable>(this.joins.size() * 2);
                for (int i = 0; i < this.joins.size(); ++i) {
                    SqlJoin sqlJoin = (SqlJoin)this.joins.elementAt(i);
                    if (i == 0) {
                        vector.addElement(sqlJoin.getSrcTable());
                        vector.addElement(sqlJoin.getDestTable());
                        string3 = string3 + sqlJoin.getSrcTable().getFullName() + " " + SqlQueryGenerator.getJoinKeyword(sqlJoin.getJoinType()) + " " + sqlJoin.getDestTable().getFullName() + " " + "ON" + " " + sqlJoin.getJoinCondition();
                        continue;
                    }
                    boolean bl = true;
                    SqlTable sqlTable = sqlJoin.getDestTable();
                    int n = vector.indexOf(sqlTable);
                    if (n > -1 && (n = vector.indexOf(sqlTable = sqlJoin.getSrcTable())) > -1) {
                        sqlTable = sqlJoin.getDestTable();
                        bl = false;
                    }
                    if (bl) {
                        vector.addElement(sqlTable);
                    }
                    string3 = "(" + string3 + ")" + " " + SqlQueryGenerator.getJoinKeyword(sqlJoin.getJoinType()) + " " + sqlTable.getFullName() + " " + "ON" + " " + sqlJoin.getJoinCondition();
                }
            }
            string = string + string3;
        }
        if (string.length() > 0) {
            string = " FROM " + string;
        }
        return string;
    }

    protected String getWhereClause() {
        Object object;
        CharSequence charSequence;
        String string = "";
        if (this.queryMode == 0) {
            charSequence = "";
            for (int i = 0; i < this.joins.size(); ++i) {
                object = (SqlJoin)this.joins.elementAt(i);
                String string2 = ((SqlJoin)object).getJoinCondition();
                if (string2.length() <= 0) continue;
                if (((String)charSequence).length() > 0) {
                    charSequence = (String)charSequence + " AND ";
                }
                charSequence = (String)charSequence + string2;
            }
            if (((String)charSequence).length() > 0) {
                string = string + "(" + (String)charSequence + ")";
            }
        } else if (this.queryMode == 1) {
            // empty if block
        }
        charSequence = new StringBuffer();
        if (this.whereAppendages.size() > 0) {
            Iterator iterator = this.whereAppendages.values().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (((StringBuffer)charSequence).length() == 0) {
                    ((StringBuffer)charSequence).append((String)object);
                    continue;
                }
                ((StringBuffer)charSequence).append(" AND (" + (String)object + ")");
            }
        }
        if (((StringBuffer)charSequence).length() > 0) {
            String string3 = "(" + ((StringBuffer)charSequence).toString() + ")";
            if (string.length() > 0) {
                string3 = " AND " + string3;
            }
            string = string + string3;
        }
        if (string.length() > 0) {
            string = " WHERE " + string;
        }
        return string;
    }

    protected String getOrderByClause() {
        String string = "";
        if (this.orderBySet) {
            string = this.orderBySetting.startsWith("ORDER BY") ? this.orderBySetting : string + this.orderBySetting;
        } else {
            for (int i = 0; i < this.orderBys.size(); ++i) {
                SqlTable sqlTable = (SqlTable)this.orderBys.elementAt(i);
                String string2 = sqlTable.getOrderByClause();
                if (string2.length() <= 0) continue;
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + string2;
            }
        }
        if (string.length() > 0) {
            string = " ORDER BY " + string;
        }
        return string;
    }

    public static String getJoinKeyword(int n) {
        if (n == 0) {
            return "INNER JOIN";
        }
        if (n == 1) {
            return "LEFT JOIN";
        }
        if (n == 2) {
            return "RIGHT JOIN";
        }
        return "INNER JOIN";
    }

    public static void debugOut(String string) {
        SqlQueryGenerator.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("SqlQueryGenerator: " + string, n);
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(2);
        SqlQueryGenerator sqlQueryGenerator = new SqlQueryGenerator(1, null, null);
        sqlQueryGenerator.addTable("ImageFiles", "*");
        sqlQueryGenerator.addTable("LPS", "*");
        sqlQueryGenerator.addTable("SPS", "*");
        sqlQueryGenerator.addTable("Profiles", "*");
        sqlQueryGenerator.addJoin("ImageFiles", "LPS", new String[]{"LPSid"}, 0);
        sqlQueryGenerator.addJoin("ImageFiles", "SPS", new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
        sqlQueryGenerator.addJoin("Profiles", "SPS", new String[]{"SPSNum", "CollectionId"}, 0);
        String string = sqlQueryGenerator.getQuery();
        SqlQueryGenerator.debugOut("The query: \n" + string);
    }
}

