/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.AudioFieldCriterion;
import com.luna.insight.server.CollectionInfo;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandardsManager;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.ImageToProcess;
import com.luna.insight.server.InsightDataAnchor;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightSmartServer;
import com.luna.insight.server.InsightSmartServicer;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.IscrMap;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.MiscFieldCriterion;
import com.luna.insight.server.ObjectDataRecord;
import com.luna.insight.server.ObjectDimension;
import com.luna.insight.server.ObjectIndicatorFieldCriterion;
import com.luna.insight.server.ObjectKey;
import com.luna.insight.server.QtvrFieldCriterion;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.StringCriterionValue;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.VideoFieldCriterion;
import com.luna.insight.server.VirtualCollectionInfo;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.InsightBackend;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.SqlTable;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.indexer.DiacriticMappings;
import com.luna.insight.server.links.AnnotationLinkData;
import com.luna.insight.server.links.LinkAuthorshipInfo;
import com.luna.insight.server.links.LinkCodeGenerator;
import com.luna.insight.server.links.LinkData;
import com.luna.insight.server.links.LinkFieldCriterion;
import com.luna.insight.server.links.LinkFieldMapping;
import com.luna.insight.server.links.LinkFieldStandard;
import com.luna.insight.server.links.WebLinkData;
import com.luna.insight.server.mpd.MpdFieldCriterion;
import com.luna.insight.server.mpd.MpdSearchResults;
import com.luna.insight.server.mpd.MultipageDocumentPage;
import com.luna.insight.server.mpd.MultipageDocumentPathEntry;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import com.luna.insight.server.mvi.MviFieldCriterion;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import com.luna.insight.server.ucb.FuzzyDateFieldCriterion;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import com.luna.insight.server.ucb.UcbFuzzyDateMachine;
import com.luna.insight.server.usergroup.UserGroup;
import com.luna.insight.server.usergroup.UserGroupConnectionPool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class InsightBackendConnector
implements InsightBackend {
    public static final int DEBUG_LEVEL = 3;
    public String VERSION_ID = InsightVersion.releaseName();
    public String COMPONENT_CODE = "InsightBackendConnector";
    public static final int DEFAULT_PROFILE = 1;
    public static final int DEFAULT_COLLECTION = 1;
    public static float DEFAULT_DB_VERSION = 2.0f;
    public static Object MAX_IDS_LOCK_OBJ = new Object();
    public static final String ESCAPE_CHARACTER = "\\";
    public static final String CHAR_WILDCARD = "?";
    public static final String STRING_WILDCARD = "*";
    public static final String DEFAULT_CHAR_WILDCARD = "_";
    public static final String DEFAULT_STRING_WILDCARD = "%";
    public static final String DEFAULT_LEFT_ESCAPE_DELIM = "[";
    public static final String DEFAULT_RIGHT_ESCAPE_DELIM = "]";
    public static Locale DEFAULT_LOCALE = new Locale(System.getProperty("user.language", "en"), System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US"));
    public static final int DEFAULT_QUERY_MODE = 0;
    public static final boolean DEFAULT_USE_LOWER_CASE_COMMAND = false;
    public static final boolean DEFAULT_USE_LOWER_CASE_COMMAND_ON_SEARCH_VALUE = false;
    public static final boolean DEFAULT_USE_VALUE_FROM_SUB_QUERY = false;
    public static final boolean DEFAULT_USE_INTERSECT_IN_KEYWORD = false;
    public static final boolean DEFAULT_USE_DISTINCT_KEYWORD = true;
    public static final boolean DEFAULT_USE_UNIQUELIST_CACHE = true;
    public static final boolean DEFAULT_CASE_INSENSITIVE_COMPARISON = true;
    public static final boolean DEFAULT_USE_SQL_COUNT = true;
    public static final boolean DEFAULT_USE_DISTINCT_IN_COUNT = true;
    public static final String DEFAULT_MEDIA_INFO_TABLE_NAME = "IRMEDIAINFO";
    public static final String FUZZY_DATE_FIELD_START_SUFFIX = "_Start";
    public static final String FUZZY_DATE_FIELD_END_SUFFIX = "_End";
    protected static Hashtable hierarchyRelationTypes = null;
    public String IG_TABLE_ARTIST_STORY = "ArtistStory";
    public String IG_TABLE_COLLECTION_INFO = "CollectionConfigurationInfo";
    public String IG_TABLE_FIELDS = "Fields";
    public String IG_TABLE_GROUP_IMAGE_MAP = "GroupImageMap";
    public String IG_TABLE_GROUPS = "Groups";
    public String IG_TABLE_IMAGE_FILES = "ImageFiles";
    public String IG_TABLE_IMAGE_SERIES = "ImageSeries";
    public String IG_TABLE_IMAGE_SERIES_SLIDES = "ImageSeriesSlides";
    public String IG_TABLE_INITIAL_SEARCH = "InitialSearchCriteria";
    public String IG_TABLE_KEYWORDS = "Keywords";
    public String IG_TABLE_LPS = "LPS";
    public String IG_TABLE_MAX_IDS = "MaxIDs";
    public String IG_TABLE_OBJECT_IMAGE_MAP = "ObjectImageMap";
    public String IG_TABLE_OBJECTS = "Objects";
    public String IG_TABLE_OBJECTS_KEY = "ObjectID";
    public String IG_TABLE_PROFILE = "Profile";
    public String IG_TABLE_REVERSE_LOOKUP = "ReverseLookup";
    public String IG_TABLE_SPS = "SPS";
    public String IG_TABLE_VOCABULARY = "Vocabulary";
    public String IG_MEDIA_INFO = "IRMEDIAINFO";
    protected String[] fields;
    protected String[] sortFields = new String[1];
    protected String connectString = "";
    protected int requestedThumbnailSize = 0;
    protected int imageGroupOpen = 0;
    protected int groupID = 0;
    protected boolean readOnly = true;
    protected int baseGroupID = 0;
    protected int groupType = 1;
    protected String groupName = new String("");
    protected boolean msAccessMode = false;
    protected int queryMode = 0;
    protected String globalEscapeDelimiter = null;
    protected String unicodeFieldPrefix = null;
    protected boolean useLowerCaseCommand = false;
    protected boolean useLowerCaseCommandOnSearchValue = false;
    protected boolean useValueFromSubQuery = false;
    protected boolean useIntersectInKeyword = false;
    protected boolean useDistinctKeyword = true;
    protected boolean useUniqueListCache = true;
    protected boolean caseInsensitiveComparison = true;
    protected boolean useSqlCountForThreshold = true;
    protected boolean useDistinctInCount = true;
    protected boolean supportsFuzzyDates = false;
    protected String distinctKeyword = "DISTINCT";
    protected Locale collectionLocale = DEFAULT_LOCALE;
    protected String CHAR_WILDCARD_SYMBOL = "_";
    protected String STRING_WILDCARD_SYMBOL = "%";
    protected String LEFT_ESCAPE_DELIM = "[";
    protected String RIGHT_ESCAPE_DELIM = "]";
    protected DatabaseConnector searchDatabaseConnector = null;
    protected DatabaseConnector collectionConfigurationConnector = null;
    protected int totalRecords = 0;
    protected DatabaseConnectorGenerator dbConnectorGenerator = null;
    protected DiacriticMappings DIACRITIC_MAPPINGS = null;
    protected SqlQueryGenerator sqlQueryGeneratorUtil = this.getQueryGeneratorUtil();

    public static void debugFile(String string) {
        InsightBackendConnector.debugFile(string, 3);
    }

    public static void debugFile(String string, int n) {
        if (3 >= n) {
            // empty if block
        }
    }

    public static Hashtable packageParameters(String string, boolean bl, String string2, String string3, String string4, String string5, Locale locale, int n, String string6, String string7, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, DatabaseConnectorGenerator databaseConnectorGenerator, String string8, DiacriticMappings diacriticMappings) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            hashtable.put("ConnectString", string);
        }
        hashtable.put("MsAccessMode", new Boolean(bl));
        if (string2 != null) {
            hashtable.put("CharWildcard", string2);
        }
        if (string3 != null) {
            hashtable.put("StringWildcard", string3);
        }
        if (string4 != null) {
            hashtable.put("LeftEscapeDelim", string4);
        }
        if (string5 != null) {
            hashtable.put("RightEscapeDelim", string5);
        }
        if (locale != null) {
            hashtable.put("Locale", locale);
        }
        hashtable.put("QueryMode", new Integer(n));
        if (string6 != null) {
            hashtable.put("GlobalEscapeDelimiter", string6);
        }
        if (string7 != null) {
            hashtable.put("UnicodeFieldPrefix", string7);
        }
        hashtable.put("UseLowerCaseCommand", new Boolean(bl2));
        hashtable.put("UseLowerCaseCommandOnSearchValue", new Boolean(bl3));
        hashtable.put("UseValueFromSubQuery", new Boolean(bl4));
        hashtable.put("UseIntersectInKeyword", new Boolean(bl5));
        hashtable.put("UseDistinctKeyword", new Boolean(bl6));
        hashtable.put("UseUniqueListCache", new Boolean(bl7));
        hashtable.put("CaseInsensitiveComparison", new Boolean(bl8));
        hashtable.put("UseSqlCount", new Boolean(bl9));
        hashtable.put("UseDistinctInCount", new Boolean(bl10));
        hashtable.put("SupportsFuzzyDates", new Boolean(bl11));
        if (databaseConnectorGenerator != null) {
            hashtable.put("DbConnectGen", databaseConnectorGenerator);
        }
        hashtable.put("MediaInfoTableName", new String(string8));
        if (diacriticMappings != null) {
            hashtable.put("DIACRITIC_MAPPINGS", diacriticMappings);
        }
        return hashtable;
    }

    public void unpackageParameters(Hashtable hashtable) {
        if (hashtable != null) {
            String string = (String)hashtable.get("ConnectString");
            Boolean bl = (Boolean)hashtable.get("MsAccessMode");
            String string2 = (String)hashtable.get("CharWildcard");
            String string3 = (String)hashtable.get("StringWildcard");
            String string4 = (String)hashtable.get("LeftEscapeDelim");
            String string5 = (String)hashtable.get("RightEscapeDelim");
            Locale locale = (Locale)hashtable.get("Locale");
            Integer n = (Integer)hashtable.get("QueryMode");
            String string6 = (String)hashtable.get("GlobalEscapeDelimiter");
            String string7 = (String)hashtable.get("UnicodeFieldPrefix");
            Boolean bl2 = (Boolean)hashtable.get("UseLowerCaseCommand");
            Boolean bl3 = (Boolean)hashtable.get("UseLowerCaseCommandOnSearchValue");
            Boolean bl4 = (Boolean)hashtable.get("UseValueFromSubQuery");
            Boolean bl5 = (Boolean)hashtable.get("UseIntersectInKeyword");
            Boolean bl6 = (Boolean)hashtable.get("UseDistinctKeyword");
            Boolean bl7 = (Boolean)hashtable.get("UseUniqueListCache");
            Boolean bl8 = (Boolean)hashtable.get("CaseInsensitiveComparison");
            Boolean bl9 = (Boolean)hashtable.get("UseSqlCount");
            Boolean bl10 = (Boolean)hashtable.get("UseDistinctInCount");
            Boolean bl11 = (Boolean)hashtable.get("SupportsFuzzyDates");
            DatabaseConnectorGenerator databaseConnectorGenerator = (DatabaseConnectorGenerator)hashtable.get("DbConnectGen");
            String string8 = (String)hashtable.get("MediaInfoTableName");
            this.DIACRITIC_MAPPINGS = (DiacriticMappings)hashtable.get("DIACRITIC_MAPPINGS");
            if (string != null) {
                this.setConnectString(string);
            }
            if (bl != null) {
                this.msAccessMode = bl;
            }
            if (string2 != null) {
                this.CHAR_WILDCARD_SYMBOL = string2;
            }
            if (string3 != null) {
                this.STRING_WILDCARD_SYMBOL = string3;
            }
            if (string4 != null) {
                this.LEFT_ESCAPE_DELIM = string4;
            }
            if (string5 != null) {
                this.RIGHT_ESCAPE_DELIM = string5;
            }
            if (locale != null) {
                this.collectionLocale = locale;
            }
            if (n != null) {
                this.queryMode = n;
            }
            if (string6 != null) {
                this.globalEscapeDelimiter = string6;
            }
            if (string7 != null) {
                this.unicodeFieldPrefix = string7;
            }
            if (bl2 != null) {
                this.useLowerCaseCommand = bl2;
            }
            if (bl3 != null) {
                this.useLowerCaseCommandOnSearchValue = bl3;
            }
            if (bl4 != null) {
                this.useValueFromSubQuery = bl4;
            }
            if (bl5 != null) {
                this.useIntersectInKeyword = bl5;
            }
            if (bl6 != null) {
                this.useDistinctKeyword = bl6;
            }
            if (bl7 != null) {
                this.useUniqueListCache = bl7;
            }
            if (bl8 != null) {
                this.caseInsensitiveComparison = bl8;
            }
            if (bl9 != null) {
                this.useSqlCountForThreshold = bl9;
            }
            if (bl10 != null) {
                this.useDistinctInCount = bl10;
            }
            if (bl11 != null) {
                this.supportsFuzzyDates = bl11;
            }
            this.dbConnectorGenerator = databaseConnectorGenerator == null ? DatabaseConnectorGenerator.getDefaultGenerator() : databaseConnectorGenerator;
            if (string8 != null && string8.length() > 0) {
                this.IG_MEDIA_INFO = string8;
            }
            this.sqlQueryGeneratorUtil = this.getQueryGenerator();
        }
    }

    public static Vector groupImagesToProcess(Vector vector) {
        Vector vector2 = new Vector(0);
        boolean bl = false;
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            int n;
            ImageToProcess imageToProcess = (ImageToProcess)vector.elementAt(i);
            if (imageToProcess == null) continue;
            Vector<ImageToProcess> vector3 = null;
            for (n = 0; n < vector2.size() && ((vector3 = (Vector<ImageToProcess>)vector2.elementAt(n)) == null || vector3.size() <= 0 || ((ImageToProcess)vector3.firstElement()).groupID != imageToProcess.groupID); ++n) {
                vector3 = null;
            }
            if (vector3 == null) {
                vector3 = new Vector<ImageToProcess>(1);
                vector2.addElement(vector3);
            }
            bl = false;
            for (n = 0; n < vector3.size(); ++n) {
                ImageToProcess imageToProcess2 = (ImageToProcess)vector3.elementAt(n);
                if (imageToProcess2 == null || imageToProcess2.groupID != imageToProcess.groupID || imageToProcess2.objectID != imageToProcess.objectID || imageToProcess2.imageID != imageToProcess.imageID || imageToProcess2.hasMultiview != imageToProcess.hasMultiview) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector3.addElement(imageToProcess);
        }
        return vector2;
    }

    public InsightBackendConnector(Hashtable hashtable) {
        this.unpackageParameters(hashtable);
        this.sortFields[0] = "ImageID";
        if (this.msAccessMode) {
            this.distinctKeyword = "DISTINCTROW";
        }
        if (!this.useDistinctKeyword) {
            this.distinctKeyword = "";
        }
    }

    public void setConnectString(String string) {
        if (string != null) {
            this.connectString = string;
        } else {
            InsightBackendConnector.debugFile("setConnectString received null.");
        }
    }

    public void finalize() {
        if (this.searchDatabaseConnector != null) {
            this.searchDatabaseConnector.close();
        }
        if (this.collectionConfigurationConnector != null) {
            this.collectionConfigurationConnector.close();
        }
    }

    public void setVersionID(String string) {
        this.VERSION_ID = string;
    }

    public void setComponentCode(String string) {
        this.COMPONENT_CODE = string;
    }

    public String getVersionId() {
        return this.VERSION_ID;
    }

    public String getImplementationName() {
        return "Std. " + this.dbConnectorGenerator.getConnectorTypeString() + " Insight Backend";
    }

    public void doQueryEqualityTest(String string, String string2) {
        boolean bl = false;
        if (string == null && string2 == null) {
            bl = true;
        } else if (string != null && string2 == null) {
            bl = false;
        } else if (string == null && string2 != null) {
            bl = false;
        } else if (string != null && string2 != null) {
            bl = string.equals(string2);
        }
        if (bl) {
            this.debugOut("\n\n\nQuery equality test:  *-*-*-*-*-* Queries are equal. *-*-*-*-*-*\n\n");
        } else {
            this.debugOut("\n\n\nQuery equality test:  *-*-*-*-*-* QUERIES ARE NOT EQUAL!!! *-*-*-*-*-*\n\n");
        }
    }

    public boolean isMedeEnabled() {
        this.debugOut("In isMedeEnabled().");
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYTYPES", null, STRING_WILDCARD);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get entity types query: " + databaseConnector.getQuery());
            databaseConnector.runQuery();
            bl = databaseConnector.more();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isMedeEnabled(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return bl;
    }

    public float getDatabaseVersion() {
        this.debugOut("in getDatabaseVersion().");
        float f = DEFAULT_DB_VERSION;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable("IRVERSION", null, "Version");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get database version query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                String string = databaseConnector.getFieldByName("Version");
                try {
                    f = Float.parseFloat(string);
                }
                catch (Exception exception) {
                    this.debugOut("Exception parsing DB version: not a float:\n" + InsightUtilities.getStackTrace(exception));
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDatabaseVersion(), exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        this.debugOut("Returning database version: " + f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUniqueCollectionIDs() {
        this.debugOut("In getUniqueCollectionIDs()");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            Serializable serializable;
            String string = "UniqueCollectionID";
            ArrayList arrayList = new ArrayList();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", string);
            sqlQueryGenerator.addOrderBy("IRCOLLECTIONCONFIGURATIONINFO", string);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            HashSet hashSet = new HashSet();
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                serializable = new Integer(databaseConnector.getIntegerField(string));
                if (this.useDistinctKeyword) {
                    arrayList.add(serializable);
                } else if (hashSet.add(serializable)) {
                    arrayList.add(serializable);
                }
                databaseConnector.next();
            }
            serializable = arrayList;
            return serializable;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueCollectionIDs():\n" + InsightUtilities.getStackTrace(exception));
            List list = null;
            return list;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public Vector getThumbnailQueries(Integer n) {
        this.debugOut("in getThumbnailQueries().");
        Vector<ThumbnailQuery> vector = new Vector<ThumbnailQuery>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, new String[]{STRING_WILDCARD});
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, new String[]{"GroupID"});
            sqlQueryGenerator.addJoin(this.IG_TABLE_COLLECTION_INFO, new String[]{"InitialGroupOpen", "VCID"}, this.IG_TABLE_GROUPS, new String[]{"Name", "VCID"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_GROUPS + ".GroupType = " + 1);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".UniqueCollectionID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get thumbnail queries query: \n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            ThumbnailQuery thumbnailQuery = null;
            boolean bl = false;
            while (databaseConnector.more()) {
                try {
                    bl = databaseConnector.getBooleanField("IsPersonalCollection");
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) {
                    thumbnailQuery = new ThumbnailQuery(new CollectionKeyWrapper(databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getFieldByName("VCID")), databaseConnector.getIntegerFieldByName("GroupID"), 0, databaseConnector.getIntegerFieldByName("ThumbCacheProfileID"), databaseConnector.getIntegerFieldByName("UserCollection"), false);
                    this.debugOut("Adding thumbnail query: " + thumbnailQuery.toKeyString());
                    vector.addElement(thumbnailQuery);
                }
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getThumbnailQueries():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public int getSessionLimit(UserGroupConnectionPool userGroupConnectionPool) {
        int n = 0;
        if (userGroupConnectionPool != null) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "SELECT IRCONNECTIONPOOLS.MaximumConnections FROM IRCONNECTIONPOOLS WHERE (ConnectionPoolID = " + userGroupConnectionPool.getPoolID() + ");";
            this.debugOut("Session query: " + string);
            try {
                databaseConnector.setQuery(string);
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n = databaseConnector.getIntegerFieldByName("MaximumConnections");
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getSessionLimit(): " + exception);
            }
            databaseConnector.close();
        }
        return n;
    }

    public Vector getUserGroupList() {
        Vector<UserGroup> vector = new Vector<UserGroup>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable("IRUSERGROUPS", null, STRING_WILDCARD);
            sqlQueryGenerator.addOrderBy("IRUSERGROUPS", "GroupID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("User group list query: " + databaseConnector.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            String string = null;
            String string2 = null;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string3 = null;
            String string4 = null;
            Integer n5 = null;
            UserGroup userGroup = null;
            while (databaseConnector.more()) {
                n = databaseConnector.getIntegerFieldByName("GroupID");
                string = databaseConnector.getFieldByName("GroupName");
                string2 = databaseConnector.getFieldByName("GroupCodeKey");
                n2 = databaseConnector.getIntegerFieldByName("ProfileID");
                n3 = databaseConnector.getIntegerFieldByName("ConnectionPoolID");
                n4 = databaseConnector.getIntegerFieldByName("ConnectionReserve");
                n5 = new Integer(databaseConnector.getIntegerField("UniqueCollectionID", -1));
                string3 = null;
                string4 = null;
                try {
                    string3 = databaseConnector.getFieldByName("IPAddressRanges");
                }
                catch (Exception exception) {
                    string3 = null;
                }
                try {
                    string4 = databaseConnector.getFieldByName("BrowserIPAddressRanges");
                }
                catch (Exception exception) {
                    string4 = null;
                }
                if (string3 == null) {
                    this.debugOut("WARNING: Could not find field \"IPAddressRanges\" in table IRUSERGROUPS, using default range of all IPs.");
                    string3 = "0.0.0.0-255.255.255.255";
                }
                if (string4 == null) {
                    this.debugOut("WARNING: Could not find field \"BrowserIPAddressRanges\" in table IRUSERGROUPS, using value of IPAddressRanges.");
                    string4 = string3;
                }
                userGroup = new UserGroup(n5, n, string, string2, n2, n3, n4, string3, string4);
                vector.addElement(userGroup);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUserGroupList(): " + exception);
        }
        databaseConnector.close();
        return vector;
    }

    public Vector getUserGroupConnectionPoolList(InsightSmartServer insightSmartServer) {
        Vector<UserGroupConnectionPool> vector = new Vector<UserGroupConnectionPool>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable("IRCONNECTIONPOOLS", null, STRING_WILDCARD);
            sqlQueryGenerator.addOrderBy("IRCONNECTIONPOOLS", "ConnectionPoolID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Connection pool list query: " + databaseConnector.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            String string = null;
            int n2 = 0;
            UserGroupConnectionPool userGroupConnectionPool = null;
            while (databaseConnector.more()) {
                n = databaseConnector.getIntegerFieldByName("ConnectionPoolID");
                string = databaseConnector.getFieldByName("PoolName");
                n2 = databaseConnector.getIntegerFieldByName("MaximumConnections");
                userGroupConnectionPool = new UserGroupConnectionPool(n, string, n2, insightSmartServer);
                vector.addElement(userGroupConnectionPool);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getConnectionPoolList(): " + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public String escapeQuotes(String string) {
        return this.getQueryGeneratorUtil().escapeQuotes(string);
    }

    public String prepStringForQuery(String string) {
        return this.getQueryGeneratorUtil().prepStringForQuery(string);
    }

    public String prepStringForQuery(String string, boolean bl) {
        return this.getQueryGeneratorUtil().prepStringForQuery(string, bl);
    }

    public String escapeSpecialCharacters(String string) {
        return this.escapeSpecialCharacters(string, this.LEFT_ESCAPE_DELIM, this.RIGHT_ESCAPE_DELIM);
    }

    public String escapeSpecialCharacters(String string, String string2, String string3) {
        String string4 = this.escapeQuotes(string);
        if (InsightUtilities.isEmpty(string2) && InsightUtilities.isEmpty(string3)) {
            return string4;
        }
        string4 = InsightUtilities.replaceSubstrings(string4, DEFAULT_LEFT_ESCAPE_DELIM, string2 + DEFAULT_LEFT_ESCAPE_DELIM + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, "{", string2 + "{" + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, "(", string2 + "(" + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, DEFAULT_CHAR_WILDCARD, string2 + DEFAULT_CHAR_WILDCARD + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, "#", string2 + "#" + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, "-", string2 + "-" + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, "^", string2 + "^" + string3, false);
        string4 = InsightUtilities.replaceSubstrings(string4, DEFAULT_STRING_WILDCARD, string2 + DEFAULT_STRING_WILDCARD + string3, false);
        return string4;
    }

    public String underscoreFieldName(String string) {
        if (string != null) {
            return string.replace(' ', '_');
        }
        return null;
    }

    public void underscoreFields() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = this.underscoreFieldName(this.fields[i]);
        }
    }

    public boolean isOpen() {
        return this.imageGroupOpen == 1;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public int getBaseGroupID() {
        return this.baseGroupID;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getObjectID(long l) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        long l2 = -1L;
        try {
            String string = "SELECT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE (ImageID = " + l + ")";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l2 = databaseConnector.getLongField("ObjectID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectID(): " + exception);
        }
        databaseConnector.close();
        return l2;
    }

    public long getImageID(long l) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        long l2 = -1L;
        try {
            String string = "SELECT ImageID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE (ObjectID = " + l + ")";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l2 = databaseConnector.getLongField("ImageID");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageID(): " + exception);
        }
        databaseConnector.close();
        return l2;
    }

    public void getVirtualCollectionID(VirtualCollectionInfo virtualCollectionInfo) {
    }

    public Vector getDescriptionData(TrinityCollectionInfo trinityCollectionInfo) {
        return this.getDescriptionData(trinityCollectionInfo.getInstitutionID(), trinityCollectionInfo.getCollectionID(), trinityCollectionInfo.getVCID());
    }

    public Vector getDescriptionData(String string, String string2, String string3) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, new String[]{"ShortDescription", "LongDescriptionURL"});
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".InstitutionID=" + this.prepStringForQuery(string));
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".CollectionID=" + this.prepStringForQuery(string2));
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".VCID=" + this.prepStringForQuery(string3));
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Data query: \n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            Vector<String> vector = new Vector<String>(2);
            String string4 = "";
            String string5 = "";
            try {
                string4 = databaseConnector.getFieldByName("ShortDescription");
                string5 = databaseConnector.getFieldByName("LongDescriptionURL");
            }
            catch (Exception exception) {
                string4 = "";
                string5 = "";
                this.debugOut("Exception in getDescriptionData(): " + exception);
            }
            vector.addElement(string4);
            vector.addElement(string5);
            databaseConnector.close();
            return vector;
        }
        databaseConnector.close();
        return null;
    }

    public void openCollectionConfiguration(String string, String string2, String string3) {
        this.debugOut("In openCollectionConfiguration().");
        this.collectionConfigurationConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, STRING_WILDCARD);
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".InstitutionID=" + this.prepStringForQuery(string));
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".CollectionID=" + this.prepStringForQuery(string2));
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".VCID=" + this.prepStringForQuery(string3));
        this.collectionConfigurationConnector.setQuery(sqlQueryGenerator.getQuery());
        this.collectionConfigurationConnector.runQuery();
    }

    public String getCollectionConfigurationValue(String string) {
        String string2 = null;
        if (this.collectionConfigurationConnector != null) {
            try {
                string2 = this.collectionConfigurationConnector.getFieldByName(string);
            }
            catch (Exception exception) {
                this.debugOut("Exception in InsightBackendConnector.getCollectionConfigurationValue(): " + exception);
            }
        } else {
            this.debugOut("gCCV(): No collection configuration info available.");
        }
        return string2;
    }

    public void closeCollectionConfiguration() {
        if (this.collectionConfigurationConnector != null) {
            this.collectionConfigurationConnector.close();
            this.collectionConfigurationConnector = null;
        }
    }

    public String getCollectionConfigurationFieldValue(String string, String string2, String string3) {
        this.debugOut("In getCollectionConfigurationFieldValue().");
        String string4 = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        String string5 = "SELECT " + this.IG_TABLE_COLLECTION_INFO + ".*" + " FROM " + this.IG_TABLE_COLLECTION_INFO + " WHERE ((" + this.IG_TABLE_COLLECTION_INFO + ".InstitutionID = " + this.prepStringForQuery(string) + ") AND (" + this.IG_TABLE_COLLECTION_INFO + ".CollectionID = " + this.prepStringForQuery(string2) + "))";
        databaseConnector.setQuery(string5);
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            try {
                string4 = databaseConnector.getFieldByName(string3);
            }
            catch (Exception exception) {
                this.debugOut("Exception in InsightBackendConnector.getCollectionConfigurationFieldValue(): " + exception);
            }
        } else {
            this.debugOut("No collection configuration info available for id [" + string + ", " + string2 + "].");
        }
        databaseConnector.close();
        return string4;
    }

    protected void getConfigurationInfo(TrinityCollectionInfo trinityCollectionInfo, boolean bl) {
        DatabaseConnector databaseConnector;
        block21: {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, STRING_WILDCARD);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".InstitutionID = " + this.prepStringForQuery(trinityCollectionInfo.getInstitutionID()) + " AND " + this.IG_TABLE_COLLECTION_INFO + ".CollectionID = " + this.prepStringForQuery(trinityCollectionInfo.getCollectionID()) + " AND " + this.IG_TABLE_COLLECTION_INFO + ".VCID = " + this.prepStringForQuery(trinityCollectionInfo.getVCID()));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Config info query: \n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                try {
                    Serializable serializable;
                    if (bl) {
                        trinityCollectionInfo.setCollectionName(databaseConnector.getFieldByName("CollectionName"));
                    }
                    trinityCollectionInfo.setPcUsrGrpMemberPrivs(databaseConnector.getIntegerField("PcUserGroupMemberPrivs"));
                    trinityCollectionInfo.setPcNonUsrGrpMemberPrivs(databaseConnector.getIntegerField("PcNonUserGroupMemberPrivs"));
                    trinityCollectionInfo.setUniqueCollectionID(new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID")));
                    trinityCollectionInfo.setNativeStandardID(databaseConnector.getIntegerFieldByName("NativeStandardID"));
                    trinityCollectionInfo.setInitialActivity(databaseConnector.getIntegerFieldByName("InitialActivity"));
                    trinityCollectionInfo.setInitialGroupOpen(databaseConnector.getFieldByName("InitialGroupOpen"));
                    trinityCollectionInfo.setDisplayArtistStories(databaseConnector.getIntegerFieldByName("DisplayArtistStories") != 0);
                    trinityCollectionInfo.setVerticalBarX(databaseConnector.getIntegerFieldByName("VerticalBarX"));
                    trinityCollectionInfo.setHorizontalBarY(databaseConnector.getIntegerFieldByName("HorizontalBarY"));
                    trinityCollectionInfo.setBackgroundColor(new Color(databaseConnector.getIntegerFieldByName("BackgroundColorR"), databaseConnector.getIntegerFieldByName("BackgroundColorG"), databaseConnector.getIntegerFieldByName("BackgroundColorB")));
                    trinityCollectionInfo.setUserCollection(databaseConnector.getIntegerFieldByName("UserCollection"));
                    trinityCollectionInfo.setLargeThumbnailThreshold(databaseConnector.getIntegerFieldByName("LargeThumbnailThreshold"));
                    trinityCollectionInfo.setDefaultViewResolution(databaseConnector.getIntegerFieldByName("DefaultViewResolution"));
                    trinityCollectionInfo.setGroupTopInset(databaseConnector.getIntegerFieldByName("GroupTopInset"));
                    trinityCollectionInfo.setGroupLeftInset(databaseConnector.getIntegerFieldByName("GroupLeftInset"));
                    trinityCollectionInfo.setGroupSpacingH(databaseConnector.getIntegerFieldByName("GroupSpacingH"));
                    trinityCollectionInfo.setGroupSpacingV(databaseConnector.getIntegerFieldByName("GroupSpacingV"));
                    trinityCollectionInfo.setMenuXPosition(databaseConnector.getIntegerFieldByName("MenuXPosition"));
                    trinityCollectionInfo.setMaximumWindows(databaseConnector.getIntegerFieldByName("MaximumWindows"));
                    trinityCollectionInfo.setInterWindowSpacing(databaseConnector.getIntegerFieldByName("InterWindowSpacing"));
                    trinityCollectionInfo.setMinImageWindowSize(new Dimension(databaseConnector.getIntegerFieldByName("MinImageWindowSizeWidth"), databaseConnector.getIntegerFieldByName("MinImageWindowSizeHeight")));
                    trinityCollectionInfo.setDragSpeedCoeffecient(databaseConnector.getIntegerFieldByName("DragSpeedCoeffecient"));
                    trinityCollectionInfo.setInitialGroupROnly(databaseConnector.getIntegerFieldByName("InitialGroupROnly") != 0);
                    trinityCollectionInfo.setHelpGroup(databaseConnector.getFieldByName("HelpGroup"));
                    trinityCollectionInfo.setHelpImage(databaseConnector.getFieldByName("HelpImage"));
                    trinityCollectionInfo.setSimultaneousIWLoads(databaseConnector.getIntegerFieldByName("SimultaneousIWLoads"));
                    trinityCollectionInfo.setSimultaneousGWLoads(databaseConnector.getIntegerFieldByName("SimultaneousGWLoads"));
                    trinityCollectionInfo.setMacWidthAdjustment(databaseConnector.getIntegerFieldByName("MacWidthAdjustment"));
                    trinityCollectionInfo.setBGURL(databaseConnector.getFieldByName("BGURL"));
                    trinityCollectionInfo.setScaleFast(databaseConnector.getIntegerFieldByName("FastScaling") != 0);
                    try {
                        trinityCollectionInfo.setCopyrightStatement(databaseConnector.getStringField("CopyrightStatement"));
                    }
                    catch (Exception exception) {
                        trinityCollectionInfo.setCopyrightStatement("");
                    }
                    try {
                        trinityCollectionInfo.setForceCollectionName(databaseConnector.getBooleanField("ForceCollectionNameDisplay"));
                    }
                    catch (Exception exception) {
                        trinityCollectionInfo.setForceCollectionName(false);
                    }
                    try {
                        trinityCollectionInfo.setRemoteLaunchBaseUrl(databaseConnector.getStringField("RemoteLaunchBaseURL"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        trinityCollectionInfo.setRemoteLaunchHyperlinkTemplate(databaseConnector.getStringField("RemoteLaunchHyperlinkTemplate"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        trinityCollectionInfo.setBrowserRtlUrl(databaseConnector.getStringField("BrowserRTLURL"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        trinityCollectionInfo.setCreatedTimestamp(databaseConnector.getStringField("CreatedTimestamp"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    trinityCollectionInfo.setSearchCriteria(this.getInitialSearchCriteria(trinityCollectionInfo.getInstitutionID(), trinityCollectionInfo.getCollectionID(), trinityCollectionInfo.getVCID()));
                    trinityCollectionInfo.setInfoComplete();
                    if (!trinityCollectionInfo.getVCID().equals("NA")) {
                        serializable = new TrinityCollectionInfo(trinityCollectionInfo.getUserID(), trinityCollectionInfo.getUserName(), trinityCollectionInfo.getInstitutionID(), trinityCollectionInfo.getCollectionID(), trinityCollectionInfo.getServerID(), trinityCollectionInfo.getCollectionName(), trinityCollectionInfo.getServerAddress(), trinityCollectionInfo.getServerPort(), trinityCollectionInfo.getUserGroupName(), trinityCollectionInfo.getUserGroupCodeKey(), trinityCollectionInfo.getUserGroupProfileID());
                        ((TrinityCollectionInfo)serializable).setVCID("NA");
                        this.getConfigurationInfo((TrinityCollectionInfo)serializable, true);
                        if (((CollectionInfo)serializable).isInfoComplete()) {
                            trinityCollectionInfo.setParentTci((TrinityCollectionInfo)serializable);
                        }
                        break block21;
                    }
                    databaseConnector.close();
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, "VCID");
                    sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, "GroupID");
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_COLLECTION_INFO + ".UniqueCollectionID = " + trinityCollectionInfo.getUniqueCollectionID());
                    sqlQueryGenerator.addJoin(this.IG_TABLE_COLLECTION_INFO, "InitialGroupOpen", this.IG_TABLE_GROUPS, "Name", 0);
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("VC groups query: \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    serializable = new ArrayList();
                    while (databaseConnector.more()) {
                        Integer n;
                        if (!databaseConnector.getFieldByName("VCID").equals("NA") && (n = new Integer(databaseConnector.getIntegerField("GroupID", -1))) != -1) {
                            serializable.add(n);
                        }
                        databaseConnector.next();
                    }
                    trinityCollectionInfo.setVirtualCollectionGroups((List)((Object)serializable));
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getConfigurationInfo(): " + InsightUtilities.getStackTrace(exception));
                }
            } else {
                this.debugOut("No collection configuration info available for " + trinityCollectionInfo.getCollectionName());
            }
        }
        databaseConnector.close();
    }

    public void getConfigurationInfo(TrinityCollectionInfo trinityCollectionInfo) {
        this.getConfigurationInfo(trinityCollectionInfo, false);
    }

    protected String constructVirtualGroupQuery(String string, int n) {
        return "(" + string + ".GroupID=" + n + ")";
    }

    public Vector getInitialSearchCriteria(String string, String string2, String string3) {
        Vector<FieldCriterion> vector = new Vector<FieldCriterion>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable(this.IG_TABLE_INITIAL_SEARCH, null, STRING_WILDCARD);
            sqlQueryGenerator.addTable(this.IG_TABLE_FIELDS, null, STRING_WILDCARD);
            sqlQueryGenerator.addJoin(this.IG_TABLE_INITIAL_SEARCH, this.IG_TABLE_FIELDS, new String[]{"FieldID"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_INITIAL_SEARCH + ".InstitutionID = " + this.prepStringForQuery(string));
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_INITIAL_SEARCH + ".CollectionID = " + this.prepStringForQuery(string2));
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_INITIAL_SEARCH + ".VCID = " + this.prepStringForQuery(string3));
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_INITIAL_SEARCH + ".SearchType = 1");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_INITIAL_SEARCH, "CriteriaOrder");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Initial search criteria query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                FieldCriterion fieldCriterion = null;
                Field field = null;
                while (databaseConnector.more()) {
                    fieldCriterion = new FieldCriterion(databaseConnector.getIntegerFieldByName("BooleanOp"), databaseConnector.getIntegerFieldByName("EquivalenceOp"), new StringCriterionValue(databaseConnector.getFieldByName("Criterion")));
                    field = new Field(databaseConnector.getIntegerFieldByName("FieldId"), databaseConnector.getFieldByName("FieldName"), databaseConnector.getIntegerFieldByName("SearchType"));
                    field.fieldDisplayName = field.fieldName;
                    field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                    fieldCriterion.field = field;
                    vector.addElement(fieldCriterion);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getInitialSearchCriteria(): " + exception);
        }
        databaseConnector.close();
        return vector;
    }

    public FieldCriterion[] getSearchCriteriaAsArray(String string, String string2, String string3) {
        Vector vector = this.getInitialSearchCriteria(string, string2, string3);
        Object[] objectArray = new FieldCriterion[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int[] getPrivs(int n, int n2) {
        int[] nArray = new int[]{0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0};
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable(this.IG_TABLE_PROFILE, null, STRING_WILDCARD);
            sqlQueryGenerator.appendToWhere("ProfileId = " + n);
            sqlQueryGenerator.appendToWhere("CollectionId = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                try {
                    nArray[0] = databaseConnector.getIntegerFieldByName("ExportPriv");
                    nArray[1] = databaseConnector.getIntegerFieldByName("PrintPriv");
                    nArray[2] = databaseConnector.getIntegerFieldByName("EditPriv");
                    if (nArray[2] > 0) {
                        nArray[3] = databaseConnector.getIntegerFieldByName("EditVocabPriv");
                    }
                    nArray[4] = databaseConnector.getIntegerFieldByName("MaxViewableSize");
                    nArray[5] = databaseConnector.getIntegerFieldByName("HTMLExport");
                    nArray[6] = databaseConnector.getIntegerFieldByName("SaveGroups");
                    nArray[7] = databaseConnector.getIntegerFieldByName("DeleteGroups");
                    nArray[8] = databaseConnector.getIntegerFieldByName("EditMviPriv");
                    nArray[9] = databaseConnector.getIntegerFieldByName("EditLinkPriv");
                    nArray[10] = databaseConnector.getIntegerFieldByName("EditMpdPriv");
                    nArray[11] = databaseConnector.getIntegerFieldByName("EditPersonalCollections");
                    nArray[12] = databaseConnector.getIntegerFieldByName("ExportPresentationPriv");
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getPrivs():" + exception + "\n");
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPrivs():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return nArray;
    }

    public ImageSeries[] getImageSeriesList(int n) {
        Object object;
        Vector<ImageSeries> vector = new Vector<ImageSeries>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            object = "SELECT " + this.IG_TABLE_IMAGE_SERIES + ".*" + " FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE (GroupID = " + n + ");";
            databaseConnector.setQuery((String)object);
            databaseConnector.runQuery();
            ImageSeries imageSeries = null;
            while (databaseConnector.more()) {
                imageSeries = new ImageSeries(databaseConnector.getFieldByName("SeriesName"), databaseConnector.getIntegerFieldByName("ImageSeriesID"));
                vector.addElement(imageSeries);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageSeriesList(): " + exception);
        }
        databaseConnector.close();
        object = new ImageSeries[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public ImageSeries getImageSeries(int n, int n2, int n3) {
        ImageSeries imageSeries = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = "SELECT " + this.IG_TABLE_IMAGE_SERIES + ".*, " + this.IG_TABLE_GROUPS + ".Name" + " FROM " + this.IG_TABLE_GROUPS + " INNER JOIN " + this.IG_TABLE_IMAGE_SERIES + " ON " + this.IG_TABLE_GROUPS + ".GroupID = " + this.IG_TABLE_IMAGE_SERIES + ".GroupID" + " WHERE (ImageSeriesID = " + n + ");";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                String string2 = databaseConnector.getFieldByName("SeriesName");
                imageSeries = new ImageSeries(string2, n);
                Vector vector = imageSeries.getSlideVector();
                databaseConnector.close();
                string = "SELECT " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".*, " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".DisplayOrder, " + this.IG_TABLE_LPS + ".LPS, " + this.IG_TABLE_SPS + ".URL, " + this.IG_TABLE_IMAGE_FILES + ".FileName, " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize, " + this.IG_TABLE_PROFILE + ".ProfileId, " + this.IG_TABLE_PROFILE + ".CollectionId" + " FROM " + this.IG_TABLE_PROFILE + " INNER JOIN (((" + this.IG_TABLE_IMAGE_FILES + " INNER JOIN " + this.IG_TABLE_LPS + " ON " + this.IG_TABLE_IMAGE_FILES + ".LPSid = " + this.IG_TABLE_LPS + ".LPSid) INNER JOIN " + this.IG_TABLE_SPS + " ON " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + this.IG_TABLE_SPS + ".ResolutionSize AND " + this.IG_TABLE_IMAGE_FILES + ".Format = " + this.IG_TABLE_SPS + ".Format AND " + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + this.IG_TABLE_SPS + ".MediaType) INNER JOIN " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " ON " + this.IG_TABLE_IMAGE_FILES + ".ImageID = " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".ImageID) ON (" + this.IG_TABLE_PROFILE + ".SPSNum = " + this.IG_TABLE_SPS + ".SPSNum)" + " WHERE (((" + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize)=" + n3 + ") AND ((" + this.IG_TABLE_PROFILE + ".ProfileId)=" + n2 + ") AND (ImageSeriesID=" + n + "))" + " ORDER BY " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ".DisplayOrder;";
                this.debugOut("Image series query is: \n" + string);
                databaseConnector.setQuery(string);
                databaseConnector.runQuery();
                int n4 = -1;
                long l = -1L;
                int n5 = 0;
                String string3 = null;
                int n6 = 0;
                Dimension dimension = null;
                Rectangle rectangle = null;
                Point point = null;
                long l2 = -1L;
                boolean bl = true;
                ImageSeriesSlide imageSeriesSlide = null;
                while (databaseConnector.more()) {
                    n5 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                    if (n5 > n4) {
                        n4 = n5;
                        string3 = this.getMediaUrl(databaseConnector);
                        this.debugOut("Slide " + n5 + ": Thumbnail URL: " + string3);
                        boolean bl2 = databaseConnector.getIntegerFieldByName("Enabled") == 1;
                        n6 = databaseConnector.getIntegerFieldByName("LinkCount");
                        boolean bl3 = databaseConnector.getIntegerFieldByName("Maximized") == 1;
                        boolean bl4 = databaseConnector.getIntegerFieldByName("Minimized") == 1;
                        dimension = new Dimension(databaseConnector.getIntegerFieldByName("TotalWidth"), databaseConnector.getIntegerFieldByName("TotalHeight"));
                        if (dimension.width == -1 && dimension.height == -1) {
                            dimension = null;
                        }
                        rectangle = new Rectangle(databaseConnector.getIntegerFieldByName("XPosition"), databaseConnector.getIntegerFieldByName("YPosition"), databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                        if (rectangle.width == -1 && rectangle.height == -1) {
                            rectangle = null;
                        }
                        point = new Point(databaseConnector.getIntegerFieldByName("ViewLeft"), databaseConnector.getIntegerFieldByName("ViewTop"));
                        if (point.x == -1 && point.y == -1) {
                            point = null;
                        }
                        l2 = -1L;
                        bl = true;
                        int n7 = databaseConnector.getIntegerFieldByName("SlideID");
                        long l3 = databaseConnector.getLongField("ObjectID");
                        long l4 = databaseConnector.getLongField("ImageID");
                        if (l3 == 0L) {
                            l2 = this.getObjectID(l4);
                            if ((long)n7 == l) {
                                bl = false;
                            }
                        } else {
                            l2 = l3;
                        }
                        l = n7;
                        imageSeriesSlide = new ImageSeriesSlide(n, l2, l4, new CollectionKeyWrapper("", "", null), databaseConnector.getIntegerFieldByName("resolution"), rectangle, point, dimension, bl2, n6, null, bl3, bl4);
                        this.debugOut("Setting slide objectID: " + imageSeriesSlide.getObjectID());
                        this.debugOut("Adding: " + imageSeriesSlide);
                        if (bl) {
                            vector.addElement(imageSeriesSlide);
                        }
                    }
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageSeries: " + exception);
        }
        databaseConnector.close();
        return imageSeries;
    }

    public int saveImageSeries(int n, ImageSeries imageSeries) {
        int n2 = 0;
        this.debugOut("saveImageSeries()");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = "SELECT " + this.IG_TABLE_IMAGE_SERIES + ".*" + " FROM " + this.IG_TABLE_IMAGE_SERIES + "" + " WHERE (ImageSeriesID = " + imageSeries.getImageSeriesID() + ");";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " WHERE ImageSeriesID=" + imageSeries.getImageSeriesID() + ";");
                this.debugOut("Deleting from " + this.IG_TABLE_IMAGE_SERIES_SLIDES + ": " + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE ImageSeriesID=" + imageSeries.getImageSeriesID() + ";");
                this.debugOut("Deleting from " + this.IG_TABLE_IMAGE_SERIES + ": " + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
            }
            databaseConnector.close();
            databaseConnector.setQuery("INSERT INTO " + this.IG_TABLE_IMAGE_SERIES + " (SeriesName, GroupID) VALUES (" + this.prepStringForQuery(imageSeries.getSeriesName()) + ", " + n + ");");
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("SELECT " + this.IG_TABLE_IMAGE_SERIES + ".* FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE ((SeriesName = " + this.prepStringForQuery(imageSeries.getSeriesName()) + ") AND (GroupID = " + n + "));");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerFieldByName("ImageSeriesID");
                    databaseConnector.next();
                }
                if (n2 > 0) {
                    Vector vector = imageSeries.getSlideVector();
                    for (int i = 0; i < vector.size(); ++i) {
                        Dimension dimension;
                        Point point;
                        ImageSeriesSlide imageSeriesSlide = (ImageSeriesSlide)vector.elementAt(i);
                        this.debugOut("Saving: " + imageSeriesSlide);
                        int n3 = -1;
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = -1;
                        int n8 = -1;
                        int n9 = -1;
                        int n10 = -1;
                        Rectangle rectangle = imageSeriesSlide.getWindowRectangle();
                        if (rectangle != null) {
                            n3 = rectangle.x;
                            n4 = rectangle.y;
                            n5 = rectangle.width;
                            n6 = rectangle.height;
                        }
                        if ((point = imageSeriesSlide.getViewportPosition()) != null) {
                            n7 = point.x;
                            n8 = point.y;
                        }
                        if ((dimension = imageSeriesSlide.getTotalSize()) != null) {
                            n9 = dimension.width;
                            n10 = dimension.height;
                        }
                        int n11 = imageSeriesSlide.isEnabled() ? 1 : 0;
                        int n12 = imageSeriesSlide.getLinkCount();
                        int n13 = imageSeriesSlide.isMaximized() ? 1 : 0;
                        int n14 = imageSeriesSlide.isMinimized() ? 1 : 0;
                        databaseConnector.close();
                        databaseConnector.setQuery("INSERT INTO " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " (ImageSeriesID, ObjectID, ImageID, DisplayOrder, Resolution, XPosition, YPosition, Width, Height, TotalWidth, TotalHeight, ViewLeft, ViewTop, Enabled, LinkCount, Maximized, Minimized) VALUES (" + n2 + ", " + imageSeriesSlide.getObjectID() + ", " + imageSeriesSlide.getImageID() + ", " + i + ", " + imageSeriesSlide.getResolution() + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ", " + n9 + ", " + n10 + ", " + n7 + ", " + n8 + ", " + n11 + ", " + n12 + ", " + n13 + ", " + n14 + ")");
                        this.debugOut("Insert query: " + databaseConnector.getQuery());
                        databaseConnector.runUpdateQuery();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveImageSeries: " + exception);
        }
        databaseConnector.close();
        return n2;
    }

    public MultipageDocumentSeries getMultipageDocument(ObjectKey objectKey) {
        DatabaseConnector databaseConnector;
        MultipageDocumentSeries multipageDocumentSeries;
        block10: {
            multipageDocumentSeries = null;
            databaseConnector = this.getDatabaseConnector();
            try {
                if (objectKey == null) break block10;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRIMAGETODOCUMENTMAP", null, new String[0]);
                sqlQueryGenerator.addTable("ISDOCUMENTS", null, STRING_WILDCARD);
                sqlQueryGenerator.addJoin("IRIMAGETODOCUMENTMAP", "ISDOCUMENTS", new String[]{"DocumentID"}, 0);
                sqlQueryGenerator.appendToWhere("IRIMAGETODOCUMENTMAP.ImageID = " + objectKey.getImageID());
                sqlQueryGenerator.addOrderBy("ISDOCUMENTS", "DocumentID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get document query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    int n;
                    multipageDocumentSeries = new MultipageDocumentSeries(databaseConnector.getFieldByName("DocumentID"), databaseConnector.getFieldByName("DocumentName"));
                    int n2 = databaseConnector.getIntegerFieldByName("MaxLevelCount");
                    int n3 = databaseConnector.getIntegerFieldByName("LinkVisibilityMode");
                    multipageDocumentSeries.setLinkVisibilityMode(n3);
                    String string = "";
                    for (n = 1; n <= n2; ++n) {
                        string = databaseConnector.getFieldByName("LevelName" + n);
                        if (string == null) continue;
                        multipageDocumentSeries.addLevel(string, n);
                    }
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("ISDOCUMENTLEVELDESCRIPTIONS", null, STRING_WILDCARD);
                    sqlQueryGenerator.appendToWhere("ISDOCUMENTLEVELDESCRIPTIONS.DocumentID = " + multipageDocumentSeries.getDocumentID());
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Get document levels query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        multipageDocumentSeries.addLevelNodeDefinition(databaseConnector.getIntegerFieldByName("LevelID"), databaseConnector.getIntegerFieldByName("LevelValue"), databaseConnector.getFieldByName("LevelTerm"));
                        databaseConnector.next();
                    }
                    sqlQueryGenerator = this.getQueryGenerator();
                    sqlQueryGenerator.addTable("ISDOCUMENTPAGES", null, STRING_WILDCARD);
                    sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, "MediaType");
                    sqlQueryGenerator.addJoin("ISDOCUMENTPAGES", this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
                    sqlQueryGenerator.appendToWhere("ISDOCUMENTPAGES.DocumentID = " + multipageDocumentSeries.getDocumentID());
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + 0);
                    sqlQueryGenerator.addOrderBy("ISDOCUMENTPAGES", "DisplayOrder");
                    for (n = 1; n <= n2; ++n) {
                        sqlQueryGenerator.addOrderBy("ISDOCUMENTPAGES", "Level" + n);
                    }
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Get document pages query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    CollectionKeyWrapper collectionKeyWrapper = new CollectionKeyWrapper(objectKey.getInstitutionID(), objectKey.getCollectionID(), objectKey.getVCID());
                    MultipageDocumentPage multipageDocumentPage = null;
                    int n4 = 0;
                    int n5 = 0;
                    while (databaseConnector.more()) {
                        multipageDocumentPage = new MultipageDocumentPage(multipageDocumentSeries, databaseConnector.getLongField("ObjectID"), databaseConnector.getLongField("ImageID"), databaseConnector.getIntegerFieldByName("MediaType"), collectionKeyWrapper);
                        n5 = 0;
                        try {
                            n5 = databaseConnector.getIntegerFieldByName("LinkCount");
                        }
                        catch (Exception exception) {
                            n5 = 0;
                        }
                        multipageDocumentPage.setLinkCount(n5);
                        for (int i = 1; i <= n2 && (n4 = databaseConnector.getIntegerFieldByName("Level" + i)) > 0; ++i) {
                            multipageDocumentPage.addToPath(i, n4);
                        }
                        multipageDocumentSeries.addPage(multipageDocumentPage);
                        databaseConnector.next();
                    }
                    multipageDocumentSeries.assembleDocumentHierarchy();
                    break block10;
                }
                this.debugOut("Unable to find MPD for imageID: " + objectKey.getImageID());
            }
            catch (Exception exception) {
                this.debugOut("Exception in getMultipageDocument(), exc:\n" + InsightUtilities.convertStackTraceToString(exception));
            }
        }
        databaseConnector.close();
        return multipageDocumentSeries;
    }

    public boolean saveMultipageDocumentSeries(MultipageDocumentSeries multipageDocumentSeries) {
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = multipageDocumentSeries.getDocumentID();
            databaseConnector.setQuery("DELETE FROM ISDOCUMENTPAGES WHERE DocumentID = " + string);
            this.debugOut("Delete previous pages:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            Vector vector = multipageDocumentSeries.getPages();
            this.debugOut("Document " + multipageDocumentSeries.getDocumentName() + " contains " + vector.size() + " page(s).");
            for (int i = 0; i < vector.size(); ++i) {
                MultipageDocumentPage multipageDocumentPage = (MultipageDocumentPage)vector.elementAt(i);
                Vector vector2 = multipageDocumentPage.getPath();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DocumentID", 2, stringBuffer2, string);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayOrder", 2, stringBuffer2, i + 1 + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, multipageDocumentPage.getObjectID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, multipageDocumentPage.getImageID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LinkCount", 2, stringBuffer2, multipageDocumentPage.getLinkCount() + "");
                vector2 = multipageDocumentPage.getPath();
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    MultipageDocumentPathEntry multipageDocumentPathEntry = (MultipageDocumentPathEntry)vector2.elementAt(j);
                    if (multipageDocumentPathEntry.getLevelNumber() <= -1) continue;
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Level" + multipageDocumentPathEntry.getLevelNumber(), 2, stringBuffer2, multipageDocumentPathEntry.getNodeValue() + "");
                }
                databaseConnector.setQuery("INSERT INTO ISDOCUMENTPAGES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Document page " + (i + 1) + " insert query:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
            }
            databaseConnector.setQuery("UPDATE ISDOCUMENTS SET LinkVisibilityMode = " + multipageDocumentSeries.getLinkVisibilityMode() + " WHERE " + "ISDOCUMENTS" + ".DocumentID = " + string);
            this.debugOut("Update link visibility mode query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            bl = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveMultipageDocumentSeries():\n" + InsightUtilities.convertStackTraceToString(exception));
            bl = false;
        }
        databaseConnector.close();
        return bl;
    }

    public MpdSearchResults searchMultipageDocument(String string, String string2) {
        this.debugOut("In searchMultipageDocument(" + string + ", " + string2 + ").");
        MpdSearchResults mpdSearchResults = new MpdSearchResults();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
        }
        sqlQueryGenerator.addTable("ISDOCUMENTPAGES", new String[]{"ObjectID", "ImageID"});
        sqlQueryGenerator.addJoin(this.IG_TABLE_REVERSE_LOOKUP, "ISDOCUMENTPAGES", "ObjectID", 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_REVERSE_LOOKUP, this.IG_TABLE_KEYWORDS, "ValueID", 0);
        sqlQueryGenerator.appendToWhere("ISDOCUMENTPAGES.DocumentID = " + string);
        sqlQueryGenerator.appendToWhere(this.createEquivalenceRelationshipClause(this.IG_TABLE_KEYWORDS + ".ValueText", 1, 2, this.escapeSpecialCharacters(string2), false));
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Mpd search query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        try {
            while (databaseConnector.more()) {
                mpdSearchResults.addResult(databaseConnector.getFieldByName("ObjectID"), databaseConnector.getFieldByName("ImageID"));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in searchMultipageDocument():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return mpdSearchResults;
    }

    protected int getUniqueListCount(String string, int n, int n2, String string2) {
        return this.getUniqueListCount(string, n, n2, string2, null);
    }

    protected int getUniqueListCount(Object object, int n, int n2, String string, Vector vector) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n3 = 0;
        try {
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(this.getUniqueListQuery(object, n, n2, string, vector), "ResultCount", true, this.useDistinctInCount));
            this.debugOut("Unique list count query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n3 = databaseConnector.getIntegerField("ResultCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueListCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n3;
    }

    protected String getUniqueListQuery(String string, int n, int n2, String string2) {
        return this.getUniqueListQuery(string, n, n2, string2, null);
    }

    protected String getUniqueListQuery(Object object, int n, int n2, String string, Vector vector) {
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        if (object instanceof LinkFieldMapping) {
            String string2;
            LinkFieldMapping linkFieldMapping = (LinkFieldMapping)object;
            String string3 = "GroupID = " + n;
            String string4 = this.createLinkCodeClause(vector);
            if (string4.length() > 0) {
                string3 = string3 + " AND " + string4;
            }
            if ((string2 = this.createEquivalenceRelationshipClause(linkFieldMapping.fieldName, 1, n2, this.escapeSpecialCharacters(string), false)).length() > 0) {
                string3 = string3 + " AND " + string2;
            }
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("IRLINKREPOSITORY", new String[]{linkFieldMapping.fieldName});
            sqlQueryGenerator.addJoin("IRLINKREPOSITORY", this.IG_TABLE_GROUP_IMAGE_MAP, "ImageID", 0);
            sqlQueryGenerator.appendToWhere(string3);
        } else {
            String string5 = (String)object;
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable(this.IG_TABLE_OBJECTS, null, string5);
            sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[0]);
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, new String[0]);
            sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECTS, this.IG_TABLE_OBJECT_IMAGE_MAP, new String[]{"ObjectID"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECT_IMAGE_MAP, this.IG_TABLE_GROUP_IMAGE_MAP, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.appendToWhere(this.constructVirtualGroupQuery(this.IG_TABLE_GROUP_IMAGE_MAP, n));
            if (n2 != 0 && string != null) {
                String string6 = this.IG_TABLE_OBJECTS + "." + string5;
                if (this.useLowerCaseCommand) {
                    string6 = "LOWER(" + string6 + ")";
                }
                boolean bl = false;
                String string7 = this.escapeSpecialCharacters(string);
                if (this.useLowerCaseCommand) {
                    if (string7 == null) {
                        string7 = "LOWER('" + string7 + "')";
                    } else if (this.useLowerCaseCommandOnSearchValue) {
                        bl = true;
                    } else {
                        string7 = string7.toLowerCase();
                    }
                }
                sqlQueryGenerator.appendToWhere(this.createEquivalenceRelationshipClause(string6, 1, n2, string7, bl));
            }
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_OBJECTS, string5);
        }
        return sqlQueryGenerator.getQuery();
    }

    public CriterionValue[] getUniqueList(String string, int n) {
        return this.getUniqueList(string, n, 0, null, -1, null);
    }

    public CriterionValue[] getUniqueList(String string, int n, int n2, String string2, int n3, Vector vector) {
        return this.getUniqueList(string, n, n2, string2, n3, false, vector);
    }

    public CriterionValue[] getUniqueList(String string, int n, int n2, String string2, int n3, boolean bl, Vector vector) {
        String string3 = string.replace(' ', '_');
        Vector<StringCriterionValue> vector2 = new Vector<StringCriterionValue>();
        boolean bl2 = false;
        this.debugOut("in getUniqueList() with fieldName (underscored) = " + string3);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            boolean bl3 = bl2 = n3 > -1 && this.useSqlCountForThreshold && this.getUniqueListCount(string, n, n2, string2) > n3;
            if (!bl2) {
                databaseConnector.setQuery(this.getUniqueListQuery(string, n, n2, string2));
                this.debugOut("getUniqueList query is:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    int n4 = 0;
                    StringCriterionValue stringCriterionValue = null;
                    while (databaseConnector.more()) {
                        stringCriterionValue = new StringCriterionValue(databaseConnector.getFieldByName(string3));
                        if (stringCriterionValue != null && !stringCriterionValue.isEmpty() && !vector2.contains(stringCriterionValue)) {
                            vector2.addElement(stringCriterionValue);
                            ++n4;
                        }
                        databaseConnector.next();
                    }
                    this.debugOut(n4 + " elements found.");
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueList(): " + exception);
        }
        databaseConnector.close();
        if (!bl2 && n3 > -1 && vector2.size() > n3) {
            bl2 = true;
        }
        Object[] objectArray = null;
        if (!bl2) {
            objectArray = new CriterionValue[vector2.size()];
            vector2.copyInto(objectArray);
        }
        return objectArray;
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, int n, int n2, String string, int n3) {
        return this.getUniqueList(fieldMapping, n, n2, string, n3, null);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, int n, int n2, String string, int n3, Vector vector) {
        return this.getUniqueList(fieldMapping, n, n2, string, n3, false, vector);
    }

    public CriterionValue[] getUniqueList(FieldMapping fieldMapping, int n, int n2, String string, int n3, boolean bl, Vector vector) {
        Object[] objectArray;
        Vector<CriterionValue> vector2 = new Vector<CriterionValue>();
        Vector vector3 = fieldMapping.getFinalFields();
        Field field = null;
        CriterionValue[] criterionValueArray = null;
        boolean bl2 = false;
        if (fieldMapping instanceof LinkFieldMapping) {
            boolean bl3 = bl2 = n3 > -1 && this.useSqlCountForThreshold && this.getUniqueListCount(fieldMapping, n, n2, string, vector) > n3;
            if (!bl2) {
                objectArray = this.getDatabaseConnector();
                objectArray.setQuery(this.getUniqueListQuery(fieldMapping, n, n2, string, vector));
                this.debugOut("Unique Link List Query:\n" + objectArray.getQuery());
                objectArray.runQuery();
                StringCriterionValue stringCriterionValue = null;
                while (objectArray.more()) {
                    try {
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        String string2 = objectArray.getFieldByName(fieldMapping.fieldName);
                        if (!treeMap.containsKey(string2)) {
                            treeMap.put(string2, string2);
                            stringCriterionValue = new StringCriterionValue(string2);
                            if (stringCriterionValue != null && !stringCriterionValue.isEmpty()) {
                                vector2.addElement(stringCriterionValue);
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("Caught exception while retrieving results in getUniqueList():\n" + InsightUtilities.convertStackTraceToString(exception));
                    }
                    objectArray.next();
                }
                this.debugOut(vector2.size() + " elements found.");
                objectArray.close();
            }
        } else if (vector3 != null) {
            for (int i = 0; i < vector3.size(); ++i) {
                field = (Field)vector3.elementAt(i);
                if (field == null) continue;
                criterionValueArray = this.getUniqueList(field.fieldName, n, n2, string, n3, null);
                if (criterionValueArray == null) {
                    bl2 = true;
                    break;
                }
                for (int j = 0; j < criterionValueArray.length; ++j) {
                    vector2.addElement(criterionValueArray[j]);
                }
            }
        }
        if (!bl2 && n3 > -1 && vector2.size() > n3) {
            bl2 = true;
        }
        objectArray = null;
        if (!bl2) {
            objectArray = new CriterionValue[vector2.size()];
            vector2.copyInto(objectArray);
        }
        return objectArray;
    }

    public CriterionValue[] getArtistList() {
        if (this.groupID != 0) {
            return this.getUniqueList("Artist", this.groupID);
        }
        return null;
    }

    public CriterionValue[] getCategoryList() {
        return this.getUniqueList("Category", this.groupID);
    }

    public String getArtistInformation(String string) {
        this.debugOut("in getArtistInformation() for " + string);
        String string2 = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable(this.IG_TABLE_ARTIST_STORY, null, "Story");
            sqlQueryGenerator.addTable(this.IG_TABLE_OBJECTS, null, new String[0]);
            sqlQueryGenerator.addJoin(this.IG_TABLE_ARTIST_STORY, this.IG_TABLE_OBJECTS, new String[]{"ArtistID"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_OBJECTS + ".Artist = " + this.prepStringForQuery(string));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                string2 = databaseConnector.getFieldByName("Story");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getArtistInformation(): " + exception);
        }
        databaseConnector.close();
        if (string2 == null) {
            return "No information available for " + string + ".";
        }
        return string2;
    }

    public String getArtistInformationWrap(String string) {
        String string2 = this.getArtistInformation(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\f\r");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("<p>" + stringTokenizer.nextToken() + "</p>");
        }
        return stringBuffer.toString();
    }

    public Vector getVocabulary(String string, String string2) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        Vector<String> vector = new Vector<String>();
        try {
            String string3 = "SELECT VocabValue FROM " + this.IG_TABLE_VOCABULARY + " WHERE ((FieldName = " + this.prepStringForQuery(string2) + ") AND (TableName = " + this.prepStringForQuery(string) + "))" + " ORDER BY VocabValue";
            databaseConnector.setQuery(string3);
            this.debugOut(this.IG_TABLE_VOCABULARY + " query is\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                vector.addElement(databaseConnector.getFieldByName("VocabValue"));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getVocabulary(): " + exception);
        }
        databaseConnector.close();
        return vector;
    }

    public void addVocabulary(String string, String string2, String string3) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("INSERT INTO " + this.IG_TABLE_VOCABULARY + " (TableName, FieldName, VocabValue)" + " VALUES (" + this.prepStringForQuery(string) + ", " + this.prepStringForQuery(string2) + ", " + this.prepStringForQuery(string3) + ");");
            this.debugOut("Adding vocabulary with the following query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in addVocabulary(): " + exception);
        }
        databaseConnector.close();
    }

    public void removeVocabulary(String string, String string2, String string3) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("DELETE FROM " + this.IG_TABLE_VOCABULARY + " WHERE ((FieldName = " + this.prepStringForQuery(string2) + ") AND (TableName = " + this.prepStringForQuery(string) + ") AND (VocabValue = " + this.prepStringForQuery(string3) + "));");
            this.debugOut("Removing vocabulary with the following query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeVocabulary(): " + exception);
        }
        databaseConnector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getUniqueCollectionID(CollectionKey collectionKey) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        Integer n = null;
        try {
            String string = collectionKey.getCollectionID();
            String string2 = collectionKey.getInstitutionID();
            String string3 = collectionKey.getVCID();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "UniqueCollectionID");
            sqlQueryGenerator.appendToWhere("CollectionID = " + this.prepStringForQuery(string) + " AND InstitutionID = " + this.prepStringForQuery(string2) + " AND VCID = " + this.prepStringForQuery(string3));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                n = new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID"));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUniqueCollectionID():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n;
    }

    public Locale getCollectionLanguage() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        Locale locale = null;
        try {
            this.debugOut("in getCollectionLanguage().");
            sqlQueryGenerator.addTable(this.IG_TABLE_COLLECTION_INFO, null, new String[]{"LanguageCode", "CountryCode"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get collection language query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                this.collectionLocale = locale = new Locale(databaseConnector.getFieldByName("LanguageCode"), databaseConnector.getFieldByName("CountryCode"));
            } else {
                String string = System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US");
                this.collectionLocale = locale = new Locale(System.getProperty("user.language", "en"), string);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionLanguage(): " + exception);
            String string = System.getProperty("user.region") != null ? System.getProperty("user.region") : System.getProperty("user.country", "US");
            this.collectionLocale = locale = new Locale(System.getProperty("user.language", "en"), string);
        }
        this.debugOut("Collection Server Locale is:  " + locale);
        databaseConnector.close();
        return locale;
    }

    public String getStandardDescription(String string) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        String string2 = new String();
        try {
            this.debugOut("in getStandardDescription().");
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardDescriptionURL");
            sqlQueryGenerator.appendToWhere("StandardName = " + this.prepStringForQuery(string));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("getStandardDescription query is:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                string2 = databaseConnector.getFieldByName("StandardDescriptionURL");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getStandardDescription(): " + exception);
            string2 = null;
        }
        databaseConnector.close();
        return string2;
    }

    public List getVirtualCollectionList(Integer n) {
        Vector<GroupInformation> vector = new Vector<GroupInformation>(0);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, new String[]{"GroupID", "Name", "VCID"});
            sqlQueryGenerator.appendToWhere("GroupType = 1");
            if (n != null) {
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            }
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_GROUPS, "Name");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    String string = databaseConnector.getStringField("Name");
                    String string2 = databaseConnector.getStringField("VCID");
                    if (string != null && !string2.equals("NA")) {
                        GroupInformation groupInformation = new GroupInformation();
                        groupInformation.setGroupName(string);
                        groupInformation.setGroupID(databaseConnector.getIntegerField("GroupID"));
                        groupInformation.setVcID(string2);
                        vector.add(groupInformation);
                    }
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getAbstractGroupList():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public List getGroupList(Integer n, String string) {
        return this.getAbstractGroupList(2, string, n);
    }

    public List getCollectionList() {
        return this.getAbstractGroupList(1, "NA", null);
    }

    protected List getAbstractGroupList(int n, String string, Integer n2) {
        Vector<GroupInformation> vector = new Vector<GroupInformation>(0);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, new String[]{"GroupID", "Name"});
            sqlQueryGenerator.appendToWhere("GroupType = " + n);
            sqlQueryGenerator.appendToWhere("VCID = " + this.prepStringForQuery(string));
            if (n2 != null) {
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n2);
            }
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_GROUPS, "Name");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    String string2 = databaseConnector.getStringField("Name");
                    if (string2 != null) {
                        GroupInformation groupInformation = new GroupInformation();
                        groupInformation.setGroupName(string2);
                        groupInformation.setGroupID(databaseConnector.getIntegerField("GroupID"));
                        vector.add(groupInformation);
                    }
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getAbstractGroupList():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public int newGroup(Integer n, String string) {
        this.debugOut("creating new group");
        if (this.imageGroupOpen == 0) {
            int n2 = this.getNextGroupId();
            this.debugOut("new group ID = " + n2);
            if (n2 > 0) {
                String string2 = new SimpleDate().get();
                this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUPS + " (GroupID, Name, GroupType, VCID, UniqueCollectionID, CreatedTimestamp, LastModifiedTimestamp) VALUES (" + n2 + ", 'temp3599 new temporary " + n2 + "', " + 3 + ", " + this.prepStringForQuery(string) + ", " + n + ", '" + string2 + "', '" + string2 + "')");
                this.readOnly = false;
                this.groupType = 3;
                this.imageGroupOpen = 1;
                this.groupID = n2;
                return -1;
            }
            return -4;
        }
        return -6;
    }

    protected int newGroup(Integer n, int n2, String string) {
        this.debugOut("creating new group from existing group " + n2 + ", VCID: " + string);
        this.baseGroupID = n2;
        if (this.imageGroupOpen == 0) {
            int n3 = this.getNextGroupId();
            this.debugOut("new group ID = " + n3);
            if (n3 > 0) {
                String string2 = new SimpleDate().get();
                this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUPS + " (GroupID, Name, GroupType, Base, VCID, UniqueCollectionID, CreatedTimestamp, LastModifiedTimestamp) VALUES (" + n3 + ", 'temp3599 open temporary " + n3 + "', " + 3 + ", " + this.prepStringForQuery(this.baseGroupID + "") + ", " + this.prepStringForQuery(string) + ", " + n + ", '" + string2 + "', '" + string2 + "')");
                this.readOnly = false;
                this.groupType = 3;
                this.imageGroupOpen = 1;
                this.groupID = n3;
                return -1;
            }
            return -4;
        }
        return -6;
    }

    public boolean addImage(int n, long l) {
        return this.addImage(n, l, false, false, 0);
    }

    public boolean addImage(int n, long l, boolean bl, boolean bl2, int n2) {
        boolean bl3 = false;
        this.debugOut("Add image to specific group: " + l + " to group " + n + ", hasMultiview: " + bl);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT ImageID FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE ((GroupID = " + n + ") AND (ImageID = " + l + ") AND (MviSeries = " + (bl ? 1 : 0) + ") AND (MpdSeries = " + (bl2 ? 1 : 0) + "))");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                bl3 = false;
            } else {
                this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + " (GroupID, ImageID, MviSeries, MpdSeries, ObjectID) VALUES (" + n + ", " + l + ", " + (bl ? 1 : 0) + ", " + (bl2 ? 1 : 0) + ", 0)");
                bl3 = true;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addImage(): " + exception);
            bl3 = false;
        }
        databaseConnector.close();
        return bl3;
    }

    public boolean reorderImagesInGroup(int n, boolean bl, Vector vector) {
        boolean bl2 = false;
        this.debugOut("reordering images in group: " + n + " absoluteOrdering: " + bl + " images: " + vector.size());
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (bl) {
                Vector<String> vector2 = new Vector<String>(vector.size());
                for (int i = 0; i < vector.size(); ++i) {
                    Long[] longArray = (Long[])vector.elementAt(i);
                    Long l = longArray[0];
                    Long l2 = longArray[1];
                    String string = "UPDATE " + this.IG_TABLE_GROUP_IMAGE_MAP + " SET AbsoluteOrder = " + l2 + " WHERE ((GroupID = " + n + ") AND (ImageID = " + l + "))";
                    vector2.add(string);
                }
                databaseConnector.executeBatch(vector2, true);
            } else {
                this.quickUpdate("UPDATE " + this.IG_TABLE_GROUP_IMAGE_MAP + " SET AbsoluteOrder = 0 WHERE GroupID = " + n);
            }
            bl2 = true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in reorderImagesInGroup(): " + exception);
            bl2 = false;
        }
        databaseConnector.close();
        return bl2;
    }

    public void addBatchImages(Vector vector) {
        this.debugOut("in addBatchImages().");
        if (vector == null || vector.size() < 1) {
            this.debugOut("No images to insert.");
        } else {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                this.debugOut(vector.size() + " images to add.");
                long l = System.currentTimeMillis();
                Vector<String> vector2 = new Vector<String>();
                Vector vector3 = InsightBackendConnector.groupImagesToProcess(vector);
                Vector vector4 = null;
                ImageToProcess imageToProcess = null;
                for (int i = 0; vector3 != null && i < vector3.size(); ++i) {
                    int n;
                    vector4 = (Vector)vector3.elementAt(i);
                    if (vector4 == null || vector4.size() <= 0) continue;
                    imageToProcess = (ImageToProcess)vector4.firstElement();
                    String string = "SELECT * FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE (GroupID = " + imageToProcess.groupID + ")";
                    this.debugOut("Select current group contents query:\n" + string);
                    databaseConnector.setQuery(string);
                    databaseConnector.runQuery();
                    while (databaseConnector.more() && vector4.size() > 0) {
                        long l2 = databaseConnector.getLongField("ImageID");
                        boolean bl = databaseConnector.getBooleanField("MviSeries");
                        n = 0;
                        while (n < vector4.size()) {
                            imageToProcess = (ImageToProcess)vector4.elementAt(n);
                            if (imageToProcess == null || imageToProcess.imageID == l2 && imageToProcess.hasMultiview == bl) {
                                vector4.removeElementAt(n);
                                if (imageToProcess == null) continue;
                                imageToProcess.success = false;
                                continue;
                            }
                            ++n;
                        }
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    for (n = 0; vector4 != null && n < vector4.size(); ++n) {
                        imageToProcess = (ImageToProcess)vector4.elementAt(n);
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, imageToProcess.groupID);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, imageToProcess.imageID);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MviSeries", 2, stringBuffer2, imageToProcess.hasMultiview ? 1 : 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MpdSeries", 2, stringBuffer2, imageToProcess.hasMultipage ? 1 : 0);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "AbsoluteOrder", 2, stringBuffer2, imageToProcess.absoluteOrder);
                        sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, 0);
                        String string2 = "INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")";
                        if (!vector2.contains(string2)) {
                            vector2.addElement(string2);
                        }
                        imageToProcess.success = true;
                    }
                }
                this.debugOut("Time to assemble batch: " + (System.currentTimeMillis() - l));
                this.debugOut("Batch size: " + (vector2 != null ? vector2.size() : 0));
                l = System.currentTimeMillis();
                if (vector2 != null && vector2.size() > 0) {
                    databaseConnector.executeBatch(vector2, true);
                } else {
                    this.debugOut("No images to insert.");
                }
                this.debugOut("Time to execute batch: " + (System.currentTimeMillis() - l));
            }
            catch (Exception exception) {
                this.debugOut("Exception in addBatchImages():\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error in addBatchImages():\n" + InsightUtilities.getStackTrace(error));
            }
            databaseConnector.close();
        }
    }

    public int removeImage(long l) {
        this.debugOut("remove image " + l);
        if (this.imageGroupOpen == 1 && !this.readOnly) {
            this.removeImage(this.groupID, l);
            return -1;
        }
        return -2;
    }

    public int removeImage(int n, long l) {
        this.debugOut("remove from specific group: " + l + " to group " + n);
        this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE ((GroupID = " + n + ") AND (ImageID = " + l + ") AND (MviSeries = 0))");
        return -1;
    }

    protected void synchronizeImageSeries(int n, int n2) {
    }

    public GroupInformation getGroupInformation(Integer n, String string, String string2, int n2, int n3) {
        GroupInformation groupInformation = null;
        int n4 = this.getGroupID(n, string, string2);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (n4 >= 1) {
                groupInformation = new GroupInformation();
                groupInformation.setGroupID(n4);
                groupInformation.setGroupName(string);
                groupInformation.setContainsAudio(this.groupContainsMediaType(2, n4, n2, n3));
                groupInformation.setContainsVideo(this.groupContainsMediaType(3, n4, n2, n3));
                groupInformation.setContainsQtvr(this.groupContainsMediaType(4, n4, n2, n3));
                groupInformation.setContainsMisc(this.groupContainsMediaType(5, n4, n2, n3));
                groupInformation.setContainsMultiviews(this.groupHasMultiviewImages(n4, n2, n3));
                groupInformation.setContainsMultipages(this.groupHasMultipageDocuments(n4, n2, n3));
                groupInformation.setAbsoluteOrdering(this.groupIsAbsoluteOrdered(n4, n2, n3));
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getGroupInformation():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return groupInformation;
    }

    public boolean doesGroupExist(Integer n, String string, String string2) {
        return this.getGroupID(n, string, string2) > 0;
    }

    public int getGroupID(Integer n, String string, String string2) {
        this.debugOut("Retreiving group ID for " + string + ", VCID: " + string2);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, "GroupID");
            sqlQueryGenerator.appendToWhere("(Name = " + this.prepStringForQuery(string) + ") AND (VCID = " + this.prepStringForQuery(string2) + ") AND (UniqueCollectionID = " + n + ") AND (NOT (GroupType = " + 3 + "))");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get group ID query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerFieldByName("GroupID");
                databaseConnector.close();
                return n2;
            }
            this.debugOut("No records match.");
            databaseConnector.close();
            return -4;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getGroupID():\n" + InsightUtilities.getStackTrace(exception));
            databaseConnector.close();
            return -3;
        }
    }

    public int getType(int n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = "SELECT GroupType FROM " + this.IG_TABLE_GROUPS + " WHERE (GroupID = " + n + ")";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerFieldByName("GroupType");
                databaseConnector.close();
                return n2;
            }
            databaseConnector.close();
            return -4;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getType(): " + exception);
            databaseConnector.close();
            return -3;
        }
    }

    public Vector getImagesInGroup(int n, int n2, int n3, CollectionKey collectionKey) {
        return this.getImagesInGroup(n, n2, n3, collectionKey, new Vector());
    }

    public Vector getImagesInGroup(int n, int n2, int n3, CollectionKey collectionKey, Vector vector) {
        this.debugOut("in getImagesInGroup.");
        Vector<ImageInGroup> vector2 = new Vector<ImageInGroup>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            boolean bl;
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, new String[]{"GroupID", "ImageID", "MpdSeries", "AbsoluteOrder"});
            sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[]{"ObjectID"});
            sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"ResolutionSize", "MediaType", "Format", "Width", "Height", "Filename"});
            sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_OBJECT_IMAGE_MAP, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.appendToWhere(this.constructVirtualGroupQuery(this.IG_TABLE_GROUP_IMAGE_MAP, n));
            boolean bl2 = bl = n2 >= 0 || n3 >= 0;
            if (bl) {
                sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
                sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
                sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_IMAGE_FILES, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_LPS, this.IG_TABLE_IMAGE_FILES, new String[]{"LPSid"}, 0);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".SPSNum = (" + "SELECT SPSNum FROM " + this.IG_TABLE_PROFILE + " WHERE " + this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_IMAGE_FILES + ".Format != 'SOURCE'" + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3 + ")");
            }
            boolean bl3 = this.groupIsAbsoluteOrdered(n, n2, n3);
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_OBJECT_IMAGE_MAP, "ObjectID");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_GROUP_IMAGE_MAP, "ImageID");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_GROUP_IMAGE_MAP, "MpdSeries");
            sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ResolutionSize");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Query i:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            int n4 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            int n5 = -1;
            ImageInGroup imageInGroup = null;
            long l5 = 0L;
            long l6 = 0L;
            boolean bl6 = false;
            int n6 = -1;
            Dimension dimension = null;
            Object var35_26 = null;
            int n7 = 1;
            String string = null;
            while (databaseConnector.more()) {
                try {
                    l2 = databaseConnector.getLongField("ObjectID");
                }
                catch (Exception exception) {
                    l2 = l5;
                }
                l4 = Long.parseLong(databaseConnector.getFieldByName("ImageID"));
                n5 = databaseConnector.getIntegerFieldByName("ResolutionSize");
                try {
                    bl5 = databaseConnector.getBooleanField("MpdSeries");
                }
                catch (Exception exception) {
                    bl5 = false;
                }
                try {
                    n4 = databaseConnector.getIntegerField("AbsoluteOrder");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l6 != l4 || l5 != l2 || bl6 != bl5 || n6 != n5) {
                    l5 = l2;
                    l6 = l4;
                    bl6 = bl5;
                    n6 = n5;
                    int n8 = 0;
                    int n9 = databaseConnector.getIntegerFieldByName("Width");
                    int n10 = databaseConnector.getIntegerFieldByName("Height");
                    dimension = new Dimension(n9, n10);
                    n8 = ImageFile.getFormatTypeToInt(databaseConnector.getFieldByName("Format"));
                    n7 = 1;
                    try {
                        n7 = databaseConnector.getIntegerFieldByName("MediaType");
                    }
                    catch (Exception exception) {
                        n7 = 1;
                    }
                    if (n7 < 1) {
                        n7 = 1;
                    }
                    string = this.getMediaUrl(databaseConnector);
                    ImageFile imageFile = new ImageFile(dimension, n5, string, n8, n7);
                    if (l3 == 0L || l2 != l || l4 != l3 || bl5 != bl4) {
                        if (imageInGroup != null) {
                            vector2.addElement(imageInGroup);
                        }
                        imageInGroup = new ImageInGroup(l2, l4, bl5, collectionKey, new Vector());
                        imageInGroup.setAbsoluteOrder(n4);
                        l = l2;
                        l3 = l4;
                        bl4 = bl5;
                        this.debugOut("Created IIG: " + imageInGroup);
                    }
                    imageInGroup.imageFiles.addElement(imageFile);
                }
                databaseConnector.next();
            }
            this.debugOut("Outside of while loop.");
            if (imageInGroup != null) {
                vector2.addElement(imageInGroup);
            }
            if (vector2.size() > 0 && bl3) {
                Collections.sort(vector2, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImagesInGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector2;
    }

    public Vector getImageFiles(Vector vector, int n, int n2, int n3) {
        this.debugOut("in getImageFiles().");
        Vector<ImageFile> vector2 = new Vector<ImageFile>();
        if (vector != null && vector.size() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "MediaType", "ResolutionSize", "ImageID", "Filename", "Width", "Height"});
                sqlQueryGenerator.appendToWhere("(" + this.IG_TABLE_IMAGE_FILES + ".ImageID IN (" + InsightUtilities.getListString(vector) + "))" + " AND (" + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + n + ")");
                boolean bl2 = bl = n2 >= 0 || n3 >= 0;
                if (bl) {
                    sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
                    sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
                    sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
                    sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                    sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3);
                }
                sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ImageID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get image files query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    ImageFile imageFile = this.getImageFile(databaseConnector);
                    if (imageFile != null) {
                        vector2.addElement(imageFile);
                    }
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getImageFiles():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return vector2;
    }

    public Vector getImageFiles(Vector vector, int n, int n2, boolean bl) {
        this.debugOut("in getImageFiles().");
        Vector vector2 = new Vector();
        if (vector != null && vector.size() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl2;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "MediaType", "ResolutionSize", "ImageID", "Filename", "Width", "Height"});
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID IN (" + InsightUtilities.getListString(vector) + ")");
                boolean bl3 = bl2 = n >= 0 || n2 >= 0;
                if (bl2) {
                    sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
                    sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
                    sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
                    sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                    sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n2);
                    if (!bl) {
                        sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".Format <> " + this.prepStringForQuery("JP2"));
                    }
                }
                sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ImageID");
                sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ResolutionSize");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get image files query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    ImageFile imageFile = this.getImageFile(databaseConnector);
                    if (imageFile != null) {
                        Vector<ImageFile> vector3 = null;
                        for (int i = 0; !(i >= vector2.size() || InsightUtilities.isNonEmpty(vector3 = (Vector<ImageFile>)vector2.get(i)) && ((ImageFile)vector3.get(0)).getImageID() == imageFile.getImageID()); ++i) {
                            vector3 = null;
                        }
                        if (vector3 == null) {
                            vector3 = new Vector<ImageFile>(0);
                            vector2.add(vector3);
                        }
                        vector3.add(imageFile);
                    }
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getImageFiles():\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return vector2;
    }

    public Vector getImageFiles(long l, int n, int n2, boolean bl) {
        DatabaseConnector databaseConnector;
        Vector<ImageFile> vector;
        block7: {
            this.debugOut("in getImageFiles().");
            vector = new Vector<ImageFile>();
            databaseConnector = this.getDatabaseConnector();
            try {
                boolean bl2;
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "MediaType", "ResolutionSize", "ImageID", "Filename", "Width", "Height"});
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID = " + l);
                boolean bl3 = bl2 = n >= 0 || n2 >= 0;
                if (bl2) {
                    sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
                    sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
                    sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
                    sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                    sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n);
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".CollectionId = " + n2);
                    sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".Format != 'SOURCE'");
                    if (!bl) {
                        sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".Format <> " + this.prepStringForQuery("JP2"));
                    }
                }
                sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ResolutionSize");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get image files query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block7;
                for (int i = 0; i < 9; ++i) {
                    ImageFile imageFile = this.getImageFile(databaseConnector);
                    if (imageFile != null) {
                        vector.addElement(imageFile);
                    }
                    databaseConnector.next();
                    if (databaseConnector.more()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getImageFiles():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return vector;
    }

    public ImageFile getImageFile(long l, int n, int n2, int n3) {
        this.debugOut("in getImageFile().");
        ImageFile imageFile = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            boolean bl;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "MediaType", "ResolutionSize", "ImageID", "Filename", "Width", "Height"});
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID = " + l + " AND " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + n);
            boolean bl2 = bl = n2 >= 0 || n3 >= 0;
            if (bl) {
                sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
                sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
                sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n2);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".CollectionId = " + n3);
            }
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get image file query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                imageFile = this.getImageFile(databaseConnector);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageFile():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return imageFile;
    }

    public ImageFile getImageFile(DatabaseConnector databaseConnector) {
        ImageFile imageFile;
        block4: {
            imageFile = null;
            try {
                if (databaseConnector == null || !databaseConnector.more()) break block4;
                Dimension dimension = new Dimension(databaseConnector.getIntegerField("Width"), databaseConnector.getIntegerField("Height"));
                int n = databaseConnector.getIntegerField("ResolutionSize");
                String string = this.getMediaUrl(databaseConnector);
                int n2 = ImageFile.getFormatTypeToInt(databaseConnector.getFieldByName("Format"));
                int n3 = 1;
                try {
                    n3 = databaseConnector.getIntegerField("MediaType");
                }
                catch (Exception exception) {
                    n3 = 1;
                }
                imageFile = new ImageFile(dimension, n, string, n2, n3);
                imageFile.imageID = databaseConnector.getLongField("ImageID");
            }
            catch (Exception exception) {
                this.debugOut("Exception in getImageFile():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        return imageFile;
    }

    public String getMediaUrl(DatabaseConnector databaseConnector) {
        try {
            if (databaseConnector != null) {
                String[] stringArray = databaseConnector.getFieldNames();
                boolean bl = false;
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equalsIgnoreCase("URL")) continue;
                    bl = true;
                    break;
                }
                String string = bl ? databaseConnector.getFieldByName("URL") + "/" + databaseConnector.getFieldByName("LPS") + "/" + databaseConnector.getFieldByName("FileName") : databaseConnector.getFieldByName("FileName");
                return string;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaUrl():\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            this.debugOut("Error in getMediaUrl():\n" + InsightUtilities.getStackTrace(error));
        }
        return null;
    }

    public ImageGroupFile getImageGroupFile(int n, int n2, int n3, CollectionKey collectionKey, int n4) {
        return this.getImageGroupFile(n, n2, n3, collectionKey, n4, true);
    }

    public ImageGroupFile getImageGroupFile(int n, int n2, int n3, CollectionKey collectionKey, int n4, boolean bl) {
        Vector vector = new Vector(0);
        if (bl) {
            vector = this.getImagesInGroup(n, n2, n3, collectionKey);
        }
        ImageGroupFile imageGroupFile = new ImageGroupFile("(unspecified)", vector);
        return imageGroupFile;
    }

    public GroupInformation openGroup(Integer n, Vector vector, String string) {
        GroupInformation groupInformation = null;
        if (vector != null && this.newGroup(n, string) == -1) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                groupInformation = new GroupInformation();
                groupInformation.setGroupID(this.groupID);
                this.debugOut("Adding " + vector.size() + " images into temporary group.");
                for (int i = 0; i < vector.size(); ++i) {
                    ImageInGroup imageInGroup = (ImageInGroup)vector.elementAt(i);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, this.groupID);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, imageInGroup.getImageID());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MviSeries", 2, stringBuffer2, 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MpdSeries", 2, stringBuffer2, imageInGroup.isMultipage() ? 1 : 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, 0);
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "AbsoluteOrder", 2, stringBuffer2, imageInGroup.getAbsoluteOrder());
                    databaseConnector.setQuery("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + " (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in openGroup():\n" + InsightUtilities.getStackTrace(exception));
                groupInformation = null;
            }
            catch (Error error) {
                this.debugOut("Error in openGroup():\n" + InsightUtilities.getStackTrace(error));
                groupInformation = null;
            }
            databaseConnector.close();
        }
        return groupInformation;
    }

    public int openClientSideGroup(Integer n, String string, String string2, Vector vector) {
        if (this.newGroup(n, string2) == -1) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                this.debugOut("Adding " + vector.size() + " images into temporary group.");
                for (int i = 0; i < vector.size(); ++i) {
                    ImageInGroup imageInGroup = (ImageInGroup)vector.elementAt(i);
                    databaseConnector.setQuery("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + " (GroupID, ImageID, ObjectID) VALUES (" + this.groupID + ", " + imageInGroup.getImageID() + ", 0);");
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in openClientSideGroup(): " + exception);
                this.groupID = -3;
            }
            databaseConnector.close();
            return this.groupID;
        }
        return -4;
    }

    public void setMviSeries(int n, long l, boolean bl) {
        if (bl) {
            this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + "(GroupID, ImageID, MviSeries, ObjectID, AbsoluteOrder) VALUES(" + n + ", " + l + ", 1, 0, 0)");
        } else {
            this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE (GroupID = " + n + " AND ImageID = " + l + " AND MviSeries = 1)");
        }
    }

    public boolean groupHasMultiviewImages(int n, int n2, int n3) {
        this.debugOut("in groupHasMultiviewImages(" + n + ", " + n2 + ", " + n3 + ")");
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            boolean bl2;
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, STRING_WILDCARD);
            sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.appendToWhere(this.constructVirtualGroupQuery(this.IG_TABLE_GROUP_IMAGE_MAP, n) + " AND " + this.IG_TABLE_GROUP_IMAGE_MAP + ".MviSeries = 1");
            boolean bl3 = bl2 = n2 >= 0 || n3 >= 0;
            if (bl2) {
                sqlQueryGenerator.addJoin(this.IG_TABLE_LPS, this.IG_TABLE_IMAGE_FILES, new String[]{"LPSid"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_IMAGE_FILES, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".SPSNum = (" + "SELECT SPSNum FROM " + this.IG_TABLE_PROFILE + " WHERE " + this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3 + ")");
            }
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Query is:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            bl = databaseConnector.more();
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupHasMultiviewImages():\n" + InsightUtilities.getStackTrace(exception));
            bl = false;
        }
        databaseConnector.close();
        return bl;
    }

    public boolean groupHasMultipageDocuments(int n, int n2, int n3) {
        this.debugOut("in groupHasMultipageDocuments(" + n + ", " + n2 + ", " + n3 + ")");
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            boolean bl2;
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, STRING_WILDCARD);
            sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[0]);
            sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.appendToWhere(this.constructVirtualGroupQuery(this.IG_TABLE_GROUP_IMAGE_MAP, n) + " AND " + this.IG_TABLE_GROUP_IMAGE_MAP + ".MpdSeries = 1");
            boolean bl3 = bl2 = n2 >= 0 || n3 >= 0;
            if (bl2) {
                sqlQueryGenerator.addJoin(this.IG_TABLE_LPS, this.IG_TABLE_IMAGE_FILES, new String[]{"LPSid"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_IMAGE_FILES, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".SPSNum = (" + "SELECT SPSNum FROM " + this.IG_TABLE_PROFILE + " WHERE " + this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3 + ")");
            }
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("MPD query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            bl = databaseConnector.more();
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupHasMultipageDocuments(): " + exception);
            bl = false;
        }
        databaseConnector.close();
        return bl;
    }

    public boolean groupIsAbsoluteOrdered(int n, int n2, int n3) {
        this.debugOut("in groupIsAbsoluteOrdered(" + n + ", " + n2 + ", " + n3 + ")");
        int n4 = 0;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, STRING_WILDCARD);
            sqlQueryGenerator.appendToWhere("GroupID = " + n);
            sqlQueryGenerator.appendToWhere("AbsoluteOrder > 0");
            databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(sqlQueryGenerator.getQuery(), "AbsCount"));
            this.debugOut("groupIsAbsoluteOrdered query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuerySafe();
            if (databaseConnector.more()) {
                n4 = databaseConnector.getIntegerField("AbsCount");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupIsAbsoluteOrdered():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n4 > 0;
    }

    public boolean groupContainsMediaType(int n, int n2, int n3, int n4) {
        this.debugOut("in groupContainsMediaType(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        boolean bl = false;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        try {
            boolean bl2;
            sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, STRING_WILDCARD);
            sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[0]);
            sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
            sqlQueryGenerator.appendToWhere(this.constructVirtualGroupQuery(this.IG_TABLE_GROUP_IMAGE_MAP, n2) + " AND " + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + n);
            boolean bl3 = bl2 = n3 >= 0 || n4 >= 0;
            if (bl2) {
                sqlQueryGenerator.addJoin(this.IG_TABLE_LPS, this.IG_TABLE_IMAGE_FILES, new String[]{"LPSid"}, 0);
                sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_IMAGE_FILES, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
                sqlQueryGenerator.appendToWhere(this.IG_TABLE_SPS + ".SPSNum = (" + "SELECT SPSNum FROM " + this.IG_TABLE_PROFILE + " WHERE " + this.IG_TABLE_PROFILE + ".ProfileId = " + n3 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n4 + ")");
            }
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Group contains media type query is:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            bl = databaseConnector.more();
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupContainsMediaType():\n" + InsightUtilities.getStackTrace(exception));
            bl = false;
        }
        databaseConnector.close();
        return bl;
    }

    protected void removeAllImageSeries(int n) {
        this.debugOut("Removing any ImageSeries for group ID " + n);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (n >= 1) {
                databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE GroupID = " + n);
                databaseConnector.runQuery();
                int n2 = 0;
                while (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerFieldByName("ImageSeriesID");
                    this.removeImageSeries(n2);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeAllImageSeries: " + exception);
        }
        databaseConnector.close();
    }

    public void removeImageSeries(int n) {
        this.quickUpdate("DELETE FROM " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " WHERE ImageSeriesID = " + n);
        this.quickUpdate("DELETE FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE ImageSeriesID = " + n);
    }

    protected void copyAllImageSeries(int n, int n2) {
        this.copyAllImageSeries(n, n2, null);
    }

    protected void copyAllImageSeries(int n, int n2, GroupInformation groupInformation) {
        this.debugOut("Copying any ImageSeries from " + n + " to " + n2);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (n >= 1 && n2 >= 1) {
                databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE GroupID = " + n);
                databaseConnector.runQuery();
                String string = null;
                while (databaseConnector.more()) {
                    int n3 = databaseConnector.getIntegerFieldByName("ImageSeriesID");
                    string = databaseConnector.getFieldByName("SeriesName");
                    int n4 = this.copyImageSeries(n3, string, n2);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in copyAllImageSeries: " + exception);
        }
        databaseConnector.close();
    }

    protected int copyImageSeries(int n, String string, int n2) {
        this.debugOut("Copying ImageSeries " + n + " to group " + n2);
        int n3 = -4;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("INSERT INTO " + this.IG_TABLE_IMAGE_SERIES + " (SeriesName, GroupID) VALUES (" + this.prepStringForQuery(string) + ", " + n2 + ");");
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_IMAGE_SERIES + " WHERE (SeriesName = " + this.prepStringForQuery(string) + " AND GroupID = " + n2 + ");");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n3 = databaseConnector.getIntegerFieldByName("ImageSeriesID");
                databaseConnector.close();
                databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " WHERE (ImageSeriesID = " + n + ");");
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    long l = databaseConnector.getLongField("ObjectID");
                    long l2 = databaseConnector.getLongField("ImageID");
                    int n4 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                    int n5 = databaseConnector.getIntegerFieldByName("Resolution");
                    int n6 = databaseConnector.getIntegerFieldByName("XPosition");
                    int n7 = databaseConnector.getIntegerFieldByName("YPosition");
                    int n8 = databaseConnector.getIntegerFieldByName("Width");
                    int n9 = databaseConnector.getIntegerFieldByName("Height");
                    int n10 = databaseConnector.getIntegerFieldByName("ViewTop");
                    int n11 = databaseConnector.getIntegerFieldByName("ViewLeft");
                    int n12 = databaseConnector.getIntegerFieldByName("Enabled");
                    int n13 = databaseConnector.getIntegerFieldByName("LinkCount");
                    int n14 = databaseConnector.getIntegerFieldByName("TotalWidth");
                    int n15 = databaseConnector.getIntegerFieldByName("TotalHeight");
                    int n16 = databaseConnector.getIntegerFieldByName("Maximized");
                    int n17 = databaseConnector.getIntegerFieldByName("Minimized");
                    String string2 = "INSERT INTO " + this.IG_TABLE_IMAGE_SERIES_SLIDES + " (ImageSeriesID, ObjectID, ImageID," + " DisplayOrder, Resolution, Maximized, Minimized, XPosition, YPosition, Width, Height," + " ViewTop, ViewLeft, Enabled, LinkCount, TotalWidth, TotalHeight)" + " VALUES (" + n3 + ", " + l + ", " + l2 + ", " + n4 + ", " + n5 + ", " + n16 + ", " + n17 + ", " + n6 + ", " + n7 + ", " + n8 + ", " + n9 + ", " + n10 + ", " + n11 + ", " + n12 + ", " + n13 + ", " + n14 + ", " + n15 + ")";
                    this.quickUpdate(string2);
                    databaseConnector.next();
                }
            } else {
                this.debugOut("Could not create copy of ImageSeries data.");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in copyImageSeries: " + exception);
        }
        databaseConnector.close();
        return n3;
    }

    public GroupInformation openGroupWithInfo(Integer n, String string, String string2) {
        return this.openGroupWithInfo(n, string, string2, true);
    }

    public int openGroup(Integer n, String string, String string2) {
        return this.openGroup(n, string, string2, true);
    }

    public int openGroup(Integer n, String string, String string2, boolean bl) {
        GroupInformation groupInformation = this.openGroupWithInfo(n, string, string2, bl);
        return groupInformation.getGroupID();
    }

    public GroupInformation openGroupWithInfo(Integer n, String string, String string2, boolean bl) {
        GroupInformation groupInformation;
        block15: {
            this.debugOut("in openGroupWithInfo().");
            this.debugOut("theGroupName: " + string + ", vcID: " + string2 + ", isReadOnly: " + bl);
            groupInformation = new GroupInformation();
            groupInformation.setGroupName(string);
            if (this.imageGroupOpen == 0) {
                this.groupName = string;
                this.readOnly = bl;
                if (this.readOnly) {
                    this.debugOut("open group (RO) " + this.groupName);
                } else {
                    this.debugOut("open group (RW) " + this.groupName);
                }
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                if (this.readOnly) {
                    databaseConnector.setQuery("SELECT GroupID FROM " + this.IG_TABLE_GROUPS + " WHERE ((Name = " + this.prepStringForQuery(string) + ") AND (VCID = " + this.prepStringForQuery(string2) + ") AND ((GroupType = " + 2 + ") OR (GroupType = " + 1 + ")) AND UniqueCollectionID = " + n + ")");
                    this.groupType = 1;
                } else {
                    if (!string2.equals("NA")) {
                        databaseConnector.setQuery("SELECT GroupID FROM " + this.IG_TABLE_GROUPS + " WHERE ((Name = " + this.prepStringForQuery(string) + ") AND (VCID = " + this.prepStringForQuery(string2) + ") AND ((GroupType = " + 2 + ") OR (GroupType = " + 1 + ")) AND UniqueCollectionID = " + n + ")");
                    } else {
                        databaseConnector.setQuery("SELECT GroupID FROM " + this.IG_TABLE_GROUPS + " WHERE ((Name = " + this.prepStringForQuery(string) + ") AND (VCID = " + this.prepStringForQuery(string2) + ") AND (GroupType = " + 2 + ") AND UniqueCollectionID = " + n + ")");
                    }
                    this.groupType = 3;
                }
                try {
                    this.debugOut("Open group with info query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        this.groupID = databaseConnector.getIntegerFieldByName("GroupID");
                        databaseConnector.close();
                        if (!this.readOnly) {
                            int n2 = this.groupID;
                            if (this.newGroup(n, n2, string2) == -1) {
                                this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + this.groupID);
                                this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + "(GroupID, ImageID, MviSeries, MpdSeries, ObjectID, AbsoluteOrder)" + " SELECT " + this.groupID + " AS GroupID, ImageID, MviSeries, MpdSeries, ObjectID, AbsoluteOrder" + " FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + n2);
                                this.imageGroupOpen = 1;
                                groupInformation.setGroupID(-1);
                            } else {
                                groupInformation.setGroupID(-4);
                            }
                        } else {
                            this.imageGroupOpen = 1;
                            groupInformation.setGroupID(-1);
                        }
                        break block15;
                    }
                    databaseConnector.close();
                    groupInformation.setGroupID(-4);
                }
                catch (Exception exception) {
                    this.debugOut("Exception in openGroup: " + exception);
                    databaseConnector.close();
                    groupInformation.setGroupID(-3);
                }
            } else {
                groupInformation.setGroupID(-6);
            }
        }
        return groupInformation;
    }

    public int saveAs(Integer n, String string, String string2, List list) {
        if (this.imageGroupOpen == 1) {
            if (!this.readOnly) {
                return this.saveAs(n, this.groupID, string, string2, list);
            }
            return -2;
        }
        return -2;
    }

    public int saveAs(Integer n, int n2, String string, String string2, List list) {
        String string3;
        int n3;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        boolean bl = list != null;
        try {
            databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_GROUPS + " WHERE GroupID = " + n2);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                this.debugOut("base group found.");
                try {
                    this.baseGroupID = Integer.parseInt(databaseConnector.getFieldByName("Base"));
                    databaseConnector.setQuery("SELECT Name, GroupType FROM " + this.IG_TABLE_GROUPS + " WHERE GroupID = " + this.baseGroupID);
                    databaseConnector.runQuery();
                    if (databaseConnector.more()) {
                        this.groupName = databaseConnector.getFieldByName("Name");
                        n3 = databaseConnector.getIntegerField("GroupType");
                        bl &= n3 == 1;
                    }
                    this.debugOut("base group is " + this.baseGroupID + " / " + this.groupName + ".");
                }
                catch (Exception exception) {
                    this.baseGroupID = 0;
                }
            } else {
                this.baseGroupID = 0;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveAs() while determining base group: " + exception);
            this.baseGroupID = 0;
        }
        databaseConnector.close();
        bl &= this.baseGroupID != 0;
        this.debugOut("Saving as " + n2 + " / " + string + " with base group " + this.baseGroupID);
        if (this.baseGroupID == 0 || !string.equals(this.groupName)) {
            n3 = this.getGroupID(n, string, string2);
            if (n3 > 0) {
                this.baseGroupID = n3;
                this.groupName = string;
                this.quickUpdate("UPDATE " + this.IG_TABLE_GROUPS + " SET Base = " + this.prepStringForQuery(n3 + "") + ", VCID = " + this.prepStringForQuery(string2) + ", LastModifiedTimestamp = '" + new SimpleDate().get() + "' WHERE GroupID = " + n2 + ";");
            } else {
                int n4 = this.getNextGroupId();
                if (n4 > 0) {
                    string3 = new SimpleDate().get();
                    this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUPS + " (GroupID, Name, GroupType, VCID, UniqueCollectionID, CreatedTimestamp, LastModifiedTimestamp) VALUES (" + n4 + ", " + this.prepStringForQuery(string) + ", " + 2 + ", " + this.prepStringForQuery(string2) + ", " + n + ", '" + string3 + "', '" + string3 + "')");
                    this.baseGroupID = n4;
                    this.groupName = string;
                    this.quickUpdate("UPDATE " + this.IG_TABLE_GROUPS + " SET Base = " + this.prepStringForQuery(n4 + "") + ", VCID = " + this.prepStringForQuery(string2) + ", LastModifiedTimestamp = '" + new SimpleDate().get() + "' WHERE GroupID = " + n2 + ";");
                }
            }
        }
        HashSet hashSet = new HashSet();
        if (bl) {
            HashSet<Long> hashSet2 = new HashSet<Long>();
            string3 = null;
            try {
                string3 = "SELECT DISTINCT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE ImageID IN " + "(SELECT (CASE WHEN table_base.imageid IS NULL THEN table_temp.imageid ELSE table_base.imageid END) AS ImageID " + "FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_base FULL OUTER JOIN " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_temp " + "ON (table_base.imageid = table_temp.imageid AND table_base.groupid = " + this.baseGroupID + " AND table_temp.groupid = " + n2 + ") " + "WHERE ( (table_base.groupid = " + this.baseGroupID + " AND table_temp.imageid IS NULL) OR (table_temp.groupid = " + n2 + " AND table_base.imageid IS NULL)))";
                if (this.useValueFromSubQuery) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string4 = "SELECT (CASE WHEN table_base.imageid IS NULL THEN table_temp.imageid ELSE table_base.imageid END) AS ImageID FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_base FULL OUTER JOIN " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_temp " + "ON (table_base.imageid = table_temp.imageid AND table_base.groupid = " + this.baseGroupID + " AND table_temp.groupid = " + n2 + ") " + "WHERE ( (table_base.groupid = " + this.baseGroupID + " AND table_temp.imageid IS NULL) OR (table_temp.groupid = " + n2 + " AND table_base.imageid IS NULL)";
                    this.debugOut("Execute sub query\n" + string4);
                    databaseConnector.setQuery(string4);
                    databaseConnector.runQuerySafe();
                    while (databaseConnector.more()) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(databaseConnector.getIntegerField("ImageID"));
                        databaseConnector.next();
                    }
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append("NULL");
                    }
                    string3 = "SELECT DISTINCT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE ImageID IN (" + stringBuffer.toString() + ")";
                    databaseConnector.close();
                }
                this.debugOut("Execute query\n" + string3);
                databaseConnector.setQuery(string3);
                databaseConnector.runQuerySafe();
                while (databaseConnector.more()) {
                    hashSet2.add(new Long(databaseConnector.getLongField("ObjectID")));
                    databaseConnector.next();
                }
            }
            catch (Throwable throwable) {
                this.debugOut("Exception in saveAs() while determining modified object ids using FULL OUTER JOIN.  Retrying with LEFT and RIGHT: " + throwable);
                databaseConnector.close();
                try {
                    String string5;
                    StringBuffer stringBuffer;
                    this.debugOut("try LEFT OUTER JOIN");
                    string3 = "SELECT DISTINCT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE ImageID IN " + "(SELECT (CASE WHEN table_base.imageid IS NULL THEN table_temp.imageid ELSE table_base.imageid END) AS ImageID " + "FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_base LEFT OUTER JOIN " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_temp " + "ON (table_base.imageid = table_temp.imageid AND table_base.groupid = " + this.baseGroupID + " AND table_temp.groupid = " + n2 + ") " + "WHERE (table_base.groupid = " + this.baseGroupID + " AND table_temp.imageid IS NULL))";
                    if (this.useValueFromSubQuery) {
                        stringBuffer = new StringBuffer();
                        string5 = "SELECT (CASE WHEN table_base.imageid IS NULL THEN table_temp.imageid ELSE table_base.imageid END) AS ImageID FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_base LEFT OUTER JOIN " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_temp " + "ON (table_base.imageid = table_temp.imageid AND table_base.groupid = " + this.baseGroupID + " AND table_temp.groupid = " + n2 + ") " + "WHERE (table_base.groupid = " + this.baseGroupID + " AND table_temp.imageid IS NULL)";
                        this.debugOut("Execute sub query\n" + string5);
                        databaseConnector.setQuery(string5);
                        databaseConnector.runQuerySafe();
                        while (databaseConnector.more()) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(databaseConnector.getIntegerField("ImageID"));
                            databaseConnector.next();
                        }
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append("NULL");
                        }
                        string3 = "SELECT DISTINCT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE ImageID IN (" + stringBuffer.toString() + ")";
                        databaseConnector.close();
                    }
                    this.debugOut("Execute LEFT OUTER JOIN query\n" + string3);
                    databaseConnector.setQuery(string3);
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        hashSet2.add(new Long(databaseConnector.getLongField("ObjectID")));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    this.debugOut("try RIGHT OUTER JOIN");
                    string3 = "SELECT DISTINCT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE ImageID IN " + "(SELECT (CASE WHEN table_base.imageid IS NULL THEN table_temp.imageid ELSE table_base.imageid END) AS ImageID " + "FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_base RIGHT OUTER JOIN " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_temp " + "ON (table_base.imageid = table_temp.imageid AND table_base.groupid = " + this.baseGroupID + " AND table_temp.groupid = " + n2 + ") " + "WHERE (table_temp.groupid = " + n2 + " AND table_base.imageid IS NULL))";
                    if (this.useValueFromSubQuery) {
                        stringBuffer = new StringBuffer();
                        string5 = "SELECT (CASE WHEN table_base.imageid IS NULL THEN table_temp.imageid ELSE table_base.imageid END) AS ImageID FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_base RIGHT OUTER JOIN " + this.IG_TABLE_GROUP_IMAGE_MAP + " table_temp " + "ON (table_base.imageid = table_temp.imageid AND table_base.groupid = " + this.baseGroupID + " AND table_temp.groupid = " + n2 + ") " + "WHERE (table_temp.groupid = " + n2 + " AND table_base.imageid IS NULL)";
                        this.debugOut("Execute sub query\n" + string5);
                        databaseConnector.setQuery(string5);
                        databaseConnector.runQuerySafe();
                        while (databaseConnector.more()) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(databaseConnector.getIntegerField("ImageID"));
                            databaseConnector.next();
                        }
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append("NULL");
                        }
                        string3 = "SELECT DISTINCT ObjectID FROM " + this.IG_TABLE_OBJECT_IMAGE_MAP + " WHERE ImageID IN (" + stringBuffer.toString() + ")";
                        databaseConnector.close();
                    }
                    this.debugOut("Execute RIGHT OUTER JOIN query\n" + string3);
                    databaseConnector.setQuery(string3);
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        hashSet2.add(new Long(databaseConnector.getLongField("ObjectID")));
                        databaseConnector.next();
                    }
                }
                catch (Exception exception) {
                    this.debugOut("Exception in saveAs() during second attempt at reading modified object ids.  Thumbnail caches may not be updated.");
                }
            }
            databaseConnector.close();
            list.addAll(hashSet2);
        }
        this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + this.baseGroupID);
        this.quickUpdate("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + "(GroupID, ImageID, MviSeries, MpdSeries, ObjectID, AbsoluteOrder)" + " SELECT " + this.baseGroupID + " AS GroupID, ImageID, MviSeries, MpdSeries, ObjectID, AbsoluteOrder" + " FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + n2);
        return -1;
    }

    /*
     * Exception decompiling
     */
    public int deleteGroup(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int closeGroup() {
        if (this.imageGroupOpen == 1) {
            if (this.groupType == 3) {
                this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + this.groupID);
                this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUPS + " WHERE GroupID = " + this.groupID);
            }
            if (this.searchDatabaseConnector != null) {
                this.searchDatabaseConnector.close();
            }
            this.imageGroupOpen = 0;
            this.groupID = 0;
            this.readOnly = true;
            return -1;
        }
        return -2;
    }

    public int closeGroup(int n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_GROUPS + " WHERE ((GroupID = " + n + ") AND (GroupType = " + 3 + "))");
            databaseConnector.runQuery();
            this.debugOut("closeGroup query is " + databaseConnector.getQuery());
            if (databaseConnector.more()) {
                this.debugOut("at least one group matches.");
                this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + n);
                this.quickUpdate("DELETE FROM " + this.IG_TABLE_GROUPS + " WHERE GroupID = " + n);
                databaseConnector.close();
                return -1;
            }
            databaseConnector.close();
            return -4;
        }
        catch (Exception exception) {
            this.debugOut("Exception in closeGroup(): " + exception);
            databaseConnector.close();
            return -3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getImageCountOfGroup(int n) {
        String string = "SELECT Count(ImageID) AS Images FROM " + this.IG_TABLE_GROUP_IMAGE_MAP + " WHERE GroupID = " + n + ";";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerFieldByName("Images");
                databaseConnector.close();
                int n3 = n2;
                return n3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            databaseConnector.close();
        }
        return 0;
    }

    public boolean canEditObjects() {
        return true;
    }

    public boolean addObject(Field[] fieldArray, String[] stringArray, String string, String string2) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT Max(" + this.IG_TABLE_OBJECTS_KEY + ") AS MaxID FROM " + this.IG_TABLE_OBJECTS + ";");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n;
                int n2 = databaseConnector.getIntegerFieldByName("MaxID") + 1;
                databaseConnector.close();
                String string3 = "INSERT INTO " + this.IG_TABLE_OBJECTS + " (" + this.IG_TABLE_OBJECTS_KEY + "";
                for (n = 0; n < fieldArray.length; ++n) {
                    string3 = string3 + ", " + fieldArray[n].fieldName.replace(' ', '_');
                }
                string3 = string3 + ") VALUES (" + n2;
                for (n = 0; n < stringArray.length; ++n) {
                    string3 = string3 + ", ";
                    if (fieldArray[n].fieldType == 1) {
                        string3 = string3 + this.prepStringForQuery(stringArray[n]);
                        continue;
                    }
                    string3 = string3 + this.escapeQuotes(stringArray[n]);
                    if (fieldArray[n].fieldType != 2 || stringArray[n].length() != 0) continue;
                    string3 = string3 + "0";
                }
                string3 = string3 + ");";
                this.debugOut("Add Object query is:\n" + string3);
                databaseConnector.setQuery(string3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                databaseConnector2.setQuery("SELECT MIN(ImageID) AS MinimumID FROM " + this.IG_TABLE_IMAGE_FILES + ";");
                databaseConnector2.runQuery();
                if (databaseConnector2.more()) {
                    int n3;
                    long l = databaseConnector2.getLongField("MinimumID") - 1L;
                    this.debugOut("New Image ID = " + l);
                    int n4 = 96;
                    for (n3 = 0; n3 <= 2; ++n3) {
                        databaseConnector2.close();
                        databaseConnector2.setQuery("INSERT INTO " + this.IG_TABLE_IMAGE_FILES + " (ImageID, ResolutionSize, Format, LPSid, FileName, Width, Height)" + " VALUES (" + l + ", " + n3 + ", 'JPEG', -1, 'placeholder" + n3 + ".jpg', " + n4 + ", " + n4 + ");");
                        n4 *= 2;
                        this.debugOut("Insert into " + this.IG_TABLE_IMAGE_FILES + " query:\n" + databaseConnector2.getQuery());
                        databaseConnector2.runUpdateQuery();
                    }
                    databaseConnector2.close();
                    databaseConnector2.setQuery("INSERT INTO " + this.IG_TABLE_OBJECT_IMAGE_MAP + " (ObjectID, ImageID) VALUES (" + n2 + ", " + l + ");");
                    this.debugOut("Insert into " + this.IG_TABLE_OBJECT_IMAGE_MAP + " query:\n" + databaseConnector2.getQuery());
                    databaseConnector2.runUpdateQuery();
                    databaseConnector2.close();
                    databaseConnector2.setQuery("SELECT GroupID FROM " + this.IG_TABLE_GROUPS + " WHERE (Name = " + this.prepStringForQuery(string) + " AND VCID = " + this.prepStringForQuery(string2) + " AND GroupType = " + 1 + ")");
                    this.debugOut("Find collections query:\n" + databaseConnector2.getQuery());
                    databaseConnector2.runQuery();
                    DatabaseConnector databaseConnector3 = null;
                    while (databaseConnector2.more()) {
                        n3 = databaseConnector2.getIntegerFieldByName("GroupID");
                        databaseConnector3 = this.getDatabaseConnector();
                        databaseConnector3.setQuery("INSERT INTO " + this.IG_TABLE_GROUP_IMAGE_MAP + " (GroupID, ImageID, ObjectID, AbsoluteOrder) VALUES (" + n3 + ", " + l + ", 0, 0);");
                        this.debugOut("Insert into " + this.IG_TABLE_GROUP_IMAGE_MAP + " query:\n" + databaseConnector3.getQuery());
                        databaseConnector3.runUpdateQuery();
                        databaseConnector3.close();
                        databaseConnector2.next();
                    }
                    return true;
                }
                databaseConnector2.close();
            } else {
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            databaseConnector.close();
            databaseConnector2.close();
        }
        return false;
    }

    public boolean editObject(long l, Field[] fieldArray, String[] stringArray) {
        try {
            StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.IG_TABLE_OBJECTS + " ");
            for (int i = 0; i < fieldArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("SET ");
                } else {
                    stringBuffer.append(", ");
                }
                if (fieldArray[i].fieldType == 1) {
                    stringBuffer.append(fieldArray[i].fieldName.replace(' ', '_') + " = " + this.prepStringForQuery(stringArray[i]));
                } else {
                    stringBuffer.append(fieldArray[i].fieldName.replace(' ', '_') + " = " + this.escapeQuotes(stringArray[i]));
                }
                if (fieldArray[i].fieldType != 2 || stringArray[i].length() != 0) continue;
                stringBuffer.append("0");
            }
            stringBuffer.append(" WHERE " + this.IG_TABLE_OBJECTS_KEY + " = " + l + ";");
            this.debugOut("Edit Object query is:\n" + stringBuffer);
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            boolean bl = true;
            try {
                databaseConnector.setQuery(stringBuffer.toString());
                databaseConnector.runUpdateQuery();
            }
            catch (Exception exception) {
                bl = false;
            }
            databaseConnector.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object[] getObjectData(long l) {
        int n;
        Object object;
        this.debugOut("getObjectData, objectID is " + l);
        Object[] objectArray = new Field[]{};
        int n2 = 0;
        String string = "SELECT " + this.IG_TABLE_FIELDS + ".* FROM " + this.IG_TABLE_FIELDS + " WHERE (NOT (" + this.IG_TABLE_FIELDS + ".FieldType)=0) ORDER BY " + this.IG_TABLE_FIELDS + ".DisplayOrder;";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            object = new Vector();
            while (databaseConnector.more()) {
                boolean bl = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                int n3 = databaseConnector.getIntegerFieldByName("LongString");
                boolean bl2 = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                boolean bl3 = databaseConnector.getIntegerFieldByName("Sortable") == 1;
                n = 0;
                try {
                    n = databaseConnector.getIntegerFieldByName("IsDate") == 1 ? 1 : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Field field = new Field(databaseConnector.getIntegerFieldByName("FieldId"), this.IG_TABLE_OBJECTS, databaseConnector.getFieldByName("FieldName"), databaseConnector.getIntegerFieldByName("FieldType"));
                field.vocabulary = bl;
                field.stringType = n3;
                field.multiValue = bl2;
                field.date = n;
                ((Vector)object).addElement(field);
                databaseConnector.next();
            }
            objectArray = new Field[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
            n2 = objectArray.length;
            this.debugOut(n2 + " fields to query.");
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectData while gathering fields: " + exception);
        }
        databaseConnector.close();
        object = "SELECT " + this.IG_TABLE_OBJECTS + ".*";
        String string2 = " FROM " + this.IG_TABLE_OBJECTS + "";
        String string3 = " WHERE (" + this.IG_TABLE_OBJECTS_KEY + " = " + l + ");";
        String string4 = (String)object + string2 + string3;
        this.debugOut("full info query is...\n " + string4);
        DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
        try {
            databaseConnector2.setQuery(string4);
            databaseConnector2.runQuery();
            if (databaseConnector2.more()) {
                this.debugOut("At least one element found.");
                n = n2 * 2;
                int n4 = 0;
                Object[] objectArray2 = new Object[n];
                String string5 = null;
                for (int i = 0; i < n2; ++i) {
                    try {
                        string5 = databaseConnector2.getFieldByName(((Field)objectArray[i]).fieldName.replace(' ', '_'));
                        if (string5 != null) {
                            objectArray2[n4++] = objectArray[i];
                            objectArray2[n4++] = string5;
                            continue;
                        }
                        objectArray2[n4++] = objectArray[i];
                        objectArray2[n4++] = "";
                        continue;
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception while attempting to gather data from field " + ((Field)objectArray[i]).fieldName);
                        this.debugOut(exception.toString());
                    }
                }
                databaseConnector2.close();
                return objectArray2;
            }
            this.debugOut("No matching elements.");
            databaseConnector2.close();
            return new Object[0];
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectData: " + exception);
            databaseConnector2.close();
            return new Object[0];
        }
    }

    public ObjectDimension getObjectDimension(Integer n, long l) {
        this.debugOut("getObjectDimension(), image ID: " + l);
        ObjectDimension objectDimension = new ObjectDimension(l);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            String string = "SELECT * FROM IROBJECTDIMENSION WHERE UniqueCollectionID = " + n;
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n2;
                int n3 = databaseConnector.getIntegerFieldByName("WidthFieldID");
                int n4 = databaseConnector.getIntegerFieldByName("HeightFieldID");
                objectDimension.metric = n2 = databaseConnector.getIntegerFieldByName("Metric");
                databaseConnector.setQuery("SELECT FieldId, FieldName FROM " + this.IG_TABLE_FIELDS + " WHERE (FieldId = " + n3 + " OR FieldId = " + n4 + ")");
                this.debugOut("Query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    String string2 = null;
                    String string3 = null;
                    while (databaseConnector.more()) {
                        int n5 = databaseConnector.getIntegerFieldByName("FieldId");
                        if (n5 == n3) {
                            string2 = this.underscoreFieldName(databaseConnector.getFieldByName("FieldName"));
                        }
                        if (n5 == n4) {
                            string3 = this.underscoreFieldName(databaseConnector.getFieldByName("FieldName"));
                        }
                        databaseConnector.next();
                    }
                    if (string2 != null && string3 != null) {
                        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECTS, null, new String[]{"ObjectID", string2, string3});
                        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[0]);
                        sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECT_IMAGE_MAP, this.IG_TABLE_OBJECTS, new String[]{"ObjectID"}, 0);
                        sqlQueryGenerator.appendToWhere(this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = " + l);
                        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                        this.debugOut("Dimension query: \n" + databaseConnector.getQuery());
                        databaseConnector.runQuery();
                        if (databaseConnector.more()) {
                            objectDimension.objectID = databaseConnector.getLongField("ObjectID");
                            objectDimension.convertDimension(databaseConnector.getFieldByName(string2), databaseConnector.getFieldByName(string3));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectDimension: " + exception);
        }
        databaseConnector.close();
        return objectDimension;
    }

    public FieldValue[] getFullInformation(long l) {
        this.debugOut("getFullInformation, objectID is " + l);
        String string = "SELECT " + this.IG_TABLE_FIELDS + ".FieldID, " + this.IG_TABLE_FIELDS + ".FieldName, " + this.IG_TABLE_FIELDS + ".TableName, " + this.IG_TABLE_FIELDS + ".DisplayOrder, " + this.IG_TABLE_FIELDS + ".FieldType" + " FROM " + this.IG_TABLE_FIELDS + " WHERE " + this.IG_TABLE_FIELDS + ".Displayed = 1 AND " + this.IG_TABLE_FIELDS + ".FieldType <> " + 0 + " ORDER BY " + this.IG_TABLE_FIELDS + ".DisplayOrder";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        databaseConnector.setQuery(string);
        databaseConnector.runQuery();
        Object[] objectArray = new String[]{};
        Object[] objectArray2 = new Integer[]{};
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        String string2 = "";
        while (databaseConnector.more()) {
            string2 = "";
            int n = 0;
            try {
                string2 = databaseConnector.getFieldByName("FieldName");
                n = databaseConnector.getIntegerField("FieldID");
            }
            catch (Exception exception) {
                string2 = "";
                this.debugOut("Exception in getFullInformation(): " + exception);
            }
            vector.addElement(string2.replace(' ', '_'));
            vector2.addElement(new Integer(n));
            databaseConnector.next();
        }
        databaseConnector.close();
        int n = vector.size();
        this.debugOut(n + " fields to query.");
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        objectArray2 = new Integer[vector2.size()];
        vector2.copyInto(objectArray2);
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECTS, null, STRING_WILDCARD);
        sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, new String[0]);
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[0]);
        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[0]);
        sqlQueryGenerator.addJoin(this.IG_TABLE_LPS, this.IG_TABLE_IMAGE_FILES, new String[]{"LPSid"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECT_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECT_IMAGE_MAP, this.IG_TABLE_OBJECTS, new String[]{"ObjectID"}, 0);
        sqlQueryGenerator.appendToWhere("(" + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + this.requestedThumbnailSize + ") AND (" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + l + ")");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Full info query :\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            this.debugOut("At least one element found.");
            int n2 = n * 2;
            Vector<FieldValue> vector3 = new Vector<FieldValue>(n2);
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                try {
                    string3 = databaseConnector.getStringField((String)objectArray[i]);
                    if (string3 == null) continue;
                    vector3.addElement(new FieldValue((Integer)objectArray2[i], ((String)objectArray[i]).replace('_', ' '), string3, false));
                    continue;
                }
                catch (Exception exception) {
                    this.debugOut("Exception while attempting to gather data from field " + (String)objectArray[i] + ":\n" + InsightUtilities.getStackTrace(exception));
                }
            }
            Object[] objectArray3 = new FieldValue[vector3.size()];
            vector3.copyInto(objectArray3);
            databaseConnector.close();
            return objectArray3;
        }
        this.debugOut("No matching elements.");
        databaseConnector.close();
        return new FieldValue[0];
    }

    public String getFullInformationWrap(long l, String string) {
        FieldValue[] fieldValueArray = this.getFullInformation(l);
        StringBuffer stringBuffer = new StringBuffer("<table border=0 cellpadding=0 cellspacing=5 width=" + string + ">");
        for (int i = 0; i < fieldValueArray.length; ++i) {
            if (fieldValueArray[i] == null) continue;
            stringBuffer.append("<tr><td width=40% align=left valign=top><font size=-1><b>" + fieldValueArray[i].displayName + ":</b></font></td><td width=60% align=left valign=top><font size=-1>" + fieldValueArray[i].value + "</font></td></tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    public String getImage(long l, int n) {
        return this.getImage(l, n, 1, 1);
    }

    public String getImageFromObjectID(String string, int n, int n2, int n3) {
        boolean bl;
        this.debugOut("in getImageFromObjectID(): objectID: " + string + ", resolutionCode: " + n);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, "ObjectID");
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"FileName", "LPSid", "Width as ImageWidth", "Height as ImageHeight"});
        sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_OBJECT_IMAGE_MAP, new String[]{"ImageID"}, 0);
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + string + " AND " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + n);
        boolean bl2 = bl = n2 >= 0 || n3 >= 0;
        if (bl) {
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_IMAGE_FILES, new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_PROFILE, this.IG_TABLE_SPS, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3);
        }
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Get image from objectID query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            this.debugOut("At least one element found.");
            String string2 = "";
            try {
                string2 = this.getMediaUrl(databaseConnector);
            }
            catch (Exception exception) {
                string2 = "";
                this.debugOut("Exception in getImageFromObjectID(): " + exception);
            }
            databaseConnector.close();
            this.debugOut("The URL is " + string2);
            return string2;
        }
        databaseConnector.close();
        return "";
    }

    public String getImage(long l, int n, int n2, int n3) {
        boolean bl;
        this.debugOut("getImage " + l + " at resolution " + n);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"ImageID", "FileName"});
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID = " + l + " AND " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + n);
        boolean bl2 = bl = n2 >= 0 || n3 >= 0;
        if (bl) {
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_PROFILE, this.IG_TABLE_SPS, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3);
        }
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Get image query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            this.debugOut("At least one element found.");
            String string = "";
            try {
                string = this.getMediaUrl(databaseConnector);
            }
            catch (Exception exception) {
                string = "";
                this.debugOut("Exception in getImage(): " + exception);
            }
            databaseConnector.close();
            this.debugOut("The URL is " + string);
            return string;
        }
        databaseConnector.close();
        return "";
    }

    public Object[] getURLs(long l) {
        return this.getURLs(l, 1, 1);
    }

    public String[] getURLs(long l, int n, int n2) {
        Object[] objectArray = this.getURLsAndDimensions(l, n, n2);
        String[] stringArray = new String[18];
        int n3 = 0;
        for (int i = 0; i < objectArray.length; i += 3) {
            stringArray[n3++] = (String)objectArray[i];
            stringArray[n3++] = (String)objectArray[i + 1];
        }
        return stringArray;
    }

    public Object[] getURLsAndDimensions(String[] stringArray, int n, int n2) {
        Object[] objectArray;
        boolean bl;
        Object[] objectArray2 = new Object[stringArray.length];
        this.debugOut("in getURLsAndDimensions() for images.");
        String string = "";
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + stringArray[i];
        }
        if (string.equals("")) {
            return objectArray2;
        }
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "ImageID", "FileName", "Width", "Height"});
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID IN (" + string + ")");
        boolean bl2 = bl = n >= 0 || n2 >= 0;
        if (bl) {
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n2);
        }
        sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ImageID");
        sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ResolutionSize");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        while (databaseConnector.more()) {
            int n3;
            objectArray = null;
            try {
                objectArray = databaseConnector.getLongField("ImageID") + "";
            }
            catch (Exception exception) {
                this.debugOut("Exception in getURLsAndDimensions() for images: " + exception);
                objectArray = null;
            }
            if (objectArray == null) {
                databaseConnector.next();
                continue;
            }
            Object[] objectArray3 = new Object[27];
            String string2 = "";
            for (n3 = 0; n3 < 9; ++n3) {
                string2 = "";
                try {
                    string2 = this.getMediaUrl(databaseConnector);
                    objectArray3[n3 * 3] = string2;
                    objectArray3[n3 * 3 + 1] = databaseConnector.getFieldByName("Format");
                    objectArray3[n3 * 3 + 2] = new Dimension(databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                }
                catch (Exception exception) {
                    string2 = "";
                    this.debugOut("Exception in getURLsAndDimensions() for images: " + exception);
                }
                databaseConnector.next();
                if (!databaseConnector.more()) break;
                String string3 = null;
                try {
                    string3 = databaseConnector.getLongField("ImageID") + "";
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getURLsAndDimensions() for images: " + exception);
                    string3 = null;
                }
                if (string3 == null || !string3.equals(objectArray)) break;
            }
            for (n3 = 0; n3 < stringArray.length && stringArray[n3] != null; ++n3) {
                if (!stringArray[n3].equals(objectArray)) continue;
                objectArray2[n3] = objectArray3;
            }
        }
        objectArray = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray2[i] != null) continue;
            if (objectArray == null) {
                objectArray = new Object[27];
            }
            objectArray2[i] = objectArray;
        }
        databaseConnector.close();
        return objectArray2;
    }

    public Object[] getURLsAndDimensions(long l, int n, int n2, Integer n3) {
        boolean bl;
        this.debugOut("in getURLsAndDimensions().");
        Object[] objectArray = new Object[27];
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "ImageID", "FileName", "Width", "Height", "ResolutionSize", "MediaType"});
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID = " + l);
        boolean bl2 = bl = n >= 0 || n2 >= 0;
        if (bl) {
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n2 + " AND " + this.IG_TABLE_IMAGE_FILES + ".Format != 'SOURCE'");
        }
        sqlQueryGenerator.addOrderBy(this.IG_TABLE_IMAGE_FILES, "ResolutionSize");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            String string = "";
            for (int i = 0; i < 9; ++i) {
                string = "";
                try {
                    int n4 = databaseConnector.getIntegerField("MediaType");
                    if (n3 != null && n4 == 1 && databaseConnector.getIntegerField("ResolutionSize") > n3) continue;
                    string = this.getMediaUrl(databaseConnector);
                    objectArray[i * 3] = string;
                    objectArray[i * 3 + 1] = databaseConnector.getFieldByName("Format");
                    objectArray[i * 3 + 2] = new Dimension(databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                }
                catch (Exception exception) {
                    string = "";
                    this.debugOut("Exception in getURLsAndDimensions(): " + exception);
                }
                databaseConnector.next();
                if (!databaseConnector.more()) break;
            }
            databaseConnector.close();
            return objectArray;
        }
        databaseConnector.close();
        return objectArray;
    }

    public Object[] getURLsAndDimensions(long l, int n, int n2) {
        return this.getURLsAndDimensions(l, n, n2, null);
    }

    public Object[] getMediaURL(long l, int n, int n2, int n3) {
        boolean bl;
        this.debugOut("in getMediaURL().");
        Object[] objectArray = new Object[3];
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"Format", "ImageID", "FileName", "Width", "Height", "ResolutionSize", "MediaType"});
        sqlQueryGenerator.appendToWhere(this.IG_TABLE_IMAGE_FILES + ".ImageID = " + l);
        if (n3 < 0) {
            sqlQueryGenerator.appendToWhere("(" + this.IG_TABLE_IMAGE_FILES + ".Format = 'SOURCE'" + " and " + this.IG_TABLE_IMAGE_FILES + ".MediaType = 1" + ") or " + "(" + this.IG_TABLE_IMAGE_FILES + ".MediaType != 1 and " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = 2" + ")");
        } else {
            sqlQueryGenerator.appendToWhere("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = 1" + " and " + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + n3 + ")");
        }
        boolean bl2 = bl = n >= 0 || n2 >= 0;
        if (bl) {
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"Format", "ResolutionSize", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n2);
        }
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Query:\n" + databaseConnector.getQuery());
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            try {
                objectArray[0] = this.getMediaUrl(databaseConnector);
                objectArray[1] = databaseConnector.getFieldByName("FileName");
                int n4 = databaseConnector.getIntegerFieldByName("ResolutionSize");
                objectArray[2] = new Integer(n4);
                this.debugOut("getMediaURL: Source URL: " + objectArray[0]);
                this.debugOut("getMediaURL: Source File Name: " + objectArray[1]);
                this.debugOut("getMediaURL: ResolutionSize: " + objectArray[2]);
            }
            catch (Exception exception) {
                this.debugOut("Exception in getMediaURL(): " + exception);
            }
            databaseConnector.close();
            return objectArray;
        }
        databaseConnector.close();
        return objectArray;
    }

    public int attemptBrowserLogin(String string, String string2, int n) {
        int n2 = 0;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable("USERLIST", null, "UserID");
            sqlQueryGenerator.addJoin("UserGroupProfileMap", "USERLIST", "UserID", 0);
            sqlQueryGenerator.addJoin("UserGroupProfileMap", "UserGroupLoginID", "USERGROUPS", "GroupID", 0);
            sqlQueryGenerator.addJoin("USERGROUPS", "USERGROUPSERVERMAP", "GroupID", 0);
            sqlQueryGenerator.addJoin("USERGROUPSERVERMAP", "COLLECTIONS", "ServerID", 0);
            sqlQueryGenerator.appendToWhere("((USERLIST.UserName=" + this.prepStringForQuery(string) + ")" + " AND (" + "USERLIST" + ".Password=" + this.prepStringForQuery(string2) + ")" + " AND (" + "COLLECTIONS" + ".CollectionID=" + n + "))");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerFieldByName("UserID");
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in attemptBrowserLogin(): " + exception);
            InsightBackendConnector.debugFile("Exception in attemptBrowserLogin(): " + exception, 1);
        }
        return n2;
    }

    public void setSortField(String string) {
        this.sortFields = new String[1];
        this.sortFields[0] = string.replace(' ', '_');
    }

    public void setSortFields(String[] stringArray) {
        this.sortFields = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) {
                this.sortFields[i] = stringArray[i].replace(' ', '_');
                this.debugOut("Sort field " + i + " = " + this.sortFields[i]);
                continue;
            }
            this.sortFields[i] = null;
        }
    }

    public void setThumbnailSize(int n) {
        this.requestedThumbnailSize = n;
    }

    public String[] getSortFields() {
        return this.sortFields;
    }

    public int getThumbnailSize() {
        return this.requestedThumbnailSize;
    }

    protected String convertFieldName(String string) {
        if (string.equalsIgnoreCase("Width")) {
            return this.IG_TABLE_OBJECTS + ".Width as objectWidth";
        }
        if (string.equalsIgnoreCase("Height")) {
            return this.IG_TABLE_OBJECTS + ".Height as objectHeight";
        }
        return this.IG_TABLE_OBJECTS + "." + this.underscoreFieldName(string);
    }

    protected String convertSortField(String string) {
        if (string.equalsIgnoreCase("ImageID")) {
            return this.IG_TABLE_IMAGE_FILES + ".ImageID";
        }
        if (string.equalsIgnoreCase("Width")) {
            return this.IG_TABLE_OBJECTS + ".Width";
        }
        if (string.equalsIgnoreCase("Height")) {
            return this.IG_TABLE_OBJECTS + ".Height";
        }
        return this.IG_TABLE_OBJECTS + "." + this.underscoreFieldName(string);
    }

    protected String convertKeyword(String string) {
        String string2 = this.escapeSpecialCharacters(string);
        string2 = InsightUtilities.replaceSubstrings(string2, CHAR_WILDCARD, this.CHAR_WILDCARD_SYMBOL);
        string2 = InsightUtilities.replaceSubstrings(string2, STRING_WILDCARD, this.STRING_WILDCARD_SYMBOL);
        return string2;
    }

    protected String createFieldSelectList(String[] stringArray) {
        String string = "";
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = stringArray[i] != null && stringArray[i].length() > 0;
            if (!bl) continue;
            for (int j = 0; j < i; ++j) {
                if (stringArray[j] == null || !stringArray[i].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + this.convertFieldName(stringArray[i]);
            ++n;
        }
        return string;
    }

    protected String createOrderBy(String[] stringArray) {
        String string = new String();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = stringArray[i] != null && stringArray[i].length() > 0;
            if (!bl) continue;
            for (int j = 0; j < i; ++j) {
                if (stringArray[j] == null || !stringArray[i].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (n > 0) {
                string = string + ", ";
            }
            string = string + this.convertSortField(stringArray[i]);
            ++n;
        }
        return string;
    }

    public String createEquivalenceRelationshipClause(String string, int n, int n2, String string2, boolean bl) {
        String string3 = "";
        if (n2 != 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            switch (n2) {
                case 3: {
                    if (n != 2) {
                        if (bl) {
                            stringBuffer.append(" LIKE LOWER(" + this.prepStringForQuery(string2 + this.STRING_WILDCARD_SYMBOL, false) + ")");
                            break;
                        }
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(string2 + this.STRING_WILDCARD_SYMBOL, false));
                        break;
                    }
                    if (this.useDistinctKeyword) {
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(string2 + this.STRING_WILDCARD_SYMBOL, false));
                        break;
                    }
                    if (string2.equals("") || string2 == null) {
                        stringBuffer.append(" IS NOT NULL");
                        break;
                    }
                    stringBuffer.append(" = " + string2);
                    break;
                }
                case 4: {
                    if (n != 2) {
                        if (bl) {
                            stringBuffer.append(" LIKE LOWER(" + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2, false));
                        break;
                    }
                    if (this.useDistinctKeyword) {
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2, false));
                        break;
                    }
                    if (string2.equals("") || string2 == null) {
                        stringBuffer.append(" IS NOT NULL");
                        break;
                    }
                    stringBuffer.append(" = " + string2);
                    break;
                }
                case 2: {
                    if (n != 2) {
                        if (bl) {
                            stringBuffer.append(" LIKE LOWER(" + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false) + ")");
                            break;
                        }
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false));
                        break;
                    }
                    if (this.useDistinctKeyword) {
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false));
                        break;
                    }
                    if (string2.equals("") || string2 == null) {
                        stringBuffer.append(" IS NOT NULL");
                        break;
                    }
                    stringBuffer.append(" = " + string2);
                    break;
                }
                case 9: {
                    if (n != 2) {
                        if (bl) {
                            stringBuffer.append(" NOT LIKE LOWER(" + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false) + ")");
                            break;
                        }
                        stringBuffer.append(" NOT LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false));
                        break;
                    }
                    if (this.useDistinctKeyword) {
                        stringBuffer.append(" NOT LIKE " + this.prepStringForQuery(this.STRING_WILDCARD_SYMBOL + string2 + this.STRING_WILDCARD_SYMBOL, false));
                        break;
                    }
                    if (string2.equals("") || string2 == null) {
                        stringBuffer.append(" IS NULL");
                        break;
                    }
                    stringBuffer.append(" <> " + string2);
                    break;
                }
                case 1: {
                    if (n == 1) {
                        if (bl) {
                            stringBuffer.append(" LIKE LOWER(" + this.prepStringForQuery(string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (n == 3) {
                        stringBuffer.append(" LIKE " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    stringBuffer.append(" = " + string2);
                    break;
                }
                case 10: {
                    if (n == 1) {
                        if (bl) {
                            stringBuffer.append(" NOT LIKE LOWER(" + this.prepStringForQuery(string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" NOT LIKE " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (n == 3) {
                        stringBuffer.append(" NOT LIKE " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (string2.equals("") || string2 == null) {
                        stringBuffer.append(" IS NOT NULL");
                        break;
                    }
                    stringBuffer.append(" <> " + string2);
                    break;
                }
                case 5: {
                    if (n == 1) {
                        if (bl) {
                            stringBuffer.append(" > LOWER(" + this.prepStringForQuery(string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" > " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (n == 3) {
                        stringBuffer.append(" > " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    stringBuffer.append(" > " + string2);
                    break;
                }
                case 6: {
                    if (n == 1) {
                        if (bl) {
                            stringBuffer.append(" < LOWER(" + this.prepStringForQuery(string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" < " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (n == 3) {
                        stringBuffer.append(" < " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    stringBuffer.append(" < " + string2);
                    break;
                }
                case 7: {
                    if (n == 1) {
                        if (bl) {
                            stringBuffer.append(" >= LOWER(" + this.prepStringForQuery(string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" >= " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (n == 3) {
                        stringBuffer.append(" >= " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    stringBuffer.append(" >= " + string2);
                    break;
                }
                case 8: {
                    if (n == 1) {
                        if (bl) {
                            stringBuffer.append(" <= LOWER(" + this.prepStringForQuery(string2, false) + ")");
                            break;
                        }
                        stringBuffer.append(" <= " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    if (n == 3) {
                        stringBuffer.append(" <= " + this.prepStringForQuery(string2, false));
                        break;
                    }
                    stringBuffer.append(" <= " + string2);
                    break;
                }
                case 11: {
                    stringBuffer.append(" IS NOT NULL");
                    break;
                }
                case 12: {
                    stringBuffer.append(" IS NOT NULL");
                }
            }
            if (stringBuffer.length() > 0) {
                string3 = "(" + stringBuffer.toString() + ")";
            }
        }
        return string3;
    }

    public String createLinkCodeClause(CollectionKey collectionKey, String string, String string2, Vector vector) {
        return this.createLinkCodeClause(LinkCodeGenerator.getLinkCodes((CollectionKey)collectionKey, (String)string, (String)string2, (Vector)vector));
    }

    public String createLinkCodeClause(Vector vector) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.prepStringForQuery((String)vector.elementAt(i)));
        }
        if (stringBuffer.length() > 0) {
            string = "(LinkCode IN (" + stringBuffer.toString() + "))";
        }
        return string;
    }

    public Field[] getFieldList() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        Object[] objectArray = new Field[]{};
        try {
            this.debugOut("in getFieldList().");
            databaseConnector.setQuery("SELECT " + this.IG_TABLE_FIELDS + ".*" + " FROM " + this.IG_TABLE_FIELDS + " WHERE (NOT " + this.IG_TABLE_FIELDS + ".FieldType = 0)" + " ORDER BY " + this.IG_TABLE_FIELDS + ".DisplayOrder");
            databaseConnector.runQuery();
            Vector<Field> vector = new Vector<Field>();
            int n = 0;
            Field field = null;
            while (databaseConnector.more()) {
                field = new Field();
                field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                field.fieldDisplayName = field.fieldName = databaseConnector.getFieldByName("FieldName");
                field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                field.fieldGroupID = databaseConnector.getIntegerField("FieldGroupID");
                field.tableName = databaseConnector.getFieldByName("TableName");
                field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                try {
                    field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                }
                catch (NumberFormatException numberFormatException) {
                    field.fieldType = 0;
                }
                try {
                    field.keywordSearchable = databaseConnector.getIntegerFieldByName("Indexed") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                }
                catch (Exception exception) {
                    field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                }
                if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                    try {
                        field.hierarchyName = databaseConnector.getFieldByName("HierarchyName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (field.hierarchyName == null) {
                    field.hierarchyName = "";
                }
                vector.addElement(field);
                if (n < 10) {
                    this.debugOut("0" + n + " " + field);
                } else {
                    this.debugOut(n + " " + field);
                }
                databaseConnector.next();
                ++n;
            }
            objectArray = new Field[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFieldList():\n" + InsightUtilities.getStackTrace(exception));
            objectArray = new Field[]{};
        }
        databaseConnector.close();
        return objectArray;
    }

    public Field[] getSearchableFieldList(Integer n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        Object[] objectArray = new Field[]{};
        try {
            this.debugOut("in getSearchableFieldList().");
            databaseConnector.setQuery("SELECT " + this.IG_TABLE_FIELDS + ".*" + " FROM " + this.IG_TABLE_FIELDS + " WHERE ((DataFieldSearchable = 1) AND (NOT " + this.IG_TABLE_FIELDS + ".FieldType = 0))" + " ORDER BY " + this.IG_TABLE_FIELDS + ".DisplayOrder");
            databaseConnector.runQuery();
            Vector<Field> vector = new Vector<Field>();
            int n2 = 0;
            Field field = null;
            while (databaseConnector.more()) {
                field = new Field();
                field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                field.fieldDisplayName = field.fieldName = databaseConnector.getFieldByName("FieldName");
                field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                field.fieldGroupID = databaseConnector.getIntegerField("FieldGroupID");
                field.tableName = databaseConnector.getFieldByName("TableName");
                field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                try {
                    field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                }
                catch (NumberFormatException numberFormatException) {
                    field.fieldType = 0;
                }
                try {
                    field.keywordSearchable = databaseConnector.getIntegerFieldByName("Indexed") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                }
                catch (Exception exception) {
                    field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                }
                if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                    try {
                        field.hierarchyName = databaseConnector.getFieldByName("HierarchyName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (field.hierarchyName == null) {
                    field.hierarchyName = "";
                }
                vector.addElement(field);
                if (n2 < 10) {
                    this.debugOut("0" + n2 + " " + field);
                } else {
                    this.debugOut(n2 + " " + field);
                }
                databaseConnector.next();
                ++n2;
            }
            objectArray = new Field[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getSearchableFieldList():\n" + InsightUtilities.getStackTrace(exception));
            objectArray = new Field[]{};
        }
        databaseConnector.close();
        return objectArray;
    }

    public Field[] getPickableFieldList() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        Object[] objectArray = new Field[]{};
        try {
            this.debugOut("in getPickableFieldList().");
            databaseConnector.setQuery("SELECT " + this.IG_TABLE_FIELDS + ".*" + " FROM " + this.IG_TABLE_FIELDS + " WHERE (SearchPick = 1)" + " ORDER BY " + this.IG_TABLE_FIELDS + ".DisplayOrder");
            databaseConnector.runQuery();
            Vector<Field> vector = new Vector<Field>();
            int n = 0;
            Field field = null;
            while (databaseConnector.more()) {
                field = new Field();
                field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                field.fieldDisplayName = field.fieldName = databaseConnector.getFieldByName("FieldName");
                field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                field.fieldGroupID = databaseConnector.getIntegerField("FieldGroupID");
                field.tableName = databaseConnector.getFieldByName("TableName");
                field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                try {
                    field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                }
                catch (NumberFormatException numberFormatException) {
                    field.fieldType = 0;
                }
                try {
                    field.keywordSearchable = databaseConnector.getIntegerFieldByName("Indexed") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                }
                catch (Exception exception) {
                    field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                }
                if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                    try {
                        field.hierarchyName = databaseConnector.getFieldByName("HierarchyName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (field.hierarchyName == null) {
                    field.hierarchyName = "";
                }
                vector.addElement(field);
                if (n < 10) {
                    this.debugOut("0" + n + " " + field);
                } else {
                    this.debugOut(n + " " + field);
                }
                databaseConnector.next();
                ++n;
            }
            objectArray = new Field[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPickableFieldList():\n" + InsightUtilities.getStackTrace(exception));
            objectArray = new Field[]{};
        }
        databaseConnector.close();
        return objectArray;
    }

    public Field getField(String string, Integer n) {
        DatabaseConnector databaseConnector;
        Field field;
        block16: {
            field = new Field();
            databaseConnector = this.getDatabaseConnector();
            try {
                this.debugOut("in getField(" + string + ").");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRFIELDS", null, STRING_WILDCARD);
                sqlQueryGenerator.addJoin("IRFIELDS", "ISENTITYFIELDS", "FieldID", 0);
                sqlQueryGenerator.addJoin("ISENTITYFIELDS", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + n);
                sqlQueryGenerator.appendToWhere("IRFIELDS.FieldName = " + this.prepStringForQuery(string));
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block16;
                field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                field.fieldDisplayName = field.fieldName = databaseConnector.getFieldByName("FieldName");
                field.fieldDisplayOrder = databaseConnector.getIntegerField("DisplayOrder");
                field.tableName = databaseConnector.getFieldByName("TableName");
                field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                field.pickable = databaseConnector.getIntegerFieldByName("SearchPick") == 1;
                field.vocabulary = databaseConnector.getIntegerFieldByName("VocabField") == 1;
                field.multiValue = databaseConnector.getIntegerFieldByName("MultiValue") == 1;
                try {
                    field.date = databaseConnector.getIntegerFieldByName("IsDate") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                }
                catch (NumberFormatException numberFormatException) {
                    field.fieldType = 0;
                }
                try {
                    field.keywordSearchable = databaseConnector.getIntegerFieldByName("Indexed") == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("Lexicon");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                }
                catch (Exception exception) {
                    field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                }
                if (field.hierarchyMode > Field.HIERARCHY_MODE_NONE) {
                    try {
                        field.hierarchyName = databaseConnector.getFieldByName("HierarchyName");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (field.hierarchyName == null) {
                    field.hierarchyName = "";
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getField(): " + exception);
                field = new Field();
            }
        }
        databaseConnector.close();
        return field;
    }

    public FieldMapping getFieldMapping(String string, Integer n) {
        Field field = this.getField(string, n);
        return this.getFieldMapping(field);
    }

    public FieldMapping getFieldMapping(Field field) {
        FieldMapping fieldMapping = new FieldMapping(field.fieldName, field.fieldDisplayName, field.fieldID, field.fieldType);
        fieldMapping.addFinalField(field);
        return fieldMapping;
    }

    public FieldMapping[] getFieldMappings(String[] stringArray, Integer n) {
        FieldMapping[] fieldMappingArray = null;
        if (stringArray == null) {
            fieldMappingArray = new FieldMapping[]{};
        } else {
            fieldMappingArray = new FieldMapping[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fieldMappingArray[i] = this.getFieldMapping(stringArray[i], n);
            }
        }
        return fieldMappingArray;
    }

    public Vector doBrowserInsightThumbnailQuery(int n, String[] stringArray, String[] stringArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2, int n5, int n6, Integer n7) {
        InsightBackendConnector.debugFile("in doBrowserInsightThumbnailQuery().", 2);
        Integer n8 = this.getCollectionTemplateID(n7);
        FieldMapping[] fieldMappingArray = this.getFieldMappings(stringArray, n8);
        FieldMapping[] fieldMappingArray2 = this.getFieldMappings(stringArray2, n8);
        InsightBackendConnector.debugFile("freeTextSearch: " + bl, 2);
        if (!bl && objectArray != null) {
            FieldCriterion fieldCriterion = null;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof String) continue;
                fieldCriterion = (FieldCriterion)objectArray[i];
                InsightBackendConnector.debugFile("fc.field: " + fieldCriterion.field, 2);
                InsightBackendConnector.debugFile("fc.field.fieldDisplayName: " + fieldCriterion.field.fieldDisplayName, 2);
                fieldCriterion.fieldMapping = this.getFieldMapping(fieldCriterion.field.fieldName, n8);
                fieldCriterion.field = null;
            }
        }
        return this.performThumbnailQuery(n, fieldMappingArray, fieldMappingArray2, objectArray, bl, n2, n3, n4, bl2, n5, n6, null, true);
    }

    public Vector performThumbnailQuery(int n, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2, int n5, int n6, IscrMap iscrMap, boolean bl3) {
        int n7;
        long l = System.currentTimeMillis();
        String[] stringArray = new String[fieldMappingArray.length];
        Field field = null;
        for (int i = 0; i < fieldMappingArray.length; ++i) {
            if (fieldMappingArray[i] == null || (field = fieldMappingArray[i].getFinalField()) == null) continue;
            stringArray[i] = field.fieldName;
        }
        String[] stringArray2 = new String[fieldMappingArray2.length];
        field = null;
        for (n7 = 0; n7 < fieldMappingArray2.length; ++n7) {
            if (fieldMappingArray2[n7] == null || (field = fieldMappingArray2[n7].getFinalField()) == null) continue;
            stringArray2[n7] = field.fieldName;
        }
        this.setSortFields(stringArray2);
        this.setThumbnailSize(n2);
        n7 = -3;
        n7 = bl ? this.beginFreeTextThumbnailQuery(n, stringArray, (String[])objectArray, n3, n4) : this.beginThumbnailQuery(n, stringArray, (FieldCriterion[])objectArray, n3, n4);
        this.debugOut("Version 2 time for query: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        Vector<InsightSmartClientResults> vector = new Vector<InsightSmartClientResults>(100);
        if (n7 == -1) {
            int n8 = 0;
            this.totalRecords = 0;
            while (bl2 && !this.endOfList() && n8 < n5) {
                ++n8;
                ++this.totalRecords;
                this.nextItem();
            }
            int n9 = 0;
            InsightSmartClientResults insightSmartClientResults = null;
            while (!(this.endOfList() || bl2 && n9 >= n6)) {
                int n10;
                insightSmartClientResults = new InsightSmartClientResults();
                insightSmartClientResults.fieldData = new String[stringArray.length];
                for (n10 = 0; n10 < stringArray.length; ++n10) {
                    insightSmartClientResults.fieldData[n10] = InsightDataAnchor.getPlainText(this.getText(n10));
                    if (insightSmartClientResults.fieldData[n10] == null || insightSmartClientResults.fieldData[n10].length() <= InsightSmartServicer.MAXIMUM_THUMBNAIL_FIELD_LENGTH) continue;
                    insightSmartClientResults.fieldData[n10] = insightSmartClientResults.fieldData[n10].substring(0, InsightSmartServicer.MAXIMUM_THUMBNAIL_FIELD_LENGTH);
                }
                insightSmartClientResults.sortString = "";
                if (stringArray2 != null) {
                    for (n10 = 0; n10 < stringArray2.length; ++n10) {
                        insightSmartClientResults.sortString = insightSmartClientResults.sortString + TrinityConnector.convertSortValue(this.getSortText(n10));
                    }
                }
                insightSmartClientResults.thumbnailURL = this.getThumbnail();
                insightSmartClientResults.imageID = this.getImageID();
                insightSmartClientResults.objectID = this.getObjectID();
                insightSmartClientResults.mediaType = this.getMediaType();
                insightSmartClientResults.thumbDimension = new Dimension(this.getImageWidth(), this.getImageHeight());
                insightSmartClientResults.hasMviSeries = this.hasMviSeries();
                insightSmartClientResults.hasMpdSeries = this.hasMpdSeries();
                insightSmartClientResults.iscrLocale = this.collectionLocale;
                insightSmartClientResults.absoluteOrder = this.getAbsoluteOrder();
                if (!vector.contains(insightSmartClientResults)) {
                    vector.addElement(insightSmartClientResults);
                    ++n9;
                    ++this.totalRecords;
                }
                this.nextItem();
            }
            while (bl2 && !this.endOfList()) {
                ++this.totalRecords;
                this.nextItem();
            }
            this.debugOut("Version 2 time for creating ISCR results: " + (System.currentTimeMillis() - l));
        } else {
            this.debugOut("cannot open group.  Error code = " + n7 + ", wanted " + -1);
        }
        this.closeSearchDBConnector();
        Collections.sort(vector);
        return vector;
    }

    public int beginFreeTextThumbnailQuery(int n, String[] stringArray, String[] stringArray2) {
        return this.beginFreeTextThumbnailQuery(n, stringArray, stringArray2, 1, 1);
    }

    public int beginFreeTextThumbnailQuery(int n, String[] stringArray, String[] stringArray2, int n2, int n3) {
        int n4;
        this.fields = (String[])stringArray.clone();
        this.underscoreFields();
        if (this.searchDatabaseConnector != null) {
            this.searchDatabaseConnector.close();
        }
        this.searchDatabaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        String string = this.createOrderBy(this.sortFields);
        String string2 = this.IG_TABLE_GROUP_IMAGE_MAP + ".AbsoluteOrder, ";
        if (string.length() > 0) {
            string2 = string2 + string + ", ";
        }
        string2 = string2 + this.IG_TABLE_GROUP_IMAGE_MAP + ".ImageID, " + this.IG_TABLE_GROUP_IMAGE_MAP + ".MviSeries, " + this.IG_TABLE_GROUP_IMAGE_MAP + ".MpdSeries";
        sqlQueryGenerator.setOrderBy(string2);
        String string3 = "";
        String string4 = this.createKeywordClause(stringArray2, this.IG_TABLE_OBJECTS);
        if (string4.length() > 0) {
            string3 = string3 + "(" + string4 + ") AND ";
        }
        string3 = string3 + "(" + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + this.requestedThumbnailSize + ")";
        string3 = string3 + " AND " + this.constructVirtualGroupQuery(this.IG_TABLE_GROUPS, n);
        sqlQueryGenerator.appendToWhere(string3);
        SqlTable sqlTable = new SqlTable(this.IG_TABLE_OBJECTS);
        String string5 = null;
        for (n4 = 0; n4 < this.sortFields.length; ++n4) {
            string5 = this.sortFields[n4];
            if (string5 == null) continue;
            sqlTable.addColumnSelection(string5);
        }
        string5 = null;
        for (n4 = 0; n4 < this.fields.length; ++n4) {
            string5 = this.fields[n4];
            if (string5 == null) continue;
            sqlTable.addColumnSelection(string5);
        }
        sqlTable.addColumnSelection("ObjectID");
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword(this.distinctKeyword);
        }
        sqlQueryGenerator.addTable(sqlTable);
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"ImageID", "FileName", "MediaType", "Width AS ThumbWidth", "Height AS ThumbHeight"});
        sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, STRING_WILDCARD);
        sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, new String[0]);
        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[0]);
        sqlQueryGenerator.addJoin(this.IG_TABLE_GROUPS, this.IG_TABLE_GROUP_IMAGE_MAP, new String[]{"GroupID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_OBJECT_IMAGE_MAP, new String[]{"ImageID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECT_IMAGE_MAP, this.IG_TABLE_OBJECTS, new String[]{"ObjectID"}, 0);
        int n5 = n4 = n2 >= 0 || n3 >= 0 ? 1 : 0;
        if (n4 != 0) {
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3);
        }
        this.searchDatabaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("Free text thunbnail query:\n" + this.searchDatabaseConnector.getQuery());
        this.searchDatabaseConnector.runQuery();
        if (this.searchDatabaseConnector.more()) {
            this.debugOut("at least one record matches.");
        }
        return -1;
    }

    public int beginThumbnailQuery(int n, String[] stringArray) {
        return this.beginThumbnailQuery(n, stringArray, null);
    }

    public int beginThumbnailQuery(String[] stringArray) {
        return this.beginThumbnailQuery(this.groupID, stringArray, null);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, FieldCriterion[] fieldCriterionArray) {
        return this.beginThumbnailQuery(n, stringArray, fieldCriterionArray, 1, 1);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, int n2, int n3) {
        return this.beginThumbnailQuery(n, stringArray, null, n2, n3);
    }

    public int beginThumbnailQuery(int n, String[] stringArray, FieldCriterion[] fieldCriterionArray, int n2, int n3) {
        int n4;
        Object object;
        this.fields = (String[])stringArray.clone();
        this.underscoreFields();
        if (this.searchDatabaseConnector != null) {
            this.searchDatabaseConnector.close();
        }
        this.searchDatabaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        String string = this.createOrderBy(this.sortFields);
        String string2 = this.IG_TABLE_GROUP_IMAGE_MAP + ".AbsoluteOrder, ";
        if (string.length() > 0) {
            string2 = string2 + string + ", ";
        }
        string2 = string2 + this.IG_TABLE_GROUP_IMAGE_MAP + ".ImageID, " + this.IG_TABLE_GROUP_IMAGE_MAP + ".MviSeries, " + this.IG_TABLE_GROUP_IMAGE_MAP + ".MpdSeries";
        sqlQueryGenerator.setOrderBy(string2);
        String string3 = "";
        boolean bl = false;
        if (fieldCriterionArray != null && fieldCriterionArray.length > 0) {
            object = this.createCriteriaClause(fieldCriterionArray);
            this.debugOut("Criteria string: " + (String)object);
            if (((String)object).length() > 0) {
                string3 = string3 + "(" + (String)object + ") AND ";
                bl = true;
            }
        }
        string3 = string3 + "(" + this.IG_TABLE_IMAGE_FILES + ".ResolutionSize = " + this.requestedThumbnailSize + ")";
        string3 = string3 + " AND " + this.constructVirtualGroupQuery(this.IG_TABLE_GROUPS, n);
        sqlQueryGenerator.appendToWhere(string3);
        object = new SqlTable(this.IG_TABLE_OBJECTS);
        String string4 = null;
        for (n4 = 0; n4 < this.sortFields.length; ++n4) {
            string4 = this.sortFields[n4];
            if (string4 == null) continue;
            ((SqlTable)object).addColumnSelection(string4);
        }
        string4 = null;
        for (n4 = 0; n4 < this.fields.length; ++n4) {
            string4 = this.fields[n4];
            if (string4 == null) continue;
            ((SqlTable)object).addColumnSelection(string4);
        }
        ((SqlTable)object).addColumnSelection("ObjectID");
        if (this.useDistinctKeyword) {
            sqlQueryGenerator.setDistinctKeyword(this.distinctKeyword);
        }
        sqlQueryGenerator.addTable((SqlTable)object);
        sqlQueryGenerator.addTable(this.IG_TABLE_IMAGE_FILES, null, new String[]{"ImageID", "FileName", "MediaType", "Width AS ThumbWidth", "Height AS ThumbHeight"});
        sqlQueryGenerator.addTable(this.IG_TABLE_GROUP_IMAGE_MAP, null, STRING_WILDCARD);
        sqlQueryGenerator.addTable(this.IG_TABLE_GROUPS, null, new String[0]);
        sqlQueryGenerator.addTable(this.IG_TABLE_OBJECT_IMAGE_MAP, null, new String[0]);
        sqlQueryGenerator.addJoin(this.IG_TABLE_GROUPS, this.IG_TABLE_GROUP_IMAGE_MAP, new String[]{"GroupID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_OBJECT_IMAGE_MAP, new String[]{"ImageID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_GROUP_IMAGE_MAP, this.IG_TABLE_IMAGE_FILES, new String[]{"ImageID"}, 0);
        sqlQueryGenerator.addJoin(this.IG_TABLE_OBJECT_IMAGE_MAP, this.IG_TABLE_OBJECTS, new String[]{"ObjectID"}, 0);
        int n5 = n4 = n2 >= 0 || n3 >= 0 ? 1 : 0;
        if (n4 != 0) {
            sqlQueryGenerator.addTable(this.IG_TABLE_LPS, null, "LPS");
            sqlQueryGenerator.addTable(this.IG_TABLE_SPS, null, "URL");
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_LPS, new String[]{"LPSid"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_IMAGE_FILES, this.IG_TABLE_SPS, new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.addJoin(this.IG_TABLE_SPS, this.IG_TABLE_PROFILE, new String[]{"SPSNum"}, 0);
            sqlQueryGenerator.appendToWhere(this.IG_TABLE_PROFILE + ".ProfileId = " + n2 + " AND " + this.IG_TABLE_PROFILE + ".CollectionId = " + n3);
        }
        if (bl || fieldCriterionArray.length == 0) {
            this.searchDatabaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Thumbnail query:\n" + this.searchDatabaseConnector.getQuery());
            this.searchDatabaseConnector.runQuery();
            if (this.searchDatabaseConnector.more()) {
                this.debugOut("at least one record matches.");
            } else {
                this.debugOut("no matching records found.");
            }
        }
        return -1;
    }

    public int firstItem() {
        try {
            this.searchDatabaseConnector.first();
            return -1;
        }
        catch (Exception exception) {
            return -3;
        }
    }

    public int nextItem() {
        try {
            this.searchDatabaseConnector.next();
            return -1;
        }
        catch (Exception exception) {
            return -3;
        }
    }

    public int moveTo(int n) {
        try {
            this.searchDatabaseConnector.first();
            for (int i = 0; i < n; ++i) {
                if (!this.searchDatabaseConnector.more()) {
                    return -4;
                }
                this.searchDatabaseConnector.next();
            }
            return -1;
        }
        catch (Exception exception) {
            return -3;
        }
    }

    public boolean endOfList() {
        return !this.searchDatabaseConnector.more();
    }

    public void closeSearchDBConnector() {
        if (this.searchDatabaseConnector != null) {
            this.searchDatabaseConnector.close();
            this.searchDatabaseConnector = null;
        }
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public long getObjectID() {
        long l = 0L;
        try {
            l = this.searchDatabaseConnector.getLongField("ObjectID");
        }
        catch (Exception exception) {
            l = 0L;
            this.debugOut("Exception in getObjectID(): " + exception);
        }
        return l;
    }

    public long getImageID() {
        try {
            return Long.parseLong(this.searchDatabaseConnector.getFieldByName("ImageID"));
        }
        catch (Exception exception) {
            this.debugOut("error in getImageID.");
            return -1L;
        }
    }

    public long getImageRef() {
        return this.getImageID();
    }

    public int getMediaType() {
        int n = 0;
        try {
            n = this.searchDatabaseConnector.getIntegerFieldByName("MediaType");
        }
        catch (Exception exception) {
            n = 0;
            this.debugOut("Exception in getMediaType(): " + exception);
        }
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public int getAbsoluteOrder() {
        int n = 0;
        try {
            n = this.searchDatabaseConnector.getIntegerField("AbsoluteOrder");
        }
        catch (Exception exception) {
            n = 0;
            this.debugOut("Exception in getAbsoluteOrder(): " + exception);
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public boolean hasMviSeries() {
        try {
            return this.searchDatabaseConnector.getIntegerFieldByName("MviSeries") == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasMpdSeries() {
        try {
            return this.searchDatabaseConnector.getIntegerFieldByName("MpdSeries") == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getText(int n) {
        try {
            if (this.fields[n].equalsIgnoreCase("Width")) {
                return this.searchDatabaseConnector.getFieldByName("ObjectWidth");
            }
            if (this.fields[n].equalsIgnoreCase("Height")) {
                return this.searchDatabaseConnector.getFieldByName("ObjectHeight");
            }
            return this.searchDatabaseConnector.getFieldByName(this.fields[n]);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getSortText(int n) {
        try {
            if (this.sortFields[n].equalsIgnoreCase("Width")) {
                return this.searchDatabaseConnector.getFieldByName("ObjectWidth");
            }
            if (this.sortFields[n].equalsIgnoreCase("Height")) {
                return this.searchDatabaseConnector.getFieldByName("ObjectHeight");
            }
            return this.searchDatabaseConnector.getFieldByName(this.sortFields[n]);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getThumbnail() {
        try {
            String string = this.getMediaUrl(this.searchDatabaseConnector);
            return string;
        }
        catch (Exception exception) {
            this.debugOut("error in getThumbnail.");
            return "Error: InsightBackendConnector/getThumbnail().";
        }
    }

    public int getImageWidth() {
        try {
            return Integer.parseInt(this.searchDatabaseConnector.getFieldByName("ThumbWidth"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getImageHeight() {
        try {
            return Integer.parseInt(this.searchDatabaseConnector.getFieldByName("ThumbHeight"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected String createCriteriaClause(FieldCriterion[] fieldCriterionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fieldCriterionArray != null) {
            FieldCriterion fieldCriterion = null;
            for (int i = 0; i < fieldCriterionArray.length; ++i) {
                Object object;
                Cloneable cloneable;
                fieldCriterion = fieldCriterionArray[i];
                if (fieldCriterion != null && fieldCriterion instanceof ObjectIndicatorFieldCriterion) {
                    cloneable = (ObjectIndicatorFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((ObjectIndicatorFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ObjectID = " + ((ObjectIndicatorFieldCriterion)cloneable).getObjectID() + " AND " + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = " + ((ObjectIndicatorFieldCriterion)cloneable).getImageID() + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof MviFieldCriterion) {
                    cloneable = (MviFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((MviFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_GROUP_IMAGE_MAP + ".MviSeries = 1)");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof MpdFieldCriterion) {
                    cloneable = (MpdFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((MpdFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_GROUP_IMAGE_MAP + ".MpdSeries = 1)");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof AudioFieldCriterion) {
                    cloneable = (AudioFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((AudioFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 2 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof VideoFieldCriterion) {
                    cloneable = (VideoFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((VideoFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 3 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof QtvrFieldCriterion) {
                    cloneable = (QtvrFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((QtvrFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 4 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof MiscFieldCriterion) {
                    cloneable = (MiscFieldCriterion)fieldCriterion;
                    if (stringBuffer.length() > 0) {
                        if (((MiscFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + this.IG_TABLE_IMAGE_FILES + ".MediaType = " + 5 + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof FuzzyDateFieldCriterion && fieldCriterion.fieldMapping != null) {
                    cloneable = (FuzzyDateFieldCriterion)fieldCriterion;
                    if (!this.supportsFuzzyDates) continue;
                    Vector vector = fieldCriterion.fieldMapping.getFinalFields();
                    object = "";
                    if (vector != null) {
                        Field field = null;
                        for (int j = 0; j < vector.size(); ++j) {
                            field = (Field)vector.elementAt(j);
                            if (field == null || !field.date) continue;
                            object = (String)object + "(" + this.convertFieldName(field.fieldName + FUZZY_DATE_FIELD_START_SUFFIX) + " >= " + ((FuzzyDateFieldCriterion)cloneable).getStartJulian() + " AND " + this.convertFieldName(field.fieldName + FUZZY_DATE_FIELD_END_SUFFIX) + " <= " + ((FuzzyDateFieldCriterion)cloneable).getEndJulian() + ")";
                        }
                    }
                    if (((String)object).length() <= 0) continue;
                    if (stringBuffer.length() > 0) {
                        if (((FuzzyDateFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append("(" + (String)object + ")");
                    continue;
                }
                if (fieldCriterion != null && fieldCriterion instanceof LinkFieldCriterion && (fieldCriterion.relationship != 0 || ((LinkFieldCriterion)fieldCriterion).getFuzzyDateJulianRange() != null) && fieldCriterion.fieldMapping != null && fieldCriterion.fieldMapping instanceof LinkFieldMapping) {
                    cloneable = (LinkFieldCriterion)fieldCriterion;
                    String string = "";
                    if (((LinkFieldCriterion)cloneable).getFuzzyDateJulianRange() != null) {
                        if (((LinkFieldCriterion)cloneable).fieldMapping.isFuzzyDateSearchable()) {
                            object = this.underscoreFieldName(fieldCriterion.fieldMapping.fieldName);
                            string = "(" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = ANY (" + "SELECT ImageID FROM " + "IRLINKREPOSITORY" + " WHERE " + this.createLinkCodeClause(((LinkFieldCriterion)cloneable).getCollectionKey(), ((LinkFieldCriterion)cloneable).getClientIP(), ((LinkFieldCriterion)cloneable).getLocalClientIP(), ((LinkFieldCriterion)cloneable).getUserGroupShells()) + " AND " + (String)object + FUZZY_DATE_FIELD_START_SUFFIX + " >= " + ((LinkFieldCriterion)cloneable).getFuzzyDateJulianRange().getStartJulian() + " AND " + (String)object + FUZZY_DATE_FIELD_END_SUFFIX + " <= " + ((LinkFieldCriterion)cloneable).getFuzzyDateJulianRange().getEndJulian() + "))";
                        }
                    } else {
                        object = this.useLowerCaseCommand ? "(LOWER(" + this.underscoreFieldName(fieldCriterion.fieldMapping.fieldName) + "))" : "(" + this.underscoreFieldName(fieldCriterion.fieldMapping.fieldName) + ")";
                        boolean bl = false;
                        String string2 = this.escapeSpecialCharacters(fieldCriterion.equivalence.getSearchValue());
                        if (this.useLowerCaseCommand) {
                            if (string2 == null) {
                                string2 = "LOWER('" + string2 + "')";
                            } else if (this.useLowerCaseCommandOnSearchValue) {
                                bl = true;
                            } else {
                                string2 = string2.toLowerCase();
                            }
                        }
                        string = "(" + this.IG_TABLE_OBJECT_IMAGE_MAP + ".ImageID = ANY (" + "SELECT ImageID FROM " + "IRLINKREPOSITORY" + " WHERE " + this.createLinkCodeClause(((LinkFieldCriterion)cloneable).getCollectionKey(), ((LinkFieldCriterion)cloneable).getClientIP(), ((LinkFieldCriterion)cloneable).getLocalClientIP(), ((LinkFieldCriterion)cloneable).getUserGroupShells()) + " AND " + this.createEquivalenceRelationshipClause((String)object, 1, fieldCriterion.relationship, string2, bl) + "))";
                    }
                    if (string.length() <= 0) continue;
                    if (stringBuffer.length() > 0) {
                        if (((LinkFieldCriterion)cloneable).booleanOperator == 1) {
                            stringBuffer.append(" AND ");
                        } else {
                            stringBuffer.append(" OR ");
                        }
                    }
                    stringBuffer.append(string);
                    continue;
                }
                if (fieldCriterion == null || fieldCriterion.fieldMapping == null || fieldCriterion.relationship == 0 || (cloneable = fieldCriterion.fieldMapping.getFinalFields()) == null) continue;
                boolean bl = false;
                object = null;
                for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                    object = (Field)((Vector)cloneable).elementAt(j);
                    if (object == null || ((Field)object).fieldType == 0) continue;
                    if (!bl) {
                        if (stringBuffer.length() > 0) {
                            if (fieldCriterion.booleanOperator == 1) {
                                stringBuffer.append(" AND ");
                            } else {
                                stringBuffer.append(" OR ");
                            }
                        }
                        if (fieldCriterion.paren == 1) {
                            stringBuffer.append("(");
                        }
                        stringBuffer.append("(");
                        bl = true;
                    } else {
                        stringBuffer.append(" OR ");
                    }
                    String string = this.useLowerCaseCommand ? "(LOWER(" + this.convertFieldName(((Field)object).fieldName) + "))" : "(" + this.convertFieldName(((Field)object).fieldName) + ")";
                    boolean bl2 = false;
                    String string3 = this.escapeSpecialCharacters(fieldCriterion.equivalence.getSearchValue());
                    if (this.useLowerCaseCommand) {
                        if (string3 == null) {
                            string3 = "LOWER('" + string3 + "')";
                        } else if (this.useLowerCaseCommandOnSearchValue) {
                            bl2 = true;
                        } else {
                            string3 = string3.toLowerCase();
                        }
                    }
                    stringBuffer.append(this.createEquivalenceRelationshipClause(string, ((Field)object).fieldType, fieldCriterion.relationship, string3, bl2));
                }
                if (!bl) continue;
                stringBuffer.append(")");
                if (fieldCriterion.paren != 2) continue;
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    protected String createKeywordClause(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = true;
            StringTokenizer stringTokenizer = null;
            String string3 = this.IG_TABLE_KEYWORDS + ".ValueText";
            String string4 = null;
            if (this.useLowerCaseCommand) {
                string3 = "LOWER(" + string3 + ")";
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringTokenizer = new StringTokenizer(stringArray[i]);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!bl) {
                        stringBuffer.append(" AND ");
                    }
                    string4 = this.convertKeyword(stringTokenizer.nextToken());
                    boolean bl2 = false;
                    if (this.useLowerCaseCommand) {
                        if (string4 == null) {
                            string4 = "LOWER('" + string4 + "')";
                        } else if (this.useLowerCaseCommandOnSearchValue) {
                            bl2 = true;
                        } else {
                            string4 = string4.toLowerCase();
                        }
                    }
                    stringBuffer.append("(" + string2 + "ObjectID = ANY (SELECT " + this.IG_TABLE_REVERSE_LOOKUP + ".ObjectID FROM " + this.IG_TABLE_REVERSE_LOOKUP + ", " + this.IG_TABLE_KEYWORDS + " WHERE (" + this.IG_TABLE_REVERSE_LOOKUP + ".ValueID = " + this.IG_TABLE_KEYWORDS + ".ValueID) AND ");
                    if (bl2) {
                        stringBuffer.append("(" + string3 + " LIKE LOWER(" + this.prepStringForQuery(string4, false) + "))))");
                    } else {
                        stringBuffer.append("(" + string3 + " LIKE " + this.prepStringForQuery(string4, false) + ")))");
                    }
                    bl = false;
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextGroupId() {
        int n = 0;
        Object object = MAX_IDS_LOCK_OBJ;
        synchronized (object) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                databaseConnector.setQuery("SELECT MaxGroupID FROM " + this.IG_TABLE_MAX_IDS);
                databaseConnector.runQuery();
                n = databaseConnector.getIntegerFieldByName("MaxGroupID");
                databaseConnector.close();
                if (n <= 0) {
                    databaseConnector.setQuery("SELECT Max(GroupID) AS MaxGroupID FROM " + this.IG_TABLE_GROUPS);
                    databaseConnector.runQuery();
                    n = databaseConnector.getIntegerFieldByName("MaxGroupID");
                    databaseConnector.close();
                }
                databaseConnector.setQuery("UPDATE " + this.IG_TABLE_MAX_IDS + " Set MaxGroupID = " + ++n);
                databaseConnector.runUpdateQuery();
            }
            catch (Exception exception) {
                this.debugOut("Excetpion in getNextGroupId():\n" + InsightUtilities.getStackTrace(exception));
                n = -3;
            }
            databaseConnector.close();
        }
        return n;
    }

    public boolean getFuzzyDateSupport() {
        boolean bl = false;
        String string = "";
        Vector<String> vector = null;
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery("SELECT * FROM " + this.IG_TABLE_FIELDS + " WHERE IsDate = 1;");
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                vector = new Vector<String>();
                while (databaseConnector.more()) {
                    String string2 = databaseConnector.getFieldByName("FieldName");
                    vector.addElement(string2.replace(' ', '_') + FUZZY_DATE_FIELD_START_SUFFIX);
                    vector.addElement(string2.replace(' ', '_') + FUZZY_DATE_FIELD_END_SUFFIX);
                    databaseConnector.next();
                }
                bl = SqlQueryGenerator.doesColumnExist(databaseConnector2, vector, this.IG_TABLE_OBJECTS);
            } else {
                bl = false;
                string = "No date fields founds.";
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFuzzyDateSupport(), exc:\n" + InsightUtilities.convertStackTraceToString(exception));
            bl = false;
        }
        catch (Error error) {
            this.debugOut("Error in getFuzzyDateSupport(), err: " + InsightUtilities.convertStackTraceToString(error));
            bl = false;
        }
        databaseConnector.close();
        databaseConnector2.close();
        if (bl) {
            this.debugOut("Fuzzy dates supported.");
        } else {
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    if (string.length() == 0) {
                        string = string + "Field(s) ";
                    } else {
                        string = string + ", ";
                        if (i == vector.size() - 1) {
                            string = string + "or ";
                        }
                    }
                    string = string + this.IG_TABLE_OBJECTS + "." + vector.elementAt(i);
                }
                string = string + " are not defined.";
            }
            this.debugOut("Fuzzy dates not supported: " + string);
        }
        return bl;
    }

    public boolean containsLinkData(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            try {
                sqlQueryGenerator.addTable("IRLINKREPOSITORY", null, new String[]{"COUNT(*) AS LinkCount"});
                sqlQueryGenerator.appendToWhere("IRLINKREPOSITORY.LinkCode LIKE " + this.prepStringForQuery(string));
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Link data contains query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                bl = databaseConnector.getIntegerFieldByName("LinkCount") > 0;
            }
            catch (Exception exception) {
                this.debugOut("Exception in containsLinkData():\n" + InsightUtilities.convertStackTraceToString(exception));
            }
            databaseConnector.close();
        }
        return bl;
    }

    public void addMultipleLinkData(Vector vector, String string, LinkFieldStandard linkFieldStandard) {
        DatabaseConnector databaseConnector = null;
        for (int i = 0; vector != null && string != null && i < vector.size(); ++i) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            LinkData linkData = (LinkData)vector.elementAt(i);
            this.addLinkData(linkData, string, linkFieldStandard, databaseConnector);
        }
    }

    public boolean addLinkData(LinkData linkData, String string, LinkFieldStandard linkFieldStandard) {
        return this.addLinkData(linkData, string, linkFieldStandard, null);
    }

    public boolean addLinkData(LinkData linkData, String string, LinkFieldStandard linkFieldStandard, DatabaseConnector databaseConnector) {
        boolean bl = false;
        if (string != null && string.length() > 0 && linkData != null && linkData.getAuthorshipInfo() != null) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                this.removeSpecificLinkData(databaseConnector, string, linkData.getRegion(), linkData.getImageID());
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LinkCode", 1, stringBuffer2, string);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LinkTimeStamp", 1, stringBuffer2, System.currentTimeMillis() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LinkRegion", 1, stringBuffer2, InsightUtilities.convertRectToCleanString(linkData.getRegion()));
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, linkData.getImageID() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, linkData.getObjectID() + "");
                LinkAuthorshipInfo linkAuthorshipInfo = linkData.getAuthorshipInfo();
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("Author"), stringBuffer, stringBuffer2, linkAuthorshipInfo.getAuthor(), null);
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("Subject"), stringBuffer, stringBuffer2, linkAuthorshipInfo.getSubject(), null);
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("Category"), stringBuffer, stringBuffer2, linkAuthorshipInfo.getCategory(), null);
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("Organization"), stringBuffer, stringBuffer2, linkAuthorshipInfo.getOrganization(), null);
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("Email"), stringBuffer, stringBuffer2, linkAuthorshipInfo.getEmail(), null);
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("Username"), stringBuffer, stringBuffer2, linkAuthorshipInfo.getUsername(), null);
                this.evaluateLinkField(linkFieldStandard.getFieldMapping("DateStamp"), stringBuffer, stringBuffer2, null, new Long(linkAuthorshipInfo.getDateStamp()));
                if (linkData instanceof AnnotationLinkData) {
                    this.evaluateLinkField(linkFieldStandard.getFieldMapping("AnnotationText"), stringBuffer, stringBuffer2, ((AnnotationLinkData)linkData).getText(), null);
                }
                if (linkData instanceof WebLinkData) {
                    this.evaluateLinkField(linkFieldStandard.getFieldMapping("WebAddress"), stringBuffer, stringBuffer2, ((WebLinkData)linkData).getWebAddress(), null);
                }
                databaseConnector.setQuery("INSERT INTO IRLINKREPOSITORY (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Link data insert query:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                bl = true;
            }
            catch (Exception exception) {
                this.debugOut("Exception in addLinkData():\n" + InsightUtilities.convertStackTraceToString(exception));
            }
            databaseConnector.close();
        }
        return bl;
    }

    public void removeMultipleLinkData(Vector vector, String string) {
        DatabaseConnector databaseConnector = null;
        for (int i = 0; vector != null && string != null && i < vector.size(); ++i) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            LinkData linkData = (LinkData)vector.elementAt(i);
            this.removeSpecificLinkData(databaseConnector, string, linkData.getRegion(), linkData.getImageID());
        }
    }

    public boolean removeSpecificLinkData(String string, Rectangle rectangle, long l) {
        return this.removeSpecificLinkData(null, string, rectangle, l);
    }

    public boolean removeSpecificLinkData(DatabaseConnector databaseConnector, String string, Rectangle rectangle, long l) {
        return this.removeLinkData(databaseConnector, rectangle == null ? "" : string, rectangle, l);
    }

    public boolean removeLinkDataWithFragment(String string) {
        return this.removeLinkData(null, string == null ? "" : string, null, 0L, true);
    }

    public boolean removeLinkDataWithLinkCode(String string) {
        return this.removeLinkData(null, string == null ? "" : string, null, 0L);
    }

    public boolean removeAllLinkData() {
        return this.removeLinkData(null, null, null, 0L);
    }

    private boolean removeLinkData(DatabaseConnector databaseConnector, String string, Rectangle rectangle, long l) {
        return this.removeLinkData(databaseConnector, string, rectangle, l, false);
    }

    private boolean removeLinkData(DatabaseConnector databaseConnector, String string, Rectangle rectangle, long l, boolean bl) {
        boolean bl2 = false;
        String string2 = "DELETE FROM IRLINKREPOSITORY";
        String string3 = "";
        if (string == null && rectangle == null) {
            string3 = string2;
        } else if (string != null && string.length() > 0) {
            string2 = bl ? string2 + " WHERE LinkCode LIKE " + this.prepStringForQuery(STRING_WILDCARD + string + STRING_WILDCARD) : string2 + " WHERE LinkCode LIKE " + this.prepStringForQuery(string);
            if (rectangle != null) {
                string2 = string2 + " AND LinkRegion LIKE " + this.prepStringForQuery(InsightUtilities.convertRectToCleanString(rectangle));
                string2 = string2 + " AND ImageID = " + l;
            }
            string3 = string2;
        }
        if (string3.length() > 0) {
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            try {
                databaseConnector.setQuery(string3);
                this.debugOut("Remove link data query:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                bl2 = true;
            }
            catch (Exception exception) {
                this.debugOut("Exception in removeLinkData():\n" + InsightUtilities.convertStackTraceToString(exception));
            }
            databaseConnector.close();
        }
        return bl2;
    }

    private void evaluateLinkField(FieldMapping fieldMapping, StringBuffer stringBuffer, StringBuffer stringBuffer2, String string, Long l) {
        if (fieldMapping != null && fieldMapping instanceof LinkFieldMapping) {
            FuzzyDateJulianRange fuzzyDateJulianRange;
            String string2 = string;
            if (fieldMapping.isDate() && l != null) {
                string2 = InsightUtilities.formatDate(l);
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, fieldMapping.fieldName, 1, stringBuffer2, string2);
            if (fieldMapping.isFuzzyDateSearchable() && l != null && (fuzzyDateJulianRange = UcbFuzzyDateMachine.getFuzzyDateJulianRange(string2 = InsightUtilities.formatDate(l, 1))) != null) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, fieldMapping.fieldName + FUZZY_DATE_FIELD_START_SUFFIX, 2, stringBuffer2, fuzzyDateJulianRange.getStartJulian() + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, fieldMapping.fieldName + FUZZY_DATE_FIELD_END_SUFFIX, 2, stringBuffer2, fuzzyDateJulianRange.getEndJulian() + "");
            }
        }
    }

    public DatabaseConnector getDatabaseConnector() {
        return this.getDatabaseConnector(true);
    }

    public DatabaseConnector getDatabaseConnector(boolean bl) {
        return this.dbConnectorGenerator.getConnector(this.connectString, bl);
    }

    public SqlQueryGenerator getQueryGenerator() {
        return new SqlQueryGenerator(this.queryMode, this.globalEscapeDelimiter, this.unicodeFieldPrefix);
    }

    public SqlQueryGenerator getQueryGeneratorUtil() {
        return this.sqlQueryGeneratorUtil;
    }

    protected void quickQuery(String string) {
        this.debugOut("Quick-query:\n" + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in quickQuery: " + exception);
        }
        databaseConnector.close();
    }

    protected void quickUpdate(String string) {
        this.debugOut("Quick-update:\n" + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery(string);
            databaseConnector.runUpdateQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in quickUpdate: " + exception);
        }
        databaseConnector.close();
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }

    protected void newLine() {
        Debug.debugOut("", 3);
    }

    public ObjectDataRecord getFullObjectData(long l, FieldStandardsManager fieldStandardsManager, String string) {
        return null;
    }

    public MediaMetaData getFullMediaData(long l, int n) {
        return null;
    }

    public int getMaxResolutionSize(long l) {
        return -1;
    }

    protected Integer getCollectionTemplateID(Integer n) {
        Map map = FieldStandardsManager.getCollectionTemplateMap();
        if (map == null || map.get(n) == null) {
            map = this.setCollectionTemplateMap();
        }
        return (Integer)map.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map setCollectionTemplateMap() {
        Object object = FieldStandardsManager.FIELD_POOL_LOCK;
        synchronized (object) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, new String[]{"UniqueCollectionID", "NativeStandardID"});
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    hashMap.put(new Integer(databaseConnector.getIntegerField("UniqueCollectionID")), new Integer(databaseConnector.getIntegerField("NativeStandardID")));
                    databaseConnector.next();
                }
                if (FieldStandardsManager.isCacheCollectionTemplateMap()) {
                    FieldStandardsManager.setCollectionTemplateMap(hashMap);
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in setCollectionTemplateMap():\n" + InsightUtilities.getStackTrace(exception));
            }
            finally {
                if (databaseConnector != null) {
                    databaseConnector.close();
                }
            }
            return hashMap;
        }
    }
}

