/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.DynamicThumbnailDistribution;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.IscrMap;
import com.luna.insight.server.ObjectKeyWrapper;
import com.luna.insight.server.ThumbnailDistribution;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.ThumbnailTallyMark;
import com.luna.insight.server.backend.TrinityConnector;
import java.util.List;
import java.util.Vector;

public class ThumbnailResultCache {
    protected ThumbnailQuery thumbQuery;
    protected Vector results;
    protected IscrMap iscrMap;
    protected ThumbnailDistribution distribution;
    protected DynamicThumbnailDistribution dynamicDistribution;
    protected Integer uniqueCollectionID;

    public static void debugOut(String string) {
        Debug.debugOut("TRC: " + string);
    }

    public ThumbnailResultCache(Integer n, ThumbnailQuery thumbnailQuery) {
        this.thumbQuery = thumbnailQuery;
        this.uniqueCollectionID = n;
    }

    public void setIscrMap(IscrMap iscrMap) {
        this.iscrMap = iscrMap;
    }

    protected void setResults(Vector vector, int n) {
        this.results = vector;
        this.distribution = new ThumbnailDistribution();
        this.dynamicDistribution = new DynamicThumbnailDistribution(n);
        InsightSmartClientResults insightSmartClientResults = null;
        for (int i = 0; i < this.results.size(); ++i) {
            insightSmartClientResults = (InsightSmartClientResults)this.results.get(i);
            this.addThumbnail(insightSmartClientResults, true);
        }
    }

    public synchronized DynamicThumbnailDistribution getDynamicDistribution() {
        return this.dynamicDistribution;
    }

    public synchronized ThumbnailDistribution getDistribution() {
        return this.distribution;
    }

    public synchronized IscrMap getIscrMap() {
        return this.iscrMap;
    }

    public int getTotalCount() {
        if (this.distribution != null) {
            return this.distribution.totalCount;
        }
        if (this.results != null) {
            return this.results.size();
        }
        return 0;
    }

    public Vector getThumbnails(Vector vector) {
        Vector<InsightSmartClientResults> vector2 = new Vector<InsightSmartClientResults>();
        if (this.iscrMap != null) {
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)vector.get(i);
                InsightSmartClientResults insightSmartClientResults = this.iscrMap.getIscr(thumbnailTallyMark.getObjectID(), thumbnailTallyMark.getImageID(), thumbnailTallyMark.isMultiview(), thumbnailTallyMark.isMultipage(), 0);
                if (insightSmartClientResults == null) continue;
                vector2.add(insightSmartClientResults);
            }
        } else {
            InsightSmartClientResults insightSmartClientResults = null;
            for (int i = 0; i < this.results.size() && vector2.size() != vector.size(); ++i) {
                insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(i);
                int n = vector.indexOf(insightSmartClientResults);
                if (n <= -1) continue;
                vector2.addElement(insightSmartClientResults);
            }
        }
        return vector2;
    }

    public synchronized void replaceThumbnails(List list, List list2) {
        this.removeThumbnails(list);
        this.addThumbnails(list2);
    }

    protected synchronized void addThumbnails(List list) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            this.addThumbnail((InsightSmartClientResults)list.get(i), false);
        }
        this.dynamicDistribution.calculateBuckets();
    }

    protected synchronized void addThumbnail(InsightSmartClientResults insightSmartClientResults, boolean bl) {
        if (insightSmartClientResults != null) {
            insightSmartClientResults.institutionID = this.thumbQuery.getInstitutionID();
            insightSmartClientResults.collectionID = this.thumbQuery.getCollectionID();
            insightSmartClientResults.vcID = this.thumbQuery.getVCID();
            if (insightSmartClientResults.sortString == null || insightSmartClientResults.sortString.trim().length() == 0) {
                String string = insightSmartClientResults.sortString = insightSmartClientResults.absoluteOrder <= 0 ? " " : TrinityConnector.convertSortValue("" + insightSmartClientResults.absoluteOrder);
            }
            if (!bl) {
                InsightUtilities.addToSortedList(this.results, insightSmartClientResults);
            }
            ThumbnailTallyMark thumbnailTallyMark = new ThumbnailTallyMark(insightSmartClientResults.sortString, insightSmartClientResults);
            this.distribution.addTally(thumbnailTallyMark);
            this.dynamicDistribution.addTally(thumbnailTallyMark);
            if (this.iscrMap != null) {
                this.iscrMap.addIscr(insightSmartClientResults);
            }
            this.thumbQuery.resultCount = this.getTotalCount();
        }
    }

    public synchronized void addMultiviewThumbnail(long l, long l2, CollectionKey collectionKey) {
        ObjectKeyWrapper objectKeyWrapper = new ObjectKeyWrapper(l, l2, true, false, collectionKey);
        int n = this.results.indexOf(objectKeyWrapper);
        if (n == -1) {
            ObjectKeyWrapper objectKeyWrapper2 = new ObjectKeyWrapper(l, l2, false, false, collectionKey);
            n = this.results.indexOf(objectKeyWrapper2);
            if (n > -1) {
                InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.elementAt(n);
                InsightSmartClientResults insightSmartClientResults2 = (InsightSmartClientResults)insightSmartClientResults.clone();
                insightSmartClientResults2.hasMviSeries = true;
                this.results.insertElementAt(insightSmartClientResults2, n + 1);
                ThumbnailTallyMark thumbnailTallyMark = new ThumbnailTallyMark(insightSmartClientResults2.sortString, insightSmartClientResults2);
                this.distribution.addTally(thumbnailTallyMark, objectKeyWrapper2);
                this.dynamicDistribution.addTally(thumbnailTallyMark);
                this.iscrMap.addIscr(insightSmartClientResults2);
                this.thumbQuery.resultCount = this.getTotalCount();
            } else {
                ThumbnailResultCache.debugOut("in addMultiviewThumbnail().  The non-mvi thumbnail was not found.");
            }
        }
    }

    public synchronized void removeThumbnails(List list) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            this.removeThumbnails((Long)list.get(i));
        }
    }

    public synchronized void removeThumbnails(long l) {
        int n = 0;
        while (this.results != null && n < this.results.size()) {
            InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)this.results.get(n);
            if (insightSmartClientResults.getObjectID() == l) {
                this.results.remove(n);
                continue;
            }
            ++n;
        }
        if (this.iscrMap != null) {
            this.iscrMap.removeIscrs(l);
        }
        this.distribution.removeTally(l);
        this.dynamicDistribution.removeTally(l);
        this.thumbQuery.resultCount = this.getTotalCount();
    }

    public synchronized void removeMultiviewThumbnail(long l, long l2, CollectionKey collectionKey) {
        ObjectKeyWrapper objectKeyWrapper = new ObjectKeyWrapper(l, l2, true, false, collectionKey);
        int n = this.results.indexOf(objectKeyWrapper);
        if (n > -1) {
            this.results.removeElementAt(n);
            this.distribution.removeTally(objectKeyWrapper);
            this.dynamicDistribution.removeTally(objectKeyWrapper);
            if (this.iscrMap != null) {
                this.iscrMap.removeIscr(objectKeyWrapper);
            }
            this.thumbQuery.resultCount = this.getTotalCount();
        } else {
            ThumbnailResultCache.debugOut("in removeMultiviewThumbnail().  The target ISCR was not found.");
        }
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }
}

