/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.inscribe.EntityEquivalenceQuery;
import com.luna.insight.server.inscribe.EntitySearchQuery;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class ThumbnailQueryCache
implements Serializable {
    public static final long serialVersionUID = 3481304861061209290L;
    protected Vector queryCache = new Vector();
    protected Vector esqCache = new Vector();
    protected EntityEquivalenceQuery equivCache = null;

    public static void debugOut(String string) {
        ThumbnailQueryCache.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ThumbnailQueryCache: " + string, n);
    }

    public ThumbnailQuery getThumbnailQuery(ThumbnailQuery thumbnailQuery) {
        ThumbnailQuery thumbnailQuery2 = null;
        int n = this.queryCache.indexOf(thumbnailQuery);
        if (n > -1) {
            thumbnailQuery2 = (ThumbnailQuery)this.queryCache.elementAt(n);
        }
        return thumbnailQuery2;
    }

    public ThumbnailQuery getThumbnailQuery(int n) {
        for (int i = 0; i < this.queryCache.size(); ++i) {
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)this.queryCache.elementAt(i);
            if (thumbnailQuery.getGroupID() != n) continue;
            return thumbnailQuery;
        }
        return null;
    }

    public Vector getThumbnailQueries() {
        return this.queryCache;
    }

    public Vector getThumbnailQueries(int n) {
        Vector<ThumbnailQuery> vector = new Vector<ThumbnailQuery>();
        for (int i = 0; i < this.queryCache.size(); ++i) {
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)this.queryCache.elementAt(i);
            if (thumbnailQuery.getGroupID() != n) continue;
            vector.addElement(thumbnailQuery);
        }
        return vector;
    }

    public ThumbnailQuery getMatchingFieldsThumbnailQuery(ThumbnailQuery thumbnailQuery) {
        for (int i = 0; thumbnailQuery != null && this.queryCache != null && i < this.queryCache.size(); ++i) {
            ThumbnailQuery thumbnailQuery2 = (ThumbnailQuery)this.queryCache.elementAt(i);
            if (thumbnailQuery2.criteria != null && thumbnailQuery2.criteria.length != 0 || !thumbnailQuery.captionFieldsEqual(thumbnailQuery2.captionFields) || !InsightUtilities.arraysEqual(thumbnailQuery2.sortFields, thumbnailQuery.sortFields) || thumbnailQuery2.thumbnailSize != thumbnailQuery.thumbnailSize || !CollectionKeyDistributor.keysAgree(thumbnailQuery2, thumbnailQuery)) continue;
            return thumbnailQuery2;
        }
        return null;
    }

    public void addThumbnailQuery(ThumbnailQuery thumbnailQuery) {
        this.addThumbnailQuery(thumbnailQuery, false);
    }

    public void addThumbnailQuery(ThumbnailQuery thumbnailQuery, boolean bl) {
        if (thumbnailQuery == null || thumbnailQuery.refuseResultCache()) {
            return;
        }
        ThumbnailQueryCache.debugOut("in addThumbnailQuery().");
        int n = -1;
        if (bl) {
            for (int i = 0; i < this.queryCache.size(); ++i) {
                ThumbnailQuery thumbnailQuery2 = (ThumbnailQuery)this.queryCache.elementAt(i);
                if (thumbnailQuery2.getGroupID() != thumbnailQuery.getGroupID()) continue;
                n = i;
                break;
            }
        } else {
            n = this.queryCache.indexOf(thumbnailQuery);
        }
        if (n > -1) {
            this.queryCache.setElementAt(thumbnailQuery, n);
        } else {
            this.queryCache.addElement(thumbnailQuery);
        }
        ThumbnailQueryCache.debugOut("Query cache has " + this.queryCache.size() + " thumbnail cache(s).");
    }

    public boolean removeThumbnailQuery(int n) {
        for (int i = 0; i < this.queryCache.size(); ++i) {
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)this.queryCache.elementAt(i);
            if (thumbnailQuery.getGroupID() != n) continue;
            this.queryCache.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void clearThumbnailQueries(int n) {
        if (this.queryCache == null) {
            return;
        }
        Iterator iterator = this.queryCache.iterator();
        while (iterator.hasNext()) {
            if (((ThumbnailQuery)iterator.next()).getGroupID() != n) continue;
            iterator.remove();
        }
    }

    public void clearThumbnailQueries() {
        try {
            int n = 0;
            while (this.queryCache != null && n < this.queryCache.size()) {
                if (this.queryCache.get(n) instanceof ThumbnailQuery) {
                    this.queryCache.remove(n);
                    continue;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addEntitySearchQuery(EntitySearchQuery entitySearchQuery) {
        if (entitySearchQuery != null) {
            ThumbnailQueryCache.debugOut("in addEntitySearchQuery().");
            int n = this.esqCache.indexOf(entitySearchQuery);
            if (n > -1) {
                this.esqCache.setElementAt(entitySearchQuery, n);
            } else {
                this.esqCache.addElement(entitySearchQuery);
            }
        }
        ThumbnailQueryCache.debugOut("Query cache has " + this.esqCache.size() + " thumbnail cache(s).");
    }

    public EntitySearchQuery getEntitySearchQuery(EntitySearchQuery entitySearchQuery) {
        if (entitySearchQuery != null) {
            EntitySearchQuery entitySearchQuery2 = null;
            int n = this.esqCache.indexOf(entitySearchQuery);
            if (n > -1) {
                entitySearchQuery2 = (EntitySearchQuery)this.esqCache.elementAt(n);
            }
            return entitySearchQuery2;
        }
        return null;
    }

    public EntityEquivalenceQuery getEntityEquivalenceQuery() {
        return this.equivCache;
    }

    public void setEntityEquivalenceQuery(EntityEquivalenceQuery entityEquivalenceQuery) {
        this.equivCache = entityEquivalenceQuery;
    }

    public void clearEntitySearchQueries() {
        try {
            int n = 0;
            while (this.esqCache != null && n < this.esqCache.size()) {
                if (this.esqCache.get(n) instanceof EntitySearchQuery) {
                    this.esqCache.remove(n);
                    continue;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

