/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.CSVLogger;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.KeywordsFieldCriterion;
import com.luna.insight.server.MediaFetchFieldCriterion;
import com.luna.insight.server.ThumbnailQueryLogger;
import com.luna.insight.server.ThumbnailResultCache;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class ThumbnailQuery
implements CollectionKey,
Serializable {
    static final long serialVersionUID = -8452408123576256825L;
    public String institutionID;
    public String collectionID;
    public String vcID;
    public String collectionName = "Collection Name";
    public int groupID;
    public FieldMapping[] captionFields;
    public FieldMapping[] sortFields;
    public Object[] criteria = new FieldCriterion[0];
    public boolean freeTextSearch = false;
    public boolean absoluteOrdering = false;
    public int thumbnailSize;
    public int profileID;
    public int userCollection;
    public boolean excludeSps = false;
    public boolean refuseResultCache = false;
    public int start = 0;
    public int length = 50;
    public int resultCount = 0;
    protected transient ThumbnailResultCache queryResults;

    public static void debugOut(String string) {
        ThumbnailQuery.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ThumbnailQuery: " + string, n);
    }

    public static boolean isKeywordsFieldSearch(Object[] objectArray) {
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof KeywordsFieldCriterion)) continue;
            return true;
        }
        return false;
    }

    public ThumbnailQuery(CollectionKey collectionKey, String string, int n, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2) {
        this(collectionKey, string, n, fieldMappingArray, fieldMappingArray2, objectArray, bl, n2, n3, n4, bl2, false);
    }

    public ThumbnailQuery(CollectionKey collectionKey, String string, int n, FieldMapping[] fieldMappingArray, FieldMapping[] fieldMappingArray2, Object[] objectArray, boolean bl, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        this.institutionID = collectionKey.getInstitutionID();
        this.collectionID = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
        this.collectionName = string;
        this.groupID = n;
        this.captionFields = fieldMappingArray;
        this.sortFields = fieldMappingArray2;
        this.criteria = objectArray;
        this.freeTextSearch = bl;
        this.thumbnailSize = n2;
        this.profileID = n3;
        this.userCollection = n4;
        this.refuseResultCache = bl2;
        this.absoluteOrdering = bl3;
    }

    public ThumbnailQuery(CollectionKey collectionKey, int n, int n2, int n3, int n4, boolean bl) {
        this.institutionID = collectionKey.getInstitutionID();
        this.collectionID = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
        this.groupID = n;
        this.thumbnailSize = n2;
        this.profileID = n3;
        this.userCollection = n4;
        this.refuseResultCache = bl;
        this.absoluteOrdering = false;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public FieldMapping[] getCaptionFields() {
        return this.captionFields;
    }

    public FieldMapping[] getSortFields() {
        return this.sortFields;
    }

    public Object[] getCriteria() {
        return this.criteria;
    }

    public boolean isFreeTextSearch() {
        return this.freeTextSearch;
    }

    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public ThumbnailResultCache getThumbnailResultCache() {
        return this.queryResults;
    }

    public boolean excludeSps() {
        return false;
    }

    public boolean refuseResultCache() {
        return this.refuseResultCache;
    }

    public int getProfileID() {
        return this.getProfileID(true);
    }

    public int getProfileID(boolean bl) {
        if (bl && this.excludeSps()) {
            return -1;
        }
        return this.profileID;
    }

    public int getUserCollection() {
        return this.getUserCollection(true);
    }

    public int getUserCollection(boolean bl) {
        if (bl && this.excludeSps()) {
            return -1;
        }
        return this.userCollection;
    }

    public void setThumbnailResultCache(ThumbnailResultCache thumbnailResultCache) {
        this.queryResults = thumbnailResultCache;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setResultCount(int n) {
        this.resultCount = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ThumbnailQuery) {
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)object;
            return this.groupID == thumbnailQuery.groupID && this.thumbnailSize == thumbnailQuery.thumbnailSize && this.freeTextSearch == thumbnailQuery.freeTextSearch && CollectionKeyDistributor.keysAgree(this, thumbnailQuery) && this.captionFieldsEqual(thumbnailQuery.captionFields) && InsightUtilities.arraysEqual(this.sortFields, thumbnailQuery.sortFields) && InsightUtilities.arraysEqual(this.criteria, thumbnailQuery.criteria);
        }
        return super.equals(object);
    }

    protected boolean captionFieldsEqual(FieldMapping[] fieldMappingArray) {
        if (this.captionFields != null && fieldMappingArray != null && this.captionFields.length == fieldMappingArray.length) {
            for (int i = 0; i < this.captionFields.length; ++i) {
                if (this.captionFields[i] == null && fieldMappingArray[i] != null || this.captionFields[i] != null && fieldMappingArray[i] == null) {
                    return false;
                }
                if (this.captionFields[i] == null || fieldMappingArray[i] == null || this.captionFields[i].fieldID == 0 || this.captionFields[i].equals(fieldMappingArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[InstID: " + this.institutionID + "]" + "-[CollID: " + this.collectionID + "]" + "-[VcID: " + this.vcID + "]" + "-[ProfileID: " + this.profileID + "]");
        stringBuffer.append("\nSearch group ID: " + this.groupID);
        if (this.freeTextSearch) {
            stringBuffer.append("\nKeywords: ");
            if (this.criteria != null && this.criteria.length > 0) {
                for (int i = 0; this.criteria != null && i < this.criteria.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("\"" + this.criteria[i] + "\"");
                }
            } else {
                stringBuffer.append("NO KEYWORDS SPECIFIED");
            }
        } else {
            stringBuffer.append("\nSearch criteria: ");
            if (this.criteria != null && this.criteria.length > 0) {
                for (int i = 0; this.criteria != null && i < this.criteria.length; ++i) {
                    stringBuffer.append("\n" + this.criteria[i]);
                }
            } else {
                stringBuffer.append("NO SEARCH CRITERIA SPECIFIED");
            }
        }
        if (this.queryResults != null && this.queryResults.getDistribution() != null) {
            stringBuffer.append("\nResult count: " + this.queryResults.getDistribution().totalCount);
        } else {
            stringBuffer.append("\nResult count: " + this.resultCount);
        }
        return stringBuffer.toString();
    }

    public void toCsvString(Writer writer) throws IOException {
        CSVLogger.write(writer, this.collectionID);
        CSVLogger.write(writer, this.institutionID);
        CSVLogger.write(writer, this.vcID);
        CSVLogger.write(writer, this.profileID + "");
        CSVLogger.write(writer, this.groupID + "");
        if (this.queryResults != null && this.queryResults.getDistribution() != null) {
            CSVLogger.write(writer, this.queryResults.getDistribution().totalCount + "");
        } else {
            CSVLogger.write(writer, this.resultCount + "");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Object object = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        Object object2 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        Object object3 = "";
        if (this.freeTextSearch) {
            string = "Keyword";
            if (this.criteria != null && this.criteria.length > 0) {
                for (int i = 0; this.criteria != null && i < this.criteria.length && i < ThumbnailQueryLogger.MAX_CRITERIA_COUNT; ++i) {
                    string = "Field Relation Value";
                    String string15 = (String)this.criteria[i];
                    if (i == 0) {
                        string5 = "KEYWORDS";
                        object = string15;
                        continue;
                    }
                    if (i == 1) {
                        string7 = "AND";
                        string9 = "KEYWORDS";
                        object2 = string15;
                        continue;
                    }
                    if (i != 2) continue;
                    string11 = "AND";
                    string13 = "KEYWORDS";
                    object3 = string15;
                }
            }
        } else if (this.criteria != null && this.criteria.length > 0) {
            for (int i = 0; this.criteria != null && i < this.criteria.length && i < ThumbnailQueryLogger.MAX_CRITERIA_COUNT; ++i) {
                Object object4;
                if (this.criteria[i] instanceof MediaFetchFieldCriterion) {
                    string = "Media Fetch";
                    object4 = (MediaFetchFieldCriterion)this.criteria[i];
                    string3 = ((MediaFetchFieldCriterion)object4).getMediaTypeString();
                    continue;
                }
                if (this.criteria[i] instanceof KeywordsFieldCriterion) {
                    string = "Field Relation Value";
                    object4 = (KeywordsFieldCriterion)this.criteria[i];
                    if (i == 0) {
                        string5 = ((KeywordsFieldCriterion)object4).fieldMapping != null ? ((KeywordsFieldCriterion)object4).fieldMapping.fieldName : "KEYWORDS";
                        if (((KeywordsFieldCriterion)object4).relationship != 0) {
                            string6 = this.getRelationString(((KeywordsFieldCriterion)object4).relationship);
                        }
                        if (((KeywordsFieldCriterion)object4).equivalence == null) continue;
                        object = ((KeywordsFieldCriterion)object4).equivalence.toString() != null ? ((KeywordsFieldCriterion)object4).equivalence.toString() : "";
                        continue;
                    }
                    if (i == 1) {
                        string7 = ((KeywordsFieldCriterion)object4).booleanOperator == 0 ? "OR" : "AND";
                        string9 = ((KeywordsFieldCriterion)object4).fieldMapping != null ? ((KeywordsFieldCriterion)object4).fieldMapping.fieldName : "KEYWORDS";
                        if (((KeywordsFieldCriterion)object4).relationship != 0) {
                            string10 = this.getRelationString(((KeywordsFieldCriterion)object4).relationship);
                        }
                        if (((KeywordsFieldCriterion)object4).equivalence == null) continue;
                        object2 = ((KeywordsFieldCriterion)object4).equivalence.toString() != null ? ((KeywordsFieldCriterion)object4).equivalence.toString() : "";
                        continue;
                    }
                    if (i != 2) continue;
                    string11 = ((KeywordsFieldCriterion)object4).booleanOperator == 0 ? "OR" : "AND";
                    string13 = ((KeywordsFieldCriterion)object4).fieldMapping != null ? ((KeywordsFieldCriterion)object4).fieldMapping.fieldName : "KEYWORDS";
                    if (((KeywordsFieldCriterion)object4).relationship != 0) {
                        string14 = this.getRelationString(((KeywordsFieldCriterion)object4).relationship);
                    }
                    if (((KeywordsFieldCriterion)object4).equivalence == null) continue;
                    object3 = ((KeywordsFieldCriterion)object4).equivalence.toString() != null ? ((KeywordsFieldCriterion)object4).equivalence.toString() : "";
                    continue;
                }
                if (this.criteria[i] instanceof FieldCriterion) {
                    string = "Field Relation Value";
                    object4 = (FieldCriterion)this.criteria[i];
                    if (i == 0) {
                        if (((FieldCriterion)object4).fieldMapping != null) {
                            string4 = ((FieldCriterion)object4).fieldMapping.fieldID + "";
                            string5 = ((FieldCriterion)object4).fieldMapping.fieldName;
                        }
                        string6 = this.getRelationString(((FieldCriterion)object4).relationship);
                        if (((FieldCriterion)object4).equivalence == null) continue;
                        object = ((FieldCriterion)object4).equivalence.toString() != null ? ((FieldCriterion)object4).equivalence.toString() : "";
                        continue;
                    }
                    if (i == 1) {
                        String string16 = string7 = ((FieldCriterion)object4).booleanOperator == 0 ? "OR" : "AND";
                        if (((FieldCriterion)object4).fieldMapping != null) {
                            string8 = ((FieldCriterion)object4).fieldMapping.fieldID + "";
                            string9 = ((FieldCriterion)object4).fieldMapping.fieldName;
                        }
                        string10 = this.getRelationString(((FieldCriterion)object4).relationship);
                        if (((FieldCriterion)object4).equivalence == null) continue;
                        object2 = ((FieldCriterion)object4).equivalence.toString() != null ? ((FieldCriterion)object4).equivalence.toString() : "";
                        continue;
                    }
                    if (i != 2) continue;
                    String string17 = string11 = ((FieldCriterion)object4).booleanOperator == 0 ? "OR" : "AND";
                    if (((FieldCriterion)object4).fieldMapping != null) {
                        string12 = ((FieldCriterion)object4).fieldMapping.fieldID + "";
                        string13 = ((FieldCriterion)object4).fieldMapping.fieldName;
                    }
                    string14 = this.getRelationString(((FieldCriterion)object4).relationship);
                    if (((FieldCriterion)object4).equivalence == null) continue;
                    object3 = ((FieldCriterion)object4).equivalence.toString() != null ? ((FieldCriterion)object4).equivalence.toString() : "";
                    continue;
                }
                if (!(this.criteria[i] instanceof String)) continue;
                string = "Field Relation Value";
                object4 = (String)this.criteria[i];
                if (i == 0) {
                    string5 = "KEYWORDS";
                    object = object4;
                    continue;
                }
                if (i == 1) {
                    string7 = "AND";
                    string9 = "KEYWORDS";
                    object2 = object4;
                    continue;
                }
                if (i != 2) continue;
                string11 = "AND";
                string13 = "KEYWORDS";
                object3 = object4;
            }
        } else {
            string = "Show All";
        }
        CSVLogger.write(writer, string);
        CSVLogger.write(writer, string3);
        CSVLogger.write(writer, string4);
        CSVLogger.write(writer, string5);
        CSVLogger.write(writer, string6);
        CSVLogger.write(writer, object);
        CSVLogger.write(writer, string7);
        CSVLogger.write(writer, string8);
        CSVLogger.write(writer, string9);
        CSVLogger.write(writer, string10);
        CSVLogger.write(writer, object2);
        CSVLogger.write(writer, string11);
        CSVLogger.write(writer, string12);
        CSVLogger.write(writer, string13);
        CSVLogger.write(writer, string14);
        CSVLogger.write(writer, object3);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    private String getRelationString(int n) {
        switch (n) {
            case 0: {
                return "No Relation";
            }
            case 1: {
                return "Equals";
            }
            case 10: {
                return "Does Not Equal";
            }
            case 2: {
                return "Contains";
            }
            case 9: {
                return "Does Not Contain";
            }
            case 3: {
                return "Begins With";
            }
            case 4: {
                return "Ends With";
            }
            case 5: {
                return "Greater Than";
            }
            case 6: {
                return "Less Than";
            }
            case 7: {
                return "Greater Than Or Equal";
            }
            case 8: {
                return "Less Than Or Equal";
            }
            case 11: {
                return "Empty Field";
            }
            case 12: {
                return "Non-Empty Field";
            }
        }
        return "";
    }
}

