/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.ThreadedGetter;
import com.luna.insight.server.ThumbnailResultCollector;
import java.util.Vector;

public class ThumbnailGetter
extends ThreadedGetter {
    public ThumbnailResultCollector trc;
    public Vector tallyMarks;
    protected Vector cNameFieldIndices;
    protected String localAddress;

    public ThumbnailGetter(Vector vector, ResultsProgressListener resultsProgressListener, ThumbnailResultCollector thumbnailResultCollector, CollectionConnection collectionConnection, InsightSmartClient insightSmartClient, String string) {
        this.tallyMarks = vector;
        this.rpl = resultsProgressListener;
        this.trc = thumbnailResultCollector;
        this.cc = collectionConnection;
        this.trc.addClient();
        this.isc = insightSmartClient;
        this.localAddress = string;
        this.cNameFieldIndices = InsightSmartClient.getCollectionNameFieldIndices(resultsProgressListener.getGroupInfo().getThumbnailQuery().getCaptionFields());
    }

    public void run() {
        try {
            this.setPriority(1);
            this.debugOut("ThumbnailGetter: Starting.", 3);
            if (!this.isc.continueThumbRetrieval()) {
                this.trc.removeClient();
                this.rpl.resultLoadFailed();
                return;
            }
            InsightRequest insightRequest = InsightRequest.newRequest(1, this.rpl.getGroupInfo().getTci(), this.localAddress);
            insightRequest.addObjectParam("TALLY_MARKS", this.tallyMarks);
            insightRequest.addObjectParam("THUMBNAIL_QUERY", this.rpl.getGroupInfo().getThumbnailQuery());
            this.cc.oos.writeObject(insightRequest);
            this.cc.oos.flush();
            this.debugOut("Waiting for data.");
            if (this.waitWhileKeepAlive(1) > 0) {
                this.debugOut("THG - Data retrieval begun", 3);
                this.debugOut("Receiving data.", 3);
                int n = this.cc.ois.readInt();
                this.rpl.setResultCounts(this.cc.totalRecords, n);
                InsightSmartClientResults insightSmartClientResults = null;
                for (int i = 0; i < n; ++i) {
                    if (!this.isc.continueThumbRetrieval()) {
                        this.trc.removeClient();
                        this.rpl.resultLoadFailed();
                        return;
                    }
                    this.rpl.setResultProgress(i);
                    insightSmartClientResults = (InsightSmartClientResults)this.cc.ois.readObject();
                    InsightSmartClient.setCollectionName(insightSmartClientResults, this.cNameFieldIndices, this.cc.tci.getCollectionName());
                    this.trc.addResult(insightSmartClientResults);
                    this.debugOut("Item #" + i + "  added to TRC");
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in ThumbnailGetter:\n" + InsightUtilities.getStackTrace(exception), 2);
            this.rpl.serverContacted(false);
            this.rpl.resultLoadFailed();
        }
        this.trc.removeClient();
        this.rpl.resultLoadComplete();
    }
}

