/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.ObjectKey;
import com.luna.insight.server.ObjectKeyWrapper;
import com.luna.insight.server.ThumbnailTallyMark;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Vector;

public class ThumbnailDistribution
implements Serializable {
    static final long serialVersionUID = -7089497727558919288L;
    public static final int OFFSET = 32;
    public static final int TARGET_SET_LENGTH = 66;
    public int totalCount = 0;
    public int[] tally = new int[66];
    protected transient Vector[] tallyMarks = null;

    public static void debugOut(String string) {
        ThumbnailDistribution.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("TD: " + string, n);
    }

    public static int findIndex(String string) {
        char c;
        int n = -1;
        if (string != null && string.length() > 0 && (n = (c = string.charAt(0)) - 32) >= 66) {
            n = 65;
        }
        return n;
    }

    public static char findChar(int n) {
        char c = '\u0000';
        if (n < 0) {
            n = 0;
        }
        if (n >= 66) {
            n = 65;
        }
        c = (char)(n + 32);
        return c;
    }

    public static void findStringRange(int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (n < 0) {
            n = 0;
        }
        if (n >= 66) {
            n = 65;
        }
        if (n == 65) {
            if (stringBuffer != null) {
                stringBuffer.append(ThumbnailDistribution.findChar(n) + "");
            }
            if (stringBuffer2 != null) {
                stringBuffer2.append("\uffff");
            }
        } else {
            char c = ThumbnailDistribution.findChar(n);
            if (stringBuffer != null) {
                stringBuffer.append(c + "");
            }
            if (stringBuffer2 != null) {
                stringBuffer2.append(c + 65535 + "");
            }
        }
    }

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                System.out.println("Enter a character:");
                String string = bufferedReader.readLine();
                if (string != null && string.length() > 0) {
                    int n = string.charAt(0);
                    System.out.println("Char: " + (char)n + " -> Unicode: " + n);
                    System.out.println("Array index: " + ThumbnailDistribution.findIndex(string));
                    System.out.println("");
                    System.out.println("Enter an index:");
                    string = bufferedReader.readLine();
                    if (string != null && string.length() > 0) {
                        n = Integer.parseInt(string);
                        System.out.println("Index: " + n);
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        ThumbnailDistribution.findStringRange(n, stringBuffer, stringBuffer2);
                        System.out.println("Start str: " + stringBuffer.toString() + ", End str: " + stringBuffer2.toString());
                        System.out.println("");
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    public void addTally(ThumbnailTallyMark thumbnailTallyMark) {
        this.addTally(thumbnailTallyMark, null);
    }

    public void addTally(ThumbnailTallyMark thumbnailTallyMark, ObjectKey objectKey) {
        int n;
        if (this.tallyMarks == null) {
            this.tallyMarks = new Vector[66];
        }
        if ((n = ThumbnailDistribution.findIndex(thumbnailTallyMark.sort)) >= 0 && n < this.tally.length) {
            if (this.tallyMarks[n] == null) {
                this.tallyMarks[n] = new Vector();
            }
            int n2 = -1;
            if (objectKey != null && (n2 = this.tallyMarks[n].indexOf(objectKey)) > -1) {
                ++n2;
            }
            if (n2 == -1) {
                this.tallyMarks[n].addElement(thumbnailTallyMark);
            } else {
                this.tallyMarks[n].insertElementAt(thumbnailTallyMark, n2);
            }
            this.tally[n] = this.tallyMarks[n].size();
            ++this.totalCount;
        } else {
            ThumbnailDistribution.debugOut("WARNING: Unable to add TTM: '" + thumbnailTallyMark.sort + "', tallyIndex: " + n, 2);
        }
    }

    public void removeTally(ObjectKeyWrapper objectKeyWrapper) {
        if (this.tallyMarks != null) {
            for (int i = 0; i < this.tallyMarks.length; ++i) {
                int n;
                if (this.tallyMarks[i] == null || (n = this.tallyMarks[i].indexOf(objectKeyWrapper)) <= -1) continue;
                this.tallyMarks[i].removeElementAt(n);
                this.tally[i] = this.tallyMarks[i].size();
                --this.totalCount;
                break;
            }
        }
    }

    public void removeTally(long l) {
        if (this.tallyMarks != null) {
            for (int i = 0; i < this.tallyMarks.length; ++i) {
                int n = 0;
                while (this.tallyMarks[i] != null && n < this.tallyMarks[i].size()) {
                    ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)this.tallyMarks[i].get(n);
                    if (thumbnailTallyMark.getObjectID() == l) {
                        this.tallyMarks[i].remove(n);
                        this.tally[i] = this.tallyMarks[i].size();
                        --this.totalCount;
                        continue;
                    }
                    ++n;
                }
            }
        }
    }

    public Vector getTallyMarks(int n, int n2) {
        ThumbnailDistribution.debugOut("in getTallyMarks(tallyIndex: " + n + ", length: " + n2 + ").");
        Vector vector = new Vector(n2);
        if (this.tallyMarks != null && n >= 0 && n < this.tallyMarks.length) {
            int n3;
            Vector vector2 = this.tallyMarks[n];
            if (vector2 != null) {
                for (n3 = 0; n3 < vector2.size(); ++n3) {
                    vector.addElement(vector2.elementAt(n3));
                }
            }
            n3 = 0;
            for (int i = n + 1; i < this.tallyMarks.length; ++i) {
                vector2 = this.tallyMarks[i];
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    if (n3 == n2) {
                        return vector;
                    }
                    vector.addElement(vector2.elementAt(j));
                    ++n3;
                }
            }
        }
        return vector;
    }
}

