/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;

public class InsightDataAnchor {
    public static final String ERROR_HYPER_TEXT = "<INVALID LINK>";
    public static final String OPEN_ANCHOR_TAG = "<a";
    public static final String CLOSE_ANCHOR_TAG = "</a>";
    public static final String CLOSE_ANCHOR_TAG_UPPER = "</A>";
    public static final String HREF_TAG = "href=";
    protected String htmlAnchorTag = "";
    protected String webAddress = "";
    protected String hyperText = "";
    protected int hyperTextStartPosition = 0;
    protected int hyperTextEndPosition = 0;
    protected int htmlAnchorTagStartPosition = 0;
    protected boolean anchorTagValid = false;

    public static void debugOut(String string) {
        InsightDataAnchor.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightDataAnchor: " + string, n);
    }

    public static String getPlainText(String string) {
        return (String)InsightDataAnchor.extractAnchors(string).lastElement();
    }

    public static Vector extractAnchors(String string) {
        StringBuffer stringBuffer = new StringBuffer(string == null ? 0 : string.length());
        int n = 0;
        Vector<Object> vector = new Vector<Object>();
        while (string != null && n < string.length()) {
            String string2 = InsightDataAnchor.getNextAnchorTag(string, n);
            if (string2 != null) {
                int n2 = string.indexOf(string2, n);
                stringBuffer.append(string.substring(n, n2));
                InsightDataAnchor insightDataAnchor = new InsightDataAnchor(string2, stringBuffer.length(), n2);
                stringBuffer.append(insightDataAnchor.getHyperText());
                vector.addElement(insightDataAnchor);
                n = n2 + string2.length();
                continue;
            }
            stringBuffer.append(string.substring(n));
            break;
        }
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    public static String getNextAnchorTag(String string, int n) {
        int n2 = InsightDataAnchor.getStartAnchorTagPosition(string, n);
        int n3 = InsightDataAnchor.getEndAnchorTagPosition(string, n2 + 1);
        if (n2 != -1 && n3 != -1 && n2 < n3) {
            int n4 = string.indexOf(">", n3);
            return string.substring(n2, n4 + 1);
        }
        return null;
    }

    public static int getHrefPosition(String string) {
        int n = (string = string.toLowerCase()).indexOf("href");
        if (n > -1) {
            for (int i = n + 4; i < string.length(); ++i) {
                if (String.valueOf(string.charAt(i)).equals("=")) {
                    return n;
                }
                if (String.valueOf(string.charAt(i)).equals(" ")) continue;
                return -1;
            }
        }
        return n;
    }

    public static int getStartAnchorTagPosition(String string) {
        return InsightDataAnchor.getStartAnchorTagPosition(string, 0);
    }

    public static int getStartAnchorTagPosition(String string, int n) {
        int n2 = (string = string.substring(n)).indexOf("<");
        if (n2 > -1 && string.length() > 1) {
            for (int i = n2 + 1; i < string.length(); ++i) {
                if (string.charAt(i) == 'a' || string.charAt(i) == 'A') {
                    if (i + 1 < string.length()) {
                        if (String.valueOf(string.charAt(i + 1)).equals(" ")) {
                            return n2 + n;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (String.valueOf(string.charAt(i)).equals(" ")) continue;
                return -1;
            }
        }
        return n2;
    }

    public static int getEndAnchorTagPosition(String string) {
        return InsightDataAnchor.getEndAnchorTagPosition(string, 0);
    }

    public static int getEndAnchorTagPosition(String string, int n) {
        int n2;
        int n3 = (string = string.substring(n)).indexOf("</");
        if (n3 > -1 && (n2 = string.indexOf(">", n3)) > -1) {
            String string2 = string.substring(n3, n2 + 1);
            if ((string2 = InsightUtilities.removeAllWhiteSpace(string2)).equals(CLOSE_ANCHOR_TAG) || string2.equals(CLOSE_ANCHOR_TAG_UPPER)) {
                return n3 + n;
            }
            return -1;
        }
        return n3;
    }

    public static boolean endsWithCloseAnchor(String string) {
        String string2;
        boolean bl = false;
        int n = InsightDataAnchor.getEndAnchorTagPosition(string);
        if (n > -1 && (string2 = string.substring(n, string.length())).indexOf(">") == string2.length() - 1) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    InsightDataAnchor.debugOut("\nEnter an anchor string: ");
                    String string = bufferedReader.readLine();
                    InsightDataAnchor.debugOut("Anchor string: " + string);
                    InsightDataAnchor.debugOut("Plain text string: " + InsightDataAnchor.getPlainText(string));
                }
            }
            catch (Exception exception) {
                InsightDataAnchor.debugOut("Exception encountered, unable to parse string: " + exception);
                continue;
            }
            break;
        }
    }

    public InsightDataAnchor(String string) {
        this(string, 0, 0);
    }

    public InsightDataAnchor(String string, int n, int n2) {
        this.htmlAnchorTag = string;
        this.hyperTextStartPosition = n;
        this.htmlAnchorTagStartPosition = n2;
        this.parseAnchorString(string);
    }

    public InsightDataAnchor(InsightDataAnchor insightDataAnchor) {
        this.htmlAnchorTag = insightDataAnchor.getHtmlAnchorTag();
        this.webAddress = insightDataAnchor.getWebAddress();
        this.hyperText = insightDataAnchor.getHyperText();
        this.hyperTextStartPosition = insightDataAnchor.getStartPosition();
        this.hyperTextEndPosition = insightDataAnchor.getEndPosition();
        this.htmlAnchorTagStartPosition = insightDataAnchor.getHtmlAnchorPosition();
        this.anchorTagValid = insightDataAnchor.isValid();
    }

    public String getHtmlAnchorTag() {
        return this.htmlAnchorTag;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public String getHyperText() {
        return this.hyperText;
    }

    public int getStartPosition() {
        return this.hyperTextStartPosition;
    }

    public int getEndPosition() {
        return this.hyperTextEndPosition;
    }

    public int getHtmlAnchorPosition() {
        return this.htmlAnchorTagStartPosition;
    }

    public boolean isValid() {
        return this.anchorTagValid;
    }

    public void setHyperText(String string) {
        this.hyperText = string;
        this.htmlAnchorTag = "<a href=\"" + this.webAddress + "\">" + this.hyperText + CLOSE_ANCHOR_TAG;
        this.anchorTagValid = !this.hyperText.equals("");
    }

    public void setWebAddress(String string) {
        this.webAddress = string;
        this.htmlAnchorTag = "<a href=\"" + this.webAddress + "\">" + this.hyperText + CLOSE_ANCHOR_TAG;
        this.anchorTagValid = !this.webAddress.equals("");
    }

    private void parseAnchorString(String string) {
        if (string != null && string.length() >= 16 && InsightDataAnchor.getStartAnchorTagPosition(string) == 0 && InsightDataAnchor.endsWithCloseAnchor(string)) {
            int n = 0;
            n = InsightDataAnchor.getHrefPosition(string);
            if (n == -1) {
                this.hyperText = ERROR_HYPER_TEXT;
                return;
            }
            int n2 = string.indexOf("\"", n);
            int n3 = string.indexOf("\"", n2 + 1);
            if (n2 == -1 || n3 == -1 || n3 <= n2) {
                this.hyperText = ERROR_HYPER_TEXT;
                return;
            }
            this.webAddress = string.substring(n2 + 1, n3);
            n = n3;
            n2 = string.indexOf(">", n);
            n3 = InsightDataAnchor.getEndAnchorTagPosition(string, n2 + 1);
            if (n2 == -1 || n3 == -1 || n3 <= n2) {
                this.hyperText = ERROR_HYPER_TEXT;
                return;
            }
            this.hyperText = string.substring(n2 + 1, n3);
            this.hyperTextEndPosition = this.hyperTextStartPosition + this.hyperText.length() - 1;
            this.anchorTagValid = true;
        }
    }
}

