/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.presentation.ImageSeries;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class ImageGroupFileManager
implements FilenameFilter {
    public static final String IMAGE_GROUP_FILE_PATH = "Image-Group-Files";
    public static final String IMAGE_GROUP_FILE_EXT = "grp";
    public static final String LIST_FILE_EXT = "lst";
    public static final String PRESENTATION_KEY = "presentation.";
    protected String imageGroupFilePath = null;

    public static void debugOut(String string) {
        Debug.debugOut("IGFM: " + string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IGFM: " + string, n);
    }

    public ImageGroupFileManager() {
        this(IMAGE_GROUP_FILE_PATH, false);
    }

    public ImageGroupFileManager(String string, boolean bl) {
        this.setGroupFilePath(string, bl);
    }

    public boolean groupFilePathExists() {
        if (this.imageGroupFilePath != null) {
            return new File(this.imageGroupFilePath).exists();
        }
        return false;
    }

    public String getGroupFilePath() {
        return this.imageGroupFilePath;
    }

    public void setGroupFilePath(String string, boolean bl) {
        this.imageGroupFilePath = string;
        if (string != null) {
            File file = new File(this.imageGroupFilePath);
            if (bl && !file.exists()) {
                file.mkdirs();
            }
        }
    }

    public Vector getImageGroupFileList(String string, String string2, int n) {
        ImageGroupFileManager.debugOut("in getImageGroupFileList().");
        Vector<String> vector = new Vector<String>();
        String string3 = this.getDirectoryPath(string, string2, n);
        ImageGroupFileManager.debugOut("Retrieving available image group files for " + string3);
        File file = new File(string3);
        file.mkdirs();
        String[] stringArray = file.list(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].toLowerCase();
                if (!string4.endsWith(".grp")) continue;
                vector.addElement(string4);
            }
        }
        return vector;
    }

    public Vector getImageGroupFileInfoList(String string, String string2, int n) {
        ImageGroupFileManager.debugOut("in getImageGroupFileInfoList().");
        Vector<File> vector = new Vector<File>();
        String string3 = this.getDirectoryPath(string, string2, n);
        ImageGroupFileManager.debugOut("Retrieving available image group files for " + string3);
        File file = new File(string3);
        file.mkdirs();
        File[] fileArray = file.listFiles(this);
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            String string4 = fileArray[i].getName().toLowerCase();
            if (!string4.endsWith(".grp")) continue;
            vector.addElement(fileArray[i]);
        }
        return vector;
    }

    public int getGroupFileCountForShare(String string, String string2) {
        int n = 0;
        try {
            String string3 = this.getDirectoryPath(string, string2, 0);
            n = this.getGroupFileCountForShare(string3);
            System.out.println("getGroupFileCountForShare - group: " + string + " count: " + n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    protected int getGroupFileCountForShare(String string) throws IOException {
        int n = 0;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (fileArray[i].isFile() && fileArray[i].canRead()) {
                String string2 = fileArray[i].getName().toLowerCase();
                if (!string2.endsWith(".grp")) continue;
                ++n;
                continue;
            }
            if (!fileArray[i].isDirectory() || !fileArray[i].canRead()) continue;
            n += this.getGroupFileCountForShare(fileArray[i].getCanonicalPath());
        }
        return n;
    }

    public boolean doesImageGroupFileExist(String string, String string2, int n, String string3) {
        ImageGroupFileManager.debugOut("in doesImageGroupFileExist().");
        String string4 = string3.toLowerCase();
        if (!string4.endsWith(".grp")) {
            string4 = string4 + ".grp";
        }
        String string5 = this.getFilePath(string, string2, n, string4);
        ImageGroupFileManager.debugOut("Finding file at " + string5);
        File file = new File(string5);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ImageGroupFile getImageGroupFile(String string, String string2, int n, String string3) {
        ImageGroupFile imageGroupFile;
        block16: {
            ImageGroupFileManager.debugOut("in getImageGroupFile().");
            imageGroupFile = null;
            String string4 = string3.toLowerCase();
            if (!string4.endsWith(".grp")) {
                string4 = string4 + ".grp";
            }
            String string5 = this.getFilePath(string, string2, n, string4);
            ImageGroupFileManager.debugOut("Finding file at " + string5);
            File file = new File(string5);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                InsightPkgSetterInputStream insightPkgSetterInputStream = null;
                fileInputStream = new FileInputStream(file);
                insightPkgSetterInputStream = new InsightPkgSetterInputStream(fileInputStream);
                imageGroupFile = (ImageGroupFile)insightPkgSetterInputStream.readObject();
                insightPkgSetterInputStream.close();
                fileInputStream.close();
                Object var13_11 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (insightPkgSetterInputStream != null) {
                        insightPkgSetterInputStream.close();
                    }
                    break block16;
                }
                catch (IOException iOException) {}
                break block16;
                {
                    catch (Exception exception) {
                        ImageGroupFileManager.debugOut("Exception in getImageGroupFile(): " + exception);
                        Object var13_12 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            if (insightPkgSetterInputStream != null) {
                                insightPkgSetterInputStream.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (insightPkgSetterInputStream != null) {
                            insightPkgSetterInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return imageGroupFile;
    }

    public List getPresentationNames(String string, String string2, int n, String string3) {
        Object object;
        Vector<Object> vector = new Vector<Object>(0);
        EnhancedProperties enhancedProperties = this.getPropertyFile(string, string2, n, string3);
        if (enhancedProperties == null) {
            ImageGroupFileManager.debugOut("Creating IGF property file.");
            object = this.getImageGroupFile(string, string2, n, string3);
            if (object != null) {
                enhancedProperties = this.savePropertyFile(string, string2, n, (ImageGroupFile)object);
            }
        } else {
            ImageGroupFileManager.debugOut("IGF property file found.");
        }
        if (enhancedProperties != null) {
            object = null;
            int n2 = 0;
            while (InsightUtilities.isNonEmpty((String)(object = enhancedProperties.getProperty(PRESENTATION_KEY + n2)))) {
                vector.add(object);
                ++n2;
            }
        }
        return vector;
    }

    public ImageSeries getPresentation(String string, String string2, int n, String string3, String string4) {
        ImageGroupFile imageGroupFile;
        ImageSeries imageSeries = null;
        if (InsightUtilities.isNonEmpty(string4) && (imageGroupFile = this.getImageGroupFile(string, string2, n, string3)) != null) {
            imageSeries = imageGroupFile.getImageSeries(string4);
        }
        return imageSeries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveImageGroupFile(String string, String string2, int n, ImageGroupFile imageGroupFile, boolean bl) {
        Object object;
        Object object2;
        String string3;
        File file;
        ImageGroupFileManager.debugOut("in saveImageGroupFile().");
        String string4 = imageGroupFile.getGroupName().toLowerCase();
        if (!string4.endsWith(".grp")) {
            string4 = string4 + ".grp";
        }
        if ((file = new File(string3 = this.getFilePath(string, string2, n, string4))).exists()) {
            if (bl) {
                file.delete();
            } else {
                object2 = this.getImageGroupFile(string, string2, n, string4);
                if (object2 == null || !((ImageGroupFile)object2).hasSameCreator(imageGroupFile)) return false;
                file.delete();
            }
        } else {
            object2 = this.getDirectoryPath(string, string2, n);
            object = new File((String)object2);
            ((File)object).mkdirs();
        }
        object2 = null;
        object2 = new FileOutputStream(file);
        object = InsightPkgRemoverOutputStream.getInstance((OutputStream)object2);
        imageGroupFile.trimToSize();
        ((ObjectOutputStream)object).writeObject(imageGroupFile);
        ((ObjectOutputStream)object).close();
        ((FileOutputStream)object2).close();
        this.savePropertyFile(string, string2, n, imageGroupFile);
        Object var13_12 = null;
        try {
            if (object2 == null) return file.exists();
            ((FileOutputStream)object2).close();
            return file.exists();
        }
        catch (IOException iOException) {}
        return file.exists();
        {
            catch (Exception exception) {
                ImageGroupFileManager.debugOut("Exception in saveImageGroupFile(): " + exception);
                boolean bl2 = false;
                Object var13_13 = null;
                try {
                    if (object2 == null) return bl2;
                    ((FileOutputStream)object2).close();
                    return bl2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (object2 == null) throw throwable;
                ((FileOutputStream)object2).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean deleteImageGroupFile(String string, String string2, String string3, String string4, int n, String string5, boolean bl) {
        ImageGroupFile imageGroupFile;
        ImageGroupFileManager.debugOut("in deleteImageGroupFile().");
        String string6 = string5.toLowerCase();
        if (!string6.endsWith(".grp")) {
            string6 = string6 + ".grp";
        }
        String string7 = this.getFilePath(string3, string4, n, string6);
        ImageGroupFileManager.debugOut("Finding file at " + string7);
        File file = new File(string7);
        if (!(!file.exists() || bl || (imageGroupFile = this.getImageGroupFile(string3, string4, n, string6)) != null && imageGroupFile.hasSameCreator(string, string2))) {
            return false;
        }
        boolean bl2 = file.delete();
        if (bl2) {
            ImageGroupFileManager.debugOut(string7 + " successfully deleted.");
        } else {
            ImageGroupFileManager.debugOut(string7 + " not deleted.");
        }
        this.deletePropertyFile(string3, string4, n, string5);
        return bl2;
    }

    public EnhancedProperties getPropertyFile(String string, String string2, int n, String string3) {
        if (InsightUtilities.isNonEmpty(string3)) {
            return InsightUtilities.getEnhancedProperties(this.getPropertyFilePath(string, string2, n, string3));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public EnhancedProperties savePropertyFile(String string, String string2, int n, ImageGroupFile imageGroupFile) {
        block15: {
            Object object;
            block14: {
                Serializable serializable;
                if (imageGroupFile == null) break block15;
                String string3 = this.getPropertyFilePath(string, string2, n, imageGroupFile.getGroupName());
                File file = new File(string3);
                if (file.exists()) {
                    file.delete();
                } else {
                    object = this.getDirectoryPath(string, string2, n);
                    serializable = new File((String)object);
                    ((File)serializable).mkdirs();
                }
                object = new EnhancedProperties();
                serializable = imageGroupFile.getImageSerieses();
                for (int i = 0; serializable != null && i < serializable.size(); ++i) {
                    ((Properties)object).setProperty(PRESENTATION_KEY + i, ((ImageSeries)serializable.get(i)).getSeriesName());
                }
                FileOutputStream fileOutputStream = null;
                fileOutputStream = new FileOutputStream(file);
                ((EnhancedProperties)object).store(fileOutputStream, "Group File " + imageGroupFile.getGroupName() + " Content Listing");
                fileOutputStream.close();
                Object var12_11 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    break block14;
                }
                catch (IOException iOException) {}
                break block14;
                {
                    catch (Exception exception) {
                        ImageGroupFileManager.debugOut("Exception in savePropertyFile(): " + exception);
                        Object var12_12 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            break block14;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return object;
        }
        return null;
    }

    protected void deletePropertyFile(String string, String string2, int n, String string3) {
        ImageGroupFileManager.debugOut("in deletePropertyFile().");
        if (InsightUtilities.isNonEmpty(string3)) {
            try {
                String string4 = this.getPropertyFilePath(string, string2, n, string3);
                if (InsightUtilities.isNonEmpty(string4)) {
                    new File(string4).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String getDirectoryPath(String string, String string2, int n) {
        return this.imageGroupFilePath + File.separator + InsightUtilities.cleanFilename(string, true) + "-" + InsightUtilities.cleanFilename(string2, true) + File.separator + this.computeFolderPath(n);
    }

    protected String computeFolderPath(int n) {
        return n == 0 ? "" : "" + n + File.separator;
    }

    protected String getFilePath(String string, String string2, int n, String string3) {
        return this.getDirectoryPath(string, string2, n) + InsightUtilities.cleanFilename(string3);
    }

    protected String getPropertyFilePath(String string, String string2, int n, String string3) {
        String string4 = string3.toLowerCase();
        if (string4.endsWith(".grp")) {
            string4 = string4.substring(0, string4.lastIndexOf(".grp"));
        }
        if (!string4.endsWith(".lst")) {
            string4 = string4 + ".lst";
        }
        return this.getFilePath(string, string2, n, string4);
    }

    public boolean accept(File file, String string) {
        return string != null && string.toLowerCase().endsWith(".grp");
    }
}

