/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldStandardMismatches;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.links.LinkFieldMapping;
import com.luna.insight.server.links.LinkFieldStandard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FieldStandardsManager
implements Serializable {
    static final long serialVersionUID = 5714546519273855833L;
    public static final int STARTUP_FIELD_COUNT = 4;
    public static final Object FIELD_POOL_LOCK = new Object();
    protected static boolean fieldPoolUpToDate = false;
    protected static boolean cacheCollectionTemplateMap = true;
    protected List fieldList = null;
    protected transient Field[] fieldListArray = null;
    protected static Vector fieldMappingGroups = new Vector(0);
    protected static Map fieldPool;
    protected static Map collectionTemplateMap;
    protected Integer uniqueCollectionID = null;
    protected Vector fieldStandards = new Vector();
    protected Vector thumbnailFields = new Vector();
    protected FieldStandard collectionStandard = null;
    protected LinkFieldStandard linkStandard = null;

    public static void debugOut(String string) {
        FieldStandardsManager.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("FSM: " + string, n);
    }

    public static void newLine() {
        Debug.debugOut("", 3);
    }

    public static void setFieldMappingGroups(Vector vector) {
        fieldMappingGroups = vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldPool(Set set) {
        Object object = FIELD_POOL_LOCK;
        synchronized (object) {
            if (set != null) {
                fieldPool = new HashMap(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Field field = (Field)iterator.next();
                    fieldPool.put(new Integer(field.getFieldID()), field);
                }
                fieldPoolUpToDate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getFieldPool() {
        Object object = FIELD_POOL_LOCK;
        synchronized (object) {
            if (!fieldPoolUpToDate) {
                TrinityConnector.rebuildFieldPool(null);
            }
            return fieldPool;
        }
    }

    public static Vector getFieldMappingGroups() {
        if (fieldMappingGroups == null) {
            fieldMappingGroups = new Vector(0);
        }
        return fieldMappingGroups;
    }

    public FieldStandardsManager(Integer n) {
        this.uniqueCollectionID = n;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public FieldStandard getCollectionStandard() {
        return this.collectionStandard;
    }

    public Field[] getFieldList() {
        if (this.fieldListArray == null) {
            this.fieldListArray = this.fieldList.toArray(new Field[0]);
        }
        return this.fieldListArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldList(Set set) {
        Object object = FIELD_POOL_LOCK;
        synchronized (object) {
            if (set != null) {
                this.fieldList = new ArrayList();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Field field = (Field)fieldPool.get((Integer)iterator.next());
                    if (field == null) continue;
                    this.fieldList.add(Field.copy(field));
                }
            }
            if (this.fieldList != null) {
                Collections.sort(this.fieldList);
            }
        }
    }

    public void setLinkStandard(LinkFieldStandard linkFieldStandard) {
        this.linkStandard = linkFieldStandard;
    }

    public LinkFieldStandard getLinkStandard() {
        return this.linkStandard;
    }

    public Field getFieldByID(int n) {
        for (int i = 0; i < this.fieldList.size(); ++i) {
            Field field = (Field)this.fieldList.get(i);
            if (field.getFieldID() != n) continue;
            return field;
        }
        return null;
    }

    public Field getField(FieldMapping fieldMapping) {
        FieldMapping fieldMapping2;
        FieldStandard fieldStandard;
        if (fieldMapping != null && (fieldStandard = this.getFieldStandard(fieldMapping.fieldStandardName)) != null && (fieldMapping2 = fieldStandard.getFieldMapping(fieldMapping.fieldID)) != null) {
            return fieldMapping2.getFinalField();
        }
        return null;
    }

    public FieldMapping getFieldMapping(FieldMapping fieldMapping) {
        FieldMapping fieldMapping2 = null;
        if (fieldMapping != null) {
            if (fieldMapping instanceof LinkFieldMapping) {
                LinkFieldStandard linkFieldStandard = this.getLinkStandard();
                if (linkFieldStandard != null) {
                    fieldMapping2 = linkFieldStandard.getFieldMappingByDisplayName(fieldMapping.fieldDisplayName);
                    if (fieldMapping2 != null && fieldMapping2.fieldStandardName == null) {
                        fieldMapping2.fieldStandardName = linkFieldStandard.getStandardName();
                    }
                } else {
                    FieldStandardsManager.debugOut("Link field standard not defined.", 3);
                }
            } else if (InsightUtilities.isNonEmpty(fieldMapping.getFieldStandardName())) {
                FieldStandard fieldStandard = this.getFieldStandard(fieldMapping.getFieldStandardName());
                if (fieldStandard != null) {
                    fieldMapping2 = fieldStandard.getFieldMapping(fieldMapping.getFieldID());
                } else {
                    FieldStandardsManager.debugOut("Field standard: " + fieldMapping.getFieldStandardName() + " not found.", 3);
                }
            } else {
                FieldStandard fieldStandard = this.getCollectionStandard();
                if (fieldStandard != null) {
                    fieldMapping2 = fieldStandard.getFieldMapping(fieldMapping.getFieldName());
                } else {
                    FieldStandardsManager.debugOut("Collection standard missing.", 3);
                }
            }
        }
        return fieldMapping2;
    }

    public FieldMapping getFieldMappingInStandard(String string, String string2) {
        FieldStandard fieldStandard = this.getFieldStandard(string);
        FieldMapping fieldMapping = null;
        try {
            FieldMapping fieldMapping2;
            if (fieldStandard != null && (fieldMapping2 = this.collectionStandard.getFieldMapping(string2)) != null) {
                fieldMapping = fieldMapping2.getTranslatedFieldMapping(fieldStandard);
            }
        }
        catch (Exception exception) {
            FieldStandardsManager.debugOut("Exception in getFieldMappingInStandard(): " + exception, 2);
        }
        return fieldMapping;
    }

    public Field getFieldInStandardByID(String string, int n) {
        Field field = this.getFieldByID(n);
        FieldMapping fieldMapping = null;
        Field field2 = null;
        try {
            fieldMapping = field.getTranslatedFieldMapping(string);
            if (fieldMapping != null && fieldMapping != null && fieldMapping.fieldDisplayName != null) {
                Field field3 = new Field(fieldMapping.fieldID, fieldMapping.fieldName, fieldMapping.fieldType, fieldMapping.fieldDescriptionURL, fieldMapping.longString);
                field3.fieldDisplayName = fieldMapping.fieldDisplayName;
                field3.setFieldGroupID(fieldMapping.getFieldGroupID());
                field2 = field3;
            }
        }
        catch (Exception exception) {
            FieldStandardsManager.debugOut("Exception in getFieldInStandardByID(): " + exception, 2);
        }
        return field2;
    }

    public FieldMapping getFieldMappingInStandardByID(String string, int n) {
        Field field = this.getFieldByID(n);
        if (field != null) {
            return field.getTranslatedFieldMapping(string);
        }
        return null;
    }

    public FieldMapping[] getStartThumbFields(String string) {
        FieldMapping[] fieldMappingArray = new FieldMapping[]{};
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard != null) {
            fieldMappingArray = fieldStandard.getStartThumbFields();
        } else {
            FieldStandardsManager.debugOut("Field standard: " + string + " not found.", 3);
        }
        return fieldMappingArray;
    }

    public FieldMapping[] getStartSortFields(String string) {
        FieldMapping[] fieldMappingArray = new FieldMapping[]{};
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard != null) {
            fieldMappingArray = fieldStandard.getStartSortFields();
        } else {
            FieldStandardsManager.debugOut("Field standard: " + string + " not found.", 3);
        }
        return fieldMappingArray;
    }

    public Vector getFieldList(String string) {
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard != null) {
            return fieldStandard.getFieldMappings();
        }
        return new Vector(0);
    }

    public Vector getHierarchyFieldMappings(String string) {
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard != null) {
            return fieldStandard.getHierarchyFieldMappings();
        }
        return new Vector(0);
    }

    public Vector getNonMatchedFields(String string) {
        Vector<FieldMapping> vector = new Vector<FieldMapping>();
        FieldStandard fieldStandard = this.getFieldStandard(string);
        try {
            if (fieldStandard != null) {
                FieldMapping fieldMapping = null;
                boolean bl = false;
                FieldMapping fieldMapping2 = null;
                for (int i = 0; i < this.collectionStandard.fieldMappings.size(); ++i) {
                    fieldMapping = (FieldMapping)this.collectionStandard.fieldMappings.elementAt(i);
                    bl = false;
                    fieldMapping2 = null;
                    for (int j = 0; j < fieldStandard.fieldMappings.size(); ++j) {
                        fieldMapping2 = (FieldMapping)fieldStandard.fieldMappings.elementAt(j);
                        if (!fieldMapping2.hasFinalField(fieldMapping.getFinalField())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    vector.addElement(fieldMapping);
                }
            } else {
                FieldStandardsManager.debugOut("Unable to find FieldStandard for " + string, 3);
            }
        }
        catch (Exception exception) {
            FieldStandardsManager.debugOut("Exception in getNonMatchedFields(): " + exception, 2);
            vector = new Vector();
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getFieldStandards() {
        return this.fieldStandards;
    }

    public FieldStandard getFieldStandard(String string) {
        int n = this.getFieldStandardIndex(string);
        if (n > -1) {
            return (FieldStandard)this.fieldStandards.get(n);
        }
        return null;
    }

    public FieldStandard getFieldStandard(int n) {
        Iterator iterator = this.fieldStandards.iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard = (FieldStandard)iterator.next();
            if (fieldStandard.getStandardID() != n) continue;
            return fieldStandard;
        }
        return null;
    }

    public int getFieldStandardIndex(String string) {
        if (InsightUtilities.isNonEmpty(string)) {
            FieldStandard fieldStandard = null;
            for (int i = 0; this.fieldStandards != null && i < this.fieldStandards.size(); ++i) {
                fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
                if (!InsightUtilities.isNonEmpty(fieldStandard.getStandardName()) || !fieldStandard.getStandardName().equalsIgnoreCase(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public List getFieldStandardTemplates() {
        Vector vector = new Vector(0);
        for (int i = 0; this.fieldStandards != null && i < this.fieldStandards.size(); ++i) {
            if (!((FieldStandard)this.fieldStandards.get(i)).isTemplate()) continue;
            vector.add(this.fieldStandards.get(i));
        }
        return vector;
    }

    public synchronized void addFieldStandard(FieldStandard fieldStandard, boolean bl) {
        if (fieldStandard != null) {
            int n = this.getFieldStandardIndex(fieldStandard.getStandardName());
            if (n > -1) {
                if (bl) {
                    this.fieldStandards.set(n, fieldStandard);
                }
            } else {
                this.fieldStandards.add(fieldStandard);
            }
            Vector vector = fieldStandard.getFinalFields();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Field field = (Field)vector.get(i);
                if (this.fieldList.contains(field)) continue;
                this.fieldList.add(field);
            }
            this.fieldListArray = null;
        }
    }

    public void addFieldStandard(String string, int n, int n2, int n3, String string2, String string3, int n4, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string5, String string6, int n5, int n6, boolean bl6, int n7, String string7, int n8, boolean bl7, boolean bl8, boolean bl9, boolean bl10, int n9) {
        FieldMapping fieldMapping;
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard == null) {
            fieldStandard = new FieldStandard(string, n, n2, n3, string2, string3, n4, string4, bl, bl2, bl3, bl4, bl5, FieldStandardsManager.getFieldMappingGroups());
            this.fieldStandards.addElement(fieldStandard);
        }
        if ((fieldMapping = fieldStandard.getFieldMapping(n5)) == null) {
            fieldMapping = new FieldMapping(string5, string6, n5, n6, bl6, fieldStandard, n7, string7, n8, bl7, bl8, bl9, bl10, n9);
            fieldStandard.addFieldMapping(fieldMapping);
        } else {
            FieldStandardsManager.debugOut("Field mapping '" + string6 + "'. Already found in field standard '" + string + "'.", 3);
        }
    }

    public void setMappingStandard() {
        FieldStandard fieldStandard = null;
        FieldStandard fieldStandard2 = null;
        for (int i = 0; this.fieldStandards != null && i < this.fieldStandards.size(); ++i) {
            fieldStandard2 = (FieldStandard)this.fieldStandards.elementAt(i);
            if (fieldStandard2.isMappingStandard()) {
                return;
            }
            if (fieldStandard != null && fieldStandard2.getStandardID() >= fieldStandard.getStandardID()) continue;
            fieldStandard = fieldStandard2;
        }
        if (fieldStandard != null) {
            FieldStandardsManager.newLine();
            FieldStandardsManager.debugOut("ALERT: Mapping standard not specified, setting default: " + fieldStandard.getStandardName());
            FieldStandardsManager.newLine();
            fieldStandard.setMappingStandard(true);
        }
    }

    public void setFieldMapping(String string, int n, String string2, int n2) {
        FieldStandard fieldStandard = this.getFieldStandard(string2);
        List list = this.getChildStandards(string);
        if (list.size() > 0 && fieldStandard != null) {
            this.setFieldMapping(list, n, fieldStandard, n2);
        }
        fieldStandard = this.getFieldStandard(string);
        list = this.getChildStandards(string2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard2 = (FieldStandard)iterator.next();
            if (!fieldStandard2.getStandardName().equals(string2)) continue;
            iterator.remove();
        }
        if (list.size() > 0 && fieldStandard != null) {
            this.setFieldMapping(list, n2, fieldStandard, n);
        }
    }

    private void setFieldMapping(List list, int n, FieldStandard fieldStandard, int n2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard2 = (FieldStandard)iterator.next();
            FieldMapping fieldMapping = fieldStandard2.getFieldMapping(n);
            FieldMapping fieldMapping2 = fieldStandard.getFieldMapping(n2);
            if (fieldMapping != null && fieldMapping2 != null) {
                fieldMapping.addFieldMapping(fieldMapping2);
                fieldMapping2.addFieldMapping(fieldMapping);
                continue;
            }
            FieldStandardsManager.debugOut("Error locating field mappings -> fieldID: " + n + ", fm: " + fieldMapping + ", mappingFieldID: " + n2 + ", mappingFM: " + fieldMapping2);
        }
    }

    private List getChildStandards(String string) {
        ArrayList<FieldStandard> arrayList = new ArrayList<FieldStandard>();
        Iterator iterator = this.getFieldStandards().iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard = (FieldStandard)iterator.next();
            if (!fieldStandard.getParentStandardName().equals(string)) continue;
            arrayList.add(fieldStandard);
        }
        return arrayList;
    }

    public void setStartupFields(String string, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard != null) {
            fieldStandard.setCreateThumbCache(bl);
            int[] nArray = new int[]{n, n2, n3, n4};
            int[] nArray2 = new int[]{n5, n6, n7, n8};
            fieldStandard.setStartupFields(nArray, nArray2);
        }
    }

    public void setCollectionStandard(int n) {
        Iterator iterator = this.fieldStandards.iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard = (FieldStandard)iterator.next();
            if (fieldStandard.getStandardID() == n) {
                fieldStandard.setType(1);
                this.collectionStandard = fieldStandard;
                this.collectionStandard.matchToFields(this.getFieldList());
                continue;
            }
            if (fieldStandard.getType() != 4) continue;
            fieldStandard.matchToFields(this.getFieldList());
        }
    }

    public void matchToFinalFields() {
        FieldStandard fieldStandard = null;
        for (int i = 0; i < this.fieldStandards.size(); ++i) {
            fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
            if (fieldStandard.getType() == 1) continue;
            fieldStandard.matchToFields(this.collectionStandard);
        }
    }

    public void matchToHierarchies() {
        FieldStandard fieldStandard = null;
        for (int i = 0; i < this.fieldStandards.size(); ++i) {
            fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
            fieldStandard.matchToHierarchies();
        }
    }

    public void matchToDates() {
        FieldStandard fieldStandard = null;
        for (int i = 0; i < this.fieldStandards.size(); ++i) {
            fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
            fieldStandard.matchToDates();
        }
    }

    public void showData() {
        FieldStandard fieldStandard = null;
        FieldMapping fieldMapping = null;
        for (int i = 0; i < this.fieldStandards.size(); ++i) {
            int n;
            fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
            FieldStandardsManager.debugOut("UniqueCollectionID " + this.uniqueCollectionID);
            FieldStandardsManager.debugOut("Standard " + i + ": " + fieldStandard.standardName, 3);
            FieldStandardsManager.debugOut("", 3);
            fieldMapping = null;
            for (n = 0; n < fieldStandard.fieldMappings.size(); ++n) {
                fieldMapping = (FieldMapping)fieldStandard.fieldMappings.elementAt(n);
                fieldMapping.showData();
                FieldStandardsManager.debugOut("", 3);
            }
            for (n = 0; n < fieldStandard.getFieldMappingGroups().size(); ++n) {
                FieldStandardsManager.debugOut("Group " + n + ": " + fieldStandard.getFieldMappingGroups().get(n));
            }
            FieldStandardsManager.newLine();
        }
    }

    public Vector getMismatchedFields() {
        Vector<FieldStandardMismatches> vector = new Vector<FieldStandardMismatches>();
        FieldStandard fieldStandard = null;
        for (int i = 0; i < this.fieldStandards.size(); ++i) {
            fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
            if (fieldStandard.getMismatches() != null && !fieldStandard.getMismatches().getMismatchedFields().isEmpty()) {
                vector.addElement(fieldStandard.getMismatches());
                continue;
            }
            FieldStandardsManager.debugOut("There were no mismatched fields for standard " + fieldStandard.standardName, 2);
        }
        return vector;
    }

    public void addThumbnailFields(Vector vector) {
        this.thumbnailFields = vector;
    }

    public boolean areThumbnailFieldsValid() {
        Vector vector = new Vector();
        boolean bl = true;
        try {
            FieldStandard fieldStandard = null;
            String string = null;
            FieldMapping fieldMapping = null;
            for (int i = 0; i < this.fieldStandards.size(); ++i) {
                fieldStandard = (FieldStandard)this.fieldStandards.elementAt(i);
                if (fieldStandard.getMismatches() == null || fieldStandard.getMismatches().getMismatchedFields().isEmpty()) continue;
                for (int j = 0; j < this.thumbnailFields.size(); ++j) {
                    string = (String)this.thumbnailFields.elementAt(j);
                    if (fieldStandard == null || fieldStandard.standardName == null || string == null || (fieldMapping = this.getFieldMappingInStandard(fieldStandard.standardName, string)) == null || fieldMapping.fieldName == null || string == null || !fieldStandard.getMismatches().getMismatchedFields().contains(fieldMapping.fieldName)) continue;
                    bl = false;
                    FieldStandardsManager.debugOut("Found a thumbnail field lacking a mapping in standard " + fieldStandard.standardName + ": " + string, 2);
                }
            }
        }
        catch (Exception exception) {
            FieldStandardsManager.debugOut("Exception in areThumbnailFieldsValid(): " + exception, 2);
        }
        return bl;
    }

    public void setParentRelations() {
        Iterator iterator = this.getFieldStandards().iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard;
            FieldStandard fieldStandard2 = (FieldStandard)iterator.next();
            if (fieldStandard2.getParentStandardName() != null || (fieldStandard = this.getFieldStandardByParentID(fieldStandard2.getParentStandardID())) == null) continue;
            fieldStandard2.setParentStandardName(fieldStandard.getStandardName());
        }
    }

    private FieldStandard getFieldStandardByParentID(int n) {
        Iterator iterator = this.getFieldStandards().iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard = (FieldStandard)iterator.next();
            if (fieldStandard.getStandardID() != n) continue;
            return fieldStandard;
        }
        return null;
    }

    public void setEnabledStandardOrder(String string, int n) {
        FieldStandard fieldStandard = this.getFieldStandard(string);
        if (fieldStandard != null) {
            fieldStandard.setEnabled(true);
            fieldStandard.setStandardsOrder(n);
        }
    }

    public void setEnabledStandardsOrder(List list) {
        Iterator iterator = this.fieldStandards.iterator();
        while (iterator.hasNext()) {
            ((FieldStandard)iterator.next()).setEnabled(false);
        }
        if (list != null) {
            int n = 0;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                this.setEnabledStandardOrder((String)iterator2.next(), ++n);
            }
        }
    }

    public List getStandardPreferences() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = this.getFieldStandards();
        Collections.sort(vector);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            FieldStandard fieldStandard = (FieldStandard)iterator.next();
            if (!fieldStandard.isEnabled()) continue;
            arrayList.add(fieldStandard.getStandardName());
        }
        return arrayList;
    }

    public boolean supportsLinkSearching() {
        return this.getLinkStandard().supportsLinkSearching();
    }

    public static boolean isFieldPoolUpToDate() {
        return fieldPoolUpToDate;
    }

    public static void setFieldPoolUpToDate(boolean bl) {
        fieldPoolUpToDate = bl;
    }

    public static void setCollectionTemplateMap(Map map) {
        collectionTemplateMap = map;
    }

    public static Map getCollectionTemplateMap() {
        return collectionTemplateMap;
    }

    public static boolean isCacheCollectionTemplateMap() {
        return cacheCollectionTemplateMap;
    }

    public static void setCacheCollectionTemplateMap(boolean bl) {
        cacheCollectionTemplateMap = bl;
    }
}

