/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldMappingGroup;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldStandardMismatches;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class FieldStandard
implements Serializable,
Comparable {
    static final long serialVersionUID = -8789183209653359378L;
    public static final int COLLECTION = 1;
    public static final int LOCAL = 2;
    public static final int PUBLISHED = 3;
    public static final int CUSTOM = 4;
    public static final int UNDEFINED = 0;
    private static int TEMP_STANDARD_ID = -1;
    protected static Comparator STANDARD_NAME_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    public String standardName;
    public String parentStandardName;
    public int standardID;
    public int parentStandardID;
    public int type;
    public String version;
    public String versionInfo;
    public int standardsOrder;
    public String descriptionUrl;
    public boolean isMappingStandard;
    public boolean isEnabled;
    public boolean isTemplate;
    public boolean isPCTemplate;
    public boolean isPublished;
    protected InsightUser standardCreator = null;
    public FieldMapping[] thumbnailFieldMappings = new FieldMapping[4];
    public FieldMapping[] sortFieldMappings = new FieldMapping[4];
    protected FieldStandardMismatches mismatches = null;
    protected Vector fieldMappings = new Vector();
    protected Vector hierarchyFieldMappings = new Vector();
    protected Vector fieldMappingGroups = new Vector();
    protected boolean createThumbCache = false;
    protected transient Vector usedFinalFields = new Vector();

    public static void debugOut(String string) {
        FieldStandard.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("FieldStandard: " + string, n);
    }

    public static boolean isTempStandardID(int n) {
        return n <= 0;
    }

    public static synchronized String getNextTempStandardID() {
        return TEMP_STANDARD_ID-- + "";
    }

    public static void sortFieldStandardsByName(List list) {
        if (InsightUtilities.isNonEmpty(list)) {
            Collections.sort(list, STANDARD_NAME_COMPARATOR);
        }
    }

    public FieldStandard() {
    }

    public FieldStandard(String string, int n, int n2, int n3, String string2, String string3, int n4, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Vector vector) {
        this.standardName = string;
        this.standardID = n;
        this.parentStandardID = n2;
        this.type = n3;
        this.version = string2;
        this.versionInfo = string3;
        this.standardsOrder = n4;
        this.descriptionUrl = string4;
        this.isMappingStandard = bl;
        this.isEnabled = bl2;
        this.isTemplate = bl3;
        this.isPCTemplate = bl4;
        this.isPublished = bl5;
        if (this.standardID == this.parentStandardID) {
            this.parentStandardName = this.standardName;
        }
        this.mismatches = new FieldStandardMismatches(this.standardName);
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            FieldMappingGroup fieldMappingGroup = (FieldMappingGroup)InsightUtilities.deepCopy(vector.get(i));
            this.fieldMappingGroups.add(fieldMappingGroup);
        }
    }

    public String getStandardName() {
        return this.standardName;
    }

    public int getStandardID() {
        return this.standardID;
    }

    public int getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public int getStandardsOrder() {
        return this.standardsOrder;
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public boolean isMappingStandard() {
        return this.isMappingStandard;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public InsightUser getStandardCreator() {
        return this.standardCreator;
    }

    public boolean createThumbCache() {
        return this.createThumbCache;
    }

    public FieldStandardMismatches getMismatches() {
        return this.mismatches;
    }

    public void setStandardName(String string) {
        this.standardName = string;
    }

    public void setStandardID(int n) {
        this.standardID = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setVersionInfo(String string) {
        this.versionInfo = string;
    }

    public void setStandardsOrder(int n) {
        this.standardsOrder = n;
    }

    public void setMappingStandard(boolean bl) {
        this.isMappingStandard = bl;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void setTemplate(boolean bl) {
        this.isTemplate = bl;
    }

    public void setStandardCreator(InsightUser insightUser) {
        this.standardCreator = insightUser;
    }

    public void setCreateThumbCache(boolean bl) {
        this.createThumbCache = bl;
    }

    public void setFieldMappingGroups(Vector vector) {
        this.fieldMappingGroups = vector;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof FieldStandard) {
            FieldStandard fieldStandard = (FieldStandard)object;
            return this.standardName != null && this.type == fieldStandard.type && this.standardName.equals(fieldStandard.standardName);
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.standardName.equals(string);
        }
        return super.equals(object);
    }

    public void addFieldMapping(FieldMapping fieldMapping) {
        if (!this.fieldMappings.contains(fieldMapping)) {
            InsightUtilities.addToSortedList(this.fieldMappings, fieldMapping);
            if (this.fieldMappings.size() == 1) {
                int n;
                for (n = 0; n < this.thumbnailFieldMappings.length; ++n) {
                    this.thumbnailFieldMappings[n] = fieldMapping;
                }
                for (n = 0; n < this.sortFieldMappings.length; ++n) {
                    this.sortFieldMappings[n] = fieldMapping;
                }
            }
        }
    }

    public void deleteFieldMapping(FieldMapping fieldMapping) {
        if (this.fieldMappings.contains(fieldMapping)) {
            this.fieldMappings.remove(fieldMapping);
        }
        this.removeFieldMappingFromAllGroups(fieldMapping);
    }

    public void addFieldMappingToGroup(FieldMapping fieldMapping, int n) {
        if (fieldMapping != null) {
            this.removeFieldMappingFromAllGroups(fieldMapping);
            fieldMapping.setFieldGroupID(n);
            if (n == 0) {
                this.addToDummyFieldMappingGroup(fieldMapping);
            } else {
                FieldMappingGroup fieldMappingGroup = this.getFieldMappingGroupByID(n);
                if (fieldMappingGroup != null) {
                    fieldMappingGroup.addFieldMapping(fieldMapping);
                }
            }
            for (int i = 0; fieldMapping.getFinalFields() != null && i < fieldMapping.getFinalFields().size(); ++i) {
                this.usedFinalFields.add(fieldMapping.getFinalFields().get(i));
            }
        }
    }

    protected void removeFieldMappingFromAllGroups(FieldMapping fieldMapping) {
        if (fieldMapping != null) {
            Vector vector = this.getFieldMappingGroups();
            Object var3_3 = null;
            for (int i = 0; i < vector.size(); ++i) {
                var3_3 = vector.get(i);
                if (var3_3 instanceof FieldMappingGroup) {
                    ((FieldMappingGroup)var3_3).removeFieldMapping(fieldMapping);
                    continue;
                }
                if (!(var3_3 instanceof FieldMapping) || !vector.contains(fieldMapping)) continue;
                vector.remove(fieldMapping);
            }
        }
    }

    public Vector getFieldMappingGroups() {
        return this.fieldMappingGroups;
    }

    public FieldMappingGroup getFieldMappingGroupByID(int n) {
        for (int i = 0; i < this.fieldMappingGroups.size(); ++i) {
            Object e = this.fieldMappingGroups.get(i);
            if (!(e instanceof FieldMappingGroup) || ((FieldMappingGroup)e).getFieldGroupID() != n) continue;
            return (FieldMappingGroup)e;
        }
        return null;
    }

    public synchronized void addToDummyFieldMappingGroup(FieldMapping fieldMapping) {
        if (fieldMapping != null) {
            int n = 0;
            for (int i = 0; this.fieldMappingGroups != null && i < this.fieldMappingGroups.size(); ++i) {
                Object e = this.fieldMappingGroups.get(i);
                if (!(e instanceof FieldMappingGroup) || ((FieldMappingGroup)e).getFieldGroupID() <= n) continue;
                n = ((FieldMappingGroup)e).getFieldGroupID();
            }
            FieldMappingGroup fieldMappingGroup = new FieldMappingGroup(++n, fieldMapping.getDisplayName(), 1, fieldMapping.getDisplayOrder());
            this.fieldMappingGroups.add(fieldMappingGroup);
            fieldMappingGroup.addFieldMapping(fieldMapping);
            this.sortFieldMappingGroups();
        }
    }

    public void sortFieldMappingGroups() {
        2 var1_1 = new /* Unavailable Anonymous Inner Class!! */;
        if (InsightUtilities.isNonEmpty(this.fieldMappingGroups)) {
            Collections.sort(this.fieldMappingGroups, var1_1);
        }
        for (int i = 0; this.fieldMappingGroups != null && i < this.fieldMappingGroups.size(); ++i) {
            if (!(this.fieldMappingGroups.get(i) instanceof FieldMappingGroup)) continue;
            Collections.sort(((FieldMappingGroup)this.fieldMappingGroups.get(i)).getFieldMappings(), var1_1);
        }
    }

    public Vector getFieldMappings() {
        return this.fieldMappings;
    }

    public int getFieldMappingsCount() {
        if (this.fieldMappings != null) {
            return this.fieldMappings.size();
        }
        return 0;
    }

    public Vector getFinalFields() {
        Vector vector = new Vector();
        for (int i = 0; this.fieldMappings != null && i < this.fieldMappings.size(); ++i) {
            FieldMapping fieldMapping = (FieldMapping)this.fieldMappings.get(i);
            vector.addAll(fieldMapping.getFinalFields());
        }
        return vector;
    }

    public int getNextFieldMappingID() {
        int n = 0;
        Vector vector = this.getFieldMappings();
        FieldMapping fieldMapping = null;
        for (int i = 0; i < vector.size(); ++i) {
            fieldMapping = (FieldMapping)vector.get(i);
            if (fieldMapping.getFieldID() <= n) continue;
            n = fieldMapping.getFieldID();
        }
        return n + 1;
    }

    public FieldMapping getFieldMapping(int n) {
        FieldMapping fieldMapping = null;
        for (int i = 0; i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            if (fieldMapping.fieldID != n) continue;
            return fieldMapping;
        }
        return null;
    }

    public FieldMapping getFieldMapping(String string) {
        FieldMapping fieldMapping = null;
        for (int i = 0; i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            if (!fieldMapping.fieldName.equals(string)) continue;
            return fieldMapping;
        }
        return null;
    }

    public FieldMapping getFieldMappingByDisplayName(String string) {
        FieldMapping fieldMapping = null;
        for (int i = 0; string != null && i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            if (fieldMapping.fieldDisplayName == null || !fieldMapping.fieldDisplayName.equals(string)) continue;
            return fieldMapping;
        }
        return null;
    }

    public int getParentStandardID() {
        return this.parentStandardID;
    }

    public String getParentStandardName() {
        return this.parentStandardName;
    }

    public void setParentStandardName(String string) {
        this.parentStandardName = string;
    }

    public void setStartupFields(int[] nArray, int[] nArray2) {
        int n;
        FieldMapping fieldMapping;
        if (nArray.length == this.thumbnailFieldMappings.length) {
            fieldMapping = null;
            for (n = 0; n < nArray.length; ++n) {
                fieldMapping = null;
                fieldMapping = nArray[n] == 0 ? new FieldMapping("Collection Name", "Collection Name", 0, 1) : this.getFieldMapping(nArray[n]);
                if (fieldMapping == null) continue;
                this.thumbnailFieldMappings[n] = fieldMapping;
            }
        } else {
            FieldStandard.debugOut("ERROR: At setStartupFields(), thumbnailFieldIDs.length (" + nArray.length + ") does not match thumbnailFieldMappings.length (" + this.thumbnailFieldMappings.length + ").");
        }
        if (nArray2.length == this.sortFieldMappings.length) {
            fieldMapping = null;
            for (n = 0; n < nArray2.length; ++n) {
                fieldMapping = this.getFieldMapping(nArray2[n]);
                if (fieldMapping == null) continue;
                this.sortFieldMappings[n] = fieldMapping;
            }
        } else {
            FieldStandard.debugOut("ERROR: At setStartupFields(), sortFieldIDs.length (" + nArray2.length + ") does not match sortFieldMappings.length (" + this.sortFieldMappings.length + ").");
        }
    }

    public FieldMapping[] getStartThumbFields() {
        return this.thumbnailFieldMappings;
    }

    public FieldMapping[] getStartSortFields() {
        return this.sortFieldMappings;
    }

    public List getThumbnailableFields() {
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        HashSet hashSet = new HashSet(this.mismatches.getMismatchedFields());
        Iterator iterator = this.getFieldMappings().iterator();
        while (iterator.hasNext()) {
            FieldMapping fieldMapping = (FieldMapping)iterator.next();
            if (!fieldMapping.isDisplayedInThumbnail() || hashSet.contains(fieldMapping.fieldName)) continue;
            arrayList.add(fieldMapping);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getSortableFields() {
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        HashSet hashSet = new HashSet(this.mismatches.getMismatchedFields());
        Iterator iterator = this.getFieldMappings().iterator();
        while (iterator.hasNext()) {
            FieldMapping fieldMapping = (FieldMapping)iterator.next();
            if (!fieldMapping.isSortable() || hashSet.contains(fieldMapping.fieldName)) continue;
            arrayList.add(fieldMapping);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void showStartupFields() {
        int n;
        FieldStandard.debugOut(this.standardName + " thumbnail start fields:");
        for (n = 0; n < this.thumbnailFieldMappings.length; ++n) {
            FieldStandard.debugOut("\t[" + this.thumbnailFieldMappings[n].fieldID + ", " + this.thumbnailFieldMappings[n] + "]");
        }
        FieldStandard.debugOut(this.standardName + " sort start fields:");
        for (n = 0; n < this.sortFieldMappings.length; ++n) {
            FieldStandard.debugOut("\t[" + this.sortFieldMappings[n].fieldID + ", " + this.sortFieldMappings[n] + "]");
        }
    }

    public void matchToFields(Field[] fieldArray) {
        FieldMapping fieldMapping = null;
        block0: for (int i = 0; i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            for (int j = 0; j < fieldArray.length; ++j) {
                if (fieldMapping.fieldID != fieldArray[j].fieldID) continue;
                fieldMapping.addFinalField(fieldArray[j]);
                if (fieldMapping.getFinalField() == null) continue block0;
                this.addFieldMappingToGroup(fieldMapping, fieldMapping.getFinalField().getFieldGroupID());
                continue block0;
            }
        }
    }

    public void matchToFields(FieldStandard fieldStandard) {
        int n;
        Field field;
        int n2;
        long l = 0L;
        long l2 = 0L;
        FieldMapping fieldMapping = null;
        Vector vector = null;
        for (n2 = 0; n2 < this.fieldMappings.size(); ++n2) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(n2);
            long l3 = System.currentTimeMillis();
            vector = fieldMapping.getFieldMappings(fieldStandard);
            l += System.currentTimeMillis() - l3;
            ++l2;
            if (vector.size() > 0) {
                FieldMapping fieldMapping2 = null;
                field = null;
                for (n = 0; n < vector.size(); ++n) {
                    fieldMapping2 = (FieldMapping)vector.elementAt(n);
                    if (fieldMapping2 == null || fieldMapping2.getFinalFields().size() <= 0) continue;
                    field = null;
                    for (int i = 0; i < fieldMapping2.getFinalFields().size(); ++i) {
                        field = (Field)fieldMapping2.getFinalFields().elementAt(i);
                        fieldMapping.addFinalField(field);
                    }
                }
                continue;
            }
            this.mismatches.addMismatchedField(fieldMapping.fieldName);
        }
        n2 = 1;
        for (int i = 0; i < this.fieldMappings.size(); ++i) {
            n2 = 0;
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            field = null;
            if (fieldMapping == null || fieldMapping.getFinalFields().size() <= 0) continue;
            n2 = 1;
            field = null;
            for (n = 0; n < fieldMapping.getFinalFields().size(); ++n) {
                field = (Field)fieldMapping.getFinalFields().elementAt(n);
                if (!this.usedFinalFields.contains(field)) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0 || field == null) continue;
            this.addFieldMappingToGroup(fieldMapping, field.getFieldGroupID());
        }
    }

    public void matchToHierarchies() {
        FieldMapping fieldMapping = null;
        Vector vector = null;
        String string = null;
        Field field = null;
        for (int i = 0; i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            vector = fieldMapping.getFinalFields();
            int n = Field.HIERARCHY_MODE_NONE;
            string = "";
            field = null;
            for (int j = 0; j < vector.size(); ++j) {
                field = (Field)vector.elementAt(j);
                if (j == 0) {
                    n = field.hierarchyMode;
                    string = field.hierarchyName;
                    continue;
                }
                if (field.hierarchyMode != Field.HIERARCHY_MODE_NONE && field.hierarchyName.equals(string)) continue;
                n = Field.HIERARCHY_MODE_NONE;
                string = "";
                break;
            }
            fieldMapping.hierarchyMode = n;
            fieldMapping.hierarchyName = string;
            if (n <= Field.HIERARCHY_MODE_NONE) continue;
            this.hierarchyFieldMappings.addElement(fieldMapping);
        }
    }

    public Vector getHierarchyFieldMappings() {
        return this.hierarchyFieldMappings;
    }

    public void matchToDates() {
        FieldMapping fieldMapping = null;
        for (int i = 0; i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            fieldMapping.matchToDates();
        }
    }

    public boolean isPCTemplate() {
        return this.isPCTemplate;
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    public String toString() {
        return this.getStandardName();
    }

    public int compareTo(Object object) {
        int n = this.standardsOrder;
        int n2 = ((FieldStandard)object).standardsOrder;
        if (n == 0) {
            return n2 == 0 ? 0 : 1;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }
}

