/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.license;

import com.luna.insight.core.license.InsightLicenseConstants;
import com.luna.insight.core.util.CoreUtilities;
import com.vs.ezlicrun.EzLicenseInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class InsightLicenseUtilities
implements InsightLicenseConstants {
    public static String getHostName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            return string;
        }
        catch (Exception exception) {
            CoreUtilities.logWarning("Unable to resovle Local Host Name: \n" + exception.toString());
            return null;
        }
    }

    public static final boolean stringToBoolean(String string) {
        return !(string = string.toLowerCase()).equals("0") && !string.equals("false") && !string.equals("no");
    }

    public static void checkWarnings(int n) {
        if (n != 0) {
            CoreUtilities.logWarning("Warnings:");
            if ((n & 1) != 0) {
                CoreUtilities.logWarning("Time Limited Key Is About To Expire");
            }
            if ((n & 2) != 0) {
                CoreUtilities.logWarning("Quota Limited Key Is About To Expire");
            }
            if ((n & 4) != 0) {
                CoreUtilities.logWarning("Time Limited Key Has Expired");
            }
            if ((n & 8) != 0) {
                CoreUtilities.logWarning("Quota Limited Key Has Expired");
            }
            if ((n & 0x20) != 0) {
                CoreUtilities.logWarning("Expiration Days Grace In API Call Too Large - Truncated To 5 / 25% Of Lifespan");
            }
            if ((n & 0x10) != 0) {
                CoreUtilities.logWarning("Quota Grace In API Call Too Large - Truncated To 5 / 25% Of Original Quota");
            }
            CoreUtilities.logWarning("");
        }
    }

    public static void displayLicenseParams(EzLicenseInfo ezLicenseInfo) {
        String string;
        String string2;
        String string3;
        Date date;
        String string4;
        long l;
        CoreUtilities.logWarning("License Key Information:");
        CoreUtilities.logWarning("Key Version: " + (ezLicenseInfo.getKeyVersion() <= 0 ? "Legacy (1.1 or earlier)" : String.valueOf(ezLicenseInfo.getKeyVersion() / 10) + "." + String.valueOf(ezLicenseInfo.getKeyVersion() % 10)));
        if (ezLicenseInfo.getChainedKeyId() != null) {
            System.out.println("Replacement For Key With Id: " + ezLicenseInfo.getChainedKeyId());
        }
        int n = ezLicenseInfo.getLicenseModeBitmap();
        CoreUtilities.logWarning("License Mode Bitmap: " + n);
        if ((n & 1) != 0) {
            CoreUtilities.logWarning("TIME LIMITED");
        }
        if ((n & 4) != 0) {
            CoreUtilities.logWarning("OPTIONS");
        }
        if ((n & 2) != 0) {
            CoreUtilities.logWarning("METERED");
        }
        if ((n & 8) != 0) {
            CoreUtilities.logWarning("CUSTOM KEY");
        }
        if ((n & 0x10) != 0) {
            CoreUtilities.logWarning("CUSTOM COOKIE");
        }
        if ((l = ezLicenseInfo.getUsageValue()) > 0L) {
            CoreUtilities.logWarning("Usage Limit Value: " + l);
        }
        if ((l = ezLicenseInfo.getQuotaValue()) > 0L) {
            CoreUtilities.logWarning("Quota Value: " + l);
        }
        if ((string4 = ezLicenseInfo.getOptions()) != null && !string4.equals("")) {
            CoreUtilities.logWarning("Options: [" + string4 + "]");
        }
        if ((date = ezLicenseInfo.getExpirationDate()) != null) {
            CoreUtilities.logWarning("Expiration Date: " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss z").format(date));
        }
        if ((string3 = ezLicenseInfo.getUserHostNetName()).equalsIgnoreCase("developmentlicense")) {
            CoreUtilities.logWarning("Host Node Lock Disabled");
        } else if (string3.equalsIgnoreCase("multihostlicense")) {
            CoreUtilities.logWarning("Multi Host License");
        } else {
            CoreUtilities.logWarning("Licensed Host: " + string3);
        }
        if (ezLicenseInfo.getEnforce()) {
            CoreUtilities.logWarning("Operating system check enforced.");
        }
        if ((string2 = ezLicenseInfo.getCustomCookie()) != null && !string2.equals("")) {
            CoreUtilities.logWarning("Custom Cookie: [" + string2 + "]");
        }
        if ((string = ezLicenseInfo.getCustomKey()) != null && !string.equals("")) {
            CoreUtilities.logWarning("Custom Key: [" + string + "]");
        }
        if (ezLicenseInfo.getAppPwd() != null && !ezLicenseInfo.getAppPwd().equals("")) {
            CoreUtilities.logWarning("Application Password: [" + ezLicenseInfo.getAppPwd() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getKeyCookieFromFile() {
        File file = new File("mycookiefile");
        if (!file.exists()) {
            CoreUtilities.logWarning("*** File for key cookie does not exist ***");
            System.exit(2);
        }
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        string = bufferedReader.readLine();
        if (string == null) {
            CoreUtilities.logWarning("*** Invalid key cookie file - empty ***");
            System.exit(3);
        }
        if ((string = string.trim()).length() > 800) {
            CoreUtilities.logWarning("*** Invalid key cookie: string too long. ***");
            System.exit(1);
        }
        String string2 = string;
        Object var5_5 = null;
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
        catch (Exception exception) {
            try {
                CoreUtilities.logWarning("*** IO Error reading key cookie file ***");
                CoreUtilities.logWarning("Exception: " + exception.getClass().getName() + ", Message: " + exception.getMessage());
                exception.printStackTrace();
                System.exit(2);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception3) {}
        }
        return null;
    }

    public static int getFileType(String string) {
        int n = string.lastIndexOf(46);
        if (n <= 0 || n > string.length() - 4) {
            return 0;
        }
        String string2 = string.substring(n + 1);
        if (string2.equals("txt")) {
            return 1;
        }
        if (string2.equals("xml")) {
            return 2;
        }
        if (string2.equals("csv")) {
            return 3;
        }
        if (string2.equals("tab")) {
            return 4;
        }
        if (string2.equals("ini")) {
            return 5;
        }
        if (string2.equals("key")) {
            return 6;
        }
        CoreUtilities.logAlways("*** Unknown file type: '" + string2 + "'.  Giving up. ***");
        return -1;
    }

    public static String strip(String string) {
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string2 = string2 + string3;
            }
        }
        catch (Exception exception) {
            CoreUtilities.logWarning("*** Got exception: " + exception.getMessage());
        }
        return string2;
    }

    protected static Object[] getKey(String[] stringArray, int n, int n2, int n3) {
        Object[] objectArray = new Object[]{null, null};
        int n4 = -1;
        String string = null;
        if (n2 >= n) {
            return null;
        }
        if (n2 == 0) {
            switch (n3) {
                case 1: {
                    if (!stringArray[n2++].startsWith("License Key List:") || !stringArray[n2++].startsWith("----------------")) {
                        CoreUtilities.logWarning("*** Not a valid EasyLicenser text export file ***");
                        CoreUtilities.logWarning("Bad line #: " + n2 + ", contents: " + stringArray[n2 - 1]);
                        return null;
                    }
                    n2 += 3;
                    break;
                }
                case 2: {
                    if (!stringArray[n2++].startsWith("<?xml") || !stringArray[n2++].startsWith("<key-list>")) {
                        CoreUtilities.logWarning("*** Not a valid EasyLicenser XML export file ***");
                        CoreUtilities.logWarning("Bad line #: " + n2 + ", contents: " + stringArray[n2 - 1]);
                        return null;
                    } else {
                        break;
                    }
                }
            }
        } else {
            switch (n3) {
                case 2: {
                    if (stringArray[n2] == null || !stringArray[n2].startsWith("</key-list>")) break;
                    return null;
                }
            }
            if (stringArray[n2] == null) {
                return null;
            }
        }
        switch (n3) {
            case 1: {
                while (!stringArray[n2].startsWith("License key:") && n2 < n) {
                    ++n2;
                }
                if (++n2 >= n) {
                    CoreUtilities.logWarning("*** Premature termination of text file ***");
                    return null;
                }
                string = stringArray[n2].trim();
                n2 += 2;
                break;
            }
            case 2: {
                if (!stringArray[n2].startsWith("<key id=")) {
                    CoreUtilities.logWarning("*** Invalid XML record - treating as EOF ***");
                    CoreUtilities.logWarning("Bad line #: " + n2 + 1 + ", contents: " + stringArray[n2]);
                    return null;
                }
                if (++n2 >= n) {
                    CoreUtilities.logWarning("*** Premature termination of XML file ***");
                    return null;
                }
                string = stringArray[n2].trim();
                ++n2;
                ++n2;
                break;
            }
            case 5: {
                n4 = stringArray[n2].indexOf("=");
                if (n4 <= 0) {
                    CoreUtilities.logWarning("*** Invalid property file format - treating as EOF ***");
                    return null;
                }
                string = stringArray[n2].substring(n4 + 1).trim();
                ++n2;
                break;
            }
            case 6: {
                string = stringArray[n2].trim();
                ++n2;
                break;
            }
            case 3: 
            case 4: {
                n4 = stringArray[n2].lastIndexOf(n3 == 3 ? "," : "\t");
                if (n4 <= 0) {
                    CoreUtilities.logWarning("*** Invalid " + (n3 == 3 ? "csv" : "tab") + " file format - treating as EOF ***");
                    CoreUtilities.logWarning("Bad line #: " + n2 + 1 + ", contents: " + stringArray[n2]);
                    return null;
                }
                string = stringArray[n2].substring(n4 + 1).trim();
                ++n2;
            }
        }
        if (string.length() > 800) {
            CoreUtilities.logWarning("Key length exceeds limit of 800 characters");
            System.exit(2);
        }
        objectArray[0] = InsightLicenseUtilities.strip(string);
        objectArray[1] = new Integer(n2);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static Object[] readFile(String string, int n) {
        int n2;
        Object[] objectArray;
        block18: {
            BufferedReader bufferedReader;
            block16: {
                String[] stringArray = new String[n];
                objectArray = new Object[]{stringArray, null};
                File file = new File(string);
                if (!file.exists()) {
                    CoreUtilities.logWarning("*** License key file '" + string + "' not found ***");
                    return null;
                }
                n2 = 0;
                bufferedReader = null;
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null && n2 < n) {
                    stringArray[n2++] = string2.trim();
                }
                if (string2 == null) break block16;
                CoreUtilities.logWarning("*** Invalid key: too many lines.  Limit is " + n + ". ***");
                Object[] objectArray2 = null;
                Object var10_11 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return objectArray2;
            }
            stringArray[n2] = null;
            Object var10_12 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block18;
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (Exception exception) {
                    CoreUtilities.logWarning("*** IO Error reading license key file ***");
                    CoreUtilities.logWarning("Exception: " + exception.getClass().getName() + ", Message: " + exception.getMessage());
                    Object[] objectArray3 = null;
                    Object var10_13 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    return objectArray3;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        objectArray[1] = new Integer(n2);
        return objectArray;
    }

    public static void displayUnlicensedDialog(String string, String string2) {
        boolean bl = false;
        JFrame jFrame = new JFrame();
        JOptionPane jOptionPane = new JOptionPane(string2, 2);
        JDialog jDialog = jOptionPane.createDialog(jFrame, string);
        jDialog.show();
    }
}

