/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.license;

import com.luna.insight.core.license.InsightLicenseConstants;
import com.luna.insight.core.license.InsightLicenseException;
import com.luna.insight.core.license.InsightLicenseNamedUsers;
import com.luna.insight.core.license.InsightLicenseService;
import com.luna.insight.core.license.InsightLicenseUtilities;
import com.luna.insight.core.util.CoreUtilities;
import java.io.File;

public class InsightLicenseManager
implements InsightLicenseConstants {
    private String icmLicenseFile = "insightCollectionManager.key";
    private String pcmLicenseFile_v5_0 = "insightPersonalManager.key";
    private String pcmLicenseFile = "insightCollectionManager.key";
    private String iumLicenseFile = "insightCollectionManager.key";
    private String gatewayLicenseFile = "insightCollectionManager.key";
    private String browserLicenseFile = "insightCollectionManager.key";
    private int inscribeLicensedSessions = 0;
    private int pcLicensedSessions = 0;
    private int licenseVersionMajor = 5;
    private int icmLicenseVersion = -1;
    private int pcmLicenseVersion = -1;
    private int iumLicenseVersion = -1;
    private int gatewayLicenseVersion = -1;
    private int browserLicenseVersion = -1;
    private String licenseFilePath = "License-Files";
    private boolean licensedUserMode = false;
    private int maxMediaSoft = 0;
    private int maxMediaHard = 0;
    private InsightLicenseNamedUsers namedUsers;

    public InsightLicenseManager(String string) {
        if (string != null) {
            this.licenseFilePath = string.endsWith(File.separator) ? string.substring(0, string.length() - 1) : string;
        }
    }

    public boolean checkCollectionManagerLicense() {
        String string = this.licenseFilePath + File.separator + this.icmLicenseFile;
        File file = new File(string);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        if (file.exists()) {
            try {
                CoreUtilities.logInfo("Checking Collection Manager License");
                InsightLicenseService insightLicenseService = new InsightLicenseService();
                bl = insightLicenseService.registerInsightServerLicense(file.getPath());
                this.icmLicenseVersion = insightLicenseService.getLicenseVersion();
                this.inscribeLicensedSessions = insightLicenseService.getInscribeSessions();
                this.licensedUserMode = insightLicenseService.isLicensedUserMode();
                this.maxMediaSoft = insightLicenseService.getMaxMediaSoft();
                this.maxMediaHard = insightLicenseService.getMaxMediaHard();
                if (this.icmLicenseVersion < this.licenseVersionMajor && this.icmLicenseVersion != -1) {
                    CoreUtilities.logAlways("\n ATTENTION: Expired Insight Collection Manager License");
                    bl = false;
                }
            }
            catch (InsightLicenseException insightLicenseException) {
                CoreUtilities.logAlways("\n ATTENTION: Insight Collection Manager License is invalid.");
                CoreUtilities.logAlways("InsightLicenseException: " + insightLicenseException.getInsightMessage() + "\n");
                bl = false;
            }
        } else {
            CoreUtilities.logAlways("\n ATTENTION: Unable to locate Insight Collection Manager License\n Please refer to the Installation & Configuration Documentation for details. \n");
            string2 = string;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.displayServerNotLicensed("Collection Manager", string2);
        }
        return bl;
    }

    public boolean checkPersonalCollectionManagerLicense() {
        String string = this.licenseFilePath + File.separator + this.pcmLicenseFile_v5_0;
        boolean bl = true;
        File file = new File(string);
        if (!file.exists()) {
            bl = false;
            string = this.licenseFilePath + File.separator + this.pcmLicenseFile;
            file = new File(string);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        if (file.exists()) {
            try {
                CoreUtilities.logInfo("Checking Personal Collection Manager License");
                InsightLicenseService insightLicenseService = new InsightLicenseService();
                bl2 = bl ? insightLicenseService.registerPersonalInsightServerLicense_v5_0(file.getPath()) : insightLicenseService.registerPersonalInsightServerLicense(file.getPath());
                this.pcmLicenseVersion = insightLicenseService.getLicenseVersion();
                this.pcLicensedSessions = insightLicenseService.getPcSessions();
                this.licensedUserMode = insightLicenseService.isLicensedUserMode();
                this.maxMediaSoft = insightLicenseService.getMaxMediaSoft();
                this.maxMediaHard = insightLicenseService.getMaxMediaHard();
                if (this.pcmLicenseVersion < this.licenseVersionMajor && this.pcmLicenseVersion != -1) {
                    CoreUtilities.logAlways("\n ATTENTION: Expired Personal Collection Manager License");
                    bl2 = false;
                }
            }
            catch (InsightLicenseException insightLicenseException) {
                CoreUtilities.logAlways("\n ATTENTION: Insight Personal Collection Manager License is invalid");
                CoreUtilities.logAlways("InsightLicenseException: " + insightLicenseException.getInsightMessage() + "\n");
                bl2 = false;
            }
        } else {
            CoreUtilities.logAlways("\n ATTENTION: Unable to locate Insight Personal Collection Manager License\n Please refer to the Installation & Configuration Documentation for details. \n");
            string2 = string;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2) {
            this.displayServerNotLicensed("Personal Collection Manager", string2);
        }
        return bl2;
    }

    public boolean checkUserManagerLicense() {
        String string = this.licenseFilePath + File.separator + this.iumLicenseFile;
        File file = new File(string);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        if (file.exists()) {
            try {
                CoreUtilities.logInfo("Checking User Manager License");
                InsightLicenseService insightLicenseService = new InsightLicenseService();
                bl = insightLicenseService.registerInsightUserServerLicense(file.getPath());
                this.iumLicenseVersion = insightLicenseService.getLicenseVersion();
                if (this.iumLicenseVersion < this.licenseVersionMajor && this.iumLicenseVersion != -1) {
                    CoreUtilities.logAlways("\n ATTENTION: Expired User Manager License");
                    bl = false;
                }
            }
            catch (InsightLicenseException insightLicenseException) {
                CoreUtilities.logAlways("\n ATTENTION: Insight User Manager License is invalid.");
                CoreUtilities.logAlways("InsightLicenseException: " + insightLicenseException.getInsightMessage() + "\n");
                bl = false;
            }
        } else {
            CoreUtilities.logAlways("\n ATTENTION: Unable to locate Insight User Manager License\n Please refer to the Installation & Configuration Documentation for details. \n");
            string2 = string;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.displayServerNotLicensed("User Manager", string2);
        }
        return bl;
    }

    public boolean checkXMLGatewayLicense() {
        String string = this.licenseFilePath + File.separator + this.gatewayLicenseFile;
        File file = new File(string);
        boolean bl = false;
        String string2 = null;
        if (file.exists()) {
            try {
                CoreUtilities.logInfo("Checking XML Gateway License");
                InsightLicenseService insightLicenseService = new InsightLicenseService();
                bl = insightLicenseService.registerXmlGatewayLicense(file.getPath());
                this.gatewayLicenseVersion = insightLicenseService.getLicenseVersion();
                if (this.gatewayLicenseVersion < this.licenseVersionMajor && this.gatewayLicenseVersion != -1) {
                    CoreUtilities.logAlways("\n ATTENTION: Expired XML Gateway License");
                    bl = false;
                }
            }
            catch (InsightLicenseException insightLicenseException) {
                CoreUtilities.logAlways("\n ATTENTION: Insight XML Gateway License is invalid.");
                CoreUtilities.logAlways("InsightLicenseException: " + insightLicenseException.getInsightMessage() + "\n");
                bl = false;
            }
        } else {
            CoreUtilities.logAlways("\n ATTENTION: Unable to locate Insight XML Gateway License\n Please refer to the Installation & Configuration Documentation for details. \n");
            string2 = string;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.displayServerNotLicensed("Insight XML Gateway", string2);
        }
        return bl;
    }

    public boolean checkBrowserInsightLicense() {
        String string = this.licenseFilePath + File.separator + this.browserLicenseFile;
        File file = new File(string);
        boolean bl = false;
        String string2 = null;
        if (file.exists()) {
            try {
                CoreUtilities.logInfo("Checking Browser Insight License");
                InsightLicenseService insightLicenseService = new InsightLicenseService();
                bl = insightLicenseService.registerBrowserInsightLicense(file.getPath());
                this.browserLicenseVersion = insightLicenseService.getLicenseVersion();
                if (this.browserLicenseVersion < this.licenseVersionMajor && this.browserLicenseVersion != -1) {
                    CoreUtilities.logAlways("\n ATTENTION: Expired Browser Insight License");
                    bl = false;
                }
            }
            catch (InsightLicenseException insightLicenseException) {
                CoreUtilities.logAlways("\n ATTENTION: Browser Insight License is invalid.");
                CoreUtilities.logAlways("InsightLicenseException: " + insightLicenseException.getInsightMessage() + "\n");
                bl = false;
            }
        } else {
            CoreUtilities.logAlways("\n ATTENTION: Unable to locate Browser Insight License\n Please refer to the Installation & Configuration Documentation for details. \n");
            string2 = string;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.displayServerNotLicensed("Browser Insight", string2);
        }
        return bl;
    }

    public void initializeLicenseNamedUserList() {
        this.namedUsers = new InsightLicenseNamedUsers(this.pcLicensedSessions, this.inscribeLicensedSessions);
    }

    public InsightLicenseNamedUsers getLicenseNamedUserList() {
        return this.namedUsers;
    }

    public int getInscribeLicensedSessions() {
        return this.inscribeLicensedSessions;
    }

    public int getPcLicensedSessions() {
        return this.pcLicensedSessions;
    }

    public int getMaxMediaSoft() {
        return this.maxMediaSoft;
    }

    public int getMaxMediaHard() {
        return this.maxMediaHard;
    }

    public boolean isLicensedUserMode() {
        return this.licensedUserMode;
    }

    public void setLicensedUserMode(boolean bl) {
        this.licensedUserMode = bl;
    }

    private void displayServerNotLicensed(String string, String string2) {
        CoreUtilities.logAlways("\n\nLUNA IMAGING INC. LICENSE INFORMATION\n");
        if (string2 != null) {
            CoreUtilities.logAlways("* The " + string + " license file cannot be found in the following location:\n");
            CoreUtilities.logAlways("\t" + string2 + "\n");
        } else {
            CoreUtilities.logAlways("* The " + string + " license file is invalid.\n");
        }
        CoreUtilities.logAlways("* If you need a license key, please complete the following form:\n");
        CoreUtilities.logAlways("\thttp://www.lunaimaging.com/support/register/50.html\n");
        CoreUtilities.logAlways("* If you have any questions, or problems with your license key\nplease contact licensing@luna-img.com or call (800) 452-LUNA\n");
        CoreUtilities.logAlways("MACHINE HOSTNAME IS : " + InsightLicenseUtilities.getHostName() + "\n\n");
    }
}

