/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.iface;

import com.luna.insight.core.catalog.iface.BaseEntityType;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.core.catalog.iface.ITemplateElement;
import java.io.Serializable;
import java.util.Set;

public abstract class BaseTemplateElement
implements ITemplateElement,
Serializable {
    private int displayOrder = -1;
    private transient int dbDisplayOrder = -1;
    protected int toStringIndentLevel = 0;
    protected BaseTemplate template = null;
    protected int id = -1;
    protected String name = null;
    protected String displayName = null;
    protected BaseEntityType parentType = null;
    protected BaseEntityType previousParentType = null;

    public final int getDisplayOrder() {
        this.template.calculateDisplayOrders();
        return this.displayOrder;
    }

    protected final void setDisplayOrder(int n) {
        this.displayOrder = n;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean setDisplayName(String string) {
        this.displayName = string;
        return true;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public final int setParentEntityType(IEntityType iEntityType) {
        return this.setParentEntityType(iEntityType.getSize(), iEntityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setParentEntityType(int n, IEntityType iEntityType) throws IndexOutOfBoundsException {
        if (!this.template.getClass().equals(((BaseEntityType)iEntityType).template.getClass())) {
            return 10;
        }
        Object object = this.getTemplateStructureLock();
        synchronized (object) {
            int n2 = ((BaseEntityType)iEntityType).addChild(n, this);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEntityType getParentEntityType() {
        Object object = this.getTemplateStructureLock();
        synchronized (object) {
            return this.parentType;
        }
    }

    public final IEntityType getPreviousParentEntityType() {
        return this.previousParentType;
    }

    protected final Set getTemplateTypes() {
        return this.template.getTemplateTypes();
    }

    protected final Set getTemplateFields() {
        return this.template.getTemplateFields();
    }

    protected final Object getTemplateStructureLock() {
        return this.template.getTemplateStructureLock();
    }

    public final boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.name.equals(((BaseTemplateElement)object).getName());
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public int getDbDisplayOrder() {
        return this.dbDisplayOrder;
    }

    public void setDbDisplayOrder(int n) {
        this.dbDisplayOrder = n;
    }
}

