/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.iface;

import com.luna.insight.core.catalog.edit.EntityFieldEdit;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IFieldProfile;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.core.catalog.iface.ITemplateElement;
import com.luna.insight.core.catalog.utils.TemplateCompareException;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.IntegerRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseEntityField
extends BaseTemplateElement
implements IEntityField,
Serializable {
    public static final int MAX_FIELD_VALUE_COLUMN_NAME_LENGTH = 50;
    public static final transient IFieldProfile SHORT_TEXT = new ShortTextFieldProfile();
    public static final transient IFieldProfile LONG_TEXT = new LongTextFieldProfile();
    public static final transient IFieldProfile NUMERIC = new NumericFieldProfile();
    public static final transient IFieldProfile DATE = new DateFieldProfile();
    public static final transient IFieldProfile UNIQUE_ID = new UniqueIDFieldProfile();
    protected Map mappingFieldsMap = new HashMap();
    protected boolean isRequired;
    protected IntegerRange intRange;
    protected boolean repeatedValuesAllowed;
    protected boolean enforceUniqueValues;
    protected int fieldType;
    protected int stringType;
    protected boolean date;
    protected boolean keywordSearchable;
    protected boolean dataFieldSearchable;
    protected boolean displayedInData;
    protected int listMode;
    protected int delimiterType;
    protected boolean thumbnailOption;
    protected boolean sortOption;
    protected boolean valueListAllowed;
    protected int maxValueLength;
    protected boolean isReadOnly = false;
    protected int restrictionLevel = 0;
    protected int minApprovalToAddValue = 0;
    protected boolean displayInRelatedEntities = true;
    protected String descriptionURL = "";
    protected boolean pickable = false;
    protected int hierarchyMode = 0;
    protected String hierarchyName = null;
    protected int tableID = -1;
    protected String fieldValueColumnName;

    protected BaseEntityField(BaseTemplate baseTemplate, int n, IFieldProfile iFieldProfile, String string, String string2) {
        this.template = baseTemplate;
        this.name = string;
        this.displayName = string2;
        this.id = n;
        this.setFieldProfile(iFieldProfile);
    }

    public int[] getStandardsWithMappings() {
        int[] nArray = new int[this.mappingFieldsMap.size()];
        int n = 0;
        Iterator iterator = this.mappingFieldsMap.keySet().iterator();
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldMappings(int n) {
        Object object = this.getTemplateStructureLock();
        synchronized (object) {
            HashSet hashSet = (HashSet)this.mappingFieldsMap.get(new Integer(n));
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            return Collections.unmodifiableList(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFieldMapping(int n, Object object) {
        Object object2 = this.getTemplateStructureLock();
        synchronized (object2) {
            Integer n2 = new Integer(n);
            HashSet<Object> hashSet = (HashSet<Object>)this.mappingFieldsMap.get(n2);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                this.mappingFieldsMap.put(n2, hashSet);
            }
            if (!hashSet.contains(object)) {
                return hashSet.add(object);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFieldMapping(int n, Object object) {
        Object object2 = this.getTemplateStructureLock();
        synchronized (object2) {
            Integer n2 = new Integer(n);
            Set set = (Set)this.mappingFieldsMap.get(n2);
            if (set != null) {
                set.remove(object);
                if (set.size() == 0) {
                    this.mappingFieldsMap.remove(n2);
                }
                return true;
            }
            return false;
        }
    }

    public String getFieldValueColumnName() {
        return this.fieldValueColumnName == null ? this.name : this.fieldValueColumnName;
    }

    public void setFieldValueColumnName(String string) {
        this.fieldValueColumnName = string;
    }

    public void setFieldProfile(IFieldProfile iFieldProfile) {
        if (iFieldProfile == null) {
            iFieldProfile = SHORT_TEXT;
        }
        this.isRequired = iFieldProfile.isRequired();
        this.intRange = iFieldProfile.getIntegerRange();
        this.repeatedValuesAllowed = iFieldProfile.isAllowRepeatingValues();
        this.enforceUniqueValues = iFieldProfile.isEnforceUniqueValues();
        this.fieldType = iFieldProfile.getFieldType();
        this.stringType = iFieldProfile.getDataDisplayType();
        this.date = iFieldProfile.isFuzzyDate();
        this.keywordSearchable = iFieldProfile.isKeywordSearchable();
        this.listMode = iFieldProfile.getSelectListBehavior();
        this.delimiterType = iFieldProfile.getDelimiterType();
        this.dataFieldSearchable = iFieldProfile.isDataFieldSearchable();
        this.displayedInData = iFieldProfile.isDisplayedInData();
        this.thumbnailOption = iFieldProfile.isThumbnailOption();
        this.sortOption = iFieldProfile.isSortOption();
        this.valueListAllowed = iFieldProfile.isValueListAllowed();
        this.maxValueLength = iFieldProfile.getMaxValueLength();
    }

    public boolean isThumbnailOption() {
        return this.thumbnailOption;
    }

    public void setThumbnailOption(boolean bl) {
        this.thumbnailOption = bl;
    }

    public boolean isSortOption() {
        return this.sortOption;
    }

    public void setSortOption(boolean bl) {
        this.sortOption = bl;
    }

    public boolean isDisplayedInData() {
        return this.displayedInData;
    }

    public void setDisplayedInData(boolean bl) {
        this.displayedInData = bl;
    }

    public boolean isDataFieldSearchable() {
        return this.dataFieldSearchable;
    }

    public void setDataFieldSearchable(boolean bl) {
        this.dataFieldSearchable = bl;
    }

    public int getDelimiterType() {
        return this.delimiterType;
    }

    public void setDelimiterType(int n) {
        this.delimiterType = n;
    }

    public int getSelectListBehavior() {
        return this.listMode;
    }

    public void setSelectListBehavior(int n) {
        this.listMode = n;
    }

    public IFieldProfile getFieldProfile() {
        if (SHORT_TEXT.equals(this)) {
            return SHORT_TEXT;
        }
        if (LONG_TEXT.equals(this)) {
            return LONG_TEXT;
        }
        if (NUMERIC.equals(this)) {
            return NUMERIC;
        }
        if (DATE.equals(this)) {
            return DATE;
        }
        if (UNIQUE_ID.equals(this)) {
            return UNIQUE_ID;
        }
        return null;
    }

    public boolean isAllowRepeatingValues() {
        return this.repeatedValuesAllowed;
    }

    public void setRestrictionLevel(int n) {
        this.restrictionLevel = n;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void setRequired(boolean bl) {
        this.isRequired = bl;
    }

    public void setIntegerRange(IntegerRange integerRange) {
        this.intRange = integerRange;
    }

    public void setValueListAllowed(boolean bl) {
        this.valueListAllowed = bl;
    }

    public void setMinApprovalToAddValue(int n) {
        this.minApprovalToAddValue = n;
    }

    public void setAllowRepeatingValues(boolean bl) {
        this.repeatedValuesAllowed = bl;
    }

    public void setDisplayInRelatedEntities(boolean bl) {
        this.displayInRelatedEntities = bl;
    }

    public void setUseUniqueValues(boolean bl) {
        this.enforceUniqueValues = bl;
    }

    public void setMaxValueLength(int n) {
        this.maxValueLength = n;
    }

    public int getRestrictionLevel() {
        return this.restrictionLevel;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public IntegerRange getIntegerRange() {
        return this.intRange;
    }

    public boolean isValueListAllowed() {
        return this.valueListAllowed;
    }

    public int getMinApprovalToAddValue() {
        return this.minApprovalToAddValue;
    }

    public boolean isUseUniqueValues() {
        return this.enforceUniqueValues;
    }

    public boolean isDisplayInRelatedEntities() {
        return this.displayInRelatedEntities;
    }

    public int getMaxValueLength() {
        return this.maxValueLength;
    }

    public boolean isIntegerInRange(int n) {
        if (this.intRange == null) {
            return true;
        }
        return this.intRange.isWithinRange(n);
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public String getDescriptionUrl() {
        return this.descriptionURL;
    }

    public boolean isFuzzyDate() {
        return this.date;
    }

    public boolean isPickable() {
        return this.pickable;
    }

    public int getDataDisplayType() {
        return this.stringType;
    }

    public boolean isKeywordSearchable() {
        return this.keywordSearchable;
    }

    public int getHierarchyMode() {
        return this.hierarchyMode;
    }

    public String getHierarchy() {
        return this.hierarchyName;
    }

    public void setHierarchy(String string) {
        this.hierarchyName = string;
    }

    public void setDescriptionUrl(String string) {
        this.descriptionURL = string == null ? "" : string.intern();
    }

    public void setFieldType(int n) {
        this.fieldType = n;
    }

    public void setPickable(boolean bl) {
        this.pickable = bl;
    }

    public void setDataDisplayType(int n) {
        this.stringType = n;
    }

    public void setFuzzyDate(boolean bl) {
        this.date = bl;
    }

    public void setKeywordSearchable(boolean bl) {
        this.keywordSearchable = bl;
    }

    public void setHierarchyMode(int n) {
        this.hierarchyMode = n;
    }

    public List getChangedValues(ITemplate iTemplate, ITemplate iTemplate2, boolean bl, ITemplateElement iTemplateElement) throws TemplateCompareException {
        ArrayList<EntityFieldEdit> arrayList = new ArrayList<EntityFieldEdit>();
        if (iTemplateElement == null || iTemplateElement.getClass().hashCode() != this.getClass().hashCode() || iTemplateElement.getID() != this.getID()) {
            throw new TemplateCompareException("invalid source object");
        }
        BaseEntityField baseEntityField = (BaseEntityField)iTemplateElement;
        EntityFieldEdit entityFieldEdit = new EntityFieldEdit(7, baseEntityField, this);
        if (bl) {
            if (this.getDisplayOrder() != baseEntityField.getDbDisplayOrder()) {
                entityFieldEdit.addChange(0, this.getDisplayOrder());
            }
        } else if (this.getDisplayOrder() != baseEntityField.getDisplayOrder()) {
            entityFieldEdit.addChange(0, this.getDisplayOrder());
        }
        if (!CoreUtilities.isEqual(this.name, baseEntityField.name)) {
            entityFieldEdit.addChange(2, this.name);
        }
        if (!CoreUtilities.isEqual(this.displayName, baseEntityField.displayName)) {
            entityFieldEdit.addChange(1, this.displayName);
        }
        if (this.isRequired != baseEntityField.isRequired) {
            entityFieldEdit.addChange(101, this.isRequired());
        }
        if (this.intRange != null && baseEntityField.intRange != null && (this.intRange.getMinValue() != baseEntityField.intRange.getMinValue() || this.intRange.getMaxValue() != baseEntityField.intRange.getMaxValue())) {
            entityFieldEdit.addChange(102, this.intRange);
        }
        if (this.repeatedValuesAllowed != baseEntityField.repeatedValuesAllowed) {
            entityFieldEdit.addChange(103, this.repeatedValuesAllowed);
        }
        if (this.enforceUniqueValues != baseEntityField.enforceUniqueValues) {
            entityFieldEdit.addChange(104, this.enforceUniqueValues);
        }
        if (this.fieldType != baseEntityField.fieldType) {
            entityFieldEdit.addChange(105, this.fieldType);
        }
        if (this.stringType != baseEntityField.stringType) {
            entityFieldEdit.addChange(106, this.stringType);
        }
        if (this.keywordSearchable != baseEntityField.keywordSearchable) {
            entityFieldEdit.addChange(107, this.keywordSearchable);
        }
        if (this.dataFieldSearchable != baseEntityField.dataFieldSearchable) {
            entityFieldEdit.addChange(122, this.dataFieldSearchable);
        }
        if (this.displayedInData != baseEntityField.displayedInData) {
            entityFieldEdit.addChange(108, this.displayedInData);
        }
        if (this.listMode != baseEntityField.listMode) {
            entityFieldEdit.addChange(109, this.listMode);
        }
        if (this.delimiterType != baseEntityField.delimiterType) {
            entityFieldEdit.addChange(110, this.delimiterType);
        }
        if (this.thumbnailOption != baseEntityField.thumbnailOption) {
            entityFieldEdit.addChange(111, this.thumbnailOption);
        }
        if (this.sortOption != baseEntityField.sortOption) {
            entityFieldEdit.addChange(112, this.sortOption);
        }
        if (this.valueListAllowed != baseEntityField.valueListAllowed) {
            entityFieldEdit.addChange(113, this.valueListAllowed);
        }
        if (this.restrictionLevel != baseEntityField.restrictionLevel) {
            entityFieldEdit.addChange(114, this.restrictionLevel);
        }
        if (this.minApprovalToAddValue != baseEntityField.minApprovalToAddValue) {
            entityFieldEdit.addChange(115, this.minApprovalToAddValue);
        }
        if (this.date != baseEntityField.date) {
            entityFieldEdit.addChange(123, this.date);
        }
        if (this.displayInRelatedEntities != baseEntityField.displayInRelatedEntities) {
            entityFieldEdit.addChange(116, this.displayInRelatedEntities);
        }
        if (this.pickable != baseEntityField.pickable) {
            entityFieldEdit.addChange(117, this.pickable);
        }
        if (this.hierarchyMode != baseEntityField.hierarchyMode) {
            entityFieldEdit.addChange(118, this.hierarchyMode);
        }
        if (this.tableID != baseEntityField.tableID) {
            entityFieldEdit.addChange(120, this.tableID);
        }
        if (!CoreUtilities.isEqual(this.descriptionURL, baseEntityField.descriptionURL)) {
            entityFieldEdit.addChange(8, this.descriptionURL);
        }
        if (!CoreUtilities.isEqual(this.hierarchyName, baseEntityField.hierarchyName)) {
            entityFieldEdit.addChange(119, this.hierarchyName);
        }
        if (!CoreUtilities.isEqual(this.fieldValueColumnName, baseEntityField.fieldValueColumnName)) {
            entityFieldEdit.addChange(121, this.fieldValueColumnName);
        }
        this.checkMappingFields(baseEntityField, entityFieldEdit);
        this.checkThumbSortFields(iTemplate, iTemplate2, entityFieldEdit);
        if (entityFieldEdit.getPropertyChanges() != null) {
            arrayList.add(entityFieldEdit);
        }
        if (this.parentType != null && baseEntityField.parentType != null && this.parentType.getID() != baseEntityField.parentType.getID()) {
            arrayList.add(new EntityFieldEdit(5, baseEntityField, this));
        }
        return arrayList;
    }

    protected void checkThumbSortFields(ITemplate iTemplate, ITemplate iTemplate2, EntityFieldEdit entityFieldEdit) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        BaseEntityField[] baseEntityFieldArray = iTemplate2.getSortFields();
        BaseEntityField[] baseEntityFieldArray2 = iTemplate2.getThumbnailFields();
        for (n = 0; n < baseEntityFieldArray.length; ++n) {
            if (baseEntityFieldArray[n] != null && baseEntityFieldArray[n].getID() == this.getID()) {
                n4 = n;
            }
            if (baseEntityFieldArray2[n] == null || baseEntityFieldArray2[n].getID() != this.getID()) continue;
            n2 = n;
        }
        baseEntityFieldArray = iTemplate.getSortFields();
        baseEntityFieldArray2 = iTemplate.getThumbnailFields();
        for (n = 0; n < baseEntityFieldArray.length; ++n) {
            if (baseEntityFieldArray[n] != null && baseEntityFieldArray[n].getID() == this.getID()) {
                n5 = n;
            }
            if (baseEntityFieldArray2[n] == null || baseEntityFieldArray2[n].getID() != this.getID()) continue;
            n3 = n;
        }
        if (n2 != n3) {
            entityFieldEdit.addChange(124, n3 != -1);
        }
        if (n4 != n5) {
            entityFieldEdit.addChange(125, n5 != -1);
        }
    }

    protected void checkMappingFields(BaseEntityField baseEntityField, EntityFieldEdit entityFieldEdit) {
        List list = baseEntityField.getFieldMappings(0);
        HashSet hashSet = (HashSet)this.mappingFieldsMap.get(new Integer(0));
        int n = 0;
        int n2 = 0;
        if (list != null) {
            n = list.size();
        }
        if (hashSet != null) {
            n2 = hashSet.size();
        }
        if (n == n2) {
            if (n > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    String string = e.toString();
                    boolean bl = false;
                    Iterator iterator2 = hashSet.iterator();
                    while (iterator2.hasNext()) {
                        Object e2 = iterator2.next();
                        String string2 = e2.toString();
                        if (!string.equalsIgnoreCase(string2)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    entityFieldEdit.addChange(126, true);
                }
            }
        } else {
            entityFieldEdit.addChange(126, true);
        }
    }

    public String toString() {
        return this.displayName;
    }

    private static abstract class BaseFieldProfile
    implements IFieldProfile,
    Serializable {
        private String profileName;
        private String descriptionUrl;
        private int fieldType;
        private boolean searchable;
        private int selectListBehavior;
        private boolean thumbnailOption;
        private boolean sortOption;
        private boolean displayedInData;
        private int dataDisplayType;
        private int delimiterType;
        private boolean keywordIndexed;
        private boolean required;
        private boolean enforceUniqueValues;
        private boolean allowRepeatingValues;
        private boolean hierarchy;
        private IntegerRange integerRange;
        private boolean fuzzyDate;
        private boolean valueListAllowed;
        private int maxValueLength;
        private boolean cloned;

        private BaseFieldProfile(String string, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, int n3, int n4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, IntegerRange integerRange, boolean bl11, int n5, String string2) {
            this.profileName = string;
            this.fieldType = n;
            this.searchable = bl;
            this.selectListBehavior = n2;
            this.thumbnailOption = bl2;
            this.sortOption = bl3;
            this.displayedInData = bl4;
            this.dataDisplayType = n3;
            this.delimiterType = n4;
            this.keywordIndexed = bl5;
            this.required = bl6;
            this.enforceUniqueValues = bl7;
            this.allowRepeatingValues = bl8;
            this.valueListAllowed = bl9;
            this.hierarchy = bl10;
            this.integerRange = integerRange;
            this.fuzzyDate = bl11;
            this.maxValueLength = n5;
            this.descriptionUrl = string2;
        }

        public IFieldProfile cloneProfile(String string) {
            BaseFieldProfile baseFieldProfile = this.allocateProfile();
            baseFieldProfile.cloned = true;
            baseFieldProfile.profileName = string;
            baseFieldProfile.fieldType = this.fieldType;
            baseFieldProfile.searchable = this.searchable;
            baseFieldProfile.selectListBehavior = this.selectListBehavior;
            baseFieldProfile.thumbnailOption = this.thumbnailOption;
            baseFieldProfile.sortOption = this.sortOption;
            baseFieldProfile.displayedInData = this.displayedInData;
            baseFieldProfile.dataDisplayType = this.dataDisplayType;
            baseFieldProfile.delimiterType = this.delimiterType;
            baseFieldProfile.keywordIndexed = this.keywordIndexed;
            baseFieldProfile.required = this.required;
            baseFieldProfile.enforceUniqueValues = this.enforceUniqueValues;
            baseFieldProfile.allowRepeatingValues = this.allowRepeatingValues;
            baseFieldProfile.valueListAllowed = this.valueListAllowed;
            baseFieldProfile.hierarchy = this.hierarchy;
            baseFieldProfile.integerRange = this.integerRange;
            baseFieldProfile.fuzzyDate = this.fuzzyDate;
            baseFieldProfile.maxValueLength = this.maxValueLength;
            baseFieldProfile.descriptionUrl = this.descriptionUrl;
            return baseFieldProfile;
        }

        protected abstract BaseFieldProfile allocateProfile();

        public String getProfileName() {
            return this.profileName;
        }

        public void setProfileName(String string) {
            this.profileName = string;
        }

        public int getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(int n) {
            this.fieldType = n;
        }

        public boolean isDataFieldSearchable() {
            return this.searchable;
        }

        public void setDataFieldSearchable(boolean bl) {
            this.searchable = bl;
        }

        public int getSelectListBehavior() {
            return this.selectListBehavior;
        }

        public void setSelectListBehavior(int n) {
            this.selectListBehavior = n;
        }

        public boolean isThumbnailOption() {
            return this.thumbnailOption;
        }

        public void setThumbnailOption(boolean bl) {
            this.thumbnailOption = bl;
        }

        public boolean isUseHierarchy() {
            return this.hierarchy;
        }

        public void setUseHierarchy(boolean bl) {
            this.hierarchy = bl;
        }

        public boolean isSortOption() {
            return this.sortOption;
        }

        public void setSortOption(boolean bl) {
            this.sortOption = bl;
        }

        public boolean isDisplayedInData() {
            return this.displayedInData;
        }

        public void setDisplayedInData(boolean bl) {
            this.displayedInData = bl;
        }

        public int getDataDisplayType() {
            return this.dataDisplayType;
        }

        public void setDataDisplayType(int n) {
            this.dataDisplayType = n;
        }

        public int getDelimiterType() {
            return this.delimiterType;
        }

        public void setDelimiterType(int n) {
            this.delimiterType = n;
        }

        public boolean isKeywordSearchable() {
            return this.keywordIndexed;
        }

        public void setKeywordSearchable(boolean bl) {
            this.keywordIndexed = bl;
        }

        public void setRequired(boolean bl) {
            this.required = bl;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isEnforceUniqueValues() {
            return this.enforceUniqueValues;
        }

        public void setEnforceUniqueValues(boolean bl) {
            this.enforceUniqueValues = bl;
        }

        public boolean isAllowRepeatingValues() {
            return this.allowRepeatingValues;
        }

        public void setAllowRepeatingValues(boolean bl) {
            this.allowRepeatingValues = bl;
        }

        public boolean isValueListAllowed() {
            return this.valueListAllowed;
        }

        public void setValueListAllowed(boolean bl) {
            this.valueListAllowed = bl;
        }

        public boolean isIntegerRangeEnforced() {
            return this.integerRange != null;
        }

        public IntegerRange getIntegerRange() {
            return this.integerRange;
        }

        public void setIntegerRange(IntegerRange integerRange) {
            this.integerRange = integerRange;
        }

        public boolean isFuzzyDate() {
            return this.fuzzyDate;
        }

        public void setFuzzyDatesEnabled(boolean bl) {
            this.fuzzyDate = bl;
        }

        public void setMaxValueLength(int n) {
            this.maxValueLength = n;
        }

        public int getMaxValueLength() {
            return this.maxValueLength;
        }

        public boolean isClonedProfile() {
            return this.cloned;
        }

        public String getDescriptionUrl() {
            return this.descriptionUrl;
        }

        public void setDescriptionUrl(String string) {
            this.descriptionUrl = string;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof BaseEntityField)) {
                return false;
            }
            BaseEntityField baseEntityField = (BaseEntityField)object;
            return this.fieldType == baseEntityField.getFieldType() && this.searchable == baseEntityField.isDataFieldSearchable() && this.selectListBehavior == baseEntityField.getSelectListBehavior() && this.thumbnailOption == baseEntityField.isThumbnailOption() && this.sortOption == baseEntityField.isSortOption() && this.displayedInData == baseEntityField.isDisplayedInData() && this.dataDisplayType == baseEntityField.getDataDisplayType() && this.delimiterType == baseEntityField.getDelimiterType() && this.keywordIndexed == baseEntityField.isKeywordSearchable() && this.required == baseEntityField.isRequired() && this.enforceUniqueValues == baseEntityField.isUseUniqueValues() && this.allowRepeatingValues == baseEntityField.isAllowRepeatingValues() && this.valueListAllowed == baseEntityField.isValueListAllowed() && this.hierarchy == (baseEntityField.getHierarchy() != null && !baseEntityField.getHierarchy().equals("")) && this.integerRange == baseEntityField.getIntegerRange() && this.fuzzyDate == baseEntityField.isFuzzyDate() && CoreUtilities.isEqual(this.descriptionUrl, baseEntityField.getDescriptionUrl());
        }
    }

    private static final class UniqueIDFieldProfile
    extends BaseFieldProfile
    implements Serializable {
        private UniqueIDFieldProfile() {
            super("Required", 1, true, 2, true, true, true, 2, 1, true, true, true, false, false, false, null, false, 100, "");
        }

        protected BaseFieldProfile allocateProfile() {
            return new UniqueIDFieldProfile();
        }
    }

    private static final class DateFieldProfile
    extends BaseFieldProfile
    implements Serializable {
        private DateFieldProfile() {
            super("Date", 1, true, 2, true, true, true, 2, 1, true, false, false, false, true, false, null, true, 100, "");
        }

        protected BaseFieldProfile allocateProfile() {
            return new DateFieldProfile();
        }
    }

    private static final class NumericFieldProfile
    extends BaseFieldProfile
    implements Serializable {
        private NumericFieldProfile() {
            super("Numeric", 2, true, 2, true, true, true, 2, 1, true, false, false, false, true, false, null, false, 4, "");
        }

        protected BaseFieldProfile allocateProfile() {
            return new NumericFieldProfile();
        }
    }

    private static final class LongTextFieldProfile
    extends BaseFieldProfile
    implements Serializable {
        private LongTextFieldProfile() {
            super("Long Text", 1, true, 1, true, true, true, 1, 1, true, false, false, false, false, false, null, false, 3000, "");
        }

        protected BaseFieldProfile allocateProfile() {
            return new LongTextFieldProfile();
        }
    }

    private static final class ShortTextFieldProfile
    extends BaseFieldProfile
    implements Serializable {
        private ShortTextFieldProfile() {
            super("Short Text", 1, true, 2, true, true, true, 2, 1, true, false, false, false, true, false, null, false, 255, "");
        }

        protected BaseFieldProfile allocateProfile() {
            return new ShortTextFieldProfile();
        }
    }
}

