/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog;

import com.luna.insight.core.catalog.PersistentCatalogTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.util.CoreUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TemplateManager {
    public static String TEMPLATE_SUFFIX = ".tmpl";
    public static final String TEMPLATE_DIR = ".Template-Files";
    public static String TEMPLATE_WORK_PATH = CoreUtilities.getUserHomeDirFilepath(".Template-Files", "LunaImaging");

    public static boolean saveUnpublishedTemplate(BaseTemplate baseTemplate) {
        String string = baseTemplate.getTemplateName() + TEMPLATE_SUFFIX;
        if (baseTemplate instanceof PersistentCatalogTemplate) {
            boolean bl;
            PersistentCatalogTemplate persistentCatalogTemplate = (PersistentCatalogTemplate)baseTemplate;
            boolean bl2 = bl = persistentCatalogTemplate.getFileName() != null && !persistentCatalogTemplate.getFileName().equals(string);
            if (bl) {
                File file = new File(TEMPLATE_WORK_PATH, persistentCatalogTemplate.getFileName());
                if (bl && file.exists()) {
                    file.delete();
                }
            }
            persistentCatalogTemplate.setFileName(string);
        }
        boolean bl = CoreUtilities.writeSerializeableObjectToFS(new File(TEMPLATE_WORK_PATH), string, baseTemplate, true);
        return bl;
    }

    public static boolean deleteUnpublishedTemplate(BaseTemplate baseTemplate) {
        String string = baseTemplate.getTemplateName() + TEMPLATE_SUFFIX;
        return CoreUtilities.removeSerializeableObjectFromFS(new File(TEMPLATE_WORK_PATH), string, baseTemplate);
    }

    public static boolean deleteUnpublishedTemplate(String string) {
        String string2 = string + TEMPLATE_SUFFIX;
        return new File(TEMPLATE_WORK_PATH, string2).delete();
    }

    public static PersistentCatalogTemplate loadUnpublishedTemplate(String string) {
        Serializable serializable;
        PersistentCatalogTemplate persistentCatalogTemplate;
        if (string == null || string.trim().equals("")) {
            return null;
        }
        if (!string.endsWith(TEMPLATE_SUFFIX)) {
            string = string + TEMPLATE_SUFFIX;
        }
        if ((persistentCatalogTemplate = (PersistentCatalogTemplate)(serializable = CoreUtilities.loadSerializeableObjectFromFS(new File(TEMPLATE_WORK_PATH), string))) != null) {
            persistentCatalogTemplate.setNewTemplate(true);
            persistentCatalogTemplate.setFileName(string);
        }
        return persistentCatalogTemplate;
    }

    public static boolean doesTemplateExist(String string) {
        return new File(TEMPLATE_WORK_PATH, string + TEMPLATE_SUFFIX).exists();
    }

    public static Map getUnpublishedTemplates() {
        HashMap hashMap = new HashMap();
        File file = new File(TEMPLATE_WORK_PATH);
        if (file.mkdirs()) {
            return hashMap;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(TEMPLATE_SUFFIX);
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].substring(0, stringArray[i].indexOf(TEMPLATE_SUFFIX));
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, null);
        }
        return hashMap;
    }
}

