/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.layouts;

import com.luna.insight.server.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JViewport;

public class DynamicGridLayout
implements LayoutManager {
    protected int xGap = 5;
    protected int yGap = 5;
    protected int xInsets = 5;
    protected int yInsets = 5;
    protected Dimension largestComponentSize = new Dimension(0, 0);
    protected int previouslyKnownComponentCount = 0;

    public static void debugOut(String string) {
        DynamicGridLayout.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("DynamicGridLayout: " + string, n);
    }

    public DynamicGridLayout() {
    }

    public DynamicGridLayout(int n, int n2) {
        this.xGap = n;
        this.yGap = n2;
    }

    public DynamicGridLayout(int n, int n2, int n3, int n4) {
        this.xGap = n;
        this.yGap = n2;
        this.xInsets = n3;
        this.yInsets = n4;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Dimension dimension = container.getSize();
            if (container.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)container.getParent();
                dimension.width = jViewport.getExtentSize().width;
            }
            if ((n = container.getComponentCount()) != this.previouslyKnownComponentCount) {
                this.largestComponentSize = this.getLargestComponentSize(container);
                this.previouslyKnownComponentCount = n;
            }
            int n2 = this.largestComponentSize.width;
            int n3 = this.largestComponentSize.height;
            int n4 = this.yInsets;
            int n5 = this.xInsets;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (n5 + n2 < dimension.width) {
                    component.setBounds(n5, n4, n2, n3);
                } else {
                    if (n5 != this.xInsets) {
                        n4 += n3 + this.yGap;
                        n5 = this.xInsets;
                    }
                    component.setBounds(n5, n4, n2, n3);
                }
                component.doLayout();
                n5 += n2 + this.xGap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Dimension dimension = container.getSize();
            if (container.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)container.getParent();
                dimension.width = jViewport.getExtentSize().width;
            }
            if ((n = container.getComponentCount()) != this.previouslyKnownComponentCount) {
                this.largestComponentSize = this.getLargestComponentSize(container);
                this.previouslyKnownComponentCount = n;
            }
            int n2 = this.largestComponentSize.width;
            int n3 = this.largestComponentSize.height;
            int n4 = this.yInsets;
            int n5 = this.xInsets;
            int n6 = 0;
            for (int i = 0; i < n; ++i) {
                if (n5 + n2 >= dimension.width && n5 != this.xInsets) {
                    n4 += n3 + this.yGap;
                    n5 = this.xInsets;
                }
                if ((n5 += n2 + this.xGap) - this.xGap <= n6) continue;
                n6 = n5 - this.xGap;
            }
            return new Dimension(n6, n4 + n3 + this.yGap);
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    protected Dimension getLargestComponentSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (component.getMinimumSize().width > n) {
                n = component.getMinimumSize().width;
            }
            if (component.getMinimumSize().height <= n2) continue;
            n2 = component.getMinimumSize().height;
        }
        return new Dimension(n, n2);
    }
}

