/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.verifier;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.verifier.AdminComponentVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class StringLengthJTextComponentVerifier
extends AdminComponentVerifier {
    private boolean allowEmpty = false;
    private int maxLength = 0;

    public StringLengthJTextComponentVerifier(int n) {
        this(n, false);
    }

    public StringLengthJTextComponentVerifier(int n, boolean bl) {
        this.maxLength = n;
        this.allowEmpty = bl;
    }

    public boolean verify(JComponent jComponent) {
        if (this.acceptAll) {
            return true;
        }
        String string = ((JTextComponent)jComponent).getText();
        if (this.allowEmpty && (string == null || string.equals(""))) {
            return true;
        }
        if (string == null || string.equals("")) {
            InsightAdministrator.showWarningDialog(jComponent, "This field must be given a value.", "Form Validation Warning");
            return false;
        }
        if (string.length() > this.maxLength) {
            InsightAdministrator.showWarningDialog(jComponent, "This value for this field cannot exceed " + this.maxLength + " characters.", "Form Validation Warning");
            return false;
        }
        return true;
    }
}

