/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.verifier;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.verifier.AdminComponentVerifier;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class IntegerRangeStringJTextComponentVerifier
extends AdminComponentVerifier {
    private boolean allowEmpty = false;

    public IntegerRangeStringJTextComponentVerifier() {
        this(false);
    }

    public IntegerRangeStringJTextComponentVerifier(boolean bl) {
        this.allowEmpty = bl;
    }

    public boolean verify(JComponent jComponent) {
        if (this.acceptAll) {
            return true;
        }
        String string = ((JTextComponent)jComponent).getText();
        if (this.allowEmpty && (string == null || string.equals(""))) {
            return true;
        }
        if (this.isValidIntegerRange(string, jComponent)) {
            return true;
        }
        return this.verifyFailed(jComponent);
    }

    private boolean isValidIntegerRange(String string, JComponent jComponent) {
        if (string == null) {
            return this.verifyFailed(jComponent);
        }
        if (string.startsWith(":") || string.endsWith(":")) {
            return this.verifyFailed(jComponent);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ": \t");
        if (stringTokenizer.countTokens() != 2) {
            return this.verifyFailed(jComponent);
        }
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return this.verifyFailed(jComponent);
        }
        return true;
    }

    private boolean verifyFailed(JComponent jComponent) {
        String string = "This field must contain an integer range of the form 'n:m'.";
        InsightAdministrator.showWarningDialog(jComponent, string, "Form Validation Warning");
        return false;
    }
}

