/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.verifier;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.verifier.AdminComponentVerifier;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class IPAddressJTextComponentVerifier
extends AdminComponentVerifier {
    public String getVerifyMessage() {
        return "This field does not contain a valid IP address.";
    }

    public boolean verify(JComponent jComponent) {
        if (this.acceptAll) {
            return true;
        }
        String string = ((JTextComponent)jComponent).getText();
        if (this.validateIPAddress(string) || string.length() == 0) {
            return true;
        }
        InsightAdministrator.showWarningDialog(jComponent, this.getVerifyMessage(), "Form Validation Warning");
        return false;
    }

    private boolean validateIPAddress(String string) {
        Pattern pattern = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
        return pattern.matcher(string).matches();
    }
}

