/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.verifier;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.verifier.AdminComponentVerifier;
import com.luna.insight.admin.verifier.CustomVerificationChecker;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class CustomJTextComponentVerifier
extends AdminComponentVerifier {
    public static final int NO_DATATYPE_CHECK = 0;
    public static final int ALLOW_INT_ONLY = 1;
    public static final int ALLOW_LONG_ONLY = 2;
    private boolean allowEmpty = false;
    private int dataTypeAllowed = 0;
    private CustomVerificationChecker customChecker = null;

    public CustomJTextComponentVerifier(CustomVerificationChecker customVerificationChecker) {
        this(customVerificationChecker, 0, false);
    }

    public CustomJTextComponentVerifier(CustomVerificationChecker customVerificationChecker, int n) {
        this(customVerificationChecker, n, false);
    }

    public CustomJTextComponentVerifier(CustomVerificationChecker customVerificationChecker, int n, boolean bl) {
        this.customChecker = customVerificationChecker;
        this.dataTypeAllowed = n;
        this.allowEmpty = bl;
    }

    public boolean verify(JComponent jComponent) {
        if (this.acceptAll) {
            return true;
        }
        String string = ((JTextComponent)jComponent).getText();
        if (this.allowEmpty && (string == null || string.equals(""))) {
            return true;
        }
        switch (this.dataTypeAllowed) {
            case 1: {
                try {
                    int n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    InsightAdministrator.showWarningDialog(jComponent, "This field must be given an integer value.", "Form Validation Warning");
                    return false;
                }
            }
            case 2: {
                try {
                    long l = Long.parseLong(string);
                    break;
                }
                catch (Exception exception) {
                    InsightAdministrator.showWarningDialog(jComponent, "This field must be given a long value.", "Form Validation Warning");
                    return false;
                }
            }
        }
        boolean bl = false;
        try {
            bl = this.customChecker.verify(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            InsightAdministrator.showWarningDialog(jComponent, this.customChecker.getFailedMessage(), "Form Validation Warning");
            return false;
        }
        return true;
    }
}

