/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfile;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class UserServerUserProfilesNode
extends TableDisplayControlPanelNode {
    protected UserServerNode userServerNode = null;

    public UserServerUserProfilesNode(UserServerNode userServerNode) {
        super(userServerNode.getUserServer().getInsightAdministrator(), "User Profiles", false);
        this.userServerNode = userServerNode;
        this.columnNames = new Object[]{"Profile Name", "Member Groups"};
    }

    public void updateInformationDisplay() {
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            UserServerUserProfile userServerUserProfile = (UserServerUserProfile)vector.elementAt(i);
            objectArray[i][0] = userServerUserProfile;
            objectArray[i][1] = "" + userServerUserProfile.profileGroups.size();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New User Profile Command", this.userServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.userServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-user-profiles-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return UserServerNode.createServerNodePopupMenu(actionListener, n, this.userServerNode.getAdminAccount(), "New User Profile Command", "Edit User Profile Command", "Delete User Profile Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Profile Command")) {
            this.userServerNode.createNewUserProfile();
        } else if (string.equals("Delete User Profile Command")) {
            if (vector != null && vector.size() > 0) {
                this.userServerNode.removeUserProfiles(vector);
            }
        } else if (string.equals("Edit User Profile Command") && vector != null && vector.size() == 1) {
            this.userServerNode.editUserProfile((UserServerUserProfile)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.userServerNode.editUserProfile((UserServerUserProfile)object);
        }
    }

    public static void debugOut(String string) {
        UserServerUserProfilesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUserProfilesNode: " + string, n);
    }
}

