/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class UserServerUserGroupsNode
extends TableDisplayControlPanelNode {
    protected UserServerNode userServerNode = null;

    public UserServerUserGroupsNode(UserServerNode userServerNode) {
        super(userServerNode.getUserServer().getInsightAdministrator(), "User Groups", false);
        this.userServerNode = userServerNode;
        this.columnNames = new Object[]{"Group Name", "Display Name", "Created", "Modified"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.userServerNode.getUserServer().getUserGroups()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            UserServerUserGroup userServerUserGroup = (UserServerUserGroup)vector.elementAt(i);
            objectArray[i][0] = userServerUserGroup;
            objectArray[i][1] = userServerUserGroup.displayName;
            objectArray[i][2] = new SimpleDate(userServerUserGroup.createdTimestamp).getFull();
            objectArray[i][3] = new SimpleDate(userServerUserGroup.modifiedTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New User Group Command", this.userServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.userServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-user-groups-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.userServerNode.getAdminAccount(), "New User Group Command", "Edit User Group Command", "Delete User Group Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Group Command")) {
            this.userServerNode.createNewUserGroup();
        } else if (string.equals("Delete User Group Command")) {
            if (vector != null && vector.size() > 0) {
                this.userServerNode.removeUserGroups(vector);
            }
        } else if (string.equals("Edit User Group Command") && vector != null && vector.size() == 1) {
            this.userServerNode.editUserGroup((UserServerUserGroup)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.userServerNode.editUserGroup((UserServerUserGroup)object);
        }
    }

    public static void debugOut(String string) {
        UserServerUserGroupsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUserGroupsNode: " + string, n);
    }
}

