/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.ImageGroupFileDataObject;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class UsUserGroupNode
extends TableDisplayControlPanelNode {
    protected UserServerNode serverNode = null;
    protected UserServerShare userShare = null;

    public static void debugOut(String string) {
        UsUserGroupNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UsUserGroupNode: " + string, n);
    }

    public UsUserGroupNode(UserServerNode userServerNode, UserServerShare userServerShare) {
        super(userServerNode.getUserServer().getInsightAdministrator(), userServerShare.getName(), false);
        this.serverNode = userServerNode;
        this.userShare = userServerShare;
        this.columnNames = new Object[]{"Image Group File Name", "Created/Modified"};
    }

    public UserServerNode getServerNode() {
        return this.serverNode;
    }

    public UserServerShare getUserShare() {
        return this.userShare;
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.serverNode.getImageGroupFileList(this.userShare.getName(), this.userShare.getCodeKey())), this.columnNames);
    }

    private Object[][] getTableData(List list) {
        Object[][] objectArray = new Object[list.size()][this.columnNames.length];
        for (int i = 0; list != null && i < list.size(); ++i) {
            ImageGroupFileDataObject imageGroupFileDataObject = new ImageGroupFileDataObject(this, this.userShare, (File)list.get(i));
            objectArray[i][0] = imageGroupFileDataObject;
            objectArray[i][1] = imageGroupFileDataObject.getLastModified();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.serverNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/us-user-group-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = this.serverNode.getAdminAccount().createPermittedServerMenuItem("View/Rename Image Group File", "view-rename-image-group-file", actionListener);
        jMenuItem.setEnabled(n == 1);
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.serverNode.getAdminAccount().createPermittedServerMenuItem("Delete Image Group File" + (n == 1 ? "" : "s"), "delete-image-group-file", actionListener);
        jMenuItem.setEnabled(n > 0);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void actionPerformed(String string, Vector vector) {
        UsUserGroupNode.debugOut("Received action: " + string);
        if (string.equals("view-rename-image-group-file")) {
            if (vector != null && vector.size() > 0) {
                this.serverNode.editImageGroupFile((ImageGroupFileDataObject)vector.get(0));
            }
        } else if (string.equals("delete-image-group-file") && vector != null && vector.size() > 0) {
            this.serverNode.deleteImageGroupFiles(this.userShare.getName(), this.userShare.getCodeKey(), vector);
            this.updateInformationDisplay();
        }
    }

    public void defaultItemAction(Object object) {
        if (object instanceof ImageGroupFileDataObject) {
            this.serverNode.editImageGroupFile((ImageGroupFileDataObject)object);
        }
    }
}

