/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.share;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class UserServerSharesNode
extends TableDisplayControlPanelNode {
    protected UserServerNode userServerNode;

    public UserServerSharesNode(UserServerNode userServerNode) {
        super(userServerNode.getUserServer().getInsightAdministrator(), "User Shares", false);
        this.userServerNode = userServerNode;
        this.columnNames = new Object[]{"Share Name", "Owner", "Created", "Modified"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.userServerNode.getUserServer().getUserShares()), this.columnNames);
    }

    private Object[][] getTableData(List list) {
        HashMap<Integer, UserServerUser> hashMap = new HashMap<Integer, UserServerUser>();
        Object[][] objectArray = this.userServerNode.getUserServer().getUsers().iterator();
        while (objectArray.hasNext()) {
            UserServerUser userServerUser = (UserServerUser)objectArray.next();
            hashMap.put(new Integer(userServerUser.getIndex()), userServerUser);
        }
        objectArray = new Object[list.size()][this.columnNames.length];
        for (int i = 0; i < list.size(); ++i) {
            UserServerShare userServerShare = (UserServerShare)list.get(i);
            objectArray[i][0] = userServerShare;
            UserServerUser userServerUser = (UserServerUser)hashMap.get(new Integer(userServerShare.ownerID));
            objectArray[i][1] = userServerUser == null ? "" : userServerUser.getName();
            objectArray[i][2] = new SimpleDate(userServerShare.createdTimestamp).getFull();
            objectArray[i][3] = new SimpleDate(userServerShare.modifiedTimestamp).getFull();
        }
        return objectArray;
    }

    public boolean hasReadPermission() {
        return this.userServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.userServerNode.getAdminAccount(), "New User Share Command", "Edit User Share Command", "Delete User Share Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Share Command")) {
            this.userServerNode.createNewUserShare();
        } else if (string.equals("Delete User Share Command")) {
            if (vector != null && vector.size() > 0) {
                this.userServerNode.removeUserShares(vector);
            }
        } else if (string.equals("Edit User Share Command") && vector != null && vector.size() == 1) {
            this.userServerNode.editUserShare((UserServerShare)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.userServerNode.editUserShare((UserServerShare)object);
        }
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New User Share Command", this.userServerNode));
        return jPopupMenu;
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-user-groups-node-icon.gif");
        }
        return this.treeIcon;
    }

    public static void debugOut(String string) {
        UserServerSharesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUserGroupsNode: " + string, n);
    }
}

