/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.share;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.share.UserInShare;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class UserServerShareRecordHandler
extends DatabaseRecordHandler {
    public UserServerShareRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "UserServerUserShareRecordHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        DatabaseConnector databaseConnector = null;
        UserServerShare userServerShare = (UserServerShare)databaseRecord;
        try {
            databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareID", 2, stringBuffer2, userServerShare.shareID);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareName", 1, stringBuffer2, userServerShare.shareName);
            if (userServerShare.legacyCodeKey != null) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LegacyCodeKey", 1, stringBuffer2, userServerShare.legacyCodeKey);
            }
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "OwnerID", 2, stringBuffer2, userServerShare.ownerID);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, userServerShare.createdTimestamp);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ModifiedTimestamp", 1, stringBuffer2, userServerShare.modifiedTimestamp);
            databaseConnector.setQuery("INSERT INTO USERSHARES (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")");
            this.debugOut("insert share query = " + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = userServerShare.users.iterator();
            while (iterator.hasNext()) {
                UserInShare userInShare = (UserInShare)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, userInShare.userID);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShareID", 2, stringBuffer2, userServerShare.shareID);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "WritePriv", 2, stringBuffer2, userInShare.writePriv);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DeletePriv", 2, stringBuffer2, userInShare.deletePriv);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreateFolderPriv", 2, stringBuffer2, userInShare.createPriv);
                String string = "INSERT INTO USERSHAREMAP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                arrayList.add(string);
            }
            databaseConnector.executeBatch(arrayList, false);
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        DatabaseConnector databaseConnector = null;
        UserServerShare userServerShare = (UserServerShare)databaseRecord;
        try {
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM USERSHARES WHERE ShareID = " + userServerShare.shareID);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("DELETE FROM USERSHAREMAP WHERE ShareID = " + userServerShare.shareID);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRecords() {
        this.debugOut("in getRecords()");
        DatabaseConnector databaseConnector = null;
        HashMap<Integer, UserServerShare> hashMap = new HashMap<Integer, UserServerShare>();
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHARES", null, "*");
            sqlQueryGenerator.addOrderBy("USERSHARES", "ShareID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("User Shares query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                UserServerShare userServerShare = new UserServerShare((UserServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerField("ShareID"), databaseConnector.getIntegerField("OwnerID"), databaseConnector.getField("ShareName"), databaseConnector.getFieldByName("LegacyCodeKey"), databaseConnector.getFieldByName("CreatedTimestamp"), databaseConnector.getFieldByName("ModifiedTimestamp"));
                hashMap.put(new Integer(userServerShare.shareID), userServerShare);
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHAREMAP", null, "*");
            sqlQueryGenerator.addTable("USERLIST", null, "UserName");
            sqlQueryGenerator.addJoin("USERSHAREMAP", "USERLIST", "UserID", 0);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("user-share mapping query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                int n = databaseConnector.getIntegerFieldByName("ShareID");
                UserServerShare userServerShare = (UserServerShare)hashMap.get(new Integer(n));
                if (userServerShare != null) {
                    UserInShare userInShare = new UserInShare(databaseConnector.getIntegerField("UserID"), databaseConnector.getField("UserName"), databaseConnector.getBooleanField("WritePriv", false), databaseConnector.getBooleanField("DeletePriv", false), databaseConnector.getBooleanField("CreateFolderPriv", false));
                    userServerShare.addUserInShare(userInShare);
                } else {
                    this.debugOut("Could not find share with ShareID: " + n);
                }
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return new Vector(hashMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        DatabaseConnector databaseConnector = null;
        UserServerShare userServerShare = null;
        UserServerShare userServerShare2 = (UserServerShare)databaseRecord;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERSHARES", null, "*");
            sqlQueryGenerator.appendToWhere("ShareID = " + userServerShare2.shareID);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("User Shares query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                userServerShare = new UserServerShare(userServerShare2.userServer, userServerShare2.shareID, databaseConnector.getIntegerField("OwnerID"), databaseConnector.getField("ShareName"), databaseConnector.getFieldByName("LegacyCodeKey"), databaseConnector.getFieldByName("CreatedTimestamp"), databaseConnector.getFieldByName("ModifiedTimestamp"));
            }
            databaseConnector.close();
            if (userServerShare != null) {
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("USERSHAREMAP", null, "*");
                sqlQueryGenerator.addTable("USERLIST", null, "UserName");
                sqlQueryGenerator.addJoin("USERSHAREMAP", "USERLIST", "UserID", 0);
                sqlQueryGenerator.appendToWhere("USERSHAREMAP.ShareID = " + userServerShare2.shareID);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("User - Shares mapping query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    UserInShare userInShare = new UserInShare(databaseConnector.getIntegerField("UserID"), databaseConnector.getField("UserName"), databaseConnector.getBooleanField("WritePriv", false), databaseConnector.getBooleanField("DeletePriv", false), databaseConnector.getBooleanField("CreateFolderPriv", false));
                    userServerShare.addUserInShare(userInShare);
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return userServerShare;
    }

    public String getNextValidIDQuery() {
        return "SELECT ShareID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "USERSHARES" + " ORDER BY ShareID";
    }

    public void updateMaxIDValue(long l) {
    }
}

