/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.collection;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.collection.UserServerCollection;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UserServerCollectionRecordHandler
extends DatabaseRecordHandler {
    public UserServerCollectionRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "UserServerCollectionRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            String string;
            Integer n;
            UserServerCollection userServerCollection = (UserServerCollection)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string2 = null;
            if (userServerCollection.recordType == 0) {
                string2 = userServerCollection.getCollectionID();
            } else if (userServerCollection.initialCollectionID == null) {
                Integer n2 = this.getNextCollectionIDForServer(userServerCollection);
                if (n2 == null) {
                    return;
                }
                userServerCollection.collectionID = string2 = n2.toString();
            } else {
                string2 = userServerCollection.initialCollectionID;
            }
            boolean bl = userServerCollection.recordType != 0 || userServerCollection.medeEnabled;
            userServerCollection.medeEnabled = bl;
            String string3 = "INSERT INTO COLLECTIONS (ServerID, InstitutionID, CollectionID, CollectionUniqueID, CollectionName, ServerAddress, ServerPort, MedeEnabled, IsVirtualCollection, VCID, LanguageCode, CountryCode, Type) VALUES (" + userServerCollection.serverID + ", " + this.prepForInsertQuery(userServerCollection.institutionID) + ", " + this.prepForInsertQuery(string2) + ", " + this.prepForInsertQuery(userServerCollection.getCollectionUniqueID()) + ", " + this.prepForInsertQuery(userServerCollection.collectionName) + ", " + this.prepForInsertQuery(userServerCollection.address) + ", " + userServerCollection.port + ", " + (userServerCollection.medeEnabled ? 1 : 0) + ", " + (userServerCollection.virtual ? 1 : 0) + ", " + this.prepForInsertQuery(userServerCollection.vcID) + ", " + this.prepForInsertQuery(userServerCollection.getLocaleLanguage()) + ", " + this.prepForInsertQuery(userServerCollection.getLocaleCountry()) + ", " + userServerCollection.recordType + ")";
            databaseConnector.setQuery(string3);
            this.debugOut("insertCollectionQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            Object object = userServerCollection.virtualCollections.elements();
            while (object.hasMoreElements()) {
                n = (Integer)object.nextElement();
                string = "INSERT INTO VIRTUALCOLLECTIONMAP (VirtualCollectionServerID, CollectionServerID) VALUES (" + userServerCollection.serverID + ", " + n + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            object = userServerCollection.userGroups.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                string = "INSERT INTO USERGROUPSERVERMAP (ServerID, GroupID) VALUES (" + userServerCollection.serverID + ", " + n + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM COLLECTIONS WHERE ServerID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteCollectionQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "DELETE FROM VIRTUALCOLLECTIONMAP WHERE VirtualCollectionServerID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string2);
            this.debugOut("deleteMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            string2 = "DELETE FROM USERGROUPSERVERMAP WHERE ServerID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string2);
            this.debugOut("deleteMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(true);
    }

    public Vector getRecords(boolean bl) {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        try {
            int n;
            UserServerCollection userServerCollection;
            Hashtable<Integer, UserServerCollection> hashtable = new Hashtable<Integer, UserServerCollection>();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("COLLECTIONS", null, "*");
            if (!bl) {
                sqlQueryGenerator.appendToWhere("COLLECTIONS.Type <> 2");
            }
            sqlQueryGenerator.addOrderBy("COLLECTIONS", "CollectionName");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Collections query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    userServerCollection = new UserServerCollection((UserServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ServerID"), databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getFieldByName("CollectionUniqueID"), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), databaseConnector.getIntegerFieldByName("MedeEnabled") == 1, databaseConnector.getIntegerFieldByName("IsVirtualCollection") == 1, databaseConnector.getFieldByName("VCID"), databaseConnector.getFieldByName("LanguageCode"), databaseConnector.getFieldByName("CountryCode"), databaseConnector.getIntegerFieldByName("Type"));
                    hashtable.put(new Integer(userServerCollection.serverID), userServerCollection);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("VIRTUALCOLLECTIONMAP", null, "*");
            sqlQueryGenerator.addOrderBy("VIRTUALCOLLECTIONMAP", "VirtualCollectionServerID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Collections query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                userServerCollection = null;
                while (databaseConnector.more()) {
                    n = databaseConnector.getIntegerFieldByName("VirtualCollectionServerID");
                    int n2 = databaseConnector.getIntegerFieldByName("CollectionServerID");
                    userServerCollection = (UserServerCollection)hashtable.get(new Integer(n));
                    if (userServerCollection != null) {
                        userServerCollection.addVirtualCollectionIndex(n2);
                    } else {
                        this.debugOut("Could not find collection with VirtualCollectionServerID: " + n);
                    }
                    databaseConnector.next();
                }
            } else {
                this.debugOut("Could not find virtual collection mappings.");
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERGROUPSERVERMAP", null, "*");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                int n3 = databaseConnector.getIntegerFieldByName("ServerID");
                n = databaseConnector.getIntegerFieldByName("GroupID");
                UserServerCollection userServerCollection2 = (UserServerCollection)hashtable.get(new Integer(n3));
                if (userServerCollection2 != null) {
                    userServerCollection2.addUserGroupIndex(n);
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        UserServerCollection userServerCollection = null;
        int n = databaseRecord.getIndex();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("COLLECTIONS", null, "*");
            sqlQueryGenerator.appendToWhere("ServerID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Collection query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                userServerCollection = new UserServerCollection((UserServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ServerID"), databaseConnector.getFieldByName("InstitutionID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getFieldByName("CollectionUniqueID"), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getFieldByName("ServerAddress"), databaseConnector.getIntegerFieldByName("ServerPort"), databaseConnector.getIntegerFieldByName("MedeEnabled") == 1, databaseConnector.getIntegerFieldByName("IsVirtualCollection") == 1, databaseConnector.getFieldByName("VCID"), databaseConnector.getFieldByName("LanguageCode"), databaseConnector.getFieldByName("CountryCode"), databaseConnector.getIntegerFieldByName("Type"));
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("VIRTUALCOLLECTIONMAP", null, "*");
            sqlQueryGenerator.appendToWhere("VirtualCollectionServerID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Collections query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                Object var6_7 = null;
                while (databaseConnector.more()) {
                    userServerCollection.addVirtualCollectionIndex(databaseConnector.getIntegerFieldByName("CollectionServerID"));
                    databaseConnector.next();
                }
            } else {
                this.debugOut("Could not find any virtual collection mappings.");
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("USERGROUPSERVERMAP", null, "*");
            sqlQueryGenerator.appendToWhere("ServerID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerFieldByName("GroupID");
                userServerCollection.addUserGroupIndex(n2);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        return userServerCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getNextCollectionIDForServer(UserServerCollection userServerCollection) {
        DatabaseConnector databaseConnector = null;
        Integer n = new Integer(-2);
        try {
            Integer n2;
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("COLLECTIONS", null, new String[]{"CollectionID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                try {
                    n2 = new Integer(databaseConnector.getField("CollectionID"));
                    if (n2.compareTo(n) < 0) {
                        n = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (Exception exception) {
                    this.debugOut("Exception in getNextCollectionIDForServer " + InsightUtilities.getStackTrace(exception));
                    Integer n3 = null;
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                    return n3;
                }
                databaseConnector.next();
            }
            n2 = new Integer(n - 1);
            return n2;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public String getNextValidIDQuery() {
        return "SELECT ServerID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "COLLECTIONS" + " ORDER BY ServerID";
    }

    public void updateMaxIDValue(long l) {
    }
}

