/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.collection;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.collection.UserServerCollectionEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class UserServerCollection
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
CollectionKey {
    public static final String RECORD_TYPE_COLLECTION = "Collection";
    public static final String RECORD_TYPE_PC_SERVER = "Personal Collection Server";
    public static final String RECORD_TYPE_MASTER_SERVER = "Master Server";
    protected int serverID;
    protected UserServer userServer;
    protected String collectionName = "";
    protected String collectionID = null;
    protected String initialCollectionID = null;
    protected String collectionUniqueID = null;
    protected String institutionID = null;
    protected String address = null;
    protected int port = 2450;
    protected boolean medeEnabled = true;
    protected boolean virtual = false;
    protected String vcID = "NA";
    protected String languageCode = null;
    protected String countryCode = null;
    protected Locale locale = null;
    protected Vector virtualCollections = new Vector();
    protected int recordType = 0;
    protected UserServerCollectionEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;
    protected Vector availableLocales = null;
    protected Set userGroups = new HashSet();

    public UserServerCollection(UserServer userServer, int n, String string, String string2, String string3, String string4, String string5, int n2, boolean bl, boolean bl2, String string6, String string7, String string8, int n3) {
        this.userServer = userServer;
        this.serverID = n;
        this.institutionID = string == null ? "" : string;
        this.collectionID = string2 == null ? "" : string2;
        this.initialCollectionID = string2;
        this.collectionUniqueID = string3 == null ? "" : string3;
        this.collectionName = string4 == null ? "" : string4;
        this.address = string5 == null ? "" : string5;
        this.port = n2;
        this.medeEnabled = bl;
        this.virtual = bl2;
        this.vcID = string6 == null ? "" : string6;
        this.languageCode = string7 == null ? "" : string7;
        this.countryCode = string8 == null ? "" : string8;
        this.recordType = n3;
        try {
            this.locale = new Locale(string7, string8);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public UserServerCollection(int n, UserServer userServer) {
        this.serverID = n;
        this.userServer = userServer;
        try {
            this.locale = new Locale("en", "US");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addVirtualCollectionIndex(int n) {
        Integer n2 = new Integer(n);
        if (!this.virtualCollections.contains(n2)) {
            this.virtualCollections.addElement(n2);
        }
    }

    public void addUserGroupIndex(int n) {
        this.userGroups.add(new Integer(n));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.collectionName;
    }

    public int getIndex() {
        return this.serverID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new UserServerCollectionEditComponent();
        this.editComponent.getCollectionNameField().setText(this.collectionName);
        this.editComponent.getCollectionIdField().setText(this.collectionID);
        this.editComponent.getCollectionUniqueIdField().setText(this.collectionUniqueID);
        this.editComponent.getInstitutionIdField().setText(this.institutionID);
        this.editComponent.getAddressField().setText(this.address);
        this.editComponent.getPortField().setText("" + this.port);
        this.availableLocales = this.userServer.getAvailableLocales();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.availableLocales.size(); ++i) {
            Locale locale = (Locale)this.availableLocales.elementAt(i);
            vector.addElement(locale + " - " + locale.getDisplayLanguage() + " " + locale.getDisplayCountry());
        }
        this.editComponent.getLocaleComboBox().setModel(new DefaultComboBoxModel(vector));
        this.editComponent.getLocaleComboBox().setSelectedIndex(this.availableLocales.indexOf(this.locale));
        Vector<String> vector2 = new Vector<String>();
        vector2.add(RECORD_TYPE_COLLECTION);
        vector2.add(RECORD_TYPE_PC_SERVER);
        vector2.add(RECORD_TYPE_MASTER_SERVER);
        this.editComponent.getRecordTypeComboBox().setModel(new DefaultComboBoxModel(vector2));
        this.editComponent.getRecordTypeComboBox().setSelectedIndex(this.recordType);
        this.editComponent.getCollectionNameField().selectAll();
        this.editComponent.getVirtualCollectionIDField().setText(this.vcID);
        this.itemSelector = new ListItemSelector("Available Virtual Collection Constituents:", "Virtual Collection Constituents:", this.userServer.getCollections(false), this.virtualCollections);
        this.editComponent.getVirtualCollectionMemberSelectionPanel().add(this.itemSelector);
        this.editComponent.setMedeEnabled(this.medeEnabled);
        this.editComponent.setVirtual(this.virtual);
        return this.editComponent;
    }

    public void save() {
        UserServerCollection.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.collectionName, this.editComponent.getCollectionNameField().getText())) {
            this.collectionName = this.editComponent.getCollectionNameField().getText();
        }
        if (this.editComponent.getRecordTypeComboBox().getSelectedIndex() == 0 && this.hasChanged(this.collectionID, this.editComponent.getCollectionIdField().getText())) {
            this.collectionID = this.editComponent.getCollectionIdField().getText();
        }
        if (this.hasChanged(this.collectionUniqueID, this.editComponent.getCollectionUniqueIdField().getText())) {
            this.collectionUniqueID = this.editComponent.getCollectionUniqueIdField().getText();
        }
        if (this.hasChanged(this.institutionID, this.editComponent.getInstitutionIdField().getText())) {
            this.institutionID = this.editComponent.getInstitutionIdField().getText();
        }
        if (this.hasChanged(this.address, this.editComponent.getAddressField().getText())) {
            this.address = this.editComponent.getAddressField().getText();
        }
        try {
            if (this.hasChanged(this.port, Integer.parseInt(this.editComponent.getPortField().getText()))) {
                this.port = Integer.parseInt(this.editComponent.getPortField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale locale = null;
        try {
            locale = (Locale)this.availableLocales.elementAt(this.editComponent.getLocaleComboBox().getSelectedIndex());
        }
        catch (Exception exception) {
            locale = this.locale;
        }
        if (this.hasChanged(this.locale, locale)) {
            this.locale = locale;
        }
        if (this.hasChanged(this.recordType, this.editComponent.getRecordTypeComboBox().getSelectedIndex())) {
            this.recordType = this.editComponent.getRecordTypeComboBox().getSelectedIndex();
        }
        if (this.editComponent.getRecordTypeComboBox().getSelectedIndex() == 0 && this.hasChanged(this.medeEnabled, this.editComponent.getMedeEnabledCheckBox().isSelected())) {
            this.medeEnabled = this.editComponent.getMedeEnabledCheckBox().isSelected();
        }
        if (this.hasChanged(this.virtual, this.editComponent.getVirtualCheckBox().isSelected())) {
            this.virtual = this.editComponent.getVirtualCheckBox().isSelected();
        }
        if (this.virtual) {
            if (this.hasChanged(this.virtualCollections, this.itemSelector.getChosenItemIndices())) {
                this.virtualCollections = this.itemSelector.getChosenItemIndices();
            }
        } else {
            this.virtualCollections = new Vector();
        }
        if (this.virtual) {
            if (this.hasChanged(this.vcID, this.editComponent.getVirtualCollectionIDField().getText())) {
                this.vcID = this.editComponent.getVirtualCollectionIDField().getText();
            }
        } else {
            this.vcID = "NA";
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.userServer.commitDataObject(this);
        } else {
            this.userServer.cancelEdit(this);
        }
    }

    public void cancel() {
        UserServerCollection.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.userServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Collection - " + this.collectionName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-collections-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof UserServerCollection) {
            UserServerCollection userServerCollection = (UserServerCollection)object;
            return this.serverID == userServerCollection.serverID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof UserServerCollection) {
            UserServerCollection userServerCollection = (UserServerCollection)databaseRecord;
            return this.serverID == userServerCollection.serverID && UserServerCollection.stringsAreEqual(this.collectionName, userServerCollection.collectionName) && UserServerCollection.stringsAreEqual(this.collectionID, userServerCollection.collectionID) && UserServerCollection.stringsAreEqual(this.collectionUniqueID, userServerCollection.collectionUniqueID) && UserServerCollection.stringsAreEqual(this.institutionID, userServerCollection.institutionID) && UserServerCollection.stringsAreEqual(this.address, userServerCollection.address) && this.port == userServerCollection.port && this.virtual == userServerCollection.virtual && this.recordType == userServerCollection.recordType && this.medeEnabled == userServerCollection.medeEnabled && UserServerCollection.stringsAreEqual(this.vcID, userServerCollection.vcID) && (UserServerCollection.stringsAreEqual(this.languageCode, userServerCollection.languageCode) && UserServerCollection.stringsAreEqual(this.countryCode, userServerCollection.countryCode) || this.locale != null && this.locale.equals(userServerCollection.locale)) && this.virtualCollections.containsAll(userServerCollection.virtualCollections) && userServerCollection.virtualCollections.containsAll(this.virtualCollections);
        }
        return false;
    }

    public String getLocaleLanguage() {
        try {
            return this.locale.getLanguage();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getLocaleCountry() {
        try {
            return this.locale.getCountry();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getCollectionUniqueID() {
        if (this.collectionUniqueID == null) {
            this.collectionUniqueID = "";
        }
        return this.collectionUniqueID;
    }

    public String getVCID() {
        if (this.vcID == null || this.vcID.length() == 0) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public static void debugOut(String string) {
        UserServerCollection.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerCollection: " + string, n);
    }
}

