/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.collection.UserServerCollection;
import com.luna.insight.admin.userserver.collection.UserServerCollectionRecordHandler;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.share.UserServerShareRecordHandler;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroup;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroupRecordHandler;
import com.luna.insight.admin.userserver.usergroup.UserServerUserRecordHandler;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class UserServerConnector
extends AdministeredServerConnector {
    public static final String US_TABLE_COLLECTIONS = "COLLECTIONS";
    public static final String US_TABLE_VIRTUAL_COLLECTION_MAP = "VIRTUALCOLLECTIONMAP";
    public static final String US_TABLE_USER_LIST = "USERLIST";
    public static final String US_TABLE_USER_GROUPS = "USERGROUPS";
    public static final String US_TABLE_USER_GROUP_SERVER_MAP = "USERGROUPSERVERMAP";
    public static String US_TABLE_USER_GROUP_PROFILES = "UserGroupProfiles";
    public static String US_TABLE_USER_GROUP_PROFILE_MAP = "UserGroupProfileMap";
    public static final String US_TABLE_USER_SHARES = "USERSHARES";
    public static final String US_TABLE_USER_GROUP_MAP = "USERGROUPMAP";
    public static final String US_TABLE_USER_SHARE_MAP = "USERSHAREMAP";
    protected UserServerCollectionRecordHandler userServerCollectionHandler = null;
    protected UserServerUserRecordHandler userServerUserHandler = null;
    protected UserServerUserGroupRecordHandler userServerUserGroupHandler = null;
    protected UserServerShareRecordHandler userServerUserShareHandler = null;

    public UserServerConnector(UserServer userServer, Properties properties) {
        this.COMPONENT_CODE = "UserServerConnector";
        this.server = userServer;
        this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(properties);
        this.setConnectString(properties.getProperty(userServer.getConnectStringKey()));
        if (this.msAccessMode) {
            this.distinctKeyword = "DISTINCTROW";
        }
        if (!this.useDistinctKeyword) {
            this.distinctKeyword = "";
        }
        this.userServerCollectionHandler = new UserServerCollectionRecordHandler(this);
        this.userServerUserHandler = new UserServerUserRecordHandler(this);
        this.userServerUserGroupHandler = new UserServerUserGroupRecordHandler(this);
        this.userServerUserShareHandler = new UserServerShareRecordHandler(this);
    }

    public void commitRecord(DatabaseRecord databaseRecord) throws RecordCommitFailedException {
        if (databaseRecord != null) {
            if (databaseRecord instanceof UserServerCollection) {
                this.userServerCollectionHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof UserServerUser) {
                this.userServerUserHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof UserServerUserGroup) {
                this.userServerUserGroupHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof UserServerShare) {
                this.userServerUserShareHandler.commitRecord(databaseRecord);
            } else {
                super.commitRecord(databaseRecord);
            }
        }
    }

    public void deleteRecord(DatabaseRecord databaseRecord) throws RecordDeleteFailedException {
        if (databaseRecord != null) {
            if (databaseRecord instanceof UserServerCollection) {
                this.userServerCollectionHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof UserServerUser) {
                this.userServerUserHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof UserServerUserGroup) {
                this.userServerUserGroupHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof UserServerShare) {
                this.userServerUserShareHandler.deleteRecord(databaseRecord);
            } else {
                super.deleteRecord(databaseRecord);
            }
        }
    }

    public Vector getCollectionRecords(boolean bl) {
        return this.userServerCollectionHandler.getRecords(bl);
    }

    public int getNextValidCollectionID() {
        return this.userServerCollectionHandler.getNextValidID();
    }

    public Vector getCollectionsLanguages() {
        Vector<Locale> vector = new Vector<Locale>();
        this.debugOut("In getCollectionsLanguages().");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this.useDistinctKeyword) {
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            }
            sqlQueryGenerator.addTable(US_TABLE_COLLECTIONS, null, new String[]{"LanguageCode", "CountryCode"});
            sqlQueryGenerator.addOrderBy(US_TABLE_COLLECTIONS, "LanguageCode");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Languages query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    Locale locale = new Locale(databaseConnector.getFieldByName("LanguageCode"), databaseConnector.getFieldByName("CountryCode"));
                    if (!vector.contains(locale)) {
                        vector.addElement(locale);
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionsLanguages(): " + exception);
        }
        return vector;
    }

    public Vector getUserRecords() {
        return this.userServerUserHandler.getRecords();
    }

    public int getNextValidUserID() {
        return this.userServerUserHandler.getNextValidID();
    }

    public Vector getUserGroupRecords() {
        return this.userServerUserGroupHandler.getRecords();
    }

    public Vector getUserShareRecords() {
        return this.userServerUserShareHandler.getRecords();
    }

    public int getNextValidUserGroupID() {
        return this.userServerUserGroupHandler.getNextValidID();
    }

    public int getNextValidShareID() {
        return this.userServerUserShareHandler.getNextValidID();
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }
}

