/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.UsImageGroupFilePath;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.usergroup.UsUserGroupNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class UsImageGroupFilesNode
extends TableDisplayControlPanelNode {
    protected UserServerNode userServerNode = null;
    protected UserServer userServer = null;
    protected Hashtable childNodes = new Hashtable();

    public static void debugOut(String string) {
        UsImageGroupFilesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UsImageGroupFilesNode: " + string, n);
    }

    public UsImageGroupFilesNode(UserServerNode userServerNode) {
        super(userServerNode.getUserServer().getInsightAdministrator(), "Image Group Files", true);
        this.userServerNode = userServerNode;
        if (userServerNode != null) {
            this.userServer = userServerNode.userServer;
        }
        this.columnNames = new Object[]{"Image Group File Path"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(new Object[][]{{new UsImageGroupFilePath(this.userServerNode)}}, this.columnNames);
        this.addUserGroupChildren();
    }

    public void addUserGroupChildren() {
        this.addUserGroupChildren(this.userServerNode.getUserServer().getUserShares());
    }

    private void addUserGroupChildren(List list) {
        if (list != null) {
            this.removeAllChildren();
            this.childNodes = new Hashtable();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UsUserGroupNode usUserGroupNode = new UsUserGroupNode(this.userServerNode, (UserServerShare)iterator.next());
                this.childNodes.put(usUserGroupNode.getUserShare(), usUserGroupNode);
                this.add(usUserGroupNode);
            }
        }
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("Set image group file path", "Edit Image Group File Path", this.userServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.userServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-image-group-files-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("Set image group file path", "Edit Image Group File Path", actionListener));
        return jPopupMenu;
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit Image Group File Path") && vector != null && vector.size() == 1) {
            this.userServerNode.editImageGroupFilePath();
        }
    }

    public void defaultItemAction(Object object) {
        this.userServerNode.editImageGroupFilePath();
    }
}

