/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.userserver.ImageGroupFileEditComponent;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.collection.UserServerCollection;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.usergroup.UsUserGroupNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.ImageInGroup;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ImageGroupFileDataObject
extends EditableDataObject {
    protected UsUserGroupNode userGroupNode;
    protected UserServerNode serverNode;
    protected UserServerShare userShare;
    protected File igfFile;
    protected ImageGroupFile igf;
    protected ImageGroupFileEditComponent editComponent;

    public static void debugOut(String string) {
        ImageGroupFileDataObject.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ImageGroupFileDataObject: " + string, n);
    }

    public ImageGroupFileDataObject(UsUserGroupNode usUserGroupNode, UserServerShare userServerShare, File file) {
        this.userGroupNode = usUserGroupNode;
        this.serverNode = usUserGroupNode.getServerNode();
        this.userShare = userServerShare;
        this.igfFile = file;
    }

    public String getName() {
        return this.igfFile.getName().toLowerCase();
    }

    public String getLastModified() {
        return DateFormat.getDateTimeInstance(3, 2).format(new Date(this.igfFile.lastModified()));
    }

    public String toString() {
        return this.getName();
    }

    public ImageGroupFile getImageGroupFile() {
        if (this.igf == null) {
            this.igf = this.serverNode.getImageGroupFile(this.userShare.getName(), this.userShare.getCodeKey(), this.igfFile.getName());
        }
        return this.igf;
    }

    public void updateInformationDisplay() {
        this.userGroupNode.updateInformationDisplay();
    }

    protected Vector getCollections() {
        Vector<String> vector = new Vector<String>();
        if (this.getImageGroupFile() != null) {
            Vector vector2 = this.igf.getImagesInGroup();
            Vector vector3 = this.serverNode.getUserServer().getCollections(false);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                String string = this.getCollectionName(vector3, (ImageInGroup)vector2.get(i));
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        return vector;
    }

    protected String getCollectionName(Vector vector, CollectionKey collectionKey) {
        String string = collectionKey.toKeyString();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            UserServerCollection userServerCollection = (UserServerCollection)vector.get(i);
            if (!CollectionKeyDistributor.keysAgree(userServerCollection, collectionKey)) continue;
            string = userServerCollection.getName();
            break;
        }
        return string;
    }

    public String getUniqueIdentifier() {
        return this.userShare.getName() + "-" + this.userShare.getCodeKey() + "-" + this.getName();
    }

    public EditComponent getEditComponent() {
        this.editComponent = new ImageGroupFileEditComponent();
        if (this.getImageGroupFile() != null) {
            this.editComponent.getIgfNameField().setText(this.igf.getGroupName());
            this.editComponent.getAuthorField().setText(this.igf.getCreatorName());
            this.editComponent.getLastModifiedField().setText(this.getLastModified());
            this.editComponent.getImageCountField().setText(this.igf.getImagesInGroup() == null ? "0" : this.igf.getImagesInGroup().size() + "");
            Vector vector = this.igf.getImageSerieses();
            if (vector != null) {
                this.editComponent.getPresentationsLabel().setText("Presentation" + (vector.size() == 1 ? "" : "s") + ":");
                this.editComponent.getPresentationsList().setListData(vector);
            }
            Vector vector2 = this.getCollections();
            this.editComponent.getCollectionsLabel().setText("Collection" + (vector2.size() == 1 ? "" : "s") + ":");
            this.editComponent.getCollectionsList().setListData(vector2);
        }
        return this.editComponent;
    }

    public void save() {
        ImageGroupFileDataObject.debugOut("Save " + this.toString() + ".");
        this.requiresCommit = false;
        if (this.igf != null && this.editComponent != null && this.hasChanged(this.igf.getGroupName(), this.editComponent.getIgfNameField().getText())) {
            ImageGroupFileDataObject.debugOut("Changes? true");
            this.requiresCommit = true;
            if (!this.serverNode.getUserServer().renameImageGroupFile(this.userShare.getName(), this.userShare.getCodeKey(), this.igf, this.editComponent.getIgfNameField().getText())) {
                InsightAdministrator.showWarningDialog(this.editComponent, "Could not rename '" + this.igf.getGroupName() + "' to '" + this.editComponent.getIgfNameField().getText() + "'.", "Image Group File Rename Error");
            }
            this.updateInformationDisplay();
        }
        this.cancel();
    }

    public void cancel() {
        this.editComponent = null;
        this.serverNode.getUserServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "View/Rename - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/us-image-group-file-node-icon.gif");
    }
}

