/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.manytomanymap;

import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.server.Debug;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MappedThumbnailViewer
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    public static final int SCROLL_SPEED = 10;
    public static final Border VIEWER_BORDER = BorderFactory.createLineBorder(Color.black);
    public static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    protected List thumbnails = new ArrayList();
    protected JPanel internalPanel;
    protected boolean populated;

    public static void debugOut(String string) {
        MappedThumbnailViewer.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MappedThumbnailViewer: " + string, n);
    }

    public MappedThumbnailViewer() {
        this(new VerticalStackResizeWidthLayout());
    }

    public MappedThumbnailViewer(LayoutManager layoutManager) {
        this.setBorder(VIEWER_BORDER);
        this.internalPanel = new JPanel(layoutManager);
        this.getViewport().add(this.internalPanel);
        this.getViewport().doLayout();
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.getHorizontalScrollBar().setUnitIncrement(10);
    }

    public void setThumbnailLayout(LayoutManager layoutManager) {
        this.internalPanel.setLayout(layoutManager);
        this.refreshLayout();
    }

    public LayoutManager getThumbnailLayout() {
        return this.internalPanel.getLayout();
    }

    public void refreshLayout() {
        this.doLayout();
        this.getViewport().doLayout();
        this.internalPanel.doLayout();
        this.getViewport().doLayout();
        this.invalidate();
        this.validate();
        this.repaint();
        this.getVerticalScrollBar().repaint();
        this.getHorizontalScrollBar().repaint();
    }

    public void populate(List list) {
        if (list != null) {
            this.populate(list.iterator());
        }
    }

    public void populate(Iterator iterator) {
        if (iterator != null) {
            this.removeAllThumbnails();
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                this.addThumbnail((MappedThumbnail)iterator2.next());
            }
        }
    }

    public void addThumbnail(MappedThumbnail mappedThumbnail) {
        mappedThumbnail.setViewer(this);
        this.thumbnails.add(mappedThumbnail);
        this.internalPanel.add(mappedThumbnail);
        this.internalPanel.doLayout();
        this.repaint();
    }

    protected void removeThumbnail(MappedThumbnail mappedThumbnail) {
        this.thumbnails.remove(mappedThumbnail);
        this.internalPanel.remove(mappedThumbnail);
        this.internalPanel.doLayout();
        this.repaint();
    }

    public void removeAllThumbnails() {
        this.thumbnails.clear();
        this.internalPanel.removeAll();
        this.repaint();
    }

    public void selectAllThumbnails(boolean bl) {
        this.selectAllThumbnails(bl, false);
    }

    public void selectAllThumbnails(boolean bl, boolean bl2) {
        Iterator iterator = this.thumbnails.iterator();
        while (iterator.hasNext()) {
            ((MappedThumbnail)iterator.next()).select(bl, bl2);
        }
    }

    public void selectThumbnails(List list, boolean bl) {
        this.selectThumbnails(list, bl, false);
    }

    public void selectThumbnails(List list, boolean bl, boolean bl2) {
        this.selectThumbnails(list, bl, bl2, true);
    }

    public void selectThumbnails(List list, boolean bl, boolean bl2, boolean bl3) {
        if (list != null) {
            MappedThumbnail mappedThumbnail = null;
            MappedThumbnail mappedThumbnail2 = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                mappedThumbnail2 = this.selectThumbnail(iterator.next(), bl, bl2);
                if (mappedThumbnail != null) continue;
                mappedThumbnail = mappedThumbnail2;
            }
            if (bl3) {
                this.scrollToThumbnail(mappedThumbnail);
            }
        }
    }

    public MappedThumbnail selectThumbnail(Object object, boolean bl) {
        return this.selectThumbnail(object, bl, false);
    }

    public MappedThumbnail selectThumbnail(Object object, boolean bl, boolean bl2) {
        MappedThumbnail mappedThumbnail = null;
        Iterator iterator = this.thumbnails.iterator();
        while (iterator.hasNext()) {
            mappedThumbnail = (MappedThumbnail)iterator.next();
            if (mappedThumbnail.mapObjectEquals(object)) {
                mappedThumbnail.select(bl, bl2);
                break;
            }
            mappedThumbnail = null;
        }
        return mappedThumbnail;
    }

    public int getThumbnailCount() {
        return this.thumbnails.size();
    }

    public int getThumbnailIndex(MappedThumbnail mappedThumbnail) {
        return this.thumbnails.indexOf(mappedThumbnail);
    }

    public MappedThumbnail getThumbnail(Object object) {
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            MappedThumbnail mappedThumbnail = (MappedThumbnail)this.thumbnails.get(i);
            if (!mappedThumbnail.mapObjectEquals(object)) continue;
            return mappedThumbnail;
        }
        return null;
    }

    public boolean containsThumbnail(MappedThumbnail mappedThumbnail) {
        return this.getThumbnailIndex(mappedThumbnail) > -1;
    }

    public void scrollToMapObject(Object object) {
        this.scrollToThumbnail(this.getThumbnail(object));
    }

    public void scrollToThumbnail(MappedThumbnail mappedThumbnail) {
        if (mappedThumbnail != null) {
            Rectangle rectangle = mappedThumbnail.getBounds();
            Point point = SwingUtilities.convertPoint(mappedThumbnail, 0, 0, this.getViewport().getView());
            rectangle.y = point.y - (this.getViewport().getViewPosition().y + 5);
            rectangle.height += 10;
            this.getViewport().scrollRectToVisible(rectangle);
        }
    }

    public void endDrag(MouseEvent mouseEvent) {
    }

    public int findComponentPosition(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.endDrag(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.endDrag(mouseEvent);
    }

    public void run() {
    }
}

