/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.manytomanymap;

import com.luna.insight.admin.manytomanymap.ManyToManyMapListener;
import com.luna.insight.admin.manytomanymap.MapRecord;
import com.luna.insight.server.Debug;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ManyToManyMap {
    protected Map mainMap = new Hashtable();
    protected Map inverseMap = new Hashtable();
    protected Map orphans = new Hashtable();
    protected int mapCount = 0;
    protected Object lockObject = new Object();
    protected boolean recordChanges = false;
    protected List mapChanges = new Vector(1);
    protected List changeHistory = new Vector(1);
    protected List listeners = new Vector(0);

    public static void debugOut(String string) {
        ManyToManyMap.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ManyToManyMap: " + string, n);
    }

    public int size() {
        return this.mapCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lockObject;
        synchronized (object) {
            this.mainMap.clear();
            this.inverseMap.clear();
            this.mapCount = 0;
        }
    }

    public Iterator getMappings(Object object) {
        Iterator iterator = null;
        List list = this.getMappingsList(object);
        if (list != null) {
            iterator = list.iterator();
        }
        return iterator;
    }

    public List getMappingsList(Object object) {
        Vector vector = null;
        if (object != null) {
            vector = (Vector)this.mainMap.get(object);
            if (vector == null) {
                vector = (List)this.inverseMap.get(object);
            }
            vector = vector == null ? new Vector(0) : new Vector(vector);
        }
        return vector;
    }

    public Iterator getMappings() {
        return this.mainMap.entrySet().iterator();
    }

    public boolean isMapped(Object object, Object object2) {
        return this.isMapped(object, object2, false) || this.isMapped(object2, object, false);
    }

    private boolean isMapped(Object object, Object object2, boolean bl) {
        boolean bl2 = false;
        if (object != null && object2 != null) {
            Object object3 = object;
            Object object4 = object2;
            Map map = bl ? this.inverseMap : this.mainMap;
            List list = (List)map.get(object3);
            bl2 = list != null && list.contains(object4);
        }
        return bl2;
    }

    public Iterator getOrphans() {
        return this.orphans.keySet().iterator();
    }

    public void addOrphan(Object object) {
        this.manageOrphan(object);
    }

    public void manageOrphan(Object object) {
        if (object != null) {
            this.manageOrphan(object, this.getMappingsList(object));
        }
    }

    private void manageOrphan(Object object, List list) {
        if (object != null && list != null) {
            if (list.size() > 0) {
                this.orphans.remove(object);
            } else if (!this.orphans.containsKey(object)) {
                this.orphans.put(object, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean map(Object object, Object object2) {
        boolean bl = false;
        Object object3 = this.lockObject;
        synchronized (object3) {
            boolean bl2 = false;
            if (this.containsKeyInverted(object)) {
                Object object4 = object;
                object = object2;
                object2 = object4;
                bl2 = true;
            }
            if (!this.isMapped(object, object2) && this.map(object, object2, false) && this.map(object2, object, true)) {
                this.recordMapping(0, bl2 ? object2 : object, bl2 ? object : object2);
                ++this.mapCount;
                bl = true;
            }
        }
        return bl;
    }

    private boolean map(Object object, Object object2, boolean bl) {
        boolean bl2 = false;
        if (object != null && object2 != null) {
            Object object3 = object;
            Object object4 = object2;
            Map map = bl ? this.inverseMap : this.mainMap;
            Vector<Object> vector = (Vector<Object>)map.get(object3);
            if (vector == null) {
                vector = new Vector<Object>(1);
                map.put(object3, vector);
            }
            if (!vector.contains(object4)) {
                vector.add(object4);
            }
            if (vector.size() > 0) {
                this.manageOrphan(object3, vector);
            }
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unmap(Object object, Object object2) {
        boolean bl = false;
        Object object3 = this.lockObject;
        synchronized (object3) {
            boolean bl2 = false;
            if (this.containsKeyInverted(object)) {
                Object object4 = object;
                object = object2;
                object2 = object4;
                bl2 = true;
            }
            if (this.unmap(object, object2, false) && this.unmap(object2, object, true)) {
                this.recordMapping(1, bl2 ? object2 : object, bl2 ? object : object2);
                --this.mapCount;
                bl = true;
            }
        }
        return bl;
    }

    private boolean unmap(Object object, Object object2, boolean bl) {
        boolean bl2 = false;
        if (object != null && object2 != null) {
            Object object3 = object;
            Object object4 = object2;
            Map map = bl ? this.inverseMap : this.mainMap;
            List list = (List)map.get(object3);
            if (list != null) {
                list.remove(object4);
            }
            if (list == null || list.size() <= 0) {
                map.remove(object3);
                this.manageOrphan(object3, list);
            }
            bl2 = true;
        }
        return bl2;
    }

    protected boolean containsKey(Object object) {
        return this.containsKey(object, false);
    }

    protected boolean containsKeyInverted(Object object) {
        return this.containsKey(object, true);
    }

    private boolean containsKey(Object object, boolean bl) {
        if (object != null) {
            Map map = bl ? this.inverseMap : this.mainMap;
            boolean bl2 = map.containsKey(object);
            return bl2;
        }
        return false;
    }

    protected boolean containsKeyType(Object object) {
        return this.containsKeyType(object, false);
    }

    protected boolean containsKeyTypeInverted(Object object) {
        return this.containsKey(object, true);
    }

    private boolean containsKeyType(Object object, boolean bl) {
        if (object != null) {
            Map map = bl ? this.inverseMap : this.mainMap;
        }
        return false;
    }

    public void setRecordChanges(boolean bl) {
        this.recordChanges = bl;
    }

    public boolean hasChanged() {
        return this.mapChanges.size() > 0;
    }

    public List getChanges() {
        return new Vector(this.mapChanges);
    }

    public boolean hasChangeHistory() {
        return this.changeHistory.size() > 0;
    }

    protected void recordMapping(int n, Object object, Object object2) {
        if (this.recordChanges) {
            MapRecord mapRecord = new MapRecord(n, object, object2);
            int n2 = this.mapChanges.indexOf(mapRecord);
            if (n2 > -1) {
                MapRecord mapRecord2 = (MapRecord)this.mapChanges.get(n2);
                if (mapRecord.getMappingType() != mapRecord2.getMappingType()) {
                    this.mapChanges.remove(n2);
                }
            } else {
                this.mapChanges.add(mapRecord);
            }
            this.changeHistory.add(mapRecord);
            this.notifyListeners(mapRecord);
        }
    }

    public MapRecord undoLastChange() {
        MapRecord mapRecord = null;
        if (this.changeHistory != null && this.changeHistory.size() > 0) {
            mapRecord = (MapRecord)this.changeHistory.get(this.changeHistory.size() - 1);
            this.changeHistory.remove(this.changeHistory.size() - 1);
            int n = this.changeHistory.size();
            if (mapRecord.getMappingType() == 0) {
                this.unmap(mapRecord.getObjectA(), mapRecord.getObjectB());
            } else if (mapRecord.getMappingType() == 1) {
                this.map(mapRecord.getObjectA(), mapRecord.getObjectB());
            }
            if (this.changeHistory.size() > n && this.changeHistory.size() > 0) {
                this.changeHistory.remove(this.changeHistory.size() - 1);
            }
        }
        return mapRecord;
    }

    public void addManyToManyMapListener(ManyToManyMapListener manyToManyMapListener) {
        if (!this.listeners.contains(manyToManyMapListener)) {
            this.listeners.add(manyToManyMapListener);
        }
    }

    protected void notifyListeners(MapRecord mapRecord) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ManyToManyMapListener manyToManyMapListener = (ManyToManyMapListener)this.listeners.get(i);
            manyToManyMapListener.mapStateAltered(mapRecord);
        }
    }

    public void removeObject(Object object) {
        List list;
        this.mainMap.remove(object);
        Object object2 = this.mainMap.values().iterator();
        while (object2.hasNext()) {
            list = (List)object2.next();
            list.remove(object);
        }
        this.inverseMap.remove(object);
        object2 = this.inverseMap.values().iterator();
        while (object2.hasNext()) {
            list = (List)object2.next();
            list.remove(object);
        }
        this.orphans.remove(object);
        Vector<Object> vector = new Vector<Object>(1);
        Iterator iterator = this.mapChanges.iterator();
        while (iterator.hasNext()) {
            object2 = (MapRecord)iterator.next();
            if (!((MapRecord)object2).getObjectA().equals(object) && !((MapRecord)object2).getObjectB().equals(object)) continue;
            vector.add(object2);
        }
        this.mapChanges.removeAll(vector);
        vector.clear();
        iterator = this.changeHistory.iterator();
        while (iterator.hasNext()) {
            object2 = (MapRecord)iterator.next();
            if (!((MapRecord)object2).getObjectA().equals(object) && !((MapRecord)object2).getObjectB().equals(object)) continue;
            vector.add(object2);
        }
        this.changeHistory.removeAll(vector);
    }
}

