/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.user;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.user.LunaServerUser;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerUsersNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerUsersNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Users", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"ID", "User Name", "Password", "Credential ID", "First Name", "Last Name", "Email", "Default Page Size", "Default Thumbnail Size", "Default Group ID", "Default Presentation ID", "Minimal Client Side", "Enabled", "Domain Auth Required", "Display Tips", "Authenticator Type"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getUsers()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerUser lunaServerUser = (LunaServerUser)vector.elementAt(i);
            objectArray[i][0] = lunaServerUser;
            objectArray[i][1] = lunaServerUser.username;
            objectArray[i][2] = lunaServerUser.password;
            objectArray[i][3] = new Integer(lunaServerUser.credentialId);
            objectArray[i][4] = lunaServerUser.firstName;
            objectArray[i][5] = lunaServerUser.lastName;
            objectArray[i][6] = lunaServerUser.email;
            objectArray[i][7] = new Integer(lunaServerUser.defaultPageSize);
            objectArray[i][8] = new Integer(lunaServerUser.defaultThumbnailSize);
            objectArray[i][9] = new Integer(lunaServerUser.defaultGroupId);
            objectArray[i][10] = new Integer(lunaServerUser.defaultPresentationId);
            objectArray[i][11] = new Boolean(lunaServerUser.minimalClientSide);
            objectArray[i][12] = new Boolean(lunaServerUser.enabled);
            objectArray[i][13] = new Boolean(lunaServerUser.domainAuthenticationRequired);
            objectArray[i][14] = lunaServerUser.displayHelpfulTips;
            objectArray[i][15] = lunaServerUser.getAuthType();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), null, "Edit User Command", "Delete User Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Command")) {
            this.lunaServerNode.createNewUser();
        } else if (string.equals("Delete User Command")) {
            if (vector != null && vector.size() > 0) {
                this.lunaServerNode.removeUsers(vector);
            }
        } else if (string.equals("Edit User Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editUser((LunaServerUser)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editUser((LunaServerUser)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerUsersNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerUsersNode: " + string, n);
    }
}

