/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.user;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.admin.lunaserver.user.LunaServerUserEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class LunaServerUser
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected int id;
    protected LunaServer lunaServer;
    protected String username = "";
    protected String password = "";
    protected String firstName = "";
    protected String lastName = "";
    protected String email = "";
    protected int credentialId = 0;
    protected int defaultPageSize = 0;
    protected int defaultThumbnailSize = 0;
    protected int defaultGroupId = 0;
    protected int defaultPresentationId = 0;
    protected boolean minimalClientSide = false;
    protected boolean enabled = false;
    protected boolean domainAuthenticationRequired = false;
    protected String displayHelpfulTips = "";
    protected String authenticatorType = "";
    private Vector credentials;
    private List selectableCredentials = new ArrayList();
    protected LunaServerUserEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public LunaServerUser(LunaServer lunaServer, int n, int n2, String string, String string2, String string3, String string4, String string5, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, String string6, String string7) {
        this.lunaServer = lunaServer;
        this.id = n;
        this.credentialId = n2;
        this.username = string == null ? "" : string;
        this.password = string2 == null ? "" : string2;
        this.firstName = string3 == null ? "" : string3;
        this.lastName = string4 == null ? "" : string4;
        this.email = string5 == null ? "" : string5;
        this.defaultPageSize = n3;
        this.defaultThumbnailSize = n4;
        this.defaultGroupId = n5;
        this.defaultPresentationId = n6;
        this.minimalClientSide = bl;
        this.enabled = bl2;
        this.domainAuthenticationRequired = bl3;
        this.displayHelpfulTips = string6 == null ? "" : string6;
        this.authenticatorType = string7 == null ? "" : string7;
    }

    public LunaServerUser(int n, LunaServer lunaServer) {
        this.id = n;
        this.lunaServer = lunaServer;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public String getName() {
        return this.username;
    }

    public String getAuthType() {
        return this.authenticatorType.substring(this.authenticatorType.lastIndexOf(46) + 1, this.authenticatorType.length());
    }

    public int getIndex() {
        return this.id;
    }

    public int getUserId() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerUserEditComponent();
        this.credentials = this.lunaServer.getCredentials();
        int n = -1;
        Vector<String> vector = new Vector<String>();
        this.selectableCredentials.clear();
        Enumeration enumeration = this.credentials.elements();
        while (enumeration.hasMoreElements()) {
            LunaServerCredential lunaServerCredential = (LunaServerCredential)enumeration.nextElement();
            String string = lunaServerCredential.getCredentialId() + " - " + lunaServerCredential.getName();
            vector.addElement(string);
            this.selectableCredentials.add(new Integer(lunaServerCredential.getCredentialId()));
            if (lunaServerCredential.getCredentialId() != this.credentialId) continue;
            n = this.selectableCredentials.size() - 1;
        }
        this.editComponent.getCredentialComboBox().setModel(new DefaultComboBoxModel(vector));
        this.editComponent.getCredentialComboBox().setSelectedIndex(n);
        return this.editComponent;
    }

    public void save() {
        LunaServerUser.debugOut("Save...", 3);
        this.requiresCommit = false;
        int n = this.credentialId;
        try {
            n = (Integer)this.selectableCredentials.get(this.editComponent.getCredentialComboBox().getSelectedIndex());
        }
        catch (Exception exception) {
            n = this.credentialId;
        }
        if (this.hasChanged(this.credentialId, n)) {
            this.credentialId = n;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerUser.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User - " + this.username;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerUser) {
            LunaServerUser lunaServerUser = (LunaServerUser)object;
            return this.id == lunaServerUser.id;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerUser) {
            LunaServerUser lunaServerUser = (LunaServerUser)databaseRecord;
            return this.id == lunaServerUser.id && LunaServerUser.stringsAreEqual(this.username, lunaServerUser.username) && LunaServerUser.stringsAreEqual(this.password, lunaServerUser.password) && LunaServerUser.stringsAreEqual(this.firstName, lunaServerUser.firstName) && LunaServerUser.stringsAreEqual(this.lastName, lunaServerUser.lastName) && LunaServerUser.stringsAreEqual(this.email, lunaServerUser.email) && this.defaultPageSize == lunaServerUser.defaultPageSize && this.defaultThumbnailSize == lunaServerUser.defaultThumbnailSize && this.defaultGroupId == lunaServerUser.defaultGroupId && this.defaultPresentationId == lunaServerUser.defaultPresentationId && this.minimalClientSide == lunaServerUser.minimalClientSide && this.enabled == lunaServerUser.enabled && this.domainAuthenticationRequired == lunaServerUser.domainAuthenticationRequired && LunaServerUser.stringsAreEqual(this.displayHelpfulTips, lunaServerUser.displayHelpfulTips) && LunaServerUser.stringsAreEqual(this.authenticatorType, lunaServerUser.authenticatorType);
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerUser.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerUser: " + string, n);
    }

    public int compareTo(Object object) {
        return this.username.compareTo(((LunaServerUser)object).username);
    }
}

