/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.sharedmediacollection;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollection;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerSharedMediaCollectionsNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerSharedMediaCollectionsNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Shared Media Collections", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"ID", "CollectionName"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getSharedMediaCollections()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerSharedMediaCollection lunaServerSharedMediaCollection = (LunaServerSharedMediaCollection)vector.elementAt(i);
            objectArray[i][0] = lunaServerSharedMediaCollection.id;
            objectArray[i][1] = lunaServerSharedMediaCollection.collectionName;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-collections-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), null, null, null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("NewShared Media Collection Command")) {
            this.lunaServerNode.createNewCollection();
        } else if (string.equals("DeleteShared Media Collection Command")) {
            if (vector != null && vector.size() > 0) {
                this.lunaServerNode.removeCollections(vector);
            }
        } else if (string.equals("EditShared Media Collection Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editCollection((LunaServerSharedMediaCollection)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editCollection((LunaServerSharedMediaCollection)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerSharedMediaCollectionsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerSharedCollectionsNode: " + string, n);
    }
}

