/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.sharedmediacollection;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.IndexedStringObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollection;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollectionEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class LunaServerSharedMediaCollection
extends EditableDataObject
implements IndexedObject,
IndexedStringObject,
DatabaseRecord {
    public static final String RECORD_TYPE_MEDIACOLLECTION = "Media Collection";
    protected LunaServer lunaServer;
    protected String collectionName = "";
    protected String id = null;
    protected LunaServerSharedMediaCollectionEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;
    protected Vector availableLocales = null;
    protected Set credentials = new HashSet();

    public LunaServerSharedMediaCollection(LunaServer lunaServer, String string, String string2) {
        this.lunaServer = lunaServer;
        this.id = string == null ? "" : string;
        this.collectionName = string2 == null ? "" : string2;
    }

    public LunaServerSharedMediaCollection(int n, LunaServer lunaServer) {
        this.lunaServer = lunaServer;
    }

    public void addCredentialIndex(int n) {
        this.credentials.add(new Integer(n));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.collectionName;
    }

    public int getIndex() {
        return this.getStringIDSimple(this.id);
    }

    public String getStringIndex() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerSharedMediaCollectionEditComponent();
        this.editComponent.getCollectionNameField().setText(this.id);
        this.editComponent.getCollectionNameField().setText(this.collectionName);
        Vector<String> vector = new Vector<String>();
        vector.add(RECORD_TYPE_MEDIACOLLECTION);
        return this.editComponent;
    }

    public void save() {
    }

    public void cancel() {
        LunaServerSharedMediaCollection.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Media Collection - " + this.collectionName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-collections-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerSharedMediaCollection) {
            LunaServerSharedMediaCollection lunaServerSharedMediaCollection = (LunaServerSharedMediaCollection)object;
            return LunaServerSharedMediaCollection.stringsAreEqual(this.id, lunaServerSharedMediaCollection.id);
        }
        if (object instanceof LunaServerMediaCollection) {
            LunaServerMediaCollection lunaServerMediaCollection = (LunaServerMediaCollection)object;
            return LunaServerSharedMediaCollection.stringsAreEqual(this.id, lunaServerMediaCollection.getID());
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerSharedMediaCollection) {
            LunaServerSharedMediaCollection lunaServerSharedMediaCollection = (LunaServerSharedMediaCollection)databaseRecord;
            return this.id == lunaServerSharedMediaCollection.id && LunaServerSharedMediaCollection.stringsAreEqual(this.collectionName, lunaServerSharedMediaCollection.collectionName);
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    public int getStringIDSimple(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i) * (string.length() - i) * 491;
        }
        return n;
    }

    public static void debugOut(String string) {
        LunaServerSharedMediaCollection.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCollection: " + string, n);
    }
}

