/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.presentation;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentation;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerPresentationsNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerPresentationsNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Presentations", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"Name", "User ID", "Description", "Folder ID", "Publicly Viewable"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getPresentations()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerPresentation lunaServerPresentation = (LunaServerPresentation)vector.elementAt(i);
            objectArray[i][0] = lunaServerPresentation;
            objectArray[i][1] = new Integer(lunaServerPresentation.userId);
            objectArray[i][2] = lunaServerPresentation.description;
            objectArray[i][3] = new Integer(lunaServerPresentation.folderId);
            objectArray[i][4] = new Boolean(lunaServerPresentation.isPubliclyViewable);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), null, "Edit Presentation Command", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit Presentation Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editPresentation((LunaServerPresentation)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editPresentation((LunaServerPresentation)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerPresentationsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerPresentationsNode: " + string, n);
    }
}

