/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.presentation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentation;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Hashtable;
import java.util.Vector;

public class LunaServerPresentationRecordHandler
extends DatabaseRecordHandler {
    public LunaServerPresentationRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "LunaServerPresentationRecordHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        DatabaseConnector databaseConnector = null;
        try {
            LunaServerPresentation lunaServerPresentation = (LunaServerPresentation)databaseRecord;
            databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ID", 2, stringBuffer2, lunaServerPresentation.id);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserID", 2, stringBuffer2, lunaServerPresentation.userId);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FolderID", 2, stringBuffer2, lunaServerPresentation.folderId);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayName", 1, stringBuffer2, lunaServerPresentation.displayName);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Password", 1, stringBuffer2, lunaServerPresentation.password);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Description", 1, stringBuffer2, lunaServerPresentation.description);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Publiclyviewable", 2, stringBuffer2, lunaServerPresentation.isPubliclyViewable);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Width", 2, stringBuffer2, lunaServerPresentation.width);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Height", 2, stringBuffer2, lunaServerPresentation.height);
            String string = "INSERT INTO PRESENTATIONS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertPresentationQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(DatabaseRecord databaseRecord) {
        this.debugOut("in doUpdate()");
        DatabaseConnector databaseConnector = null;
        try {
            LunaServerPresentation lunaServerPresentation = (LunaServerPresentation)databaseRecord;
            databaseConnector = this.getDatabaseConnector();
            String string = "UPDATE PRESENTATIONS SET UserID = " + lunaServerPresentation.userId + " WHERE ID = " + lunaServerPresentation.id;
            databaseConnector.setQuery(string);
            this.debugOut("updatePresentationQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doUpdate(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM PRESENTATIONS WHERE ID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deletePresentationQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        DatabaseConnector databaseConnector = null;
        try {
            Object object;
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("PRESENTATIONS", null, "*");
            sqlQueryGenerator.addOrderBy("PRESENTATIONS", "DISPLAYNAME");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Presentations query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                object = new LunaServerPresentation((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ID"), databaseConnector.getIntegerFieldByName("USERID"), databaseConnector.getFieldByName("DisplayName"), databaseConnector.getFieldByName("Password"), databaseConnector.getFieldByName("Description"), databaseConnector.getIntegerFieldByName("FolderID"), databaseConnector.getIntegerFieldByName("PubliclyViewable") == 1, databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                hashtable.put(new Integer(((LunaServerPresentation)object).id), object);
                databaseConnector.next();
            }
            databaseConnector.close();
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            object = vector;
            return object;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
            Vector vector2 = vector;
            return vector2;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        LunaServerPresentation lunaServerPresentation = null;
        int n = databaseRecord.getIndex();
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("PRESENTATIONS", null, "*");
            sqlQueryGenerator.appendToWhere("ID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Presentation query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                lunaServerPresentation = new LunaServerPresentation((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ID"), databaseConnector.getIntegerFieldByName("USERID"), databaseConnector.getFieldByName("DisplayName"), databaseConnector.getFieldByName("Password"), databaseConnector.getFieldByName("Description"), databaseConnector.getIntegerFieldByName("FolderID"), databaseConnector.getIntegerFieldByName("PubliclyViewable") == 1, databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return lunaServerPresentation;
    }

    public String getNextValidIDQuery() {
        return "SELECT ID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "MEDIAGROUPS" + " ORDER BY ID";
    }

    public void updateMaxIDValue(long l) {
    }

    public void updateRecord(DatabaseRecord databaseRecord) throws RecordCommitFailedException {
        this.debugOut("in commitRecord().");
        this.debugOut("Getting backup record.");
        DatabaseRecord databaseRecord2 = this.getRecord(databaseRecord);
        if (databaseRecord2 != null) {
            this.debugOut("Updating new record.");
            this.doUpdate(databaseRecord);
        } else {
            this.debugOut("Deleting current record.");
            this.doDelete(databaseRecord);
            this.debugOut("Inserting new record.");
            this.doInsert(databaseRecord);
        }
        this.debugOut("Retrieving updated record.");
        DatabaseRecord databaseRecord3 = this.getUpdatedRecord(databaseRecord);
        if (databaseRecord3 == null || !databaseRecord3.equalsRecord(databaseRecord)) {
            if (databaseRecord3 == null) {
                this.debugOut("Updated record: " + databaseRecord3);
            } else {
                this.debugOut("updatedRecord.equalsRecord(record): " + databaseRecord3.equalsRecord(databaseRecord));
            }
            if (databaseRecord2 != null) {
                this.debugOut("Commit failed, restoring backup record.");
                this.doInsert(databaseRecord2);
            } else {
                this.debugOut("Record could not be created.");
            }
            throw new RecordCommitFailedException(databaseRecord, databaseRecord2);
        }
    }
}

