/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.presentation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentationEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class LunaServerPresentation
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected int id;
    protected int userId;
    protected LunaServer lunaServer;
    protected String displayName = "";
    protected String password = "";
    protected String description = "";
    protected int folderId = 0;
    protected boolean isPubliclyViewable = false;
    protected int width = 0;
    protected int height = 0;
    protected LunaServerPresentationEditComponent editComponent = null;

    public LunaServerPresentation(LunaServer lunaServer, int n, int n2, String string, String string2, String string3, int n3, boolean bl, int n4, int n5) {
        this.lunaServer = lunaServer;
        this.id = n;
        this.userId = n2;
        this.displayName = string == null ? "" : string;
        this.password = string2 == null ? "" : string2;
        this.description = string3 == null ? "" : string3;
        this.folderId = n3;
        this.isPubliclyViewable = bl;
        this.width = n4;
        this.height = n5;
    }

    public LunaServerPresentation(int n, LunaServer lunaServer) {
        this.id = n;
        this.lunaServer = lunaServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.displayName;
    }

    public int getIndex() {
        return this.id;
    }

    public int getPresentationId() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerPresentationEditComponent();
        this.editComponent.getUserIdField().setText(Integer.toString(this.userId));
        return this.editComponent;
    }

    public void save() {
        LunaServerPresentation.debugOut("Save...", 3);
        this.requiresCommit = false;
        String string = this.editComponent.getUserIdField().getText();
        if (this.hasChanged(this.userId, Integer.parseInt(string))) {
            this.userId = Integer.parseInt(string);
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerPresentation.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Presentation - " + this.displayName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerPresentation) {
            LunaServerPresentation lunaServerPresentation = (LunaServerPresentation)object;
            return this.id == lunaServerPresentation.id;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerPresentation) {
            LunaServerPresentation lunaServerPresentation = (LunaServerPresentation)databaseRecord;
            return this.id == lunaServerPresentation.id && this.userId == lunaServerPresentation.userId && LunaServerPresentation.stringsAreEqual(this.displayName, lunaServerPresentation.displayName) && LunaServerPresentation.stringsAreEqual(this.password, lunaServerPresentation.password) && LunaServerPresentation.stringsAreEqual(this.description, lunaServerPresentation.description) && this.folderId == lunaServerPresentation.folderId && this.isPubliclyViewable == lunaServerPresentation.isPubliclyViewable && this.width == lunaServerPresentation.width && this.height == lunaServerPresentation.height;
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerPresentation.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerPresentation: " + string, n);
    }

    public int compareTo(Object object) {
        return this.displayName.compareTo(((LunaServerPresentation)object).displayName);
    }
}

