/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.mediagroup;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerMediaGroupsNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerMediaGroupsNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Media Groups", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"Name", "User ID", "Description", "Folder ID", "Publicly Viewable"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getMediaGroups()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerMediaGroup lunaServerMediaGroup = (LunaServerMediaGroup)vector.elementAt(i);
            objectArray[i][0] = lunaServerMediaGroup;
            objectArray[i][1] = new Integer(lunaServerMediaGroup.userId);
            objectArray[i][2] = lunaServerMediaGroup.description;
            objectArray[i][3] = new Integer(lunaServerMediaGroup.folderId);
            objectArray[i][4] = new Boolean(lunaServerMediaGroup.isPubliclyViewable);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), null, "Edit Media Group Command", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit Media Group Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editMediaGroup((LunaServerMediaGroup)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editMediaGroup((LunaServerMediaGroup)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerMediaGroupsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerPresentationsNode: " + string, n);
    }
}

