/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.mediagroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class LunaServerMediaGroup
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected int id;
    protected int userId;
    protected LunaServer lunaServer;
    protected String displayName = "";
    protected String password = "";
    protected String description = "";
    protected int folderId = 0;
    protected boolean isPubliclyViewable = false;
    protected String name = null;
    protected LunaServerMediaGroupEditComponent editComponent = null;

    public LunaServerMediaGroup(LunaServer lunaServer, int n, int n2, String string, String string2, String string3, int n3, boolean bl, String string4) {
        this.lunaServer = lunaServer;
        this.id = n;
        this.userId = n2;
        this.displayName = string == null ? "" : string;
        this.password = string2 == null ? "" : string2;
        this.description = string3 == null ? "" : string3;
        this.folderId = n3;
        this.isPubliclyViewable = bl;
        this.name = string4 == null ? "" : string4;
    }

    public LunaServerMediaGroup(int n, LunaServer lunaServer) {
        this.id = n;
        this.lunaServer = lunaServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.displayName;
    }

    public int getIndex() {
        return this.id;
    }

    public int getMediaGroupId() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerMediaGroupEditComponent();
        this.editComponent.getUserIdField().setText(Integer.toString(this.userId));
        return this.editComponent;
    }

    public void save() {
        LunaServerMediaGroup.debugOut("Save...", 3);
        this.requiresCommit = false;
        String string = this.editComponent.getUserIdField().getText();
        if (this.hasChanged(this.userId, Integer.parseInt(string))) {
            this.userId = Integer.parseInt(string);
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerMediaGroup.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Media Group - " + this.displayName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerMediaGroup) {
            LunaServerMediaGroup lunaServerMediaGroup = (LunaServerMediaGroup)object;
            return this.id == lunaServerMediaGroup.id;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerMediaGroup) {
            LunaServerMediaGroup lunaServerMediaGroup = (LunaServerMediaGroup)databaseRecord;
            return this.id == lunaServerMediaGroup.id && this.userId == lunaServerMediaGroup.userId && LunaServerMediaGroup.stringsAreEqual(this.displayName, lunaServerMediaGroup.displayName) && LunaServerMediaGroup.stringsAreEqual(this.password, lunaServerMediaGroup.password) && LunaServerMediaGroup.stringsAreEqual(this.description, lunaServerMediaGroup.description) && this.folderId == lunaServerMediaGroup.folderId && this.isPubliclyViewable == lunaServerMediaGroup.isPubliclyViewable && LunaServerMediaGroup.stringsAreEqual(this.name, lunaServerMediaGroup.name);
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerMediaGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerPresentation: " + string, n);
    }

    public int compareTo(Object object) {
        return this.displayName.compareTo(((LunaServerMediaGroup)object).displayName);
    }
}

